(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1816617,      45968]*)
(*NotebookOutlinePosition[   1817259,      45990]*)
(*  CellTagsIndexPosition[   1817215,      45986]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(Plot3D[
      20 + x*x + y*y + 10*Cos[2*Pi*x] + 10*Cos[2*Pi*y], {x, \(-5\), 
        5}, {y, \(-5\), 5}, PlotPoints\  -> 150, Mesh -> False, 
      ViewPoint -> {1.568, \ \(-1.276\), \ 2.714}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .93108 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0133825 1.01338 -0.00541245 1.01338 [
[.06828 .41457 -12 -7.26981 ]
[.06828 .41457 0 1.73019 ]
[.14114 .32958 -12 -7.38516 ]
[.14114 .32958 0 1.61484 ]
[.21802 .23989 -6 -7.51054 ]
[.21802 .23989 0 1.48946 ]
[.29928 .1451 -6 -7.64731 ]
[.29928 .1451 0 1.35269 ]
[.3853 .04479 -6 -7.7971 ]
[.3853 .04479 0 1.2029 ]
[.50557 .03316 -0.6951 -9 ]
[.50557 .03316 11.3049 0 ]
[.61553 .11574 -0.37795 -9 ]
[.61553 .11574 11.6221 0 ]
[.72048 .19456 -0.03039 -9 ]
[.72048 .19456 5.96961 0 ]
[.82075 .26988 0 -8.8156 ]
[.82075 .26988 6 .1844 ]
[.91664 .34192 0 -8.60738 ]
[.91664 .34192 6 .39262 ]
[.0323 .45899 -6 -7.21192 ]
[.0323 .45899 0 1.78808 ]
[.02356 .49134 -12 -7.17925 ]
[.02356 .49134 0 1.82075 ]
[.01448 .52498 -12 -7.14542 ]
[.01448 .52498 0 1.85458 ]
[.00504 .55996 -12 -7.11034 ]
[.00504 .55996 0 1.88966 ]
[-0.0048 .59638 -12 -7.07397 ]
[-0.0048 .59638 0 1.92603 ]
[ 0 0 0 0 ]
[ 1 .93108 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04411 .46197 m
.44035 0 L
s
.07907 .42121 m
.08446 .42453 L
s
[(-4)] .06828 .41457 1 .61551 Mshowa
.1518 .33641 m
.15713 .33983 L
s
[(-2)] .14114 .32958 1 .64115 Mshowa
.22855 .24693 m
.23382 .25045 L
s
[(0)] .21802 .23989 1 .66901 Mshowa
.30966 .15236 m
.31485 .156 L
s
[(2)] .29928 .1451 1 .6994 Mshowa
.39551 .05227 m
.40062 .05602 L
s
[(4)] .3853 .04479 1 .73269 Mshowa
.125 Mabswid
.09689 .40043 m
.10012 .40244 L
s
.11495 .37937 m
.11817 .3814 L
s
.13325 .35804 m
.13646 .36007 L
s
.1706 .3145 m
.17379 .31656 L
s
.18965 .29228 m
.19283 .29436 L
s
.20897 .26976 m
.21214 .27186 L
s
.24841 .22378 m
.25155 .22591 L
s
.26854 .20031 m
.27168 .20245 L
s
.28896 .17651 m
.29208 .17867 L
s
.33066 .12788 m
.33377 .13007 L
s
.35197 .10304 m
.35506 .10525 L
s
.37358 .07784 m
.37666 .08007 L
s
.06147 .44172 m
.06472 .4437 L
s
.41777 .02633 m
.42082 .02859 L
s
.25 Mabswid
.44035 0 m
.95358 .3852 L
s
.49718 .04265 m
.49298 .0474 L
s
[(-4)] .50557 .03316 -0.88415 1 Mshowa
.60687 .12498 m
.60254 .1296 L
s
[(-2)] .61553 .11574 -0.93701 1 Mshowa
.71157 .20356 m
.70711 .20806 L
s
[(0)] .72048 .19456 -0.98987 1 Mshowa
.8116 .27864 m
.80703 .28303 L
s
[(2)] .82075 .26988 -1 .95902 Mshowa
.90728 .35046 m
.90261 .35473 L
s
[(4)] .91664 .34192 -1 .91275 Mshowa
.125 Mabswid
.52509 .0636 m
.52255 .06643 L
s
.55267 .0843 m
.55011 .08711 L
s
.57993 .10476 m
.57735 .10755 L
s
.6335 .14497 m
.63088 .14772 L
s
.65982 .16472 m
.65718 .16746 L
s
.68584 .18425 m
.68319 .18697 L
s
.737 .22265 m
.73431 .22533 L
s
.76215 .24153 m
.75944 .24419 L
s
.78701 .26019 m
.78429 .26284 L
s
.83592 .2969 m
.83316 .29951 L
s
.85997 .31495 m
.85719 .31754 L
s
.88376 .3328 m
.88097 .33538 L
s
.46893 .02146 m
.46644 .02432 L
s
.93056 .36792 m
.92773 .37047 L
s
.25 Mabswid
.04411 .46197 m
0 .62569 L
s
.04315 .46553 m
.04857 .4688 L
s
[(0)] .0323 .45899 1 .60265 Mshowa
.03445 .49782 m
.03989 .50107 L
s
[(20)] .02356 .49134 1 .59539 Mshowa
.0254 .5314 m
.03086 .53461 L
s
[(40)] .01448 .52498 1 .58787 Mshowa
.01599 .56632 m
.02147 .5695 L
s
[(60)] .00504 .55996 1 .58008 Mshowa
.0062 .60267 m
.0117 .60582 L
s
[(80)] -0.0048 .59638 1 .57199 Mshowa
.125 Mabswid
.04101 .47349 m
.04426 .47544 L
s
.03884 .48152 m
.0421 .48347 L
s
.03666 .48963 m
.03992 .49158 L
s
.03222 .5061 m
.03549 .50804 L
s
.02997 .51445 m
.03324 .51638 L
s
.0277 .52288 m
.03097 .52481 L
s
.02309 .54 m
.02637 .54192 L
s
.02075 .54868 m
.02403 .5506 L
s
.01838 .55746 m
.02167 .55937 L
s
.01358 .57527 m
.01687 .57717 L
s
.01115 .58431 m
.01444 .58621 L
s
.00869 .59344 m
.01198 .59534 L
s
.00369 .612 m
.00699 .61388 L
s
.00115 .62141 m
.00446 .62329 L
s
.25 Mabswid
.04411 .46197 m
0 .62569 L
s
0 .62569 m
.53872 .93108 L
s
.53872 .93108 m
.53504 .75822 L
s
.53504 .75822 m
.04411 .46197 L
s
.44035 0 m
.95358 .3852 L
s
.95358 .3852 m
1 .54562 L
s
1 .54562 m
.43429 .13791 L
s
.43429 .13791 m
.44035 0 L
s
.04411 .46197 m
0 .62569 L
s
0 .62569 m
.43429 .13791 L
s
.43429 .13791 m
.44035 0 L
s
.44035 0 m
.04411 .46197 L
s
.53504 .75822 m
.95358 .3852 L
s
.95358 .3852 m
1 .54562 L
s
1 .54562 m
.53872 .93108 L
s
.53872 .93108 m
.53504 .75822 L
s
0 0 m
1 0 L
1 .93108 L
0 .93108 L
closepath
clip
newpath
.689 .517 .648 r
.53532 .92172 .53862 .92661 .54125 .9213 .53795 .91642 Mtetra
.741 .528 .605 r
.53795 .91642 .54125 .9213 .5438 .91287 .54051 .908 Mtetra
.762 .531 .583 r
.54051 .908 .5438 .91287 .54629 .90222 .54301 .89737 Mtetra
.77 .532 .575 r
.54301 .89737 .54629 .90222 .54873 .89063 .54546 .88581 Mtetra
.767 .532 .579 r
.54546 .88581 .54873 .89063 .55117 .87953 .54791 .87474 Mtetra
.752 .53 .594 r
.54791 .87474 .55117 .87953 .55364 .87023 .55038 .86546 Mtetra
.716 .523 .627 r
.55038 .86546 .55364 .87023 .55618 .8637 .55293 .85894 Mtetra
.626 .5 .689 r
.55293 .85894 .55618 .8637 .55882 .86045 .55556 .85569 Mtetra
.36 .4 .767 r
.55556 .85569 .55882 .86045 .56157 .86044 .5583 .85567 Mtetra
0 .097 .654 r
.5583 .85567 .56157 .86044 .56442 .86309 .56114 .8583 Mtetra
.584 .151 0 r
.56114 .8583 .56442 .86309 .56734 .86736 .56405 .86255 Mtetra
.627 .184 0 r
.56405 .86255 .56734 .86736 .5703 .87194 .56699 .8671 Mtetra
0 0 .543 r
.56699 .8671 .5703 .87194 .57324 .87541 .56992 .87056 Mtetra
.162 .307 .764 r
.56992 .87056 .57324 .87541 .57611 .87656 .57277 .87169 Mtetra
.554 .476 .721 r
.57277 .87169 .57611 .87656 .57886 .87457 .57552 .86969 Mtetra
.69 .516 .647 r
.57552 .86969 .57886 .87457 .58148 .86919 .57814 .86433 Mtetra
.742 .527 .603 r
.57814 .86433 .58148 .86919 .58396 .86082 .58062 .85597 Mtetra
.763 .53 .581 r
.58062 .85597 .58396 .86082 .58633 .85039 .583 .84556 Mtetra
.769 .531 .574 r
.583 .84556 .58633 .85039 .58865 .83917 .58533 .83436 Mtetra
.765 .53 .578 r
.58533 .83436 .58865 .83917 .59098 .82856 .58767 .82378 Mtetra
.748 .528 .597 r
.58767 .82378 .59098 .82856 .59339 .81983 .59008 .81506 Mtetra
.706 .52 .635 r
.59008 .81506 .59339 .81983 .59592 .81388 .59262 .80913 Mtetra
.598 .491 .704 r
.59262 .80913 .59592 .81388 .59862 .81118 .59531 .80642 Mtetra
.292 .372 .773 r
.59531 .80642 .59862 .81118 .60149 .81161 .59817 .80685 Mtetra
0 .07 .631 r
.59817 .80685 .60149 .81161 .60451 .81458 .60118 .80979 Mtetra
0 0 .412 r
.60118 .80979 .60451 .81458 .60763 .81902 .60429 .81422 Mtetra
.592 .153 0 r
.60429 .81422 .60763 .81902 .61079 .82363 .60743 .8188 Mtetra
0 .016 .583 r
.60743 .8188 .61079 .82363 .6139 .82702 .61052 .82217 Mtetra
.197 .326 .77 r
.61052 .82217 .6139 .82702 .61689 .82803 .6135 .82316 Mtetra
.56 .478 .719 r
.6135 .82316 .61689 .82803 .61969 .82589 .6163 .82103 Mtetra
.692 .516 .645 r
.6163 .82103 .61969 .82589 .6223 .82045 .6189 .81559 Mtetra
.742 .526 .601 r
.6189 .81559 .6223 .82045 .62471 .81213 .62132 .80728 Mtetra
.763 .528 .579 r
.62132 .80728 .62471 .81213 .62698 .80189 .6236 .79706 Mtetra
.768 .529 .572 r
.6236 .79706 .62698 .80189 .62919 .79101 .62582 .78621 Mtetra
.763 .528 .578 r
.62582 .78621 .62919 .79101 .63143 .78086 .62806 .77609 Mtetra
.743 .526 .6 r
.62806 .77609 .63143 .78086 .63379 .77266 .63043 .7679 Mtetra
.693 .517 .644 r
.63043 .7679 .63379 .77266 .63634 .76728 .63298 .76252 Mtetra
.566 .481 .719 r
.63298 .76252 .63634 .76728 .63912 .76509 .63576 .76033 Mtetra
.222 .341 .774 r
.63576 .76033 .63912 .76509 .64214 .76595 .63877 .76119 Mtetra
0 .051 .614 r
.63877 .76119 .64214 .76595 .64536 .76923 .64198 .76444 Mtetra
0 0 .429 r
.64198 .76444 .64536 .76923 .64871 .77383 .64531 .76902 Mtetra
0 0 .431 r
.64531 .76902 .64871 .77383 .65209 .77847 .64867 .77363 Mtetra
0 .056 .619 r
.64867 .77363 .65209 .77847 .65538 .78178 .65195 .77692 Mtetra
.228 .343 .774 r
.65195 .77692 .65538 .78178 .6585 .78265 .65505 .77778 Mtetra
.566 .481 .717 r
.65505 .77778 .6585 .78265 .66136 .78038 .65791 .7755 Mtetra
.693 .515 .643 r
.65791 .7755 .66136 .78038 .66395 .77486 .6605 .76999 Mtetra
.743 .524 .598 r
.6605 .76999 .66395 .77486 .6663 .76657 .66285 .76172 Mtetra
.763 .527 .576 r
.66285 .76172 .6663 .76657 .66847 .7565 .66503 .75168 Mtetra
.768 .527 .57 r
.66503 .75168 .66847 .7565 .67058 .74594 .66715 .74114 Mtetra
.76 .527 .579 r
.66715 .74114 .67058 .74594 .67274 .73623 .66932 .73145 Mtetra
.737 .524 .604 r
.66932 .73145 .67274 .73623 .67508 .72854 .67167 .72377 Mtetra
.678 .513 .654 r
.67167 .72377 .67508 .72854 .67768 .72368 .67426 .71892 Mtetra
.528 .469 .734 r
.67426 .71892 .67768 .72368 .68058 .72199 .67716 .71723 Mtetra
.154 .311 .771 r
.67716 .71723 .68058 .72199 .68379 .72328 .68035 .71849 Mtetra
0 .039 .602 r
.68035 .71849 .68379 .72328 .68724 .72685 .68379 .72204 Mtetra
0 0 .449 r
.68379 .72204 .68724 .72685 .69084 .73162 .68737 .72679 Mtetra
0 0 .47 r
.68737 .72679 .69084 .73162 .69445 .73628 .69097 .73142 Mtetra
0 .094 .65 r
.69097 .73142 .69445 .73628 .69795 .73951 .69444 .73464 Mtetra
.255 .358 .777 r
.69444 .73464 .69795 .73951 .7012 .74024 .69768 .73535 Mtetra
.571 .482 .715 r
.69768 .73535 .7012 .74024 .70413 .73783 .70061 .73294 Mtetra
.694 .515 .64 r
.70061 .73294 .70413 .73783 .70671 .73223 .70319 .72735 Mtetra
.743 .523 .596 r
.70319 .72735 .70671 .73223 .70899 .72397 .70547 .7191 Mtetra
.763 .525 .574 r
.70547 .7191 .70899 .72397 .71106 .71406 .70756 .70922 Mtetra
.767 .525 .569 r
.70756 .70922 .71106 .71406 .71308 .70379 .70959 .69897 Mtetra
.757 .524 .58 r
.70959 .69897 .71308 .70379 .71519 .69449 .71171 .68969 Mtetra
.729 .521 .61 r
.71171 .68969 .71519 .69449 .71753 .68729 .71405 .6825 Mtetra
.661 .508 .666 r
.71405 .6825 .71753 .68729 .72021 .68294 .71672 .67815 Mtetra
.486 .455 .748 r
.71672 .67815 .72021 .68294 .72327 .68173 .71977 .67694 Mtetra
.09 .281 .764 r
.71977 .67694 .72327 .68173 .72669 .68342 .72318 .67861 Mtetra
0 .034 .597 r
.72318 .67861 .72669 .68342 .73041 .68728 .72688 .68245 Mtetra
0 0 .473 r
.72688 .68245 .73041 .68728 .73429 .69221 .73074 .68736 Mtetra
0 0 .507 r
.73074 .68736 .73429 .69221 .73817 .69691 .7346 .69202 Mtetra
0 .129 .678 r
.7346 .69202 .73817 .69691 .74188 .70007 .7383 .69516 Mtetra
.28 .371 .779 r
.7383 .69516 .74188 .70007 .74528 .70066 .74168 .69574 Mtetra
.576 .484 .713 r
.74168 .69574 .74528 .70066 .74827 .69811 .74467 .69319 Mtetra
.695 .514 .638 r
.74467 .69319 .74827 .69811 .75084 .69241 .74725 .6875 Mtetra
.743 .521 .593 r
.74725 .6875 .75084 .69241 .75306 .68416 .74947 .67927 Mtetra
.762 .523 .571 r
.74947 .67927 .75306 .68416 .75505 .67439 .75147 .66952 Mtetra
.765 .523 .568 r
.75147 .66952 .75505 .67439 .75699 .6644 .75342 .65955 Mtetra
.754 .522 .581 r
.75342 .65955 .75699 .6644 .75906 .65549 .7555 .65066 Mtetra
.721 .518 .616 r
.7555 .65066 .75906 .65549 .76143 .64875 .75787 .64393 Mtetra
.64 .502 .679 r
.75787 .64393 .76143 .64875 .76422 .64489 .76065 .64008 Mtetra
.439 .439 .762 r
.76065 .64008 .76422 .64489 .76747 .64415 .76389 .63933 Mtetra
.033 .255 .755 r
.76389 .63933 .76747 .64415 .77115 .64624 .76756 .6414 Mtetra
0 .035 .596 r
.76756 .6414 .77115 .64624 .77517 .6504 .77156 .64553 Mtetra
0 0 .498 r
.77156 .64553 .77517 .6504 .77937 .65549 .77574 .65059 Mtetra
0 0 .544 r
.77574 .65059 .77937 .65549 .78354 .66022 .77989 .6553 Mtetra
0 .161 .701 r
.77989 .6553 .78354 .66022 .78749 .66331 .78382 .65836 Mtetra
.301 .382 .78 r
.78382 .65836 .78749 .66331 .79104 .66377 .78736 .65881 Mtetra
.58 .485 .711 r
.78736 .65881 .79104 .66377 .79411 .66107 .79042 .65611 Mtetra
.696 .513 .636 r
.79042 .65611 .79411 .66107 .79668 .65528 .79299 .65032 Mtetra
.743 .519 .59 r
.79299 .65032 .79668 .65528 .79883 .64702 .79515 .64209 Mtetra
.762 .521 .569 r
.79515 .64209 .79883 .64702 .80074 .63738 .79707 .63247 Mtetra
.763 .521 .567 r
.79707 .63247 .80074 .63738 .80262 .62764 .79896 .62275 Mtetra
.749 .52 .584 r
.79896 .62275 .80262 .62764 .80467 .6191 .80102 .61423 Mtetra
.71 .516 .624 r
.80102 .61423 .80467 .6191 .8071 .61281 .80345 .60794 Mtetra
.616 .496 .693 r
.80345 .60794 .8071 .61281 .81003 .60943 .80637 .60457 Mtetra
.389 .421 .772 r
.80637 .60457 .81003 .60943 .81351 .60916 .80984 .60428 Mtetra
0 .233 .745 r
.80984 .60428 .81351 .60916 .81749 .61164 .81381 .60674 Mtetra
0 .04 .6 r
.81381 .60674 .81749 .61164 .82186 .61609 .81816 .61116 Mtetra
0 0 .525 r
.81816 .61116 .82186 .61609 .82641 .62135 .82269 .6164 Mtetra
0 .019 .578 r
.82269 .6164 .82641 .62135 .83091 .62612 .82716 .62114 Mtetra
0 .191 .721 r
.82716 .62114 .83091 .62612 .83512 .62914 .83135 .62414 Mtetra
.321 .392 .78 r
.83135 .62414 .83512 .62914 .83885 .62946 .83507 .62445 Mtetra
.584 .486 .709 r
.83507 .62445 .83885 .62946 .84199 .62661 .83821 .62159 Mtetra
.697 .512 .634 r
.83821 .62159 .84199 .62661 .84456 .62071 .84077 .6157 Mtetra
.743 .517 .587 r
.84077 .6157 .84456 .62071 .84666 .61245 .84288 .60745 Mtetra
.761 .519 .566 r
.84288 .60745 .84666 .61245 .84849 .60291 .84472 .59794 Mtetra
.84472 .59794 .84849 .60291 .85031 .59341 .84655 .58847 Mtetra
.744 .518 .587 r
.84655 .58847 .85031 .59341 .85237 .58522 .84861 .58029 Mtetra
.698 .512 .633 r
.84861 .58029 .85237 .58522 .85488 .57937 .85113 .57444 Mtetra
.588 .488 .708 r
.85113 .57444 .85488 .57937 .858 .57646 .85424 .57154 Mtetra
.337 .401 .781 r
.85424 .57154 .858 .57646 .86176 .57664 .85799 .57171 Mtetra
0 .215 .736 r
.85799 .57171 .86176 .57664 .8661 .57952 .86231 .57456 Mtetra
0 .05 .608 r
.86231 .57456 .8661 .57952 .87087 .58427 .86705 .57928 Mtetra
0 0 .553 r
.86705 .57928 .87087 .58427 .87582 .58971 .87198 .58469 Mtetra
0 .053 .61 r
.87198 .58469 .87582 .58971 .88068 .59452 .87682 .58948 Mtetra
0 .218 .738 r
.87682 .58948 .88068 .59452 .88517 .59748 .88129 .59241 Mtetra
.338 .4 .78 r
.88129 .59241 .88517 .59748 .88909 .59767 .8852 .59258 Mtetra
.587 .486 .707 r
.8852 .59258 .88909 .59767 .89232 .59466 .88842 .58957 Mtetra
.697 .51 .631 r
.88842 .58957 .89232 .59466 .89488 .58865 .89099 .58357 Mtetra
.743 .515 .584 r
.89099 .58357 .89488 .58865 .89693 .58035 .89304 .57529 Mtetra
.76 .516 .564 r
.89304 .57529 .89693 .58035 .89869 .57091 .89481 .56587 Mtetra
.759 .516 .566 r
.89481 .56587 .89869 .57091 .90047 .56163 .8966 .55661 Mtetra
.738 .515 .591 r
.8966 .55661 .90047 .56163 .90256 .55378 .89869 .54878 Mtetra
.684 .508 .643 r
.89869 .54878 .90256 .55378 .9052 .54835 .90133 .54336 Mtetra
.556 .479 .723 r
.90133 .54336 .9052 .54835 .90855 .54591 .90467 .54091 Mtetra
.285 .381 .786 r
.90467 .54091 .90855 .54591 .91264 .54655 .90875 .54154 Mtetra
0 .203 .73 r
.90875 .54154 .91264 .54655 .91739 .54983 .91349 .5448 Mtetra
0 .063 .619 r
.91349 .5448 .91739 .54983 .92262 .55489 .91868 .54982 Mtetra
0 .024 .58 r
.91868 .54982 .92262 .55489 .92802 .56051 .92406 .55541 Mtetra
0 .085 .64 r
.92406 .55541 .92802 .56051 .93329 .56538 .9293 .56025 Mtetra
0 .242 .751 r
.9293 .56025 .93329 .56538 .9381 .56828 .93409 .56312 Mtetra
.353 .408 .779 r
.93409 .56312 .9381 .56828 .94222 .56833 .9382 .56316 Mtetra
.589 .486 .705 r
.9382 .56316 .94222 .56833 .94555 .56516 .94152 .55999 Mtetra
.697 .508 .629 r
.94152 .55999 .94555 .56516 .94812 .55902 .94409 .55386 Mtetra
.743 .513 .581 r
.94409 .55386 .94812 .55902 .9501 .55068 .94608 .54553 Mtetra
.759 .513 .562 r
.94608 .54553 .9501 .55068 .9518 .54131 .94779 .53619 Mtetra
.755 .513 .566 r
.94779 .53619 .9518 .54131 .95356 .53224 .94956 .52714 Mtetra
.73 .512 .596 r
.94956 .52714 .95356 .53224 .9557 .52472 .95171 .51963 Mtetra
.667 .504 .655 r
.95171 .51963 .9557 .52472 .95851 .51971 .95452 .51463 Mtetra
.521 .468 .738 r
.95452 .51463 .95851 .51971 .96215 .51774 .95814 .51265 Mtetra
.236 .361 .788 r
.95814 .51265 .96215 .51774 .96664 .51884 .96262 .51373 Mtetra
0 .195 .725 r
.96262 .51373 .96664 .51884 .97187 .52254 .96783 .5174 Mtetra
0 .078 .632 r
.96783 .5174 .97187 .52254 .97762 .52791 .97355 .52274 Mtetra
0 .052 .607 r
.97355 .52274 .97762 .52791 .98354 .53373 .97944 .52853 Mtetra
0 .117 .666 r
.97944 .52853 .98354 .53373 .98926 .53867 .98513 .53344 Mtetra
.029 .263 .763 r
.98513 .53344 .98926 .53867 .99443 .54152 .99028 .53626 Mtetra
.366 .414 .778 r
.99028 .53626 .99443 .54152 .99879 .54142 .99462 .53615 Mtetra
.618 .433 .61 r
.53198 .91371 .53532 .92172 .53795 .91642 .5346 .90842 Mtetra
.678 .462 .585 r
.5346 .90842 .53795 .91642 .54051 .908 .53716 .90004 Mtetra
.706 .475 .571 r
.53716 .90004 .54051 .908 .54301 .89737 .53966 .88946 Mtetra
.716 .479 .565 r
.53966 .88946 .54301 .89737 .54546 .88581 .54212 .87796 Mtetra
.712 .477 .567 r
.54212 .87796 .54546 .88581 .54791 .87474 .54457 .86693 Mtetra
.693 .469 .578 r
.54457 .86693 .54791 .87474 .55038 .86546 .54705 .85769 Mtetra
.649 .448 .599 r
.54705 .85769 .55038 .86546 .55293 .85894 .54959 .85119 Mtetra
.556 .404 .63 r
.54959 .85119 .55293 .85894 .55556 .85569 .55222 .84795 Mtetra
.365 .306 .658 r
.55222 .84795 .55556 .85569 .5583 .85567 .55495 .84792 Mtetra
.049 .132 .63 r
.55495 .84792 .5583 .85567 .56114 .8583 .55777 .85052 Mtetra
0 0 .545 r
.55777 .85052 .56114 .8583 .56405 .86255 .56066 .85473 Mtetra
0 0 .524 r
.56066 .85473 .56405 .86255 .56699 .8671 .56358 .85924 Mtetra
0 .06 .599 r
.56358 .85924 .56699 .8671 .56992 .87056 .56649 .86265 Mtetra
.255 .246 .657 r
.56649 .86265 .56992 .87056 .57277 .87169 .56933 .86377 Mtetra
.496 .373 .642 r
.56933 .86377 .57277 .87169 .57552 .86969 .57207 .86176 Mtetra
.619 .433 .608 r
.57207 .86176 .57552 .86969 .57814 .86433 .57468 .85641 Mtetra
.678 .46 .583 r
.57468 .85641 .57814 .86433 .58062 .85597 .57717 .84809 Mtetra
.705 .472 .568 r
.57717 .84809 .58062 .85597 .583 .84556 .57955 .83773 Mtetra
.714 .476 .563 r
.57955 .83773 .583 .84556 .58533 .83436 .58189 .82659 Mtetra
.708 .473 .567 r
.58189 .82659 .58533 .83436 .58767 .82378 .58424 .81605 Mtetra
.686 .464 .579 r
.58424 .81605 .58767 .82378 .59008 .81506 .58665 .80737 Mtetra
.636 .441 .602 r
.58665 .80737 .59008 .81506 .59262 .80913 .58918 .80146 Mtetra
.532 .392 .636 r
.58918 .80146 .59262 .80913 .59531 .80642 .59187 .79875 Mtetra
.326 .288 .662 r
.59187 .79875 .59531 .80642 .59817 .80685 .59471 .79916 Mtetra
.013 .116 .628 r
.59471 .79916 .59817 .80685 .60118 .80979 .5977 .80207 Mtetra
0 0 .551 r
.5977 .80207 .60118 .80979 .60429 .81422 .60079 .80645 Mtetra
0 0 .542 r
.60079 .80645 .60429 .81422 .60743 .8188 .60391 .81099 Mtetra
0 .085 .614 r
.60391 .81099 .60743 .8188 .61052 .82217 .60698 .81432 Mtetra
.272 .259 .661 r
.60698 .81432 .61052 .82217 .6135 .82316 .60994 .81529 Mtetra
.501 .376 .642 r
.60994 .81529 .6135 .82316 .6163 .82103 .61274 .81316 Mtetra
.619 .432 .607 r
.61274 .81316 .6163 .82103 .6189 .81559 .61533 .80774 Mtetra
.677 .458 .581 r
.61533 .80774 .6189 .81559 .62132 .80728 .61775 .79947 Mtetra
.703 .469 .566 r
.61775 .79947 .62132 .80728 .6236 .79706 .62004 .78929 Mtetra
.711 .472 .561 r
.62004 .78929 .6236 .79706 .62582 .78621 .62226 .77849 Mtetra
.704 .469 .566 r
.62226 .77849 .62582 .78621 .62806 .77609 .62452 .76841 Mtetra
.678 .458 .58 r
.62452 .76841 .62806 .77609 .63043 .7679 .62688 .76026 Mtetra
.621 .434 .607 r
.62688 .76026 .63043 .7679 .63298 .76252 .62943 .7549 Mtetra
.506 .38 .643 r
.62943 .7549 .63298 .76252 .63576 .76033 .6322 .75271 Mtetra
.286 .269 .665 r
.6322 .75271 .63576 .76033 .63877 .76119 .6352 .75354 Mtetra
0 .105 .626 r
.6352 .75354 .63877 .76119 .64198 .76444 .63838 .75675 Mtetra
0 0 .559 r
.63838 .75675 .64198 .76444 .64531 .76902 .64169 .7613 Mtetra
0 0 .56 r
.64169 .7613 .64531 .76902 .64867 .77363 .64502 .76586 Mtetra
0 .108 .628 r
.64502 .76586 .64867 .77363 .65195 .77692 .64828 .76911 Mtetra
.289 .27 .665 r
.64828 .76911 .65195 .77692 .65505 .77778 .65137 .76995 Mtetra
.506 .379 .641 r
.65137 .76995 .65505 .77778 .65791 .7755 .65422 .76767 Mtetra
.62 .431 .605 r
.65422 .76767 .65791 .7755 .6605 .76999 .65681 .76218 Mtetra
.676 .455 .578 r
.65681 .76218 .6605 .76999 .66285 .76172 .65916 .75394 Mtetra
.702 .466 .564 r
.65916 .75394 .66285 .76172 .66503 .75168 .66135 .74394 Mtetra
.708 .468 .559 r
.66135 .74394 .66503 .75168 .66715 .74114 .66347 .73346 Mtetra
.699 .465 .565 r
.66347 .73346 .66715 .74114 .66932 .73145 .66565 .72381 Mtetra
.669 .453 .582 r
.66565 .72381 .66932 .73145 .67167 .72377 .668 .71616 Mtetra
.605 .425 .612 r
.668 .71616 .67167 .72377 .67426 .71892 .67059 .71133 Mtetra
.478 .367 .65 r
.67059 .71133 .67426 .71892 .67716 .71723 .67348 .70962 Mtetra
.247 .252 .668 r
.67348 .70962 .67716 .71723 .68035 .71849 .67665 .71087 Mtetra
0 .097 .626 r
.67665 .71087 .68035 .71849 .68379 .72204 .68006 .71438 Mtetra
0 0 .569 r
.68006 .71438 .68379 .72204 .68737 .72679 .68362 .71908 Mtetra
0 .01 .578 r
.68362 .71908 .68737 .72679 .69097 .73142 .68719 .72367 Mtetra
.018 .13 .64 r
.68719 .72367 .69097 .73142 .69444 .73464 .69065 .72685 Mtetra
.304 .281 .668 r
.69065 .72685 .69444 .73464 .69768 .73535 .69387 .72754 Mtetra
.51 .381 .641 r
.69387 .72754 .69768 .73535 .70061 .73294 .69678 .72513 Mtetra
.62 .43 .603 r
.69678 .72513 .70061 .73294 .70319 .72735 .69936 .71955 Mtetra
.675 .453 .576 r
.69936 .71955 .70319 .72735 .70547 .7191 .70165 .71134 Mtetra
.7 .462 .561 r
.70165 .71134 .70547 .7191 .70756 .70922 .70374 .7015 Mtetra
.705 .464 .558 r
.70374 .7015 .70756 .70922 .70959 .69897 .70578 .6913 Mtetra
.693 .46 .565 r
.70578 .6913 .70959 .69897 .71171 .68969 .7079 .68206 Mtetra
.659 .446 .585 r
.7079 .68206 .71171 .68969 .71405 .6825 .71025 .6749 Mtetra
.588 .417 .617 r
.71025 .6749 .71405 .6825 .71672 .67815 .71291 .67057 Mtetra
.448 .354 .656 r
.71291 .67057 .71672 .67815 .71977 .67694 .71595 .66934 Mtetra
.209 .236 .67 r
.71595 .66934 .71977 .67694 .72318 .67861 .71934 .67099 Mtetra
0 .093 .627 r
.71934 .67099 .72318 .67861 .72688 .68245 .72302 .67478 Mtetra
0 .011 .58 r
.72302 .67478 .72688 .68245 .73074 .68736 .72685 .67964 Mtetra
0 .034 .595 r
.72685 .67964 .73074 .68736 .7346 .69202 .73068 .68426 Mtetra
.047 .15 .651 r
.73068 .68426 .7346 .69202 .7383 .69516 .73435 .68736 Mtetra
.318 .29 .67 r
.73435 .68736 .7383 .69516 .74168 .69574 .73772 .68792 Mtetra
.514 .383 .64 r
.73772 .68792 .74168 .69574 .74467 .69319 .7407 .68537 Mtetra
.62 .429 .601 r
.7407 .68537 .74467 .69319 .74725 .6875 .74327 .6797 Mtetra
.674 .45 .573 r
.74327 .6797 .74725 .6875 .74947 .67927 .7455 .6715 Mtetra
.697 .459 .559 r
.7455 .6715 .74947 .67927 .75147 .66952 .7475 .6618 Mtetra
.701 .46 .556 r
.7475 .6618 .75147 .66952 .75342 .65955 .74946 .65188 Mtetra
.686 .455 .565 r
.74946 .65188 .75342 .65955 .7555 .65066 .75155 .64302 Mtetra
.648 .44 .588 r
.75155 .64302 .7555 .65066 .75787 .64393 .75392 .63632 Mtetra
.568 .408 .624 r
.75392 .63632 .75787 .64393 .76065 .64008 .75669 .63248 Mtetra
.416 .34 .663 r
.75669 .63248 .76065 .64008 .76389 .63933 .75992 .63171 Mtetra
.175 .223 .672 r
.75992 .63171 .76389 .63933 .76756 .6414 .76356 .63375 Mtetra
0 .092 .63 r
.76356 .63375 .76756 .6414 .77156 .64553 .76754 .63784 Mtetra
0 .026 .592 r
.76754 .63784 .77156 .64553 .77574 .65059 .77168 .64286 Mtetra
0 .057 .611 r
.77168 .64286 .77574 .65059 .77989 .6553 .77581 .64751 Mtetra
.073 .169 .66 r
.77581 .64751 .77989 .6553 .78382 .65836 .77971 .65054 Mtetra
.33 .299 .672 r
.77971 .65054 .78382 .65836 .78736 .65881 .78324 .65096 Mtetra
.517 .384 .639 r
.78324 .65096 .78736 .65881 .79042 .65611 .78629 .64826 Mtetra
.62 .427 .599 r
.78629 .64826 .79042 .65611 .79299 .65032 .78885 .6425 Mtetra
.672 .447 .57 r
.78885 .6425 .79299 .65032 .79515 .64209 .79102 .6343 Mtetra
.694 .455 .556 r
.79102 .6343 .79515 .64209 .79707 .63247 .79294 .62472 Mtetra
.697 .455 .554 r
.79294 .62472 .79707 .63247 .79896 .62275 .79483 .61505 Mtetra
.679 .449 .566 r
.79483 .61505 .79896 .62275 .80102 .61423 .7969 .60656 Mtetra
.635 .433 .592 r
.7969 .60656 .80102 .61423 .80345 .60794 .79933 .60031 Mtetra
.547 .398 .631 r
.79933 .60031 .80345 .60794 .80637 .60457 .80225 .59694 Mtetra
.384 .327 .67 r
.80225 .59694 .80637 .60457 .80984 .60428 .8057 .59663 Mtetra
.145 .211 .674 r
.8057 .59663 .80984 .60428 .81381 .60674 .80964 .59906 Mtetra
0 .095 .634 r
.80964 .59906 .81381 .60674 .81816 .61116 .81396 .60343 Mtetra
0 .044 .605 r
.81396 .60343 .81816 .61116 .82269 .6164 .81846 .60861 Mtetra
0 .08 .626 r
.81846 .60861 .82269 .6164 .82716 .62114 .8229 .6133 Mtetra
.098 .187 .669 r
.8229 .6133 .82716 .62114 .83135 .62414 .82706 .61627 Mtetra
.342 .306 .673 r
.82706 .61627 .83135 .62414 .83507 .62445 .83076 .61655 Mtetra
.519 .385 .637 r
.83076 .61655 .83507 .62445 .83821 .62159 .83389 .6137 Mtetra
.62 .425 .596 r
.83389 .6137 .83821 .62159 .84077 .6157 .83645 .60783 Mtetra
.67 .443 .568 r
.83645 .60783 .84077 .6157 .84288 .60745 .83856 .59962 Mtetra
.691 .45 .553 r
.83856 .59962 .84288 .60745 .84472 .59794 .84041 .59015 Mtetra
.692 .45 .553 r
.84041 .59015 .84472 .59794 .84655 .58847 .84225 .58072 Mtetra
.671 .443 .567 r
.84225 .58072 .84655 .58847 .84861 .58029 .84432 .57258 Mtetra
.621 .426 .596 r
.84432 .57258 .84861 .58029 .85113 .57444 .84683 .56675 Mtetra
.524 .388 .638 r
.84683 .56675 .85113 .57444 .85424 .57154 .84993 .56385 Mtetra
.352 .314 .676 r
.84993 .56385 .85424 .57154 .85799 .57171 .85366 .564 Mtetra
.119 .202 .676 r
.85366 .564 .85799 .57171 .86231 .57456 .85795 .56682 Mtetra
0 .1 .64 r
.85795 .56682 .86231 .57456 .86705 .57928 .86266 .57148 Mtetra
0 .062 .618 r
.86266 .57148 .86705 .57928 .87198 .58469 .86755 .57683 Mtetra
0 .102 .64 r
.86755 .57683 .87198 .58469 .87682 .58948 .87235 .58157 Mtetra
.122 .203 .676 r
.87235 .58157 .87682 .58948 .88129 .59241 .8768 .58446 Mtetra
.352 .313 .674 r
.8768 .58446 .88129 .59241 .8852 .59258 .88069 .58461 Mtetra
.522 .385 .636 r
.88069 .58461 .8852 .59258 .88842 .58957 .8839 .58161 Mtetra
.619 .422 .594 r
.8839 .58161 .88842 .58957 .89099 .58357 .88646 .57562 Mtetra
.668 .439 .565 r
.88646 .57562 .89099 .58357 .89304 .57529 .88851 .56738 Mtetra
.688 .446 .551 r
.88851 .56738 .89304 .57529 .89481 .56587 .89029 .558 Mtetra
.686 .445 .552 r
.89029 .558 .89481 .56587 .8966 .55661 .89209 .54879 Mtetra
.662 .437 .569 r
.89209 .54879 .8966 .55661 .89869 .54878 .89419 .54099 Mtetra
.606 .418 .601 r
.89419 .54099 .89869 .54878 .90133 .54336 .89683 .53559 Mtetra
.499 .377 .645 r
.89683 .53559 .90133 .54336 .90467 .54091 .90016 .53314 Mtetra
.32 .301 .681 r
.90016 .53314 .90467 .54091 .90875 .54154 .90421 .53374 Mtetra
.097 .196 .679 r
.90421 .53374 .90875 .54154 .91349 .5448 .90891 .53696 Mtetra
0 .108 .646 r
.90891 .53696 .91349 .5448 .91868 .54982 .91407 .54193 Mtetra
0 .08 .632 r
.91407 .54193 .91868 .54982 .92406 .55541 .91941 .54746 Mtetra
0 .123 .653 r
.91941 .54746 .92406 .55541 .9293 .56025 .92461 .55224 Mtetra
.144 .218 .683 r
.92461 .55224 .9293 .56025 .93409 .56312 .92937 .55508 Mtetra
.361 .318 .675 r
.92937 .55508 .93409 .56312 .9382 .56316 .93346 .55509 Mtetra
.523 .385 .634 r
.93346 .55509 .9382 .56316 .94152 .55999 .93677 .55192 Mtetra
.617 .419 .591 r
.93677 .55192 .94152 .55999 .94409 .55386 .93934 .54581 Mtetra
.665 .435 .561 r
.93934 .54581 .94409 .55386 .94608 .54553 .94134 .53753 Mtetra
.684 .441 .548 r
.94134 .53753 .94608 .54553 .94779 .53619 .94305 .52823 Mtetra
.68 .439 .551 r
.94305 .52823 .94779 .53619 .94956 .52714 .94483 .51922 Mtetra
.651 .431 .571 r
.94483 .51922 .94956 .52714 .95171 .51963 .94698 .51175 Mtetra
.589 .41 .607 r
.94698 .51175 .95171 .51963 .95452 .51463 .94978 .50675 Mtetra
.473 .367 .653 r
.94978 .50675 .95452 .51463 .95814 .51265 .95339 .50477 Mtetra
.29 .29 .687 r
.95339 .50477 .95814 .51265 .96262 .51373 .95784 .50583 Mtetra
.08 .192 .682 r
.95784 .50583 .96262 .51373 .96783 .5174 .96302 .50945 Mtetra
0 .118 .654 r
.96302 .50945 .96783 .5174 .97355 .52274 .96869 .51473 Mtetra
0 .099 .645 r
.96869 .51473 .97355 .52274 .97944 .52853 .97454 .52046 Mtetra
0 .143 .665 r
.97454 .52046 .97944 .52853 .98513 .53344 .98019 .5253 Mtetra
.164 .232 .688 r
.98019 .5253 .98513 .53344 .99028 .53626 .9853 .52808 Mtetra
.37 .323 .675 r
.9853 .52808 .99028 .53626 .99462 .53615 .98962 .52796 Mtetra
.581 .391 .589 r
.5286 .90348 .53198 .91371 .5346 .90842 .53122 .89822 Mtetra
.643 .425 .573 r
.53122 .89822 .5346 .90842 .53716 .90004 .53378 .88988 Mtetra
.673 .442 .562 r
.53378 .88988 .53716 .90004 .53966 .88946 .53628 .87937 Mtetra
.684 .448 .558 r
.53628 .87937 .53966 .88946 .54212 .87796 .53874 .86794 Mtetra
.68 .445 .56 r
.53874 .86794 .54212 .87796 .54457 .86693 .5412 .85698 Mtetra
.659 .434 .567 r
.5412 .85698 .54457 .86693 .54705 .85769 .54368 .84779 Mtetra
.612 .409 .582 r
.54368 .84779 .54705 .85769 .54959 .85119 .54622 .84133 Mtetra
.523 .36 .601 r
.54622 .84133 .54959 .85119 .55222 .84795 .54884 .8381 Mtetra
.364 .27 .614 r
.54884 .8381 .55222 .84795 .55495 .84792 .55155 .83804 Mtetra
.135 .138 .596 r
.55155 .83804 .55495 .84792 .55777 .85052 .55435 .8406 Mtetra
0 .021 .552 r
.55435 .8406 .55777 .85052 .56066 .85473 .55722 .84476 Mtetra
0 0 .541 r
.55722 .84476 .56066 .85473 .56358 .85924 .56011 .84921 Mtetra
.048 .086 .58 r
.56011 .84921 .56358 .85924 .56649 .86265 .563 .85258 Mtetra
.281 .222 .612 r
.563 .85258 .56649 .86265 .56933 .86377 .56582 .85367 Mtetra
.47 .329 .607 r
.56582 .85367 .56933 .86377 .57207 .86176 .56855 .85166 Mtetra
.582 .391 .588 r
.56855 .85166 .57207 .86176 .57468 .85641 .57115 .84633 Mtetra
.642 .423 .57 r
.57115 .84633 .57468 .85641 .57717 .84809 .57364 .83806 Mtetra
.671 .439 .56 r
.57364 .83806 .57717 .84809 .57955 .83773 .57603 .82776 Mtetra
.681 .444 .556 r
.57603 .82776 .57955 .83773 .58189 .82659 .57837 .81669 Mtetra
.675 .441 .558 r
.57837 .81669 .58189 .82659 .58424 .81605 .58072 .80622 Mtetra
.651 .428 .568 r
.58072 .80622 .58424 .81605 .58665 .80737 .58313 .79759 Mtetra
.599 .401 .584 r
.58313 .79759 .58665 .80737 .58918 .80146 .58566 .79171 Mtetra
.502 .348 .605 r
.58566 .79171 .58918 .80146 .59187 .79875 .58834 .789 Mtetra
.334 .256 .617 r
.58834 .789 .59187 .79875 .59471 .79916 .59116 .78939 Mtetra
.108 .127 .597 r
.59116 .78939 .59471 .79916 .5977 .80207 .59413 .79226 Mtetra
0 .024 .557 r
.59413 .79226 .5977 .80207 .60079 .80645 .59719 .79658 Mtetra
0 .015 .553 r
.59719 .79658 .60079 .80645 .60391 .81099 .60029 .80106 Mtetra
.069 .104 .59 r
.60029 .80106 .60391 .81099 .60698 .81432 .60334 .80435 Mtetra
.294 .233 .616 r
.60334 .80435 .60698 .81432 .60994 .81529 .60628 .80529 Mtetra
.475 .332 .607 r
.60628 .80529 .60994 .81529 .61274 .81316 .60906 .80315 Mtetra
.583 .39 .586 r
.60906 .80315 .61274 .81316 .61533 .80774 .61165 .79776 Mtetra
.641 .421 .568 r
.61165 .79776 .61533 .80774 .61775 .79947 .61407 .78953 Mtetra
.669 .435 .557 r
.61407 .78953 .61775 .79947 .62004 .78929 .61636 .77942 Mtetra
.678 .439 .554 r
.61636 .77942 .62004 .78929 .62226 .77849 .61859 .76869 Mtetra
.669 .435 .557 r
.61859 .76869 .62226 .77849 .62452 .76841 .62085 .75867 Mtetra
.642 .421 .568 r
.62085 .75867 .62452 .76841 .62688 .76026 .62321 .75057 Mtetra
.585 .392 .587 r
.62321 .75057 .62688 .76026 .62943 .7549 .62576 .74523 Mtetra
.479 .336 .609 r
.62576 .74523 .62943 .7549 .6322 .75271 .62851 .74304 Mtetra
.304 .241 .62 r
.62851 .74304 .6322 .75271 .6352 .75354 .63149 .74384 Mtetra
.085 .118 .599 r
.63149 .74384 .6352 .75354 .63838 .75675 .63465 .74701 Mtetra
0 .03 .564 r
.63465 .74701 .63838 .75675 .64169 .7613 .63793 .7515 Mtetra
0 .031 .565 r
.63793 .7515 .64169 .7613 .64502 .76586 .64124 .756 Mtetra
.089 .121 .599 r
.64124 .756 .64502 .76586 .64828 .76911 .64447 .75921 Mtetra
.306 .242 .619 r
.64447 .75921 .64828 .76911 .65137 .76995 .64754 .76001 Mtetra
.479 .335 .607 r
.64754 .76001 .65137 .76995 .65422 .76767 .65038 .75774 Mtetra
.583 .389 .585 r
.65038 .75774 .65422 .76767 .65681 .76218 .65296 .75227 Mtetra
.639 .418 .566 r
.65296 .75227 .65681 .76218 .65916 .75394 .65531 .74408 Mtetra
.666 .431 .555 r
.65531 .74408 .65916 .75394 .66135 .74394 .6575 .73414 Mtetra
.674 .435 .552 r
.6575 .73414 .66135 .74394 .66347 .73346 .65963 .72372 Mtetra
.663 .43 .556 r
.65963 .72372 .66347 .73346 .66565 .72381 .66182 .71414 Mtetra
.632 .414 .569 r
.66182 .71414 .66565 .72381 .668 .71616 .66416 .70653 Mtetra
.569 .383 .59 r
.66416 .70653 .668 .71616 .67059 .71133 .66675 .70172 Mtetra
.455 .324 .613 r
.66675 .70172 .67059 .71133 .67348 .70962 .66962 .70001 Mtetra
.275 .228 .623 r
.66962 .70001 .67348 .70962 .67665 .71087 .67277 .70122 Mtetra
.066 .113 .601 r
.67277 .70122 .67665 .71087 .68006 .71438 .67616 .70468 Mtetra
0 .038 .572 r
.67616 .70468 .68006 .71438 .68362 .71908 .67968 .70932 Mtetra
0 .048 .577 r
.67968 .70932 .68362 .71908 .68719 .72367 .68323 .71385 Mtetra
.109 .137 .608 r
.68323 .71385 .68719 .72367 .69065 .72685 .68666 .71698 Mtetra
.317 .251 .622 r
.68666 .71698 .69065 .72685 .69387 .72754 .68986 .71765 Mtetra
.482 .337 .607 r
.68986 .71765 .69387 .72754 .69678 .72513 .69276 .71523 Mtetra
.583 .388 .583 r
.69276 .71523 .69678 .72513 .69936 .71955 .69533 .70968 Mtetra
.638 .415 .563 r
.69533 .70968 .69936 .71955 .70165 .71134 .69762 .70152 Mtetra
.663 .427 .552 r
.69762 .70152 .70165 .71134 .70374 .7015 .69971 .69174 Mtetra
.669 .43 .55 r
.69971 .69174 .70374 .7015 .70578 .6913 .70176 .68161 Mtetra
.656 .424 .555 r
.70176 .68161 .70578 .6913 .7079 .68206 .70388 .67243 Mtetra
.621 .407 .57 r
.70388 .67243 .7079 .68206 .71025 .6749 .70623 .6653 Mtetra
.552 .373 .593 r
.70623 .6653 .71025 .6749 .71291 .67057 .70889 .66099 Mtetra
.43 .312 .617 r
.70889 .66099 .71291 .67057 .71595 .66934 .71191 .65975 Mtetra
.247 .216 .626 r
.71191 .65975 .71595 .66934 .71934 .67099 .71527 .66136 Mtetra
.051 .11 .605 r
.71527 .66136 .71934 .67099 .72302 .67478 .71892 .6651 Mtetra
0 .048 .581 r
.71892 .6651 .72302 .67478 .72685 .67964 .72272 .6699 Mtetra
0 .066 .588 r
.72272 .6699 .72685 .67964 .73068 .68426 .72652 .67446 Mtetra
.128 .152 .616 r
.72652 .67446 .73068 .68426 .73435 .68736 .73016 .67751 Mtetra
.328 .258 .625 r
.73016 .67751 .73435 .68736 .73772 .68792 .73351 .67804 Mtetra
.486 .339 .607 r
.73351 .67804 .73772 .68792 .7407 .68537 .73647 .67549 Mtetra
.583 .386 .581 r
.73647 .67549 .7407 .68537 .74327 .6797 .73904 .66985 Mtetra
.636 .412 .561 r
.73904 .66985 .74327 .6797 .7455 .6715 .74127 .6617 Mtetra
.66 .423 .55 r
.74127 .6617 .7455 .6715 .7475 .6618 .74328 .65206 Mtetra
.664 .425 .548 r
.74328 .65206 .7475 .6618 .74946 .65188 .74524 .6422 Mtetra
.649 .418 .555 r
.74524 .6422 .74946 .65188 .75155 .64302 .74733 .6334 Mtetra
.609 .4 .572 r
.74733 .6334 .75155 .64302 .75392 .63632 .7497 .62673 Mtetra
.534 .364 .597 r
.7497 .62673 .75392 .63632 .75669 .63248 .75247 .6229 Mtetra
.405 .3 .622 r
.75247 .6229 .75669 .63248 .75992 .63171 .75567 .62212 Mtetra
.221 .206 .629 r
.75567 .62212 .75992 .63171 .76356 .63375 .75929 .62412 Mtetra
.04 .109 .609 r
.75929 .62412 .76356 .63375 .76754 .63784 .76323 .62815 Mtetra
0 .06 .59 r
.76323 .62815 .76754 .63784 .77168 .64286 .76734 .6331 Mtetra
0 .083 .599 r
.76734 .6331 .77168 .64286 .77581 .64751 .77143 .63769 Mtetra
.147 .166 .623 r
.77143 .63769 .77581 .64751 .77971 .65054 .77531 .64067 Mtetra
.338 .265 .627 r
.77531 .64067 .77971 .65054 .78324 .65096 .77881 .64107 Mtetra
.488 .34 .606 r
.77881 .64107 .78324 .65096 .78629 .64826 .78184 .63837 Mtetra
.582 .385 .579 r
.78184 .63837 .78629 .64826 .78885 .6425 .7844 .63263 Mtetra
.633 .408 .558 r
.7844 .63263 .78885 .6425 .79102 .6343 .78657 .62448 Mtetra
.656 .418 .547 r
.78657 .62448 .79102 .6343 .79294 .62472 .7885 .61497 Mtetra
.659 .419 .546 r
.7885 .61497 .79294 .62472 .79483 .61505 .7904 .60536 Mtetra
.641 .411 .555 r
.7904 .60536 .79483 .61505 .7969 .60656 .79247 .59692 Mtetra
.597 .392 .574 r
.79247 .59692 .7969 .60656 .79933 .60031 .7949 .5907 Mtetra
.515 .354 .601 r
.7949 .5907 .79933 .60031 .80225 .59694 .7978 .58733 Mtetra
.379 .289 .626 r
.7978 .58733 .80225 .59694 .8057 .59663 .80123 .58701 Mtetra
.198 .198 .632 r
.80123 .58701 .8057 .59663 .80964 .59906 .80515 .58939 Mtetra
.033 .111 .614 r
.80515 .58939 .80964 .59906 .81396 .60343 .80943 .59371 Mtetra
0 .072 .599 r
.80943 .59371 .81396 .60343 .81846 .60861 .81388 .59882 Mtetra
.012 .1 .61 r
.81388 .59882 .81846 .60861 .8229 .6133 .81829 .60344 Mtetra
.164 .18 .63 r
.81829 .60344 .8229 .6133 .82706 .61627 .82242 .60635 Mtetra
.346 .272 .629 r
.82242 .60635 .82706 .61627 .83076 .61655 .82609 .60661 Mtetra
.491 .341 .605 r
.82609 .60661 .83076 .61655 .83389 .6137 .8292 .60377 Mtetra
.581 .382 .577 r
.8292 .60377 .83389 .6137 .83645 .60783 .83176 .59793 Mtetra
.631 .404 .555 r
.83176 .59793 .83645 .60783 .83856 .59962 .83387 .58976 Mtetra
.652 .413 .544 r
.83387 .58976 .83856 .59962 .84041 .59015 .83573 .58035 Mtetra
.653 .413 .544 r
.83573 .58035 .84041 .59015 .84225 .58072 .83757 .57098 Mtetra
.632 .404 .555 r
.83757 .57098 .84225 .58072 .84432 .57258 .83965 .56289 Mtetra
.583 .383 .577 r
.83965 .56289 .84432 .57258 .84683 .56675 .84216 .5571 Mtetra
.494 .344 .606 r
.84216 .5571 .84683 .56675 .84993 .56385 .84524 .55419 Mtetra
.354 .278 .631 r
.84524 .55419 .84993 .56385 .85366 .564 .84894 .55432 Mtetra
.178 .191 .636 r
.84894 .55432 .85366 .564 .85795 .56682 .8532 .55709 Mtetra
.03 .115 .62 r
.8532 .55709 .85795 .56682 .86266 .57148 .85787 .56169 Mtetra
0 .086 .609 r
.85787 .56169 .86266 .57148 .86755 .57683 .86272 .56697 Mtetra
.033 .116 .62 r
.86272 .56697 .86755 .57683 .87235 .58157 .86748 .57163 Mtetra
.181 .192 .635 r
.86748 .57163 .87235 .58157 .8768 .58446 .87189 .57448 Mtetra
.354 .277 .63 r
.87189 .57448 .8768 .58446 .88069 .58461 .87575 .5746 Mtetra
.492 .341 .604 r
.87575 .5746 .88069 .58461 .8839 .58161 .87895 .5716 Mtetra
.58 .38 .574 r
.87895 .5716 .8839 .58161 .88646 .57562 .8815 .56564 Mtetra
.628 .4 .552 r
.8815 .56564 .88646 .57562 .88851 .56738 .88356 .55745 Mtetra
.648 .408 .542 r
.88356 .55745 .88851 .56738 .89029 .558 .88535 .54814 Mtetra
.646 .407 .543 r
.88535 .54814 .89029 .558 .89209 .54879 .88715 .53899 Mtetra
.622 .397 .555 r
.88715 .53899 .89209 .54879 .89419 .54099 .88925 .53123 Mtetra
.568 .375 .58 r
.88925 .53123 .89419 .54099 .89683 .53559 .89188 .52585 Mtetra
.473 .334 .611 r
.89188 .52585 .89683 .53559 .90016 .53314 .89519 .52341 Mtetra
.33 .269 .636 r
.89519 .52341 .90016 .53314 .90421 .53374 .89922 .52397 Mtetra
.161 .187 .64 r
.89922 .52397 .90421 .53374 .90891 .53696 .90388 .52714 Mtetra
.03 .121 .626 r
.90388 .52714 .90891 .53696 .91407 .54193 .909 .53203 Mtetra
0 .1 .619 r
.909 .53203 .91407 .54193 .91941 .54746 .91429 .53749 Mtetra
.052 .133 .629 r
.91429 .53749 .91941 .54746 .92461 .55224 .91944 .5422 Mtetra
.196 .204 .641 r
.91944 .5422 .92461 .55224 .92937 .55508 .92417 .54499 Mtetra
.362 .282 .631 r
.92417 .54499 .92937 .55508 .93346 .55509 .92823 .54497 Mtetra
.494 .341 .602 r
.92823 .54497 .93346 .55509 .93677 .55192 .93152 .54181 Mtetra
.578 .376 .572 r
.93152 .54181 .93677 .55192 .93934 .54581 .93408 .53573 Mtetra
.624 .395 .549 r
.93408 .53573 .93934 .54581 .94134 .53753 .93608 .5275 Mtetra
.643 .402 .539 r
.93608 .5275 .94134 .53753 .94305 .52823 .93781 .51826 Mtetra
.639 .4 .541 r
.93781 .51826 .94305 .52823 .94483 .51922 .93959 .50931 Mtetra
.611 .39 .556 r
.93959 .50931 .94483 .51922 .94698 .51175 .94174 .50188 Mtetra
.552 .366 .583 r
.94174 .50188 .94698 .51175 .94978 .50675 .94454 .49691 Mtetra
.451 .324 .616 r
.94454 .49691 .94978 .50675 .95339 .50477 .94813 .49492 Mtetra
.307 .26 .641 r
.94813 .49492 .95339 .50477 .95784 .50583 .95254 .49594 Mtetra
.147 .185 .644 r
.95254 .49594 .95784 .50583 .96302 .50945 .95767 .4995 Mtetra
.033 .129 .633 r
.95767 .4995 .96302 .50945 .96869 .51473 .9633 .50471 Mtetra
.005 .115 .629 r
.9633 .50471 .96869 .51473 .97454 .52046 .96909 .51035 Mtetra
.072 .148 .638 r
.96909 .51035 .97454 .52046 .98019 .5253 .97469 .51512 Mtetra
.211 .215 .645 r
.97469 .51512 .98019 .5253 .9853 .52808 .97976 .51785 Mtetra
.368 .287 .632 r
.97976 .51785 .9853 .52808 .98962 .52796 .98405 .5177 Mtetra
.568 .376 .581 r
.52524 .89232 .5286 .90348 .53122 .89822 .52785 .88708 Mtetra
.629 .411 .567 r
.52785 .88708 .53122 .89822 .53378 .88988 .5304 .8788 Mtetra
.66 .429 .558 r
.5304 .8788 .53378 .88988 .53628 .87937 .53291 .86836 Mtetra
.672 .435 .555 r
.53291 .86836 .53628 .87937 .53874 .86794 .53537 .85701 Mtetra
.667 .433 .556 r
.53537 .85701 .53874 .86794 .5412 .85698 .53783 .84613 Mtetra
.645 .42 .563 r
.53783 .84613 .5412 .85698 .54368 .84779 .54031 .837 Mtetra
.598 .394 .575 r
.54031 .837 .54368 .84779 .54622 .84133 .54284 .83058 Mtetra
.512 .345 .591 r
.54284 .83058 .54622 .84133 .54884 .8381 .54545 .82735 Mtetra
.364 .259 .6 r
.54545 .82735 .54884 .8381 .55155 .83804 .54815 .82728 Mtetra
.16 .139 .583 r
.54815 .82728 .55155 .83804 .55435 .8406 .55092 .82979 Mtetra
0 .036 .548 r
.55092 .82979 .55435 .8406 .55722 .84476 .55377 .83389 Mtetra
0 .017 .54 r
.55377 .83389 .55722 .84476 .56011 .84921 .55664 .83828 Mtetra
.084 .093 .57 r
.55664 .83828 .56011 .84921 .563 .85258 .5595 .8416 Mtetra
.289 .215 .597 r
.5595 .8416 .563 .85258 .56582 .85367 .56231 .84265 Mtetra
.461 .314 .595 r
.56231 .84265 .56582 .85367 .56855 .85166 .56502 .84065 Mtetra
.568 .376 .58 r
.56502 .84065 .56855 .85166 .57115 .84633 .56762 .83534 Mtetra
.628 .409 .565 r
.56762 .83534 .57115 .84633 .57364 .83806 .5701 .82713 Mtetra
.658 .425 .556 r
.5701 .82713 .57364 .83806 .57603 .82776 .57249 .8169 Mtetra
.668 .431 .552 r
.57249 .8169 .57603 .82776 .57837 .81669 .57484 .8059 Mtetra
.662 .428 .555 r
.57484 .8059 .57837 .81669 .58072 .80622 .57719 .79551 Mtetra
.637 .414 .563 r
.57719 .79551 .58072 .80622 .58313 .79759 .5796 .78693 Mtetra
.585 .386 .577 r
.5796 .78693 .58313 .79759 .58566 .79171 .58212 .78108 Mtetra
.491 .333 .594 r
.58212 .78108 .58566 .79171 .58834 .789 .58478 .77838 Mtetra
.336 .245 .602 r
.58478 .77838 .58834 .789 .59116 .78939 .58759 .77874 Mtetra
.136 .129 .585 r
.58759 .77874 .59116 .78939 .59413 .79226 .59054 .78156 Mtetra
0 .039 .554 r
.59054 .78156 .59413 .79226 .59719 .79658 .59357 .78583 Mtetra
0 .03 .55 r
.59357 .78583 .59719 .79658 .60029 .80106 .59664 .79024 Mtetra
.102 .109 .579 r
.59664 .79024 .60029 .80106 .60334 .80435 .59967 .79348 Mtetra
.3 .224 .601 r
.59967 .79348 .60334 .80435 .60628 .80529 .60259 .79439 Mtetra
.465 .318 .595 r
.60259 .79439 .60628 .80529 .60906 .80315 .60535 .79225 Mtetra
.569 .375 .579 r
.60535 .79225 .60906 .80315 .61165 .79776 .60794 .78688 Mtetra
.627 .406 .563 r
.60794 .78688 .61165 .79776 .61407 .78953 .61036 .77871 Mtetra
.655 .422 .554 r
.61036 .77871 .61407 .78953 .61636 .77942 .61265 .76867 Mtetra
.664 .426 .55 r
.61265 .76867 .61636 .77942 .61859 .76869 .61488 .75801 Mtetra
.656 .422 .553 r
.61488 .75801 .61859 .76869 .62085 .75867 .61714 .74807 Mtetra
.628 .407 .563 r
.61714 .74807 .62085 .75867 .62321 .75057 .61951 .74002 Mtetra
.571 .377 .579 r
.61951 .74002 .62321 .75057 .62576 .74523 .62204 .73471 Mtetra
.47 .321 .597 r
.62204 .73471 .62576 .74523 .62851 .74304 .62479 .73251 Mtetra
.309 .232 .605 r
.62479 .73251 .62851 .74304 .63149 .74384 .62774 .73329 Mtetra
.116 .122 .587 r
.62774 .73329 .63149 .74384 .63465 .74701 .63088 .7364 Mtetra
0 .044 .56 r
.63088 .7364 .63465 .74701 .63793 .7515 .63413 .74082 Mtetra
0 .045 .561 r
.63413 .74082 .63793 .7515 .64124 .756 .63741 .74527 Mtetra
.119 .124 .588 r
.63741 .74527 .64124 .756 .64447 .75921 .64062 .74842 Mtetra
.311 .233 .604 r
.64062 .74842 .64447 .75921 .64754 .76001 .64366 .7492 Mtetra
.469 .32 .596 r
.64366 .7492 .64754 .76001 .65038 .75774 .64648 .74692 Mtetra
.569 .374 .577 r
.64648 .74692 .65038 .75774 .65296 .75227 .64906 .74148 Mtetra
.625 .404 .561 r
.64906 .74148 .65296 .75227 .65531 .74408 .65141 .73334 Mtetra
.652 .418 .551 r
.65141 .73334 .65531 .74408 .6575 .73414 .6536 .72348 Mtetra
.66 .422 .548 r
.6536 .72348 .6575 .73414 .65963 .72372 .65574 .71313 Mtetra
.649 .416 .552 r
.65574 .71313 .65963 .72372 .66182 .71414 .65793 .70361 Mtetra
.618 .4 .564 r
.65793 .70361 .66182 .71414 .66416 .70653 .66027 .69606 Mtetra
.556 .367 .581 r
.66027 .69606 .66416 .70653 .66675 .70172 .66285 .69126 Mtetra
.447 .31 .6 r
.66285 .69126 .66675 .70172 .66962 .70001 .6657 .68954 Mtetra
.283 .22 .608 r
.6657 .68954 .66962 .70001 .67277 .70122 .66883 .69072 Mtetra
.098 .117 .59 r
.66883 .69072 .67277 .70122 .67616 .70468 .67219 .69413 Mtetra
0 .051 .568 r
.67219 .69413 .67616 .70468 .67968 .70932 .67568 .6987 Mtetra
0 .06 .571 r
.67568 .6987 .67968 .70932 .68323 .71385 .6792 .70317 Mtetra
.136 .138 .596 r
.6792 .70317 .68323 .71385 .68666 .71698 .6826 .70625 Mtetra
.321 .241 .607 r
.6826 .70625 .68666 .71698 .68986 .71765 .68578 .70689 Mtetra
.473 .322 .595 r
.68578 .70689 .68986 .71765 .69276 .71523 .68866 .70447 Mtetra
.569 .373 .575 r
.68866 .70447 .69276 .71523 .69533 .70968 .69123 .69895 Mtetra
.623 .4 .558 r
.69123 .69895 .69533 .70968 .69762 .70152 .69351 .69084 Mtetra
.649 .414 .549 r
.69351 .69084 .69762 .70152 .69971 .69174 .69562 .68113 Mtetra
.655 .416 .546 r
.69562 .68113 .69971 .69174 .70176 .68161 .69766 .67107 Mtetra
.642 .41 .551 r
.69766 .67107 .70176 .68161 .70388 .67243 .69979 .66195 Mtetra
.607 .392 .564 r
.69979 .66195 .70388 .67243 .70623 .6653 .70214 .65487 Mtetra
.539 .358 .584 r
.70214 .65487 .70623 .6653 .70889 .66099 .70479 .65057 Mtetra
.424 .298 .604 r
.70479 .65057 .70889 .66099 .71191 .65975 .70779 .64932 Mtetra
.258 .209 .61 r
.70779 .64932 .71191 .65975 .71527 .66136 .71113 .65089 Mtetra
.085 .114 .594 r
.71113 .65089 .71527 .66136 .71892 .6651 .71474 .65458 Mtetra
0 .06 .576 r
.71474 .65458 .71892 .6651 .72272 .6699 .71851 .65931 Mtetra
.015 .075 .581 r
.71851 .65931 .72272 .6699 .72652 .67446 .72228 .6638 Mtetra
.153 .152 .603 r
.72228 .6638 .72652 .67446 .73016 .67751 .72589 .6668 Mtetra
.331 .248 .61 r
.72589 .6668 .73016 .67751 .73351 .67804 .72921 .6673 Mtetra
.476 .324 .595 r
.72921 .6673 .73351 .67804 .73647 .67549 .73216 .66475 Mtetra
.569 .371 .573 r
.73216 .66475 .73647 .67549 .73904 .66985 .73472 .65914 Mtetra
.621 .397 .556 r
.73472 .65914 .73904 .66985 .74127 .6617 .73695 .65104 Mtetra
.646 .409 .546 r
.73695 .65104 .74127 .6617 .74328 .65206 .73896 .64147 Mtetra
.65 .411 .544 r
.73896 .64147 .74328 .65206 .74524 .6422 .74093 .63168 Mtetra
.634 .404 .551 r
.74093 .63168 .74524 .6422 .74733 .6334 .74302 .62294 Mtetra
.595 .385 .566 r
.74302 .62294 .74733 .6334 .7497 .62673 .74539 .61631 Mtetra
.522 .348 .587 r
.74539 .61631 .7497 .62673 .75247 .6229 .74814 .61249 Mtetra
.401 .287 .608 r
.74814 .61249 .75247 .6229 .75567 .62212 .75133 .6117 Mtetra
.235 .2 .614 r
.75133 .6117 .75567 .62212 .75929 .62412 .75492 .61366 Mtetra
.075 .114 .599 r
.75492 .61366 .75929 .62412 .76323 .62815 .75883 .61762 Mtetra
0 .07 .584 r
.75883 .61762 .76323 .62815 .76734 .6331 .7629 .6225 Mtetra
.032 .09 .591 r
.7629 .6225 .76734 .6331 .77143 .63769 .76695 .62702 Mtetra
.169 .165 .609 r
.76695 .62702 .77143 .63769 .77531 .64067 .77079 .62995 Mtetra
.339 .254 .612 r
.77079 .62995 .77531 .64067 .77881 .64107 .77427 .63032 Mtetra
.478 .325 .594 r
.77427 .63032 .77881 .64107 .78184 .63837 .77729 .62762 Mtetra
.568 .369 .571 r
.77729 .62762 .78184 .63837 .7844 .63263 .77984 .62191 Mtetra
.619 .393 .553 r
.77984 .62191 .7844 .63263 .78657 .62448 .78201 .61382 Mtetra
.642 .404 .543 r
.78201 .61382 .78657 .62448 .7885 .61497 .78395 .60437 Mtetra
.644 .405 .542 r
.78395 .60437 .7885 .61497 .7904 .60536 .78585 .59483 Mtetra
.626 .397 .55 r
.78585 .59483 .7904 .60536 .79247 .59692 .78792 .58645 Mtetra
.582 .376 .567 r
.78792 .58645 .79247 .59692 .7949 .5907 .79034 .58026 Mtetra
.503 .339 .591 r
.79034 .58026 .7949 .5907 .7978 .58733 .79324 .57691 Mtetra
.377 .276 .612 r
.79324 .57691 .7978 .58733 .80123 .58701 .79664 .57656 Mtetra
.215 .193 .617 r
.79664 .57656 .80123 .58701 .80515 .58939 .80052 .5789 Mtetra
.068 .115 .604 r
.80052 .5789 .80515 .58939 .80943 .59371 .80477 .58314 Mtetra
.003 .081 .593 r
.80477 .58314 .80943 .59371 .81388 .59882 .80918 .58818 Mtetra
.049 .105 .601 r
.80918 .58818 .81388 .59882 .81829 .60344 .81355 .59274 Mtetra
.184 .177 .615 r
.81355 .59274 .81829 .60344 .82242 .60635 .81764 .59559 Mtetra
.347 .26 .614 r
.81764 .59559 .82242 .60635 .82609 .60661 .82129 .59582 Mtetra
.48 .326 .594 r
.82129 .59582 .82609 .60661 .8292 .60377 .82438 .59298 Mtetra
.567 .367 .569 r
.82438 .59298 .8292 .60377 .83176 .59793 .82693 .58717 Mtetra
.616 .389 .55 r
.82693 .58717 .83176 .59793 .83387 .58976 .82905 .57906 Mtetra
.637 .399 .54 r
.82905 .57906 .83387 .58976 .83573 .58035 .83091 .56972 Mtetra
.638 .399 .54 r
.83091 .56972 .83573 .58035 .83757 .57098 .83276 .56042 Mtetra
.617 .39 .55 r
.83276 .56042 .83757 .57098 .83965 .56289 .83483 .55238 Mtetra
.569 .368 .569 r
.83483 .55238 .83965 .56289 .84216 .5571 .83734 .54662 Mtetra
.484 .329 .594 r
.83734 .54662 .84216 .5571 .84524 .55419 .84041 .54372 Mtetra
.355 .266 .616 r
.84041 .54372 .84524 .55419 .84894 .55432 .84408 .54381 Mtetra
.196 .187 .621 r
.84408 .54381 .84894 .55432 .8532 .55709 .84831 .54653 Mtetra
.064 .119 .609 r
.84831 .54653 .8532 .55709 .85787 .56169 .85293 .55106 Mtetra
.014 .093 .602 r
.85293 .55106 .85787 .56169 .86272 .56697 .85773 .55626 Mtetra
.066 .12 .61 r
.85773 .55626 .86272 .56697 .86748 .57163 .86245 .56085 Mtetra
.199 .188 .621 r
.86245 .56085 .86748 .57163 .87189 .57448 .86682 .56364 Mtetra
.355 .266 .615 r
.86682 .56364 .87189 .57448 .87575 .5746 .87065 .56374 Mtetra
.482 .326 .593 r
.87065 .56374 .87575 .5746 .87895 .5716 .87383 .56074 Mtetra
.566 .364 .567 r
.87383 .56074 .87895 .5716 .8815 .56564 .87638 .55482 Mtetra
.613 .385 .547 r
.87638 .55482 .8815 .56564 .88356 .55745 .87844 .54668 Mtetra
.633 .393 .538 r
.87844 .54668 .88356 .55745 .88535 .54814 .88023 .53744 Mtetra
.631 .393 .539 r
.88023 .53744 .88535 .54814 .88715 .53899 .88204 .52835 Mtetra
.606 .382 .55 r
.88204 .52835 .88715 .53899 .88925 .53123 .88415 .52065 Mtetra
.554 .36 .572 r
.88415 .52065 .88925 .53123 .89188 .52585 .88677 .51529 Mtetra
.464 .319 .599 r
.88677 .51529 .89188 .52585 .89519 .52341 .89006 .51285 Mtetra
.332 .258 .621 r
.89006 .51285 .89519 .52341 .89922 .52397 .89406 .51338 Mtetra
.181 .184 .625 r
.89406 .51338 .89922 .52397 .90388 .52714 .89868 .51649 Mtetra
.063 .124 .616 r
.89868 .51649 .90388 .52714 .909 .53203 .90374 .52131 Mtetra
.027 .106 .611 r
.90374 .52131 .909 .53203 .91429 .53749 .90898 .52668 Mtetra
.084 .135 .618 r
.90898 .52668 .91429 .53749 .91944 .5422 .91409 .53132 Mtetra
.213 .199 .625 r
.91409 .53132 .91944 .5422 .92417 .54499 .91877 .53404 Mtetra
.361 .27 .616 r
.91877 .53404 .92417 .54499 .92823 .54497 .9228 .534 Mtetra
.483 .326 .591 r
.9228 .534 .92823 .54497 .93152 .54181 .92607 .53084 Mtetra
.564 .361 .564 r
.92607 .53084 .93152 .54181 .93408 .53573 .92863 .5248 Mtetra
.609 .38 .544 r
.92863 .5248 .93408 .53573 .93608 .5275 .93063 .51662 Mtetra
.627 .387 .535 r
.93063 .51662 .93608 .5275 .93781 .51826 .93237 .50745 Mtetra
.623 .386 .537 r
.93237 .50745 .93781 .51826 .93959 .50931 .93415 .49857 Mtetra
.596 .375 .551 r
.93415 .49857 .93959 .50931 .94174 .50188 .93631 .49119 Mtetra
.539 .351 .575 r
.93631 .49119 .94174 .50188 .94454 .49691 .93909 .48624 Mtetra
.444 .31 .603 r
.93909 .48624 .94454 .49691 .94813 .49492 .94266 .48424 Mtetra
.311 .25 .625 r
.94266 .48424 .94813 .49492 .95254 .49594 .94704 .48522 Mtetra
.168 .182 .63 r
.94704 .48522 .95254 .49594 .95767 .4995 .95212 .48872 Mtetra
.065 .131 .622 r
.95212 .48872 .95767 .4995 .9633 .50471 .95769 .49384 Mtetra
.04 .119 .619 r
.95769 .49384 .9633 .50471 .96909 .51035 .96343 .4994 Mtetra
.101 .149 .626 r
.96343 .4994 .96909 .51035 .97469 .51512 .96898 .50409 Mtetra
.225 .209 .63 r
.96898 .50409 .97469 .51512 .97976 .51785 .974 .50676 Mtetra
.367 .274 .617 r
.974 .50676 .97976 .51785 .98405 .5177 .97825 .50658 Mtetra
.573 .382 .584 r
.5219 .88164 .52524 .89232 .52785 .88708 .52451 .87643 Mtetra
.634 .417 .57 r
.52451 .87643 .52785 .88708 .5304 .8788 .52706 .8682 Mtetra
.665 .434 .56 r
.52706 .8682 .5304 .8788 .53291 .86836 .52956 .85783 Mtetra
.677 .44 .556 r
.52956 .85783 .53291 .86836 .53537 .85701 .53203 .84655 Mtetra
.672 .438 .558 r
.53203 .84655 .53537 .85701 .53783 .84613 .53449 .83575 Mtetra
.65 .426 .565 r
.53449 .83575 .53783 .84613 .54031 .837 .53697 .82668 Mtetra
.604 .4 .578 r
.53697 .82668 .54031 .837 .54284 .83058 .5395 .82029 Mtetra
.516 .351 .595 r
.5395 .82029 .54284 .83058 .54545 .82735 .5421 .81707 Mtetra
.364 .263 .605 r
.5421 .81707 .54545 .82735 .54815 .82728 .54478 .81698 Mtetra
.15 .138 .588 r
.54478 .81698 .54815 .82728 .55092 .82979 .54754 .81945 Mtetra
0 .03 .55 r
.54754 .81945 .55092 .82979 .55377 .83389 .55035 .82349 Mtetra
0 .01 .541 r
.55035 .82349 .55377 .83389 .55664 .83828 .5532 .82783 Mtetra
.07 .091 .574 r
.5532 .82783 .55664 .83828 .5595 .8416 .55604 .8311 Mtetra
.286 .218 .602 r
.55604 .8311 .5595 .8416 .56231 .84265 .55883 .83212 Mtetra
.465 .32 .6 r
.55883 .83212 .56231 .84265 .56502 .84065 .56153 .83011 Mtetra
.574 .382 .583 r
.56153 .83011 .56502 .84065 .56762 .83534 .56412 .82483 Mtetra
.633 .414 .567 r
.56412 .82483 .56762 .83534 .5701 .82713 .5666 .81666 Mtetra
.663 .431 .558 r
.5666 .81666 .5701 .82713 .57249 .8169 .569 .8065 Mtetra
.673 .436 .554 r
.569 .8065 .57249 .8169 .57484 .8059 .57135 .79558 Mtetra
.667 .433 .556 r
.57135 .79558 .57484 .8059 .57719 .79551 .5737 .78526 Mtetra
.642 .419 .565 r
.5737 .78526 .57719 .79551 .5796 .78693 .57611 .77674 Mtetra
.591 .391 .58 r
.57611 .77674 .5796 .78693 .58212 .78108 .57863 .77091 Mtetra
.495 .339 .598 r
.57863 .77091 .58212 .78108 .58478 .77838 .58128 .76821 Mtetra
.335 .249 .608 r
.58128 .76821 .58478 .77838 .58759 .77874 .58407 .76855 Mtetra
.125 .128 .59 r
.58407 .76855 .58759 .77874 .59054 .78156 .58699 .77133 Mtetra
0 .033 .556 r
.58699 .77133 .59054 .78156 .59357 .78583 .59 .77553 Mtetra
0 .025 .552 r
.59 .77553 .59357 .78583 .59664 .79024 .59304 .77989 Mtetra
.089 .107 .584 r
.59304 .77989 .59664 .79024 .59967 .79348 .59604 .78308 Mtetra
.298 .227 .606 r
.59604 .78308 .59967 .79348 .60259 .79439 .59895 .78396 Mtetra
.469 .323 .6 r
.59895 .78396 .60259 .79439 .60535 .79225 .6017 .78182 Mtetra
.574 .381 .582 r
.6017 .78182 .60535 .79225 .60794 .78688 .60428 .77648 Mtetra
.632 .412 .565 r
.60428 .77648 .60794 .78688 .61036 .77871 .60669 .76836 Mtetra
.661 .427 .555 r
.60669 .76836 .61036 .77871 .61265 .76867 .60899 .75839 Mtetra
.67 .432 .552 r
.60899 .75839 .61265 .76867 .61488 .75801 .61122 .7478 Mtetra
.661 .427 .555 r
.61122 .7478 .61488 .75801 .61714 .74807 .61349 .73792 Mtetra
.633 .413 .565 r
.61349 .73792 .61714 .74807 .61951 .74002 .61585 .72992 Mtetra
.576 .383 .582 r
.61585 .72992 .61951 .74002 .62204 .73471 .61838 .72463 Mtetra
.473 .327 .602 r
.61838 .72463 .62204 .73471 .62479 .73251 .62111 .72243 Mtetra
.307 .236 .611 r
.62111 .72243 .62479 .73251 .62774 .73329 .62405 .72318 Mtetra
.104 .121 .592 r
.62405 .72318 .62774 .73329 .63088 .7364 .62716 .72625 Mtetra
0 .039 .562 r
.62716 .72625 .63088 .7364 .63413 .74082 .63038 .73061 Mtetra
0 .04 .563 r
.63038 .73061 .63413 .74082 .63741 .74527 .63363 .73499 Mtetra
.108 .123 .592 r
.63363 .73499 .63741 .74527 .64062 .74842 .63682 .7381 Mtetra
.309 .236 .61 r
.63682 .7381 .64062 .74842 .64366 .7492 .63984 .73885 Mtetra
.473 .326 .6 r
.63984 .73885 .64366 .7492 .64648 .74692 .64265 .73657 Mtetra
.575 .38 .58 r
.64265 .73657 .64648 .74692 .64906 .74148 .64522 .73115 Mtetra
.631 .409 .563 r
.64522 .73115 .64906 .74148 .65141 .73334 .64757 .72307 Mtetra
.658 .423 .553 r
.64757 .72307 .65141 .73334 .6536 .72348 .64977 .71327 Mtetra
.665 .427 .55 r
.64977 .71327 .6536 .72348 .65574 .71313 .65191 .70299 Mtetra
.655 .422 .554 r
.65191 .70299 .65574 .71313 .65793 .70361 .6541 .69353 Mtetra
.623 .406 .566 r
.6541 .69353 .65793 .70361 .66027 .69606 .65644 .68602 Mtetra
.561 .374 .585 r
.65644 .68602 .66027 .69606 .66285 .69126 .65901 .68125 Mtetra
.45 .315 .605 r
.65901 .68125 .66285 .69126 .6657 .68954 .66185 .67953 Mtetra
.28 .223 .613 r
.66185 .67953 .6657 .68954 .66883 .69072 .66496 .68068 Mtetra
.086 .115 .595 r
.66496 .68068 .66883 .69072 .67219 .69413 .66829 .68403 Mtetra
0 .046 .57 r
.66829 .68403 .67219 .69413 .67568 .6987 .67175 .68854 Mtetra
0 .056 .574 r
.67175 .68854 .67568 .6987 .6792 .70317 .67523 .69294 Mtetra
.126 .138 .601 r
.67523 .69294 .6792 .70317 .6826 .70625 .67861 .69597 Mtetra
.32 .244 .613 r
.67861 .69597 .6826 .70625 .68578 .70689 .68177 .69658 Mtetra
.477 .328 .6 r
.68177 .69658 .68578 .70689 .68866 .70447 .68463 .69417 Mtetra
.575 .379 .578 r
.68463 .69417 .68866 .70447 .69123 .69895 .68719 .68867 Mtetra
.629 .406 .56 r
.68719 .68867 .69123 .69895 .69351 .69084 .68948 .68061 Mtetra
.655 .419 .55 r
.68948 .68061 .69351 .69084 .69562 .68113 .69159 .67097 Mtetra
.661 .422 .548 r
.69159 .67097 .69562 .68113 .69766 .67107 .69364 .66098 Mtetra
.648 .416 .553 r
.69364 .66098 .69766 .67107 .69979 .66195 .69577 .65192 Mtetra
.613 .398 .567 r
.69577 .65192 .69979 .66195 .70214 .65487 .69811 .64488 Mtetra
.544 .364 .587 r
.69811 .64488 .70214 .65487 .70479 .65057 .70076 .6406 Mtetra
.427 .304 .609 r
.70076 .6406 .70479 .65057 .70779 .64932 .70374 .63934 Mtetra
.254 .212 .616 r
.70374 .63934 .70779 .64932 .71113 .65089 .70706 .64087 Mtetra
.072 .113 .598 r
.70706 .64087 .71113 .65089 .71474 .65458 .71064 .6445 Mtetra
0 .055 .578 r
.71064 .6445 .71474 .65458 .71851 .65931 .71437 .64917 Mtetra
0 .072 .584 r
.71437 .64917 .71851 .65931 .72228 .6638 .71811 .65359 Mtetra
.144 .152 .608 r
.71811 .65359 .72228 .6638 .72589 .6668 .72169 .65655 Mtetra
.33 .252 .616 r
.72169 .65655 .72589 .6668 .72921 .6673 .72499 .65702 Mtetra
.48 .33 .6 r
.72499 .65702 .72921 .6673 .73216 .66475 .72793 .65447 Mtetra
.574 .377 .576 r
.72793 .65447 .73216 .66475 .73472 .65914 .73048 .64888 Mtetra
.627 .403 .558 r
.73048 .64888 .73472 .65914 .73695 .65104 .73271 .64084 Mtetra
.651 .415 .547 r
.73271 .64084 .73695 .65104 .73896 .64147 .73473 .63133 Mtetra
.656 .416 .546 r
.73473 .63133 .73896 .64147 .74093 .63168 .7367 .62161 Mtetra
.64 .409 .552 r
.7367 .62161 .74093 .63168 .74302 .62294 .7388 .61293 Mtetra
.601 .391 .568 r
.7388 .61293 .74302 .62294 .74539 .61631 .74116 .60634 Mtetra
.527 .354 .591 r
.74116 .60634 .74539 .61631 .74814 .61249 .7439 .60253 Mtetra
.402 .292 .613 r
.7439 .60253 .74814 .61249 .75133 .6117 .74707 .60172 Mtetra
.23 .203 .62 r
.74707 .60172 .75133 .6117 .75492 .61366 .75063 .60364 Mtetra
.062 .112 .603 r
.75063 .60364 .75492 .61366 .75883 .61762 .75451 .60754 Mtetra
0 .066 .587 r
.75451 .60754 .75883 .61762 .7629 .6225 .75854 .61235 Mtetra
.017 .088 .595 r
.75854 .61235 .7629 .6225 .76695 .62702 .76256 .61681 Mtetra
.161 .165 .615 r
.76256 .61681 .76695 .62702 .77079 .62995 .76637 .61969 Mtetra
.339 .259 .618 r
.76637 .61969 .77079 .62995 .77427 .63032 .76982 .62003 Mtetra
.482 .331 .599 r
.76982 .62003 .77427 .63032 .77729 .62762 .77282 .61733 Mtetra
.574 .375 .574 r
.77282 .61733 .77729 .62762 .77984 .62191 .77537 .61165 Mtetra
.624 .399 .555 r
.77537 .61165 .77984 .62191 .78201 .61382 .77754 .60361 Mtetra
.648 .41 .545 r
.77754 .60361 .78201 .61382 .78395 .60437 .77949 .59423 Mtetra
.65 .411 .544 r
.77949 .59423 .78395 .60437 .78585 .59483 .78139 .58475 Mtetra
.632 .403 .552 r
.78139 .58475 .78585 .59483 .78792 .58645 .78347 .57643 Mtetra
.588 .382 .57 r
.78347 .57643 .78792 .58645 .79034 .58026 .78589 .57027 Mtetra
.508 .345 .595 r
.78589 .57027 .79034 .58026 .79324 .57691 .78876 .56692 Mtetra
.378 .281 .618 r
.78876 .56692 .79324 .57691 .79664 .57656 .79215 .56656 Mtetra
.208 .195 .623 r
.79215 .56656 .79664 .57656 .80052 .5789 .796 .56885 Mtetra
.055 .114 .608 r
.796 .56885 .80052 .5789 .80477 .58314 .80021 .57303 Mtetra
0 .078 .596 r
.80021 .57303 .80477 .58314 .80918 .58818 .80458 .578 Mtetra
.035 .103 .605 r
.80458 .578 .80918 .58818 .81355 .59274 .80891 .58248 Mtetra
.177 .178 .621 r
.80891 .58248 .81355 .59274 .81764 .59559 .81297 .58529 Mtetra
.347 .265 .619 r
.81297 .58529 .81764 .59559 .82129 .59582 .81659 .58549 Mtetra
.484 .332 .598 r
.81659 .58549 .82129 .59582 .82438 .59298 .81967 .58265 Mtetra
.573 .373 .572 r
.81967 .58265 .82438 .59298 .82693 .58717 .82221 .57687 Mtetra
.622 .395 .552 r
.82221 .57687 .82693 .58717 .82905 .57906 .82433 .56882 Mtetra
.643 .405 .542 r
.82433 .56882 .82905 .57906 .83091 .56972 .8262 .55954 Mtetra
.644 .405 .542 r
.8262 .55954 .83091 .56972 .83276 .56042 .82805 .5503 Mtetra
.623 .395 .552 r
.82805 .5503 .83276 .56042 .83483 .55238 .83013 .54232 Mtetra
.574 .374 .572 r
.83013 .54232 .83483 .55238 .83734 .54662 .83263 .53658 Mtetra
.488 .335 .599 r
.83263 .53658 .83734 .54662 .84041 .54372 .83568 .53369 Mtetra
.354 .271 .622 r
.83568 .53369 .84041 .54372 .84408 .54381 .83933 .53376 Mtetra
.19 .189 .627 r
.83933 .53376 .84408 .54381 .84831 .54653 .84352 .53642 Mtetra
.051 .118 .614 r
.84352 .53642 .84831 .54653 .85293 .55106 .8481 .54088 Mtetra
0 .09 .605 r
.8481 .54088 .85293 .55106 .85773 .55626 .85286 .54601 Mtetra
.053 .119 .614 r
.85286 .54601 .85773 .55626 .86245 .56085 .85753 .55053 Mtetra
.192 .19 .627 r
.85753 .55053 .86245 .56085 .86682 .56364 .86187 .55327 Mtetra
.355 .27 .621 r
.86187 .55327 .86682 .56364 .87065 .56374 .86567 .55334 Mtetra
.486 .332 .597 r
.86567 .55334 .87065 .56374 .87383 .56074 .86884 .55034 Mtetra
.571 .37 .57 r
.86884 .55034 .87383 .56074 .87638 .55482 .87138 .54445 Mtetra
.619 .391 .549 r
.87138 .54445 .87638 .55482 .87844 .54668 .87344 .53637 Mtetra
.639 .399 .539 r
.87344 .53637 .87844 .54668 .88023 .53744 .87524 .52719 Mtetra
.637 .398 .54 r
.87524 .52719 .88023 .53744 .88204 .52835 .87706 .51816 Mtetra
.612 .388 .552 r
.87706 .51816 .88204 .52835 .88415 .52065 .87916 .51051 Mtetra
.56 .366 .575 r
.87916 .51051 .88415 .52065 .88677 .51529 .88178 .50518 Mtetra
.468 .325 .603 r
.88178 .50518 .88677 .51529 .89006 .51285 .88505 .50273 Mtetra
.331 .262 .627 r
.88505 .50273 .89006 .51285 .89406 .51338 .88902 .50324 Mtetra
.173 .185 .631 r
.88902 .50324 .89406 .51338 .89868 .51649 .8936 .50629 Mtetra
.05 .123 .62 r
.8936 .50629 .89868 .51649 .90374 .52131 .89862 .51103 Mtetra
.012 .104 .614 r
.89862 .51103 .90374 .52131 .90898 .52668 .90381 .51633 Mtetra
.072 .134 .623 r
.90381 .51633 .90898 .52668 .91409 .53132 .90887 .52089 Mtetra
.206 .201 .631 r
.90887 .52089 .91409 .53132 .91877 .53404 .91351 .52356 Mtetra
.362 .275 .622 r
.91351 .52356 .91877 .53404 .9228 .534 .91751 .5235 Mtetra
.487 .332 .596 r
.91751 .5235 .9228 .534 .92607 .53084 .92077 .52034 Mtetra
.569 .367 .567 r
.92077 .52034 .92607 .53084 .92863 .5248 .92332 .51433 Mtetra
.615 .386 .546 r
.92332 .51433 .92863 .5248 .93063 .51662 .92533 .50621 Mtetra
.633 .393 .536 r
.92533 .50621 .93063 .51662 .93237 .50745 .92707 .4971 Mtetra
.629 .392 .539 r
.92707 .4971 .93237 .50745 .93415 .49857 .92886 .48828 Mtetra
.602 .381 .553 r
.92886 .48828 .93415 .49857 .93631 .49119 .93102 .48095 Mtetra
.544 .357 .578 r
.93102 .48095 .93631 .49119 .93909 .48624 .93379 .47602 Mtetra
.447 .315 .608 r
.93379 .47602 .93909 .48624 .94266 .48424 .93733 .47402 Mtetra
.31 .254 .631 r
.93733 .47402 .94266 .48424 .94704 .48522 .94168 .47496 Mtetra
.16 .183 .636 r
.94168 .47496 .94704 .48522 .95212 .48872 .94672 .4784 Mtetra
.053 .13 .627 r
.94672 .4784 .95212 .48872 .95769 .49384 .95224 .48344 Mtetra
.026 .117 .623 r
.95224 .48344 .95769 .49384 .96343 .4994 .95792 .48891 Mtetra
.09 .149 .631 r
.95792 .48891 .96343 .4994 .96898 .50409 .96341 .49353 Mtetra
.22 .211 .636 r
.96341 .49353 .96898 .50409 .974 .50676 .96839 .49614 Mtetra
.368 .279 .623 r
.96839 .49614 .974 .50676 .97825 .50658 .97261 .49593 Mtetra
.599 .411 .599 r
.51861 .87276 .5219 .88164 .52451 .87643 .52121 .86757 Mtetra
.66 .443 .579 r
.52121 .86757 .52451 .87643 .52706 .8682 .52376 .85938 Mtetra
.69 .458 .567 r
.52376 .85938 .52706 .8682 .52956 .85783 .52627 .84906 Mtetra
.7 .463 .562 r
.52627 .84906 .52956 .85783 .53203 .84655 .52874 .83785 Mtetra
.696 .461 .564 r
.52874 .83785 .53203 .84655 .53449 .83575 .53121 .8271 Mtetra
.676 .451 .573 r
.53121 .8271 .53449 .83575 .53697 .82668 .53369 .81808 Mtetra
.63 .428 .59 r
.53369 .81808 .53697 .82668 .5395 .82029 .53622 .81172 Mtetra
.539 .381 .615 r
.53622 .81172 .5395 .82029 .5421 .81707 .53881 .8085 Mtetra
.366 .288 .635 r
.53881 .8085 .5421 .81707 .54478 .81698 .54147 .80839 Mtetra
.098 .137 .613 r
.54147 .80839 .54478 .81698 .54754 .81945 .54421 .81083 Mtetra
0 0 .553 r
.54421 .81083 .54754 .81945 .55035 .82349 .54701 .81483 Mtetra
0 0 .538 r
.54701 .81483 .55035 .82349 .5532 .82783 .54984 .81912 Mtetra
0 .076 .591 r
.54984 .81912 .5532 .82783 .55604 .8311 .55266 .82235 Mtetra
.27 .234 .633 r
.55266 .82235 .55604 .8311 .55883 .83212 .55543 .82334 Mtetra
.482 .35 .624 r
.55543 .82334 .55883 .83212 .56153 .83011 .55812 .82133 Mtetra
.6 .411 .598 r
.55812 .82133 .56153 .83011 .56412 .82483 .5607 .81607 Mtetra
.659 .441 .577 r
.5607 .81607 .56412 .82483 .5666 .81666 .56318 .80795 Mtetra
.688 .455 .564 r
.56318 .80795 .5666 .81666 .569 .8065 .56558 .79784 Mtetra
.698 .46 .56 r
.56558 .79784 .569 .8065 .57135 .79558 .56794 .78698 Mtetra
.692 .457 .563 r
.56794 .78698 .57135 .79558 .5737 .78526 .5703 .77671 Mtetra
.668 .446 .574 r
.5703 .77671 .5737 .78526 .57611 .77674 .57271 .76823 Mtetra
.617 .42 .593 r
.57271 .76823 .57611 .77674 .57863 .77091 .57522 .76243 Mtetra
.517 .369 .62 r
.57522 .76243 .57863 .77091 .58128 .76821 .57786 .75973 Mtetra
.331 .271 .638 r
.57786 .75973 .58128 .76821 .58407 .76855 .58064 .76005 Mtetra
.067 .124 .613 r
.58064 .76005 .58407 .76855 .58699 .77133 .58354 .76279 Mtetra
0 .004 .559 r
.58354 .76279 .58699 .77133 .59 .77553 .58653 .76695 Mtetra
0 0 .553 r
.58653 .76695 .59 .77553 .59304 .77989 .58955 .77126 Mtetra
.021 .097 .603 r
.58955 .77126 .59304 .77989 .59604 .78308 .59253 .77441 Mtetra
.285 .245 .637 r
.59253 .77441 .59604 .78308 .59895 .78396 .59542 .77527 Mtetra
.487 .353 .624 r
.59542 .77527 .59895 .78396 .6017 .78182 .59816 .77312 Mtetra
.601 .411 .596 r
.59816 .77312 .6017 .78182 .60428 .77648 .60073 .7678 Mtetra
.659 .439 .575 r
.60073 .7678 .60428 .77648 .60669 .76836 .60315 .75972 Mtetra
.686 .452 .562 r
.60315 .75972 .60669 .76836 .60899 .75839 .60544 .7498 Mtetra
.694 .456 .558 r
.60544 .7498 .60899 .75839 .61122 .7478 .60769 .73927 Mtetra
.687 .452 .562 r
.60769 .73927 .61122 .7478 .61349 .73792 .60996 .72944 Mtetra
.66 .44 .574 r
.60996 .72944 .61349 .73792 .61585 .72992 .61232 .72148 Mtetra
.603 .412 .597 r
.61232 .72148 .61585 .72992 .61838 .72463 .61485 .71621 Mtetra
.492 .357 .625 r
.61485 .71621 .61838 .72463 .62111 .72243 .61757 .71401 Mtetra
.297 .255 .641 r
.61757 .71401 .62111 .72243 .62405 .72318 .62049 .71474 Mtetra
.041 .114 .614 r
.62049 .71474 .62405 .72318 .62716 .72625 .62358 .71777 Mtetra
0 .011 .566 r
.62358 .71777 .62716 .72625 .63038 .73061 .62678 .72208 Mtetra
0 .013 .567 r
.62678 .72208 .63038 .73061 .63363 .73499 .63 .72641 Mtetra
.046 .117 .615 r
.63 .72641 .63363 .73499 .63682 .7381 .63316 .72948 Mtetra
.299 .256 .641 r
.63316 .72948 .63682 .7381 .63984 .73885 .63617 .7302 Mtetra
.492 .356 .623 r
.63617 .7302 .63984 .73885 .64265 .73657 .63897 .72792 Mtetra
.601 .41 .595 r
.63897 .72792 .64265 .73657 .64522 .73115 .64153 .72252 Mtetra
.657 .436 .572 r
.64153 .72252 .64522 .73115 .64757 .72307 .64388 .71448 Mtetra
.684 .448 .559 r
.64388 .71448 .64757 .72307 .64977 .71327 .64608 .70473 Mtetra
.691 .452 .556 r
.64608 .70473 .64977 .71327 .65191 .70299 .64823 .69451 Mtetra
.681 .447 .561 r
.64823 .69451 .65191 .70299 .6541 .69353 .65042 .6851 Mtetra
.65 .433 .576 r
.65042 .6851 .6541 .69353 .65644 .68602 .65277 .67763 Mtetra
.587 .404 .6 r
.65277 .67763 .65644 .68602 .65901 .68125 .65533 .67287 Mtetra
.466 .345 .63 r
.65533 .67287 .65901 .68125 .66185 .67953 .65816 .67114 Mtetra
.263 .24 .644 r
.65816 .67114 .66185 .67953 .66496 .68068 .66125 .67227 Mtetra
.019 .107 .615 r
.66125 .67227 .66496 .68068 .66829 .68403 .66456 .67558 Mtetra
0 .021 .575 r
.66456 .67558 .66829 .68403 .67175 .68854 .668 .68004 Mtetra
0 .033 .581 r
.668 .68004 .67175 .68854 .67523 .69294 .67145 .68439 Mtetra
.07 .135 .625 r
.67145 .68439 .67523 .69294 .67861 .69597 .6748 .68738 Mtetra
.312 .265 .644 r
.6748 .68738 .67861 .69597 .68177 .69658 .67794 .68797 Mtetra
.496 .358 .623 r
.67794 .68797 .68177 .69658 .68463 .69417 .6808 .68555 Mtetra
.601 .409 .593 r
.6808 .68555 .68463 .69417 .68719 .68867 .68335 .68008 Mtetra
.656 .434 .57 r
.68335 .68008 .68719 .68867 .68948 .68061 .68564 .67206 Mtetra
.681 .445 .557 r
.68564 .67206 .68948 .68061 .69159 .67097 .68776 .66247 Mtetra
.687 .447 .554 r
.68776 .66247 .69159 .67097 .69364 .66098 .68981 .65253 Mtetra
.675 .442 .561 r
.68981 .65253 .69364 .66098 .69577 .65192 .69195 .64352 Mtetra
.64 .426 .578 r
.69195 .64352 .69577 .65192 .69811 .64488 .69429 .63651 Mtetra
.569 .394 .605 r
.69429 .63651 .69811 .64488 .70076 .6406 .69692 .63224 Mtetra
.439 .332 .636 r
.69692 .63224 .70076 .6406 .70374 .63934 .6999 .63097 Mtetra
.231 .226 .647 r
.6999 .63097 .70374 .63934 .70706 .64087 .70319 .63248 Mtetra
.003 .104 .618 r
.70319 .63248 .70706 .64087 .71064 .6445 .70675 .63606 Mtetra
0 .033 .584 r
.70675 .63606 .71064 .6445 .71437 .64917 .71045 .64067 Mtetra
0 .053 .595 r
.71045 .64067 .71437 .64917 .71811 .65359 .71416 .64505 Mtetra
.093 .153 .634 r
.71416 .64505 .71811 .65359 .72169 .65655 .71772 .64796 Mtetra
.324 .274 .646 r
.71772 .64796 .72169 .65655 .72499 .65702 .721 .64841 Mtetra
.499 .36 .622 r
.721 .64841 .72499 .65702 .72793 .65447 .72392 .64586 Mtetra
.601 .407 .591 r
.72392 .64586 .72793 .65447 .73048 .64888 .72647 .6403 Mtetra
.654 .43 .567 r
.72647 .6403 .73048 .64888 .73271 .64084 .7287 .63229 Mtetra
.678 .441 .554 r
.7287 .63229 .73271 .64084 .73473 .63133 .73073 .62284 Mtetra
.682 .442 .552 r
.73073 .62284 .73473 .63133 .7367 .62161 .73271 .61317 Mtetra
.667 .436 .56 r
.73271 .61317 .7367 .62161 .7388 .61293 .73481 .60453 Mtetra
.628 .419 .58 r
.73481 .60453 .7388 .61293 .74116 .60634 .73717 .59797 Mtetra
.55 .385 .61 r
.73717 .59797 .74116 .60634 .7439 .60253 .73991 .59417 Mtetra
.411 .319 .641 r
.73991 .59417 .7439 .60253 .74707 .60172 .74305 .59335 Mtetra
.202 .215 .65 r
.74305 .59335 .74707 .60172 .75063 .60364 .74659 .59523 Mtetra
0 .103 .621 r
.74659 .59523 .75063 .60364 .75451 .60754 .75044 .59909 Mtetra
0 .046 .595 r
.75044 .59909 .75451 .60754 .75854 .61235 .75444 .60384 Mtetra
0 .073 .608 r
.75444 .60384 .75854 .61235 .76256 .61681 .75843 .60825 Mtetra
.115 .169 .642 r
.75843 .60825 .76256 .61681 .76637 .61969 .76221 .61108 Mtetra
.335 .281 .648 r
.76221 .61108 .76637 .61969 .76982 .62003 .76564 .6114 Mtetra
.502 .361 .622 r
.76564 .6114 .76982 .62003 .77282 .61733 .76863 .6087 Mtetra
.601 .405 .589 r
.76863 .6087 .77282 .61733 .77537 .61165 .77118 .60305 Mtetra
.652 .427 .564 r
.77118 .60305 .77537 .61165 .77754 .60361 .77335 .59505 Mtetra
.675 .436 .552 r
.77335 .59505 .77754 .60361 .77949 .59423 .7753 .58571 Mtetra
.677 .437 .55 r
.7753 .58571 .77949 .59423 .78139 .58475 .77722 .57629 Mtetra
.66 .43 .561 r
.77722 .57629 .78139 .58475 .78347 .57643 .7793 .56801 Mtetra
.616 .412 .583 r
.7793 .56801 .78347 .57643 .78589 .57027 .78171 .56188 Mtetra
.53 .375 .615 r
.78171 .56188 .78589 .57027 .78876 .56692 .78458 .55854 Mtetra
.382 .307 .647 r
.78458 .55854 .78876 .56692 .79215 .56656 .78794 .55816 Mtetra
.175 .205 .653 r
.78794 .55816 .79215 .56656 .796 .56885 .79177 .56041 Mtetra
0 .105 .626 r
.79177 .56041 .796 .56885 .80021 .57303 .79594 .56454 Mtetra
0 .061 .606 r
.79594 .56454 .80021 .57303 .80458 .578 .80028 .56945 Mtetra
0 .092 .621 r
.80028 .56945 .80458 .578 .80891 .58248 .80457 .57388 Mtetra
.136 .184 .649 r
.80457 .57388 .80891 .58248 .81297 .58529 .80861 .57664 Mtetra
.345 .288 .65 r
.80861 .57664 .81297 .58529 .81659 .58549 .8122 .57682 Mtetra
.505 .362 .621 r
.8122 .57682 .81659 .58549 .81967 .58265 .81527 .57398 Mtetra
.6 .403 .586 r
.81527 .57398 .81967 .58265 .82221 .57687 .81782 .56823 Mtetra
.65 .423 .562 r
.81782 .56823 .82221 .57687 .82433 .56882 .81993 .56021 Mtetra
.672 .431 .549 r
.81993 .56021 .82433 .56882 .8262 .55954 .82181 .55099 Mtetra
.672 .432 .549 r
.82181 .55099 .8262 .55954 .82805 .5503 .82367 .5418 Mtetra
.651 .424 .561 r
.82367 .5418 .82805 .5503 .83013 .54232 .82575 .53386 Mtetra
.602 .404 .586 r
.82575 .53386 .83013 .54232 .83263 .53658 .82825 .52814 Mtetra
.508 .365 .621 r
.82825 .52814 .83263 .53658 .83568 .53369 .83129 .52525 Mtetra
.354 .295 .652 r
.83129 .52525 .83568 .53369 .83933 .53376 .83492 .5253 Mtetra
.153 .198 .656 r
.83492 .5253 .83933 .53376 .84352 .53642 .83908 .52792 Mtetra
0 .11 .632 r
.83908 .52792 .84352 .53642 .8481 .54088 .84363 .53233 Mtetra
0 .076 .617 r
.84363 .53233 .8481 .54088 .85286 .54601 .84834 .53739 Mtetra
0 .111 .632 r
.84834 .53739 .85286 .54601 .85753 .55053 .85298 .54186 Mtetra
.155 .199 .656 r
.85298 .54186 .85753 .55053 .86187 .55327 .85728 .54455 Mtetra
.354 .294 .651 r
.85728 .54455 .86187 .55327 .86567 .55334 .86106 .5446 Mtetra
.507 .362 .619 r
.86106 .5446 .86567 .55334 .86884 .55034 .86421 .54161 Mtetra
.599 .4 .584 r
.86421 .54161 .86884 .55034 .87138 .54445 .86676 .53574 Mtetra
.647 .419 .559 r
.86676 .53574 .87138 .54445 .87344 .53637 .86882 .5277 Mtetra
.667 .426 .546 r
.86882 .5277 .87344 .53637 .87524 .52719 .87063 .51857 Mtetra
.666 .426 .548 r
.87063 .51857 .87524 .52719 .87706 .51816 .87245 .5096 Mtetra
.641 .417 .562 r
.87245 .5096 .87706 .51816 .87916 .51051 .87456 .50198 Mtetra
.586 .396 .59 r
.87456 .50198 .87916 .51051 .88178 .50518 .87717 .49667 Mtetra
.486 .355 .627 r
.87717 .49667 .88178 .50518 .88505 .50273 .88043 .49422 Mtetra
.326 .284 .657 r
.88043 .49422 .88505 .50273 .88902 .50324 .88437 .4947 Mtetra
.133 .192 .659 r
.88437 .4947 .88902 .50324 .8936 .50629 .88892 .4977 Mtetra
0 .116 .638 r
.88892 .4977 .8936 .50629 .89862 .51103 .8939 .50239 Mtetra
0 .092 .628 r
.8939 .50239 .89862 .51103 .90381 .51633 .89905 .50762 Mtetra
.009 .13 .643 r
.89905 .50762 .90381 .51633 .90887 .52089 .90407 .51213 Mtetra
.174 .212 .661 r
.90407 .51213 .90887 .52089 .91351 .52356 .90867 .51475 Mtetra
.362 .3 .652 r
.90867 .51475 .91351 .52356 .91751 .5235 .91265 .51466 Mtetra
.508 .362 .618 r
.91265 .51466 .91751 .5235 .92077 .52034 .91589 .51151 Mtetra
.597 .397 .581 r
.91589 .51151 .92077 .52034 .92332 .51433 .91844 .50553 Mtetra
.644 .414 .555 r
.91844 .50553 .92332 .51433 .92533 .50621 .92045 .49745 Mtetra
.663 .421 .544 r
.92045 .49745 .92533 .50621 .92707 .4971 .9222 .48839 Mtetra
.659 .419 .546 r
.9222 .48839 .92707 .4971 .92886 .48828 .924 .47962 Mtetra
.631 .41 .564 r
.924 .47962 .92886 .48828 .93102 .48095 .92616 .47232 Mtetra
.57 .387 .595 r
.92616 .47232 .93102 .48095 .93379 .47602 .92893 .46741 Mtetra
.462 .345 .634 r
.92893 .46741 .93379 .47602 .93733 .47402 .93245 .4654 Mtetra
.3 .275 .663 r
.93245 .4654 .93733 .47402 .94168 .47496 .93677 .46631 Mtetra
.118 .19 .663 r
.93677 .46631 .94168 .47496 .94672 .4784 .94177 .4697 Mtetra
0 .125 .645 r
.94177 .4697 .94672 .4784 .95224 .48344 .94724 .47468 Mtetra
0 .109 .639 r
.94724 .47468 .95224 .48344 .95792 .48891 .95288 .48008 Mtetra
.032 .147 .653 r
.95288 .48008 .95792 .48891 .96341 .49353 .95833 .48464 Mtetra
.191 .224 .666 r
.95833 .48464 .96341 .49353 .96839 .49614 .96327 .4872 Mtetra
.37 .304 .652 r
.96327 .4872 .96839 .49614 .97261 .49593 .96747 .48697 Mtetra
.654 .475 .63 r
.51537 .86666 .51861 .87276 .52121 .86757 .51797 .86148 Mtetra
.711 .496 .596 r
.51797 .86148 .52121 .86757 .52376 .85938 .52052 .85331 Mtetra
.736 .505 .578 r
.52052 .85331 .52376 .85938 .52627 .84906 .52303 .84303 Mtetra
.745 .507 .572 r
.52303 .84303 .52627 .84906 .52874 .83785 .52552 .83185 Mtetra
.741 .506 .574 r
.52552 .83185 .52874 .83785 .53121 .8271 .52799 .82114 Mtetra
.724 .501 .587 r
.52799 .82114 .53121 .8271 .53369 .81808 .53048 .81214 Mtetra
.684 .487 .614 r
.53048 .81214 .53369 .81808 .53622 .81172 .533 .8058 Mtetra
.591 .451 .659 r
.533 .8058 .53622 .81172 .53881 .8085 .53559 .80258 Mtetra
.368 .351 .709 r
.53559 .80258 .53881 .8085 .54147 .80839 .53824 .80246 Mtetra
0 .126 .66 r
.53824 .80246 .54147 .80839 .54421 .81083 .54097 .80488 Mtetra
0 0 .504 r
.54097 .80488 .54421 .81083 .54701 .81483 .54375 .80885 Mtetra
0 0 .47 r
.54375 .80885 .54701 .81483 .54984 .81912 .54656 .81311 Mtetra
0 .03 .6 r
.54656 .81311 .54984 .81912 .55266 .82235 .54936 .81631 Mtetra
.223 .278 .71 r
.54936 .81631 .55266 .82235 .55543 .82334 .55212 .81729 Mtetra
.525 .422 .68 r
.55212 .81729 .55543 .82334 .55812 .82133 .5548 .81527 Mtetra
.655 .475 .628 r
.5548 .81527 .55812 .82133 .5607 .81607 .55739 .81003 Mtetra
.711 .495 .594 r
.55739 .81003 .5607 .81607 .56318 .80795 .55987 .80192 Mtetra
.735 .503 .576 r
.55987 .80192 .56318 .80795 .56558 .79784 .56228 .79185 Mtetra
.743 .505 .57 r
.56228 .79185 .56558 .79784 .56794 .78698 .56464 .78102 Mtetra
.738 .504 .574 r
.56464 .78102 .56794 .78698 .5703 .77671 .56701 .77078 Mtetra
.718 .497 .589 r
.56701 .77078 .5703 .77671 .57271 .76823 .56943 .76233 Mtetra
.672 .482 .62 r
.56943 .76233 .57271 .76823 .57522 .76243 .57194 .75654 Mtetra
.565 .441 .669 r
.57194 .75654 .57522 .76243 .57786 .75973 .57457 .75385 Mtetra
.317 .329 .715 r
.57457 .75385 .57786 .75973 .58064 .76005 .57734 .75415 Mtetra
0 .105 .65 r
.57734 .75415 .58064 .76005 .58354 .76279 .58023 .75687 Mtetra
0 0 .512 r
.58023 .75687 .58354 .76279 .58653 .76695 .58319 .761 Mtetra
0 0 .497 r
.58319 .761 .58653 .76695 .58955 .77126 .58619 .76527 Mtetra
0 .063 .624 r
.58619 .76527 .58955 .77126 .59253 .77441 .58916 .7684 Mtetra
.247 .294 .714 r
.58916 .7684 .59253 .77441 .59542 .77527 .59203 .76924 Mtetra
.531 .426 .679 r
.59203 .76924 .59542 .77527 .59816 .77312 .59477 .76709 Mtetra
.656 .475 .627 r
.59477 .76709 .59816 .77312 .60073 .7678 .59734 .76178 Mtetra
.711 .493 .592 r
.59734 .76178 .60073 .7678 .60315 .75972 .59976 .75372 Mtetra
.735 .5 .574 r
.59976 .75372 .60315 .75972 .60544 .7498 .60206 .74384 Mtetra
.741 .502 .568 r
.60206 .74384 .60544 .7498 .60769 .73927 .60432 .73334 Mtetra
.735 .501 .573 r
.60432 .73334 .60769 .73927 .60996 .72944 .60659 .72354 Mtetra
.712 .494 .592 r
.60659 .72354 .60996 .72944 .61232 .72148 .60896 .7156 Mtetra
.658 .476 .626 r
.60896 .7156 .61232 .72148 .61485 .71621 .61149 .71035 Mtetra
.536 .429 .68 r
.61149 .71035 .61485 .71621 .61757 .71401 .6142 .70814 Mtetra
.265 .306 .718 r
.6142 .70814 .61757 .71401 .62049 .71474 .61711 .70886 Mtetra
0 .089 .642 r
.61711 .70886 .62049 .71474 .62358 .71777 .62018 .71186 Mtetra
0 0 .522 r
.62018 .71186 .62358 .71777 .62678 .72208 .62336 .71614 Mtetra
0 0 .524 r
.62336 .71614 .62678 .72208 .63 .72641 .62657 .72044 Mtetra
0 .094 .645 r
.62657 .72044 .63 .72641 .63316 .72948 .62971 .72348 Mtetra
.269 .307 .718 r
.62971 .72348 .63316 .72948 .63617 .7302 .6327 .72419 Mtetra
.536 .428 .678 r
.6327 .72419 .63617 .7302 .63897 .72792 .63549 .7219 Mtetra
.657 .474 .625 r
.63549 .7219 .63897 .72792 .64153 .72252 .63806 .71652 Mtetra
.711 .491 .59 r
.63806 .71652 .64153 .72252 .64388 .71448 .64041 .7085 Mtetra
.734 .498 .571 r
.64041 .7085 .64388 .71448 .64608 .70473 .64262 .69879 Mtetra
.74 .5 .566 r
.64262 .69879 .64608 .70473 .64823 .69451 .64478 .6886 Mtetra
.731 .497 .574 r
.64478 .6886 .64823 .69451 .65042 .6851 .64698 .67922 Mtetra
.704 .489 .595 r
.64698 .67922 .65042 .6851 .65277 .67763 .64932 .67177 Mtetra
.642 .469 .634 r
.64932 .67177 .65277 .67763 .65533 .67287 .65188 .66702 Mtetra
.504 .416 .69 r
.65188 .66702 .65533 .67287 .65816 .67114 .65471 .66528 Mtetra
.213 .284 .72 r
.65471 .66528 .65816 .67114 .66125 .67227 .65778 .66639 Mtetra
0 .079 .637 r
.65778 .66639 .66125 .67227 .66456 .67558 .66107 .66967 Mtetra
0 0 .536 r
.66107 .66967 .66456 .67558 .668 .68004 .66449 .6741 Mtetra
0 0 .551 r
.66449 .6741 .668 .68004 .67145 .68439 .66792 .67842 Mtetra
0 .122 .663 r
.66792 .67842 .67145 .68439 .6748 .68738 .67125 .68138 Mtetra
.289 .32 .72 r
.67125 .68138 .6748 .68738 .67794 .68797 .67438 .68195 Mtetra
.541 .43 .677 r
.67438 .68195 .67794 .68797 .6808 .68555 .67723 .67953 Mtetra
.658 .473 .623 r
.67723 .67953 .6808 .68555 .68335 .68008 .67979 .67407 Mtetra
.71 .489 .587 r
.67979 .67407 .68335 .68008 .68564 .67206 .68208 .66608 Mtetra
.733 .495 .569 r
.68208 .66608 .68564 .67206 .68776 .66247 .6842 .65652 Mtetra
.737 .496 .565 r
.6842 .65652 .68776 .66247 .68981 .65253 .68627 .64661 Mtetra
.727 .494 .574 r
.68627 .64661 .68981 .65253 .69195 .64352 .68841 .63763 Mtetra
.695 .485 .599 r
.68841 .63763 .69195 .64352 .69429 .63651 .69075 .63064 Mtetra
.624 .462 .642 r
.69075 .63064 .69429 .63651 .69692 .63224 .69338 .62638 Mtetra
.468 .403 .7 r
.69338 .62638 .69692 .63224 .6999 .63097 .69634 .6251 Mtetra
.165 .263 .72 r
.69634 .6251 .6999 .63097 .70319 .63248 .69963 .62659 Mtetra
0 .074 .634 r
.69963 .62659 .70319 .63248 .70675 .63606 .70316 .63014 Mtetra
0 0 .552 r
.70316 .63014 .70675 .63606 .71045 .64067 .70684 .63472 Mtetra
0 0 .577 r
.70684 .63472 .71045 .64067 .71416 .64505 .71053 .63906 Mtetra
0 .149 .68 r
.71053 .63906 .71416 .64505 .71772 .64796 .71407 .64194 Mtetra
.307 .331 .722 r
.71407 .64194 .71772 .64796 .721 .64841 .71734 .64238 Mtetra
.545 .432 .676 r
.71734 .64238 .721 .64841 .72392 .64586 .72025 .63982 Mtetra
.658 .472 .621 r
.72025 .63982 .72392 .64586 .72647 .6403 .7228 .63428 Mtetra
.71 .487 .585 r
.7228 .63428 .72647 .6403 .7287 .63229 .72503 .6263 Mtetra
.731 .492 .566 r
.72503 .6263 .7287 .63229 .73073 .62284 .72707 .61687 Mtetra
.735 .493 .563 r
.72707 .61687 .73073 .62284 .73271 .61317 .72906 .60723 Mtetra
.721 .49 .575 r
.72906 .60723 .73271 .61317 .73481 .60453 .73116 .59862 Mtetra
.685 .48 .603 r
.73116 .59862 .73481 .60453 .73717 .59797 .73353 .59208 Mtetra
.604 .455 .652 r
.73353 .59208 .73717 .59797 .73991 .59417 .73626 .58828 Mtetra
.43 .388 .71 r
.73626 .58828 .73991 .59417 .74305 .59335 .73939 .58745 Mtetra
.12 .244 .719 r
.73939 .58745 .74305 .59335 .74659 .59523 .74292 .58931 Mtetra
0 .074 .635 r
.74292 .58931 .74659 .59523 .75044 .59909 .74674 .59314 Mtetra
0 0 .569 r
.74674 .59314 .75044 .59909 .75444 .60384 .75072 .59786 Mtetra
0 .029 .601 r
.75072 .59786 .75444 .60384 .75843 .60825 .75468 .60223 Mtetra
0 .174 .693 r
.75468 .60223 .75843 .60825 .76221 .61108 .75844 .60504 Mtetra
.323 .34 .724 r
.75844 .60504 .76221 .61108 .76564 .6114 .76186 .60534 Mtetra
.549 .433 .674 r
.76186 .60534 .76564 .6114 .76863 .6087 .76485 .60264 Mtetra
.659 .47 .618 r
.76485 .60264 .76863 .6087 .77118 .60305 .76739 .597 Mtetra
.709 .484 .582 r
.76739 .597 .77118 .60305 .77335 .59505 .76957 .58902 Mtetra
.73 .489 .564 r
.76957 .58902 .77335 .59505 .7753 .58571 .77153 .57972 Mtetra
.731 .49 .562 r
.77153 .57972 .7753 .58571 .77722 .57629 .77345 .57033 Mtetra
.715 .486 .576 r
.77345 .57033 .77722 .57629 .7793 .56801 .77553 .56207 Mtetra
.673 .475 .609 r
.77553 .56207 .7793 .56801 .78171 .56188 .77795 .55596 Mtetra
.581 .446 .662 r
.77795 .55596 .78171 .56188 .78458 .55854 .78081 .55262 Mtetra
.391 .372 .719 r
.78081 .55262 .78458 .55854 .78794 .55816 .78416 .55222 Mtetra
.081 .228 .717 r
.78416 .55222 .78794 .55816 .79177 .56041 .78797 .55445 Mtetra
0 .077 .638 r
.78797 .55445 .79177 .56041 .79594 .56454 .79212 .55855 Mtetra
0 .014 .588 r
.79212 .55855 .79594 .56454 .80028 .56945 .79643 .56342 Mtetra
0 .058 .624 r
.79643 .56342 .80028 .56945 .80457 .57388 .8007 .56781 Mtetra
.021 .197 .705 r
.8007 .56781 .80457 .57388 .80861 .57664 .80471 .57055 Mtetra
.337 .348 .725 r
.80471 .57055 .80861 .57664 .8122 .57682 .80829 .57071 Mtetra
.552 .434 .673 r
.80829 .57071 .8122 .57682 .81527 .57398 .81136 .56787 Mtetra
.659 .469 .616 r
.81136 .56787 .81527 .57398 .81782 .56823 .8139 .56213 Mtetra
.708 .482 .579 r
.8139 .56213 .81782 .56823 .81993 .56021 .81602 .55414 Mtetra
.728 .486 .561 r
.81602 .55414 .81993 .56021 .82181 .55099 .8179 .54494 Mtetra
.8179 .54494 .82181 .55099 .82367 .5418 .81977 .53579 Mtetra
.709 .482 .578 r
.81977 .53579 .82367 .5418 .82575 .53386 .82186 .52787 Mtetra
.66 .469 .616 r
.82186 .52787 .82575 .53386 .82825 .52814 .82436 .52217 Mtetra
.556 .437 .672 r
.82436 .52217 .82825 .52814 .83129 .52525 .82739 .51927 Mtetra
.35 .357 .726 r
.82739 .51927 .83129 .52525 .83492 .5253 .831 .51931 Mtetra
.049 .215 .715 r
.831 .51931 .83492 .5253 .83908 .52792 .83514 .52191 Mtetra
0 .084 .643 r
.83514 .52191 .83908 .52792 .84363 .53233 .83966 .52627 Mtetra
0 .037 .606 r
.83966 .52627 .84363 .53233 .84834 .53739 .84435 .5313 Mtetra
0 .086 .645 r
.84435 .5313 .84834 .53739 .85298 .54186 .84896 .53573 Mtetra
.053 .217 .715 r
.84896 .53573 .85298 .54186 .85728 .54455 .85324 .53839 Mtetra
.35 .356 .725 r
.85324 .53839 .85728 .54455 .86106 .5446 .85701 .53842 Mtetra
.554 .434 .671 r
.85701 .53842 .86106 .5446 .86421 .54161 .86015 .53543 Mtetra
.658 .467 .614 r
.86015 .53543 .86421 .54161 .86676 .53574 .86269 .52958 Mtetra
.707 .478 .576 r
.86269 .52958 .86676 .53574 .86882 .5277 .86476 .52156 Mtetra
.725 .482 .559 r
.86476 .52156 .86882 .5277 .87063 .51857 .86658 .51246 Mtetra
.724 .482 .561 r
.86658 .51246 .87063 .51857 .87245 .5096 .86841 .50352 Mtetra
.701 .477 .581 r
.86841 .50352 .87245 .5096 .87456 .50198 .87052 .49593 Mtetra
.645 .463 .623 r
.87052 .49593 .87456 .50198 .87717 .49667 .87313 .49063 Mtetra
.528 .427 .683 r
.87313 .49063 .87717 .49667 .88043 .49422 .87638 .48817 Mtetra
.31 .341 .732 r
.87638 .48817 .88043 .49422 .88437 .4947 .88031 .48864 Mtetra
.023 .206 .714 r
.88031 .48864 .88437 .4947 .88892 .4977 .88483 .49161 Mtetra
0 .094 .651 r
.88483 .49161 .88892 .4977 .8939 .50239 .88978 .49625 Mtetra
0 .06 .625 r
.88978 .49625 .8939 .50239 .89905 .50762 .89489 .50144 Mtetra
0 .113 .664 r
.89489 .50144 .89905 .50762 .90407 .51213 .89988 .50591 Mtetra
.083 .236 .724 r
.89988 .50591 .90407 .51213 .90867 .51475 .90447 .50851 Mtetra
.362 .362 .725 r
.90447 .50851 .90867 .51475 .91265 .51466 .90843 .5084 Mtetra
.556 .434 .669 r
.90843 .5084 .91265 .51466 .91589 .51151 .91166 .50525 Mtetra
.658 .464 .611 r
.91166 .50525 .91589 .51151 .91844 .50553 .91421 .49928 Mtetra
.705 .475 .573 r
.91421 .49928 .91844 .50553 .92045 .49745 .91623 .49123 Mtetra
.722 .478 .556 r
.91623 .49123 .92045 .49745 .9222 .48839 .91799 .4822 Mtetra
.719 .478 .56 r
.91799 .4822 .9222 .48839 .924 .47962 .91979 .47346 Mtetra
.692 .472 .585 r
.91979 .47346 .924 .47962 .92616 .47232 .92196 .46618 Mtetra
.628 .457 .632 r
.92196 .46618 .92616 .47232 .92893 .46741 .92472 .46128 Mtetra
.498 .416 .694 r
.92472 .46128 .92893 .46741 .93245 .4654 .92824 .45926 Mtetra
.272 .327 .737 r
.92824 .45926 .93245 .4654 .93677 .46631 .93253 .46016 Mtetra
.004 .201 .714 r
.93253 .46016 .93677 .46631 .94177 .4697 .93751 .46351 Mtetra
0 .106 .66 r
.93751 .46351 .94177 .4697 .94724 .47468 .94294 .46844 Mtetra
0 .083 .643 r
.94294 .46844 .94724 .47468 .95288 .48008 .94854 .4738 Mtetra
0 .138 .681 r
.94854 .4738 .95288 .48008 .95833 .48464 .95396 .47832 Mtetra
.11 .253 .731 r
.95396 .47832 .95833 .48464 .96327 .4872 .95888 .48085 Mtetra
.372 .368 .725 r
.95888 .48085 .96327 .4872 .96747 .48697 .96306 .48061 Mtetra
.754 .597 .682 r
.51216 .86384 .51537 .86666 .51797 .86148 .51476 .85866 Mtetra
.792 .584 .62 r
.51476 .85866 .51797 .86148 .52052 .85331 .51732 .8505 Mtetra
.805 .577 .592 r
.51732 .8505 .52052 .85331 .52303 .84303 .51985 .84022 Mtetra
.81 .575 .582 r
.51985 .84022 .52303 .84303 .52552 .83185 .52234 .82905 Mtetra
.808 .576 .586 r
.52234 .82905 .52552 .83185 .52799 .82114 .52483 .81834 Mtetra
.799 .581 .606 r
.52483 .81834 .52799 .82114 .53048 .81214 .52732 .80935 Mtetra
.775 .591 .65 r
.52732 .80935 .53048 .81214 .533 .8058 .52985 .80301 Mtetra
.697 .603 .747 r
.52985 .80301 .533 .8058 .53559 .80258 .53243 .79979 Mtetra
.348 .53 .893 r
.53243 .79979 .53559 .80258 .53824 .80246 .53509 .79966 Mtetra
.47 0 0 r
.53509 .79966 .53824 .80246 .54097 .80488 .5378 .80207 Mtetra
.721 .198 0 r
.5378 .80207 .54097 .80488 .54375 .80885 .54057 .80603 Mtetra
.742 .224 0 r
.54057 .80603 .54375 .80885 .54656 .81311 .54337 .81028 Mtetra
.62 .088 0 r
.54337 .81028 .54656 .81311 .54936 .81631 .54616 .81347 Mtetra
.02 .38 .843 r
.54616 .81347 .54936 .81631 .55212 .81729 .54892 .81445 Mtetra
.621 .6 .808 r
.54892 .81445 .55212 .81729 .5548 .81527 .55159 .81243 Mtetra
.756 .597 .679 r
.55159 .81243 .5548 .81527 .55739 .81003 .55418 .80718 Mtetra
.794 .584 .618 r
.55418 .80718 .55739 .81003 .55987 .80192 .55667 .79908 Mtetra
.807 .577 .59 r
.55667 .79908 .55987 .80192 .56228 .79185 .55909 .78901 Mtetra
.811 .575 .581 r
.55909 .78901 .56228 .79185 .56464 .78102 .56146 .7782 Mtetra
.809 .576 .587 r
.56146 .7782 .56464 .78102 .56701 .77078 .56384 .76796 Mtetra
.798 .582 .61 r
.56384 .76796 .56701 .77078 .56943 .76233 .56626 .75952 Mtetra
.768 .593 .662 r
.56626 .75952 .56943 .76233 .57194 .75654 .56878 .75373 Mtetra
.669 .603 .772 r
.56878 .75373 .57194 .75654 .57457 .75385 .57141 .75103 Mtetra
.238 .485 .891 r
.57141 .75103 .57457 .75385 .57734 .75415 .57417 .75133 Mtetra
.505 0 0 r
.57417 .75133 .57734 .75415 .58023 .75687 .57705 .75404 Mtetra
.71 .186 0 r
.57705 .75404 .58023 .75687 .58319 .761 .58001 .75815 Mtetra
.72 .197 0 r
.58001 .75815 .58319 .761 .58619 .76527 .58299 .76242 Mtetra
.573 .043 0 r
.58299 .76242 .58619 .76527 .58916 .7684 .58595 .76553 Mtetra
.08 .411 .862 r
.58595 .76553 .58916 .7684 .59203 .76924 .58882 .76637 Mtetra
.628 .601 .803 r
.58882 .76637 .59203 .76924 .59477 .76709 .59155 .76422 Mtetra
.758 .596 .677 r
.59155 .76422 .59477 .76709 .59734 .76178 .59412 .75891 Mtetra
.795 .584 .616 r
.59412 .75891 .59734 .76178 .59976 .75372 .59655 .75086 Mtetra
.809 .577 .588 r
.59655 .75086 .59976 .75372 .60206 .74384 .59886 .74097 Mtetra
.812 .575 .579 r
.59886 .74097 .60206 .74384 .60432 .73334 .60113 .73049 Mtetra
.809 .577 .587 r
.60113 .73049 .60432 .73334 .60659 .72354 .60341 .7207 Mtetra
.796 .584 .615 r
.60341 .7207 .60659 .72354 .60896 .7156 .60579 .71276 Mtetra
.759 .596 .676 r
.60579 .71276 .60896 .7156 .61149 .71035 .60832 .70751 Mtetra
.633 .601 .799 r
.60832 .70751 .61149 .71035 .6142 .70814 .61103 .7053 Mtetra
.126 .432 .872 r
.61103 .7053 .6142 .70814 .61711 .70886 .61393 .706 Mtetra
.527 .002 0 r
.61393 .706 .61711 .70886 .62018 .71186 .61699 .709 Mtetra
.696 .17 0 r
.61699 .709 .62018 .71186 .62336 .71614 .62015 .71327 Mtetra
.694 .168 0 r
.62015 .71327 .62336 .71614 .62657 .72044 .62335 .71756 Mtetra
.52 0 0 r
.62335 .71756 .62657 .72044 .62971 .72348 .62648 .72059 Mtetra
.134 .436 .874 r
.62648 .72059 .62971 .72348 .6327 .72419 .62947 .72129 Mtetra
.635 .601 .799 r
.62947 .72129 .6327 .72419 .63549 .7219 .63226 .719 Mtetra
.76 .596 .675 r
.63226 .719 .63549 .7219 .63806 .71652 .63482 .71362 Mtetra
.797 .584 .613 r
.63482 .71362 .63806 .71652 .64041 .7085 .63718 .7056 Mtetra
.81 .577 .585 r
.63718 .7056 .64041 .7085 .64262 .69879 .6394 .69589 Mtetra
.814 .575 .578 r
.6394 .69589 .64262 .69879 .64478 .6886 .64157 .68571 Mtetra
.809 .578 .588 r
.64157 .68571 .64478 .6886 .64698 .67922 .64378 .67634 Mtetra
.793 .586 .621 r
.64378 .67634 .64698 .67922 .64932 .67177 .64613 .66889 Mtetra
.747 .599 .692 r
.64613 .66889 .64932 .67177 .65188 .66702 .64869 .66414 Mtetra
.588 .594 .826 r
.64869 .66414 .65188 .66702 .65471 .66528 .65151 .6624 Mtetra
.021 .377 .842 r
.65151 .6624 .65471 .66528 .65778 .66639 .65458 .6635 Mtetra
.537 .013 0 r
.65458 .6635 .65778 .66639 .66107 .66967 .65786 .66677 Mtetra
.678 .151 0 r
.65786 .66677 .66107 .66967 .66449 .6741 .66126 .67119 Mtetra
.664 .136 0 r
.66126 .67119 .66449 .6741 .66792 .67842 .66468 .6755 Mtetra
0 .05 .535 r
.66468 .6755 .66792 .67842 .67125 .68138 .668 .67845 Mtetra
.181 .458 .882 r
.668 .67845 .67125 .68138 .67438 .68195 .67112 .67901 Mtetra
.64 .602 .795 r
.67112 .67901 .67438 .68195 .67723 .67953 .67397 .67659 Mtetra
.762 .597 .673 r
.67397 .67659 .67723 .67953 .67979 .67407 .67653 .67113 Mtetra
.799 .584 .61 r
.67653 .67113 .67979 .67407 .68208 .66608 .67883 .66314 Mtetra
.812 .577 .583 r
.67883 .66314 .68208 .66608 .6842 .65652 .68096 .65359 Mtetra
.815 .575 .577 r
.68096 .65359 .6842 .65652 .68627 .64661 .68303 .64369 Mtetra
.809 .579 .59 r
.68303 .64369 .68627 .64661 .68841 .63763 .68519 .63471 Mtetra
.789 .588 .629 r
.68519 .63471 .68841 .63763 .69075 .63064 .68754 .62773 Mtetra
.732 .601 .711 r
.68754 .62773 .69075 .63064 .69338 .62638 .69017 .62346 Mtetra
.532 .583 .851 r
.69017 .62346 .69338 .62638 .69634 .6251 .69312 .62218 Mtetra
0 .325 .806 r
.69312 .62218 .69634 .6251 .69963 .62659 .6964 .62366 Mtetra
.54 .016 0 r
.6964 .62366 .69963 .62659 .70316 .63014 .69992 .6272 Mtetra
.657 .129 0 r
.69992 .6272 .70316 .63014 .70684 .63472 .70359 .63176 Mtetra
.63 .102 0 r
.70359 .63176 .70684 .63472 .71053 .63906 .70726 .63609 Mtetra
0 .096 .589 r
.70726 .63609 .71053 .63906 .71407 .64194 .71078 .63897 Mtetra
.221 .475 .887 r
.71078 .63897 .71407 .64194 .71734 .64238 .71404 .6394 Mtetra
.646 .602 .791 r
.71404 .6394 .71734 .64238 .72025 .63982 .71696 .63684 Mtetra
.764 .597 .67 r
.71696 .63684 .72025 .63982 .7228 .63428 .71951 .63129 Mtetra
.801 .584 .608 r
.71951 .63129 .7228 .63428 .72503 .6263 .72175 .62331 Mtetra
.814 .577 .58 r
.72175 .62331 .72503 .6263 .72707 .61687 .7238 .6139 Mtetra
.816 .576 .576 r
.7238 .6139 .72707 .61687 .72906 .60723 .7258 .60427 Mtetra
.808 .58 .593 r
.7258 .60427 .72906 .60723 .73116 .59862 .72791 .59566 Mtetra
.784 .591 .639 r
.72791 .59566 .73116 .59862 .73353 .59208 .73028 .58912 Mtetra
.713 .603 .732 r
.73028 .58912 .73353 .59208 .73626 .58828 .73301 .58532 Mtetra
.466 .565 .872 r
.73301 .58532 .73626 .58828 .73939 .58745 .73614 .58449 Mtetra
0 .279 .771 r
.73614 .58449 .73939 .58745 .74292 .58931 .73965 .58634 Mtetra
.535 .013 0 r
.73965 .58634 .74292 .58931 .74674 .59314 .74346 .59015 Mtetra
.632 .104 0 r
.74346 .59015 .74674 .59314 .75072 .59786 .74743 .59486 Mtetra
.592 .065 0 r
.74743 .59486 .75072 .59786 .75468 .60223 .75137 .59921 Mtetra
0 .14 .638 r
.75137 .59921 .75468 .60223 .75844 .60504 .75512 .60201 Mtetra
.257 .49 .89 r
.75512 .60201 .75844 .60504 .76186 .60534 .75853 .6023 Mtetra
.65 .603 .788 r
.75853 .6023 .76186 .60534 .76485 .60264 .76152 .5996 Mtetra
.766 .597 .668 r
.76152 .5996 .76485 .60264 .76739 .597 .76406 .59396 Mtetra
.803 .584 .605 r
.76406 .59396 .76739 .597 .76957 .58902 .76625 .58599 Mtetra
.816 .577 .578 r
.76625 .58599 .76957 .58902 .77153 .57972 .76822 .57669 Mtetra
.817 .577 .575 r
.76822 .57669 .77153 .57972 .77345 .57033 .77015 .56731 Mtetra
.807 .582 .596 r
.77015 .56731 .77345 .57033 .77553 .56207 .77224 .55906 Mtetra
.778 .594 .65 r
.77224 .55906 .77553 .56207 .77795 .55596 .77466 .55295 Mtetra
.689 .604 .756 r
.77466 .55295 .77795 .55596 .78081 .55262 .77752 .5496 Mtetra
.392 .541 .885 r
.77752 .5496 .78081 .55262 .78416 .55222 .78087 .5492 Mtetra
0 .244 .74 r
.78087 .5492 .78416 .55222 .78797 .55445 .78467 .55142 Mtetra
.525 .005 0 r
.78467 .55142 .78797 .55445 .79212 .55855 .7888 .5555 Mtetra
.604 .077 0 r
.7888 .5555 .79212 .55855 .79643 .56342 .7931 .56036 Mtetra
.551 .028 0 r
.7931 .56036 .79643 .56342 .8007 .56781 .79735 .56474 Mtetra
0 .182 .682 r
.79735 .56474 .8007 .56781 .80471 .57055 .80135 .56746 Mtetra
.288 .502 .89 r
.80135 .56746 .80471 .57055 .80829 .57071 .80492 .56762 Mtetra
.655 .603 .784 r
.80492 .56762 .80829 .57071 .81136 .56787 .80798 .56477 Mtetra
.768 .597 .666 r
.80798 .56477 .81136 .56787 .8139 .56213 .81053 .55903 Mtetra
.805 .584 .602 r
.81053 .55903 .8139 .56213 .81602 .55414 .81266 .55105 Mtetra
.818 .577 .575 r
.81266 .55105 .81602 .55414 .8179 .54494 .81455 .54186 Mtetra
.81455 .54186 .8179 .54494 .81977 .53579 .81643 .53271 Mtetra
.806 .584 .601 r
.81643 .53271 .81977 .53579 .82186 .52787 .81853 .5248 Mtetra
.769 .597 .664 r
.81853 .5248 .82186 .52787 .82436 .52217 .82102 .5191 Mtetra
.659 .603 .781 r
.82102 .5191 .82436 .52217 .82739 .51927 .82406 .5162 Mtetra
.314 .512 .89 r
.82406 .5162 .82739 .51927 .831 .51931 .82766 .51623 Mtetra
0 .217 .717 r
.82766 .51623 .831 .51931 .83514 .52191 .83179 .51881 Mtetra
.509 0 0 r
.83179 .51881 .83514 .52191 .83966 .52627 .83629 .52317 Mtetra
.572 .048 0 r
.83629 .52317 .83966 .52627 .84435 .5313 .84096 .52817 Mtetra
.506 0 0 r
.84096 .52817 .84435 .5313 .84896 .53573 .84556 .53259 Mtetra
0 .22 .72 r
.84556 .53259 .84896 .53573 .85324 .53839 .84983 .53524 Mtetra
.314 .512 .89 r
.84983 .53524 .85324 .53839 .85701 .53842 .85358 .53526 Mtetra
.659 .604 .782 r
.85358 .53526 .85701 .53842 .86015 .53543 .85672 .53227 Mtetra
.771 .597 .664 r
.85672 .53227 .86015 .53543 .86269 .52958 .85927 .52642 Mtetra
.808 .584 .599 r
.85927 .52642 .86269 .52958 .86476 .52156 .86135 .51841 Mtetra
.82 .578 .573 r
.86135 .51841 .86476 .52156 .86658 .51246 .86317 .50931 Mtetra
.819 .578 .575 r
.86317 .50931 .86658 .51246 .86841 .50352 .86502 .50037 Mtetra
.804 .586 .607 r
.86502 .50037 .86841 .50352 .87052 .49593 .86713 .49279 Mtetra
.758 .6 .681 r
.86713 .49279 .87052 .49593 .87313 .49063 .86975 .48749 Mtetra
.621 .599 .807 r
.86975 .48749 .87313 .49063 .87638 .48817 .87299 .48503 Mtetra
.236 .478 .886 r
.87299 .48503 .87638 .48817 .88031 .48864 .87691 .48549 Mtetra
0 .199 .7 r
.87691 .48549 .88031 .48864 .88483 .49161 .88142 .48844 Mtetra
.489 0 0 r
.88142 .48844 .88483 .49161 .88978 .49625 .88635 .49307 Mtetra
.537 .017 0 r
.88635 .49307 .88978 .49625 .89489 .50144 .89145 .49824 Mtetra
0 .049 .54 r
.89145 .49824 .89489 .50144 .89988 .50591 .89642 .5027 Mtetra
0 .256 .752 r
.89642 .5027 .89988 .50591 .90447 .50851 .90099 .50528 Mtetra
.337 .521 .889 r
.90099 .50528 .90447 .50851 .90843 .5084 .90494 .50517 Mtetra
.662 .604 .779 r
.90494 .50517 .90843 .5084 .91166 .50525 .90818 .50201 Mtetra
.773 .598 .661 r
.90818 .50201 .91166 .50525 .91421 .49928 .91073 .49604 Mtetra
.81 .584 .596 r
.91073 .49604 .91421 .49928 .91623 .49123 .91275 .488 Mtetra
.822 .578 .57 r
.91275 .488 .91623 .49123 .91799 .4822 .91452 .47898 Mtetra
.819 .579 .576 r
.91452 .47898 .91799 .4822 .91979 .47346 .91634 .47024 Mtetra
.8 .589 .615 r
.91634 .47024 .91979 .47346 .92196 .46618 .91851 .46297 Mtetra
.744 .603 .7 r
.91851 .46297 .92196 .46618 .92472 .46128 .92127 .45807 Mtetra
.576 .592 .831 r
.92127 .45807 .92472 .46128 .92824 .45926 .92478 .45604 Mtetra
.164 .444 .876 r
.92478 .45604 .92824 .45926 .93253 .46016 .92907 .45693 Mtetra
0 .188 .691 r
.92907 .45693 .93253 .46016 .93751 .46351 .93403 .46026 Mtetra
0 .043 .534 r
.93403 .46026 .93751 .46351 .94294 .46844 .93945 .46518 Mtetra
.499 0 0 r
.93945 .46518 .94294 .46844 .94854 .4738 .94503 .47052 Mtetra
0 .088 .585 r
.94503 .47052 .94854 .4738 .95396 .47832 .95043 .47502 Mtetra
0 .287 .779 r
.95043 .47502 .95396 .47832 .95888 .48085 .95533 .47754 Mtetra
.357 .528 .888 r
.95533 .47754 .95888 .48085 .96306 .48061 .9595 .47729 Mtetra
.9 .795 .736 r
.50898 .86426 .51216 .86384 .51476 .85866 .51159 .85907 Mtetra
.896 .706 .638 r
.51159 .85907 .51476 .85866 .51732 .8505 .51416 .85089 Mtetra
.89 .671 .6 r
.51416 .85089 .51732 .8505 .51985 .84022 .5167 .84059 Mtetra
.887 .659 .587 r
.5167 .84059 .51985 .84022 .52234 .82905 .51921 .8294 Mtetra
.888 .664 .592 r
.51921 .8294 .52234 .82905 .52483 .81834 .52171 .81868 Mtetra
.893 .687 .618 r
.52171 .81868 .52483 .81834 .52732 .80935 .52421 .80967 Mtetra
.899 .747 .684 r
.52421 .80967 .52732 .80935 .52985 .80301 .52675 .80331 Mtetra
.861 .893 .857 r
.52675 .80331 .52985 .80301 .53243 .79979 .52934 .80009 Mtetra
0 0 0 r
.52934 .80009 .53243 .79979 .53509 .79966 .53199 .79996 Mtetra
.59 .065 0 r
.53199 .79996 .53509 .79966 .5378 .80207 .5347 .80238 Mtetra
.686 .208 .11 r
.5347 .80238 .5378 .80207 .54057 .80603 .53746 .80635 Mtetra
.696 .224 .127 r
.53746 .80635 .54057 .80603 .54337 .81028 .54025 .8106 Mtetra
.645 .144 .046 r
.54025 .8106 .54337 .81028 .54616 .81347 .54304 .8138 Mtetra
.365 0 0 r
.54304 .8138 .54616 .81347 .54892 .81445 .54579 .81478 Mtetra
.723 .956 .947 r
.54579 .81478 .54892 .81445 .55159 .81243 .54847 .81276 Mtetra
.902 .795 .732 r
.54847 .81276 .55159 .81243 .55418 .80718 .55106 .8075 Mtetra
.9 .709 .635 r
.55106 .8075 .55418 .80718 .55667 .79908 .55356 .79939 Mtetra
.894 .674 .597 r
.55356 .79939 .55667 .79908 .55909 .78901 .55599 .7893 Mtetra
.892 .664 .585 r
.55599 .7893 .55909 .78901 .56146 .7782 .55838 .77846 Mtetra
.894 .67 .592 r
.55838 .77846 .56146 .7782 .56384 .76796 .56077 .76821 Mtetra
.898 .698 .623 r
.56077 .76821 .56384 .76796 .56626 .75952 .56321 .75975 Mtetra
.902 .767 .703 r
.56321 .75975 .56626 .75952 .56878 .75373 .56573 .75395 Mtetra
.822 .926 .903 r
.56573 .75395 .56878 .75373 .57141 .75103 .56837 .75125 Mtetra
.152 0 0 r
.56837 .75125 .57141 .75103 .57417 .75133 .57113 .75155 Mtetra
.607 .082 0 r
.57113 .75155 .57417 .75133 .57705 .75404 .574 .75426 Mtetra
.688 .202 .09 r
.574 .75426 .57705 .75404 .58001 .75815 .57695 .75839 Mtetra
.692 .209 .098 r
.57695 .75839 .58001 .75815 .58299 .76242 .57993 .76266 Mtetra
.632 .118 .005 r
.57993 .76266 .58299 .76242 .58595 .76553 .58288 .76578 Mtetra
.315 0 0 r
.58288 .76578 .58595 .76553 .58882 .76637 .58574 .76662 Mtetra
.741 .953 .945 r
.58574 .76662 .58882 .76637 .59155 .76422 .58847 .76446 Mtetra
.905 .796 .729 r
.58847 .76446 .59155 .76422 .59412 .75891 .59105 .75914 Mtetra
.904 .712 .632 r
.59105 .75914 .59412 .75891 .59655 .75086 .59349 .75108 Mtetra
.899 .678 .593 r
.59349 .75108 .59655 .75086 .59886 .74097 .59582 .74118 Mtetra
.898 .668 .583 r
.59582 .74118 .59886 .74097 .60113 .73049 .5981 .73067 Mtetra
.899 .677 .593 r
.5981 .73067 .60113 .73049 .60341 .7207 .6004 .72086 Mtetra
.904 .71 .631 r
.6004 .72086 .60341 .7207 .60579 .71276 .60278 .71291 Mtetra
.904 .791 .726 r
.60278 .71291 .60579 .71276 .60832 .70751 .60532 .70765 Mtetra
.754 .945 .943 r
.60532 .70765 .60832 .70751 .61103 .7053 .60803 .70544 Mtetra
.268 0 0 r
.60803 .70544 .61103 .7053 .61393 .706 .61093 .70614 Mtetra
.619 .092 0 r
.61093 .70614 .61393 .706 .61699 .709 .61398 .70914 Mtetra
.687 .193 .068 r
.61398 .70914 .61699 .709 .62015 .71327 .61714 .71342 Mtetra
.686 .192 .066 r
.61714 .71342 .62015 .71327 .62335 .71756 .62033 .71772 Mtetra
.616 .088 0 r
.62033 .71772 .62335 .71756 .62648 .72059 .62346 .72075 Mtetra
.262 0 0 r
.62346 .72075 .62648 .72059 .62947 .72129 .62644 .72145 Mtetra
.756 .95 .941 r
.62644 .72145 .62947 .72129 .63226 .719 .62923 .71916 Mtetra
.909 .797 .725 r
.62923 .71916 .63226 .719 .63482 .71362 .6318 .71377 Mtetra
.909 .715 .628 r
.6318 .71377 .63482 .71362 .63718 .7056 .63418 .70574 Mtetra
.905 .682 .59 r
.63418 .70574 .63718 .7056 .6394 .69589 .63641 .69601 Mtetra
.903 .673 .58 r
.63641 .69601 .6394 .69589 .64157 .68571 .63859 .68581 Mtetra
.905 .685 .594 r
.63859 .68581 .64157 .68571 .64378 .67634 .64081 .67642 Mtetra
.909 .724 .64 r
.64081 .67642 .64378 .67634 .64613 .66889 .64317 .66896 Mtetra
.902 .819 .755 r
.64317 .66896 .64613 .66889 .64869 .66414 .64574 .6642 Mtetra
.647 .938 .965 r
.64574 .6642 .64869 .66414 .65151 .6624 .64856 .66247 Mtetra
.35 0 0 r
.64856 .66247 .65151 .6624 .65458 .6635 .65163 .66356 Mtetra
.627 .096 0 r
.65163 .66356 .65458 .6635 .65786 .66677 .6549 .66684 Mtetra
.684 .182 .042 r
.6549 .66684 .65786 .66677 .66126 .67119 .65829 .67127 Mtetra
.678 .172 .032 r
.65829 .67127 .66126 .67119 .66468 .6755 .66171 .67558 Mtetra
.598 .056 0 r
.66171 .67558 .66468 .6755 .668 .67845 .66502 .67854 Mtetra
.205 0 0 r
.66502 .67854 .668 .67845 .67112 .67901 .66814 .67911 Mtetra
.769 .947 .936 r
.66814 .67911 .67112 .67901 .67397 .67659 .67099 .67668 Mtetra
.913 .799 .721 r
.67099 .67668 .67397 .67659 .67653 .67113 .67355 .67121 Mtetra
.914 .718 .624 r
.67355 .67121 .67653 .67113 .67883 .66314 .67587 .66321 Mtetra
.91 .686 .586 r
.67587 .66321 .67883 .66314 .68096 .65359 .67801 .65363 Mtetra
.909 .679 .578 r
.67801 .65363 .68096 .65359 .68303 .64369 .6801 .64372 Mtetra
.912 .694 .596 r
.6801 .64372 .68303 .64369 .68519 .63471 .68226 .63472 Mtetra
.915 .741 .651 r
.68226 .63472 .68519 .63471 .68754 .62773 .68462 .62772 Mtetra
.896 .849 .789 r
.68462 .62772 .68754 .62773 .69017 .62346 .68726 .62345 Mtetra
.501 .892 .953 r
.68726 .62345 .69017 .62346 .69312 .62218 .69021 .62217 Mtetra
.408 0 0 r
.69021 .62217 .69312 .62218 .6964 .62366 .69348 .62365 Mtetra
.631 .096 0 r
.69348 .62365 .6964 .62366 .69992 .6272 .697 .6272 Mtetra
.68 .168 .013 r
.697 .6272 .69992 .6272 .70359 .63176 .70066 .63177 Mtetra
.669 .151 0 r
.70066 .63177 .70359 .63176 .70726 .63609 .70433 .63611 Mtetra
.576 .021 0 r
.70433 .63611 .70726 .63609 .71078 .63897 .70785 .63899 Mtetra
.147 0 0 r
.70785 .63899 .71078 .63897 .71404 .6394 .71111 .63942 Mtetra
.779 .945 .931 r
.71111 .63942 .71404 .6394 .71696 .63684 .71402 .63685 Mtetra
.917 .802 .718 r
.71402 .63685 .71696 .63684 .71951 .63129 .71658 .6313 Mtetra
.92 .723 .62 r
.71658 .6313 .71951 .63129 .72175 .62331 .71883 .62331 Mtetra
.917 .691 .582 r
.71883 .62331 .72175 .62331 .7238 .6139 .72089 .61387 Mtetra
.916 .686 .576 r
.72089 .61387 .7238 .6139 .7258 .60427 .7229 .60422 Mtetra
.918 .705 .599 r
.7229 .60422 .7258 .60427 .72791 .59566 .72503 .5956 Mtetra
.92 .76 .666 r
.72503 .5956 .72791 .59566 .73028 .58912 .72741 .58905 Mtetra
.881 .881 .829 r
.72741 .58905 .73028 .58912 .73301 .58532 .73014 .58524 Mtetra
.332 .807 .906 r
.73014 .58524 .73301 .58532 .73614 .58449 .73327 .58441 Mtetra
.448 0 0 r
.73327 .58441 .73614 .58449 .73965 .58634 .73678 .58626 Mtetra
.632 .092 0 r
.73678 .58626 .73965 .58634 .74346 .59015 .74058 .59008 Mtetra
.674 .152 0 r
.74058 .59008 .74346 .59015 .74743 .59486 .74454 .59479 Mtetra
.656 .126 0 r
.74454 .59479 .74743 .59486 .75137 .59921 .74848 .59916 Mtetra
.551 0 0 r
.74848 .59916 .75137 .59921 .75512 .60201 .75223 .60196 Mtetra
.089 0 0 r
.75223 .60196 .75512 .60201 .75853 .6023 .75564 .60225 Mtetra
.789 .944 .926 r
.75564 .60225 .75853 .6023 .76152 .5996 .75862 .59955 Mtetra
.922 .806 .714 r
.75862 .59955 .76152 .5996 .76406 .59396 .76118 .5939 Mtetra
.926 .727 .615 r
.76118 .5939 .76406 .59396 .76625 .58599 .76337 .58591 Mtetra
.923 .696 .577 r
.76337 .58591 .76625 .58599 .76822 .57669 .76535 .5766 Mtetra
.923 .694 .574 r
.76535 .5766 .76822 .57669 .77015 .56731 .7673 .56719 Mtetra
.925 .717 .603 r
.7673 .56719 .77015 .56731 .77224 .55906 .7694 .55893 Mtetra
.925 .782 .684 r
.7694 .55893 .77224 .55906 .77466 .55295 .77183 .5528 Mtetra
.853 .912 .873 r
.77183 .5528 .77466 .55295 .77752 .5496 .77469 .54946 Mtetra
.167 .701 .834 r
.77469 .54946 .77752 .5496 .78087 .5492 .77804 .54905 Mtetra
.476 0 0 r
.77804 .54905 .78087 .5492 .78467 .55142 .78183 .55128 Mtetra
.63 .084 0 r
.78183 .55128 .78467 .55142 .7888 .5555 .78596 .55536 Mtetra
.665 .133 0 r
.78596 .55536 .7888 .5555 .7931 .56036 .79025 .56023 Mtetra
.642 .1 0 r
.79025 .56023 .7931 .56036 .79735 .56474 .7945 .56462 Mtetra
.523 0 0 r
.7945 .56462 .79735 .56474 .80135 .56746 .79849 .56735 Mtetra
.033 0 0 r
.79849 .56735 .80135 .56746 .80492 .56762 .80207 .5675 Mtetra
.797 .943 .921 r
.80207 .5675 .80492 .56762 .80798 .56477 .80513 .56465 Mtetra
.928 .811 .71 r
.80513 .56465 .80798 .56477 .81053 .55903 .80768 .5589 Mtetra
.933 .733 .61 r
.80768 .5589 .81053 .55903 .81266 .55105 .80982 .5509 Mtetra
.93 .703 .572 r
.80982 .5509 .81266 .55105 .81455 .54186 .81173 .5417 Mtetra
.93 .702 .572 r
.81173 .5417 .81455 .54186 .81643 .53271 .81362 .53253 Mtetra
.933 .732 .608 r
.81362 .53253 .81643 .53271 .81853 .5248 .81572 .5246 Mtetra
.927 .807 .707 r
.81572 .5246 .81853 .5248 .82102 .5191 .81823 .51889 Mtetra
.804 .936 .917 r
.81823 .51889 .82102 .5191 .82406 .5162 .82127 .51599 Mtetra
.025 .595 .759 r
.82127 .51599 .82406 .5162 .82766 .51623 .82487 .51601 Mtetra
.495 0 0 r
.82487 .51601 .82766 .51623 .83179 .51881 .82899 .5186 Mtetra
.626 .073 0 r
.82899 .5186 .83179 .51881 .83629 .52317 .83349 .52296 Mtetra
.654 .112 0 r
.83349 .52296 .83629 .52317 .84096 .52817 .83816 .52798 Mtetra
.624 .071 0 r
.83816 .52798 .84096 .52817 .84556 .53259 .84275 .5324 Mtetra
.492 0 0 r
.84275 .5324 .84556 .53259 .84983 .53524 .84701 .53506 Mtetra
.02 .592 .75 r
.84701 .53506 .84983 .53524 .85358 .53526 .85077 .53508 Mtetra
.804 .944 .916 r
.85077 .53508 .85358 .53526 .85672 .53227 .85391 .53208 Mtetra
.934 .816 .705 r
.85391 .53208 .85672 .53227 .85927 .52642 .85647 .52622 Mtetra
.94 .739 .604 r
.85647 .52622 .85927 .52642 .86135 .51841 .85855 .51819 Mtetra
.938 .71 .567 r
.85855 .51819 .86135 .51841 .86317 .50931 .86039 .50908 Mtetra
.938 .712 .57 r
.86039 .50908 .86317 .50931 .86502 .50037 .86225 .50013 Mtetra
.94 .748 .616 r
.86225 .50013 .86502 .50037 .86713 .49279 .86437 .49253 Mtetra
.927 .835 .735 r
.86437 .49253 .86713 .49279 .86975 .48749 .86699 .48722 Mtetra
.729 .944 .953 r
.86699 .48722 .86975 .48749 .87299 .48503 .87024 .48476 Mtetra
.087 0 0 r
.87024 .48476 .87299 .48503 .87691 .48549 .87416 .48521 Mtetra
.505 0 0 r
.87416 .48521 .87691 .48549 .88142 .48844 .87866 .48817 Mtetra
.618 .058 0 r
.87866 .48817 .88142 .48844 .88635 .49307 .88359 .49281 Mtetra
.64 .088 0 r
.88359 .49281 .88635 .49307 .89145 .49824 .88868 .49799 Mtetra
.604 .04 0 r
.88868 .49799 .89145 .49824 .89642 .5027 .89365 .50245 Mtetra
.458 0 0 r
.89365 .50245 .89642 .5027 .90099 .50528 .89822 .50504 Mtetra
.069 .629 .789 r
.89822 .50504 .90099 .50528 .90494 .50517 .90217 .50492 Mtetra
.811 .946 .912 r
.90217 .50492 .90494 .50517 .90818 .50201 .90541 .50176 Mtetra
.941 .823 .7 r
.90541 .50176 .90818 .50201 .91073 .49604 .90797 .49578 Mtetra
.948 .746 .597 r
.90797 .49578 .91073 .49604 .91275 .488 .91 .48772 Mtetra
.946 .718 .561 r
.91 .48772 .91275 .488 .91452 .47898 .91178 .47868 Mtetra
.946 .724 .569 r
.91178 .47868 .91452 .47898 .91634 .47024 .91361 .46993 Mtetra
.947 .767 .626 r
.91361 .46993 .91634 .47024 .91851 .46297 .91579 .46264 Mtetra
.921 .867 .768 r
.91579 .46264 .91851 .46297 .92127 .45807 .91856 .45773 Mtetra
.625 .927 .971 r
.91856 .45773 .92127 .45807 .92478 .45604 .92207 .4557 Mtetra
.171 0 0 r
.92207 .4557 .92478 .45604 .92907 .45693 .92636 .45659 Mtetra
.51 0 0 r
.92636 .45659 .92907 .45693 .93403 .46026 .93131 .45993 Mtetra
.607 .041 0 r
.93131 .45993 .93403 .46026 .93945 .46518 .93673 .46486 Mtetra
.623 .062 0 r
.93673 .46486 .93945 .46518 .94503 .47052 .94231 .4702 Mtetra
.58 .006 0 r
.94231 .4702 .94503 .47052 .95043 .47502 .9477 .47471 Mtetra
.421 0 0 r
.9477 .47471 .95043 .47502 .95533 .47754 .95261 .47724 Mtetra
.114 .661 .822 r
.95261 .47724 .95533 .47754 .9595 .47729 .95678 .47698 Mtetra
.954 .952 .681 r
.5058 .86734 .50898 .86426 .51159 .85907 .50842 .86213 Mtetra
.977 .822 .623 r
.50842 .86213 .51159 .85907 .51416 .85089 .51101 .85392 Mtetra
.96 .76 .589 r
.51101 .85392 .51416 .85089 .5167 .84059 .51356 .84358 Mtetra
.953 .739 .577 r
.51356 .84358 .5167 .84059 .51921 .8294 .51609 .83235 Mtetra
.956 .747 .582 r
.51609 .83235 .51921 .8294 .52171 .81868 .51861 .82158 Mtetra
.969 .789 .606 r
.51861 .82158 .52171 .81868 .52421 .80967 .52113 .81254 Mtetra
.981 .889 .659 r
.52113 .81254 .52421 .80967 .52675 .80331 .52368 .80616 Mtetra
.723 .944 .635 r
.52368 .80616 .52675 .80331 .52934 .80009 .52627 .80293 Mtetra
.22 0 0 r
.52627 .80293 .52934 .80009 .53199 .79996 .52892 .80281 Mtetra
.532 .096 .158 r
.52892 .80281 .53199 .79996 .5347 .80238 .53163 .80524 Mtetra
.613 .194 .225 r
.53163 .80524 .5347 .80238 .53746 .80635 .53439 .80923 Mtetra
.623 .207 .233 r
.53439 .80923 .53746 .80635 .54025 .8106 .53718 .81351 Mtetra
.575 .148 .193 r
.53718 .81351 .54025 .8106 .54304 .8138 .53996 .81673 Mtetra
.395 0 .053 r
.53996 .81673 .54304 .8138 .54579 .81478 .54271 .81772 Mtetra
0 0 0 r
.54271 .81772 .54579 .81478 .54847 .81276 .5454 .81569 Mtetra
.955 .95 .674 r
.5454 .81569 .54847 .81276 .55106 .8075 .548 .81042 Mtetra
.981 .826 .616 r
.548 .81042 .55106 .8075 .55356 .79939 .55052 .80227 Mtetra
.966 .766 .583 r
.55052 .80227 .55356 .79939 .55599 .7893 .55297 .79215 Mtetra
.96 .747 .572 r
.55297 .79215 .55599 .7893 .55838 .77846 .55537 .78127 Mtetra
.964 .758 .579 r
.55537 .78127 .55838 .77846 .56077 .76821 .55778 .77097 Mtetra
.977 .807 .607 r
.55778 .77097 .56077 .76821 .56321 .75975 .56023 .76248 Mtetra
.976 .918 .666 r
.56023 .76248 .56321 .75975 .56573 .75395 .56276 .75666 Mtetra
.571 .871 .569 r
.56276 .75666 .56573 .75395 .56837 .75125 .56541 .75395 Mtetra
.295 0 0 r
.56541 .75395 .56837 .75125 .57113 .75155 .56817 .75426 Mtetra
.548 .107 .153 r
.56817 .75426 .57113 .75155 .574 .75426 .57104 .75699 Mtetra
.617 .19 .21 r
.57104 .75699 .574 .75426 .57695 .75839 .57398 .76114 Mtetra
.621 .196 .214 r
.57398 .76114 .57695 .75839 .57993 .76266 .57696 .76544 Mtetra
.567 .13 .17 r
.57696 .76544 .57993 .76266 .58288 .76578 .57991 .76858 Mtetra
.372 0 .02 r
.57991 .76858 .58288 .76578 .58574 .76662 .58277 .76943 Mtetra
0 0 0 r
.58277 .76943 .58574 .76662 .58847 .76446 .58551 .76726 Mtetra
.956 .949 .666 r
.58551 .76726 .58847 .76446 .59105 .75914 .5881 .76193 Mtetra
.985 .83 .609 r
.5881 .76193 .59105 .75914 .59349 .75108 .59055 .75383 Mtetra
.972 .772 .576 r
.59055 .75383 .59349 .75108 .59582 .74118 .5929 .74389 Mtetra
.967 .755 .566 r
.5929 .74389 .59582 .74118 .5981 .73067 .59519 .73334 Mtetra
.971 .771 .575 r
.59519 .73334 .5981 .73067 .6004 .72086 .59751 .7235 Mtetra
.984 .827 .608 r
.59751 .7235 .6004 .72086 .60278 .71291 .59991 .71552 Mtetra
.96 .945 .67 r
.59991 .71552 .60278 .71291 .60532 .70765 .60245 .71024 Mtetra
0 0 0 r
.60245 .71024 .60532 .70765 .60803 .70544 .60517 .70802 Mtetra
.352 0 0 r
.60517 .70802 .60803 .70544 .61093 .70614 .60807 .70874 Mtetra
.561 .113 .146 r
.60807 .70874 .61093 .70614 .61398 .70914 .61112 .71175 Mtetra
.619 .185 .194 r
.61112 .71175 .61398 .70914 .61714 .71342 .61428 .71606 Mtetra
.619 .184 .193 r
.61428 .71606 .61714 .71342 .62033 .71772 .61746 .72038 Mtetra
.559 .111 .144 r
.61746 .72038 .62033 .71772 .62346 .72075 .62059 .72343 Mtetra
.348 0 0 r
.62059 .72343 .62346 .72075 .62644 .72145 .62357 .72414 Mtetra
0 0 0 r
.62357 .72414 .62644 .72145 .62923 .71916 .62637 .72185 Mtetra
.956 .947 .657 r
.62637 .72185 .62923 .71916 .6318 .71377 .62895 .71644 Mtetra
.988 .834 .6 r
.62895 .71644 .6318 .71377 .63418 .70574 .63134 .70838 Mtetra
.978 .778 .567 r
.63134 .70838 .63418 .70574 .63641 .69601 .63359 .69861 Mtetra
.974 .764 .559 r
.63359 .69861 .63641 .69601 .63859 .68581 .63578 .68837 Mtetra
.979 .784 .571 r
.63578 .68837 .63859 .68581 .64081 .67642 .63802 .67894 Mtetra
.989 .85 .61 r
.63802 .67894 .64081 .67642 .64317 .66896 .64039 .67146 Mtetra
.926 .966 .669 r
.64039 .67146 .64317 .66896 .64574 .6642 .64297 .66668 Mtetra
0 0 0 r
.64297 .66668 .64574 .6642 .64856 .66247 .6458 .66494 Mtetra
.396 0 .001 r
.6458 .66494 .64856 .66247 .65163 .66356 .64886 .66605 Mtetra
.571 .117 .135 r
.64886 .66605 .65163 .66356 .6549 .66684 .65213 .66935 Mtetra
.621 .177 .175 r
.65213 .66935 .6549 .66684 .65829 .67127 .65553 .6738 Mtetra
.615 .17 .171 r
.65553 .6738 .65829 .67127 .66171 .67558 .65894 .67814 Mtetra
.548 .09 .118 r
.65894 .67814 .66171 .67558 .66502 .67854 .66226 .68112 Mtetra
.323 0 0 r
.66226 .68112 .66502 .67854 .66814 .67911 .66538 .68169 Mtetra
0 0 0 r
.66538 .68169 .66814 .67911 .67099 .67668 .66823 .67926 Mtetra
.955 .946 .646 r
.66823 .67926 .67099 .67668 .67355 .67121 .67081 .67377 Mtetra
.992 .839 .59 r
.67081 .67377 .67355 .67121 .67587 .66321 .67313 .66573 Mtetra
.984 .785 .558 r
.67313 .66573 .67587 .66321 .67801 .65363 .67529 .65612 Mtetra
.981 .774 .551 r
.67529 .65612 .67801 .65363 .6801 .64372 .67739 .64617 Mtetra
.987 .799 .567 r
.67739 .64617 .6801 .64372 .68226 .63472 .67957 .63714 Mtetra
.991 .873 .611 r
.67957 .63714 .68226 .63472 .68462 .62772 .68194 .63012 Mtetra
.867 .972 .658 r
.68194 .63012 .68462 .62772 .68726 .62345 .68459 .62583 Mtetra
0 0 0 r
.68459 .62583 .68726 .62345 .69021 .62217 .68755 .62455 Mtetra
.431 0 .009 r
.68755 .62455 .69021 .62217 .69348 .62365 .69082 .62604 Mtetra
.579 .117 .121 r
.69082 .62604 .69348 .62365 .697 .6272 .69434 .62961 Mtetra
.621 .168 .155 r
.69434 .62961 .697 .6272 .70066 .63177 .698 .63421 Mtetra
.61 .155 .147 r
.698 .63421 .70066 .63177 .70433 .63611 .70166 .63857 Mtetra
.537 .068 .089 r
.70166 .63857 .70433 .63611 .70785 .63899 .70518 .64147 Mtetra
.297 0 0 r
.70518 .64147 .70785 .63899 .71111 .63942 .70845 .6419 Mtetra
0 0 0 r
.70845 .6419 .71111 .63942 .71402 .63685 .71137 .63933 Mtetra
.953 .944 .633 r
.71137 .63933 .71402 .63685 .71658 .6313 .71394 .63376 Mtetra
.995 .843 .578 r
.71394 .63376 .71658 .6313 .71883 .62331 .7162 .62574 Mtetra
.989 .792 .547 r
.7162 .62574 .71883 .62331 .72089 .61387 .71827 .61626 Mtetra
.988 .784 .543 r
.71827 .61626 .72089 .61387 .7229 .60422 .7203 .60658 Mtetra
.993 .815 .562 r
.7203 .60658 .7229 .60422 .72503 .5956 .72244 .59792 Mtetra
.987 .897 .611 r
.72244 .59792 .72503 .5956 .72741 .58905 .72483 .59135 Mtetra
.776 .955 .632 r
.72483 .59135 .72741 .58905 .73014 .58524 .72757 .58753 Mtetra
.041 0 0 r
.72757 .58753 .73014 .58524 .73327 .58441 .73071 .58669 Mtetra
.458 0 .01 r
.73071 .58669 .73327 .58441 .73678 .58626 .73422 .58856 Mtetra
.584 .114 .105 r
.73422 .58856 .73678 .58626 .74058 .59008 .73802 .5924 Mtetra
.619 .157 .133 r
.73802 .5924 .74058 .59008 .74454 .59479 .74198 .59715 Mtetra
.604 .138 .121 r
.74198 .59715 .74454 .59479 .74848 .59916 .74592 .60153 Mtetra
.524 .045 .06 r
.74592 .60153 .74848 .59916 .75223 .60196 .74967 .60435 Mtetra
.27 0 0 r
.74967 .60435 .75223 .60196 .75564 .60225 .75308 .60466 Mtetra
0 0 0 r
.75308 .60466 .75564 .60225 .75862 .59955 .75608 .60194 Mtetra
.949 .942 .618 r
.75608 .60194 .75862 .59955 .76118 .5939 .75864 .59627 Mtetra
.997 .848 .564 r
.75864 .59627 .76118 .5939 .76337 .58591 .76085 .58825 Mtetra
.994 .8 .535 r
.76085 .58825 .76337 .58591 .76535 .5766 .76284 .5789 Mtetra
.994 .795 .532 r
.76284 .5789 .76535 .5766 .7673 .56719 .7648 .56947 Mtetra
.997 .832 .555 r
.7648 .56947 .7673 .56719 .7694 .55893 .76692 .56117 Mtetra
.975 .92 .609 r
.76692 .56117 .7694 .55893 .77183 .5528 .76936 .55502 Mtetra
.654 .909 .591 r
.76936 .55502 .77183 .5528 .77469 .54946 .77223 .55166 Mtetra
.137 0 0 r
.77223 .55166 .77469 .54946 .77804 .54905 .77558 .55126 Mtetra
.48 0 .005 r
.77558 .55126 .77804 .54905 .78183 .55128 .77938 .5535 Mtetra
.588 .109 .086 r
.77938 .5535 .78183 .55128 .78596 .55536 .78351 .55761 Mtetra
.617 .144 .108 r
.78351 .55761 .78596 .55536 .79025 .56023 .7878 .56251 Mtetra
.597 .12 .093 r
.7878 .56251 .79025 .56023 .7945 .56462 .79205 .56692 Mtetra
.51 .02 .029 r
.79205 .56692 .7945 .56462 .79849 .56735 .79604 .56967 Mtetra
.242 0 0 r
.79604 .56967 .79849 .56735 .80207 .5675 .79962 .56983 Mtetra
0 0 0 r
.79962 .56983 .80207 .5675 .80513 .56465 .80269 .56697 Mtetra
.943 .939 .6 r
.80269 .56697 .80513 .56465 .80768 .5589 .80526 .5612 Mtetra
.998 .852 .548 r
.80526 .5612 .80768 .5589 .80982 .5509 .80741 .55317 Mtetra
.998 .807 .52 r
.80741 .55317 .80982 .5509 .81173 .5417 .80933 .54393 Mtetra
.998 .806 .52 r
.80933 .54393 .81173 .5417 .81362 .53253 .81123 .53472 Mtetra
.998 .85 .547 r
.81123 .53472 .81362 .53253 .81572 .5246 .81335 .52677 Mtetra
.948 .938 .603 r
.81335 .52677 .81572 .5246 .81823 .51889 .81587 .52104 Mtetra
.51 .835 .536 r
.81587 .52104 .81823 .51889 .82127 .51599 .81891 .51812 Mtetra
.213 0 0 r
.81891 .51812 .82127 .51599 .82487 .51601 .82252 .51816 Mtetra
.496 0 0 r
.82252 .51816 .82487 .51601 .82899 .5186 .82665 .52076 Mtetra
.589 .101 .064 r
.82665 .52076 .82899 .5186 .83349 .52296 .83115 .52515 Mtetra
.613 .129 .081 r
.83115 .52515 .83349 .52296 .83816 .52798 .83582 .53019 Mtetra
.588 .1 .063 r
.83582 .53019 .83816 .52798 .84275 .5324 .84041 .53464 Mtetra
.494 0 0 r
.84041 .53464 .84275 .5324 .84701 .53506 .84468 .53732 Mtetra
.215 0 0 r
.84468 .53732 .84701 .53506 .85077 .53508 .84844 .53735 Mtetra
0 0 0 r
.84844 .53735 .85077 .53508 .85391 .53208 .8516 .53433 Mtetra
.934 .934 .579 r
.8516 .53433 .85391 .53208 .85647 .52622 .85416 .52845 Mtetra
.997 .855 .528 r
.85416 .52845 .85647 .52622 .85855 .51819 .85626 .5204 Mtetra
1 .814 .502 r
.85626 .5204 .85855 .51819 .86039 .50908 .85811 .51125 Mtetra
1 .817 .505 r
.85811 .51125 .86039 .50908 .86225 .50013 .85998 .50226 Mtetra
.994 .867 .537 r
.85998 .50226 .86225 .50013 .86437 .49253 .86211 .49463 Mtetra
.902 .946 .591 r
.86211 .49463 .86437 .49253 .86699 .48722 .86474 .4893 Mtetra
0 0 0 r
.86474 .4893 .86699 .48722 .87024 .48476 .868 .48683 Mtetra
.271 0 0 r
.868 .48683 .87024 .48476 .87416 .48521 .87192 .48729 Mtetra
.508 0 0 r
.87192 .48729 .87416 .48521 .87866 .48817 .87644 .49027 Mtetra
.589 .091 .039 r
.87644 .49027 .87866 .48817 .88359 .49281 .88137 .49494 Mtetra
.607 .112 .052 r
.88137 .49494 .88359 .49281 .88868 .49799 .88646 .50015 Mtetra
.578 .078 .031 r
.88646 .50015 .88868 .49799 .89365 .50245 .89144 .50463 Mtetra
.477 0 0 r
.89144 .50463 .89365 .50245 .89822 .50504 .89601 .50724 Mtetra
.189 0 0 r
.89601 .50724 .89822 .50504 .90217 .50492 .89997 .50713 Mtetra
0 0 0 r
.89997 .50713 .90217 .50492 .90541 .50176 .90322 .50396 Mtetra
.922 .927 .554 r
.90322 .50396 .90541 .50176 .90797 .49578 .90579 .49796 Mtetra
.992 .856 .505 r
.90579 .49796 .90797 .49578 .91 .48772 .90783 .48986 Mtetra
.999 .819 .481 r
.90783 .48986 .91 .48772 .91178 .47868 .90963 .48079 Mtetra
.998 .828 .487 r
.90963 .48079 .91178 .47868 .91361 .46993 .91146 .472 Mtetra
.982 .882 .523 r
.91146 .472 .91361 .46993 .91579 .46264 .91365 .46469 Mtetra
.832 .938 .57 r
.91365 .46469 .91579 .46264 .91856 .45773 .91644 .45976 Mtetra
0 0 0 r
.91644 .45976 .91856 .45773 .92207 .4557 .91996 .45773 Mtetra
.317 0 0 r
.91996 .45773 .92207 .4557 .92636 .45659 .92425 .45862 Mtetra
.516 0 0 r
.92425 .45862 .92636 .45659 .93131 .45993 .92921 .46198 Mtetra
.587 .078 .011 r
.92921 .46198 .93131 .45993 .93673 .46486 .93464 .46694 Mtetra
.6 .093 .02 r
.93464 .46694 .93673 .46486 .94231 .4702 .94022 .47232 Mtetra
.566 .055 0 r
.94022 .47232 .94231 .4702 .9477 .47471 .94563 .47685 Mtetra
.459 0 0 r
.94563 .47685 .9477 .47471 .95261 .47724 .95054 .4794 Mtetra
.164 0 0 r
.95054 .4794 .95261 .47724 .95678 .47698 .95472 .47914 Mtetra
.841 .919 .525 r
.50261 .87205 .5058 .86734 .50842 .86213 .50524 .86682 Mtetra
.994 .876 .58 r
.50524 .86682 .50842 .86213 .51101 .85392 .50785 .85857 Mtetra
.991 .81 .566 r
.50785 .85857 .51101 .85392 .51356 .84358 .51042 .84818 Mtetra
.984 .786 .558 r
.51042 .84818 .51356 .84358 .51609 .83235 .51297 .83688 Mtetra
.987 .796 .561 r
.51297 .83688 .51609 .83235 .51861 .82158 .51551 .82606 Mtetra
.995 .842 .575 r
.51551 .82606 .51861 .82158 .52113 .81254 .51805 .81697 Mtetra
.957 .924 .578 r
.51805 .81697 .52113 .81254 .52368 .80616 .52061 .81056 Mtetra
0 0 0 r
.52061 .81056 .52368 .80616 .52627 .80293 .52321 .80732 Mtetra
.262 0 .07 r
.52321 .80732 .52627 .80293 .52892 .80281 .52587 .80721 Mtetra
.503 .104 .217 r
.52587 .80721 .52892 .80281 .53163 .80524 .52858 .80966 Mtetra
.578 .186 .264 r
.52858 .80966 .53163 .80524 .53439 .80923 .53134 .81369 Mtetra
.587 .197 .27 r
.53134 .81369 .53439 .80923 .53718 .81351 .53412 .818 Mtetra
.542 .147 .242 r
.53412 .818 .53718 .81351 .53996 .81673 .5369 .82125 Mtetra
.39 0 .149 r
.5369 .82125 .53996 .81673 .54271 .81772 .53966 .82225 Mtetra
0 0 0 r
.53966 .82225 .54271 .81772 .5454 .81569 .54235 .82022 Mtetra
.84 .916 .517 r
.54235 .82022 .5454 .81569 .548 .81042 .54496 .81493 Mtetra
.993 .877 .568 r
.54496 .81493 .548 .81042 .55052 .80227 .5475 .80674 Mtetra
.994 .815 .555 r
.5475 .80674 .55052 .80227 .55297 .79215 .54996 .79656 Mtetra
.99 .794 .549 r
.54996 .79656 .55297 .79215 .55537 .78127 .55239 .78562 Mtetra
.993 .807 .553 r
.55239 .78562 .55537 .78127 .55778 .77097 .55481 .77528 Mtetra
.997 .859 .566 r
.55481 .77528 .55778 .77097 .56023 .76248 .55728 .76674 Mtetra
.916 .929 .554 r
.55728 .76674 .56023 .76248 .56276 .75666 .55983 .7609 Mtetra
0 0 0 r
.55983 .7609 .56276 .75666 .56541 .75395 .56248 .75818 Mtetra
.315 0 .09 r
.56248 .75818 .56541 .75395 .56817 .75426 .56524 .7585 Mtetra
.518 .113 .212 r
.56524 .7585 .56817 .75426 .57104 .75699 .56811 .76125 Mtetra
.582 .183 .252 r
.56811 .76125 .57104 .75699 .57398 .76114 .57106 .76544 Mtetra
.586 .188 .255 r
.57106 .76544 .57398 .76114 .57696 .76544 .57403 .76977 Mtetra
.535 .132 .224 r
.57403 .76977 .57696 .76544 .57991 .76858 .57698 .77294 Mtetra
.373 0 .127 r
.57698 .77294 .57991 .76858 .58277 .76943 .57985 .7738 Mtetra
0 0 0 r
.57985 .7738 .58277 .76943 .58551 .76726 .5826 .77164 Mtetra
.837 .911 .506 r
.5826 .77164 .58551 .76726 .5881 .76193 .5852 .76627 Mtetra
.992 .877 .554 r
.5852 .76627 .5881 .76193 .59055 .75383 .58767 .75814 Mtetra
.997 .821 .543 r
.58767 .75814 .59055 .75383 .5929 .74389 .59003 .74815 Mtetra
.994 .802 .538 r
.59003 .74815 .5929 .74389 .59519 .73334 .59234 .73754 Mtetra
.997 .82 .543 r
.59234 .73754 .59519 .73334 .59751 .7235 .59467 .72765 Mtetra
.993 .876 .555 r
.59467 .72765 .59751 .7235 .59991 .71552 .59709 .71963 Mtetra
.851 .917 .518 r
.59709 .71963 .59991 .71552 .60245 .71024 .59964 .71432 Mtetra
0 0 0 r
.59964 .71432 .60245 .71024 .60517 .70802 .60237 .7121 Mtetra
.358 0 .103 r
.60237 .7121 .60517 .70802 .60807 .70874 .60527 .71283 Mtetra
.53 .118 .205 r
.60527 .71283 .60807 .70874 .61112 .71175 .60833 .71588 Mtetra
.585 .179 .239 r
.60833 .71588 .61112 .71175 .61428 .71606 .61149 .72021 Mtetra
.584 .178 .238 r
.61149 .72021 .61428 .71606 .61746 .72038 .61467 .72457 Mtetra
.528 .117 .204 r
.61467 .72457 .61746 .72038 .62059 .72343 .6178 .72765 Mtetra
.356 0 .104 r
.6178 .72765 .62059 .72343 .62357 .72414 .62079 .72838 Mtetra
0 0 0 r
.62079 .72838 .62357 .72414 .62637 .72185 .62359 .72608 Mtetra
.831 .904 .493 r
.62359 .72608 .62637 .72185 .62895 .71644 .62619 .72064 Mtetra
.989 .877 .539 r
.62619 .72064 .62895 .71644 .63134 .70838 .62859 .71254 Mtetra
.999 .826 .529 r
.62859 .71254 .63134 .70838 .63359 .69861 .63085 .70272 Mtetra
.998 .811 .525 r
.63085 .70272 .63359 .69861 .63578 .68837 .63307 .69243 Mtetra
.999 .832 .531 r
.63307 .69243 .63578 .68837 .63802 .67894 .63532 .68296 Mtetra
.981 .889 .54 r
.63532 .68296 .63802 .67894 .64039 .67146 .63771 .67543 Mtetra
.76 .884 .471 r
.63771 .67543 .64039 .67146 .64297 .66668 .6403 .67064 Mtetra
0 0 0 r
.6403 .67064 .64297 .66668 .6458 .66494 .64313 .66889 Mtetra
.393 0 .11 r
.64313 .66889 .6458 .66494 .64886 .66605 .6462 .67002 Mtetra
.54 .121 .196 r
.6462 .67002 .64886 .66605 .65213 .66935 .64948 .67335 Mtetra
.587 .173 .224 r
.64948 .67335 .65213 .66935 .65553 .6738 .65287 .67783 Mtetra
.581 .167 .22 r
.65287 .67783 .65553 .6738 .65894 .67814 .65628 .68221 Mtetra
.52 .1 .184 r
.65628 .68221 .65894 .67814 .66226 .68112 .6596 .68521 Mtetra
.338 0 .082 r
.6596 .68521 .66226 .68112 .66538 .68169 .66273 .6858 Mtetra
0 0 0 r
.66273 .6858 .66538 .68169 .66823 .67926 .66559 .68336 Mtetra
.822 .895 .476 r
.66559 .68336 .66823 .67926 .67081 .67377 .66818 .67784 Mtetra
.985 .876 .52 r
.66818 .67784 .67081 .67377 .67313 .66573 .67052 .66977 Mtetra
1 .83 .513 r
.67052 .66977 .67313 .66573 .67529 .65612 .67269 .66011 Mtetra
1 .819 .51 r
.67269 .66011 .67529 .65612 .67739 .64617 .67481 .6501 Mtetra
.998 .844 .516 r
.67481 .6501 .67739 .64617 .67957 .63714 .67701 .64103 Mtetra
.959 .898 .52 r
.67701 .64103 .67957 .63714 .68194 .63012 .67939 .63397 Mtetra
.644 .828 .413 r
.67939 .63397 .68194 .63012 .68459 .62583 .68205 .62967 Mtetra
.061 0 0 r
.68205 .62967 .68459 .62583 .68755 .62455 .68502 .62839 Mtetra
.422 0 .112 r
.68502 .62839 .68755 .62455 .69082 .62604 .68829 .6299 Mtetra
.548 .122 .184 r
.68829 .6299 .69082 .62604 .69434 .62961 .69182 .6335 Mtetra
.588 .165 .207 r
.69182 .6335 .69434 .62961 .698 .63421 .69548 .63813 Mtetra
.578 .154 .201 r
.69548 .63813 .698 .63421 .70166 .63857 .69914 .64253 Mtetra
.51 .082 .163 r
.69914 .64253 .70166 .63857 .70518 .64147 .70267 .64545 Mtetra
.319 0 .06 r
.70267 .64545 .70518 .64147 .70845 .6419 .70594 .6459 Mtetra
0 0 0 r
.70594 .6459 .70845 .6419 .71137 .63933 .70887 .64332 Mtetra
.81 .884 .456 r
.70887 .64332 .71137 .63933 .71394 .63376 .71145 .63772 Mtetra
.977 .874 .499 r
.71145 .63772 .71394 .63376 .7162 .62574 .71373 .62966 Mtetra
.998 .833 .493 r
.71373 .62966 .7162 .62574 .71827 .61626 .71582 .62014 Mtetra
.999 .826 .491 r
.71582 .62014 .71827 .61626 .7203 .60658 .71786 .6104 Mtetra
.992 .853 .497 r
.71786 .6104 .7203 .60658 .72244 .59792 .72001 .6017 Mtetra
.921 .899 .493 r
.72001 .6017 .72244 .59792 .72483 .59135 .72242 .5951 Mtetra
0 0 0 r
.72242 .5951 .72483 .59135 .72757 .58753 .72517 .59127 Mtetra
.142 0 0 r
.72517 .59127 .72757 .58753 .73071 .58669 .72831 .59043 Mtetra
.445 .007 .11 r
.72831 .59043 .73071 .58669 .73422 .58856 .73183 .59232 Mtetra
.554 .12 .17 r
.73183 .59232 .73422 .58856 .73802 .5924 .73564 .5962 Mtetra
.587 .156 .188 r
.73564 .5962 .73802 .5924 .74198 .59715 .7396 .60098 Mtetra
.573 .14 .181 r
.7396 .60098 .74198 .59715 .74592 .60153 .74355 .6054 Mtetra
.5 .063 .141 r
.74355 .6054 .74592 .60153 .74967 .60435 .7473 .60825 Mtetra
.3 0 .038 r
.7473 .60825 .74967 .60435 .75308 .60466 .75072 .60856 Mtetra
0 0 0 r
.75072 .60856 .75308 .60466 .75608 .60194 .75373 .60584 Mtetra
.794 .87 .432 r
.75373 .60584 .75608 .60194 .75864 .59627 .7563 .60014 Mtetra
.967 .87 .474 r
.7563 .60014 .75864 .59627 .76085 .58825 .75853 .59208 Mtetra
.993 .835 .47 r
.75853 .59208 .76085 .58825 .76284 .5789 .76053 .58268 Mtetra
.994 .831 .47 r
.76053 .58268 .76284 .5789 .7648 .56947 .76251 .5732 Mtetra
.978 .86 .475 r
.76251 .5732 .7648 .56947 .76692 .56117 .76464 .56486 Mtetra
.864 .887 .458 r
.76464 .56486 .76692 .56117 .76936 .55502 .76709 .55868 Mtetra
0 0 0 r
.76709 .55868 .76936 .55502 .77223 .55166 .76997 .55531 Mtetra
.208 0 0 r
.76997 .55531 .77223 .55166 .77558 .55126 .77333 .55492 Mtetra
.463 .017 .104 r
.77333 .55492 .77558 .55126 .77938 .5535 .77713 .55718 Mtetra
.559 .116 .154 r
.77713 .55718 .77938 .5535 .78351 .55761 .78127 .56133 Mtetra
.586 .145 .168 r
.78127 .56133 .78351 .55761 .7878 .56251 .78557 .56626 Mtetra
.567 .125 .159 r
.78557 .56626 .7878 .56251 .79205 .56692 .78982 .57071 Mtetra
.489 .044 .118 r
.78982 .57071 .79205 .56692 .79604 .56967 .79383 .57348 Mtetra
.281 0 .018 r
.79383 .57348 .79604 .56967 .79962 .56983 .79742 .57366 Mtetra
0 0 0 r
.79742 .57366 .79962 .56983 .80269 .56697 .8005 .57079 Mtetra
.773 .853 .405 r
.8005 .57079 .80269 .56697 .80526 .5612 .80307 .56499 Mtetra
.952 .862 .445 r
.80307 .56499 .80526 .5612 .80741 .55317 .80524 .55692 Mtetra
.984 .834 .444 r
.80524 .55692 .80741 .55317 .80933 .54393 .80717 .54763 Mtetra
.80717 .54763 .80933 .54393 .81123 .53472 .80909 .53837 Mtetra
.954 .862 .446 r
.80909 .53837 .81123 .53472 .81335 .52677 .81122 .53038 Mtetra
.786 .859 .414 r
.81122 .53038 .81335 .52677 .81587 .52104 .81375 .52462 Mtetra
0 0 0 r
.81375 .52462 .81587 .52104 .81891 .51812 .8168 .5217 Mtetra
.261 0 0 r
.8168 .5217 .81891 .51812 .82252 .51816 .82042 .52174 Mtetra
.478 .024 .094 r
.82042 .52174 .82252 .51816 .82665 .52076 .82456 .52437 Mtetra
.562 .109 .136 r
.82456 .52437 .82665 .52076 .83115 .52515 .82907 .52879 Mtetra
.583 .132 .147 r
.82907 .52879 .83115 .52515 .83582 .53019 .83375 .53388 Mtetra
.56 .108 .135 r
.83375 .53388 .83582 .53019 .84041 .53464 .83835 .53837 Mtetra
.476 .023 .095 r
.83835 .53837 .84041 .53464 .84468 .53732 .84263 .54107 Mtetra
.262 0 0 r
.84263 .54107 .84468 .53732 .84844 .53735 .8464 .54111 Mtetra
0 0 0 r
.8464 .54111 .84844 .53735 .8516 .53433 .84957 .53808 Mtetra
.748 .832 .374 r
.84957 .53808 .8516 .53433 .85416 .52845 .85214 .53217 Mtetra
.931 .851 .412 r
.85214 .53217 .85416 .52845 .85626 .5204 .85425 .52408 Mtetra
.968 .83 .412 r
.85425 .52408 .85626 .5204 .85811 .51125 .85612 .51488 Mtetra
.966 .832 .412 r
.85612 .51488 .85811 .51125 .85998 .50226 .858 .50584 Mtetra
.916 .855 .411 r
.858 .50584 .85998 .50226 .86211 .49463 .86015 .49817 Mtetra
.687 .814 .363 r
.86015 .49817 .86211 .49463 .86474 .4893 .86279 .49282 Mtetra
0 0 0 r
.86279 .49282 .86474 .4893 .868 .48683 .86606 .49035 Mtetra
.304 0 0 r
.86606 .49035 .868 .48683 .87192 .48729 .86999 .49082 Mtetra
.49 .027 .081 r
.86999 .49082 .87192 .48729 .87644 .49027 .87451 .49383 Mtetra
.563 .101 .115 r
.87451 .49383 .87644 .49027 .88137 .49494 .87946 .49853 Mtetra
.58 .118 .123 r
.87946 .49853 .88137 .49494 .88646 .50015 .88456 .50378 Mtetra
.553 .09 .11 r
.88456 .50378 .88646 .50015 .89144 .50463 .88955 .50831 Mtetra
.463 .002 .071 r
.88955 .50831 .89144 .50463 .89601 .50724 .89413 .51094 Mtetra
.244 0 0 r
.89413 .51094 .89601 .50724 .89997 .50713 .89811 .51084 Mtetra
0 0 0 r
.89811 .51084 .89997 .50713 .90322 .50396 .90137 .50766 Mtetra
.717 .807 .338 r
.90137 .50766 .90322 .50396 .90579 .49796 .90395 .50163 Mtetra
.904 .834 .373 r
.90395 .50163 .90579 .49796 .90783 .48986 .90601 .49349 Mtetra
.946 .82 .375 r
.90601 .49349 .90783 .48986 .90963 .48079 .90781 .48437 Mtetra
.938 .824 .375 r
.90781 .48437 .90963 .48079 .91146 .472 .90966 .47553 Mtetra
.863 .838 .369 r
.90966 .47553 .91146 .472 .91365 .46469 .91186 .46818 Mtetra
0 0 0 r
.91186 .46818 .91365 .46469 .91644 .45976 .91466 .46323 Mtetra
.91466 .46323 .91644 .45976 .91996 .45773 .91819 .4612 Mtetra
.338 0 0 r
.91819 .4612 .91996 .45773 .92425 .45862 .9225 .4621 Mtetra
.499 .027 .065 r
.9225 .4621 .92425 .45862 .92921 .46198 .92748 .4655 Mtetra
.563 .09 .092 r
.92748 .4655 .92921 .46198 .93464 .46694 .93291 .47049 Mtetra
.575 .103 .097 r
.93291 .47049 .93464 .46694 .94022 .47232 .93851 .47592 Mtetra
.543 .071 .084 r
.93851 .47592 .94022 .47232 .94563 .47685 .94393 .48049 Mtetra
.45 0 .047 r
.94393 .48049 .94563 .47685 .95054 .4794 .94885 .48306 Mtetra
.227 0 0 r
.94885 .48306 .95054 .4794 .95472 .47914 .95305 .48282 Mtetra
.81 .901 .492 r
.4994 .87706 .50261 .87205 .50524 .86682 .50204 .87181 Mtetra
.992 .881 .569 r
.50204 .87181 .50524 .86682 .50785 .85857 .50466 .86352 Mtetra
.994 .817 .56 r
.50466 .86352 .50785 .85857 .51042 .84818 .50726 .85307 Mtetra
.988 .793 .554 r
.50726 .85307 .51042 .84818 .51297 .83688 .50983 .84171 Mtetra
.991 .803 .556 r
.50983 .84171 .51297 .83688 .51551 .82606 .51238 .83083 Mtetra
.997 .849 .567 r
.51238 .83083 .51551 .82606 .51805 .81697 .51494 .82169 Mtetra
.944 .922 .558 r
.51494 .82169 .51805 .81697 .52061 .81056 .51752 .81525 Mtetra
0 0 0 r
.51752 .81525 .52061 .81056 .52321 .80732 .52013 .812 Mtetra
.266 0 .087 r
.52013 .812 .52321 .80732 .52587 .80721 .52279 .81189 Mtetra
.499 .105 .225 r
.52279 .81189 .52587 .80721 .52858 .80966 .5255 .81437 Mtetra
.573 .185 .269 r
.5255 .81437 .52858 .80966 .53134 .81369 .52826 .81843 Mtetra
.582 .196 .275 r
.52826 .81843 .53134 .81369 .53412 .818 .53104 .82279 Mtetra
.537 .146 .248 r
.53104 .82279 .53412 .818 .5369 .82125 .53383 .82607 Mtetra
.389 0 .161 r
.53383 .82607 .5369 .82125 .53966 .82225 .53658 .82708 Mtetra
0 0 0 r
.53658 .82708 .53966 .82225 .54235 .82022 .53928 .82505 Mtetra
.81 .898 .484 r
.53928 .82505 .54235 .82022 .54496 .81493 .54191 .81973 Mtetra
.991 .881 .556 r
.54191 .81973 .54496 .81493 .5475 .80674 .54446 .8115 Mtetra
.997 .822 .549 r
.54446 .8115 .5475 .80674 .54996 .79656 .54694 .80126 Mtetra
.993 .801 .543 r
.54694 .80126 .54996 .79656 .55239 .78562 .54939 .79027 Mtetra
.996 .814 .547 r
.54939 .79027 .55239 .78562 .55481 .77528 .55183 .77987 Mtetra
.996 .865 .557 r
.55183 .77987 .55481 .77528 .55728 .76674 .55432 .77128 Mtetra
.895 .92 .528 r
.55432 .77128 .55728 .76674 .55983 .7609 .55688 .76541 Mtetra
0 0 0 r
.55688 .76541 .55983 .7609 .56248 .75818 .55953 .76269 Mtetra
.317 0 .105 r
.55953 .76269 .56248 .75818 .56524 .7585 .5623 .76302 Mtetra
.513 .113 .22 r
.5623 .76302 .56524 .7585 .56811 .76125 .56518 .7658 Mtetra
.577 .182 .258 r
.56518 .7658 .56811 .76125 .57106 .76544 .56812 .77002 Mtetra
.581 .187 .26 r
.56812 .77002 .57106 .76544 .57403 .76977 .57109 .77439 Mtetra
.531 .132 .231 r
.57109 .77439 .57403 .76977 .57698 .77294 .57404 .77759 Mtetra
.373 0 .14 r
.57404 .77759 .57698 .77294 .57985 .7738 .57692 .77847 Mtetra
0 0 0 r
.57692 .77847 .57985 .7738 .5826 .77164 .57967 .7763 Mtetra
.806 .892 .473 r
.57967 .7763 .5826 .77164 .5852 .76627 .58229 .77091 Mtetra
.988 .881 .541 r
.58229 .77091 .5852 .76627 .58767 .75814 .58477 .76273 Mtetra
.999 .827 .535 r
.58477 .76273 .58767 .75814 .59003 .74815 .58715 .75269 Mtetra
.997 .809 .531 r
.58715 .75269 .59003 .74815 .59234 .73754 .58948 .74202 Mtetra
.999 .826 .535 r
.58948 .74202 .59234 .73754 .59467 .72765 .59183 .73207 Mtetra
.989 .88 .543 r
.59183 .73207 .59467 .72765 .59709 .71963 .59426 .72402 Mtetra
.822 .9 .487 r
.59426 .72402 .59709 .71963 .59964 .71432 .59683 .71868 Mtetra
0 0 0 r
.59683 .71868 .59964 .71432 .60237 .7121 .59956 .71646 Mtetra
.359 0 .117 r
.59956 .71646 .60237 .7121 .60527 .71283 .60247 .7172 Mtetra
.525 .119 .213 r
.60247 .7172 .60527 .71283 .60833 .71588 .60553 .72028 Mtetra
.58 .178 .245 r
.60553 .72028 .60833 .71588 .61149 .72021 .60869 .72465 Mtetra
.579 .177 .244 r
.60869 .72465 .61149 .72021 .61467 .72457 .61187 .72904 Mtetra
.524 .117 .212 r
.61187 .72904 .61467 .72457 .6178 .72765 .615 .73216 Mtetra
.356 0 .118 r
.615 .73216 .6178 .72765 .62079 .72838 .618 .73289 Mtetra
0 0 0 r
.618 .73289 .62079 .72838 .62359 .72608 .62081 .73059 Mtetra
.799 .884 .459 r
.62081 .73059 .62359 .72608 .62619 .72064 .62342 .72513 Mtetra
.983 .88 .524 r
.62342 .72513 .62619 .72064 .62859 .71254 .62584 .71699 Mtetra
1 .831 .52 r
.62584 .71699 .62859 .71254 .63085 .70272 .62812 .70712 Mtetra
.999 .817 .517 r
.62812 .70712 .63085 .70272 .63307 .69243 .63035 .69677 Mtetra
.999 .838 .521 r
.63035 .69677 .63307 .69243 .63532 .68296 .63262 .68724 Mtetra
.973 .89 .524 r
.63262 .68724 .63532 .68296 .63771 .67543 .63502 .67968 Mtetra
.723 .858 .433 r
.63502 .67968 .63771 .67543 .6403 .67064 .63762 .67486 Mtetra
0 0 0 r
.63762 .67486 .6403 .67064 .64313 .66889 .64046 .67312 Mtetra
.392 0 .124 r
.64046 .67312 .64313 .66889 .6462 .67002 .64354 .67426 Mtetra
.535 .122 .204 r
.64354 .67426 .6462 .67002 .64948 .67335 .64682 .67762 Mtetra
.582 .172 .23 r
.64682 .67762 .64948 .67335 .65287 .67783 .65021 .68214 Mtetra
.576 .166 .227 r
.65021 .68214 .65287 .67783 .65628 .68221 .65363 .68655 Mtetra
.515 .101 .193 r
.65363 .68655 .65628 .68221 .6596 .68521 .65695 .68959 Mtetra
.339 0 .097 r
.65695 .68959 .6596 .68521 .66273 .6858 .66008 .69019 Mtetra
0 0 0 r
.66008 .69019 .66273 .6858 .66559 .68336 .66296 .68774 Mtetra
.789 .874 .442 r
.66296 .68774 .66559 .68336 .66818 .67784 .66556 .6822 Mtetra
.977 .877 .504 r
.66556 .6822 .66818 .67784 .67052 .66977 .66791 .67408 Mtetra
.999 .835 .502 r
.66791 .67408 .67052 .66977 .67269 .66011 .6701 .66437 Mtetra
1 .824 .5 r
.6701 .66437 .67269 .66011 .67481 .6501 .67224 .65431 Mtetra
.996 .848 .504 r
.67224 .65431 .67481 .6501 .67701 .64103 .67445 .64519 Mtetra
.945 .895 .5 r
.67445 .64519 .67701 .64103 .67939 .63397 .67685 .6381 Mtetra
.602 .795 .372 r
.67685 .6381 .67939 .63397 .68205 .62967 .67951 .63377 Mtetra
.077 0 0 r
.67951 .63377 .68205 .62967 .68502 .62839 .68249 .63249 Mtetra
.42 0 .125 r
.68249 .63249 .68502 .62839 .68829 .6299 .68577 .63402 Mtetra
.543 .122 .192 r
.68577 .63402 .68829 .6299 .69182 .6335 .6893 .63766 Mtetra
.583 .164 .214 r
.6893 .63766 .69182 .6335 .69548 .63813 .69296 .64233 Mtetra
.573 .154 .208 r
.69296 .64233 .69548 .63813 .69914 .64253 .69663 .64677 Mtetra
.506 .084 .173 r
.69663 .64677 .69914 .64253 .70267 .64545 .70017 .64972 Mtetra
.321 0 .076 r
.70017 .64972 .70267 .64545 .70594 .6459 .70344 .65018 Mtetra
0 0 0 r
.70344 .65018 .70594 .6459 .70887 .64332 .70638 .64759 Mtetra
.776 .862 .422 r
.70638 .64759 .70887 .64332 .71145 .63772 .70898 .64197 Mtetra
.967 .873 .481 r
.70898 .64197 .71145 .63772 .71373 .62966 .71127 .63386 Mtetra
.995 .837 .481 r
.71127 .63386 .71373 .62966 .71582 .62014 .71337 .62429 Mtetra
.997 .83 .48 r
.71337 .62429 .71582 .62014 .71786 .6104 .71543 .6145 Mtetra
.986 .855 .483 r
.71543 .6145 .71786 .6104 .72001 .6017 .7176 .60575 Mtetra
.9 .89 .467 r
.7176 .60575 .72001 .6017 .72242 .5951 .72001 .59911 Mtetra
0 0 0 r
.72001 .59911 .72242 .5951 .72517 .59127 .72278 .59527 Mtetra
.153 0 0 r
.72278 .59527 .72517 .59127 .72831 .59043 .72593 .59444 Mtetra
.442 .011 .123 r
.72593 .59444 .72831 .59043 .73183 .59232 .72946 .59635 Mtetra
.55 .12 .179 r
.72946 .59635 .73183 .59232 .73564 .5962 .73327 .60026 Mtetra
.583 .155 .196 r
.73327 .60026 .73564 .5962 .7396 .60098 .73723 .60508 Mtetra
.568 .14 .188 r
.73723 .60508 .7396 .60098 .74355 .6054 .74118 .60954 Mtetra
.496 .066 .151 r
.74118 .60954 .74355 .6054 .7473 .60825 .74495 .61242 Mtetra
.303 0 .056 r
.74495 .61242 .7473 .60825 .75072 .60856 .74838 .61274 Mtetra
0 0 0 r
.74838 .61274 .75072 .60856 .75373 .60584 .75139 .61001 Mtetra
.758 .846 .397 r
.75139 .61001 .75373 .60584 .7563 .60014 .75398 .60429 Mtetra
.954 .866 .454 r
.75398 .60429 .7563 .60014 .75853 .59208 .75622 .59619 Mtetra
.987 .837 .456 r
.75622 .59619 .75853 .59208 .76053 .58268 .75824 .58674 Mtetra
.989 .833 .456 r
.75824 .58674 .76053 .58268 .76251 .5732 .76023 .5772 Mtetra
.967 .859 .457 r
.76023 .5772 .76251 .5732 .76464 .56486 .76237 .56881 Mtetra
.835 .87 .427 r
.76237 .56881 .76464 .56486 .76709 .55868 .76484 .56261 Mtetra
0 0 0 r
.76484 .56261 .76709 .55868 .76997 .55531 .76773 .55923 Mtetra
.216 0 0 r
.76773 .55923 .76997 .55531 .77333 .55492 .7711 .55884 Mtetra
.461 .021 .116 r
.7711 .55884 .77333 .55492 .77713 .55718 .77491 .56112 Mtetra
.554 .116 .163 r
.77491 .56112 .77713 .55718 .78127 .56133 .77905 .56531 Mtetra
.581 .145 .176 r
.77905 .56531 .78127 .56133 .78557 .56626 .78336 .57028 Mtetra
.563 .125 .167 r
.78336 .57028 .78557 .56626 .78982 .57071 .78762 .57477 Mtetra
.485 .047 .13 r
.78762 .57477 .78982 .57071 .79383 .57348 .79163 .57757 Mtetra
.285 0 .037 r
.79163 .57757 .79383 .57348 .79742 .57366 .79523 .57776 Mtetra
0 0 0 r
.79523 .57776 .79742 .57366 .8005 .57079 .79833 .57488 Mtetra
.736 .827 .369 r
.79833 .57488 .8005 .57079 .80307 .56499 .80091 .56905 Mtetra
.935 .856 .424 r
.80091 .56905 .80307 .56499 .80524 .55692 .80309 .56094 Mtetra
.975 .834 .427 r
.80309 .56094 .80524 .55692 .80717 .54763 .80504 .5516 Mtetra
.975 .833 .427 r
.80504 .5516 .80717 .54763 .80909 .53837 .80697 .54229 Mtetra
.938 .856 .425 r
.80697 .54229 .80909 .53837 .81122 .53038 .80912 .53425 Mtetra
.75 .835 .379 r
.80912 .53425 .81122 .53038 .81375 .52462 .81166 .52847 Mtetra
0 0 0 r
.81166 .52847 .81375 .52462 .8168 .5217 .81472 .52554 Mtetra
.266 0 .012 r
.81472 .52554 .8168 .5217 .82042 .52174 .81835 .52559 Mtetra
.475 .028 .107 r
.81835 .52559 .82042 .52174 .82456 .52437 .8225 .52825 Mtetra
.557 .11 .145 r
.8225 .52825 .82456 .52437 .82907 .52879 .82702 .53271 Mtetra
.579 .133 .155 r
.82702 .53271 .82907 .52879 .83375 .53388 .8317 .53784 Mtetra
.556 .109 .145 r
.8317 .53784 .83375 .53388 .83835 .53837 .83631 .54236 Mtetra
.474 .027 .107 r
.83631 .54236 .83835 .53837 .84263 .54107 .8406 .54509 Mtetra
.267 0 .019 r
.8406 .54509 .84263 .54107 .8464 .54111 .84439 .54514 Mtetra
0 0 0 r
.84439 .54514 .8464 .54111 .84957 .53808 .84757 .54211 Mtetra
.709 .805 .338 r
.84757 .54211 .84957 .53808 .85214 .53217 .85016 .53617 Mtetra
.911 .842 .388 r
.85016 .53617 .85214 .53217 .85425 .52408 .85228 .52803 Mtetra
.956 .827 .393 r
.85228 .52803 .85425 .52408 .85612 .51488 .85416 .51878 Mtetra
.953 .829 .393 r
.85416 .51878 .85612 .51488 .858 .50584 .85605 .50969 Mtetra
.894 .844 .386 r
.85605 .50969 .858 .50584 .86015 .49817 .85822 .50198 Mtetra
.646 .783 .324 r
.85822 .50198 .86015 .49817 .86279 .49282 .86087 .49661 Mtetra
0 0 0 r
.86087 .49661 .86279 .49282 .86606 .49035 .86415 .49413 Mtetra
.307 0 .018 r
.86415 .49413 .86606 .49035 .86999 .49082 .8681 .49461 Mtetra
.487 .031 .094 r
.8681 .49461 .86999 .49082 .87451 .49383 .87263 .49765 Mtetra
.559 .102 .125 r
.87263 .49765 .87451 .49383 .87946 .49853 .87758 .5024 Mtetra
.575 .119 .132 r
.87758 .5024 .87946 .49853 .88456 .50378 .8827 .50769 Mtetra
.548 .092 .121 r
.8827 .50769 .88456 .50378 .88955 .50831 .8877 .51226 Mtetra
.461 .006 .084 r
.8877 .51226 .88955 .50831 .89413 .51094 .8923 .51492 Mtetra
.25 0 .002 r
.8923 .51492 .89413 .51094 .89811 .51084 .89628 .51483 Mtetra
0 0 0 r
.89628 .51483 .89811 .51084 .90137 .50766 .89956 .51164 Mtetra
.677 .778 .302 r
.89956 .51164 .90137 .50766 .90395 .50163 .90215 .50557 Mtetra
.88 .822 .347 r
.90215 .50557 .90395 .50163 .90601 .49349 .90422 .49739 Mtetra
.929 .814 .353 r
.90422 .49739 .90601 .49349 .90781 .48437 .90604 .48822 Mtetra
.919 .817 .353 r
.90604 .48822 .90781 .48437 .90966 .47553 .90791 .47933 Mtetra
.833 .821 .34 r
.90791 .47933 .90966 .47553 .91186 .46818 .91012 .47194 Mtetra
0 0 0 r
.91012 .47194 .91186 .46818 .91466 .46323 .91293 .46697 Mtetra
.91293 .46697 .91466 .46323 .91819 .4612 .91648 .46493 Mtetra
.34 0 .018 r
.91648 .46493 .91819 .4612 .9225 .4621 .92079 .46586 Mtetra
.496 .031 .078 r
.92079 .46586 .9225 .4621 .92748 .4655 .92579 .46928 Mtetra
.559 .092 .103 r
.92579 .46928 .92748 .4655 .93291 .47049 .93124 .47432 Mtetra
.571 .104 .107 r
.93124 .47432 .93291 .47049 .93851 .47592 .93685 .47979 Mtetra
.54 .073 .096 r
.93685 .47979 .93851 .47592 .94393 .48049 .94228 .48441 Mtetra
.448 0 .061 r
.94228 .48441 .94393 .48049 .94885 .48306 .94722 .48701 Mtetra
.234 0 0 r
.94722 .48701 .94885 .48306 .95305 .48282 .95143 .48678 Mtetra
.918 .954 .619 r
.49616 .88098 .4994 .87706 .50204 .87181 .49881 .8757 Mtetra
.99 .851 .607 r
.49881 .8757 .50204 .87181 .50466 .86352 .50145 .86737 Mtetra
.976 .784 .58 r
.50145 .86737 .50466 .86352 .50726 .85307 .50406 .85688 Mtetra
.969 .762 .57 r
.50406 .85688 .50726 .85307 .50983 .84171 .50665 .84547 Mtetra
.972 .771 .574 r
.50665 .84547 .50983 .84171 .51238 .83083 .50923 .83453 Mtetra
.984 .816 .594 r
.50923 .83453 .51238 .83083 .51494 .82169 .5118 .82536 Mtetra
.98 .915 .629 r
.5118 .82536 .51494 .82169 .51752 .81525 .51439 .81889 Mtetra
.596 .849 .491 r
.51439 .81889 .51752 .81525 .52013 .812 .51701 .81563 Mtetra
.244 0 .002 r
.51701 .81563 .52013 .812 .52279 .81189 .51967 .81553 Mtetra
.518 .101 .189 r
.51967 .81553 .52279 .81189 .5255 .81437 .52239 .81803 Mtetra
.596 .191 .245 r
.52239 .81803 .5255 .81437 .52826 .81843 .52514 .82212 Mtetra
.605 .202 .252 r
.52514 .82212 .52826 .81843 .53104 .82279 .52792 .8265 Mtetra
.559 .148 .219 r
.52792 .8265 .53104 .82279 .53383 .82607 .5307 .82981 Mtetra
.393 0 .105 r
.5307 .82981 .53383 .82607 .53658 .82708 .53346 .83084 Mtetra
0 0 0 r
.53346 .83084 .53658 .82708 .53928 .82505 .53616 .8288 Mtetra
.918 .951 .612 r
.53616 .8288 .53928 .82505 .54191 .81973 .5388 .82346 Mtetra
.992 .853 .598 r
.5388 .82346 .54191 .81973 .54446 .8115 .54137 .81519 Mtetra
.982 .79 .572 r
.54137 .81519 .54446 .8115 .54694 .80126 .54387 .80491 Mtetra
.975 .77 .563 r
.54387 .80491 .54694 .80126 .54939 .79027 .54634 .79386 Mtetra
.979 .782 .569 r
.54634 .79386 .54939 .79027 .55183 .77987 .5488 .78341 Mtetra
.991 .834 .592 r
.5488 .78341 .55183 .77987 .55432 .77128 .5513 .77479 Mtetra
.962 .936 .623 r
.5513 .77479 .55432 .77128 .55688 .76541 .55387 .7689 Mtetra
0 0 0 r
.55387 .7689 .55688 .76541 .55953 .76269 .55653 .76617 Mtetra
.307 0 .031 r
.55653 .76617 .55953 .76269 .5623 .76302 .55931 .7665 Mtetra
.533 .11 .184 r
.55931 .7665 .5623 .76302 .56518 .7658 .56218 .76931 Mtetra
.6 .187 .232 r
.56218 .76931 .56518 .7658 .56812 .77002 .56512 .77356 Mtetra
.604 .192 .235 r
.56512 .77356 .56812 .77002 .57109 .77439 .56809 .77796 Mtetra
.552 .132 .198 r
.56809 .77796 .57109 .77439 .57404 .77759 .57104 .78118 Mtetra
.374 0 .078 r
.57104 .78118 .57404 .77759 .57692 .77847 .57392 .78207 Mtetra
0 0 0 r
.57392 .78207 .57692 .77847 .57967 .7763 .57668 .7799 Mtetra
.917 .948 .603 r
.57668 .7799 .57967 .7763 .58229 .77091 .5793 .77449 Mtetra
.994 .856 .588 r
.5793 .77449 .58229 .77091 .58477 .76273 .5818 .76627 Mtetra
.987 .796 .563 r
.5818 .76627 .58477 .76273 .58715 .75269 .5842 .75618 Mtetra
.982 .778 .555 r
.5842 .75618 .58715 .75269 .58948 .74202 .58655 .74547 Mtetra
.986 .795 .563 r
.58655 .74547 .58948 .74202 .59183 .73207 .58892 .73548 Mtetra
.994 .854 .588 r
.58892 .73548 .59183 .73207 .59426 .72402 .59136 .72739 Mtetra
.926 .949 .61 r
.59136 .72739 .59426 .72402 .59683 .71868 .59394 .72203 Mtetra
0 0 0 r
.59394 .72203 .59683 .71868 .59956 .71646 .59668 .71981 Mtetra
.357 0 .049 r
.59668 .71981 .59956 .71646 .60247 .7172 .59959 .72056 Mtetra
.546 .117 .177 r
.59959 .72056 .60247 .7172 .60553 .72028 .60265 .72366 Mtetra
.603 .182 .217 r
.60265 .72366 .60553 .72028 .60869 .72465 .60581 .72806 Mtetra
.602 .181 .217 r
.60581 .72806 .60869 .72465 .61187 .72904 .60899 .73248 Mtetra
.544 .114 .176 r
.60899 .73248 .61187 .72904 .615 .73216 .61212 .73562 Mtetra
.354 0 .05 r
.61212 .73562 .615 .73216 .618 .73289 .61512 .73637 Mtetra
0 0 0 r
.61512 .73637 .618 .73289 .62081 .73059 .61794 .73406 Mtetra
.915 .944 .591 r
.61794 .73406 .62081 .73059 .62342 .72513 .62056 .72858 Mtetra
.996 .859 .576 r
.62056 .72858 .62342 .72513 .62584 .71699 .62299 .7204 Mtetra
.991 .802 .552 r
.62299 .7204 .62584 .71699 .62812 .70712 .62529 .71048 Mtetra
.988 .788 .546 r
.62529 .71048 .62812 .70712 .63035 .69677 .62753 .70009 Mtetra
.993 .809 .555 r
.62753 .70009 .63035 .69677 .63262 .68724 .62982 .69052 Mtetra
.994 .875 .583 r
.62982 .69052 .63262 .68724 .63502 .67968 .63224 .68292 Mtetra
.865 .947 .587 r
.63224 .68292 .63502 .67968 .63762 .67486 .63485 .67809 Mtetra
0 0 0 r
.63485 .67809 .63762 .67486 .64046 .67312 .6377 .67634 Mtetra
.396 0 .06 r
.6377 .67634 .64046 .67312 .64354 .67426 .64078 .6775 Mtetra
.556 .12 .167 r
.64078 .6775 .64354 .67426 .64682 .67762 .64405 .68088 Mtetra
.604 .175 .2 r
.64405 .68088 .64682 .67762 .65021 .68214 .64745 .68543 Mtetra
.599 .169 .197 r
.64745 .68543 .65021 .68214 .65363 .68655 .65086 .68988 Mtetra
.535 .096 .153 r
.65086 .68988 .65363 .68655 .65695 .68959 .65419 .69293 Mtetra
.332 0 .022 r
.65419 .69293 .65695 .68959 .66008 .69019 .65732 .69354 Mtetra
0 0 0 r
.65732 .69354 .66008 .69019 .66296 .68774 .66021 .69109 Mtetra
.91 .939 .577 r
.66021 .69109 .66296 .68774 .66556 .6822 .66282 .68553 Mtetra
.996 .862 .563 r
.66282 .68553 .66556 .6822 .66791 .67408 .66518 .67738 Mtetra
.995 .809 .54 r
.66518 .67738 .66791 .67408 .6701 .66437 .66739 .66762 Mtetra
.994 .797 .535 r
.66739 .66762 .6701 .66437 .67224 .65431 .66954 .65752 Mtetra
.997 .823 .547 r
.66954 .65752 .67224 .65431 .67445 .64519 .67177 .64835 Mtetra
.987 .894 .576 r
.67177 .64835 .67445 .64519 .67685 .6381 .67418 .64123 Mtetra
.775 .922 .549 r
.67418 .64123 .67685 .6381 .67951 .63377 .67686 .63689 Mtetra
0 0 0 r
.67686 .63689 .67951 .63377 .68249 .63249 .67984 .63561 Mtetra
.427 0 .064 r
.67984 .63561 .68249 .63249 .68577 .63402 .68313 .63715 Mtetra
.564 .12 .154 r
.68313 .63715 .68577 .63402 .6893 .63766 .68665 .64082 Mtetra
.605 .167 .182 r
.68665 .64082 .6893 .63766 .69296 .64233 .69032 .64552 Mtetra
.595 .155 .175 r
.69032 .64552 .69296 .64233 .69663 .64677 .69399 .64999 Mtetra
.524 .076 .128 r
.69399 .64999 .69663 .64677 .70017 .64972 .69752 .65296 Mtetra
.31 0 0 r
.69752 .65296 .70017 .64972 .70344 .65018 .7008 .65343 Mtetra
0 0 0 r
.7008 .65343 .70344 .65018 .70638 .64759 .70375 .65084 Mtetra
.903 .933 .56 r
.70375 .65084 .70638 .64759 .70898 .64197 .70636 .64519 Mtetra
.996 .864 .547 r
.70636 .64519 .70898 .64197 .71127 .63386 .70867 .63705 Mtetra
.999 .815 .526 r
.70867 .63705 .71127 .63386 .71337 .62429 .71078 .62744 Mtetra
.998 .807 .522 r
.71078 .62744 .71337 .62429 .71543 .6145 .71286 .6176 Mtetra
.999 .838 .536 r
.71286 .6176 .71543 .6145 .7176 .60575 .71504 .60882 Mtetra
.97 .91 .565 r
.71504 .60882 .7176 .60575 .72001 .59911 .71747 .60215 Mtetra
.656 .871 .499 r
.71747 .60215 .72001 .59911 .72278 .59527 .72024 .59829 Mtetra
.098 0 0 r
.72024 .59829 .72278 .59527 .72593 .59444 .7234 .59746 Mtetra
.453 0 .063 r
.7234 .59746 .72593 .59444 .72946 .59635 .72693 .59939 Mtetra
.57 .118 .139 r
.72693 .59939 .72946 .59635 .73327 .60026 .73074 .60333 Mtetra
.604 .157 .161 r
.73074 .60333 .73327 .60026 .73723 .60508 .73471 .60818 Mtetra
.589 .14 .152 r
.73471 .60818 .73723 .60508 .74118 .60954 .73866 .61267 Mtetra
.513 .055 .102 r
.73866 .61267 .74118 .60954 .74495 .61242 .74243 .61557 Mtetra
.288 0 0 r
.74243 .61557 .74495 .61242 .74838 .61274 .74587 .61591 Mtetra
0 0 0 r
.74587 .61591 .74838 .61274 .75139 .61001 .74889 .61317 Mtetra
.893 .926 .54 r
.74889 .61317 .75139 .61001 .75398 .60429 .75149 .60742 Mtetra
.993 .866 .528 r
.75149 .60742 .75398 .60429 .75622 .59619 .75374 .59928 Mtetra
1 .821 .509 r
.75374 .59928 .75622 .59619 .75824 .58674 .75578 .58979 Mtetra
1 .816 .507 r
.75578 .58979 .75824 .58674 .76023 .5772 .75778 .58021 Mtetra
.997 .852 .523 r
.75778 .58021 .76023 .5772 .76237 .56881 .75994 .57179 Mtetra
.939 .92 .547 r
.75994 .57179 .76237 .56881 .76484 .56261 .76241 .56556 Mtetra
0 0 0 r
.76241 .56556 .76484 .56261 .76773 .55923 .76532 .56216 Mtetra
.177 0 0 r
.76532 .56216 .76773 .55923 .7711 .55884 .76869 .56178 Mtetra
.473 .003 .057 r
.76869 .56178 .7711 .55884 .77491 .56112 .77251 .56408 Mtetra
.574 .113 .121 r
.77251 .56408 .77491 .56112 .77905 .56531 .77665 .5683 Mtetra
.602 .145 .139 r
.77665 .5683 .77905 .56531 .78336 .57028 .78096 .5733 Mtetra
.583 .123 .127 r
.78096 .5733 .78336 .57028 .78762 .57477 .78523 .57783 Mtetra
.5 .033 .076 r
.78523 .57783 .78762 .57477 .79163 .57757 .78925 .58065 Mtetra
.265 0 0 r
.78925 .58065 .79163 .57757 .79523 .57776 .79285 .58085 Mtetra
0 0 0 r
.79285 .58085 .79523 .57776 .79833 .57488 .79596 .57796 Mtetra
.879 .916 .517 r
.79596 .57796 .79833 .57488 .80091 .56905 .79856 .57211 Mtetra
.987 .865 .506 r
.79856 .57211 .80091 .56905 .80309 .56094 .80075 .56396 Mtetra
.999 .825 .489 r
.80075 .56396 .80309 .56094 .80504 .5516 .80271 .55457 Mtetra
.80271 .55457 .80504 .5516 .80697 .54229 .80466 .54522 Mtetra
.988 .864 .506 r
.80466 .54522 .80697 .54229 .80912 .53425 .80681 .53715 Mtetra
.888 .918 .523 r
.80681 .53715 .80912 .53425 .81166 .52847 .80937 .53134 Mtetra
0 0 0 r
.80937 .53134 .81166 .52847 .81472 .52554 .81244 .5284 Mtetra
.241 0 0 r
.81244 .5284 .81472 .52554 .81835 .52559 .81608 .52846 Mtetra
.488 .011 .048 r
.81608 .52846 .81835 .52559 .8225 .52825 .82023 .53114 Mtetra
.576 .106 .101 r
.82023 .53114 .8225 .52825 .82702 .53271 .82475 .53563 Mtetra
.599 .131 .115 r
.82475 .53563 .82702 .53271 .8317 .53784 .82945 .5408 Mtetra
.575 .105 .1 r
.82945 .5408 .8317 .53784 .83631 .54236 .83406 .54536 Mtetra
.486 .009 .048 r
.83406 .54536 .83631 .54236 .8406 .54509 .83836 .54811 Mtetra
.242 0 0 r
.83836 .54811 .8406 .54509 .84439 .54514 .84215 .54816 Mtetra
0 0 0 r
.84215 .54816 .84439 .54514 .84757 .54211 .84534 .54512 Mtetra
.862 .903 .489 r
.84534 .54512 .84757 .54211 .85016 .53617 .84794 .53916 Mtetra
.978 .863 .48 r
.84794 .53916 .85016 .53617 .85228 .52803 .85008 .53098 Mtetra
.994 .828 .465 r
.85008 .53098 .85228 .52803 .85416 .51878 .85197 .52169 Mtetra
.993 .831 .467 r
.85197 .52169 .85416 .51878 .85605 .50969 .85388 .51256 Mtetra
.971 .873 .485 r
.85388 .51256 .85605 .50969 .85822 .50198 .85605 .50481 Mtetra
.814 .9 .489 r
.85605 .50481 .85822 .50198 .86087 .49661 .85872 .49942 Mtetra
0 0 0 r
.85872 .49942 .86087 .49661 .86415 .49413 .86201 .49693 Mtetra
.291 0 0 r
.86201 .49693 .86415 .49413 .8681 .49461 .86596 .49742 Mtetra
.5 .014 .034 r
.86596 .49742 .8681 .49461 .87263 .49765 .8705 .50049 Mtetra
.577 .097 .078 r
.8705 .50049 .87263 .49765 .87758 .5024 .87546 .50527 Mtetra
.594 .116 .088 r
.87546 .50527 .87758 .5024 .8827 .50769 .88059 .5106 Mtetra
.566 .085 .072 r
.88059 .5106 .8827 .50769 .8877 .51226 .8856 .5152 Mtetra
.471 0 .02 r
.8856 .5152 .8877 .51226 .8923 .51492 .8902 .51788 Mtetra
.221 0 0 r
.8902 .51788 .8923 .51492 .89628 .51483 .8942 .5178 Mtetra
0 0 0 r
.8942 .5178 .89628 .51483 .89956 .51164 .89748 .5146 Mtetra
.839 .887 .458 r
.89748 .5146 .89956 .51164 .90215 .50557 .90009 .50851 Mtetra
.964 .857 .45 r
.90009 .50851 .90215 .50557 .90422 .49739 .90218 .50029 Mtetra
.985 .828 .437 r
.90218 .50029 .90422 .49739 .90604 .48822 .904 .49107 Mtetra
.981 .835 .44 r
.904 .49107 .90604 .48822 .90791 .47933 .90588 .48215 Mtetra
.94 .875 .458 r
.90588 .48215 .90791 .47933 .91012 .47194 .90811 .47472 Mtetra
.717 .863 .447 r
.90811 .47472 .91012 .47194 .91293 .46697 .91093 .46973 Mtetra
0 0 0 r
.91093 .46973 .91293 .46697 .91648 .46493 .91449 .46769 Mtetra
.33 0 0 r
.91449 .46769 .91648 .46493 .92079 .46586 .91881 .46862 Mtetra
.509 .014 .017 r
.91881 .46862 .92079 .46586 .92579 .46928 .92382 .47208 Mtetra
.576 .085 .053 r
.92382 .47208 .92579 .46928 .93124 .47432 .92928 .47715 Mtetra
.588 .099 .06 r
.92928 .47715 .93124 .47432 .93685 .47979 .9349 .48266 Mtetra
.556 .064 .042 r
.9349 .48266 .93685 .47979 .94228 .48441 .94035 .48731 Mtetra
.456 0 0 r
.94035 .48731 .94228 .48441 .94722 .48701 .9453 .48993 Mtetra
.2 0 0 r
.9453 .48993 .94722 .48701 .95143 .48678 .94952 .48971 Mtetra
.945 .876 .736 r
.4929 .88256 .49616 .88098 .49881 .8757 .49556 .87727 Mtetra
.934 .755 .637 r
.49556 .87727 .49881 .8757 .50145 .86737 .4982 .86892 Mtetra
.921 .708 .598 r
.4982 .86892 .50145 .86737 .50406 .85688 .50084 .8584 Mtetra
.916 .692 .585 r
.50084 .8584 .50406 .85688 .50665 .84547 .50344 .84695 Mtetra
.918 .698 .59 r
.50344 .84695 .50665 .84547 .50923 .83453 .50604 .83599 Mtetra
.927 .73 .616 r
.50604 .83599 .50923 .83453 .5118 .82536 .50863 .82679 Mtetra
.942 .81 .684 r
.50863 .82679 .5118 .82536 .51439 .81889 .51122 .82031 Mtetra
.872 .985 .833 r
.51122 .82031 .51439 .81889 .51701 .81563 .51385 .81704 Mtetra
.135 0 0 r
.51385 .81704 .51701 .81563 .51967 .81553 .51651 .81694 Mtetra
.568 .086 .07 r
.51651 .81694 .51967 .81553 .52239 .81803 .51922 .81945 Mtetra
.655 .205 .171 r
.51922 .81945 .52239 .81803 .52514 .82212 .52197 .82356 Mtetra
.665 .219 .183 r
.52197 .82356 .52514 .82212 .52792 .8265 .52474 .82795 Mtetra
.616 .15 .125 r
.52474 .82795 .52792 .8265 .5307 .82981 .52752 .83127 Mtetra
.395 0 0 r
.52752 .83127 .5307 .82981 .53346 .83084 .53027 .83231 Mtetra
.598 .945 .791 r
.53027 .83231 .53346 .83084 .53616 .8288 .53298 .83027 Mtetra
.948 .875 .731 r
.53298 .83027 .53616 .8288 .5388 .82346 .53563 .82491 Mtetra
.938 .759 .633 r
.53563 .82491 .5388 .82346 .54137 .81519 .53821 .81663 Mtetra
.926 .712 .594 r
.53821 .81663 .54137 .81519 .54387 .80491 .54072 .80632 Mtetra
.922 .698 .582 r
.54072 .80632 .54387 .80491 .54634 .79386 .54321 .79524 Mtetra
.924 .707 .589 r
.54321 .79524 .54634 .79386 .5488 .78341 .54569 .78476 Mtetra
.934 .744 .621 r
.54569 .78476 .5488 .78341 .5513 .77479 .5482 .77612 Mtetra
.947 .838 .703 r
.5482 .77612 .5513 .77479 .55387 .7689 .55078 .77021 Mtetra
.794 .998 .847 r
.55078 .77021 .55387 .7689 .55653 .76617 .55345 .76747 Mtetra
.248 0 0 r
.55345 .76747 .55653 .76617 .55931 .7665 .55622 .76781 Mtetra
.585 .099 .068 r
.55622 .76781 .55931 .7665 .56218 .76931 .55909 .77063 Mtetra
.658 .2 .153 r
.55909 .77063 .56218 .76931 .56512 .77356 .56202 .77489 Mtetra
.662 .206 .159 r
.56202 .77489 .56512 .77356 .56809 .77796 .56499 .77931 Mtetra
.606 .128 .093 r
.56499 .77931 .56809 .77796 .57104 .78118 .56793 .78254 Mtetra
.362 0 0 r
.56793 .78254 .57104 .78118 .57392 .78207 .57081 .78344 Mtetra
.634 .96 .809 r
.57081 .78344 .57392 .78207 .57668 .7799 .57357 .78126 Mtetra
.951 .876 .726 r
.57357 .78126 .57668 .7799 .5793 .77449 .57621 .77584 Mtetra
.943 .762 .628 r
.57621 .77584 .5793 .77449 .5818 .76627 .57872 .7676 Mtetra
.932 .717 .589 r
.57872 .7676 .5818 .76627 .5842 .75618 .58113 .75748 Mtetra
.928 .704 .578 r
.58113 .75748 .5842 .75618 .58655 .74547 .5835 .74674 Mtetra
.932 .716 .589 r
.5835 .74674 .58655 .74547 .58892 .73548 .58588 .73672 Mtetra
.942 .76 .627 r
.58588 .73672 .58892 .73548 .59136 .72739 .58834 .72861 Mtetra
.949 .87 .725 r
.58834 .72861 .59136 .72739 .59394 .72203 .59092 .72324 Mtetra
.669 .975 .834 r
.59092 .72324 .59394 .72203 .59668 .71981 .59366 .72101 Mtetra
.33 0 0 r
.59366 .72101 .59668 .71981 .59959 .72056 .59658 .72177 Mtetra
.597 .107 .061 r
.59658 .72177 .59959 .72056 .60265 .72366 .59963 .72488 Mtetra
.659 .192 .134 r
.59963 .72488 .60265 .72366 .60581 .72806 .60278 .7293 Mtetra
.658 .191 .133 r
.60278 .7293 .60581 .72806 .60899 .73248 .60596 .73374 Mtetra
.595 .104 .059 r
.60596 .73374 .60899 .73248 .61212 .73562 .60908 .73688 Mtetra
.326 0 0 r
.60908 .73688 .61212 .73562 .61512 .73637 .61208 .73764 Mtetra
.663 .972 .822 r
.61208 .73764 .61512 .73637 .61794 .73406 .61491 .73532 Mtetra
.954 .877 .721 r
.61491 .73532 .61794 .73406 .62056 .72858 .61753 .72983 Mtetra
.948 .767 .623 r
.61753 .72983 .62056 .72858 .62299 .7204 .61998 .72163 Mtetra
.938 .722 .584 r
.61998 .72163 .62299 .7204 .62529 .71048 .62229 .71169 Mtetra
.935 .711 .575 r
.62229 .71169 .62529 .71048 .62753 .70009 .62455 .70126 Mtetra
.939 .727 .589 r
.62455 .70126 .62753 .70009 .62982 .69052 .62685 .69167 Mtetra
.95 .779 .635 r
.62685 .69167 .62982 .69052 .63224 .68292 .62928 .68405 Mtetra
.945 .905 .751 r
.62928 .68405 .63224 .68292 .63485 .67809 .6319 .6792 Mtetra
.502 .903 .786 r
.6319 .6792 .63485 .67809 .6377 .67634 .63475 .67746 Mtetra
.39 0 0 r
.63475 .67746 .6377 .67634 .64078 .6775 .63783 .67862 Mtetra
.607 .111 .05 r
.63783 .67862 .64078 .6775 .64405 .68088 .6411 .68201 Mtetra
.659 .183 .111 r
.6411 .68201 .64405 .68088 .64745 .68543 .64449 .68658 Mtetra
.653 .175 .104 r
.64449 .68658 .64745 .68543 .65086 .68988 .6479 .69104 Mtetra
.582 .078 .022 r
.6479 .69104 .65086 .68988 .65419 .69293 .65122 .69411 Mtetra
.287 0 0 r
.65122 .69411 .65419 .69293 .65732 .69354 .65436 .69472 Mtetra
.688 .98 .829 r
.65436 .69472 .65732 .69354 .66021 .69109 .65724 .69227 Mtetra
.957 .879 .715 r
.65724 .69227 .66021 .69109 .66282 .68553 .65986 .68669 Mtetra
.954 .771 .618 r
.65986 .68669 .66282 .68553 .66518 .67738 .66224 .67852 Mtetra
.945 .728 .579 r
.66224 .67852 .66518 .67738 .66739 .66762 .66446 .66873 Mtetra
.943 .719 .571 r
.66446 .66873 .66739 .66762 .66954 .65752 .66663 .6586 Mtetra
.947 .739 .589 r
.66663 .6586 .66954 .65752 .67177 .64835 .66887 .64941 Mtetra
.958 .801 .646 r
.66887 .64941 .67177 .64835 .67418 .64123 .67129 .64227 Mtetra
.932 .941 .78 r
.67129 .64227 .67418 .64123 .67686 .63689 .67397 .63792 Mtetra
.317 .793 .709 r
.67397 .63792 .67686 .63689 .67984 .63561 .67696 .63664 Mtetra
.435 0 0 r
.67696 .63664 .67984 .63561 .68313 .63715 .68024 .63819 Mtetra
.613 .111 .034 r
.68024 .63819 .68313 .63715 .68665 .64082 .68377 .64186 Mtetra
.657 .171 .086 r
.68377 .64186 .68665 .64082 .69032 .64552 .68743 .64658 Mtetra
.647 .157 .074 r
.68743 .64658 .69032 .64552 .69399 .64999 .69109 .65107 Mtetra
.566 .05 0 r
.69109 .65107 .69399 .64999 .69752 .65296 .69463 .65405 Mtetra
.246 0 0 r
.69463 .65405 .69752 .65296 .7008 .65343 .69791 .65453 Mtetra
.707 .985 .833 r
.69791 .65453 .7008 .65343 .70375 .65084 .70086 .65193 Mtetra
.961 .882 .709 r
.70086 .65193 .70375 .65084 .70636 .64519 .70347 .64627 Mtetra
.96 .777 .611 r
.70347 .64627 .70636 .64519 .70867 .63705 .70579 .63811 Mtetra
.952 .735 .573 r
.70579 .63811 .70867 .63705 .71078 .62744 .70793 .62846 Mtetra
.95 .728 .567 r
.70793 .62846 .71078 .62744 .71286 .6176 .71001 .6186 Mtetra
.956 .753 .59 r
.71001 .6186 .71286 .6176 .71504 .60882 .71221 .60979 Mtetra
.964 .826 .658 r
.71221 .60979 .71504 .60882 .71747 .60215 .71465 .60311 Mtetra
.901 .974 .809 r
.71465 .60311 .71747 .60215 .72024 .59829 .71742 .59924 Mtetra
0 0 0 r
.71742 .59924 .72024 .59829 .7234 .59746 .72059 .59841 Mtetra
.468 0 0 r
.72059 .59841 .7234 .59746 .72693 .59939 .72411 .60035 Mtetra
.617 .107 .016 r
.72411 .60035 .72693 .59939 .73074 .60333 .72793 .6043 Mtetra
.654 .158 .059 r
.72793 .6043 .73074 .60333 .73471 .60818 .73189 .60917 Mtetra
.638 .136 .04 r
.73189 .60917 .73471 .60818 .73866 .61267 .73584 .61368 Mtetra
.549 .019 0 r
.73584 .61368 .73866 .61267 .74243 .61557 .7396 .61659 Mtetra
.204 0 0 r
.7396 .61659 .74243 .61557 .74587 .61591 .74304 .61692 Mtetra
.723 .989 .834 r
.74304 .61692 .74587 .61591 .74889 .61317 .74607 .61418 Mtetra
.965 .886 .702 r
.74607 .61418 .74889 .61317 .75149 .60742 .74868 .60842 Mtetra
.966 .783 .604 r
.74868 .60842 .75149 .60742 .75374 .59928 .75094 .60026 Mtetra
.959 .742 .566 r
.75094 .60026 .75374 .59928 .75578 .58979 .75299 .59074 Mtetra
.958 .738 .563 r
.75299 .59074 .75578 .58979 .75778 .58021 .75501 .58113 Mtetra
.964 .769 .592 r
.75501 .58113 .75778 .58021 .75994 .57179 .75718 .57268 Mtetra
.968 .855 .674 r
.75718 .57268 .75994 .57179 .76241 .56556 .75966 .56644 Mtetra
.846 .996 .832 r
.75966 .56644 .76241 .56556 .76532 .56216 .76257 .56304 Mtetra
.002 0 0 r
.76257 .56304 .76532 .56216 .76869 .56178 .76595 .56266 Mtetra
.492 0 0 r
.76595 .56266 .76869 .56178 .77251 .56408 .76976 .56497 Mtetra
.618 .101 0 r
.76976 .56497 .77251 .56408 .77665 .5683 .77391 .5692 Mtetra
.649 .142 .028 r
.77391 .5692 .77665 .5683 .78096 .5733 .77821 .57422 Mtetra
.628 .114 .005 r
.77821 .57422 .78096 .5733 .78523 .57783 .78247 .57876 Mtetra
.529 0 0 r
.78247 .57876 .78523 .57783 .78925 .58065 .78649 .58159 Mtetra
.162 0 0 r
.78649 .58159 .78925 .58065 .79285 .58085 .7901 .58179 Mtetra
.735 .991 .832 r
.7901 .58179 .79285 .58085 .79596 .57796 .79321 .5789 Mtetra
.969 .89 .694 r
.79321 .5789 .79596 .57796 .79856 .57211 .79581 .57303 Mtetra
.973 .789 .596 r
.79581 .57303 .79856 .57211 .80075 .56396 .79802 .56486 Mtetra
.967 .75 .558 r
.79802 .56486 .80075 .56396 .80271 .55457 .79999 .55545 Mtetra
.967 .749 .558 r
.79999 .55545 .80271 .55457 .80466 .54522 .80195 .54607 Mtetra
.973 .788 .595 r
.80195 .54607 .80466 .54522 .80681 .53715 .80412 .53798 Mtetra
.969 .886 .693 r
.80412 .53798 .80681 .53715 .80937 .53134 .80668 .53215 Mtetra
.757 .995 .843 r
.80668 .53215 .80937 .53134 .81244 .5284 .80976 .52921 Mtetra
.116 0 0 r
.80976 .52921 .81244 .5284 .81608 .52846 .8134 .52927 Mtetra
.509 0 0 r
.8134 .52927 .81608 .52846 .82023 .53114 .81755 .53196 Mtetra
.617 .091 0 r
.81755 .53196 .82023 .53114 .82475 .53563 .82207 .53647 Mtetra
.642 .124 0 r
.82207 .53647 .82475 .53563 .82945 .5408 .82676 .54165 Mtetra
.616 .089 0 r
.82676 .54165 .82945 .5408 .83406 .54536 .83138 .54622 Mtetra
.507 0 0 r
.83138 .54622 .83406 .54536 .83836 .54811 .83567 .54899 Mtetra
.12 0 0 r
.83567 .54899 .83836 .54811 .84215 .54816 .83947 .54905 Mtetra
.744 .993 .827 r
.83947 .54905 .84215 .54816 .84534 .54512 .84266 .546 Mtetra
.973 .895 .685 r
.84266 .546 .84534 .54512 .84794 .53916 .84527 .54002 Mtetra
.98 .796 .586 r
.84527 .54002 .84794 .53916 .85008 .53098 .84742 .53181 Mtetra
.974 .758 .549 r
.84742 .53181 .85008 .53098 .85197 .52169 .84933 .5225 Mtetra
.975 .762 .553 r
.84933 .5225 .85197 .52169 .85388 .51256 .85124 .51334 Mtetra
.98 .808 .598 r
.85124 .51334 .85388 .51256 .85605 .50481 .85343 .50558 Mtetra
.963 .919 .714 r
.85343 .50558 .85605 .50481 .85872 .49942 .85611 .50017 Mtetra
.633 .962 .833 r
.85611 .50017 .85872 .49942 .86201 .49693 .8594 .49767 Mtetra
.202 0 0 r
.8594 .49767 .86201 .49693 .86596 .49742 .86336 .49817 Mtetra
.52 0 0 r
.86336 .49817 .86596 .49742 .8705 .50049 .8679 .50124 Mtetra
.613 .078 0 r
.8679 .50124 .8705 .50049 .87546 .50527 .87286 .50604 Mtetra
.632 .103 0 r
.87286 .50604 .87546 .50527 .88059 .5106 .87798 .51139 Mtetra
.601 .063 0 r
.87798 .51139 .88059 .5106 .8856 .5152 .88299 .51601 Mtetra
.482 0 0 r
.88299 .51601 .8856 .5152 .8902 .51788 .8876 .5187 Mtetra
.08 0 0 r
.8876 .5187 .8902 .51788 .8942 .5178 .8916 .51862 Mtetra
.749 .993 .82 r
.8916 .51862 .8942 .5178 .89748 .5146 .89489 .51541 Mtetra
.977 .901 .675 r
.89489 .51541 .89748 .5146 .90009 .50851 .8975 .5093 Mtetra
.986 .804 .575 r
.8975 .5093 .90009 .50851 .90218 .50029 .8996 .50106 Mtetra
.982 .768 .539 r
.8996 .50106 .90218 .50029 .904 .49107 .90144 .49182 Mtetra
.983 .776 .547 r
.90144 .49182 .904 .49107 .90588 .48215 .90333 .48287 Mtetra
.987 .832 .603 r
.90333 .48287 .90588 .48215 .90811 .47472 .90557 .47542 Mtetra
.946 .953 .738 r
.90557 .47542 .90811 .47472 .91093 .46973 .90839 .47041 Mtetra
.484 .896 .799 r
.90839 .47041 .91093 .46973 .91449 .46769 .91196 .46837 Mtetra
.265 0 0 r
.91196 .46837 .91449 .46769 .91881 .46862 .91629 .46931 Mtetra
.526 0 0 r
.91629 .46931 .91881 .46862 .92382 .47208 .92129 .47278 Mtetra
.607 .063 0 r
.92129 .47278 .92382 .47208 .92928 .47715 .92675 .47787 Mtetra
.621 .081 0 r
.92675 .47787 .92928 .47715 .9349 .48266 .93237 .4834 Mtetra
.584 .034 0 r
.93237 .4834 .9349 .48266 .94035 .48731 .93782 .48806 Mtetra
.456 0 0 r
.93782 .48806 .94035 .48731 .9453 .48993 .94277 .4907 Mtetra
.042 0 0 r
.94277 .4907 .9453 .48993 .94952 .48971 .947 .49047 Mtetra
.808 .666 .705 r
.48962 .88101 .4929 .88256 .49556 .87727 .49229 .87571 Mtetra
.832 .628 .628 r
.49229 .87571 .49556 .87727 .4982 .86892 .49494 .86736 Mtetra
.838 .612 .596 r
.49494 .86736 .4982 .86892 .50084 .8584 .49759 .85683 Mtetra
.84 .606 .585 r
.49759 .85683 .50084 .8584 .50344 .84695 .50021 .84538 Mtetra
.839 .608 .589 r
.50021 .84538 .50344 .84695 .50604 .83599 .50282 .83442 Mtetra
.835 .62 .611 r
.50282 .83442 .50604 .83599 .50863 .82679 .50542 .82521 Mtetra
.821 .646 .665 r
.50542 .82521 .50863 .82679 .51122 .82031 .50802 .81872 Mtetra
.76 .702 .796 r
.50802 .81872 .51122 .82031 .51385 .81704 .51065 .81545 Mtetra
.265 .637 .963 r
.51065 .81545 .51385 .81704 .51651 .81694 .5133 .81535 Mtetra
.596 .024 0 r
.5133 .81535 .51651 .81694 .51922 .81945 .516 .81786 Mtetra
.738 .22 0 r
.516 .81786 .51922 .81945 .52197 .82356 .51874 .82196 Mtetra
.75 .24 0 r
.51874 .82196 .52197 .82356 .52474 .82795 .5215 .82636 Mtetra
.682 .136 0 r
.5215 .82636 .52474 .82795 .52752 .83127 .52427 .82967 Mtetra
0 .358 .734 r
.52427 .82967 .52752 .83127 .53027 .83231 .52702 .83071 Mtetra
.678 .729 .889 r
.52702 .83071 .53027 .83231 .53298 .83027 .52973 .82866 Mtetra
.811 .666 .703 r
.52973 .82866 .53298 .83027 .53563 .82491 .53238 .8233 Mtetra
.834 .629 .626 r
.53238 .8233 .53563 .82491 .53821 .81663 .53497 .81501 Mtetra
.841 .613 .593 r
.53497 .81501 .53821 .81663 .54072 .80632 .5375 .8047 Mtetra
.843 .608 .583 r
.5375 .8047 .54072 .80632 .54321 .79524 .53999 .79362 Mtetra
.841 .611 .589 r
.53999 .79362 .54321 .79524 .54569 .78476 .54248 .78314 Mtetra
.836 .624 .616 r
.54248 .78314 .54569 .78476 .5482 .77612 .54501 .77449 Mtetra
.818 .655 .68 r
.54501 .77449 .5482 .77612 .55078 .77021 .54759 .76858 Mtetra
.732 .713 .833 r
.54759 .76858 .55078 .77021 .55345 .76747 .55026 .76584 Mtetra
.099 .549 .911 r
.55026 .76584 .55345 .76747 .55622 .76781 .55303 .76617 Mtetra
.615 .048 0 r
.55303 .76617 .55622 .76781 .55909 .77063 .55588 .76899 Mtetra
.733 .21 0 r
.55588 .76899 .55909 .77063 .56202 .77489 .55881 .77325 Mtetra
.739 .22 0 r
.55881 .77325 .56202 .77489 .56499 .77931 .56176 .77766 Mtetra
.655 .098 0 r
.56176 .77766 .56499 .77931 .56793 .78254 .5647 .78089 Mtetra
0 .412 .794 r
.5647 .78089 .56793 .78254 .57081 .78344 .56757 .78178 Mtetra
.686 .727 .881 r
.56757 .78178 .57081 .78344 .57357 .78126 .57033 .7796 Mtetra
.813 .666 .7 r
.57033 .7796 .57357 .78126 .57621 .77584 .57297 .77418 Mtetra
.837 .63 .623 r
.57297 .77418 .57621 .77584 .57872 .7676 .57549 .76594 Mtetra
.844 .614 .591 r
.57549 .76594 .57872 .7676 .58113 .75748 .57792 .75581 Mtetra
.845 .609 .581 r
.57792 .75581 .58113 .75748 .5835 .74674 .58029 .74507 Mtetra
.844 .614 .59 r
.58029 .74507 .5835 .74674 .58588 .73672 .58269 .73505 Mtetra
.837 .63 .622 r
.58269 .73505 .58588 .73672 .58834 .72861 .58515 .72693 Mtetra
.813 .664 .698 r
.58515 .72693 .58834 .72861 .59092 .72324 .58774 .72156 Mtetra
.69 .722 .873 r
.58774 .72156 .59092 .72324 .59366 .72101 .59049 .71932 Mtetra
0 .453 .837 r
.59049 .71932 .59366 .72101 .59658 .72177 .59339 .72008 Mtetra
.627 .063 0 r
.59339 .72008 .59658 .72177 .59963 .72488 .59644 .72318 Mtetra
.725 .197 0 r
.59644 .72318 .59963 .72488 .60278 .7293 .59958 .7276 Mtetra
.724 .196 0 r
.59958 .7276 .60278 .7293 .60596 .73374 .60274 .73203 Mtetra
.623 .058 0 r
.60274 .73203 .60596 .73374 .60908 .73688 .60586 .73518 Mtetra
0 .459 .842 r
.60586 .73518 .60908 .73688 .61208 .73764 .60885 .73593 Mtetra
.693 .724 .874 r
.60885 .73593 .61208 .73764 .61491 .73532 .61168 .73361 Mtetra
.816 .667 .698 r
.61168 .73361 .61491 .73532 .61753 .72983 .61431 .72811 Mtetra
.84 .631 .62 r
.61431 .72811 .61753 .72983 .61998 .72163 .61676 .71991 Mtetra
.847 .615 .588 r
.61676 .71991 .61998 .72163 .62229 .71169 .61908 .70996 Mtetra
.848 .611 .58 r
.61908 .70996 .62229 .71169 .62455 .70126 .62136 .69953 Mtetra
.846 .617 .591 r
.62136 .69953 .62455 .70126 .62685 .69167 .62367 .68994 Mtetra
.837 .636 .63 r
.62367 .68994 .62685 .69167 .62928 .68405 .62611 .68232 Mtetra
.805 .675 .72 r
.62611 .68232 .62928 .68405 .6319 .6792 .62873 .67747 Mtetra
.633 .723 .913 r
.62873 .67747 .6319 .6792 .63475 .67746 .63158 .67572 Mtetra
0 .364 .76 r
.63158 .67572 .63475 .67746 .63783 .67862 .63465 .67687 Mtetra
.631 .069 0 r
.63465 .67687 .63783 .67862 .6411 .68201 .63791 .68026 Mtetra
.715 .181 0 r
.63791 .68026 .6411 .68201 .64449 .68658 .64129 .68483 Mtetra
.707 .17 0 r
.64129 .68483 .64449 .68658 .6479 .69104 .64469 .68929 Mtetra
.585 .014 0 r
.64469 .68929 .6479 .69104 .65122 .69411 .648 .69235 Mtetra
.027 .499 .879 r
.648 .69235 .65122 .69411 .65436 .69472 .65113 .69296 Mtetra
.7 .723 .867 r
.65113 .69296 .65436 .69472 .65724 .69227 .65402 .6905 Mtetra
.819 .667 .695 r
.65402 .6905 .65724 .69227 .65986 .68669 .65664 .68492 Mtetra
.843 .633 .617 r
.65664 .68492 .65986 .68669 .66224 .67852 .65903 .67674 Mtetra
.85 .617 .585 r
.65903 .67674 .66224 .67852 .66446 .66873 .66126 .66695 Mtetra
.852 .614 .578 r
.66126 .66695 .66446 .66873 .66663 .6586 .66344 .65682 Mtetra
.849 .621 .594 r
.66344 .65682 .66663 .6586 .66887 .64941 .66569 .64762 Mtetra
.837 .643 .64 r
.66569 .64762 .66887 .64941 .67129 .64227 .66812 .64048 Mtetra
.794 .686 .746 r
.66812 .64048 .67129 .64227 .67397 .63792 .6708 .63613 Mtetra
.556 .714 .946 r
.6708 .63613 .67397 .63792 .67696 .63664 .67379 .63484 Mtetra
0 .29 .692 r
.67379 .63484 .67696 .63664 .68024 .63819 .67707 .63639 Mtetra
.631 .07 0 r
.67707 .63639 .68024 .63819 .68377 .64186 .68058 .64006 Mtetra
.703 .163 0 r
.68058 .64006 .68377 .64186 .68743 .64658 .68423 .64478 Mtetra
.687 .141 0 r
.68423 .64478 .68743 .64658 .69109 .65107 .68788 .64926 Mtetra
.543 0 0 r
.68788 .64926 .69109 .65107 .69463 .65405 .6914 .65224 Mtetra
.089 .532 .907 r
.6914 .65224 .69463 .65405 .69791 .65453 .69468 .65271 Mtetra
.706 .721 .862 r
.69468 .65271 .69791 .65453 .70086 .65193 .69763 .65011 Mtetra
.822 .668 .693 r
.69763 .65011 .70086 .65193 .70347 .64627 .70025 .64444 Mtetra
.847 .634 .614 r
.70025 .64444 .70347 .64627 .70579 .63811 .70258 .63627 Mtetra
.854 .619 .582 r
.70258 .63627 .70579 .63811 .70793 .62846 .70472 .62663 Mtetra
.855 .616 .577 r
.70472 .62663 .70793 .62846 .71001 .6186 .70682 .61676 Mtetra
.851 .626 .597 r
.70682 .61676 .71001 .6186 .71221 .60979 .70903 .60795 Mtetra
.836 .651 .652 r
.70903 .60795 .71221 .60979 .71465 .60311 .71147 .60126 Mtetra
.777 .698 .776 r
.71147 .60126 .71465 .60311 .71742 .59924 .71425 .59739 Mtetra
.459 .689 .966 r
.71425 .59739 .71742 .59924 .72059 .59841 .71741 .59656 Mtetra
0 .234 .639 r
.71741 .59656 .72059 .59841 .72411 .60035 .72093 .59849 Mtetra
.626 .065 0 r
.72093 .59849 .72411 .60035 .72793 .6043 .72473 .60244 Mtetra
.687 .141 0 r
.72473 .60244 .72793 .6043 .73189 .60917 .72868 .6073 Mtetra
.662 .109 0 r
.72868 .6073 .73189 .60917 .73584 .61368 .73262 .61181 Mtetra
.496 0 0 r
.73262 .61181 .73584 .61368 .7396 .61659 .73637 .61471 Mtetra
.144 .558 .927 r
.73637 .61471 .7396 .61659 .74304 .61692 .73981 .61504 Mtetra
.711 .721 .857 r
.73981 .61504 .74304 .61692 .74607 .61418 .74283 .6123 Mtetra
.825 .67 .69 r
.74283 .6123 .74607 .61418 .74868 .60842 .74545 .60653 Mtetra
.851 .636 .611 r
.74545 .60653 .74868 .60842 .75094 .60026 .74772 .59837 Mtetra
.858 .621 .579 r
.74772 .59837 .75094 .60026 .75299 .59074 .74978 .58884 Mtetra
.858 .619 .576 r
.74978 .58884 .75299 .59074 .75501 .58113 .75181 .57923 Mtetra
.853 .631 .601 r
.75181 .57923 .75501 .58113 .75718 .57268 .75399 .57078 Mtetra
.834 .66 .667 r
.75399 .57078 .75718 .57268 .75966 .56644 .75648 .56453 Mtetra
.753 .709 .81 r
.75648 .56453 .75966 .56644 .76257 .56304 .75939 .56113 Mtetra
.349 .649 .967 r
.75939 .56113 .76257 .56304 .76595 .56266 .76276 .56074 Mtetra
.369 0 0 r
.76276 .56074 .76595 .56266 .76976 .56497 .76657 .56305 Mtetra
.616 .055 0 r
.76657 .56305 .76976 .56497 .77391 .5692 .7707 .56727 Mtetra
.668 .117 0 r
.7707 .56727 .77391 .5692 .77821 .57422 .77499 .57229 Mtetra
.633 .075 0 r
.77499 .57229 .77821 .57422 .78247 .57876 .77924 .57682 Mtetra
.445 0 0 r
.77924 .57682 .78247 .57876 .78649 .58159 .78325 .57965 Mtetra
.192 .58 .941 r
.78325 .57965 .78649 .58159 .7901 .58179 .78685 .57985 Mtetra
.717 .721 .853 r
.78685 .57985 .7901 .58179 .79321 .5789 .78996 .57695 Mtetra
.829 .672 .688 r
.78996 .57695 .79321 .5789 .79581 .57303 .79257 .57108 Mtetra
.855 .638 .608 r
.79257 .57108 .79581 .57303 .79802 .56486 .79479 .5629 Mtetra
.862 .623 .576 r
.79479 .5629 .79802 .56486 .79999 .55545 .79677 .55349 Mtetra
.79677 .55349 .79999 .55545 .80195 .54607 .79874 .54411 Mtetra
.855 .637 .607 r
.79874 .54411 .80195 .54607 .80412 .53798 .80092 .53601 Mtetra
.829 .67 .685 r
.80092 .53601 .80412 .53798 .80668 .53215 .80349 .53018 Mtetra
.72 .717 .847 r
.80349 .53018 .80668 .53215 .80976 .52921 .80657 .52724 Mtetra
.235 .596 .95 r
.80657 .52724 .80976 .52921 .8134 .52927 .8102 .52729 Mtetra
.396 0 0 r
.8102 .52729 .8134 .52927 .81755 .53196 .81434 .52998 Mtetra
.603 .041 0 r
.81434 .52998 .81755 .53196 .82207 .53647 .81885 .53448 Mtetra
.645 .091 0 r
.81885 .53448 .82207 .53647 .82676 .54165 .82353 .53965 Mtetra
.601 .039 0 r
.82353 .53965 .82676 .54165 .83138 .54622 .82813 .54422 Mtetra
.392 0 0 r
.82813 .54422 .83138 .54622 .83567 .54899 .83242 .54698 Mtetra
.234 .597 .95 r
.83242 .54698 .83567 .54899 .83947 .54905 .83621 .54703 Mtetra
.722 .721 .849 r
.83621 .54703 .83947 .54905 .84266 .546 .8394 .54398 Mtetra
.833 .674 .685 r
.8394 .54398 .84266 .546 .84527 .54002 .84202 .538 Mtetra
.859 .64 .604 r
.84202 .538 .84527 .54002 .84742 .53181 .84418 .52979 Mtetra
.866 .626 .573 r
.84418 .52979 .84742 .53181 .84933 .5225 .84609 .52047 Mtetra
.866 .627 .576 r
.84609 .52047 .84933 .5225 .85124 .51334 .84802 .51131 Mtetra
.857 .644 .614 r
.84802 .51131 .85124 .51334 .85343 .50558 .85021 .50354 Mtetra
.823 .682 .708 r
.85021 .50354 .85343 .50558 .85611 .50017 .85289 .49813 Mtetra
.675 .721 .884 r
.85289 .49813 .85611 .50017 .8594 .49767 .85619 .49563 Mtetra
.128 .537 .919 r
.85619 .49563 .8594 .49767 .86336 .49817 .86014 .49612 Mtetra
.411 0 0 r
.86014 .49612 .86336 .49817 .8679 .50124 .86467 .49919 Mtetra
.586 .024 0 r
.86467 .49919 .8679 .50124 .87286 .50604 .86962 .50398 Mtetra
.619 .061 0 r
.86962 .50398 .87286 .50604 .87798 .51139 .87473 .50932 Mtetra
.564 .001 0 r
.87473 .50932 .87798 .51139 .88299 .51601 .87972 .51393 Mtetra
0 .214 .635 r
.87972 .51393 .88299 .51601 .8876 .5187 .88432 .51662 Mtetra
.27 .611 .956 r
.88432 .51662 .8876 .5187 .8916 .51862 .88831 .51653 Mtetra
.727 .723 .846 r
.88831 .51653 .8916 .51862 .89489 .51541 .8916 .51332 Mtetra
.838 .677 .683 r
.8916 .51332 .89489 .51541 .8975 .5093 .89422 .50721 Mtetra
.864 .643 .601 r
.89422 .50721 .8975 .5093 .8996 .50106 .89633 .49896 Mtetra
.871 .629 .57 r
.89633 .49896 .8996 .50106 .90144 .49182 .89818 .48972 Mtetra
.869 .632 .577 r
.89818 .48972 .90144 .49182 .90333 .48287 .90008 .48076 Mtetra
.858 .653 .624 r
.90008 .48076 .90333 .48287 .90557 .47542 .90233 .47331 Mtetra
.812 .694 .734 r
.90233 .47331 .90557 .47542 .90839 .47041 .90516 .46831 Mtetra
.617 .718 .918 r
.90516 .46831 .90839 .47041 .91196 .46837 .90872 .46625 Mtetra
.036 .48 .882 r
.90872 .46625 .91196 .46837 .91629 .46931 .91305 .46719 Mtetra
.417 0 0 r
.91305 .46719 .91629 .46931 .92129 .47278 .91804 .47065 Mtetra
.565 .004 0 r
.91804 .47065 .92129 .47278 .92675 .47787 .92348 .47573 Mtetra
.589 .03 0 r
.92348 .47573 .92675 .47787 .93237 .4834 .92909 .48126 Mtetra
.524 0 0 r
.92909 .48126 .93237 .4834 .93782 .48806 .93453 .48591 Mtetra
0 .255 .683 r
.93453 .48591 .93782 .48806 .94277 .4907 .93947 .48854 Mtetra
.301 .623 .96 r
.93947 .48854 .94277 .4907 .947 .49047 .94369 .48831 Mtetra
.687 .513 .647 r
.48636 .87607 .48962 .88101 .49229 .87571 .48902 .87078 Mtetra
.739 .526 .604 r
.48902 .87078 .49229 .87571 .49494 .86736 .49168 .86245 Mtetra
.761 .53 .582 r
.49168 .86245 .49494 .86736 .49759 .85683 .49433 .85194 Mtetra
.768 .531 .574 r
.49433 .85194 .49759 .85683 .50021 .84538 .49697 .84052 Mtetra
.766 .53 .578 r
.49697 .84052 .50021 .84538 .50282 .83442 .49958 .82958 Mtetra
.751 .528 .593 r
.49958 .82958 .50282 .83442 .50542 .82521 .50219 .82039 Mtetra
.715 .521 .626 r
.50219 .82039 .50542 .82521 .50802 .81872 .50479 .81392 Mtetra
.623 .496 .687 r
.50479 .81392 .50802 .81872 .51065 .81545 .50741 .81064 Mtetra
.353 .392 .763 r
.50741 .81064 .51065 .81545 .5133 .81535 .51007 .81054 Mtetra
0 .084 .644 r
.51007 .81054 .5133 .81535 .516 .81786 .51275 .81303 Mtetra
.593 .161 0 r
.51275 .81303 .516 .81786 .51874 .82196 .51547 .8171 Mtetra
.635 .194 0 r
.51547 .8171 .51874 .82196 .5215 .82636 .51822 .82148 Mtetra
0 0 .533 r
.51822 .82148 .5215 .82636 .52427 .82967 .52097 .82477 Mtetra
.152 .297 .758 r
.52097 .82477 .52427 .82967 .52702 .83071 .52371 .82579 Mtetra
.55 .471 .719 r
.52371 .82579 .52702 .83071 .52973 .82866 .52642 .82374 Mtetra
.688 .513 .645 r
.52642 .82374 .52973 .82866 .53238 .8233 .52907 .81839 Mtetra
.74 .525 .602 r
.52907 .81839 .53238 .8233 .53497 .81501 .53166 .81012 Mtetra
.761 .528 .58 r
.53166 .81012 .53497 .81501 .5375 .8047 .5342 .79983 Mtetra
.768 .529 .573 r
.5342 .79983 .5375 .8047 .53999 .79362 .5367 .78877 Mtetra
.764 .528 .577 r
.5367 .78877 .53999 .79362 .54248 .78314 .5392 .77831 Mtetra
.746 .526 .595 r
.5392 .77831 .54248 .78314 .54501 .77449 .54173 .76968 Mtetra
.704 .517 .633 r
.54173 .76968 .54501 .77449 .54759 .76858 .54431 .76378 Mtetra
.595 .487 .701 r
.54431 .76378 .54759 .76858 .55026 .76584 .54698 .76104 Mtetra
.285 .363 .769 r
.54698 .76104 .55026 .76584 .55303 .76617 .54974 .76137 Mtetra
0 .058 .622 r
.54974 .76137 .55303 .76617 .55588 .76899 .55258 .76416 Mtetra
0 0 .402 r
.55258 .76416 .55588 .76899 .55881 .77325 .55549 .7684 Mtetra
.6 .163 0 r
.55549 .7684 .55881 .77325 .56176 .77766 .55843 .77279 Mtetra
0 .004 .573 r
.55843 .77279 .56176 .77766 .5647 .78089 .56135 .776 Mtetra
.188 .317 .765 r
.56135 .776 .5647 .78089 .56757 .78178 .56421 .77688 Mtetra
.556 .473 .717 r
.56421 .77688 .56757 .78178 .57033 .7796 .56697 .77469 Mtetra
.69 .513 .643 r
.56697 .77469 .57033 .7796 .57297 .77418 .56961 .76927 Mtetra
.741 .523 .599 r
.56961 .76927 .57297 .77418 .57549 .76594 .57213 .76105 Mtetra
.761 .526 .578 r
.57213 .76105 .57549 .76594 .57792 .75581 .57456 .75095 Mtetra
.767 .527 .571 r
.57456 .75095 .57792 .75581 .58029 .74507 .57695 .74023 Mtetra
.762 .526 .577 r
.57695 .74023 .58029 .74507 .58269 .73505 .57935 .73023 Mtetra
.741 .524 .599 r
.57935 .73023 .58269 .73505 .58515 .72693 .58183 .72213 Mtetra
.691 .514 .642 r
.58183 .72213 .58515 .72693 .58774 .72156 .58442 .71677 Mtetra
.562 .477 .716 r
.58442 .71677 .58774 .72156 .59049 .71932 .58715 .71453 Mtetra
.214 .333 .769 r
.58715 .71453 .59049 .71932 .59339 .72008 .59005 .71527 Mtetra
0 .039 .605 r
.59005 .71527 .59339 .72008 .59644 .72318 .59308 .71835 Mtetra
0 0 .419 r
.59308 .71835 .59644 .72318 .59958 .7276 .5962 .72274 Mtetra
0 0 .422 r
.5962 .72274 .59958 .7276 .60274 .73203 .59935 .72716 Mtetra
0 .044 .609 r
.59935 .72716 .60274 .73203 .60586 .73518 .60245 .73028 Mtetra
.219 .335 .769 r
.60245 .73028 .60586 .73518 .60885 .73593 .60543 .73102 Mtetra
.562 .476 .715 r
.60543 .73102 .60885 .73593 .61168 .73361 .60825 .7287 Mtetra
.691 .512 .641 r
.60825 .7287 .61168 .73361 .61431 .72811 .61088 .72321 Mtetra
.741 .522 .597 r
.61088 .72321 .61431 .72811 .61676 .71991 .61334 .71502 Mtetra
.761 .525 .575 r
.61334 .71502 .61676 .71991 .61908 .70996 .61567 .7051 Mtetra
.766 .525 .569 r
.61567 .7051 .61908 .70996 .62136 .69953 .61796 .69469 Mtetra
.759 .524 .578 r
.61796 .69469 .62136 .69953 .62367 .68994 .62028 .68511 Mtetra
.735 .521 .603 r
.62028 .68511 .62367 .68994 .62611 .68232 .62272 .67751 Mtetra
.676 .509 .653 r
.62272 .67751 .62611 .68232 .62873 .67747 .62534 .67267 Mtetra
.524 .464 .731 r
.62534 .67267 .62873 .67747 .63158 .67572 .62818 .67091 Mtetra
.145 .301 .765 r
.62818 .67091 .63158 .67572 .63465 .67687 .63124 .67205 Mtetra
0 .028 .593 r
.63124 .67205 .63465 .67687 .63791 .68026 .63449 .67542 Mtetra
0 0 .44 r
.63449 .67542 .63791 .68026 .64129 .68483 .63785 .67996 Mtetra
0 0 .46 r
.63785 .67996 .64129 .68483 .64469 .68929 .64123 .68439 Mtetra
0 .082 .642 r
.64123 .68439 .64469 .68929 .648 .69235 .64452 .68743 Mtetra
.247 .35 .772 r
.64452 .68743 .648 .69235 .65113 .69296 .64764 .68803 Mtetra
.567 .478 .713 r
.64764 .68803 .65113 .69296 .65402 .6905 .65052 .68557 Mtetra
.692 .512 .639 r
.65052 .68557 .65402 .6905 .65664 .68492 .65315 .68 Mtetra
.741 .52 .594 r
.65315 .68 .65664 .68492 .65903 .67674 .65554 .67184 Mtetra
.761 .523 .573 r
.65554 .67184 .65903 .67674 .66126 .66695 .65778 .66207 Mtetra
.765 .523 .568 r
.65778 .66207 .66126 .66695 .66344 .65682 .65997 .65196 Mtetra
.756 .522 .579 r
.65997 .65196 .66344 .65682 .66569 .64762 .66223 .64279 Mtetra
.727 .519 .608 r
.66223 .64279 .66569 .64762 .66812 .64048 .66466 .63566 Mtetra
.658 .504 .664 r
.66466 .63566 .66812 .64048 .6708 .63613 .66734 .63131 Mtetra
.481 .449 .746 r
.66734 .63131 .6708 .63613 .67379 .63484 .67032 .63002 Mtetra
.08 .272 .758 r
.67032 .63002 .67379 .63484 .67707 .63639 .67358 .63155 Mtetra
0 .024 .588 r
.67358 .63155 .67707 .63639 .68058 .64006 .67708 .63519 Mtetra
0 0 .464 r
.67708 .63519 .68058 .64006 .68423 .64478 .68071 .63988 Mtetra
0 0 .499 r
.68071 .63988 .68423 .64478 .68788 .64926 .68434 .64433 Mtetra
0 .118 .67 r
.68434 .64433 .68788 .64926 .6914 .65224 .68785 .64729 Mtetra
.272 .363 .774 r
.68785 .64729 .6914 .65224 .69468 .65271 .69111 .64775 Mtetra
.572 .479 .711 r
.69111 .64775 .69468 .65271 .69763 .65011 .69406 .64515 Mtetra
.693 .511 .637 r
.69406 .64515 .69763 .65011 .70025 .64444 .69668 .63949 Mtetra
.742 .519 .592 r
.69668 .63949 .70025 .64444 .70258 .63627 .69901 .63134 Mtetra
.761 .521 .57 r
.69901 .63134 .70258 .63627 .70472 .62663 .70117 .62172 Mtetra
.764 .521 .566 r
.70117 .62172 .70472 .62663 .70682 .61676 .70327 .61187 Mtetra
.752 .52 .58 r
.70327 .61187 .70682 .61676 .70903 .60795 .70549 .60308 Mtetra
.719 .516 .614 r
.70549 .60308 .70903 .60795 .71147 .60126 .70793 .59641 Mtetra
.637 .499 .677 r
.70793 .59641 .71147 .60126 .71425 .59739 .71071 .59254 Mtetra
.434 .433 .758 r
.71071 .59254 .71425 .59739 .71741 .59656 .71386 .5917 Mtetra
.023 .245 .749 r
.71386 .5917 .71741 .59656 .72093 .59849 .71737 .59361 Mtetra
0 .025 .588 r
.71737 .59361 .72093 .59849 .72473 .60244 .72115 .59753 Mtetra
0 0 .49 r
.72115 .59753 .72473 .60244 .72868 .6073 .72508 .60237 Mtetra
0 0 .535 r
.72508 .60237 .72868 .6073 .73262 .61181 .72899 .60684 Mtetra
0 .151 .694 r
.72899 .60684 .73262 .61181 .73637 .61471 .73273 .60973 Mtetra
.294 .375 .775 r
.73273 .60973 .73637 .61471 .73981 .61504 .73615 .61005 Mtetra
.576 .48 .709 r
.73615 .61005 .73981 .61504 .74283 .6123 .73917 .6073 Mtetra
.694 .51 .634 r
.73917 .6073 .74283 .6123 .74545 .60653 .74179 .60154 Mtetra
.742 .517 .589 r
.74179 .60154 .74545 .60653 .74772 .59837 .74406 .59339 Mtetra
.76 .519 .567 r
.74406 .59339 .74772 .59837 .74978 .58884 .74613 .58389 Mtetra
.762 .519 .565 r
.74613 .58389 .74978 .58884 .75181 .57923 .74817 .5743 Mtetra
.748 .518 .582 r
.74817 .5743 .75181 .57923 .75399 .57078 .75036 .56587 Mtetra
.708 .512 .622 r
.75036 .56587 .75399 .57078 .75648 .56453 .75285 .55963 Mtetra
.613 .492 .691 r
.75285 .55963 .75648 .56453 .75939 .56113 .75575 .55623 Mtetra
.383 .414 .769 r
.75575 .55623 .75939 .56113 .76276 .56074 .75912 .55583 Mtetra
0 .223 .739 r
.75912 .55583 .76276 .56074 .76657 .56305 .76291 .55812 Mtetra
0 .031 .592 r
.76291 .55812 .76657 .56305 .7707 .56727 .76702 .56232 Mtetra
0 0 .517 r
.76702 .56232 .7707 .56727 .77499 .57229 .77129 .5673 Mtetra
0 .009 .57 r
.77129 .5673 .77499 .57229 .77924 .57682 .77551 .57181 Mtetra
0 .181 .714 r
.77551 .57181 .77924 .57682 .78325 .57965 .7795 .57461 Mtetra
.314 .385 .776 r
.7795 .57461 .78325 .57965 .78685 .57985 .7831 .5748 Mtetra
.58 .481 .707 r
.7831 .5748 .78685 .57985 .78996 .57695 .7862 .5719 Mtetra
.694 .508 .632 r
.7862 .5719 .78996 .57695 .79257 .57108 .78881 .56604 Mtetra
.742 .515 .586 r
.78881 .56604 .79257 .57108 .79479 .5629 .79103 .55788 Mtetra
.76 .516 .565 r
.79103 .55788 .79479 .5629 .79677 .55349 .79303 .54848 Mtetra
.79303 .54848 .79677 .55349 .79874 .54411 .79501 .53913 Mtetra
.742 .515 .585 r
.79501 .53913 .79874 .54411 .80092 .53601 .79719 .53105 Mtetra
.696 .509 .631 r
.79719 .53105 .80092 .53601 .80349 .53018 .79975 .52523 Mtetra
.584 .484 .706 r
.79975 .52523 .80349 .53018 .80657 .52724 .80283 .52228 Mtetra
.33 .394 .777 r
.80283 .52228 .80657 .52724 .8102 .52729 .80645 .52232 Mtetra
0 .206 .73 r
.80645 .52232 .8102 .52729 .81434 .52998 .81058 .52498 Mtetra
0 .041 .6 r
.81058 .52498 .81434 .52998 .81885 .53448 .81506 .52946 Mtetra
0 0 .545 r
.81506 .52946 .81885 .53448 .82353 .53965 .81971 .5346 Mtetra
0 .043 .603 r
.81971 .5346 .82353 .53965 .82813 .54422 .82429 .53914 Mtetra
0 .208 .731 r
.82429 .53914 .82813 .54422 .83242 .54698 .82856 .54187 Mtetra
.331 .393 .776 r
.82856 .54187 .83242 .54698 .83621 .54703 .83234 .54191 Mtetra
.583 .482 .705 r
.83234 .54191 .83621 .54703 .8394 .54398 .83553 .53886 Mtetra
.695 .507 .629 r
.83553 .53886 .8394 .54398 .84202 .538 .83814 .53288 Mtetra
.741 .513 .583 r
.83814 .53288 .84202 .538 .84418 .52979 .84031 .5247 Mtetra
.758 .513 .562 r
.84031 .5247 .84418 .52979 .84609 .52047 .84223 .5154 Mtetra
.757 .513 .564 r
.84223 .5154 .84609 .52047 .84802 .51131 .84417 .50626 Mtetra
.736 .512 .589 r
.84417 .50626 .84802 .51131 .85021 .50354 .84637 .49851 Mtetra
.681 .505 .641 r
.84637 .49851 .85021 .50354 .85289 .49813 .84905 .4931 Mtetra
.552 .474 .721 r
.84905 .4931 .85289 .49813 .85619 .49563 .85234 .4906 Mtetra
.278 .374 .782 r
.85234 .4906 .85619 .49563 .86014 .49612 .85627 .49108 Mtetra
0 .194 .723 r
.85627 .49108 .86014 .49612 .86467 .49919 .86078 .49412 Mtetra
0 .054 .611 r
.86078 .49412 .86467 .49919 .86962 .50398 .8657 .49888 Mtetra
0 .015 .573 r
.8657 .49888 .86962 .50398 .87473 .50932 .87079 .50419 Mtetra
0 .076 .632 r
.87079 .50419 .87473 .50932 .87972 .51393 .87575 .50877 Mtetra
0 .233 .746 r
.87575 .50877 .87972 .51393 .88432 .51662 .88033 .51143 Mtetra
.346 .401 .776 r
.88033 .51143 .88432 .51662 .88831 .51653 .88431 .51133 Mtetra
.585 .482 .703 r
.88431 .51133 .88831 .51653 .8916 .51332 .8876 .50811 Mtetra
.695 .505 .627 r
.8876 .50811 .8916 .51332 .89422 .50721 .89022 .50201 Mtetra
.741 .51 .58 r
.89022 .50201 .89422 .50721 .89633 .49896 .89233 .49378 Mtetra
.757 .511 .56 r
.89233 .49378 .89633 .49896 .89818 .48972 .89419 .48456 Mtetra
.754 .511 .564 r
.89419 .48456 .89818 .48972 .90008 .48076 .8961 .47563 Mtetra
.728 .509 .594 r
.8961 .47563 .90008 .48076 .90233 .47331 .89835 .4682 Mtetra
.664 .5 .653 r
.89835 .4682 .90233 .47331 .90516 .46831 .90118 .46319 Mtetra
.516 .463 .736 r
.90118 .46319 .90516 .46831 .90872 .46625 .90474 .46113 Mtetra
.229 .354 .784 r
.90474 .46113 .90872 .46625 .91305 .46719 .90904 .46205 Mtetra
0 .187 .719 r
.90904 .46205 .91305 .46719 .91804 .47065 .91401 .46548 Mtetra
0 .07 .625 r
.91401 .46548 .91804 .47065 .92348 .47573 .91943 .47054 Mtetra
0 .044 .6 r
.91943 .47054 .92348 .47573 .92909 .48126 .92501 .47602 Mtetra
0 .108 .659 r
.92501 .47602 .92909 .48126 .93453 .48591 .93042 .48065 Mtetra
.021 .255 .757 r
.93042 .48065 .93453 .48591 .93947 .48854 .93534 .48325 Mtetra
.36 .407 .775 r
.93534 .48325 .93947 .48854 .94369 .48831 .93954 .483 Mtetra
.615 .43 .607 r
.48311 .86814 .48636 .87607 .48902 .87078 .48577 .86287 Mtetra
.677 .46 .583 r
.48577 .86287 .48902 .87078 .49168 .86245 .48843 .85456 Mtetra
.706 .473 .569 r
.48843 .85456 .49168 .86245 .49433 .85194 .49109 .8441 Mtetra
.716 .478 .563 r
.49109 .8441 .49433 .85194 .49697 .84052 .49373 .83274 Mtetra
.712 .476 .565 r
.49373 .83274 .49697 .84052 .49958 .82958 .49635 .82185 Mtetra
.692 .467 .576 r
.49635 .82185 .49958 .82958 .50219 .82039 .49895 .8127 Mtetra
.647 .446 .596 r
.49895 .8127 .50219 .82039 .50479 .81392 .50156 .80625 Mtetra
.552 .399 .627 r
.50156 .80625 .50479 .81392 .50741 .81064 .50417 .80298 Mtetra
.353 .296 .654 r
.50417 .80298 .50741 .81064 .51007 .81054 .50681 .80286 Mtetra
.021 .111 .619 r
.50681 .80286 .51007 .81054 .51275 .81303 .50948 .80532 Mtetra
0 0 .524 r
.50948 .80532 .51275 .81303 .51547 .8171 .51218 .80936 Mtetra
0 0 .502 r
.51218 .80936 .51547 .8171 .51822 .82148 .51491 .81369 Mtetra
0 .036 .584 r
.51491 .81369 .51822 .82148 .52097 .82477 .51765 .81694 Mtetra
.237 .232 .651 r
.51765 .81694 .52097 .82477 .52371 .82579 .52037 .81794 Mtetra
.489 .366 .639 r
.52037 .81794 .52371 .82579 .52642 .82374 .52307 .81589 Mtetra
.616 .429 .606 r
.52307 .81589 .52642 .82374 .52907 .81839 .52571 .81056 Mtetra
.677 .458 .581 r
.52571 .81056 .52907 .81839 .53166 .81012 .5283 .80232 Mtetra
.705 .47 .566 r
.5283 .80232 .53166 .81012 .5342 .79983 .53085 .79207 Mtetra
.714 .474 .561 r
.53085 .79207 .5342 .79983 .5367 .78877 .53336 .78107 Mtetra
.708 .472 .564 r
.53336 .78107 .5367 .78877 .5392 .77831 .53586 .77066 Mtetra
.685 .462 .577 r
.53586 .77066 .5392 .77831 .54173 .76968 .53839 .76207 Mtetra
.634 .438 .6 r
.53839 .76207 .54173 .76968 .54431 .76378 .54098 .75618 Mtetra
.527 .387 .634 r
.54098 .75618 .54431 .76378 .54698 .76104 .54363 .75344 Mtetra
.312 .277 .658 r
.54363 .75344 .54698 .76104 .54974 .76137 .54638 .75375 Mtetra
0 .095 .616 r
.54638 .75375 .54974 .76137 .55258 .76416 .54921 .75651 Mtetra
0 0 .531 r
.54921 .75651 .55258 .76416 .55549 .7684 .55209 .76071 Mtetra
0 0 .521 r
.55209 .76071 .55549 .7684 .55843 .77279 .55501 .76506 Mtetra
0 .062 .6 r
.55501 .76506 .55843 .77279 .56135 .776 .55791 .76823 Mtetra
.256 .246 .656 r
.55791 .76823 .56135 .776 .56421 .77688 .56076 .76909 Mtetra
.495 .37 .639 r
.56076 .76909 .56421 .77688 .56697 .77469 .5635 .7669 Mtetra
.617 .429 .604 r
.5635 .7669 .56697 .77469 .56961 .76927 .56614 .7615 Mtetra
.676 .455 .578 r
.56614 .7615 .56961 .76927 .57213 .76105 .56866 .75331 Mtetra
.703 .467 .564 r
.56866 .75331 .57213 .76105 .57456 .75095 .5711 .74326 Mtetra
.711 .471 .559 r
.5711 .74326 .57456 .75095 .57695 .74023 .5735 .73259 Mtetra
.703 .467 .564 r
.5735 .73259 .57695 .74023 .57935 .73023 .57591 .72263 Mtetra
.677 .456 .578 r
.57591 .72263 .57935 .73023 .58183 .72213 .57838 .71456 Mtetra
.619 .43 .604 r
.57838 .71456 .58183 .72213 .58442 .71677 .58097 .70922 Mtetra
.5 .374 .64 r
.58097 .70922 .58442 .71677 .58715 .71453 .58369 .70698 Mtetra
.27 .257 .661 r
.58369 .70698 .58715 .71453 .59005 .71527 .58657 .7077 Mtetra
0 .084 .614 r
.58657 .7077 .59005 .71527 .59308 .71835 .58958 .71075 Mtetra
0 0 .54 r
.58958 .71075 .59308 .71835 .5962 .72274 .59268 .7151 Mtetra
0 0 .541 r
.59268 .7151 .5962 .72274 .59935 .72716 .59581 .71946 Mtetra
0 .087 .615 r
.59581 .71946 .59935 .72716 .60245 .73028 .59889 .72255 Mtetra
.273 .258 .66 r
.59889 .72255 .60245 .73028 .60543 .73102 .60186 .72327 Mtetra
.5 .373 .639 r
.60186 .72327 .60543 .73102 .60825 .7287 .60467 .72095 Mtetra
.618 .428 .603 r
.60467 .72095 .60825 .7287 .61088 .72321 .60729 .71547 Mtetra
.675 .453 .576 r
.60729 .71547 .61088 .72321 .61334 .71502 .60975 .70732 Mtetra
.701 .464 .561 r
.60975 .70732 .61334 .71502 .61567 .7051 .61209 .69744 Mtetra
.708 .467 .557 r
.61209 .69744 .61567 .7051 .61796 .69469 .61438 .68709 Mtetra
.698 .463 .563 r
.61438 .68709 .61796 .69469 .62028 .68511 .61671 .67755 Mtetra
.668 .45 .58 r
.61671 .67755 .62028 .68511 .62272 .67751 .61915 .66998 Mtetra
.603 .422 .609 r
.61915 .66998 .62272 .67751 .62534 .67267 .62177 .66515 Mtetra
.471 .361 .647 r
.62177 .66515 .62534 .67267 .62818 .67091 .6246 .66339 Mtetra
.229 .239 .663 r
.6246 .66339 .62818 .67091 .63124 .67205 .62764 .66451 Mtetra
0 .076 .613 r
.62764 .66451 .63124 .67205 .63449 .67542 .63087 .66784 Mtetra
0 0 .55 r
.63087 .66784 .63449 .67542 .63785 .67996 .6342 .67233 Mtetra
0 0 .56 r
.6342 .67233 .63785 .67996 .64123 .68439 .63756 .67672 Mtetra
0 .11 .629 r
.63756 .67672 .64123 .68439 .64452 .68743 .64083 .67972 Mtetra
.289 .269 .663 r
.64083 .67972 .64452 .68743 .64764 .68803 .64393 .6803 Mtetra
.504 .375 .638 r
.64393 .6803 .64764 .68803 .65052 .68557 .6468 .67784 Mtetra
.618 .427 .601 r
.6468 .67784 .65052 .68557 .65315 .68 .64942 .67228 Mtetra
.674 .45 .573 r
.64942 .67228 .65315 .68 .65554 .67184 .65182 .66416 Mtetra
.699 .46 .559 r
.65182 .66416 .65554 .67184 .65778 .66207 .65407 .65444 Mtetra
.704 .462 .555 r
.65407 .65444 .65778 .66207 .65997 .65196 .65626 .64437 Mtetra
.692 .458 .563 r
.65626 .64437 .65997 .65196 .66223 .64279 .65853 .63524 Mtetra
.658 .444 .582 r
.65853 .63524 .66223 .64279 .66466 .63566 .66096 .62814 Mtetra
.585 .413 .615 r
.66096 .62814 .66466 .63566 .66734 .63131 .66364 .6238 Mtetra
.439 .347 .654 r
.66364 .6238 .66734 .63131 .67032 .63002 .6666 .6225 Mtetra
.19 .223 .665 r
.6666 .6225 .67032 .63002 .67358 .63155 .66985 .624 Mtetra
0 .072 .614 r
.66985 .624 .67358 .63155 .67708 .63519 .67332 .62761 Mtetra
0 0 .563 r
.67332 .62761 .67708 .63519 .68071 .63988 .67692 .63225 Mtetra
0 .011 .579 r
.67692 .63225 .68071 .63988 .68434 .64433 .68053 .63666 Mtetra
.02 .132 .641 r
.68053 .63666 .68434 .64433 .68785 .64729 .68401 .63958 Mtetra
.304 .279 .666 r
.68401 .63958 .68785 .64729 .69111 .64775 .68726 .64002 Mtetra
.508 .377 .637 r
.68726 .64002 .69111 .64775 .69406 .64515 .6902 .63742 Mtetra
.618 .425 .599 r
.6902 .63742 .69406 .64515 .69668 .63949 .69281 .63178 Mtetra
.673 .447 .571 r
.69281 .63178 .69668 .63949 .69901 .63134 .69515 .62366 Mtetra
.697 .456 .556 r
.69515 .62366 .69901 .63134 .70117 .62172 .69731 .61408 Mtetra
.7 .458 .553 r
.69731 .61408 .70117 .62172 .70327 .61187 .69942 .60429 Mtetra
.686 .452 .563 r
.69942 .60429 .70327 .61187 .70549 .60308 .70164 .59553 Mtetra
.646 .437 .585 r
.70164 .59553 .70549 .60308 .70793 .59641 .70408 .58888 Mtetra
.564 .403 .621 r
.70408 .58888 .70793 .59641 .71071 .59254 .70686 .58502 Mtetra
.407 .332 .66 r
.70686 .58502 .71071 .59254 .71386 .5917 .70999 .58417 Mtetra
.155 .208 .666 r
.70999 .58417 .71386 .5917 .71737 .59361 .71348 .58605 Mtetra
0 .072 .617 r
.71348 .58605 .71737 .59361 .72115 .59753 .71723 .58993 Mtetra
0 .004 .576 r
.71723 .58993 .72115 .59753 .72508 .60237 .72113 .59471 Mtetra
0 .035 .596 r
.72113 .59471 .72508 .60237 .72899 .60684 .72502 .59914 Mtetra
.049 .152 .652 r
.72502 .59914 .72899 .60684 .73273 .60973 .72873 .60199 Mtetra
.317 .288 .668 r
.72873 .60199 .73273 .60973 .73615 .61005 .73213 .60229 Mtetra
.511 .378 .636 r
.73213 .60229 .73615 .61005 .73917 .6073 .73515 .59954 Mtetra
.618 .423 .596 r
.73515 .59954 .73917 .6073 .74179 .60154 .73776 .5938 Mtetra
.671 .444 .568 r
.73776 .5938 .74179 .60154 .74406 .59339 .74004 .58569 Mtetra
.694 .452 .553 r
.74004 .58569 .74406 .59339 .74613 .58389 .74211 .57624 Mtetra
.696 .453 .552 r
.74211 .57624 .74613 .58389 .74817 .5743 .74416 .56669 Mtetra
.678 .447 .563 r
.74416 .56669 .74817 .5743 .75036 .56587 .74635 .5583 Mtetra
.633 .43 .589 r
.74635 .5583 .75036 .56587 .75285 .55963 .74884 .55208 Mtetra
.542 .393 .628 r
.74884 .55208 .75285 .55963 .75575 .55623 .75174 .54868 Mtetra
.373 .318 .667 r
.75174 .54868 .75575 .55623 .75912 .55583 .75508 .54827 Mtetra
.124 .196 .668 r
.75508 .54827 .75912 .55583 .76291 .55812 .75885 .55052 Mtetra
0 .075 .622 r
.75885 .55052 .76291 .55812 .76702 .56232 .76293 .55467 Mtetra
0 .022 .59 r
.76293 .55467 .76702 .56232 .77129 .5673 .76717 .55961 Mtetra
0 .059 .613 r
.76717 .55961 .77129 .5673 .77551 .57181 .77136 .56406 Mtetra
.075 .171 .661 r
.77136 .56406 .77551 .57181 .7795 .57461 .77533 .56683 Mtetra
.329 .296 .67 r
.77533 .56683 .7795 .57461 .7831 .5748 .7789 .56699 Mtetra
.514 .379 .635 r
.7789 .56699 .7831 .5748 .7862 .5719 .78199 .5641 Mtetra
.617 .421 .594 r
.78199 .5641 .7862 .5719 .78881 .56604 .7846 .55826 Mtetra
.669 .44 .565 r
.7846 .55826 .78881 .56604 .79103 .55788 .78683 .55013 Mtetra
.691 .448 .55 r
.78683 .55013 .79103 .55788 .79303 .54848 .78883 .54078 Mtetra
.78883 .54078 .79303 .54848 .79501 .53913 .79082 .53147 Mtetra
.67 .441 .564 r
.79082 .53147 .79501 .53913 .79719 .53105 .793 .52343 Mtetra
.619 .422 .594 r
.793 .52343 .79719 .53105 .79975 .52523 .79557 .51763 Mtetra
.518 .382 .635 r
.79557 .51763 .79975 .52523 .80283 .52228 .79863 .51468 Mtetra
.34 .304 .673 r
.79863 .51468 .80283 .52228 .80645 .52232 .80223 .5147 Mtetra
.097 .187 .669 r
.80223 .5147 .80645 .52232 .81058 .52498 .80633 .51733 Mtetra
0 .081 .628 r
.80633 .51733 .81058 .52498 .81506 .52946 .81078 .52175 Mtetra
0 .041 .604 r
.81078 .52175 .81506 .52946 .81971 .5346 .8154 .52684 Mtetra
0 .083 .629 r
.8154 .52684 .81971 .5346 .82429 .53914 .81994 .53133 Mtetra
.1 .188 .669 r
.81994 .53133 .82429 .53914 .82856 .54187 .82418 .53402 Mtetra
.34 .303 .671 r
.82418 .53402 .82856 .54187 .83234 .54191 .82794 .53404 Mtetra
.516 .38 .633 r
.82794 .53404 .83234 .54191 .83553 .53886 .83112 .53099 Mtetra
.616 .418 .591 r
.83112 .53099 .83553 .53886 .83814 .53288 .83373 .52504 Mtetra
.667 .436 .562 r
.83373 .52504 .83814 .53288 .84031 .5247 .8359 .51688 Mtetra
.687 .443 .548 r
.8359 .51688 .84031 .5247 .84223 .5154 .83783 .50763 Mtetra
.685 .442 .549 r
.83783 .50763 .84223 .5154 .84417 .50626 .83978 .49854 Mtetra
.66 .434 .566 r
.83978 .49854 .84417 .50626 .84637 .49851 .84198 .49082 Mtetra
.603 .414 .599 r
.84198 .49082 .84637 .49851 .84905 .4931 .84466 .48543 Mtetra
.493 .371 .643 r
.84466 .48543 .84905 .4931 .85234 .4906 .84793 .48292 Mtetra
.307 .291 .678 r
.84793 .48292 .85234 .4906 .85627 .49108 .85185 .48338 Mtetra
.075 .181 .671 r
.85185 .48338 .85627 .49108 .86078 .49412 .85633 .48638 Mtetra
0 .089 .635 r
.85633 .48638 .86078 .49412 .8657 .49888 .86121 .49108 Mtetra
0 .061 .619 r
.86121 .49108 .8657 .49888 .87079 .50419 .86626 .49634 Mtetra
0 .105 .643 r
.86626 .49634 .87079 .50419 .87575 .50877 .87119 .50086 Mtetra
.123 .204 .676 r
.87119 .50086 .87575 .50877 .88033 .51143 .87574 .50349 Mtetra
.35 .309 .672 r
.87574 .50349 .88033 .51143 .88431 .51133 .87969 .50336 Mtetra
.518 .38 .632 r
.87969 .50336 .88431 .51133 .8876 .50811 .88297 .50015 Mtetra
.615 .415 .588 r
.88297 .50015 .8876 .50811 .89022 .50201 .88559 .49407 Mtetra
.664 .432 .558 r
.88559 .49407 .89022 .50201 .89233 .49378 .88771 .48588 Mtetra
.683 .438 .545 r
.88771 .48588 .89233 .49378 .89419 .48456 .88957 .4767 Mtetra
.679 .436 .548 r
.88957 .4767 .89419 .48456 .8961 .47563 .89149 .46781 Mtetra
.65 .427 .568 r
.89149 .46781 .8961 .47563 .89835 .4682 .89374 .46041 Mtetra
.586 .406 .604 r
.89374 .46041 .89835 .4682 .90118 .46319 .89656 .45542 Mtetra
.466 .36 .651 r
.89656 .45542 .90118 .46319 .90474 .46113 .9001 .45336 Mtetra
.276 .28 .683 r
.9001 .45336 .90474 .46113 .90904 .46205 .90439 .45425 Mtetra
.058 .177 .674 r
.90439 .45425 .90904 .46205 .91401 .46548 .90932 .45763 Mtetra
0 .1 .643 r
.90932 .45763 .91401 .46548 .91943 .47054 .9147 .46263 Mtetra
0 .081 .633 r
.9147 .46263 .91943 .47054 .92501 .47602 .92023 .46805 Mtetra
0 .126 .656 r
.92023 .46805 .92501 .47602 .93042 .48065 .9256 .47262 Mtetra
.145 .219 .682 r
.9256 .47262 .93042 .48065 .93534 .48325 .93049 .47518 Mtetra
.358 .315 .672 r
.93049 .47518 .93534 .48325 .93954 .483 .93467 .47492 Mtetra
.579 .388 .587 r
.47989 .85814 .48311 .86814 .48577 .86287 .48254 .85289 Mtetra
.643 .423 .57 r
.48254 .85289 .48577 .86287 .48843 .85456 .4852 .84463 Mtetra
.674 .441 .56 r
.4852 .84463 .48843 .85456 .49109 .8441 .48786 .83424 Mtetra
.685 .447 .555 r
.48786 .83424 .49109 .8441 .49373 .83274 .4905 .82294 Mtetra
.681 .444 .557 r
.4905 .82294 .49373 .83274 .49635 .82185 .49312 .81212 Mtetra
.659 .432 .565 r
.49312 .81212 .49635 .82185 .49895 .8127 .49573 .80303 Mtetra
.611 .406 .58 r
.49573 .80303 .49895 .8127 .50156 .80625 .49833 .79661 Mtetra
.519 .355 .599 r
.49833 .79661 .50156 .80625 .50417 .80298 .50094 .79335 Mtetra
.35 .259 .61 r
.50094 .79335 .50417 .80298 .50681 .80286 .50356 .79321 Mtetra
.104 .116 .586 r
.50356 .79321 .50681 .80286 .50948 .80532 .50621 .79563 Mtetra
0 0 .534 r
.50621 .79563 .50948 .80532 .51218 .80936 .50889 .79961 Mtetra
0 0 .521 r
.50889 .79961 .51218 .80936 .51491 .81369 .5116 .80389 Mtetra
.011 .06 .566 r
.5116 .80389 .51491 .81369 .51765 .81694 .51431 .8071 Mtetra
.261 .207 .606 r
.51431 .8071 .51765 .81694 .52037 .81794 .51702 .80807 Mtetra
.463 .322 .604 r
.51702 .80807 .52037 .81794 .52307 .81589 .5197 .80602 Mtetra
.58 .388 .585 r
.5197 .80602 .52307 .81589 .52571 .81056 .52234 .80071 Mtetra
.642 .421 .568 r
.52234 .80071 .52571 .81056 .5283 .80232 .52493 .79251 Mtetra
.672 .437 .557 r
.52493 .79251 .5283 .80232 .53085 .79207 .52748 .78233 Mtetra
.682 .443 .553 r
.52748 .78233 .53085 .79207 .53336 .78107 .52999 .7714 Mtetra
.676 .439 .556 r
.52999 .7714 .53336 .78107 .53586 .77066 .5325 .76105 Mtetra
.651 .426 .565 r
.5325 .76105 .53586 .77066 .53839 .76207 .53503 .75251 Mtetra
.598 .398 .582 r
.53503 .75251 .53839 .76207 .54098 .75618 .53761 .74665 Mtetra
.496 .343 .602 r
.53761 .74665 .54098 .75618 .54363 .75344 .54026 .74391 Mtetra
.318 .243 .613 r
.54026 .74391 .54363 .75344 .54638 .75375 .54298 .7442 Mtetra
.076 .104 .587 r
.54298 .7442 .54638 .75375 .54921 .75651 .54579 .74692 Mtetra
0 0 .54 r
.54579 .74692 .54921 .75651 .55209 .76071 .54865 .75106 Mtetra
0 0 .534 r
.54865 .75106 .55209 .76071 .55501 .76506 .55155 .75536 Mtetra
.034 .079 .578 r
.55155 .75536 .55501 .76506 .55791 .76823 .55443 .75848 Mtetra
.275 .218 .611 r
.55443 .75848 .55791 .76823 .56076 .76909 .55725 .75931 Mtetra
.468 .326 .605 r
.55725 .75931 .56076 .76909 .5635 .7669 .55999 .75712 Mtetra
.581 .387 .584 r
.55999 .75712 .5635 .7669 .56614 .7615 .56262 .75175 Mtetra
.64 .419 .566 r
.56262 .75175 .56614 .7615 .56866 .75331 .56514 .7436 Mtetra
.669 .434 .555 r
.56514 .7436 .56866 .75331 .5711 .74326 .56758 .73361 Mtetra
.678 .438 .551 r
.56758 .73361 .5711 .74326 .5735 .73259 .56998 .72301 Mtetra
.67 .434 .555 r
.56998 .72301 .5735 .73259 .57591 .72263 .57239 .71312 Mtetra
.641 .419 .566 r
.57239 .71312 .57591 .72263 .57838 .71456 .57487 .70509 Mtetra
.583 .389 .584 r
.57487 .70509 .57838 .71456 .58097 .70922 .57745 .69977 Mtetra
.472 .33 .606 r
.57745 .69977 .58097 .70922 .58369 .70698 .58016 .69753 Mtetra
.286 .228 .615 r
.58016 .69753 .58369 .70698 .58657 .7077 .58302 .69822 Mtetra
.052 .095 .588 r
.58302 .69822 .58657 .7077 .58958 .71075 .58601 .70123 Mtetra
0 .001 .547 r
.58601 .70123 .58958 .71075 .59268 .7151 .58908 .70552 Mtetra
0 .002 .548 r
.58908 .70552 .59268 .7151 .59581 .71946 .59218 .70983 Mtetra
.056 .098 .589 r
.59218 .70983 .59581 .71946 .59889 .72255 .59524 .71288 Mtetra
.288 .229 .615 r
.59524 .71288 .59889 .72255 .60186 .72327 .59819 .71357 Mtetra
.472 .329 .605 r
.59819 .71357 .60186 .72327 .60467 .72095 .60099 .71124 Mtetra
.581 .386 .582 r
.60099 .71124 .60467 .72095 .60729 .71547 .60361 .70579 Mtetra
.639 .416 .563 r
.60361 .70579 .60729 .71547 .60975 .70732 .60606 .69769 Mtetra
.667 .43 .552 r
.60606 .69769 .60975 .70732 .61209 .69744 .60841 .68787 Mtetra
.674 .433 .549 r
.60841 .68787 .61209 .69744 .61438 .68709 .6107 .67758 Mtetra
.664 .428 .553 r
.6107 .67758 .61438 .68709 .61671 .67755 .61303 .6681 Mtetra
.631 .412 .566 r
.61303 .6681 .61671 .67755 .61915 .66998 .61547 .66057 Mtetra
.566 .379 .587 r
.61547 .66057 .61915 .66998 .62177 .66515 .61808 .65576 Mtetra
.447 .317 .61 r
.61808 .65576 .62177 .66515 .6246 .66339 .6209 .65399 Mtetra
.255 .214 .618 r
.6209 .65399 .6246 .66339 .62764 .66451 .62392 .65508 Mtetra
.032 .089 .59 r
.62392 .65508 .62764 .66451 .63087 .66784 .62712 .65837 Mtetra
0 .01 .556 r
.62712 .65837 .63087 .66784 .6342 .67233 .63043 .6628 Mtetra
0 .021 .561 r
.63043 .6628 .6342 .67233 .63756 .67672 .63376 .66713 Mtetra
.078 .115 .599 r
.63376 .66713 .63756 .67672 .64083 .67972 .637 .67009 Mtetra
.301 .238 .618 r
.637 .67009 .64083 .67972 .64393 .6803 .64009 .67064 Mtetra
.476 .331 .604 r
.64009 .67064 .64393 .6803 .6468 .67784 .64295 .66818 Mtetra
.581 .385 .58 r
.64295 .66818 .6468 .67784 .64942 .67228 .64556 .66265 Mtetra
.637 .413 .561 r
.64556 .66265 .64942 .67228 .65182 .66416 .64796 .65457 Mtetra
.664 .425 .549 r
.64796 .65457 .65182 .66416 .65407 .65444 .65021 .64491 Mtetra
.67 .428 .547 r
.65021 .64491 .65407 .65444 .65626 .64437 .65241 .63491 Mtetra
.657 .422 .553 r
.65241 .63491 .65626 .64437 .65853 .63524 .65467 .62583 Mtetra
.62 .405 .567 r
.65467 .62583 .65853 .63524 .66096 .62814 .6571 .61877 Mtetra
.549 .369 .59 r
.6571 .61877 .66096 .62814 .66364 .6238 .65977 .61445 Mtetra
.421 .304 .615 r
.65977 .61445 .66364 .6238 .6666 .6225 .66272 .61314 Mtetra
.226 .201 .62 r
.66272 .61314 .6666 .6225 .66985 .624 .66595 .6146 Mtetra
.017 .086 .593 r
.66595 .6146 .66985 .624 .67332 .62761 .66939 .61816 Mtetra
0 .021 .565 r
.66939 .61816 .67332 .62761 .67692 .63225 .67296 .62274 Mtetra
0 .04 .574 r
.67296 .62274 .67692 .63225 .68053 .63666 .67654 .62709 Mtetra
.099 .132 .608 r
.67654 .62709 .68053 .63666 .68401 .63958 .67999 .62996 Mtetra
.312 .246 .621 r
.67999 .62996 .68401 .63958 .68726 .64002 .68322 .63038 Mtetra
.479 .333 .604 r
.68322 .63038 .68726 .64002 .6902 .63742 .68614 .62777 Mtetra
.581 .383 .578 r
.68614 .62777 .6902 .63742 .69281 .63178 .68875 .62216 Mtetra
.635 .409 .558 r
.68875 .62216 .69281 .63178 .69515 .62366 .69109 .61409 Mtetra
.66 .421 .547 r
.69109 .61409 .69515 .62366 .69731 .61408 .69325 .60457 Mtetra
.665 .423 .545 r
.69325 .60457 .69731 .61408 .69942 .60429 .69538 .59484 Mtetra
.649 .416 .552 r
.69538 .59484 .69942 .60429 .70164 .59553 .69759 .58614 Mtetra
.608 .397 .569 r
.69759 .58614 .70164 .59553 .70408 .58888 .70004 .57952 Mtetra
.53 .359 .594 r
.70004 .57952 .70408 .58888 .70686 .58502 .7028 .57567 Mtetra
.394 .292 .619 r
.7028 .57567 .70686 .58502 .70999 .58417 .70592 .57481 Mtetra
.199 .19 .623 r
.70592 .57481 .70999 .58417 .71348 .58605 .70938 .57665 Mtetra
.006 .086 .598 r
.70938 .57665 .71348 .58605 .71723 .58993 .7131 .58047 Mtetra
0 .034 .575 r
.7131 .58047 .71723 .58993 .72113 .59471 .71697 .58519 Mtetra
0 .058 .586 r
.71697 .58519 .72113 .59471 .72502 .59914 .72082 .58956 Mtetra
.119 .147 .616 r
.72082 .58956 .72502 .59914 .72873 .60199 .7245 .59236 Mtetra
.322 .254 .623 r
.7245 .59236 .72873 .60199 .73213 .60229 .72788 .59263 Mtetra
.482 .334 .603 r
.72788 .59263 .73213 .60229 .73515 .59954 .73088 .58989 Mtetra
.58 .381 .576 r
.73088 .58989 .73515 .59954 .73776 .5938 .73349 .58418 Mtetra
.633 .405 .555 r
.73349 .58418 .73776 .5938 .74004 .58569 .73577 .57611 Mtetra
.657 .416 .544 r
.73577 .57611 .74004 .58569 .74211 .57624 .73785 .56672 Mtetra
.659 .417 .543 r
.73785 .56672 .74211 .57624 .74416 .56669 .7399 .55723 Mtetra
.64 .409 .552 r
.7399 .55723 .74416 .56669 .74635 .5583 .74209 .54889 Mtetra
.595 .388 .571 r
.74209 .54889 .74635 .5583 .74884 .55208 .74458 .54271 Mtetra
.51 .349 .598 r
.74458 .54271 .74884 .55208 .75174 .54868 .74747 .53931 Mtetra
.367 .279 .623 r
.74747 .53931 .75174 .54868 .75508 .54827 .75079 .53888 Mtetra
.174 .181 .626 r
.75079 .53888 .75508 .54827 .75885 .55052 .75453 .54109 Mtetra
0 .089 .603 r
.75453 .54109 .75885 .55052 .76293 .55467 .75858 .54518 Mtetra
0 .048 .586 r
.75858 .54518 .76293 .55467 .76717 .55961 .76278 .55005 Mtetra
0 .077 .598 r
.76278 .55005 .76717 .55961 .77136 .56406 .76694 .55445 Mtetra
.138 .162 .623 r
.76694 .55445 .77136 .56406 .77533 .56683 .77087 .55717 Mtetra
.332 .261 .625 r
.77087 .55717 .77533 .56683 .7789 .56699 .77442 .5573 Mtetra
.484 .335 .602 r
.77442 .5573 .7789 .56699 .78199 .5641 .7775 .5544 Mtetra
.579 .379 .574 r
.7775 .5544 .78199 .5641 .7846 .55826 .7801 .54859 Mtetra
.63 .401 .552 r
.7801 .54859 .7846 .55826 .78683 .55013 .78233 .54052 Mtetra
.652 .411 .541 r
.78233 .54052 .78683 .55013 .78883 .54078 .78433 .53123 Mtetra
.653 .411 .541 r
.78433 .53123 .78883 .54078 .79082 .53147 .78633 .52198 Mtetra
.631 .402 .552 r
.78633 .52198 .79082 .53147 .793 .52343 .78851 .51398 Mtetra
.581 .38 .574 r
.78851 .51398 .793 .52343 .79557 .51763 .79107 .50821 Mtetra
.488 .338 .603 r
.79107 .50821 .79557 .51763 .79863 .51468 .79412 .50526 Mtetra
.34 .268 .628 r
.79412 .50526 .79863 .51468 .80223 .5147 .7977 .50526 Mtetra
.153 .175 .63 r
.7977 .50526 .80223 .5147 .80633 .51733 .80177 .50784 Mtetra
0 .093 .609 r
.80177 .50784 .80633 .51733 .81078 .52175 .80618 .5122 Mtetra
0 .062 .597 r
.80618 .5122 .81078 .52175 .8154 .52684 .81076 .51722 Mtetra
0 .095 .61 r
.81076 .51722 .8154 .52684 .81994 .53133 .81526 .52164 Mtetra
.156 .176 .629 r
.81526 .52164 .81994 .53133 .82418 .53402 .81947 .52429 Mtetra
.34 .267 .627 r
.81947 .52429 .82418 .53402 .82794 .53404 .8232 .52428 Mtetra
.486 .335 .601 r
.8232 .52428 .82794 .53404 .83112 .53099 .82636 .52123 Mtetra
.578 .376 .571 r
.82636 .52123 .83112 .53099 .83373 .52504 .82897 .51531 Mtetra
.627 .397 .549 r
.82897 .51531 .83373 .52504 .8359 .51688 .83114 .50721 Mtetra
.648 .405 .538 r
.83114 .50721 .8359 .51688 .83783 .50763 .83308 .49801 Mtetra
.646 .404 .539 r
.83308 .49801 .83783 .50763 .83978 .49854 .83503 .48898 Mtetra
.621 .394 .552 r
.83503 .48898 .83978 .49854 .84198 .49082 .83724 .4813 Mtetra
.565 .371 .577 r
.83724 .4813 .84198 .49082 .84466 .48543 .83991 .47594 Mtetra
.466 .328 .608 r
.83991 .47594 .84466 .48543 .84793 .48292 .84316 .47343 Mtetra
.314 .258 .633 r
.84316 .47343 .84793 .48292 .85185 .48338 .84705 .47386 Mtetra
.136 .17 .633 r
.84705 .47386 .85185 .48338 .85633 .48638 .85149 .47681 Mtetra
0 .1 .616 r
.85149 .47681 .85633 .48638 .86121 .49108 .85633 .48144 Mtetra
0 .078 .607 r
.85633 .48144 .86121 .49108 .86626 .49634 .86134 .48662 Mtetra
.021 .112 .62 r
.86134 .48662 .86626 .49634 .87119 .50086 .86622 .49108 Mtetra
.173 .188 .635 r
.86622 .49108 .87119 .50086 .87574 .50349 .87073 .49365 Mtetra
.348 .272 .628 r
.87073 .49365 .87574 .50349 .87969 .50336 .87466 .4935 Mtetra
.488 .335 .6 r
.87466 .4935 .87969 .50336 .88297 .50015 .87792 .49029 Mtetra
.576 .372 .568 r
.87792 .49029 .88297 .50015 .88559 .49407 .88054 .48425 Mtetra
.623 .392 .545 r
.88054 .48425 .88559 .49407 .88771 .48588 .88266 .47611 Mtetra
.643 .399 .535 r
.88266 .47611 .88771 .48588 .88957 .4767 .88453 .46699 Mtetra
.638 .397 .537 r
.88453 .46699 .88957 .4767 .89149 .46781 .88645 .45816 Mtetra
.609 .386 .553 r
.88645 .45816 .89149 .46781 .89374 .46041 .88871 .4508 Mtetra
.548 .362 .58 r
.88871 .4508 .89374 .46041 .89656 .45542 .89152 .44583 Mtetra
.443 .317 .613 r
.89152 .44583 .89656 .45542 .9001 .45336 .89504 .44376 Mtetra
.29 .248 .638 r
.89504 .44376 .9001 .45336 .90439 .45425 .89929 .44461 Mtetra
.122 .168 .638 r
.89929 .44461 .90439 .45425 .90932 .45763 .90418 .44794 Mtetra
.001 .108 .623 r
.90418 .44794 .90932 .45763 .9147 .46263 .90951 .45286 Mtetra
0 .094 .618 r
.90951 .45286 .9147 .46263 .92023 .46805 .915 .45821 Mtetra
.042 .129 .63 r
.915 .45821 .92023 .46805 .9256 .47262 .92032 .46271 Mtetra
.189 .2 .64 r
.92032 .46271 .9256 .47262 .93049 .47518 .92516 .46521 Mtetra
.355 .277 .629 r
.92516 .46521 .93049 .47518 .93467 .47492 .92932 .46492 Mtetra
.567 .374 .579 r
.4767 .84735 .47989 .85814 .48254 .85289 .47934 .84213 Mtetra
.63 .411 .565 r
.47934 .84213 .48254 .85289 .4852 .84463 .482 .83392 Mtetra
.662 .429 .556 r
.482 .83392 .4852 .84463 .48786 .83424 .48466 .8236 Mtetra
.674 .435 .552 r
.48466 .8236 .48786 .83424 .4905 .82294 .4873 .81238 Mtetra
.669 .433 .554 r
.4873 .81238 .4905 .82294 .49312 .81212 .48993 .80163 Mtetra
.647 .42 .561 r
.48993 .80163 .49312 .81212 .49573 .80303 .49253 .7926 Mtetra
.599 .393 .574 r
.49253 .7926 .49573 .80303 .49833 .79661 .49513 .78622 Mtetra
.508 .341 .589 r
.49513 .78622 .49833 .79661 .50094 .79335 .49772 .78296 Mtetra
.349 .248 .597 r
.49772 .78296 .50094 .79335 .50356 .79321 .50033 .7828 Mtetra
.127 .116 .575 r
.50033 .7828 .50356 .79321 .50621 .79563 .50296 .78518 Mtetra
0 .003 .531 r
.50296 .78518 .50621 .79563 .50889 .79961 .50562 .78911 Mtetra
0 0 .521 r
.50562 .78911 .50889 .79961 .5116 .80389 .5083 .79333 Mtetra
.044 .066 .558 r
.5083 .79333 .5116 .80389 .51431 .8071 .51099 .79649 Mtetra
.268 .2 .592 r
.51099 .79649 .51431 .8071 .51702 .80807 .51368 .79743 Mtetra
.454 .308 .593 r
.51368 .79743 .51702 .80807 .5197 .80602 .51635 .79538 Mtetra
.567 .373 .578 r
.51635 .79538 .5197 .80602 .52234 .80071 .51898 .79009 Mtetra
.629 .408 .563 r
.51898 .79009 .52234 .80071 .52493 .79251 .52157 .78195 Mtetra
.66 .425 .554 r
.52157 .78195 .52493 .79251 .52748 .78233 .52412 .77184 Mtetra
.67 .431 .55 r
.52412 .77184 .52748 .78233 .52999 .7714 .52664 .76098 Mtetra
.664 .427 .552 r
.52664 .76098 .52999 .7714 .5325 .76105 .52915 .7507 Mtetra
.638 .413 .561 r
.52915 .7507 .5325 .76105 .53503 .75251 .53167 .74221 Mtetra
.585 .384 .575 r
.53167 .74221 .53503 .75251 .53761 .74665 .53425 .73639 Mtetra
.486 .328 .592 r
.53425 .73639 .53761 .74665 .54026 .74391 .53688 .73365 Mtetra
.32 .233 .599 r
.53688 .73365 .54026 .74391 .54298 .7442 .53959 .73392 Mtetra
.101 .106 .576 r
.53959 .73392 .54298 .7442 .54579 .74692 .54238 .73659 Mtetra
0 .007 .537 r
.54238 .73659 .54579 .74692 .54865 .75106 .54522 .74068 Mtetra
0 0 .533 r
.54522 .74068 .54865 .75106 .55155 .75536 .54808 .74491 Mtetra
.064 .084 .569 r
.54808 .74491 .55155 .75536 .55443 .75848 .55094 .74799 Mtetra
.281 .21 .597 r
.55094 .74799 .55443 .75848 .55725 .75931 .55375 .74879 Mtetra
.459 .312 .593 r
.55375 .74879 .55725 .75931 .55999 .75712 .55647 .7466 Mtetra
.568 .373 .577 r
.55647 .7466 .55999 .75712 .56262 .75175 .55909 .74125 Mtetra
.628 .406 .561 r
.55909 .74125 .56262 .75175 .56514 .7436 .56161 .73315 Mtetra
.657 .422 .551 r
.56161 .73315 .56514 .7436 .56758 .73361 .56406 .72323 Mtetra
.666 .426 .548 r
.56406 .72323 .56758 .73361 .56998 .72301 .56646 .7127 Mtetra
.658 .422 .551 r
.56646 .7127 .56998 .72301 .57239 .71312 .56887 .70288 Mtetra
.629 .406 .561 r
.56887 .70288 .57239 .71312 .57487 .70509 .57134 .6949 Mtetra
.57 .375 .577 r
.57134 .6949 .57487 .70509 .57745 .69977 .57391 .68961 Mtetra
.463 .316 .595 r
.57391 .68961 .57745 .69977 .58016 .69753 .57662 .68736 Mtetra
.29 .219 .601 r
.57662 .68736 .58016 .69753 .58302 .69822 .57946 .68803 Mtetra
.079 .098 .578 r
.57946 .68803 .58302 .69822 .58601 .70123 .58242 .69099 Mtetra
0 .013 .544 r
.58242 .69099 .58601 .70123 .58908 .70552 .58547 .69522 Mtetra
0 .014 .545 r
.58547 .69522 .58908 .70552 .59218 .70983 .58854 .69947 Mtetra
.083 .1 .578 r
.58854 .69947 .59218 .70983 .59524 .71288 .59157 .70246 Mtetra
.293 .22 .601 r
.59157 .70246 .59524 .71288 .59819 .71357 .5945 .70312 Mtetra
.463 .315 .594 r
.5945 .70312 .59819 .71357 .60099 .71124 .59729 .7008 Mtetra
.568 .372 .575 r
.59729 .7008 .60099 .71124 .60361 .70579 .5999 .69537 Mtetra
.626 .403 .558 r
.5999 .69537 .60361 .70579 .60606 .69769 .60236 .68732 Mtetra
.654 .417 .548 r
.60236 .68732 .60606 .69769 .60841 .68787 .6047 .67757 Mtetra
.662 .421 .546 r
.6047 .67757 .60841 .68787 .6107 .67758 .607 .66735 Mtetra
.651 .416 .55 r
.607 .66735 .6107 .67758 .61303 .6681 .60933 .65794 Mtetra
.619 .399 .561 r
.60933 .65794 .61303 .6681 .61547 .66057 .61177 .65046 Mtetra
.554 .365 .579 r
.61177 .65046 .61547 .66057 .61808 .65576 .61437 .64567 Mtetra
.439 .303 .598 r
.61437 .64567 .61808 .65576 .6209 .65399 .61717 .64389 Mtetra
.262 .206 .604 r
.61717 .64389 .6209 .65399 .62392 .65508 .62018 .64495 Mtetra
.061 .093 .581 r
.62018 .64495 .62392 .65508 .62712 .65837 .62335 .64818 Mtetra
0 .021 .552 r
.62335 .64818 .62712 .65837 .63043 .6628 .62663 .65255 Mtetra
0 .031 .557 r
.62663 .65255 .63043 .6628 .63376 .66713 .62992 .65682 Mtetra
.102 .116 .587 r
.62992 .65682 .63376 .66713 .637 .67009 .63315 .65973 Mtetra
.304 .228 .604 r
.63315 .65973 .637 .67009 .64009 .67064 .63621 .66025 Mtetra
.467 .317 .594 r
.63621 .66025 .64009 .67064 .64295 .66818 .63905 .65779 Mtetra
.568 .371 .573 r
.63905 .65779 .64295 .66818 .64556 .66265 .64166 .65229 Mtetra
.624 .399 .556 r
.64166 .65229 .64556 .66265 .64796 .65457 .64405 .64426 Mtetra
.651 .413 .546 r
.64405 .64426 .64796 .65457 .65021 .64491 .64631 .63467 Mtetra
.657 .416 .543 r
.64631 .63467 .65021 .64491 .65241 .63491 .64851 .62473 Mtetra
.644 .409 .549 r
.64851 .62473 .65241 .63491 .65467 .62583 .65078 .61572 Mtetra
.607 .391 .562 r
.65078 .61572 .65467 .62583 .6571 .61877 .65321 .6087 Mtetra
.537 .355 .582 r
.65321 .6087 .6571 .61877 .65977 .61445 .65587 .60439 Mtetra
.415 .291 .602 r
.65587 .60439 .65977 .61445 .66272 .61314 .6588 .60307 Mtetra
.235 .194 .606 r
.6588 .60307 .66272 .61314 .66595 .6146 .662 .6045 Mtetra
.047 .09 .584 r
.662 .6045 .66595 .6146 .66939 .61816 .66541 .608 Mtetra
0 .031 .561 r
.66541 .608 .66939 .61816 .67296 .62274 .66895 .61252 Mtetra
0 .048 .568 r
.66895 .61252 .67296 .62274 .67654 .62709 .6725 .6168 Mtetra
.121 .131 .596 r
.6725 .6168 .67654 .62709 .67999 .62996 .67592 .61963 Mtetra
.314 .236 .607 r
.67592 .61963 .67999 .62996 .68322 .63038 .67913 .62001 Mtetra
.47 .319 .593 r
.67913 .62001 .68322 .63038 .68614 .62777 .68204 .61741 Mtetra
.568 .369 .571 r
.68204 .61741 .68614 .62777 .68875 .62216 .68464 .61182 Mtetra
.622 .396 .553 r
.68464 .61182 .68875 .62216 .69109 .61409 .68698 .60381 Mtetra
.647 .408 .543 r
.68698 .60381 .69109 .61409 .69325 .60457 .68915 .59436 Mtetra
.652 .41 .541 r
.68915 .59436 .69325 .60457 .69538 .59484 .69127 .58469 Mtetra
.636 .403 .548 r
.69127 .58469 .69538 .59484 .69759 .58614 .69349 .57605 Mtetra
.595 .383 .563 r
.69349 .57605 .69759 .58614 .70004 .57952 .69593 .56947 Mtetra
.518 .345 .585 r
.69593 .56947 .70004 .57952 .7028 .57567 .69868 .56563 Mtetra
.39 .279 .606 r
.69868 .56563 .7028 .57567 .70592 .57481 .70178 .56475 Mtetra
.211 .184 .609 r
.70178 .56475 .70592 .57481 .70938 .57665 .70521 .56655 Mtetra
.037 .09 .589 r
.70521 .56655 .70938 .57665 .7131 .58047 .7089 .57032 Mtetra
0 .042 .571 r
.7089 .57032 .7131 .58047 .71697 .58519 .71273 .57497 Mtetra
0 .064 .58 r
.71273 .57497 .71697 .58519 .72082 .58956 .71655 .57927 Mtetra
.139 .145 .603 r
.71655 .57927 .72082 .58956 .7245 .59236 .72021 .58202 Mtetra
.324 .244 .609 r
.72021 .58202 .7245 .59236 .72788 .59263 .72356 .58227 Mtetra
.472 .32 .593 r
.72356 .58227 .72788 .59263 .73088 .58989 .72655 .57952 Mtetra
.567 .367 .569 r
.72655 .57952 .73088 .58989 .73349 .58418 .72915 .57384 Mtetra
.619 .392 .55 r
.72915 .57384 .73349 .58418 .73577 .57611 .73143 .56583 Mtetra
.643 .403 .54 r
.73143 .56583 .73577 .57611 .73785 .56672 .73351 .5565 Mtetra
.646 .404 .539 r
.73351 .5565 .73785 .56672 .7399 .55723 .73557 .54708 Mtetra
.627 .396 .547 r
.73557 .54708 .7399 .55723 .74209 .54889 .73776 .5388 Mtetra
.582 .374 .565 r
.73776 .5388 .74209 .54889 .74458 .54271 .74025 .53264 Mtetra
.499 .334 .589 r
.74025 .53264 .74458 .54271 .74747 .53931 .74312 .52926 Mtetra
.365 .267 .61 r
.74312 .52926 .74747 .53931 .75079 .53888 .74642 .52881 Mtetra
.189 .177 .612 r
.74642 .52881 .75079 .53888 .75453 .54109 .75013 .53097 Mtetra
.03 .092 .594 r
.75013 .53097 .75453 .54109 .75858 .54518 .75414 .535 Mtetra
0 .055 .58 r
.75414 .535 .75858 .54518 .76278 .55005 .7583 .5398 Mtetra
.01 .081 .59 r
.7583 .5398 .76278 .55005 .76694 .55445 .76242 .54412 Mtetra
.156 .159 .61 r
.76242 .54412 .76694 .55445 .77087 .55717 .76632 .54679 Mtetra
.332 .25 .611 r
.76632 .54679 .77087 .55717 .77442 .5573 .76984 .5469 Mtetra
.475 .321 .592 r
.76984 .5469 .77442 .5573 .7775 .5544 .77291 .54401 Mtetra
.566 .364 .567 r
.77291 .54401 .7775 .5544 .7801 .54859 .7755 .53822 Mtetra
.617 .388 .547 r
.7755 .53822 .7801 .54859 .78233 .54052 .77773 .5302 Mtetra
.639 .398 .537 r
.77773 .5302 .78233 .54052 .78433 .53123 .77974 .52098 Mtetra
.77974 .52098 .78433 .53123 .78633 .52198 .78174 .51179 Mtetra
.617 .388 .547 r
.78174 .51179 .78633 .52198 .78851 .51398 .78393 .50385 Mtetra
.568 .366 .567 r
.78393 .50385 .78851 .51398 .79107 .50821 .78648 .49811 Mtetra
.479 .324 .593 r
.78648 .49811 .79107 .50821 .79412 .50526 .78952 .49516 Mtetra
.34 .257 .614 r
.78952 .49516 .79412 .50526 .7977 .50526 .79307 .49514 Mtetra
.169 .171 .616 r
.79307 .49514 .7977 .50526 .80177 .50784 .7971 .49766 Mtetra
.027 .096 .6 r
.7971 .49766 .80177 .50784 .80618 .5122 .80148 .50195 Mtetra
0 .068 .59 r
.80148 .50195 .80618 .5122 .81076 .51722 .80601 .5069 Mtetra
.029 .098 .601 r
.80601 .5069 .81076 .51722 .81526 .52164 .81047 .51125 Mtetra
.172 .171 .616 r
.81047 .51125 .81526 .52164 .81947 .52429 .81464 .51384 Mtetra
.34 .256 .613 r
.81464 .51384 .81947 .52429 .8232 .52428 .81834 .51381 Mtetra
.476 .321 .591 r
.81834 .51381 .8232 .52428 .82636 .52123 .82149 .51077 Mtetra
.564 .361 .564 r
.82149 .51077 .82636 .52123 .82897 .51531 .82409 .50487 Mtetra
.613 .383 .544 r
.82409 .50487 .82897 .51531 .83114 .50721 .82627 .49683 Mtetra
.634 .392 .534 r
.82627 .49683 .83114 .50721 .83308 .49801 .82821 .4877 Mtetra
.632 .391 .535 r
.82821 .4877 .83308 .49801 .83503 .48898 .83017 .47873 Mtetra
.607 .38 .547 r
.83017 .47873 .83503 .48898 .83724 .4813 .83237 .4711 Mtetra
.552 .357 .569 r
.83237 .4711 .83724 .4813 .83991 .47594 .83503 .46577 Mtetra
.457 .314 .597 r
.83503 .46577 .83991 .47594 .84316 .47343 .83827 .46326 Mtetra
.316 .247 .619 r
.83827 .46326 .84316 .47343 .84705 .47386 .84213 .46365 Mtetra
.153 .167 .62 r
.84213 .46365 .84705 .47386 .85149 .47681 .84654 .46655 Mtetra
.027 .102 .607 r
.84654 .46655 .85149 .47681 .85633 .48144 .85133 .47111 Mtetra
0 .082 .6 r
.85133 .47111 .85633 .48144 .86134 .48662 .85628 .47621 Mtetra
.049 .114 .61 r
.85628 .47621 .86134 .48662 .86622 .49108 .86112 .48059 Mtetra
.187 .183 .621 r
.86112 .48059 .86622 .49108 .87073 .49365 .86559 .48311 Mtetra
.348 .261 .614 r
.86559 .48311 .87073 .49365 .87466 .4935 .8695 .48294 Mtetra
.478 .321 .589 r
.8695 .48294 .87466 .4935 .87792 .49029 .87274 .47973 Mtetra
.562 .358 .561 r
.87274 .47973 .87792 .49029 .88054 .48425 .87534 .47372 Mtetra
.609 .378 .541 r
.87534 .47372 .88054 .48425 .88266 .47611 .87747 .46563 Mtetra
.628 .386 .531 r
.87747 .46563 .88266 .47611 .88453 .46699 .87935 .45658 Mtetra
.624 .384 .533 r
.87935 .45658 .88453 .46699 .88645 .45816 .88128 .44781 Mtetra
.596 .372 .548 r
.88128 .44781 .88645 .45816 .88871 .4508 .88353 .4405 Mtetra
.536 .347 .572 r
.88353 .4405 .88871 .4508 .89152 .44583 .88634 .43555 Mtetra
.436 .304 .602 r
.88634 .43555 .89152 .44583 .89504 .44376 .88983 .43348 Mtetra
.294 .239 .623 r
.88983 .43348 .89504 .44376 .89929 .44461 .89405 .43429 Mtetra
.14 .165 .625 r
.89405 .43429 .89929 .44461 .90418 .44794 .8989 .43756 Mtetra
.03 .11 .614 r
.8989 .43756 .90418 .44794 .90951 .45286 .90417 .4424 Mtetra
.003 .097 .61 r
.90417 .4424 .90951 .45286 .915 .45821 .9096 .44766 Mtetra
.068 .129 .619 r
.9096 .44766 .915 .45821 .92032 .46271 .91487 .45209 Mtetra
.201 .194 .626 r
.91487 .45209 .92032 .46271 .92516 .46521 .91968 .45454 Mtetra
.354 .265 .615 r
.91968 .45454 .92516 .46521 .92932 .46492 .9238 .45422 Mtetra
.574 .383 .584 r
.47352 .83718 .4767 .84735 .47934 .84213 .47616 .83198 Mtetra
.638 .419 .568 r
.47616 .83198 .47934 .84213 .482 .83392 .47882 .82382 Mtetra
.669 .436 .558 r
.47882 .82382 .482 .83392 .48466 .8236 .48148 .81357 Mtetra
.681 .443 .554 r
.48148 .81357 .48466 .8236 .4873 .81238 .48412 .80242 Mtetra
.676 .44 .556 r
.48412 .80242 .4873 .81238 .48993 .80163 .48675 .79174 Mtetra
.654 .428 .564 r
.48675 .79174 .48993 .80163 .49253 .7926 .48935 .78276 Mtetra
.607 .401 .577 r
.48935 .78276 .49253 .7926 .49513 .78622 .49194 .77641 Mtetra
.515 .35 .595 r
.49194 .77641 .49513 .78622 .49772 .78296 .49453 .77317 Mtetra
.35 .255 .605 r
.49453 .77317 .49772 .78296 .50033 .7828 .49712 .77299 Mtetra
.113 .116 .582 r
.49712 .77299 .50033 .7828 .50296 .78518 .49973 .77533 Mtetra
0 0 .533 r
.49973 .77533 .50296 .78518 .50562 .78911 .50237 .77921 Mtetra
0 0 .521 r
.50237 .77921 .50562 .78911 .5083 .79333 .50503 .78337 Mtetra
.024 .063 .563 r
.50503 .78337 .5083 .79333 .51099 .79649 .5077 .78648 Mtetra
.264 .205 .601 r
.5077 .78648 .51099 .79649 .51368 .79743 .51037 .7874 Mtetra
.459 .317 .6 r
.51037 .7874 .51368 .79743 .51635 .79538 .51303 .78534 Mtetra
.575 .382 .583 r
.51303 .78534 .51635 .79538 .51898 .79009 .51566 .78008 Mtetra
.637 .416 .566 r
.51566 .78008 .51898 .79009 .52157 .78195 .51824 .77198 Mtetra
.667 .433 .556 r
.51824 .77198 .52157 .78195 .52412 .77184 .52079 .76193 Mtetra
.678 .438 .552 r
.52079 .76193 .52412 .77184 .52664 .76098 .52331 .75114 Mtetra
.671 .435 .555 r
.52331 .75114 .52664 .76098 .52915 .7507 .52582 .74094 Mtetra
.646 .421 .564 r
.52582 .74094 .52915 .7507 .53167 .74221 .52835 .7325 Mtetra
.593 .393 .579 r
.52835 .7325 .53167 .74221 .53425 .73639 .53092 .7267 Mtetra
.493 .337 .598 r
.53092 .7267 .53425 .73639 .53688 .73365 .53354 .72397 Mtetra
.319 .24 .608 r
.53354 .72397 .53688 .73365 .53959 .73392 .53624 .72421 Mtetra
.086 .105 .583 r
.53624 .72421 .53959 .73392 .54238 .73659 .539 .72684 Mtetra
0 0 .539 r
.539 .72684 .54238 .73659 .54522 .74068 .54181 .73087 Mtetra
0 0 .534 r
.54181 .73087 .54522 .74068 .54808 .74491 .54466 .73505 Mtetra
.045 .081 .575 r
.54466 .73505 .54808 .74491 .55094 .74799 .54749 .73808 Mtetra
.277 .215 .605 r
.54749 .73808 .55094 .74799 .55375 .74879 .55028 .73885 Mtetra
.464 .321 .6 r
.55028 .73885 .55375 .74879 .55647 .7466 .55299 .73666 Mtetra
.576 .382 .581 r
.55299 .73666 .55647 .7466 .55909 .74125 .55561 .73133 Mtetra
.636 .414 .564 r
.55561 .73133 .55909 .74125 .56161 .73315 .55813 .72329 Mtetra
.665 .429 .553 r
.55813 .72329 .56161 .73315 .56406 .72323 .56057 .71343 Mtetra
.674 .434 .55 r
.56057 .71343 .56406 .72323 .56646 .7127 .56298 .70297 Mtetra
.665 .429 .553 r
.56298 .70297 .56646 .7127 .56887 .70288 .56539 .6932 Mtetra
.637 .414 .564 r
.56539 .6932 .56887 .70288 .57134 .6949 .56786 .68528 Mtetra
.578 .383 .581 r
.56786 .68528 .57134 .6949 .57391 .68961 .57043 .68001 Mtetra
.469 .325 .602 r
.57043 .68001 .57391 .68961 .57662 .68736 .57312 .67776 Mtetra
.288 .225 .61 r
.57312 .67776 .57662 .68736 .57946 .68803 .57594 .6784 Mtetra
.062 .096 .584 r
.57594 .6784 .57946 .68803 .58242 .69099 .57888 .68131 Mtetra
0 .006 .546 r
.57888 .68131 .58242 .69099 .58547 .69522 .5819 .68549 Mtetra
0 .007 .547 r
.5819 .68549 .58547 .69522 .58854 .69947 .58495 .68968 Mtetra
.067 .099 .585 r
.58495 .68968 .58854 .69947 .59157 .70246 .58796 .69263 Mtetra
.29 .225 .609 r
.58796 .69263 .59157 .70246 .5945 .70312 .59087 .69326 Mtetra
.469 .323 .6 r
.59087 .69326 .5945 .70312 .59729 .7008 .59364 .69093 Mtetra
.576 .381 .579 r
.59364 .69093 .59729 .7008 .5999 .69537 .59625 .68554 Mtetra
.634 .411 .561 r
.59625 .68554 .5999 .69537 .60236 .68732 .5987 .67753 Mtetra
.662 .425 .551 r
.5987 .67753 .60236 .68732 .6047 .67757 .60105 .66785 Mtetra
.67 .429 .548 r
.60105 .66785 .6047 .67757 .607 .66735 .60335 .65769 Mtetra
.659 .424 .552 r
.60335 .65769 .607 .66735 .60933 .65794 .60569 .64834 Mtetra
.627 .407 .564 r
.60569 .64834 .60933 .65794 .61177 .65046 .60812 .6409 Mtetra
.562 .374 .584 r
.60812 .6409 .61177 .65046 .61437 .64567 .61072 .63613 Mtetra
.444 .312 .606 r
.61072 .63613 .61437 .64567 .61717 .64389 .61351 .63435 Mtetra
.258 .211 .612 r
.61351 .63435 .61717 .64389 .62018 .64495 .61649 .63538 Mtetra
.043 .091 .587 r
.61649 .63538 .62018 .64495 .62335 .64818 .61964 .63856 Mtetra
0 .014 .555 r
.61964 .63856 .62335 .64818 .62663 .65255 .62289 .64287 Mtetra
0 .025 .56 r
.62289 .64287 .62663 .65255 .62992 .65682 .62615 .64708 Mtetra
.087 .116 .594 r
.62615 .64708 .62992 .65682 .63315 .65973 .62935 .64994 Mtetra
.302 .234 .613 r
.62935 .64994 .63315 .65973 .63621 .66025 .63239 .65044 Mtetra
.472 .326 .6 r
.63239 .65044 .63621 .66025 .63905 .65779 .63522 .64798 Mtetra
.576 .379 .578 r
.63522 .64798 .63905 .65779 .64166 .65229 .63782 .6425 Mtetra
.632 .408 .559 r
.63782 .6425 .64166 .65229 .64405 .64426 .64022 .63452 Mtetra
.659 .421 .548 r
.64022 .63452 .64405 .64426 .64631 .63467 .64248 .62499 Mtetra
.665 .424 .545 r
.64248 .62499 .64631 .63467 .64851 .62473 .64469 .61512 Mtetra
.652 .417 .551 r
.64469 .61512 .64851 .62473 .65078 .61572 .64696 .60616 Mtetra
.616 .4 .565 r
.64696 .60616 .65078 .61572 .65321 .6087 .64938 .59918 Mtetra
.544 .364 .587 r
.64938 .59918 .65321 .6087 .65587 .60439 .65203 .59489 Mtetra
.419 .299 .61 r
.65203 .59489 .65587 .60439 .6588 .60307 .65495 .59356 Mtetra
.229 .199 .615 r
.65495 .59356 .6588 .60307 .662 .6045 .65813 .59496 Mtetra
.029 .088 .59 r
.65813 .59496 .662 .6045 .66541 .608 .66151 .59841 Mtetra
0 .025 .564 r
.66151 .59841 .66541 .608 .66895 .61252 .66502 .60286 Mtetra
0 .043 .572 r
.66502 .60286 .66895 .61252 .6725 .6168 .66853 .60708 Mtetra
.107 .132 .603 r
.66853 .60708 .6725 .6168 .67592 .61963 .67194 .60986 Mtetra
.313 .243 .616 r
.67194 .60986 .67592 .61963 .67913 .62001 .67512 .61022 Mtetra
.476 .327 .6 r
.67512 .61022 .67913 .62001 .68204 .61741 .67801 .60762 Mtetra
.576 .378 .576 r
.67801 .60762 .68204 .61741 .68464 .61182 .68061 .60206 Mtetra
.63 .404 .556 r
.68061 .60206 .68464 .61182 .68698 .60381 .68295 .59409 Mtetra
.656 .416 .545 r
.68295 .59409 .68698 .60381 .68915 .59436 .68512 .5847 Mtetra
.66 .418 .543 r
.68512 .5847 .68915 .59436 .69127 .58469 .68725 .5751 Mtetra
.644 .411 .55 r
.68725 .5751 .69127 .58469 .69349 .57605 .68947 .56651 Mtetra
.603 .392 .567 r
.68947 .56651 .69349 .57605 .69593 .56947 .69191 .55997 Mtetra
.526 .354 .591 r
.69191 .55997 .69593 .56947 .69868 .56563 .69465 .55614 Mtetra
.392 .287 .614 r
.69465 .55614 .69868 .56563 .70178 .56475 .69773 .55525 Mtetra
.203 .188 .618 r
.69773 .55525 .70178 .56475 .70521 .56655 .70114 .55701 Mtetra
.018 .088 .595 r
.70114 .55701 .70521 .56655 .7089 .57032 .7048 .56072 Mtetra
0 .037 .574 r
.7048 .56072 .7089 .57032 .71273 .57497 .70859 .56531 Mtetra
0 .061 .584 r
.70859 .56531 .71273 .57497 .71655 .57927 .71238 .56955 Mtetra
.127 .147 .611 r
.71238 .56955 .71655 .57927 .72021 .58202 .716 .57225 Mtetra
.323 .25 .618 r
.716 .57225 .72021 .58202 .72356 .58227 .71934 .57247 Mtetra
.478 .329 .599 r
.71934 .57247 .72356 .58227 .72655 .57952 .72231 .56972 Mtetra
.575 .376 .573 r
.72231 .56972 .72655 .57952 .72915 .57384 .7249 .56407 Mtetra
.628 .4 .553 r
.7249 .56407 .72915 .57384 .73143 .56583 .72718 .55611 Mtetra
.652 .411 .542 r
.72718 .55611 .73143 .56583 .73351 .5565 .72927 .54684 Mtetra
.654 .412 .541 r
.72927 .54684 .73351 .5565 .73557 .54708 .73133 .53748 Mtetra
.635 .404 .55 r
.73133 .53748 .73557 .54708 .73776 .5388 .73353 .52925 Mtetra
.59 .383 .569 r
.73353 .52925 .73776 .5388 .74025 .53264 .73601 .52313 Mtetra
.506 .343 .595 r
.73601 .52313 .74025 .53264 .74312 .52926 .73887 .51975 Mtetra
.366 .275 .618 r
.73887 .51975 .74312 .52926 .74642 .52881 .74215 .51928 Mtetra
.18 .18 .621 r
.74215 .51928 .74642 .52881 .75013 .53097 .74583 .52141 Mtetra
.011 .09 .6 r
.74583 .52141 .75013 .53097 .75414 .535 .74981 .52537 Mtetra
0 .05 .584 r
.74981 .52537 .75414 .535 .7583 .5398 .75393 .5301 Mtetra
0 .079 .596 r
.75393 .5301 .7583 .5398 .76242 .54412 .75801 .53436 Mtetra
.145 .161 .618 r
.75801 .53436 .76242 .54412 .76632 .54679 .76188 .53698 Mtetra
.332 .257 .62 r
.76188 .53698 .76632 .54679 .76984 .5469 .76538 .53707 Mtetra
.481 .33 .598 r
.76538 .53707 .76984 .5469 .77291 .54401 .76843 .53418 Mtetra
.574 .373 .571 r
.76843 .53418 .77291 .54401 .7755 .53822 .77102 .52842 Mtetra
.625 .396 .55 r
.77102 .52842 .7755 .53822 .77773 .5302 .77325 .52045 Mtetra
.647 .406 .539 r
.77325 .52045 .77773 .5302 .77974 .52098 .77527 .51129 Mtetra
.648 .406 .539 r
.77527 .51129 .77974 .52098 .78174 .51179 .77727 .50216 Mtetra
.626 .397 .55 r
.77727 .50216 .78174 .51179 .78393 .50385 .77946 .49426 Mtetra
.576 .375 .571 r
.77946 .49426 .78393 .50385 .78648 .49811 .78201 .48855 Mtetra
.485 .333 .599 r
.78201 .48855 .78648 .49811 .78952 .49516 .78503 .48561 Mtetra
.34 .264 .623 r
.78503 .48561 .78952 .49516 .79307 .49514 .78856 .48556 Mtetra
.16 .173 .625 r
.78856 .48556 .79307 .49514 .7971 .49766 .79256 .48804 Mtetra
.008 .095 .606 r
.79256 .48804 .7971 .49766 .80148 .50195 .79689 .49227 Mtetra
0 .065 .595 r
.79689 .49227 .80148 .50195 .80601 .5069 .80138 .49714 Mtetra
.011 .096 .606 r
.80138 .49714 .80601 .5069 .81047 .51125 .80581 .50143 Mtetra
.162 .174 .624 r
.80581 .50143 .81047 .51125 .81464 .51384 .80994 .50397 Mtetra
.34 .263 .622 r
.80994 .50397 .81464 .51384 .81834 .51381 .81362 .50392 Mtetra
.483 .33 .597 r
.81362 .50392 .81834 .51381 .82149 .51077 .81675 .50087 Mtetra
.573 .37 .569 r
.81675 .50087 .82149 .51077 .82409 .50487 .81935 .49501 Mtetra
.622 .392 .547 r
.81935 .49501 .82409 .50487 .82627 .49683 .82152 .48702 Mtetra
.643 .4 .537 r
.82152 .48702 .82627 .49683 .82821 .4877 .82347 .47795 Mtetra
.641 .399 .538 r
.82347 .47795 .82821 .4877 .83017 .47873 .82544 .46903 Mtetra
.616 .389 .55 r
.82544 .46903 .83017 .47873 .83237 .4711 .82764 .46146 Mtetra
.56 .366 .574 r
.82764 .46146 .83237 .4711 .83503 .46577 .8303 .45614 Mtetra
.463 .322 .604 r
.8303 .45614 .83503 .46577 .83827 .46326 .83352 .45363 Mtetra
.315 .254 .627 r
.83352 .45363 .83827 .46326 .84213 .46365 .83735 .454 Mtetra
.143 .169 .629 r
.83735 .454 .84213 .46365 .84654 .46655 .84172 .45684 Mtetra
.009 .101 .613 r
.84172 .45684 .84654 .46655 .85133 .47111 .84647 .46133 Mtetra
0 .08 .605 r
.84647 .46133 .85133 .47111 .85628 .47621 .85137 .46636 Mtetra
.032 .113 .616 r
.85137 .46636 .85628 .47621 .86112 .48059 .85617 .47067 Mtetra
.178 .187 .63 r
.85617 .47067 .86112 .48059 .86559 .48311 .8606 .47314 Mtetra
.348 .268 .623 r
.8606 .47314 .86559 .48311 .8695 .48294 .86448 .47295 Mtetra
.484 .33 .596 r
.86448 .47295 .8695 .48294 .87274 .47973 .8677 .46974 Mtetra
.571 .367 .566 r
.8677 .46974 .87274 .47973 .87534 .47372 .87031 .46376 Mtetra
.618 .387 .544 r
.87031 .46376 .87534 .47372 .87747 .46563 .87243 .45573 Mtetra
.637 .394 .534 r
.87243 .45573 .87747 .46563 .87935 .45658 .87432 .44674 Mtetra
.633 .392 .536 r
.87432 .44674 .87935 .45658 .88128 .44781 .87626 .43802 Mtetra
.604 .381 .551 r
.87626 .43802 .88128 .44781 .88353 .4405 .87851 .43076 Mtetra
.544 .356 .577 r
.87851 .43076 .88353 .4405 .88634 .43555 .8813 .42583 Mtetra
.44 .312 .609 r
.8813 .42583 .88634 .43555 .88983 .43348 .88478 .42375 Mtetra
.292 .245 .632 r
.88478 .42375 .88983 .43348 .89405 .43429 .88896 .42453 Mtetra
.129 .167 .633 r
.88896 .42453 .89405 .43429 .8989 .43756 .89377 .42774 Mtetra
.012 .109 .62 r
.89377 .42774 .8989 .43756 .90417 .4424 .899 .43251 Mtetra
0 .095 .615 r
.899 .43251 .90417 .4424 .9096 .44766 .90438 .43769 Mtetra
.052 .129 .626 r
.90438 .43769 .9096 .44766 .91487 .45209 .9096 .44204 Mtetra
.194 .198 .635 r
.9096 .44204 .91487 .45209 .91968 .45454 .91436 .44444 Mtetra
.355 .273 .624 r
.91436 .44444 .91968 .45454 .9238 .45422 .91845 .4441 Mtetra
.605 .418 .602 r
.47035 .82888 .47352 .83718 .47616 .83198 .47298 .8237 Mtetra
.667 .449 .58 r
.47298 .8237 .47616 .83198 .47882 .82382 .47564 .81558 Mtetra
.697 .464 .566 r
.47564 .81558 .47882 .82382 .48148 .81357 .4783 .80537 Mtetra
.707 .469 .561 r
.4783 .80537 .48148 .81357 .48412 .80242 .48095 .79429 Mtetra
.703 .467 .563 r
.48095 .79429 .48412 .80242 .48675 .79174 .48358 .78366 Mtetra
.683 .457 .573 r
.48358 .78366 .48675 .79174 .48935 .78276 .48619 .77472 Mtetra
.637 .434 .592 r
.48619 .77472 .48935 .78276 .49194 .77641 .48878 .76839 Mtetra
.543 .386 .619 r
.48878 .76839 .49194 .77641 .49453 .77317 .49136 .76515 Mtetra
.353 .285 .641 r
.49136 .76515 .49453 .77317 .49712 .77299 .49394 .76496 Mtetra
.05 .115 .611 r
.49394 .76496 .49712 .77299 .49973 .77533 .49653 .76727 Mtetra
0 0 .532 r
.49653 .76727 .49973 .77533 .50237 .77921 .49915 .77111 Mtetra
0 0 .513 r
.49915 .77111 .50237 .77921 .50503 .78337 .50179 .77522 Mtetra
0 .046 .581 r
.50179 .77522 .50503 .78337 .5077 .78648 .50444 .7783 Mtetra
.246 .226 .638 r
.50444 .7783 .5077 .78648 .51037 .7874 .5071 .77919 Mtetra
.482 .353 .629 r
.5071 .77919 .51037 .7874 .51303 .78534 .50975 .77713 Mtetra
.606 .417 .6 r
.50975 .77713 .51303 .78534 .51566 .78008 .51237 .77189 Mtetra
.667 .447 .577 r
.51237 .77189 .51566 .78008 .51824 .77198 .51495 .76383 Mtetra
.695 .461 .564 r
.51495 .76383 .51824 .77198 .52079 .76193 .51751 .75383 Mtetra
.705 .465 .559 r
.51751 .75383 .52079 .76193 .52331 .75114 .52003 .7431 Mtetra
.699 .463 .562 r
.52003 .7431 .52331 .75114 .52582 .74094 .52255 .73294 Mtetra
.675 .452 .574 r
.52255 .73294 .52582 .74094 .52835 .7325 .52508 .72454 Mtetra
.624 .427 .595 r
.52508 .72454 .52835 .7325 .53092 .7267 .52764 .71877 Mtetra
.518 .374 .624 r
.52764 .71877 .53092 .7267 .53354 .72397 .53026 .71603 Mtetra
.315 .267 .644 r
.53026 .71603 .53354 .72397 .53624 .72421 .53294 .71626 Mtetra
.015 .1 .609 r
.53294 .71626 .53624 .72421 .539 .72684 .53568 .71885 Mtetra
0 0 .538 r
.53568 .71885 .539 .72684 .54181 .73087 .53848 .72284 Mtetra
0 0 .53 r
.53848 .72284 .54181 .73087 .54466 .73505 .5413 .72697 Mtetra
0 .07 .596 r
.5413 .72697 .54466 .73505 .54749 .73808 .54411 .72997 Mtetra
.263 .238 .642 r
.54411 .72997 .54749 .73808 .55028 .73885 .54689 .73072 Mtetra
.487 .357 .629 r
.54689 .73072 .55028 .73885 .55299 .73666 .54959 .72852 Mtetra
.607 .417 .599 r
.54959 .72852 .55299 .73666 .55561 .73133 .5522 .72322 Mtetra
.666 .445 .575 r
.5522 .72322 .55561 .73133 .55813 .72329 .55472 .71521 Mtetra
.694 .458 .562 r
.55472 .71521 .55813 .72329 .56057 .71343 .55717 .7054 Mtetra
.702 .461 .557 r
.55717 .7054 .56057 .71343 .56298 .70297 .55958 .69499 Mtetra
.694 .458 .561 r
.55958 .69499 .56298 .70297 .56539 .6932 .562 .68527 Mtetra
.667 .446 .575 r
.562 .68527 .56539 .6932 .56786 .68528 .56447 .67738 Mtetra
.609 .418 .599 r
.56447 .67738 .56786 .68528 .57043 .68001 .56703 .67213 Mtetra
.492 .361 .63 r
.56703 .67213 .57043 .68001 .57312 .67776 .56971 .66988 Mtetra
.276 .249 .647 r
.56971 .66988 .57312 .67776 .57594 .6784 .57252 .6705 Mtetra
0 .089 .608 r
.57252 .6705 .57594 .6784 .57888 .68131 .57544 .67338 Mtetra
0 0 .546 r
.57544 .67338 .57888 .68131 .5819 .68549 .57844 .67751 Mtetra
0 0 .547 r
.57844 .67751 .5819 .68549 .58495 .68968 .58146 .68166 Mtetra
0 .092 .609 r
.58146 .68166 .58495 .68968 .58796 .69263 .58445 .68456 Mtetra
.279 .25 .646 r
.58445 .68456 .58796 .69263 .59087 .69326 .58735 .68518 Mtetra
.492 .36 .629 r
.58735 .68518 .59087 .69326 .59364 .69093 .59011 .68285 Mtetra
.607 .416 .597 r
.59011 .68285 .59364 .69093 .59625 .68554 .59271 .67747 Mtetra
.665 .442 .573 r
.59271 .67747 .59625 .68554 .5987 .67753 .59517 .6695 Mtetra
.691 .454 .559 r
.59517 .6695 .5987 .67753 .60105 .66785 .59752 .65986 Mtetra
.698 .457 .555 r
.59752 .65986 .60105 .66785 .60335 .65769 .59983 .64976 Mtetra
.688 .453 .561 r
.59983 .64976 .60335 .65769 .60569 .64834 .60217 .64046 Mtetra
.658 .439 .576 r
.60217 .64046 .60569 .64834 .60812 .6409 .6046 .63305 Mtetra
.592 .41 .603 r
.6046 .63305 .60812 .6409 .61072 .63613 .60719 .62829 Mtetra
.464 .348 .636 r
.60719 .62829 .61072 .63613 .61351 .63435 .60997 .62651 Mtetra
.239 .232 .65 r
.60997 .62651 .61351 .63435 .61649 .63538 .61293 .62751 Mtetra
0 .082 .609 r
.61293 .62751 .61649 .63538 .61964 .63856 .61606 .63065 Mtetra
0 0 .556 r
.61606 .63065 .61964 .63856 .62289 .64287 .61928 .63492 Mtetra
0 0 .564 r
.61928 .63492 .62289 .64287 .62615 .64708 .62253 .63908 Mtetra
.021 .113 .622 r
.62253 .63908 .62615 .64708 .62935 .64994 .6257 .64191 Mtetra
.294 .261 .65 r
.6257 .64191 .62935 .64994 .63239 .65044 .62873 .64238 Mtetra
.496 .362 .628 r
.62873 .64238 .63239 .65044 .63522 .64798 .63155 .63992 Mtetra
.607 .415 .595 r
.63155 .63992 .63522 .64798 .63782 .6425 .63415 .63446 Mtetra
.664 .44 .57 r
.63415 .63446 .63782 .6425 .64022 .63452 .63654 .62652 Mtetra
.689 .451 .556 r
.63654 .62652 .64022 .63452 .64248 .62499 .63881 .61703 Mtetra
.695 .453 .553 r
.63881 .61703 .64248 .62499 .64469 .61512 .64102 .60722 Mtetra
.682 .448 .56 r
.64102 .60722 .64469 .61512 .64696 .60616 .6433 .5983 Mtetra
.647 .433 .578 r
.6433 .5983 .64696 .60616 .64938 .59918 .64572 .59135 Mtetra
.574 .4 .608 r
.64572 .59135 .64938 .59918 .65203 .59489 .64837 .58707 Mtetra
.434 .334 .642 r
.64837 .58707 .65203 .59489 .65495 .59356 .65127 .58573 Mtetra
.203 .217 .652 r
.65127 .58573 .65495 .59356 .65813 .59496 .65443 .5871 Mtetra
0 .078 .611 r
.65443 .5871 .65813 .59496 .66151 .59841 .65779 .59051 Mtetra
0 0 .567 r
.65779 .59051 .66151 .59841 .66502 .60286 .66127 .59491 Mtetra
0 .022 .581 r
.66127 .59491 .66502 .60286 .66853 .60708 .66476 .59909 Mtetra
.047 .134 .632 r
.66476 .59909 .66853 .60708 .67194 .60986 .66813 .60183 Mtetra
.307 .27 .653 r
.66813 .60183 .67194 .60986 .67512 .61022 .6713 .60217 Mtetra
.5 .364 .627 r
.6713 .60217 .67512 .61022 .67801 .60762 .67419 .59957 Mtetra
.607 .413 .593 r
.67419 .59957 .67801 .60762 .68061 .60206 .67678 .59403 Mtetra
.662 .436 .567 r
.67678 .59403 .68061 .60206 .68295 .59409 .67912 .5861 Mtetra
.686 .446 .554 r
.67912 .5861 .68295 .59409 .68512 .5847 .6813 .57675 Mtetra
.69 .448 .551 r
.6813 .57675 .68512 .5847 .68725 .5751 .68343 .5672 Mtetra
.675 .442 .56 r
.68343 .5672 .68725 .5751 .68947 .56651 .68566 .55865 Mtetra
.635 .426 .581 r
.68566 .55865 .68947 .56651 .69191 .55997 .68809 .55214 Mtetra
.554 .39 .613 r
.68809 .55214 .69191 .55997 .69465 .55614 .69083 .54832 Mtetra
.404 .32 .648 r
.69083 .54832 .69465 .55614 .69773 .55525 .69389 .54741 Mtetra
.171 .204 .654 r
.69389 .54741 .69773 .55525 .70114 .55701 .69728 .54914 Mtetra
0 .078 .614 r
.69728 .54914 .70114 .55701 .7048 .56072 .70091 .55281 Mtetra
0 .015 .579 r
.70091 .55281 .7048 .56072 .70859 .56531 .70468 .55734 Mtetra
0 .044 .596 r
.70468 .55734 .70859 .56531 .71238 .56955 .70844 .56154 Mtetra
.073 .152 .642 r
.70844 .56154 .71238 .56955 .716 .57225 .71203 .5642 Mtetra
.32 .279 .655 r
.71203 .5642 .716 .57225 .71934 .57247 .71535 .5644 Mtetra
.503 .365 .626 r
.71535 .5644 .71934 .57247 .72231 .56972 .71831 .56165 Mtetra
.607 .411 .591 r
.71831 .56165 .72231 .56972 .7249 .56407 .7209 .55602 Mtetra
.66 .433 .564 r
.7209 .55602 .7249 .56407 .72718 .55611 .72318 .5481 Mtetra
.683 .442 .551 r
.72318 .5481 .72718 .55611 .72927 .54684 .72528 .53888 Mtetra
.685 .443 .549 r
.72528 .53888 .72927 .54684 .73133 .53748 .72735 .52957 Mtetra
.667 .436 .56 r
.72735 .52957 .73133 .53748 .73353 .52925 .72955 .52137 Mtetra
.622 .418 .584 r
.72955 .52137 .73353 .52925 .73601 .52313 .73202 .51528 Mtetra
.533 .38 .619 r
.73202 .51528 .73601 .52313 .73887 .51975 .73487 .5119 Mtetra
.372 .307 .654 r
.73487 .5119 .73887 .51975 .74215 .51928 .73814 .51142 Mtetra
.141 .193 .656 r
.73814 .51142 .74215 .51928 .74583 .52141 .74179 .51351 Mtetra
0 .081 .619 r
.74179 .51351 .74583 .52141 .74981 .52537 .74574 .51742 Mtetra
0 .032 .592 r
.74574 .51742 .74981 .52537 .75393 .5301 .74983 .5221 Mtetra
0 .067 .611 r
.74983 .5221 .75393 .5301 .75801 .53436 .75389 .52631 Mtetra
.097 .17 .651 r
.75389 .52631 .75801 .53436 .76188 .53698 .75773 .52889 Mtetra
.331 .286 .657 r
.75773 .52889 .76188 .53698 .76538 .53707 .76121 .52896 Mtetra
.506 .366 .625 r
.76121 .52896 .76538 .53707 .76843 .53418 .76424 .52607 Mtetra
.606 .409 .588 r
.76424 .52607 .76843 .53418 .77102 .52842 .76683 .52034 Mtetra
.658 .429 .561 r
.76683 .52034 .77102 .52842 .77325 .52045 .76906 .5124 Mtetra
.68 .437 .548 r
.76906 .5124 .77325 .52045 .77527 .51129 .77109 .50329 Mtetra
.77109 .50329 .77527 .51129 .77727 .50216 .7731 .49421 Mtetra
.659 .43 .561 r
.7731 .49421 .77727 .50216 .77946 .49426 .77529 .48634 Mtetra
.608 .41 .588 r
.77529 .48634 .77946 .49426 .78201 .48855 .77784 .48066 Mtetra
.51 .369 .626 r
.77784 .48066 .78201 .48855 .78503 .48561 .78085 .47772 Mtetra
.341 .294 .659 r
.78085 .47772 .78503 .48561 .78856 .48556 .78436 .47765 Mtetra
.116 .185 .658 r
.78436 .47765 .78856 .48556 .79256 .48804 .78832 .48009 Mtetra
0 .087 .624 r
.78832 .48009 .79256 .48804 .79689 .49227 .79263 .48426 Mtetra
0 .05 .605 r
.79263 .48426 .79689 .49227 .80138 .49714 .79708 .48908 Mtetra
0 .088 .625 r
.79708 .48908 .80138 .49714 .80581 .50143 .80147 .49332 Mtetra
.12 .186 .658 r
.80147 .49332 .80581 .50143 .80994 .50397 .80558 .49582 Mtetra
.341 .293 .658 r
.80558 .49582 .80994 .50397 .81362 .50392 .80924 .49574 Mtetra
.508 .367 .624 r
.80924 .49574 .81362 .50392 .81675 .50087 .81236 .4927 Mtetra
.605 .406 .586 r
.81236 .4927 .81675 .50087 .81935 .49501 .81495 .48686 Mtetra
.655 .425 .558 r
.81495 .48686 .81935 .49501 .82152 .48702 .81713 .47891 Mtetra
.676 .432 .545 r
.81713 .47891 .82152 .48702 .82347 .47795 .81909 .46988 Mtetra
.674 .432 .546 r
.81909 .46988 .82347 .47795 .82544 .46903 .82105 .46102 Mtetra
.649 .423 .562 r
.82105 .46102 .82544 .46903 .82764 .46146 .82326 .45347 Mtetra
.592 .402 .592 r
.82326 .45347 .82764 .46146 .8303 .45614 .82591 .44818 Mtetra
.485 .359 .633 r
.82591 .44818 .8303 .45614 .83352 .45363 .82912 .44567 Mtetra
.31 .282 .664 r
.82912 .44567 .83352 .45363 .83735 .454 .83293 .44601 Mtetra
.096 .179 .661 r
.83293 .44601 .83735 .454 .84172 .45684 .83727 .44881 Mtetra
0 .094 .632 r
.83727 .44881 .84172 .45684 .84647 .46133 .84198 .45325 Mtetra
0 .068 .618 r
.84198 .45325 .84647 .46133 .85137 .46636 .84685 .45821 Mtetra
0 .109 .638 r
.84685 .45821 .85137 .46636 .85617 .47067 .85161 .46247 Mtetra
.141 .201 .665 r
.85161 .46247 .85617 .47067 .8606 .47314 .85601 .4649 Mtetra
.35 .299 .659 r
.85601 .4649 .8606 .47314 .86448 .47295 .85986 .46468 Mtetra
.509 .366 .622 r
.85986 .46468 .86448 .47295 .8677 .46974 .86307 .46148 Mtetra
.604 .403 .583 r
.86307 .46148 .8677 .46974 .87031 .46376 .86567 .45553 Mtetra
.652 .42 .555 r
.86567 .45553 .87031 .46376 .87243 .45573 .8678 .44753 Mtetra
.671 .427 .542 r
.8678 .44753 .87243 .45573 .87432 .44674 .8697 .43859 Mtetra
.667 .425 .545 r
.8697 .43859 .87432 .44674 .87626 .43802 .87164 .42992 Mtetra
.638 .416 .564 r
.87164 .42992 .87626 .43802 .87851 .43076 .87389 .42268 Mtetra
.575 .393 .598 r
.87389 .42268 .87851 .43076 .8813 .42583 .87668 .41778 Mtetra
.459 .348 .64 r
.87668 .41778 .8813 .42583 .88478 .42375 .88015 .41569 Mtetra
.281 .271 .669 r
.88015 .41569 .88478 .42375 .88896 .42453 .8843 .41644 Mtetra
.08 .176 .665 r
.8843 .41644 .88896 .42453 .89377 .42774 .88907 .4196 Mtetra
0 .104 .639 r
.88907 .4196 .89377 .42774 .899 .43251 .89426 .42431 Mtetra
0 .087 .631 r
.89426 .42431 .899 .43251 .90438 .43769 .8996 .42943 Mtetra
0 .129 .65 r
.8996 .42943 .90438 .43769 .9096 .44204 .90477 .43373 Mtetra
.16 .214 .67 r
.90477 .43373 .9096 .44204 .91436 .44444 .9095 .43608 Mtetra
.358 .304 .659 r
.9095 .43608 .91436 .44444 .91845 .4441 .91357 .43572 Mtetra
.667 .491 .637 r
.46716 .82338 .47035 .82888 .47298 .8237 .46979 .81821 Mtetra
.723 .509 .599 r
.46979 .81821 .47298 .8237 .47564 .81558 .47245 .81011 Mtetra
.747 .515 .58 r
.47245 .81011 .47564 .81558 .4783 .80537 .47512 .79993 Mtetra
.755 .517 .572 r
.47512 .79993 .4783 .80537 .48095 .79429 .47778 .78887 Mtetra
.752 .517 .575 r
.47778 .78887 .48095 .79429 .48358 .78366 .48041 .77827 Mtetra
.736 .512 .589 r
.48041 .77827 .48358 .78366 .48619 .77472 .48303 .76936 Mtetra
.697 .501 .619 r
.48303 .76936 .48619 .77472 .48878 .76839 .48562 .76305 Mtetra
.603 .469 .671 r
.48562 .76305 .48878 .76839 .49136 .76515 .48819 .75981 Mtetra
.359 .365 .73 r
.48819 .75981 .49136 .76515 .49394 .76496 .49076 .75961 Mtetra
0 .104 .654 r
.49076 .75961 .49394 .76496 .49653 .76727 .49335 .76189 Mtetra
0 0 .453 r
.49335 .76189 .49653 .76727 .49915 .77111 .49595 .7657 Mtetra
0 0 .413 r
.49595 .7657 .49915 .77111 .50179 .77522 .49857 .7698 Mtetra
0 0 .573 r
.49857 .7698 .50179 .77522 .50444 .7783 .50121 .77285 Mtetra
.19 .282 .729 r
.50121 .77285 .50444 .7783 .5071 .77919 .50386 .77373 Mtetra
.534 .441 .696 r
.50386 .77373 .5071 .77919 .50975 .77713 .5065 .77166 Mtetra
.669 .491 .635 r
.5065 .77166 .50975 .77713 .51237 .77189 .50912 .76643 Mtetra
.723 .507 .597 r
.50912 .76643 .51237 .77189 .51495 .76383 .51171 .75839 Mtetra
.747 .513 .577 r
.51171 .75839 .51495 .76383 .51751 .75383 .51427 .74842 Mtetra
.754 .515 .571 r
.51427 .74842 .51751 .75383 .52003 .7431 .5168 .73772 Mtetra
.749 .514 .575 r
.5168 .73772 .52003 .7431 .52255 .73294 .51932 .72759 Mtetra
.731 .509 .591 r
.51932 .72759 .52255 .73294 .52508 .72454 .52186 .71921 Mtetra
.685 .496 .625 r
.52186 .71921 .52508 .72454 .52764 .71877 .52442 .71344 Mtetra
.576 .459 .682 r
.52442 .71344 .52764 .71877 .53026 .71603 .52703 .71071 Mtetra
.3 .34 .736 r
.52703 .71071 .53026 .71603 .53294 .71626 .5297 .71092 Mtetra
0 .08 .639 r
.5297 .71092 .53294 .71626 .53568 .71885 .53243 .7135 Mtetra
0 0 .463 r
.53243 .7135 .53568 .71885 .53848 .72284 .53521 .71746 Mtetra
0 0 .446 r
.53521 .71746 .53848 .72284 .5413 .72697 .53802 .72157 Mtetra
0 .032 .603 r
.53802 .72157 .5413 .72697 .54411 .72997 .54082 .72454 Mtetra
.219 .3 .734 r
.54082 .72454 .54411 .72997 .54689 .73072 .54358 .72527 Mtetra
.54 .444 .694 r
.54358 .72527 .54689 .73072 .54959 .72852 .54627 .72308 Mtetra
.67 .49 .633 r
.54627 .72308 .54959 .72852 .5522 .72322 .54888 .71778 Mtetra
.724 .506 .595 r
.54888 .71778 .5522 .72322 .55472 .71521 .55141 .70979 Mtetra
.746 .511 .575 r
.55141 .70979 .55472 .71521 .55717 .7054 .55386 .70001 Mtetra
.753 .513 .569 r
.55386 .70001 .55717 .7054 .55958 .69499 .55629 .68963 Mtetra
.747 .511 .575 r
.55629 .68963 .55958 .69499 .562 .68527 .55871 .67994 Mtetra
.724 .506 .594 r
.55871 .67994 .562 .68527 .56447 .67738 .56119 .67207 Mtetra
.672 .491 .633 r
.56119 .67207 .56447 .67738 .56703 .67213 .56375 .66682 Mtetra
.545 .447 .694 r
.56375 .66682 .56703 .67213 .56971 .66988 .56642 .66457 Mtetra
.24 .314 .739 r
.56642 .66457 .56971 .66988 .57252 .6705 .56922 .66518 Mtetra
0 .063 .627 r
.56922 .66518 .57252 .6705 .57544 .67338 .57213 .66803 Mtetra
0 0 .476 r
.57213 .66803 .57544 .67338 .57844 .67751 .57511 .67213 Mtetra
0 0 .479 r
.57511 .67213 .57844 .67751 .58146 .68166 .57811 .67625 Mtetra
0 .068 .631 r
.57811 .67625 .58146 .68166 .58445 .68456 .58108 .67914 Mtetra
.245 .315 .738 r
.58108 .67914 .58445 .68456 .58735 .68518 .58397 .67974 Mtetra
.546 .446 .693 r
.58397 .67974 .58735 .68518 .59011 .68285 .58672 .67741 Mtetra
.671 .49 .631 r
.58672 .67741 .59011 .68285 .59271 .67747 .58932 .67204 Mtetra
.724 .504 .592 r
.58932 .67204 .59271 .67747 .59517 .6695 .59178 .66409 Mtetra
.746 .509 .572 r
.59178 .66409 .59517 .6695 .59752 .65986 .59414 .65448 Mtetra
.751 .51 .567 r
.59414 .65448 .59752 .65986 .59983 .64976 .59646 .6444 Mtetra
.743 .509 .575 r
.59646 .6444 .59983 .64976 .60217 .64046 .59881 .63512 Mtetra
.717 .503 .598 r
.59881 .63512 .60217 .64046 .6046 .63305 .60124 .62773 Mtetra
.656 .486 .641 r
.60124 .62773 .6046 .63305 .60719 .62829 .60383 .62299 Mtetra
.51 .435 .707 r
.60383 .62299 .60719 .62829 .60997 .62651 .6066 .6212 Mtetra
.181 .288 .738 r
.6066 .6212 .60997 .62651 .61293 .62751 .60956 .62218 Mtetra
0 .052 .619 r
.60956 .62218 .61293 .62751 .61606 .63065 .61266 .6253 Mtetra
0 0 .493 r
.61266 .6253 .61606 .63065 .61928 .63492 .61587 .62954 Mtetra
0 0 .511 r
.61587 .62954 .61928 .63492 .62253 .63908 .6191 .63367 Mtetra
0 .101 .655 r
.6191 .63367 .62253 .63908 .6257 .64191 .62225 .63647 Mtetra
.268 .329 .741 r
.62225 .63647 .6257 .64191 .62873 .64238 .62527 .63694 Mtetra
.551 .449 .692 r
.62527 .63694 .62873 .64238 .63155 .63992 .62808 .63447 Mtetra
.672 .489 .629 r
.62808 .63447 .63155 .63992 .63415 .63446 .63068 .62902 Mtetra
.724 .502 .59 r
.63068 .62902 .63415 .63446 .63654 .62652 .63308 .6211 Mtetra
.745 .507 .57 r
.63308 .6211 .63654 .62652 .63881 .61703 .63535 .61164 Mtetra
.749 .508 .566 r
.63535 .61164 .63881 .61703 .64102 .60722 .63758 .60185 Mtetra
.739 .506 .575 r
.63758 .60185 .64102 .60722 .6433 .5983 .63986 .59296 Mtetra
.709 .499 .602 r
.63986 .59296 .6433 .5983 .64572 .59135 .64228 .58603 Mtetra
.638 .479 .651 r
.64228 .58603 .64572 .59135 .64837 .58707 .64492 .58175 Mtetra
.471 .42 .719 r
.64492 .58175 .64837 .58707 .65127 .58573 .64782 .58041 Mtetra
.125 .263 .736 r
.64782 .58041 .65127 .58573 .65443 .5871 .65096 .58176 Mtetra
0 .047 .615 r
.65096 .58176 .65443 .5871 .65779 .59051 .65431 .58514 Mtetra
0 0 .513 r
.65431 .58514 .65779 .59051 .66127 .59491 .65777 .58951 Mtetra
0 0 .542 r
.65777 .58951 .66127 .59491 .66476 .59909 .66123 .59366 Mtetra
0 .132 .676 r
.66123 .59366 .66476 .59909 .66813 .60183 .66459 .59638 Mtetra
.289 .341 .743 r
.66459 .59638 .66813 .60183 .6713 .60217 .66775 .5967 Mtetra
.555 .45 .69 r
.66775 .5967 .6713 .60217 .67419 .59957 .67063 .5941 Mtetra
.673 .488 .627 r
.67063 .5941 .67419 .59957 .67678 .59403 .67322 .58857 Mtetra
.723 .5 .587 r
.67322 .58857 .67678 .59403 .67912 .5861 .67556 .58066 Mtetra
.744 .504 .567 r
.67556 .58066 .67912 .5861 .6813 .57675 .67775 .57134 Mtetra
.747 .505 .564 r
.67775 .57134 .6813 .57675 .68343 .5672 .67989 .56181 Mtetra
.735 .503 .577 r
.67989 .56181 .68343 .5672 .68566 .55865 .68213 .55329 Mtetra
.699 .495 .608 r
.68213 .55329 .68566 .55865 .68809 .55214 .68456 .54679 Mtetra
.617 .472 .662 r
.68456 .54679 .68809 .55214 .69083 .54832 .68729 .54298 Mtetra
.429 .404 .73 r
.68729 .54298 .69083 .54832 .69389 .54741 .69035 .54206 Mtetra
.075 .241 .731 r
.69035 .54206 .69389 .54741 .69728 .54914 .69372 .54377 Mtetra
0 .048 .615 r
.69372 .54377 .69728 .54914 .70091 .55281 .69733 .54741 Mtetra
0 0 .534 r
.69733 .54741 .70091 .55281 .70468 .55734 .70108 .55191 Mtetra
0 0 .573 r
.70108 .55191 .70468 .55734 .70844 .56154 .70481 .55608 Mtetra
0 .16 .694 r
.70481 .55608 .70844 .56154 .71203 .5642 .70839 .55871 Mtetra
.308 .352 .744 r
.70839 .55871 .71203 .5642 .71535 .5644 .7117 .5589 Mtetra
.559 .452 .688 r
.7117 .5589 .71535 .5644 .71831 .56165 .71465 .55615 Mtetra
.673 .486 .625 r
.71465 .55615 .71831 .56165 .7209 .55602 .71724 .55053 Mtetra
.723 .498 .584 r
.71724 .55053 .7209 .55602 .72318 .5481 .71953 .54263 Mtetra
.743 .501 .565 r
.71953 .54263 .72318 .5481 .72528 .53888 .72163 .53343 Mtetra
.745 .502 .563 r
.72163 .53343 .72528 .53888 .72735 .52957 .72371 .52415 Mtetra
.729 .499 .578 r
.72371 .52415 .72735 .52957 .72955 .52137 .72591 .51598 Mtetra
.688 .49 .614 r
.72591 .51598 .72955 .52137 .73202 .51528 .72839 .5099 Mtetra
.593 .464 .674 r
.72839 .5099 .73202 .51528 .73487 .5119 .73124 .50652 Mtetra
.385 .387 .739 r
.73124 .50652 .73487 .5119 .73814 .51142 .73449 .50603 Mtetra
.032 .222 .726 r
.73449 .50603 .73814 .51142 .74179 .51351 .73813 .50809 Mtetra
0 .052 .618 r
.73813 .50809 .74179 .51351 .74574 .51742 .74205 .51198 Mtetra
0 0 .557 r
.74205 .51198 .74574 .51742 .74983 .5221 .74612 .51662 Mtetra
0 .032 .601 r
.74612 .51662 .74983 .5221 .75389 .52631 .75015 .5208 Mtetra
0 .186 .71 r
.75015 .5208 .75389 .52631 .75773 .52889 .75397 .52336 Mtetra
.324 .361 .745 r
.75397 .52336 .75773 .52889 .76121 .52896 .75744 .52341 Mtetra
.562 .452 .686 r
.75744 .52341 .76121 .52896 .76424 .52607 .76047 .52052 Mtetra
.673 .485 .622 r
.76047 .52052 .76424 .52607 .76683 .52034 .76306 .5148 Mtetra
.722 .495 .581 r
.76306 .5148 .76683 .52034 .76906 .5124 .76529 .50688 Mtetra
.741 .498 .562 r
.76529 .50688 .76906 .5124 .77109 .50329 .76733 .49779 Mtetra
.742 .498 .562 r
.76733 .49779 .77109 .50329 .7731 .49421 .76934 .48874 Mtetra
.723 .495 .581 r
.76934 .48874 .7731 .49421 .77529 .48634 .77154 .4809 Mtetra
.675 .485 .622 r
.77154 .4809 .77529 .48634 .77784 .48066 .77409 .47522 Mtetra
.567 .455 .686 r
.77409 .47522 .77784 .48066 .78085 .47772 .77709 .47228 Mtetra
.339 .37 .747 r
.77709 .47228 .78085 .47772 .78436 .47765 .78059 .4722 Mtetra
0 .208 .722 r
.78059 .4722 .78436 .47765 .78832 .48009 .78454 .47462 Mtetra
0 .061 .625 r
.78454 .47462 .78832 .48009 .79263 .48426 .78882 .47876 Mtetra
0 .01 .579 r
.78882 .47876 .79263 .48426 .79708 .48908 .79325 .48354 Mtetra
0 .063 .627 r
.79325 .48354 .79708 .48908 .80147 .49332 .79761 .48774 Mtetra
.002 .21 .722 r
.79761 .48774 .80147 .49332 .80558 .49582 .8017 .49022 Mtetra
.339 .369 .746 r
.8017 .49022 .80558 .49582 .80924 .49574 .80534 .49013 Mtetra
.565 .453 .685 r
.80534 .49013 .80924 .49574 .81236 .4927 .80845 .48709 Mtetra
.673 .483 .62 r
.80845 .48709 .81236 .4927 .81495 .48686 .81105 .48126 Mtetra
.721 .492 .578 r
.81105 .48126 .81495 .48686 .81713 .47891 .81323 .47332 Mtetra
.74 .495 .56 r
.81323 .47332 .81713 .47891 .81909 .46988 .8152 .46433 Mtetra
.738 .495 .562 r
.8152 .46433 .81909 .46988 .82105 .46102 .81717 .45549 Mtetra
.716 .492 .584 r
.81717 .45549 .82105 .46102 .82326 .45347 .81939 .44797 Mtetra
.66 .48 .63 r
.81939 .44797 .82326 .45347 .82591 .44818 .82203 .44268 Mtetra
.537 .445 .699 r
.82203 .44268 .82591 .44818 .82912 .44567 .82524 .44016 Mtetra
.294 .352 .752 r
.82524 .44016 .82912 .44567 .83293 .44601 .82903 .44049 Mtetra
0 .198 .718 r
.82903 .44049 .83293 .44601 .83727 .44881 .83334 .44326 Mtetra
0 .072 .634 r
.83334 .44326 .83727 .44881 .84198 .45325 .83803 .44766 Mtetra
0 .036 .602 r
.83803 .44766 .84198 .45325 .84685 .45821 .84287 .45259 Mtetra
0 .093 .651 r
.84287 .45259 .84685 .45821 .85161 .46247 .8476 .45682 Mtetra
.036 .231 .733 r
.8476 .45682 .85161 .46247 .85601 .4649 .85198 .45922 Mtetra
.353 .376 .746 r
.85198 .45922 .85601 .4649 .85986 .46468 .85582 .45899 Mtetra
.567 .453 .683 r
.85582 .45899 .85986 .46468 .86307 .46148 .85903 .45579 Mtetra
.673 .481 .617 r
.85903 .45579 .86307 .46148 .86567 .45553 .86163 .44984 Mtetra
.72 .489 .575 r
.86163 .44984 .86567 .45553 .8678 .44753 .86376 .44187 Mtetra
.737 .492 .557 r
.86376 .44187 .8678 .44753 .8697 .43859 .86567 .43295 Mtetra
.734 .491 .561 r
.86567 .43295 .8697 .43859 .87164 .42992 .86761 .42431 Mtetra
.707 .487 .588 r
.86761 .42431 .87164 .42992 .87389 .42268 .86987 .41709 Mtetra
.643 .474 .64 r
.86987 .41709 .87389 .42268 .87668 .41778 .87266 .41219 Mtetra
.504 .434 .711 r
.87266 .41219 .87668 .41778 .88015 .41569 .87611 .4101 Mtetra
.25 .335 .756 r
.87611 .4101 .88015 .41569 .8843 .41644 .88025 .41083 Mtetra
0 .191 .716 r
.88025 .41083 .8843 .41644 .88907 .4196 .885 .41396 Mtetra
0 .086 .645 r
.885 .41396 .88907 .4196 .89426 .42431 .89015 .41863 Mtetra
0 .062 .624 r
.89015 .41863 .89426 .42431 .8996 .42943 .89546 .42371 Mtetra
0 .121 .672 r
.89546 .42371 .8996 .42943 .90477 .43373 .90061 .42797 Mtetra
.068 .25 .742 r
.90061 .42797 .90477 .43373 .9095 .43608 .90531 .4303 Mtetra
.364 .382 .745 r
.90531 .4303 .9095 .43608 .91357 .43572 .90937 .42993 Mtetra
.777 .626 .693 r
.46393 .82112 .46716 .82338 .46979 .81821 .46656 .81595 Mtetra
.809 .604 .625 r
.46656 .81595 .46979 .81821 .47245 .81011 .46923 .80785 Mtetra
.82 .593 .595 r
.46923 .80785 .47245 .81011 .47512 .79993 .47191 .79767 Mtetra
.823 .589 .584 r
.47191 .79767 .47512 .79993 .47778 .78887 .47458 .78662 Mtetra
.822 .59 .588 r
.47458 .78662 .47778 .78887 .48041 .77827 .47723 .77602 Mtetra
.815 .598 .609 r
.47723 .77602 .48041 .77827 .48303 .76936 .47985 .76711 Mtetra
.795 .615 .658 r
.47985 .76711 .48303 .76936 .48562 .76305 .48244 .76079 Mtetra
.724 .644 .768 r
.48244 .76079 .48562 .76305 .48819 .75981 .48502 .75755 Mtetra
.333 .584 .935 r
.48502 .75755 .48819 .75981 .49076 .75961 .48759 .75735 Mtetra
.528 0 0 r
.48759 .75735 .49076 .75961 .49335 .76189 .49016 .75963 Mtetra
.731 .203 0 r
.49016 .75963 .49335 .76189 .49595 .7657 .49275 .76343 Mtetra
.747 .227 0 r
.49275 .76343 .49595 .7657 .49857 .7698 .49536 .76752 Mtetra
.651 .102 0 r
.49536 .76752 .49857 .7698 .50121 .77285 .49799 .77057 Mtetra
0 .396 .836 r
.49799 .77057 .50121 .77285 .50386 .77373 .50063 .77144 Mtetra
.648 .653 .841 r
.50063 .77144 .50386 .77373 .5065 .77166 .50327 .76937 Mtetra
.779 .626 .69 r
.50327 .76937 .5065 .77166 .50912 .76643 .50589 .76413 Mtetra
.811 .604 .622 r
.50589 .76413 .50912 .76643 .51171 .75839 .50849 .7561 Mtetra
.822 .593 .592 r
.50849 .7561 .51171 .75839 .51427 .74842 .51106 .74613 Mtetra
.825 .589 .583 r
.51106 .74613 .51427 .74842 .5168 .73772 .51361 .73542 Mtetra
.823 .592 .589 r
.51361 .73542 .5168 .73772 .51932 .72759 .51614 .7253 Mtetra
.814 .601 .613 r
.51614 .7253 .51932 .72759 .52186 .71921 .51868 .71692 Mtetra
.789 .62 .671 r
.51868 .71692 .52186 .71921 .52442 .71344 .52125 .71116 Mtetra
.696 .648 .798 r
.52125 .71116 .52442 .71344 .52703 .71071 .52386 .70842 Mtetra
.204 .528 .921 r
.52386 .70842 .52703 .71071 .5297 .71092 .52653 .70863 Mtetra
.556 .001 0 r
.52653 .70863 .5297 .71092 .53243 .7135 .52925 .7112 Mtetra
.722 .191 0 r
.52925 .7112 .53243 .7135 .53521 .71746 .53201 .71515 Mtetra
.73 .202 0 r
.53201 .71515 .53521 .71746 .53802 .72157 .53481 .71925 Mtetra
.612 .059 0 r
.53481 .71925 .53802 .72157 .54082 .72454 .5376 .72221 Mtetra
.02 .434 .867 r
.5376 .72221 .54082 .72454 .54358 .72527 .54035 .72294 Mtetra
.655 .652 .835 r
.54035 .72294 .54358 .72527 .54627 .72308 .54305 .72074 Mtetra
.781 .626 .688 r
.54305 .72074 .54627 .72308 .54888 .71778 .54566 .71544 Mtetra
.813 .604 .62 r
.54566 .71544 .54888 .71778 .55141 .70979 .54819 .70746 Mtetra
.824 .594 .59 r
.54819 .70746 .55141 .70979 .55386 .70001 .55066 .69768 Mtetra
.827 .59 .581 r
.55066 .69768 .55386 .70001 .55629 .68963 .55309 .6873 Mtetra
.824 .593 .59 r
.55309 .6873 .55629 .68963 .55871 .67994 .55553 .67761 Mtetra
.813 .604 .619 r
.55553 .67761 .55871 .67994 .56119 .67207 .55801 .66974 Mtetra
.782 .625 .686 r
.55801 .66974 .56119 .67207 .56375 .66682 .56058 .6645 Mtetra
.659 .65 .83 r
.56058 .6645 .56375 .66682 .56642 .66457 .56325 .66224 Mtetra
.075 .461 .886 r
.56325 .66224 .56642 .66457 .56922 .66518 .56604 .66284 Mtetra
.573 .019 0 r
.56604 .66284 .56922 .66518 .57213 .66803 .56894 .66569 Mtetra
.711 .177 0 r
.56894 .66569 .57213 .66803 .57511 .67213 .5719 .66978 Mtetra
.71 .175 0 r
.5719 .66978 .57511 .67213 .57811 .67625 .5749 .67389 Mtetra
.567 .014 0 r
.5749 .67389 .57811 .67625 .58108 .67914 .57786 .67677 Mtetra
.083 .466 .889 r
.57786 .67677 .58108 .67914 .58397 .67974 .58074 .67737 Mtetra
.661 .651 .83 r
.58074 .67737 .58397 .67974 .58672 .67741 .58349 .67503 Mtetra
.784 .626 .686 r
.58349 .67503 .58672 .67741 .58932 .67204 .58609 .66966 Mtetra
.816 .605 .617 r
.58609 .66966 .58932 .67204 .59178 .66409 .58856 .66171 Mtetra
.826 .594 .587 r
.58856 .66171 .59178 .66409 .59414 .65448 .59093 .6521 Mtetra
.829 .591 .58 r
.59093 .6521 .59414 .65448 .59646 .6444 .59326 .64203 Mtetra
.825 .595 .591 r
.59326 .64203 .59646 .6444 .59881 .63512 .59562 .63276 Mtetra
.812 .608 .626 r
.59562 .63276 .59881 .63512 .60124 .62773 .59806 .62536 Mtetra
.772 .631 .705 r
.59806 .62536 .60124 .62773 .60383 .62299 .60065 .62062 Mtetra
.61 .647 .862 r
.60065 .62062 .60383 .62299 .6066 .6212 .60342 .61882 Mtetra
0 .392 .838 r
.60342 .61882 .6066 .6212 .60956 .62218 .60637 .6198 Mtetra
.58 .029 0 r
.60637 .6198 .60956 .62218 .61266 .6253 .60946 .62291 Mtetra
.696 .159 0 r
.60946 .62291 .61266 .6253 .61587 .62954 .61266 .62714 Mtetra
.685 .145 0 r
.61266 .62714 .61587 .62954 .6191 .63367 .61587 .63127 Mtetra
.517 0 0 r
.61587 .63127 .6191 .63367 .62225 .63647 .61902 .63406 Mtetra
.139 .492 .904 r
.61902 .63406 .62225 .63647 .62527 .63694 .62203 .63452 Mtetra
.667 .651 .825 r
.62203 .63452 .62527 .63694 .62808 .63447 .62484 .63205 Mtetra
.786 .627 .683 r
.62484 .63205 .62808 .63447 .63068 .62902 .62744 .6266 Mtetra
.818 .605 .615 r
.62744 .6266 .63068 .62902 .63308 .6211 .62985 .61868 Mtetra
.829 .595 .585 r
.62985 .61868 .63308 .6211 .63535 .61164 .63213 .60922 Mtetra
.831 .592 .579 r
.63213 .60922 .63535 .61164 .63758 .60185 .63436 .59944 Mtetra
.826 .598 .593 r
.63436 .59944 .63758 .60185 .63986 .59296 .63665 .59055 Mtetra
.81 .612 .635 r
.63665 .59055 .63986 .59296 .64228 .58603 .63909 .58361 Mtetra
.758 .637 .726 r
.63909 .58361 .64228 .58603 .64492 .58175 .64173 .57934 Mtetra
.548 .637 .891 r
.64173 .57934 .64492 .58175 .64782 .58041 .64462 .57799 Mtetra
0 .33 .788 r
.64462 .57799 .64782 .58041 .65096 .58176 .64776 .57933 Mtetra
.581 .031 0 r
.64776 .57933 .65096 .58176 .65431 .58514 .65109 .5827 Mtetra
.678 .138 0 r
.65109 .5827 .65431 .58514 .65777 .58951 .65454 .58707 Mtetra
.656 .113 0 r
.65454 .58707 .65777 .58951 .66123 .59366 .65799 .59121 Mtetra
.464 0 0 r
.65799 .59121 .66123 .59366 .66459 .59638 .66134 .59392 Mtetra
.187 .513 .914 r
.66134 .59392 .66459 .59638 .66775 .5967 .66449 .59423 Mtetra
.672 .651 .82 r
.66449 .59423 .66775 .5967 .67063 .5941 .66737 .59163 Mtetra
.789 .627 .681 r
.66737 .59163 .67063 .5941 .67322 .58857 .66996 .5861 Mtetra
.821 .606 .612 r
.66996 .5861 .67322 .58857 .67556 .58066 .67231 .57819 Mtetra
.831 .596 .582 r
.67231 .57819 .67556 .58066 .67775 .57134 .67451 .56887 Mtetra
.833 .594 .578 r
.67451 .56887 .67775 .57134 .67989 .56181 .67666 .55935 Mtetra
.827 .6 .596 r
.67666 .55935 .67989 .56181 .68213 .55329 .67891 .55083 Mtetra
.806 .617 .646 r
.67891 .55083 .68213 .55329 .68456 .54679 .68135 .54433 Mtetra
.74 .642 .751 r
.68135 .54433 .68456 .54679 .68729 .54298 .68408 .54051 Mtetra
.473 .619 .913 r
.68408 .54051 .68729 .54298 .69035 .54206 .68713 .53959 Mtetra
0 .278 .742 r
.68713 .53959 .69035 .54206 .69372 .54377 .69049 .54129 Mtetra
.575 .027 0 r
.69049 .54129 .69372 .54377 .69733 .54741 .69409 .54492 Mtetra
.657 .115 0 r
.69409 .54492 .69733 .54741 .70108 .55191 .69782 .54941 Mtetra
.624 .078 0 r
.69782 .54941 .70108 .55191 .70481 .55608 .70155 .55357 Mtetra
0 .126 .584 r
.70155 .55357 .70481 .55608 .70839 .55871 .70512 .55619 Mtetra
.229 .53 .92 r
.70512 .55619 .70839 .55871 .7117 .5589 .70841 .55637 Mtetra
.677 .651 .816 r
.70841 .55637 .7117 .5589 .71465 .55615 .71136 .55363 Mtetra
.791 .628 .679 r
.71136 .55363 .71465 .55615 .71724 .55053 .71396 .54801 Mtetra
.824 .607 .609 r
.71396 .54801 .71724 .55053 .71953 .54263 .71625 .5401 Mtetra
.834 .597 .58 r
.71625 .5401 .71953 .54263 .72163 .53343 .71837 .53091 Mtetra
.835 .596 .577 r
.71837 .53091 .72163 .53343 .72371 .52415 .72046 .52163 Mtetra
.827 .604 .6 r
.72046 .52163 .72371 .52415 .72591 .51598 .72267 .51346 Mtetra
.801 .622 .659 r
.72267 .51346 .72591 .51598 .72839 .5099 .72515 .50737 Mtetra
.717 .647 .779 r
.72515 .50737 .72839 .5099 .73124 .50652 .728 .504 Mtetra
.388 .591 .925 r
.728 .504 .73124 .50652 .73449 .50603 .73125 .5035 Mtetra
0 .238 .706 r
.73125 .5035 .73449 .50603 .73813 .50809 .73487 .50555 Mtetra
.564 .019 0 r
.73487 .50555 .73813 .50809 .74205 .51198 .73878 .50943 Mtetra
.632 .088 0 r
.73878 .50943 .74205 .51198 .74612 .51662 .74284 .51406 Mtetra
.587 .041 0 r
.74284 .51406 .74612 .51662 .75015 .5208 .74685 .51823 Mtetra
0 .171 .636 r
.74685 .51823 .75015 .5208 .75397 .52336 .75066 .52078 Mtetra
.266 .544 .924 r
.75066 .52078 .75397 .52336 .75744 .52341 .75412 .52082 Mtetra
.682 .651 .813 r
.75412 .52082 .75744 .52341 .76047 .52052 .75715 .51793 Mtetra
.794 .629 .676 r
.75715 .51793 .76047 .52052 .76306 .5148 .75975 .51221 Mtetra
.827 .608 .606 r
.75975 .51221 .76306 .5148 .76529 .50688 .76199 .5043 Mtetra
.837 .598 .577 r
.76199 .5043 .76529 .50688 .76733 .49779 .76403 .49521 Mtetra
.837 .597 .577 r
.76403 .49521 .76733 .49779 .76934 .48874 .76606 .48616 Mtetra
.827 .607 .605 r
.76606 .48616 .76934 .48874 .77154 .4809 .76827 .47832 Mtetra
.795 .628 .674 r
.76827 .47832 .77154 .4809 .77409 .47522 .77082 .47264 Mtetra
.686 .649 .808 r
.77082 .47264 .77409 .47522 .77709 .47228 .77382 .4697 Mtetra
.297 .555 .924 r
.77382 .4697 .77709 .47228 .78059 .4722 .77731 .46961 Mtetra
0 .209 .68 r
.77731 .46961 .78059 .4722 .78454 .47462 .78125 .47202 Mtetra
.549 .006 0 r
.78125 .47202 .78454 .47462 .78882 .47876 .78551 .47615 Mtetra
.604 .06 0 r
.78551 .47615 .78882 .47876 .79325 .48354 .78993 .48092 Mtetra
.546 .003 0 r
.78993 .48092 .79325 .48354 .79761 .48774 .79428 .48511 Mtetra
0 .213 .683 r
.79428 .48511 .79761 .48774 .8017 .49022 .79835 .48758 Mtetra
.297 .556 .925 r
.79835 .48758 .8017 .49022 .80534 .49013 .80199 .48748 Mtetra
.686 .651 .81 r
.80199 .48748 .80534 .49013 .80845 .48709 .8051 .48443 Mtetra
.797 .63 .674 r
.8051 .48443 .80845 .48709 .81105 .48126 .8077 .4786 Mtetra
.83 .609 .603 r
.8077 .4786 .81105 .48126 .81323 .47332 .80989 .47067 Mtetra
.84 .599 .575 r
.80989 .47067 .81323 .47332 .8152 .46433 .81187 .46168 Mtetra
.839 .6 .577 r
.81187 .46168 .8152 .46433 .81717 .45549 .81385 .45284 Mtetra
.826 .611 .612 r
.81385 .45284 .81717 .45549 .81939 .44797 .81608 .44532 Mtetra
.786 .634 .693 r
.81608 .44532 .81939 .44797 .82203 .44268 .81873 .44003 Mtetra
.646 .649 .838 r
.81873 .44003 .82203 .44268 .82524 .44016 .82193 .43751 Mtetra
.208 .514 .913 r
.82193 .43751 .82524 .44016 .82903 .44049 .82571 .43783 Mtetra
0 .191 .663 r
.82571 .43783 .82903 .44049 .83334 .44326 .83001 .44059 Mtetra
.529 0 0 r
.83001 .44059 .83334 .44326 .83803 .44766 .83469 .44498 Mtetra
.572 .03 0 r
.83469 .44498 .83803 .44766 .84287 .45259 .83951 .44989 Mtetra
.502 0 0 r
.83951 .44989 .84287 .45259 .8476 .45682 .84423 .45411 Mtetra
0 .252 .724 r
.84423 .45411 .8476 .45682 .85198 .45922 .8486 .4565 Mtetra
.325 .565 .925 r
.8486 .4565 .85198 .45922 .85582 .45899 .85243 .45626 Mtetra
.691 .652 .807 r
.85243 .45626 .85582 .45899 .85903 .45579 .85563 .45306 Mtetra
.8 .631 .672 r
.85563 .45306 .85903 .45579 .86163 .44984 .85824 .44711 Mtetra
.833 .61 .6 r
.85824 .44711 .86163 .44984 .86376 .44187 .86038 .43914 Mtetra
.843 .6 .572 r
.86038 .43914 .86376 .44187 .86567 .43295 .8623 .43023 Mtetra
.841 .603 .578 r
.8623 .43023 .86567 .43295 .86761 .42431 .86425 .42159 Mtetra
.825 .616 .621 r
.86425 .42159 .86761 .42431 .86987 .41709 .86652 .41437 Mtetra
.773 .641 .715 r
.86652 .41437 .86987 .41709 .87266 .41219 .86931 .40947 Mtetra
.597 .643 .867 r
.86931 .40947 .87266 .41219 .87611 .4101 .87276 .40737 Mtetra
.128 .472 .894 r
.87276 .40737 .87611 .4101 .88025 .41083 .87689 .4081 Mtetra
0 .18 .655 r
.87689 .4081 .88025 .41083 .885 .41396 .88162 .41121 Mtetra
.506 0 0 r
.88162 .41121 .885 .41396 .89015 .41863 .88676 .41587 Mtetra
.536 0 0 r
.88676 .41587 .89015 .41863 .89546 .42371 .89205 .42094 Mtetra
.456 0 0 r
.89205 .42094 .89546 .42371 .90061 .42797 .89718 .42518 Mtetra
0 .288 .759 r
.89718 .42518 .90061 .42797 .90531 .4303 .90188 .4275 Mtetra
.348 .573 .924 r
.90188 .4275 .90531 .4303 .90937 .42993 .90592 .42712 Mtetra
.919 .829 .74 r
.46064 .82201 .46393 .82112 .46656 .81595 .46328 .81682 Mtetra
.911 .728 .641 r
.46328 .81682 .46656 .81595 .46923 .80785 .46596 .80871 Mtetra
.903 .688 .602 r
.46596 .80871 .46923 .80785 .47191 .79767 .46866 .79851 Mtetra
.899 .675 .589 r
.46866 .79851 .47191 .79767 .47458 .78662 .47134 .78743 Mtetra
.901 .68 .594 r
.47134 .78743 .47458 .78662 .47723 .77602 .47401 .77681 Mtetra
.907 .706 .621 r
.47401 .77681 .47723 .77602 .47985 .76711 .47664 .76787 Mtetra
.917 .774 .688 r
.47664 .76787 .47985 .76711 .48244 .76079 .47925 .76155 Mtetra
.875 .935 .856 r
.47925 .76155 .48244 .76079 .48502 .75755 .48183 .7583 Mtetra
.013 0 0 r
.48183 .7583 .48502 .75755 .48759 .75735 .48439 .75809 Mtetra
.566 .052 0 r
.48439 .75809 .48759 .75735 .49016 .75963 .48696 .76038 Mtetra
.664 .192 .123 r
.48696 .76038 .49016 .75963 .49275 .76343 .48954 .7642 Mtetra
.675 .208 .138 r
.48954 .7642 .49275 .76343 .49536 .76752 .49215 .76829 Mtetra
.621 .129 .063 r
.49215 .76829 .49536 .76752 .49799 .77057 .49477 .77135 Mtetra
.351 0 0 r
.49477 .77135 .49799 .77057 .50063 .77144 .49741 .77223 Mtetra
.707 .978 .911 r
.49741 .77223 .50063 .77144 .50327 .76937 .50005 .77015 Mtetra
.922 .829 .736 r
.50005 .77015 .50327 .76937 .50589 .76413 .50268 .76491 Mtetra
.916 .731 .638 r
.50268 .76491 .50589 .76413 .50849 .7561 .50529 .75685 Mtetra
.908 .692 .599 r
.50529 .75685 .50849 .7561 .51106 .74613 .50788 .74686 Mtetra
.905 .68 .587 r
.50788 .74686 .51106 .74613 .51361 .73542 .51044 .73613 Mtetra
.907 .687 .594 r
.51044 .73613 .51361 .73542 .51614 .7253 .51299 .72598 Mtetra
.913 .719 .626 r
.51299 .72598 .51614 .7253 .51868 .71692 .51554 .71759 Mtetra
.921 .797 .707 r
.51554 .71759 .51868 .71692 .52125 .71116 .51812 .71181 Mtetra
.829 .965 .894 r
.51812 .71181 .52125 .71116 .52386 .70842 .52073 .70907 Mtetra
.158 0 0 r
.52073 .70907 .52386 .70842 .52653 .70863 .5234 .70928 Mtetra
.584 .068 0 r
.5234 .70928 .52653 .70863 .52925 .7112 .52611 .71186 Mtetra
.666 .187 .104 r
.52611 .71186 .52925 .7112 .53201 .71515 .52887 .71582 Mtetra
.671 .194 .11 r
.52887 .71582 .53201 .71515 .53481 .71925 .53166 .71993 Mtetra
.609 .103 .025 r
.53166 .71993 .53481 .71925 .5376 .72221 .53444 .7229 Mtetra
.307 0 0 r
.53444 .7229 .5376 .72221 .54035 .72294 .53719 .72364 Mtetra
.73 .98 .915 r
.53719 .72364 .54035 .72294 .54305 .72074 .53989 .72143 Mtetra
.925 .829 .732 r
.53989 .72143 .54305 .72074 .54566 .71544 .54251 .71612 Mtetra
.92 .734 .634 r
.54251 .71612 .54566 .71544 .54819 .70746 .54505 .70812 Mtetra
.913 .696 .595 r
.54505 .70812 .54819 .70746 .55066 .69768 .54754 .69831 Mtetra
.91 .685 .584 r
.54754 .69831 .55066 .69768 .55309 .6873 .54998 .68792 Mtetra
.913 .695 .595 r
.54998 .68792 .55309 .6873 .55553 .67761 .55244 .6782 Mtetra
.92 .733 .633 r
.55244 .6782 .55553 .67761 .55801 .66974 .55493 .67032 Mtetra
.923 .825 .73 r
.55493 .67032 .55801 .66974 .56058 .6645 .5575 .66506 Mtetra
.748 .977 .92 r
.5575 .66506 .56058 .6645 .56325 .66224 .56018 .6628 Mtetra
.264 0 0 r
.56018 .6628 .56325 .66224 .56604 .66284 .56297 .66341 Mtetra
.597 .079 0 r
.56297 .66341 .56604 .66284 .56894 .66569 .56586 .66626 Mtetra
.666 .178 .082 r
.56586 .66626 .56894 .66569 .5719 .66978 .56882 .67036 Mtetra
.666 .177 .081 r
.56882 .67036 .5719 .66978 .5749 .67389 .5718 .67449 Mtetra
.594 .075 0 r
.5718 .67449 .5749 .67389 .57786 .67677 .57476 .67737 Mtetra
.259 0 0 r
.57476 .67737 .57786 .67677 .58074 .67737 .57763 .67797 Mtetra
.748 .98 .915 r
.57763 .67797 .58074 .67737 .58349 .67503 .58039 .67563 Mtetra
.928 .831 .728 r
.58039 .67563 .58349 .67503 .58609 .66966 .583 .67025 Mtetra
.925 .738 .63 r
.583 .67025 .58609 .66966 .58856 .66171 .58548 .66228 Mtetra
.919 .7 .591 r
.58548 .66228 .58856 .66171 .59093 .6521 .58787 .65265 Mtetra
.917 .691 .582 r
.58787 .65265 .59093 .6521 .59326 .64203 .59021 .64256 Mtetra
.919 .704 .596 r
.59021 .64256 .59326 .64203 .59562 .63276 .59258 .63326 Mtetra
.926 .749 .642 r
.59258 .63326 .59562 .63276 .59806 .62536 .59504 .62585 Mtetra
.922 .855 .758 r
.59504 .62585 .59806 .62536 .60065 .62062 .59763 .6211 Mtetra
.627 .955 .922 r
.59763 .6211 .60065 .62062 .60342 .61882 .6004 .6193 Mtetra
.341 0 0 r
.6004 .6193 .60342 .61882 .60637 .6198 .60335 .62028 Mtetra
.606 .083 0 r
.60335 .62028 .60637 .6198 .60946 .62291 .60644 .6234 Mtetra
.665 .167 .057 r
.60644 .6234 .60946 .62291 .61266 .62714 .60963 .62764 Mtetra
.659 .158 .048 r
.60963 .62764 .61266 .62714 .61587 .63127 .61283 .63178 Mtetra
.577 .044 0 r
.61283 .63178 .61587 .63127 .61902 .63406 .61597 .63458 Mtetra
.208 0 0 r
.61597 .63458 .61902 .63406 .62203 .63452 .61898 .63504 Mtetra
.763 .979 .914 r
.61898 .63504 .62203 .63452 .62484 .63205 .6218 .63256 Mtetra
.932 .833 .724 r
.6218 .63256 .62484 .63205 .62744 .6266 .6244 .6271 Mtetra
.931 .742 .626 r
.6244 .6271 .62744 .6266 .62985 .61868 .62682 .61917 Mtetra
.925 .705 .587 r
.62682 .61917 .62985 .61868 .63213 .60922 .62912 .60969 Mtetra
.923 .698 .579 r
.62912 .60969 .63213 .60922 .63436 .59944 .63137 .59988 Mtetra
.926 .715 .597 r
.63137 .59988 .63436 .59944 .63665 .59055 .63367 .59097 Mtetra
.933 .767 .654 r
.63367 .59097 .63665 .59055 .63909 .58361 .63611 .58402 Mtetra
.914 .888 .792 r
.63611 .58402 .63909 .58361 .64173 .57934 .63876 .57974 Mtetra
.47 .892 .89 r
.63876 .57974 .64173 .57934 .64462 .57799 .64166 .57838 Mtetra
.396 0 0 r
.64166 .57838 .64462 .57799 .64776 .57933 .64479 .57973 Mtetra
.611 .084 0 r
.64479 .57973 .64776 .57933 .65109 .5827 .64812 .58311 Mtetra
.661 .154 .029 r
.64812 .58311 .65109 .5827 .65454 .58707 .65156 .58749 Mtetra
.65 .137 .013 r
.65156 .58749 .65454 .58707 .65799 .59121 .655 .59164 Mtetra
.557 .011 0 r
.655 .59164 .65799 .59121 .66134 .59392 .65835 .59435 Mtetra
.155 0 0 r
.65835 .59435 .66134 .59392 .66449 .59423 .6615 .59467 Mtetra
.776 .979 .911 r
.6615 .59467 .66449 .59423 .66737 .59163 .66438 .59206 Mtetra
.937 .836 .72 r
.66438 .59206 .66737 .59163 .66996 .5861 .66698 .58652 Mtetra
.937 .747 .621 r
.66698 .58652 .66996 .5861 .67231 .57819 .66935 .57859 Mtetra
.931 .711 .583 r
.66935 .57859 .67231 .57819 .67451 .56887 .67155 .56926 Mtetra
.93 .706 .577 r
.67155 .56926 .67451 .56887 .67666 .55935 .67372 .55971 Mtetra
.934 .727 .6 r
.67372 .55971 .67666 .55935 .67891 .55083 .67598 .55117 Mtetra
.939 .789 .668 r
.67598 .55117 .67891 .55083 .68135 .54433 .67843 .54466 Mtetra
.897 .922 .829 r
.67843 .54466 .68135 .54433 .68408 .54051 .68116 .54083 Mtetra
.298 .795 .828 r
.68116 .54083 .68408 .54051 .68713 .53959 .68422 .53991 Mtetra
.435 0 0 r
.68422 .53991 .68713 .53959 .69049 .54129 .68757 .54162 Mtetra
.614 .08 0 r
.68757 .54162 .69049 .54129 .69409 .54492 .69117 .54525 Mtetra
.656 .139 0 r
.69117 .54525 .69409 .54492 .69782 .54941 .69489 .54976 Mtetra
.638 .114 0 r
.69489 .54976 .69782 .54941 .70155 .55357 .69861 .55392 Mtetra
.534 0 0 r
.69861 .55392 .70155 .55357 .70512 .55619 .70218 .55656 Mtetra
.102 0 0 r
.70218 .55656 .70512 .55619 .70841 .55637 .70547 .55674 Mtetra
.787 .978 .908 r
.70547 .55674 .70841 .55637 .71136 .55363 .70843 .55398 Mtetra
.941 .84 .715 r
.70843 .55398 .71136 .55363 .71396 .54801 .71103 .54835 Mtetra
.943 .752 .616 r
.71103 .54835 .71396 .54801 .71625 .5401 .71334 .54043 Mtetra
.938 .718 .578 r
.71334 .54043 .71625 .5401 .71837 .53091 .71547 .53122 Mtetra
.938 .714 .574 r
.71547 .53122 .71837 .53091 .72046 .52163 .71757 .52191 Mtetra
.942 .741 .604 r
.71757 .52191 .72046 .52163 .72267 .51346 .71979 .51372 Mtetra
.943 .813 .686 r
.71979 .51372 .72267 .51346 .72515 .50737 .72228 .50763 Mtetra
.863 .953 .868 r
.72228 .50763 .72515 .50737 .728 .504 .72513 .50425 Mtetra
.138 .684 .752 r
.72513 .50425 .728 .504 .73125 .5035 .72838 .50374 Mtetra
.463 0 0 r
.72838 .50374 .73125 .5035 .73487 .50555 .73201 .50581 Mtetra
.614 .073 0 r
.73201 .50581 .73487 .50555 .73878 .50943 .73591 .50969 Mtetra
.648 .121 0 r
.73591 .50969 .73878 .50943 .74284 .51406 .73996 .51434 Mtetra
.625 .089 0 r
.73996 .51434 .74284 .51406 .74685 .51823 .74397 .51852 Mtetra
.508 0 0 r
.74397 .51852 .74685 .51823 .75066 .52078 .74778 .52107 Mtetra
.05 0 0 r
.74778 .52107 .75066 .52078 .75412 .52082 .75124 .52112 Mtetra
.796 .978 .904 r
.75124 .52112 .75412 .52082 .75715 .51793 .75427 .51821 Mtetra
.947 .845 .71 r
.75427 .51821 .75715 .51793 .75975 .51221 .75687 .51248 Mtetra
.95 .758 .61 r
.75687 .51248 .75975 .51221 .76199 .5043 .75913 .50455 Mtetra
.946 .725 .572 r
.75913 .50455 .76199 .5043 .76403 .49521 .76118 .49544 Mtetra
.946 .724 .572 r
.76118 .49544 .76403 .49521 .76606 .48616 .76322 .48637 Mtetra
.949 .757 .609 r
.76322 .48637 .76606 .48616 .76827 .47832 .76544 .47852 Mtetra
.946 .841 .708 r
.76544 .47852 .76827 .47832 .77082 .47264 .768 .47282 Mtetra
.807 .973 .903 r
.768 .47282 .77082 .47264 .77382 .4697 .77101 .46987 Mtetra
0 0 0 r
.77101 .46987 .77382 .4697 .77731 .46961 .7745 .46978 Mtetra
.482 0 0 r
.7745 .46978 .77731 .46961 .78125 .47202 .77843 .4722 Mtetra
.61 .063 0 r
.77843 .4722 .78125 .47202 .78551 .47615 .78269 .47634 Mtetra
.638 .101 0 r
.78269 .47634 .78551 .47615 .78993 .48092 .7871 .48112 Mtetra
.609 .061 0 r
.7871 .48112 .78993 .48092 .79428 .48511 .79144 .48532 Mtetra
.48 0 0 r
.79144 .48532 .79428 .48511 .79835 .48758 .79552 .4878 Mtetra
0 0 0 r
.79552 .4878 .79835 .48758 .80199 .48748 .79916 .4877 Mtetra
.803 .979 .899 r
.79916 .4877 .80199 .48748 .8051 .48443 .80227 .48465 Mtetra
.952 .851 .704 r
.80227 .48465 .8051 .48443 .8077 .4786 .80488 .47881 Mtetra
.957 .765 .603 r
.80488 .47881 .8077 .4786 .80989 .47067 .80708 .47085 Mtetra
.953 .733 .566 r
.80708 .47085 .80989 .47067 .81187 .46168 .80907 .46184 Mtetra
.954 .735 .569 r
.80907 .46184 .81187 .46168 .81385 .45284 .81107 .45298 Mtetra
.957 .775 .615 r
.81107 .45298 .81385 .45284 .81608 .44532 .8133 .44544 Mtetra
.945 .872 .734 r
.8133 .44544 .81608 .44532 .81873 .44003 .81596 .44015 Mtetra
.721 .973 .927 r
.81596 .44015 .81873 .44003 .82193 .43751 .81916 .43762 Mtetra
.101 0 0 r
.81916 .43762 .82193 .43751 .82571 .43783 .82295 .43794 Mtetra
.494 0 0 r
.82295 .43794 .82571 .43783 .83001 .44059 .82725 .44071 Mtetra
.604 .049 0 r
.82725 .44071 .83001 .44059 .83469 .44498 .83192 .44511 Mtetra
.626 .078 0 r
.83192 .44511 .83469 .44498 .83951 .44989 .83673 .45003 Mtetra
.59 .031 0 r
.83673 .45003 .83951 .44989 .84423 .45411 .84145 .45426 Mtetra
.448 0 0 r
.84145 .45426 .84423 .45411 .8486 .4565 .84582 .45666 Mtetra
.046 .614 .71 r
.84582 .45666 .8486 .4565 .85243 .45626 .84965 .45642 Mtetra
.81 .981 .893 r
.84965 .45642 .85243 .45626 .85563 .45306 .85286 .45321 Mtetra
.958 .857 .698 r
.85286 .45321 .85563 .45306 .85824 .44711 .85547 .44725 Mtetra
.964 .773 .596 r
.85547 .44725 .85824 .44711 .86038 .43914 .85763 .43926 Mtetra
.961 .741 .559 r
.85763 .43926 .86038 .43914 .8623 .43023 .85955 .43032 Mtetra
.962 .748 .567 r
.85955 .43032 .8623 .43023 .86425 .42159 .86152 .42166 Mtetra
.965 .796 .625 r
.86152 .42166 .86425 .42159 .86652 .41437 .8638 .41443 Mtetra
.937 .905 .766 r
.8638 .41443 .86652 .41437 .86931 .40947 .8666 .40952 Mtetra
.606 .946 .931 r
.8666 .40952 .86931 .40947 .87276 .40737 .87005 .40741 Mtetra
.179 0 0 r
.87005 .40741 .87276 .40737 .87689 .4081 .87418 .40814 Mtetra
.5 0 0 r
.87418 .40814 .87689 .4081 .88162 .41121 .87891 .41127 Mtetra
.595 .032 0 r
.87891 .41127 .88162 .41121 .88676 .41587 .88405 .41593 Mtetra
.611 .053 0 r
.88405 .41593 .88676 .41587 .89205 .42094 .88933 .42101 Mtetra
.568 0 0 r
.88933 .42101 .89205 .42094 .89718 .42518 .89446 .42527 Mtetra
.414 0 0 r
.89446 .42527 .89718 .42518 .90188 .4275 .89916 .4276 Mtetra
.089 .648 .745 r
.89916 .4276 .90188 .4275 .90592 .42712 .9032 .42721 Mtetra
.946 .957 .669 r
.45729 .82543 .46064 .82201 .46328 .81682 .45995 .82023 Mtetra
.982 .836 .624 r
.45995 .82023 .46328 .81682 .46596 .80871 .46264 .81208 Mtetra
.966 .772 .591 r
.46264 .81208 .46596 .80871 .46866 .79851 .46536 .80183 Mtetra
.959 .751 .579 r
.46536 .80183 .46866 .79851 .47134 .78743 .46807 .7907 Mtetra
.962 .759 .584 r
.46807 .7907 .47134 .78743 .47401 .77681 .47075 .78004 Mtetra
.975 .802 .607 r
.47075 .78004 .47401 .77681 .47664 .76787 .4734 .77107 Mtetra
.981 .901 .656 r
.4734 .77107 .47664 .76787 .47925 .76155 .47602 .76472 Mtetra
.703 .928 .606 r
.47602 .76472 .47925 .76155 .48183 .7583 .4786 .76146 Mtetra
.193 0 0 r
.4786 .76146 .48183 .7583 .48439 .75809 .48117 .76126 Mtetra
.509 .074 .15 r
.48117 .76126 .48439 .75809 .48696 .76038 .48374 .76357 Mtetra
.594 .175 .218 r
.48374 .76357 .48696 .76038 .48954 .7642 .48632 .76741 Mtetra
.604 .188 .226 r
.48632 .76741 .48954 .7642 .49215 .76829 .48892 .77153 Mtetra
.554 .127 .186 r
.48892 .77153 .49215 .76829 .49477 .77135 .49154 .77461 Mtetra
.367 0 .046 r
.49154 .77461 .49477 .77135 .49741 .77223 .49417 .7755 Mtetra
0 0 0 r
.49417 .7755 .49741 .77223 .50005 .77015 .49682 .77342 Mtetra
.947 .955 .662 r
.49682 .77342 .50005 .77015 .50268 .76491 .49946 .76815 Mtetra
.985 .839 .616 r
.49946 .76815 .50268 .76491 .50529 .75685 .50209 .76007 Mtetra
.972 .778 .584 r
.50209 .76007 .50529 .75685 .50788 .74686 .50469 .75003 Mtetra
.966 .759 .574 r
.50469 .75003 .50788 .74686 .51044 .73613 .50727 .73926 Mtetra
.97 .771 .58 r
.50727 .73926 .51044 .73613 .51299 .72598 .50984 .72906 Mtetra
.982 .82 .607 r
.50984 .72906 .51299 .72598 .51554 .71759 .51241 .72063 Mtetra
.973 .928 .659 r
.51241 .72063 .51554 .71759 .51812 .71181 .515 .71484 Mtetra
.556 .854 .539 r
.515 .71484 .51812 .71181 .52073 .70907 .51762 .71209 Mtetra
.266 0 0 r
.51762 .71209 .52073 .70907 .5234 .70928 .52028 .7123 Mtetra
.525 .085 .146 r
.52028 .7123 .5234 .70928 .52611 .71186 .523 .7149 Mtetra
.598 .172 .204 r
.523 .7149 .52611 .71186 .52887 .71582 .52575 .71889 Mtetra
.603 .177 .207 r
.52575 .71889 .52887 .71582 .53166 .71993 .52854 .72303 Mtetra
.546 .11 .163 r
.52854 .72303 .53166 .71993 .53444 .7229 .53132 .72602 Mtetra
.345 0 .014 r
.53132 .72602 .53444 .7229 .53719 .72364 .53407 .72676 Mtetra
0 0 0 r
.53407 .72676 .53719 .72364 .53989 .72143 .53677 .72455 Mtetra
.947 .953 .655 r
.53677 .72455 .53989 .72143 .54251 .71612 .5394 .71922 Mtetra
.988 .843 .608 r
.5394 .71922 .54251 .71612 .54505 .70812 .54196 .71119 Mtetra
.977 .784 .577 r
.54196 .71119 .54505 .70812 .54754 .69831 .54446 .70134 Mtetra
.973 .767 .568 r
.54446 .70134 .54754 .69831 .54998 .68792 .54693 .6909 Mtetra
.977 .783 .577 r
.54693 .6909 .54998 .68792 .55244 .6782 .5494 .68115 Mtetra
.988 .841 .608 r
.5494 .68115 .55244 .6782 .55493 .67032 .55191 .67323 Mtetra
.952 .951 .659 r
.55191 .67323 .55493 .67032 .5575 .66506 .55449 .66795 Mtetra
0 0 0 r
.55449 .66795 .5575 .66506 .56018 .6628 .55717 .66569 Mtetra
.324 0 0 r
.55717 .66569 .56018 .6628 .56297 .66341 .55996 .6663 Mtetra
.539 .092 .139 r
.55996 .6663 .56297 .66341 .56586 .66626 .56285 .66918 Mtetra
.601 .166 .187 r
.56285 .66918 .56586 .66626 .56882 .67036 .56581 .67331 Mtetra
.6 .165 .187 r
.56581 .67331 .56882 .67036 .5718 .67449 .56879 .67746 Mtetra
.536 .09 .138 r
.56879 .67746 .5718 .67449 .57476 .67737 .57175 .68036 Mtetra
.32 0 0 r
.57175 .68036 .57476 .67737 .57763 .67797 .57462 .68097 Mtetra
0 0 0 r
.57462 .68097 .57763 .67797 .58039 .67563 .57738 .67862 Mtetra
.947 .951 .645 r
.57738 .67862 .58039 .67563 .583 .67025 .58001 .67322 Mtetra
.991 .847 .599 r
.58001 .67322 .583 .67025 .58548 .66228 .5825 .66522 Mtetra
.983 .791 .569 r
.5825 .66522 .58548 .66228 .58787 .65265 .58491 .65555 Mtetra
.979 .777 .561 r
.58491 .65555 .58787 .65265 .59021 .64256 .58727 .64542 Mtetra
.984 .797 .572 r
.58727 .64542 .59021 .64256 .59258 .63326 .58965 .63608 Mtetra
.991 .862 .608 r
.58965 .63608 .59258 .63326 .59504 .62585 .59212 .62864 Mtetra
.913 .965 .652 r
.59212 .62864 .59504 .62585 .59763 .6211 .59473 .62387 Mtetra
0 0 0 r
.59473 .62387 .59763 .6211 .6004 .6193 .5975 .62207 Mtetra
.369 0 0 r
.5975 .62207 .6004 .6193 .60335 .62028 .60045 .62306 Mtetra
.549 .096 .129 r
.60045 .62306 .60335 .62028 .60644 .6234 .60354 .6262 Mtetra
.602 .159 .169 r
.60354 .6262 .60644 .6234 .60963 .62764 .60672 .63047 Mtetra
.596 .151 .165 r
.60672 .63047 .60963 .62764 .61283 .63178 .60993 .63463 Mtetra
.526 .069 .111 r
.60993 .63463 .61283 .63178 .61597 .63458 .61307 .63745 Mtetra
.295 0 0 r
.61307 .63745 .61597 .63458 .61898 .63504 .61608 .63792 Mtetra
0 0 0 r
.61608 .63792 .61898 .63504 .6218 .63256 .6189 .63544 Mtetra
.945 .949 .634 r
.6189 .63544 .6218 .63256 .6244 .6271 .62152 .62996 Mtetra
.994 .851 .588 r
.62152 .62996 .6244 .6271 .62682 .61917 .62396 .62199 Mtetra
.988 .798 .559 r
.62396 .62199 .62682 .61917 .62912 .60969 .62627 .61247 Mtetra
.986 .786 .552 r
.62627 .61247 .62912 .60969 .63137 .59988 .62853 .60262 Mtetra
.991 .812 .567 r
.62853 .60262 .63137 .59988 .63367 .59097 .63085 .59367 Mtetra
.991 .885 .607 r
.63085 .59367 .63367 .59097 .63611 .58402 .63331 .5867 Mtetra
.848 .964 .636 r
.63331 .5867 .63611 .58402 .63876 .57974 .63597 .5824 Mtetra
0 0 0 r
.63597 .5824 .63876 .57974 .64166 .57838 .63887 .58104 Mtetra
.404 0 .003 r
.63887 .58104 .64166 .57838 .64479 .57973 .642 .58241 Mtetra
.558 .097 .115 r
.642 .58241 .64479 .57973 .64812 .58311 .64532 .58581 Mtetra
.602 .149 .149 r
.64532 .58581 .64812 .58311 .65156 .58749 .64876 .59021 Mtetra
.591 .136 .141 r
.64876 .59021 .65156 .58749 .655 .59164 .65221 .59439 Mtetra
.514 .047 .083 r
.65221 .59439 .655 .59164 .65835 .59435 .65556 .59713 Mtetra
.268 0 0 r
.65556 .59713 .65835 .59435 .6615 .59467 .65871 .59745 Mtetra
0 0 0 r
.65871 .59745 .6615 .59467 .66438 .59206 .6616 .59483 Mtetra
.941 .947 .62 r
.6616 .59483 .66438 .59206 .66698 .58652 .66421 .58927 Mtetra
.996 .855 .576 r
.66421 .58927 .66698 .58652 .66935 .57859 .66659 .58131 Mtetra
.993 .805 .548 r
.66659 .58131 .66935 .57859 .67155 .56926 .66881 .57194 Mtetra
.992 .797 .543 r
.66881 .57194 .67155 .56926 .67372 .55971 .671 .56235 Mtetra
.996 .828 .561 r
.671 .56235 .67372 .55971 .67598 .55117 .67327 .55377 Mtetra
.983 .907 .605 r
.67327 .55377 .67598 .55117 .67843 .54466 .67573 .54723 Mtetra
.755 .941 .606 r
.67573 .54723 .67843 .54466 .68116 .54083 .67847 .54339 Mtetra
.019 0 0 r
.67847 .54339 .68116 .54083 .68422 .53991 .68153 .54247 Mtetra
.432 0 .005 r
.68153 .54247 .68422 .53991 .68757 .54162 .68489 .5442 Mtetra
.563 .094 .099 r
.68489 .5442 .68757 .54162 .69117 .54525 .68849 .54786 Mtetra
.601 .138 .127 r
.68849 .54786 .69117 .54525 .69489 .54976 .69221 .55239 Mtetra
.585 .119 .115 r
.69221 .55239 .69489 .54976 .69861 .55392 .69593 .55658 Mtetra
.5 .023 .054 r
.69593 .55658 .69861 .55392 .70218 .55656 .6995 .55924 Mtetra
.242 0 0 r
.6995 .55924 .70218 .55656 .70547 .55674 .7028 .55943 Mtetra
0 0 0 r
.7028 .55943 .70547 .55674 .70843 .55398 .70576 .55666 Mtetra
.936 .943 .605 r
.70576 .55666 .70843 .55398 .71103 .54835 .70837 .55101 Mtetra
.997 .859 .561 r
.70837 .55101 .71103 .54835 .71334 .54043 .71069 .54306 Mtetra
.997 .812 .535 r
.71069 .54306 .71334 .54043 .71547 .53122 .71284 .5338 Mtetra
.997 .808 .532 r
.71284 .5338 .71547 .53122 .71757 .52191 .71495 .52446 Mtetra
.998 .844 .553 r
.71495 .52446 .71757 .52191 .71979 .51372 .71719 .51624 Mtetra
.966 .926 .6 r
.71719 .51624 .71979 .51372 .72228 .50763 .71969 .51012 Mtetra
.635 .891 .562 r
.71969 .51012 .72228 .50763 .72513 .50425 .72255 .50672 Mtetra
.112 0 0 r
.72255 .50672 .72513 .50425 .72838 .50374 .72581 .50622 Mtetra
.454 0 .001 r
.72581 .50622 .72838 .50374 .73201 .50581 .72943 .5083 Mtetra
.567 .09 .08 r
.72943 .5083 .73201 .50581 .73591 .50969 .73334 .51222 Mtetra
.598 .125 .103 r
.73334 .51222 .73591 .50969 .73996 .51434 .73739 .51689 Mtetra
.577 .101 .088 r
.73739 .51689 .73996 .51434 .74397 .51852 .7414 .5211 Mtetra
.485 0 .023 r
.7414 .5211 .74397 .51852 .74778 .52107 .74521 .52367 Mtetra
.215 0 0 r
.74521 .52367 .74778 .52107 .75124 .52112 .74868 .52372 Mtetra
0 0 0 r
.74868 .52372 .75124 .52112 .75427 .51821 .75172 .52081 Mtetra
.929 .939 .586 r
.75172 .52081 .75427 .51821 .75687 .51248 .75433 .51506 Mtetra
.996 .862 .544 r
.75433 .51506 .75687 .51248 .75913 .50455 .7566 .50709 Mtetra
.999 .819 .519 r
.7566 .50709 .75913 .50455 .76118 .49544 .75867 .49795 Mtetra
.999 .818 .519 r
.75867 .49795 .76118 .49544 .76322 .48637 .76073 .48883 Mtetra
.996 .86 .544 r
.76073 .48883 .76322 .48637 .76544 .47852 .76296 .48094 Mtetra
.935 .939 .59 r
.76296 .48094 .76544 .47852 .768 .47282 .76553 .47523 Mtetra
.498 .819 .508 r
.76553 .47523 .768 .47282 .77101 .46987 .76854 .47227 Mtetra
.186 0 0 r
.76854 .47227 .77101 .46987 .7745 .46978 .77204 .47219 Mtetra
.471 0 0 r
.77204 .47219 .7745 .46978 .77843 .4722 .77598 .47462 Mtetra
.569 .082 .059 r
.77598 .47462 .77843 .4722 .78269 .47634 .78024 .47879 Mtetra
.594 .11 .076 r
.78024 .47879 .78269 .47634 .7871 .48112 .78465 .4836 Mtetra
.568 .081 .058 r
.78465 .4836 .7871 .48112 .79144 .48532 .789 .48783 Mtetra
.469 0 0 r
.789 .48783 .79144 .48532 .79552 .4878 .79308 .49033 Mtetra
.188 0 0 r
.79308 .49033 .79552 .4878 .79916 .4877 .79672 .49023 Mtetra
0 0 0 r
.79672 .49023 .79916 .4877 .80227 .48465 .79985 .48717 Mtetra
.918 .933 .564 r
.79985 .48717 .80227 .48465 .80488 .47881 .80247 .48131 Mtetra
.993 .864 .524 r
.80247 .48131 .80488 .47881 .80708 .47085 .80468 .47332 Mtetra
1 .825 .501 r
.80468 .47332 .80708 .47085 .80907 .46184 .80669 .46427 Mtetra
.999 .829 .503 r
.80669 .46427 .80907 .46184 .81107 .45298 .8087 .45537 Mtetra
.989 .875 .532 r
.8087 .45537 .81107 .45298 .8133 .44544 .81094 .4478 Mtetra
.884 .941 .573 r
.81094 .4478 .8133 .44544 .81596 .44015 .81361 .44248 Mtetra
0 0 0 r
.81361 .44248 .81596 .44015 .81916 .43762 .81682 .43995 Mtetra
.244 0 0 r
.81682 .43995 .81916 .43762 .82295 .43794 .82061 .44028 Mtetra
.484 0 0 r
.82061 .44028 .82295 .43794 .82725 .44071 .82492 .44307 Mtetra
.569 .072 .035 r
.82492 .44307 .82725 .44071 .83192 .44511 .82959 .4475 Mtetra
.588 .093 .047 r
.82959 .4475 .83192 .44511 .83673 .45003 .83442 .45245 Mtetra
.557 .059 .027 r
.83442 .45245 .83673 .45003 .84145 .45426 .83913 .45671 Mtetra
.452 0 0 r
.83913 .45671 .84145 .45426 .84582 .45666 .84351 .45913 Mtetra
.162 0 0 r
.84351 .45913 .84582 .45666 .84965 .45642 .84735 .45889 Mtetra
0 0 0 r
.84735 .45889 .84965 .45642 .85286 .45321 .85057 .45567 Mtetra
.904 .924 .539 r
.85057 .45567 .85286 .45321 .85547 .44725 .85319 .44969 Mtetra
.986 .864 .5 r
.85319 .44969 .85547 .44725 .85763 .43926 .85536 .44166 Mtetra
.997 .83 .479 r
.85536 .44166 .85763 .43926 .85955 .43032 .8573 .43269 Mtetra
.995 .837 .484 r
.8573 .43269 .85955 .43032 .86152 .42166 .85928 .42399 Mtetra
.972 .887 .516 r
.85928 .42399 .86152 .42166 .8638 .41443 .86157 .41673 Mtetra
.81 .927 .548 r
.86157 .41673 .8638 .41443 .8666 .40952 .86438 .41179 Mtetra
0 0 0 r
.86438 .41179 .8666 .40952 .87005 .40741 .86784 .40968 Mtetra
.289 0 0 r
.86784 .40968 .87005 .40741 .87418 .40814 .87198 .41042 Mtetra
.493 0 0 r
.87198 .41042 .87418 .40814 .87891 .41127 .87672 .41357 Mtetra
.567 .059 .007 r
.87672 .41357 .87891 .41127 .88405 .41593 .88186 .41827 Mtetra
.58 .075 .016 r
.88186 .41827 .88405 .41593 .88933 .42101 .88715 .42338 Mtetra
.545 .035 0 r
.88715 .42338 .88933 .42101 .89446 .42527 .89229 .42767 Mtetra
.433 0 0 r
.89229 .42767 .89446 .42527 .89916 .4276 .89699 .43001 Mtetra
.138 0 0 r
.89699 .43001 .89916 .4276 .9032 .42721 .90105 .42963 Mtetra
.843 .923 .533 r
.4539 .83034 .45729 .82543 .45995 .82023 .45656 .82511 Mtetra
.993 .881 .585 r
.45656 .82511 .45995 .82023 .46264 .81208 .45928 .81692 Mtetra
.991 .817 .57 r
.45928 .81692 .46264 .81208 .46536 .80183 .46201 .80661 Mtetra
.985 .793 .563 r
.46201 .80661 .46536 .80183 .46807 .7907 .46474 .79543 Mtetra
.988 .802 .566 r
.46474 .79543 .46807 .7907 .47075 .78004 .46745 .7847 Mtetra
.995 .848 .579 r
.46745 .7847 .47075 .78004 .4734 .77107 .47012 .77568 Mtetra
.955 .927 .583 r
.47012 .77568 .4734 .77107 .47602 .76472 .47275 .7693 Mtetra
0 0 0 r
.47275 .7693 .47602 .76472 .4786 .76146 .47535 .76603 Mtetra
.23 0 .045 r
.47535 .76603 .4786 .76146 .48117 .76126 .47792 .76584 Mtetra
.483 .08 .201 r
.47792 .76584 .48117 .76126 .48374 .76357 .48049 .76817 Mtetra
.562 .167 .251 r
.48049 .76817 .48374 .76357 .48632 .76741 .48306 .77205 Mtetra
.572 .179 .257 r
.48306 .77205 .48632 .76741 .48892 .77153 .48566 .7762 Mtetra
.524 .125 .227 r
.48566 .7762 .48892 .77153 .49154 .77461 .48828 .77931 Mtetra
.363 0 .128 r
.48828 .77931 .49154 .77461 .49417 .7755 .49092 .78022 Mtetra
0 0 0 r
.49092 .78022 .49417 .7755 .49682 .77342 .49357 .77813 Mtetra
.843 .92 .526 r
.49357 .77813 .49682 .77342 .49946 .76815 .49623 .77285 Mtetra
.992 .882 .573 r
.49623 .77285 .49946 .76815 .50209 .76007 .49887 .76471 Mtetra
.995 .822 .56 r
.49887 .76471 .50209 .76007 .50469 .75003 .50149 .75462 Mtetra
.991 .801 .554 r
.50149 .75462 .50469 .75003 .50727 .73926 .5041 .74379 Mtetra
.993 .814 .558 r
.5041 .74379 .50727 .73926 .50984 .72906 .50669 .73354 Mtetra
.996 .865 .571 r
.50669 .73354 .50984 .72906 .51241 .72063 .50927 .72507 Mtetra
.915 .931 .56 r
.50927 .72507 .51241 .72063 .515 .71484 .51187 .71924 Mtetra
0 0 0 r
.51187 .71924 .515 .71484 .51762 .71209 .5145 .71649 Mtetra
.285 0 .067 r
.5145 .71649 .51762 .71209 .52028 .7123 .51717 .71672 Mtetra
.498 .09 .196 r
.51717 .71672 .52028 .7123 .523 .7149 .51988 .71934 Mtetra
.566 .164 .239 r
.51988 .71934 .523 .7149 .52575 .71889 .52264 .72336 Mtetra
.571 .169 .242 r
.52264 .72336 .52575 .71889 .52854 .72303 .52542 .72753 Mtetra
.517 .11 .208 r
.52542 .72753 .52854 .72303 .53132 .72602 .5282 .73056 Mtetra
.346 0 .105 r
.5282 .73056 .53132 .72602 .53407 .72676 .53096 .73132 Mtetra
0 0 0 r
.53096 .73132 .53407 .72676 .53677 .72455 .53367 .7291 Mtetra
.84 .915 .516 r
.53367 .7291 .53677 .72455 .5394 .71922 .53631 .72375 Mtetra
.991 .882 .56 r
.53631 .72375 .5394 .71922 .54196 .71119 .53889 .71567 Mtetra
.997 .827 .548 r
.53889 .71567 .54196 .71119 .54446 .70134 .54141 .70577 Mtetra
.995 .809 .543 r
.54141 .70577 .54446 .70134 .54693 .6909 .54389 .69527 Mtetra
.997 .826 .548 r
.54389 .69527 .54693 .6909 .5494 .68115 .54638 .68546 Mtetra
.991 .881 .561 r
.54638 .68546 .5494 .68115 .55191 .67323 .5489 .6775 Mtetra
.853 .921 .527 r
.5489 .6775 .55191 .67323 .55449 .66795 .5515 .6722 Mtetra
0 0 0 r
.5515 .6722 .55449 .66795 .55717 .66569 .55419 .66994 Mtetra
.33 0 .081 r
.55419 .66994 .55717 .66569 .55996 .6663 .55699 .67056 Mtetra
.511 .096 .189 r
.55699 .67056 .55996 .6663 .56285 .66918 .55987 .67346 Mtetra
.569 .159 .225 r
.55987 .67346 .56285 .66918 .56581 .67331 .56283 .67763 Mtetra
.56283 .67763 .56581 .67331 .56879 .67746 .56581 .68182 Mtetra
.509 .094 .189 r
.56581 .68182 .56879 .67746 .57175 .68036 .56877 .68475 Mtetra
.327 0 .082 r
.56877 .68475 .57175 .68036 .57462 .68097 .57165 .68537 Mtetra
0 0 0 r
.57165 .68537 .57462 .68097 .57738 .67862 .57442 .68302 Mtetra
.835 .909 .503 r
.57442 .68302 .57738 .67862 .58001 .67322 .57706 .67759 Mtetra
.988 .882 .545 r
.57706 .67759 .58001 .67322 .5825 .66522 .57957 .66955 Mtetra
.999 .832 .535 r
.57957 .66955 .5825 .66522 .58491 .65555 .58199 .65983 Mtetra
.998 .817 .531 r
.58199 .65983 .58491 .65555 .58727 .64542 .58437 .64964 Mtetra
.999 .838 .537 r
.58437 .64964 .58727 .64542 .58965 .63608 .58677 .64025 Mtetra
.98 .894 .547 r
.58677 .64025 .58965 .63608 .59212 .62864 .58926 .63277 Mtetra
.767 .891 .483 r
.58926 .63277 .59212 .62864 .59473 .62387 .59188 .62798 Mtetra
0 0 0 r
.59188 .62798 .59473 .62387 .5975 .62207 .59466 .62617 Mtetra
.366 0 .089 r
.59466 .62617 .5975 .62207 .60045 .62306 .59761 .62718 Mtetra
.521 .099 .18 r
.59761 .62718 .60045 .62306 .60354 .6262 .6007 .63036 Mtetra
.571 .153 .21 r
.6007 .63036 .60354 .6262 .60672 .63047 .60388 .63466 Mtetra
.565 .147 .207 r
.60388 .63466 .60672 .63047 .60993 .63463 .60709 .63886 Mtetra
.5 .076 .168 r
.60709 .63886 .60993 .63463 .61307 .63745 .61023 .64171 Mtetra
.308 0 .059 r
.61023 .64171 .61307 .63745 .61608 .63792 .61325 .64219 Mtetra
0 0 0 r
.61325 .64219 .61608 .63792 .6189 .63544 .61608 .6397 Mtetra
.826 .9 .487 r
.61608 .6397 .6189 .63544 .62152 .62996 .61871 .6342 Mtetra
.983 .882 .527 r
.61871 .6342 .62152 .62996 .62396 .62199 .62116 .62618 Mtetra
.999 .836 .519 r
.62116 .62618 .62396 .62199 .62627 .61247 .62349 .61661 Mtetra
1 .825 .516 r
.62349 .61661 .62627 .61247 .62853 .60262 .62578 .60671 Mtetra
.997 .85 .522 r
.62578 .60671 .62853 .60262 .63085 .59367 .62811 .59771 Mtetra
.957 .903 .527 r
.62811 .59771 .63085 .59367 .63331 .5867 .63058 .5907 Mtetra
.659 .84 .429 r
.63058 .5907 .63331 .5867 .63597 .5824 .63325 .58638 Mtetra
.024 0 0 r
.63325 .58638 .63597 .5824 .63887 .58104 .63616 .58503 Mtetra
.396 0 .092 r
.63616 .58503 .63887 .58104 .642 .58241 .6393 .58641 Mtetra
.53 .1 .168 r
.6393 .58641 .642 .58241 .64532 .58581 .64262 .58984 Mtetra
.572 .145 .193 r
.64262 .58984 .64532 .58581 .64876 .59021 .64606 .59429 Mtetra
.561 .134 .187 r
.64606 .59429 .64876 .59021 .65221 .59439 .64951 .5985 Mtetra
.49 .058 .146 r
.64951 .5985 .65221 .59439 .65556 .59713 .65286 .60126 Mtetra
.288 0 .036 r
.65286 .60126 .65556 .59713 .65871 .59745 .65602 .6016 Mtetra
0 0 0 r
.65602 .6016 .65871 .59745 .6616 .59483 .65892 .59897 Mtetra
.815 .89 .468 r
.65892 .59897 .6616 .59483 .66421 .58927 .66155 .59339 Mtetra
.976 .879 .507 r
.66155 .59339 .66421 .58927 .66659 .58131 .66394 .58539 Mtetra
.997 .84 .5 r
.66394 .58539 .66659 .58131 .66881 .57194 .66618 .57596 Mtetra
.999 .832 .499 r
.66618 .57596 .66881 .57194 .671 .56235 .66838 .56632 Mtetra
.991 .859 .505 r
.66838 .56632 .671 .56235 .67327 .55377 .67067 .5577 Mtetra
.921 .903 .502 r
.67067 .5577 .67327 .55377 .67573 .54723 .67315 .55112 Mtetra
0 0 0 r
.67315 .55112 .67573 .54723 .67847 .54339 .6759 .54727 Mtetra
.106 0 0 r
.6759 .54727 .67847 .54339 .68153 .54247 .67897 .54635 Mtetra
.42 0 .09 r
.67897 .54635 .68153 .54247 .68489 .5442 .68233 .5481 Mtetra
.536 .098 .155 r
.68233 .5481 .68489 .5442 .68849 .54786 .68593 .55179 Mtetra
.571 .136 .175 r
.68593 .55179 .68849 .54786 .69221 .55239 .68966 .55636 Mtetra
.556 .119 .166 r
.68966 .55636 .69221 .55239 .69593 .55658 .69338 .56059 Mtetra
.478 .038 .123 r
.69338 .56059 .69593 .55658 .6995 .55924 .69695 .56327 Mtetra
.268 0 .014 r
.69695 .56327 .6995 .55924 .7028 .55943 .70026 .56347 Mtetra
0 0 0 r
.70026 .56347 .7028 .55943 .70576 .55666 .70323 .5607 Mtetra
.8 .877 .446 r
.70323 .5607 .70576 .55666 .70837 .55101 .70586 .55502 Mtetra
.965 .875 .483 r
.70586 .55502 .70837 .55101 .71069 .54306 .70819 .54702 Mtetra
.992 .842 .479 r
.70819 .54702 .71069 .54306 .71284 .5338 .71035 .53772 Mtetra
.994 .838 .478 r
.71035 .53772 .71284 .5338 .71495 .52446 .71248 .52833 Mtetra
.977 .866 .483 r
.71248 .52833 .71495 .52446 .71719 .51624 .71474 .52006 Mtetra
.866 .893 .469 r
.71474 .52006 .71719 .51624 .71969 .51012 .71725 .51391 Mtetra
0 0 0 r
.71725 .51391 .71969 .51012 .72255 .50672 .72013 .5105 Mtetra
.173 0 0 r
.72013 .5105 .72255 .50672 .72581 .50622 .72339 .51001 Mtetra
.439 0 .085 r
.72339 .51001 .72581 .50622 .72943 .5083 .72702 .51211 Mtetra
.541 .094 .138 r
.72702 .51211 .72943 .5083 .73334 .51222 .73093 .51606 Mtetra
.57 .125 .154 r
.73093 .51606 .73334 .51222 .73739 .51689 .73499 .52077 Mtetra
.55 .103 .143 r
.73499 .52077 .73739 .51689 .7414 .5211 .73901 .52502 Mtetra
.466 .018 .1 r
.73901 .52502 .7414 .5211 .74521 .52367 .74282 .52762 Mtetra
.249 0 0 r
.74282 .52762 .74521 .52367 .74868 .52372 .7463 .52768 Mtetra
0 0 0 r
.7463 .52768 .74868 .52372 .75172 .52081 .74935 .52476 Mtetra
.78 .861 .42 r
.74935 .52476 .75172 .52081 .75433 .51506 .75198 .51898 Mtetra
.951 .868 .455 r
.75198 .51898 .75433 .51506 .7566 .50709 .75426 .51097 Mtetra
.983 .841 .453 r
.75426 .51097 .7566 .50709 .75867 .49795 .75635 .50177 Mtetra
.75635 .50177 .75867 .49795 .76073 .48883 .75842 .49261 Mtetra
.953 .868 .456 r
.75842 .49261 .76073 .48883 .76296 .48094 .76066 .48468 Mtetra
.793 .867 .428 r
.76066 .48468 .76296 .48094 .76553 .47523 .76324 .47894 Mtetra
0 0 0 r
.76324 .47894 .76553 .47523 .76854 .47227 .76627 .47597 Mtetra
.228 0 0 r
.76627 .47597 .76854 .47227 .77204 .47219 .76978 .4759 Mtetra
.455 0 .075 r
.76978 .4759 .77204 .47219 .77598 .47462 .77372 .47836 Mtetra
.543 .087 .12 r
.77372 .47836 .77598 .47462 .78024 .47879 .77799 .48256 Mtetra
.567 .112 .132 r
.77799 .48256 .78024 .47879 .78465 .4836 .78241 .48742 Mtetra
.542 .086 .12 r
.78241 .48742 .78465 .4836 .789 .48783 .78677 .49168 Mtetra
.453 0 .076 r
.78677 .49168 .789 .48783 .79308 .49033 .79085 .4942 Mtetra
.229 0 0 r
.79085 .4942 .79308 .49033 .79672 .49023 .79451 .49412 Mtetra
0 0 0 r
.79451 .49412 .79672 .49023 .79985 .48717 .79765 .49105 Mtetra
.757 .842 .39 r
.79765 .49105 .79985 .48717 .80247 .48131 .80028 .48516 Mtetra
.931 .858 .423 r
.80028 .48516 .80247 .48131 .80468 .47332 .80251 .47712 Mtetra
.968 .837 .423 r
.80251 .47712 .80468 .47332 .80669 .46427 .80453 .46802 Mtetra
.965 .839 .423 r
.80453 .46802 .80669 .46427 .8087 .45537 .80655 .45907 Mtetra
.917 .862 .423 r
.80655 .45907 .8087 .45537 .81094 .4478 .80881 .45146 Mtetra
.7 .826 .381 r
.80881 .45146 .81094 .4478 .81361 .44248 .81149 .44612 Mtetra
0 0 0 r
.81149 .44612 .81361 .44248 .81682 .43995 .81472 .44358 Mtetra
.272 0 0 r
.81472 .44358 .81682 .43995 .82061 .44028 .81852 .44392 Mtetra
.467 .001 .063 r
.81852 .44392 .82061 .44028 .82492 .44307 .82283 .44674 Mtetra
.545 .079 .099 r
.82283 .44674 .82492 .44307 .82959 .4475 .82752 .45121 Mtetra
.562 .097 .108 r
.82752 .45121 .82959 .4475 .83442 .45245 .83235 .45621 Mtetra
.534 .068 .094 r
.83235 .45621 .83442 .45245 .83913 .45671 .83708 .4605 Mtetra
.439 0 .051 r
.83708 .4605 .83913 .45671 .84351 .45913 .84146 .46294 Mtetra
.21 0 0 r
.84146 .46294 .84351 .45913 .84735 .45889 .84532 .46272 Mtetra
0 0 0 r
.84532 .46272 .84735 .45889 .85057 .45567 .84855 .45949 Mtetra
.728 .819 .357 r
.84855 .45949 .85057 .45567 .85319 .44969 .85119 .45347 Mtetra
.906 .843 .387 r
.85119 .45347 .85319 .44969 .85536 .44166 .85337 .4454 Mtetra
.946 .828 .387 r
.85337 .4454 .85536 .44166 .8573 .43269 .85532 .43638 Mtetra
.938 .833 .388 r
.85532 .43638 .8573 .43269 .85928 .42399 .85732 .42763 Mtetra
.866 .846 .384 r
.85732 .42763 .85928 .42399 .86157 .41673 .85962 .42033 Mtetra
0 0 0 r
.85962 .42033 .86157 .41673 .86438 .41179 .86244 .41537 Mtetra
.86244 .41537 .86438 .41179 .86784 .40968 .86592 .41326 Mtetra
.308 0 0 r
.86592 .41326 .86784 .40968 .87198 .41042 .87007 .41402 Mtetra
.477 .001 .047 r
.87007 .41402 .87198 .41042 .87672 .41357 .87482 .41719 Mtetra
.544 .068 .076 r
.87482 .41719 .87672 .41357 .88186 .41827 .87997 .42194 Mtetra
.557 .081 .082 r
.87997 .42194 .88186 .41827 .88715 .42338 .88528 .42709 Mtetra
.524 .048 .068 r
.88528 .42709 .88715 .42338 .89229 .42767 .89043 .43142 Mtetra
.425 0 .027 r
.89043 .43142 .89229 .42767 .89699 .43001 .89515 .43379 Mtetra
.193 0 0 r
.89515 .43379 .89699 .43001 .90105 .42963 .89922 .43342 Mtetra
.831 .916 .52 r
.45047 .83541 .4539 .83034 .45656 .82511 .45315 .83015 Mtetra
.992 .883 .58 r
.45315 .83015 .45656 .82511 .45928 .81692 .45588 .82192 Mtetra
.993 .82 .568 r
.45588 .82192 .45928 .81692 .46201 .80661 .45864 .81156 Mtetra
.987 .796 .561 r
.45864 .81156 .46201 .80661 .46474 .79543 .46139 .8003 Mtetra
.989 .805 .564 r
.46139 .8003 .46474 .79543 .46745 .7847 .46412 .78952 Mtetra
.996 .851 .576 r
.46412 .78952 .46745 .7847 .47012 .77568 .46681 .78045 Mtetra
.949 .927 .574 r
.46681 .78045 .47012 .77568 .47275 .7693 .46946 .77404 Mtetra
0 0 0 r
.46946 .77404 .47275 .7693 .47535 .76603 .47206 .77076 Mtetra
.232 0 .052 r
.47206 .77076 .47535 .76603 .47792 .76584 .47464 .77058 Mtetra
.481 .081 .204 r
.47464 .77058 .47792 .76584 .48049 .76817 .47721 .77293 Mtetra
.56 .167 .253 r
.47721 .77293 .48049 .76817 .48306 .77205 .47978 .77684 Mtetra
.57 .178 .26 r
.47978 .77684 .48306 .77205 .48566 .7762 .48237 .78104 Mtetra
.522 .125 .23 r
.48237 .78104 .48566 .7762 .48828 .77931 .48499 .78418 Mtetra
.363 0 .133 r
.48499 .78418 .48828 .77931 .49092 .78022 .48763 .78509 Mtetra
0 0 0 r
.48763 .78509 .49092 .78022 .49357 .77813 .49029 .78301 Mtetra
.83 .913 .512 r
.49029 .78301 .49357 .77813 .49623 .77285 .49296 .77769 Mtetra
.991 .884 .568 r
.49296 .77769 .49623 .77285 .49887 .76471 .49562 .76952 Mtetra
.996 .825 .557 r
.49562 .76952 .49887 .76471 .50149 .75462 .49827 .75937 Mtetra
.992 .804 .551 r
.49827 .75937 .50149 .75462 .5041 .74379 .50089 .74848 Mtetra
.995 .817 .555 r
.50089 .74848 .5041 .74379 .50669 .73354 .5035 .73818 Mtetra
.995 .867 .567 r
.5035 .73818 .50669 .73354 .50927 .72507 .50611 .72966 Mtetra
.906 .928 .549 r
.50611 .72966 .50927 .72507 .51187 .71924 .50872 .7238 Mtetra
0 0 0 r
.50872 .7238 .51187 .71924 .5145 .71649 .51136 .72104 Mtetra
.286 0 .074 r
.51136 .72104 .5145 .71649 .51717 .71672 .51403 .72128 Mtetra
.496 .09 .2 r
.51403 .72128 .51717 .71672 .51988 .71934 .51675 .72393 Mtetra
.564 .163 .241 r
.51675 .72393 .51988 .71934 .52264 .72336 .5195 .72798 Mtetra
.568 .169 .244 r
.5195 .72798 .52264 .72336 .52542 .72753 .52228 .73219 Mtetra
.515 .11 .211 r
.52228 .73219 .52542 .72753 .5282 .73056 .52506 .73525 Mtetra
.345 0 .111 r
.52506 .73525 .5282 .73056 .53096 .73132 .52782 .73602 Mtetra
0 0 0 r
.52782 .73602 .53096 .73132 .53367 .7291 .53054 .7338 Mtetra
.827 .908 .502 r
.53054 .7338 .53367 .7291 .53631 .72375 .53319 .72842 Mtetra
.989 .884 .555 r
.53319 .72842 .53631 .72375 .53889 .71567 .53579 .7203 Mtetra
.998 .83 .545 r
.53579 .7203 .53889 .71567 .54141 .70577 .53833 .71035 Mtetra
.996 .812 .54 r
.53833 .71035 .54141 .70577 .54389 .69527 .54083 .69979 Mtetra
.998 .829 .545 r
.54083 .69979 .54389 .69527 .54638 .68546 .54334 .68993 Mtetra
.99 .883 .556 r
.54334 .68993 .54638 .68546 .5489 .6775 .54588 .68192 Mtetra
.841 .914 .514 r
.54588 .68192 .5489 .6775 .5515 .6722 .54849 .6766 Mtetra
0 0 0 r
.54849 .6766 .5515 .6722 .55419 .66994 .55119 .67433 Mtetra
.33 0 .087 r
.55119 .67433 .55419 .66994 .55699 .67056 .55399 .67497 Mtetra
.509 .096 .193 r
.55399 .67497 .55699 .67056 .55987 .67346 .55688 .6779 Mtetra
.567 .159 .228 r
.55688 .6779 .55987 .67346 .56283 .67763 .55983 .6821 Mtetra
.566 .158 .227 r
.55983 .6821 .56283 .67763 .56581 .68182 .56281 .68632 Mtetra
.507 .094 .192 r
.56281 .68632 .56581 .68182 .56877 .68475 .56577 .68929 Mtetra
.327 0 .088 r
.56577 .68929 .56877 .68475 .57165 .68537 .56866 .68992 Mtetra
0 0 0 r
.56866 .68992 .57165 .68537 .57442 .68302 .57143 .68757 Mtetra
.822 .901 .489 r
.57143 .68757 .57442 .68302 .57706 .67759 .57408 .68211 Mtetra
.985 .884 .539 r
.57408 .68211 .57706 .67759 .57957 .66955 .57661 .67403 Mtetra
.999 .835 .531 r
.57661 .67403 .57957 .66955 .58199 .65983 .57905 .66425 Mtetra
.999 .82 .527 r
.57905 .66425 .58199 .65983 .58437 .64964 .58145 .654 Mtetra
.999 .841 .533 r
.58145 .654 .58437 .64964 .58677 .64025 .58387 .64456 Mtetra
.976 .895 .54 r
.58387 .64456 .58677 .64025 .58926 .63277 .58637 .63705 Mtetra
.752 .881 .467 r
.58637 .63705 .58926 .63277 .59188 .62798 .58901 .63223 Mtetra
0 0 0 r
.58901 .63223 .59188 .62798 .59466 .62617 .5918 .63043 Mtetra
.366 0 .095 r
.5918 .63043 .59466 .62617 .59761 .62718 .59475 .63145 Mtetra
.519 .099 .184 r
.59475 .63145 .59761 .62718 .6007 .63036 .59784 .63465 Mtetra
.569 .153 .213 r
.59784 .63465 .6007 .63036 .60388 .63466 .60103 .639 Mtetra
.563 .146 .209 r
.60103 .639 .60388 .63466 .60709 .63886 .60423 .64323 Mtetra
.498 .077 .172 r
.60423 .64323 .60709 .63886 .61023 .64171 .60738 .64611 Mtetra
.309 0 .066 r
.60738 .64611 .61023 .64171 .61325 .64219 .6104 .6466 Mtetra
0 0 0 r
.6104 .6466 .61325 .64219 .61608 .6397 .61324 .64411 Mtetra
.813 .892 .473 r
.61324 .64411 .61608 .6397 .61871 .6342 .61588 .63858 Mtetra
.98 .882 .52 r
.61588 .63858 .61871 .6342 .62116 .62618 .61835 .63052 Mtetra
.999 .839 .515 r
.61835 .63052 .62116 .62618 .62349 .61661 .6207 .6209 Mtetra
1 .828 .512 r
.6207 .6209 .62349 .61661 .62578 .60671 .623 .61094 Mtetra
.996 .852 .518 r
.623 .61094 .62578 .60671 .62811 .59771 .62535 .60189 Mtetra
.951 .902 .519 r
.62535 .60189 .62811 .59771 .63058 .5907 .62784 .59484 Mtetra
.641 .826 .412 r
.62784 .59484 .63058 .5907 .63325 .58638 .63052 .59051 Mtetra
.031 0 0 r
.63052 .59051 .63325 .58638 .63616 .58503 .63344 .58916 Mtetra
.395 0 .098 r
.63344 .58916 .63616 .58503 .6393 .58641 .63658 .59056 Mtetra
.527 .1 .172 r
.63658 .59056 .6393 .58641 .64262 .58984 .63991 .59402 Mtetra
.569 .145 .196 r
.63991 .59402 .64262 .58984 .64606 .59429 .64335 .5985 Mtetra
.559 .133 .19 r
.64335 .5985 .64606 .59429 .64951 .5985 .6468 .60275 Mtetra
.488 .058 .15 r
.6468 .60275 .64951 .5985 .65286 .60126 .65016 .60555 Mtetra
.289 0 .044 r
.65016 .60555 .65286 .60126 .65602 .6016 .65332 .6059 Mtetra
0 0 0 r
.65332 .6059 .65602 .6016 .65892 .59897 .65623 .60326 Mtetra
.801 .881 .454 r
.65623 .60326 .65892 .59897 .66155 .59339 .65887 .59765 Mtetra
.972 .879 .499 r
.65887 .59765 .66155 .59339 .66394 .58539 .66128 .5896 Mtetra
.996 .842 .495 r
.66128 .5896 .66394 .58539 .66618 .57596 .66354 .58012 Mtetra
.998 .834 .494 r
.66354 .58012 .66618 .57596 .66838 .56632 .66576 .57043 Mtetra
.988 .861 .499 r
.66576 .57043 .66838 .56632 .67067 .5577 .66806 .56176 Mtetra
.912 .9 .491 r
.66806 .56176 .67067 .5577 .67315 .55112 .67055 .55516 Mtetra
0 0 0 r
.67055 .55516 .67315 .55112 .6759 .54727 .67331 .55129 Mtetra
.111 0 0 r
.67331 .55129 .6759 .54727 .67897 .54635 .67639 .55037 Mtetra
.419 0 .096 r
.67639 .55037 .67897 .54635 .68233 .5481 .67976 .55214 Mtetra
.534 .098 .158 r
.67976 .55214 .68233 .5481 .68593 .55179 .68336 .55586 Mtetra
.569 .135 .178 r
.68336 .55586 .68593 .55179 .68966 .55636 .68709 .56048 Mtetra
.554 .119 .169 r
.68709 .56048 .68966 .55636 .69338 .56059 .69082 .56474 Mtetra
.477 .039 .128 r
.69082 .56474 .69338 .56059 .69695 .56327 .69439 .56745 Mtetra
.27 0 .022 r
.69439 .56745 .69695 .56327 .70026 .56347 .69771 .56767 Mtetra
0 0 0 r
.69771 .56767 .70026 .56347 .70323 .5607 .70069 .56489 Mtetra
.785 .868 .431 r
.70069 .56489 .70323 .5607 .70586 .55502 .70333 .55918 Mtetra
.96 .874 .475 r
.70333 .55918 .70586 .55502 .70819 .54702 .70569 .55114 Mtetra
.99 .843 .473 r
.70569 .55114 .70819 .54702 .71035 .53772 .70786 .54178 Mtetra
.991 .839 .472 r
.70786 .54178 .71035 .53772 .71248 .52833 .71001 .53233 Mtetra
.972 .866 .476 r
.71001 .53233 .71248 .52833 .71474 .52006 .71228 .52402 Mtetra
.854 .886 .456 r
.71228 .52402 .71474 .52006 .71725 .51391 .71481 .51784 Mtetra
0 0 0 r
.71481 .51784 .71725 .51391 .72013 .5105 .71769 .51442 Mtetra
.177 0 0 r
.71769 .51442 .72013 .5105 .72339 .51001 .72096 .51394 Mtetra
.438 0 .09 r
.72096 .51394 .72339 .51001 .72702 .51211 .7246 .51606 Mtetra
.538 .094 .142 r
.7246 .51606 .72702 .51211 .73093 .51606 .72852 .52005 Mtetra
.567 .125 .158 r
.72852 .52005 .73093 .51606 .73499 .52077 .73258 .5248 Mtetra
.547 .104 .147 r
.73258 .5248 .73499 .52077 .73901 .52502 .7366 .52908 Mtetra
.465 .019 .105 r
.7366 .52908 .73901 .52502 .74282 .52762 .74043 .53171 Mtetra
.25 0 .002 r
.74043 .53171 .74282 .52762 .7463 .52768 .74391 .53178 Mtetra
0 0 0 r
.74391 .53178 .7463 .52768 .74935 .52476 .74697 .52886 Mtetra
.765 .851 .405 r
.74697 .52886 .74935 .52476 .75198 .51898 .74962 .52304 Mtetra
.944 .866 .446 r
.74962 .52304 .75198 .51898 .75426 .51097 .75191 .51499 Mtetra
.979 .841 .446 r
.75191 .51499 .75426 .51097 .75635 .50177 .75401 .50574 Mtetra
.98 .841 .446 r
.75401 .50574 .75635 .50177 .75842 .49261 .7561 .49653 Mtetra
.946 .866 .447 r
.7561 .49653 .75842 .49261 .76066 .48468 .75836 .48856 Mtetra
.778 .858 .413 r
.75836 .48856 .76066 .48468 .76324 .47894 .76096 .48279 Mtetra
0 0 0 r
.76096 .48279 .76324 .47894 .76627 .47597 .76399 .47981 Mtetra
.23 0 0 r
.76399 .47981 .76627 .47597 .76978 .4759 .76751 .47974 Mtetra
.454 0 .081 r
.76751 .47974 .76978 .4759 .77372 .47836 .77147 .48223 Mtetra
.541 .088 .124 r
.77147 .48223 .77372 .47836 .77799 .48256 .77574 .48647 Mtetra
.565 .112 .136 r
.77574 .48647 .77799 .48256 .78241 .48742 .78017 .49137 Mtetra
.54 .087 .124 r
.78017 .49137 .78241 .48742 .78677 .49168 .78453 .49568 Mtetra
.452 0 .082 r
.78453 .49568 .78677 .49168 .79085 .4942 .78863 .49822 Mtetra
.231 0 0 r
.78863 .49822 .79085 .4942 .79451 .49412 .79229 .49815 Mtetra
0 0 0 r
.79229 .49815 .79451 .49412 .79765 .49105 .79544 .49507 Mtetra
.741 .831 .375 r
.79544 .49507 .79765 .49105 .80028 .48516 .79809 .48915 Mtetra
.923 .854 .414 r
.79809 .48915 .80028 .48516 .80251 .47712 .80034 .48107 Mtetra
.963 .836 .415 r
.80034 .48107 .80251 .47712 .80453 .46802 .80237 .47191 Mtetra
.96 .838 .415 r
.80237 .47191 .80453 .46802 .80655 .45907 .80441 .46292 Mtetra
.908 .858 .413 r
.80441 .46292 .80655 .45907 .80881 .45146 .80668 .45527 Mtetra
.683 .813 .364 r
.80668 .45527 .80881 .45146 .81149 .44612 .80938 .4499 Mtetra
0 0 0 r
.80938 .4499 .81149 .44612 .81472 .44358 .81261 .44735 Mtetra
.273 0 0 r
.81261 .44735 .81472 .44358 .81852 .44392 .81642 .4477 Mtetra
.466 .003 .068 r
.81642 .4477 .81852 .44392 .82283 .44674 .82075 .45055 Mtetra
.543 .079 .104 r
.82075 .45055 .82283 .44674 .82752 .45121 .82544 .45506 Mtetra
.56 .098 .112 r
.82544 .45506 .82752 .45121 .83235 .45621 .83029 .4601 Mtetra
.532 .068 .099 r
.83029 .4601 .83235 .45621 .83708 .4605 .83503 .46444 Mtetra
.438 0 .058 r
.83503 .46444 .83708 .4605 .84146 .46294 .83942 .46691 Mtetra
.213 0 0 r
.83942 .46691 .84146 .46294 .84532 .46272 .84329 .46669 Mtetra
0 0 0 r
.84329 .46669 .84532 .46272 .84855 .45949 .84653 .46345 Mtetra
.711 .807 .341 r
.84653 .46345 .84855 .45949 .85119 .45347 .84919 .4574 Mtetra
.896 .838 .376 r
.84919 .4574 .85119 .45347 .85337 .4454 .85138 .44929 Mtetra
.939 .826 .378 r
.85138 .44929 .85337 .4454 .85532 .43638 .85335 .44021 Mtetra
.931 .83 .378 r
.85335 .44021 .85532 .43638 .85732 .42763 .85536 .43141 Mtetra
.854 .84 .372 r
.85536 .43141 .85732 .42763 .85962 .42033 .85768 .42407 Mtetra
0 0 0 r
.85768 .42407 .85962 .42033 .86244 .41537 .86051 .41909 Mtetra
.86051 .41909 .86244 .41537 .86592 .41326 .864 .41698 Mtetra
.309 0 0 r
.864 .41698 .86592 .41326 .87007 .41402 .86816 .41775 Mtetra
.475 .003 .053 r
.86816 .41775 .87007 .41402 .87482 .41719 .87292 .42096 Mtetra
.542 .069 .081 r
.87292 .42096 .87482 .41719 .87997 .42194 .87809 .42574 Mtetra
.555 .082 .086 r
.87809 .42574 .87997 .42194 .88528 .42709 .88341 .43095 Mtetra
.522 .049 .073 r
.88341 .43095 .88528 .42709 .89043 .43142 .88858 .43531 Mtetra
.424 0 .033 r
.88858 .43531 .89043 .43142 .89515 .43379 .89331 .43771 Mtetra
.196 0 0 r
.89331 .43771 .89515 .43379 .89922 .43342 .89739 .43735 Mtetra
.93 .958 .642 r
.44705 .83926 .45047 .83541 .45315 .83015 .44974 .83399 Mtetra
.987 .848 .616 r
.44974 .83399 .45315 .83015 .45588 .82192 .45249 .82571 Mtetra
.973 .784 .587 r
.45249 .82571 .45588 .82192 .45864 .81156 .45526 .81531 Mtetra
.966 .761 .576 r
.45526 .81531 .45864 .81156 .46139 .8003 .45804 .804 Mtetra
.969 .77 .58 r
.45804 .804 .46139 .8003 .46412 .78952 .46079 .79317 Mtetra
.981 .814 .602 r
.46079 .79317 .46412 .78952 .46681 .78045 .4635 .78406 Mtetra
.981 .912 .642 r
.4635 .78406 .46681 .78045 .46946 .77404 .46615 .77762 Mtetra
.649 .889 .544 r
.46615 .77762 .46946 .77404 .47206 .77076 .46877 .77433 Mtetra
.205 0 0 r
.46877 .77433 .47206 .77076 .47464 .77058 .47135 .77415 Mtetra
.502 .077 .164 r
.47135 .77415 .47464 .77058 .47721 .77293 .47391 .77653 Mtetra
.586 .174 .227 r
.47391 .77653 .47721 .77293 .47978 .77684 .47648 .78047 Mtetra
.596 .186 .235 r
.47648 .78047 .47978 .77684 .48237 .78104 .47907 .78469 Mtetra
.547 .127 .198 r
.47907 .78469 .48237 .78104 .48499 .78418 .48168 .78786 Mtetra
.367 0 .07 r
.48168 .78786 .48499 .78418 .48763 .78509 .48433 .78879 Mtetra
0 0 0 r
.48433 .78879 .48763 .78509 .49029 .78301 .48699 .7867 Mtetra
.931 .955 .635 r
.48699 .7867 .49029 .78301 .49296 .77769 .48967 .78136 Mtetra
.99 .852 .608 r
.48967 .78136 .49296 .77769 .49562 .76952 .49235 .77315 Mtetra
.979 .789 .58 r
.49235 .77315 .49562 .76952 .49827 .75937 .49501 .76296 Mtetra
.973 .769 .57 r
.49501 .76296 .49827 .75937 .50089 .74848 .49766 .75202 Mtetra
.976 .782 .576 r
.49766 .75202 .50089 .74848 .5035 .73818 .50029 .74166 Mtetra
.988 .833 .601 r
.50029 .74166 .5035 .73818 .50611 .72966 .50291 .7331 Mtetra
.966 .935 .641 r
.50291 .7331 .50611 .72966 .50872 .7238 .50554 .72723 Mtetra
0 0 0 r
.50554 .72723 .50872 .7238 .51136 .72104 .50818 .72446 Mtetra
.273 0 0 r
.50818 .72446 .51136 .72104 .51403 .72128 .51086 .7247 Mtetra
.519 .087 .16 r
.51086 .7247 .51403 .72128 .51675 .72393 .51357 .72737 Mtetra
.59 .17 .213 r
.51357 .72737 .51675 .72393 .5195 .72798 .51632 .73146 Mtetra
.595 .176 .217 r
.51632 .73146 .5195 .72798 .52228 .73219 .51909 .7357 Mtetra
.539 .11 .176 r
.51909 .7357 .52228 .73219 .52506 .73525 .52187 .73878 Mtetra
.346 0 .04 r
.52187 .73878 .52506 .73525 .52782 .73602 .52463 .73956 Mtetra
0 0 0 r
.52463 .73956 .52782 .73602 .53054 .7338 .52736 .73734 Mtetra
.93 .953 .627 r
.52736 .73734 .53054 .7338 .53319 .72842 .53003 .73194 Mtetra
.992 .855 .599 r
.53003 .73194 .53319 .72842 .53579 .7203 .53264 .72378 Mtetra
.984 .795 .572 r
.53264 .72378 .53579 .7203 .53833 .71035 .53519 .71378 Mtetra
.979 .778 .563 r
.53519 .71378 .53833 .71035 .54083 .69979 .53772 .70317 Mtetra
.984 .795 .571 r
.53772 .70317 .54083 .69979 .54334 .68993 .54025 .69327 Mtetra
.992 .853 .599 r
.54025 .69327 .54334 .68993 .54588 .68192 .5428 .68523 Mtetra
.937 .952 .633 r
.5428 .68523 .54588 .68192 .54849 .6766 .54542 .67989 Mtetra
0 0 0 r
.54542 .67989 .54849 .6766 .55119 .67433 .54813 .67761 Mtetra
.327 0 .01 r
.54813 .67761 .55119 .67433 .55399 .67497 .55093 .67826 Mtetra
.532 .094 .153 r
.55093 .67826 .55399 .67497 .55688 .6779 .55382 .68121 Mtetra
.593 .165 .198 r
.55382 .68121 .55688 .6779 .55983 .6821 .55677 .68544 Mtetra
.592 .164 .198 r
.55677 .68544 .55983 .6821 .56281 .68632 .55975 .6897 Mtetra
.53 .092 .152 r
.55975 .6897 .56281 .68632 .56577 .68929 .5627 .69268 Mtetra
.323 0 .011 r
.5627 .69268 .56577 .68929 .56866 .68992 .56559 .69333 Mtetra
0 0 0 r
.56559 .69333 .56866 .68992 .57143 .68757 .56838 .69097 Mtetra
.928 .95 .616 r
.56838 .69097 .57143 .68757 .57408 .68211 .57104 .68549 Mtetra
.994 .858 .589 r
.57104 .68549 .57408 .68211 .57661 .67403 .57358 .67737 Mtetra
.989 .802 .562 r
.57358 .67737 .57661 .67403 .57905 .66425 .57604 .66755 Mtetra
.986 .787 .555 r
.57604 .66755 .57905 .66425 .58145 .654 .57846 .65725 Mtetra
.99 .808 .565 r
.57846 .65725 .58145 .654 .58387 .64456 .5809 .64777 Mtetra
.993 .873 .597 r
.5809 .64777 .58387 .64456 .58637 .63705 .58341 .64022 Mtetra
.886 .957 .617 r
.58341 .64022 .58637 .63705 .58901 .63223 .58605 .63539 Mtetra
0 0 0 r
.58605 .63539 .58901 .63223 .5918 .63043 .58885 .63358 Mtetra
.369 0 .023 r
.58885 .63358 .5918 .63043 .59475 .63145 .59181 .63462 Mtetra
.543 .098 .143 r
.59181 .63462 .59475 .63145 .59784 .63465 .5949 .63784 Mtetra
.594 .158 .181 r
.5949 .63784 .59784 .63465 .60103 .639 .59808 .64222 Mtetra
.589 .151 .176 r
.59808 .64222 .60103 .639 .60423 .64323 .60128 .64648 Mtetra
.519 .072 .127 r
.60128 .64648 .60423 .64323 .60738 .64611 .60443 .64938 Mtetra
.3 0 0 r
.60443 .64938 .60738 .64611 .6104 .6466 .60745 .64989 Mtetra
0 0 0 r
.60745 .64989 .6104 .6466 .61324 .64411 .6103 .64739 Mtetra
.925 .947 .604 r
.6103 .64739 .61324 .64411 .61588 .63858 .61296 .64183 Mtetra
.996 .862 .577 r
.61296 .64183 .61588 .63858 .61835 .63052 .61544 .63374 Mtetra
.993 .809 .551 r
.61544 .63374 .61835 .63052 .6207 .6209 .61781 .62407 Mtetra
.991 .797 .545 r
.61781 .62407 .6207 .6209 .623 .61094 .62013 .61407 Mtetra
.995 .823 .558 r
.62013 .61407 .623 .61094 .62535 .60189 .62249 .60498 Mtetra
.989 .894 .592 r
.62249 .60498 .62535 .60189 .62784 .59484 .62499 .5979 Mtetra
.809 .944 .589 r
.62499 .5979 .62784 .59484 .63052 .59051 .62769 .59355 Mtetra
0 0 0 r
.62769 .59355 .63052 .59051 .63344 .58916 .63061 .5922 Mtetra
.403 0 .029 r
.63061 .5922 .63344 .58916 .63658 .59056 .63375 .59362 Mtetra
.551 .098 .13 r
.63375 .59362 .63658 .59056 .63991 .59402 .63708 .59711 Mtetra
.595 .149 .162 r
.63708 .59711 .63991 .59402 .64335 .5985 .64052 .60162 Mtetra
.584 .136 .154 r
.64052 .60162 .64335 .5985 .6468 .60275 .64397 .6059 Mtetra
.508 .05 .101 r
.64397 .6059 .6468 .60275 .65016 .60555 .64733 .60871 Mtetra
.275 0 0 r
.64733 .60871 .65016 .60555 .65332 .6059 .65049 .60907 Mtetra
0 0 0 r
.65049 .60907 .65332 .6059 .65623 .60326 .65341 .60643 Mtetra
.92 .942 .589 r
.65341 .60643 .65623 .60326 .65887 .59765 .65606 .60079 Mtetra
.996 .865 .562 r
.65606 .60079 .65887 .59765 .66128 .5896 .65849 .59271 Mtetra
.997 .815 .538 r
.65849 .59271 .66128 .5896 .66354 .58012 .66076 .58319 Mtetra
.996 .807 .534 r
.66076 .58319 .66354 .58012 .66576 .57043 .663 .57345 Mtetra
.998 .838 .55 r
.663 .57345 .66576 .57043 .66806 .56176 .66532 .56474 Mtetra
.976 .912 .585 r
.66532 .56474 .66806 .56176 .67055 .55516 .66782 .55811 Mtetra
.704 .906 .548 r
.66782 .55811 .67055 .55516 .67331 .55129 .6706 .55423 Mtetra
.045 0 0 r
.6706 .55423 .67331 .55129 .67639 .55037 .67368 .55331 Mtetra
.43 0 .029 r
.67368 .55331 .67639 .55037 .67976 .55214 .67705 .5551 Mtetra
.557 .096 .115 r
.67705 .5551 .67976 .55214 .68336 .55586 .68065 .55885 Mtetra
.594 .138 .14 r
.68065 .55885 .68336 .55586 .68709 .56048 .68438 .5635 Mtetra
.578 .12 .129 r
.68438 .5635 .68709 .56048 .69082 .56474 .68811 .56779 Mtetra
.495 .028 .074 r
.68811 .56779 .69082 .56474 .69439 .56745 .69169 .57052 Mtetra
.251 0 0 r
.69169 .57052 .69439 .56745 .69771 .56767 .69501 .57074 Mtetra
0 0 0 r
.69501 .57074 .69771 .56767 .70069 .56489 .698 .56796 Mtetra
.912 .937 .571 r
.698 .56796 .70069 .56489 .70333 .55918 .70065 .56222 Mtetra
.995 .867 .546 r
.70065 .56222 .70333 .55918 .70569 .55114 .70302 .55415 Mtetra
.999 .822 .523 r
.70302 .55415 .70569 .55114 .70786 .54178 .70521 .54475 Mtetra
.999 .817 .521 r
.70521 .54475 .70786 .54178 .71001 .53233 .70738 .53526 Mtetra
.998 .853 .54 r
.70738 .53526 .71001 .53233 .71228 .52402 .70966 .52691 Mtetra
.95 .926 .573 r
.70966 .52691 .71228 .52402 .71481 .51784 .7122 .5207 Mtetra
.577 .844 .496 r
.7122 .5207 .71481 .51784 .71769 .51442 .71509 .51727 Mtetra
.131 0 0 r
.71509 .51727 .71769 .51442 .72096 .51394 .71837 .51679 Mtetra
.451 0 .024 r
.71837 .51679 .72096 .51394 .7246 .51606 .72202 .51894 Mtetra
.561 .091 .097 r
.72202 .51894 .7246 .51606 .72852 .52005 .72594 .52295 Mtetra
.591 .126 .117 r
.72594 .52295 .72852 .52005 .73258 .5248 .72999 .52774 Mtetra
.571 .102 .103 r
.72999 .52774 .73258 .5248 .7366 .52908 .73402 .53205 Mtetra
.481 .004 .045 r
.73402 .53205 .7366 .52908 .74043 .53171 .73785 .5347 Mtetra
.226 0 0 r
.73785 .5347 .74043 .53171 .74391 .53178 .74134 .53478 Mtetra
0 0 0 r
.74134 .53478 .74391 .53178 .74697 .52886 .74441 .53184 Mtetra
.901 .929 .55 r
.74441 .53184 .74697 .52886 .74962 .52304 .74707 .52601 Mtetra
.991 .868 .526 r
.74707 .52601 .74962 .52304 .75191 .51499 .74938 .51792 Mtetra
1 .827 .506 r
.74938 .51792 .75191 .51499 .75401 .50574 .7515 .50863 Mtetra
1 .827 .505 r
.7515 .50863 .75401 .50574 .7561 .49653 .7536 .49937 Mtetra
.992 .867 .526 r
.7536 .49937 .7561 .49653 .75836 .48856 .75587 .49136 Mtetra
.909 .93 .555 r
.75587 .49136 .75836 .48856 .76096 .48279 .75848 .48557 Mtetra
0 0 0 r
.75848 .48557 .76096 .48279 .76399 .47981 .76152 .48258 Mtetra
.199 0 0 r
.76152 .48258 .76399 .47981 .76751 .47974 .76505 .48252 Mtetra
.468 0 .015 r
.76505 .48252 .76751 .47974 .77147 .48223 .76901 .48503 Mtetra
.563 .084 .076 r
.76901 .48503 .77147 .48223 .77574 .48647 .77329 .4893 Mtetra
.587 .111 .092 r
.77329 .4893 .77574 .48647 .78017 .49137 .77772 .49423 Mtetra
.562 .083 .075 r
.77772 .49423 .78017 .49137 .78453 .49568 .78208 .49857 Mtetra
.466 0 .016 r
.78208 .49857 .78453 .49568 .78863 .49822 .78619 .50114 Mtetra
.201 0 0 r
.78619 .50114 .78863 .49822 .79229 .49815 .78986 .50108 Mtetra
0 0 0 r
.78986 .50108 .79229 .49815 .79544 .49507 .79302 .49798 Mtetra
.887 .92 .526 r
.79302 .49798 .79544 .49507 .79809 .48915 .79568 .49203 Mtetra
.985 .868 .503 r
.79568 .49203 .79809 .48915 .80034 .48107 .79794 .48392 Mtetra
.997 .832 .485 r
.79794 .48392 .80034 .48107 .80237 .47191 .79998 .47472 Mtetra
.996 .835 .486 r
.79998 .47472 .80237 .47191 .80441 .46292 .80204 .46568 Mtetra
.979 .878 .509 r
.80204 .46568 .80441 .46292 .80668 .45527 .80433 .458 Mtetra
.846 .922 .529 r
.80433 .458 .80668 .45527 .80938 .4499 .80703 .45261 Mtetra
0 0 0 r
.80703 .45261 .80938 .4499 .81261 .44735 .81028 .45005 Mtetra
.253 0 0 r
.81028 .45005 .81261 .44735 .81642 .4477 .8141 .45042 Mtetra
.481 0 .002 r
.8141 .45042 .81642 .4477 .82075 .45055 .81843 .45328 Mtetra
.563 .074 .052 r
.81843 .45328 .82075 .45055 .82544 .45506 .82313 .45783 Mtetra
.582 .095 .064 r
.82313 .45783 .82544 .45506 .83029 .4601 .82798 .46291 Mtetra
.552 .062 .045 r
.82798 .46291 .83029 .4601 .83503 .46444 .83272 .46727 Mtetra
.45 0 0 r
.83272 .46727 .83503 .46444 .83942 .46691 .83713 .46977 Mtetra
.177 0 0 r
.83713 .46977 .83942 .46691 .84329 .46669 .841 .46956 Mtetra
0 0 0 r
.841 .46956 .84329 .46669 .84653 .46345 .84426 .4663 Mtetra
.868 .907 .497 r
.84426 .4663 .84653 .46345 .84919 .4574 .84692 .46023 Mtetra
.974 .865 .476 r
.84692 .46023 .84919 .4574 .85138 .44929 .84913 .45208 Mtetra
.99 .834 .459 r
.84913 .45208 .85138 .44929 .85335 .44021 .85112 .44296 Mtetra
.987 .841 .464 r
.85112 .44296 .85335 .44021 .85536 .43141 .85314 .43412 Mtetra
.954 .884 .488 r
.85314 .43412 .85536 .43141 .85768 .42407 .85547 .42674 Mtetra
.761 .895 .495 r
.85547 .42674 .85768 .42407 .86051 .41909 .85831 .42174 Mtetra
0 0 0 r
.85831 .42174 .86051 .41909 .864 .41698 .86181 .41962 Mtetra
.296 0 0 r
.86181 .41962 .864 .41698 .86816 .41775 .86599 .4204 Mtetra
.49 0 0 r
.86599 .4204 .86816 .41775 .87292 .42096 .87076 .42364 Mtetra
.562 .062 .026 r
.87076 .42364 .87292 .42096 .87809 .42574 .87593 .42846 Mtetra
.575 .077 .034 r
.87593 .42846 .87809 .42574 .88341 .43095 .88126 .4337 Mtetra
.541 .039 .014 r
.88126 .4337 .88341 .43095 .88858 .43531 .88643 .4381 Mtetra
.432 0 0 r
.88643 .4381 .88858 .43531 .89331 .43771 .89117 .44052 Mtetra
.155 0 0 r
.89117 .44052 .89331 .43771 .89739 .43735 .89527 .44016 Mtetra
.94 .866 .739 r
.44366 .84073 .44705 .83926 .44974 .83399 .44635 .83544 Mtetra
.929 .751 .641 r
.44635 .83544 .44974 .83399 .45249 .82571 .44912 .82715 Mtetra
.917 .705 .601 r
.44912 .82715 .45249 .82571 .45526 .81531 .45191 .81671 Mtetra
.912 .69 .588 r
.45191 .81671 .45526 .81531 .45804 .804 .45471 .80538 Mtetra
.914 .696 .593 r
.45471 .80538 .45804 .804 .46079 .79317 .45747 .79451 Mtetra
.923 .726 .62 r
.45747 .79451 .46079 .79317 .4635 .78406 .4602 .78538 Mtetra
.937 .804 .688 r
.4602 .78538 .4635 .78406 .46615 .77762 .46286 .77892 Mtetra
.878 .975 .841 r
.46286 .77892 .46615 .77762 .46877 .77433 .46548 .77563 Mtetra
.08 0 0 r
.46548 .77563 .46877 .77433 .47135 .77415 .46806 .77545 Mtetra
.556 .063 .039 r
.46806 .77545 .47135 .77415 .47391 .77653 .47062 .77784 Mtetra
.65 .191 .151 r
.47062 .77784 .47391 .77653 .47648 .78047 .47318 .78179 Mtetra
.66 .206 .164 r
.47318 .78179 .47648 .78047 .47907 .78469 .47576 .78603 Mtetra
.608 .133 .1 r
.47576 .78603 .47907 .78469 .48168 .78786 .47837 .78921 Mtetra
.366 0 0 r
.47837 .78921 .48168 .78786 .48433 .78879 .48101 .79014 Mtetra
.645 .967 .832 r
.48101 .79014 .48433 .78879 .48699 .7867 .48368 .78805 Mtetra
.942 .866 .735 r
.48368 .78805 .48699 .7867 .48967 .78136 .48637 .7827 Mtetra
.933 .754 .637 r
.48637 .7827 .48967 .78136 .49235 .77315 .48906 .77447 Mtetra
.922 .71 .597 r
.48906 .77447 .49235 .77315 .49501 .76296 .49174 .76425 Mtetra
.918 .696 .585 r
.49174 .76425 .49501 .76296 .49766 .75202 .4944 .75327 Mtetra
.921 .704 .593 r
.4944 .75327 .49766 .75202 .50029 .74166 .49705 .74289 Mtetra
.93 .74 .625 r
.49705 .74289 .50029 .74166 .50291 .7331 .49969 .73431 Mtetra
.941 .83 .706 r
.49969 .73431 .50291 .7331 .50554 .72723 .50232 .72842 Mtetra
.812 .995 .863 r
.50232 .72842 .50554 .72723 .50818 .72446 .50497 .72564 Mtetra
.203 0 0 r
.50497 .72564 .50818 .72446 .51086 .7247 .50764 .72589 Mtetra
.574 .077 .038 r
.50764 .72589 .51086 .7247 .51357 .72737 .51035 .72857 Mtetra
.652 .186 .133 r
.51035 .72857 .51357 .72737 .51632 .73146 .51309 .73268 Mtetra
.657 .193 .139 r
.51309 .73268 .51632 .73146 .51909 .7357 .51586 .73693 Mtetra
.597 .109 .066 r
.51586 .73693 .51909 .7357 .52187 .73878 .51863 .74002 Mtetra
.329 0 0 r
.51863 .74002 .52187 .73878 .52463 .73956 .52139 .74081 Mtetra
.676 .977 .845 r
.52139 .74081 .52463 .73956 .52736 .73734 .52412 .73858 Mtetra
.945 .866 .73 r
.52412 .73858 .52736 .73734 .53003 .73194 .5268 .73317 Mtetra
.938 .758 .632 r
.5268 .73317 .53003 .73194 .53264 .72378 .52942 .72498 Mtetra
.928 .714 .593 r
.52942 .72498 .53264 .72378 .53519 .71378 .53199 .71496 Mtetra
.925 .702 .582 r
.53199 .71496 .53519 .71378 .53772 .70317 .53454 .70432 Mtetra
.928 .714 .593 r
.53454 .70432 .53772 .70317 .54025 .69327 .53708 .69439 Mtetra
.937 .756 .631 r
.53708 .69439 .54025 .69327 .5428 .68523 .53965 .68633 Mtetra
.944 .861 .729 r
.53965 .68633 .5428 .68523 .54542 .67989 .54228 .68098 Mtetra
.705 .985 .864 r
.54228 .68098 .54542 .67989 .54813 .67761 .54499 .67869 Mtetra
.294 0 0 r
.54499 .67869 .54813 .67761 .55093 .67826 .54778 .67935 Mtetra
.587 .087 .032 r
.54778 .67935 .55093 .67826 .55382 .68121 .55067 .68231 Mtetra
.653 .178 .112 r
.55067 .68231 .55382 .68121 .55677 .68544 .55361 .68656 Mtetra
.653 .177 .112 r
.55361 .68656 .55677 .68544 .55975 .6897 .55658 .69083 Mtetra
.584 .083 .03 r
.55658 .69083 .55975 .6897 .5627 .69268 .55953 .69382 Mtetra
.289 0 0 r
.55953 .69382 .5627 .69268 .56559 .69333 .56242 .69447 Mtetra
.701 .984 .854 r
.56242 .69447 .56559 .69333 .56838 .69097 .56521 .69211 Mtetra
.948 .868 .725 r
.56521 .69211 .56838 .69097 .57104 .68549 .56788 .68662 Mtetra
.943 .762 .628 r
.56788 .68662 .57104 .68549 .57358 .67737 .57044 .67848 Mtetra
.934 .719 .589 r
.57044 .67848 .57358 .67737 .57604 .66755 .57291 .66863 Mtetra
.931 .709 .579 r
.57291 .66863 .57604 .66755 .57846 .65725 .57535 .6583 Mtetra
.935 .724 .593 r
.57535 .6583 .57846 .65725 .5809 .64777 .5778 .6488 Mtetra
.945 .774 .64 r
.5778 .6488 .5809 .64777 .58341 .64022 .58033 .64123 Mtetra
.941 .894 .755 r
.58033 .64123 .58341 .64022 .58605 .63539 .58297 .63638 Mtetra
.556 .932 .833 r
.58297 .63638 .58605 .63539 .58885 .63358 .58577 .63457 Mtetra
.36 0 0 r
.58577 .63457 .58885 .63358 .59181 .63462 .58873 .63562 Mtetra
.597 .091 .021 r
.58873 .63562 .59181 .63462 .5949 .63784 .59182 .63885 Mtetra
.653 .169 .089 r
.59182 .63885 .5949 .63784 .59808 .64222 .59499 .64324 Mtetra
.647 .16 .082 r
.59499 .64324 .59808 .64222 .60128 .64648 .59819 .64752 Mtetra
.57 .055 0 r
.59819 .64752 .60128 .64648 .60443 .64938 .60133 .65043 Mtetra
.246 0 0 r
.60133 .65043 .60443 .64938 .60745 .64989 .60435 .65094 Mtetra
.722 .989 .859 r
.60435 .65094 .60745 .64989 .6103 .64739 .60721 .64843 Mtetra
.952 .87 .72 r
.60721 .64843 .6103 .64739 .61296 .64183 .60987 .64287 Mtetra
.949 .767 .623 r
.60987 .64287 .61296 .64183 .61544 .63374 .61237 .63475 Mtetra
.941 .725 .584 r
.61237 .63475 .61544 .63374 .61781 .62407 .61474 .62506 Mtetra
.939 .717 .576 r
.61474 .62506 .61781 .62407 .62013 .61407 .61708 .61503 Mtetra
.943 .736 .594 r
.61708 .61503 .62013 .61407 .62249 .60498 .61946 .60592 Mtetra
.952 .795 .65 r
.61946 .60592 .62249 .60498 .62499 .5979 .62197 .59882 Mtetra
.929 .93 .785 r
.62197 .59882 .62499 .5979 .62769 .59355 .62467 .59446 Mtetra
.381 .84 .771 r
.62467 .59446 .62769 .59355 .63061 .5922 .62759 .59311 Mtetra
.409 0 0 r
.62759 .59311 .63061 .5922 .63375 .59362 .63074 .59453 Mtetra
.603 .091 .006 r
.63074 .59453 .63375 .59362 .63708 .59711 .63406 .59803 Mtetra
.651 .157 .064 r
.63406 .59803 .63708 .59711 .64052 .60162 .6375 .60255 Mtetra
.639 .141 .05 r
.6375 .60255 .64052 .60162 .64397 .6059 .64094 .60685 Mtetra
.552 .025 0 r
.64094 .60685 .64397 .6059 .64733 .60871 .64429 .60967 Mtetra
.201 0 0 r
.64429 .60967 .64733 .60871 .65049 .60907 .64746 .61004 Mtetra
.739 .992 .86 r
.64746 .61004 .65049 .60907 .65341 .60643 .65038 .60739 Mtetra
.956 .873 .715 r
.65038 .60739 .65341 .60643 .65606 .60079 .65304 .60174 Mtetra
.955 .772 .617 r
.65304 .60174 .65606 .60079 .65849 .59271 .65548 .59364 Mtetra
.947 .732 .578 r
.65548 .59364 .65849 .59271 .66076 .58319 .65777 .58409 Mtetra
.946 .726 .572 r
.65777 .58409 .66076 .58319 .663 .57345 .66002 .57432 Mtetra
.951 .75 .596 r
.66002 .57432 .663 .57345 .66532 .56474 .66235 .56559 Mtetra
.958 .819 .664 r
.66235 .56559 .66532 .56474 .66782 .55811 .66487 .55894 Mtetra
.903 .963 .816 r
.66487 .55894 .66782 .55811 .6706 .55423 .66765 .55505 Mtetra
.209 .725 .692 r
.66765 .55505 .6706 .55423 .67368 .55331 .67073 .55414 Mtetra
.444 0 0 r
.67073 .55414 .67368 .55331 .67705 .5551 .6741 .55593 Mtetra
.607 .088 0 r
.6741 .55593 .67705 .5551 .68065 .55885 .6777 .55969 Mtetra
.647 .142 .035 r
.6777 .55969 .68065 .55885 .68438 .5635 .68142 .56435 Mtetra
.63 .119 .015 r
.68142 .56435 .68438 .5635 .68811 .56779 .68514 .56867 Mtetra
.533 0 0 r
.68514 .56867 .68811 .56779 .69169 .57052 .68872 .57141 Mtetra
.156 0 0 r
.68872 .57141 .69169 .57052 .69501 .57074 .69204 .57163 Mtetra
.752 .994 .86 r
.69204 .57163 .69501 .57074 .698 .56796 .69504 .56884 Mtetra
.96 .877 .708 r
.69504 .56884 .698 .56796 .70065 .56222 .6977 .56309 Mtetra
.961 .778 .61 r
.6977 .56309 .70065 .56222 .70302 .55415 .70008 .55499 Mtetra
.955 .739 .572 r
.70008 .55499 .70302 .55415 .70521 .54475 .70229 .54556 Mtetra
.954 .735 .569 r
.70229 .54556 .70521 .54475 .70738 .53526 .70446 .53605 Mtetra
.959 .765 .598 r
.70446 .53605 .70738 .53526 .70966 .52691 .70676 .52768 Mtetra
.963 .847 .68 r
.70676 .52768 .70966 .52691 .7122 .5207 .70931 .52146 Mtetra
.857 .988 .845 r
.70931 .52146 .7122 .5207 .71509 .51727 .71221 .51802 Mtetra
0 0 0 r
.71221 .51802 .71509 .51727 .71837 .51679 .71549 .51754 Mtetra
.47 0 0 r
.71549 .51754 .71837 .51679 .72202 .51894 .71913 .51969 Mtetra
.608 .081 0 r
.71913 .51969 .72202 .51894 .72594 .52295 .72304 .52372 Mtetra
.641 .126 .004 r
.72304 .52372 .72594 .52295 .72999 .52774 .7271 .52852 Mtetra
.618 .096 0 r
.7271 .52852 .72999 .52774 .73402 .53205 .73112 .53285 Mtetra
.511 0 0 r
.73112 .53285 .73402 .53205 .73785 .5347 .73495 .53551 Mtetra
.11 0 0 r
.73495 .53551 .73785 .5347 .74134 .53478 .73844 .53559 Mtetra
.763 .996 .857 r
.73844 .53559 .74134 .53478 .74441 .53184 .74152 .53265 Mtetra
.964 .881 .702 r
.74152 .53265 .74441 .53184 .74707 .52601 .74418 .52679 Mtetra
.968 .785 .603 r
.74418 .52679 .74707 .52601 .74938 .51792 .7465 .51868 Mtetra
.962 .747 .565 r
.7465 .51868 .74938 .51792 .7515 .50863 .74863 .50937 Mtetra
.962 .746 .565 r
.74863 .50937 .7515 .50863 .7536 .49937 .75075 .50009 Mtetra
.967 .783 .602 r
.75075 .50009 .7536 .49937 .75587 .49136 .75304 .49205 Mtetra
.964 .877 .7 r
.75304 .49205 .75587 .49136 .75848 .48557 .75565 .48625 Mtetra
.781 .996 .864 r
.75565 .48625 .75848 .48557 .76152 .48258 .7587 .48325 Mtetra
.062 0 0 r
.7587 .48325 .76152 .48258 .76505 .48252 .76223 .48319 Mtetra
.489 0 0 r
.76223 .48319 .76505 .48252 .76901 .48503 .76619 .48571 Mtetra
.606 .072 0 r
.76619 .48571 .76901 .48503 .77329 .4893 .77046 .49 Mtetra
.633 .107 0 r
.77046 .49 .77329 .4893 .77772 .49423 .77489 .49495 Mtetra
.605 .07 0 r
.77489 .49495 .77772 .49423 .78208 .49857 .77925 .4993 Mtetra
.486 0 0 r
.77925 .4993 .78208 .49857 .78619 .50114 .78335 .50188 Mtetra
.066 0 0 r
.78335 .50188 .78619 .50114 .78986 .50108 .78703 .50181 Mtetra
.771 .997 .852 r
.78703 .50181 .78986 .50108 .79302 .49798 .79019 .49872 Mtetra
.969 .887 .694 r
.79019 .49872 .79302 .49798 .79568 .49203 .79286 .49275 Mtetra
.975 .792 .594 r
.79286 .49275 .79568 .49203 .79794 .48392 .79513 .48462 Mtetra
.97 .755 .558 r
.79513 .48462 .79794 .48392 .79998 .47472 .79719 .47539 Mtetra
.97 .759 .561 r
.79719 .47539 .79998 .47472 .80204 .46568 .79926 .46633 Mtetra
.975 .803 .607 r
.79926 .46633 .80204 .46568 .80433 .458 .80156 .45862 Mtetra
.96 .91 .723 r
.80156 .45862 .80433 .458 .80703 .45261 .80427 .45321 Mtetra
.672 .976 .865 r
.80427 .45321 .80703 .45261 .81028 .45005 .80752 .45066 Mtetra
.154 0 0 r
.80752 .45066 .81028 .45005 .8141 .45042 .81135 .45102 Mtetra
.501 0 0 r
.81135 .45102 .8141 .45042 .81843 .45328 .81568 .4539 Mtetra
.602 .059 0 r
.81568 .4539 .81843 .45328 .82313 .45783 .82037 .45846 Mtetra
.622 .086 0 r
.82037 .45846 .82313 .45783 .82798 .46291 .82522 .46355 Mtetra
.589 .042 0 r
.82522 .46355 .82798 .46291 .83272 .46727 .82996 .46793 Mtetra
.459 0 0 r
.82996 .46793 .83272 .46727 .83713 .46977 .83436 .47044 Mtetra
.023 0 0 r
.83436 .47044 .83713 .46977 .841 .46956 .83824 .47023 Mtetra
.777 .998 .845 r
.83824 .47023 .841 .46956 .84426 .4663 .84151 .46697 Mtetra
.973 .893 .685 r
.84151 .46697 .84426 .4663 .84692 .46023 .84418 .46088 Mtetra
.981 .799 .584 r
.84418 .46088 .84692 .46023 .84913 .45208 .8464 .4527 Mtetra
.978 .765 .549 r
.8464 .4527 .84913 .45208 .85112 .44296 .8484 .44355 Mtetra
.979 .772 .557 r
.8484 .44355 .85112 .44296 .85314 .43412 .85043 .43469 Mtetra
.982 .826 .613 r
.85043 .43469 .85314 .43412 .85547 .42674 .85277 .4273 Mtetra
.946 .943 .749 r
.85277 .4273 .85547 .42674 .85831 .42174 .85563 .42228 Mtetra
.537 .925 .845 r
.85563 .42228 .85831 .42174 .86181 .41962 .85913 .42016 Mtetra
.223 0 0 r
.85913 .42016 .86181 .41962 .86599 .4204 .86331 .42095 Mtetra
.507 0 0 r
.86331 .42095 .86599 .4204 .87076 .42364 .86807 .42419 Mtetra
.595 .043 0 r
.86807 .42419 .87076 .42364 .87593 .42846 .87325 .42903 Mtetra
.61 .062 0 r
.87325 .42903 .87593 .42846 .88126 .4337 .87857 .43429 Mtetra
.57 .012 0 r
.87857 .43429 .88126 .4337 .88643 .4381 .88375 .4387 Mtetra
.431 0 0 r
.88375 .4387 .88643 .4381 .89117 .44052 .88849 .44113 Mtetra
0 0 0 r
.88849 .44113 .89117 .44052 .89527 .44016 .89259 .44077 Mtetra
.804 .661 .704 r
.44033 .83906 .44366 .84073 .44635 .83544 .44303 .83377 Mtetra
.829 .626 .628 r
.44303 .83377 .44635 .83544 .44912 .82715 .4458 .82547 Mtetra
.836 .61 .596 r
.4458 .82547 .44912 .82715 .45191 .81671 .44861 .81503 Mtetra
.838 .604 .585 r
.44861 .81503 .45191 .81671 .45471 .80538 .45142 .80369 Mtetra
.837 .606 .589 r
.45142 .80369 .45471 .80538 .45747 .79451 .4542 .79282 Mtetra
.832 .617 .611 r
.4542 .79282 .45747 .79451 .4602 .78538 .45693 .78369 Mtetra
.818 .642 .665 r
.45693 .78369 .4602 .78538 .46286 .77892 .45961 .77723 Mtetra
.756 .694 .792 r
.45961 .77723 .46286 .77892 .46548 .77563 .46223 .77393 Mtetra
.284 .635 .964 r
.46223 .77393 .46548 .77563 .46806 .77545 .4648 .77375 Mtetra
.584 .011 0 r
.4648 .77375 .46806 .77545 .47062 .77784 .46735 .77613 Mtetra
.736 .215 0 r
.46735 .77613 .47062 .77784 .47318 .78179 .4699 .78008 Mtetra
.748 .236 0 r
.4699 .78008 .47318 .78179 .47576 .78603 .47247 .78431 Mtetra
.676 .127 0 r
.47247 .78431 .47576 .78603 .47837 .78921 .47507 .78749 Mtetra
0 .373 .761 r
.47507 .78749 .47837 .78921 .48101 .79014 .47771 .78842 Mtetra
.675 .719 .882 r
.47771 .78842 .48101 .79014 .48368 .78805 .48038 .78633 Mtetra
.807 .661 .702 r
.48038 .78633 .48368 .78805 .48637 .7827 .48307 .78097 Mtetra
.831 .626 .626 r
.48307 .78097 .48637 .7827 .48906 .77447 .48577 .77274 Mtetra
.838 .611 .594 r
.48577 .77274 .48906 .77447 .49174 .76425 .48846 .76251 Mtetra
.84 .605 .583 r
.48846 .76251 .49174 .76425 .4944 .75327 .49114 .75154 Mtetra
.839 .609 .59 r
.49114 .75154 .4944 .75327 .49705 .74289 .4938 .74115 Mtetra
.833 .621 .616 r
.4938 .74115 .49705 .74289 .49969 .73431 .49644 .73257 Mtetra
.814 .65 .679 r
.49644 .73257 .49969 .73431 .50232 .72842 .49908 .72668 Mtetra
.728 .704 .828 r
.49908 .72668 .50232 .72842 .50497 .72564 .50173 .7239 Mtetra
.124 .554 .921 r
.50173 .7239 .50497 .72564 .50764 .72589 .5044 .72414 Mtetra
.605 .037 0 r
.5044 .72414 .50764 .72589 .51035 .72857 .5071 .72682 Mtetra
.73 .205 0 r
.5071 .72682 .51035 .72857 .51309 .73268 .50983 .73092 Mtetra
.736 .214 0 r
.50983 .73092 .51309 .73268 .51586 .73693 .51258 .73517 Mtetra
.647 .088 0 r
.51258 .73517 .51586 .73693 .51863 .74002 .51534 .73825 Mtetra
0 .425 .815 r
.51534 .73825 .51863 .74002 .52139 .74081 .5181 .73904 Mtetra
.683 .716 .874 r
.5181 .73904 .52139 .74081 .52412 .73858 .52083 .73681 Mtetra
.809 .661 .699 r
.52083 .73681 .52412 .73858 .5268 .73317 .52351 .73139 Mtetra
.834 .627 .623 r
.52351 .73139 .5268 .73317 .52942 .72498 .52614 .7232 Mtetra
.841 .612 .591 r
.52614 .7232 .52942 .72498 .53199 .71496 .52873 .71318 Mtetra
.843 .607 .582 r
.52873 .71318 .53199 .71496 .53454 .70432 .53128 .70254 Mtetra
.841 .611 .591 r
.53128 .70254 .53454 .70432 .53708 .69439 .53383 .6926 Mtetra
.834 .627 .622 r
.53383 .6926 .53708 .69439 .53965 .68633 .53641 .68454 Mtetra
.809 .659 .697 r
.53641 .68454 .53965 .68633 .54228 .68098 .53905 .67918 Mtetra
.687 .712 .867 r
.53905 .67918 .54228 .68098 .54499 .67869 .54175 .6769 Mtetra
0 .463 .854 r
.54175 .6769 .54499 .67869 .54778 .67935 .54455 .67755 Mtetra
.617 .052 0 r
.54455 .67755 .54778 .67935 .55067 .68231 .54742 .6805 Mtetra
.722 .191 0 r
.54742 .6805 .55067 .68231 .55361 .68656 .55035 .68475 Mtetra
.721 .19 0 r
.55035 .68475 .55361 .68656 .55658 .69083 .55331 .68901 Mtetra
.613 .047 0 r
.55331 .68901 .55658 .69083 .55953 .69382 .55625 .692 Mtetra
0 .469 .858 r
.55625 .692 .55953 .69382 .56242 .69447 .55913 .69265 Mtetra
.69 .714 .867 r
.55913 .69265 .56242 .69447 .56521 .69211 .56192 .69028 Mtetra
.812 .661 .696 r
.56192 .69028 .56521 .69211 .56788 .68662 .5646 .68479 Mtetra
.837 .628 .621 r
.5646 .68479 .56788 .68662 .57044 .67848 .56716 .67664 Mtetra
.844 .613 .588 r
.56716 .67664 .57044 .67848 .57291 .66863 .56965 .66679 Mtetra
.846 .609 .58 r
.56965 .66679 .57291 .66863 .57535 .6583 .5721 .65646 Mtetra
.843 .615 .592 r
.5721 .65646 .57535 .6583 .5778 .6488 .57456 .64695 Mtetra
.834 .632 .63 r
.57456 .64695 .5778 .6488 .58033 .64123 .5771 .63939 Mtetra
.801 .669 .718 r
.5771 .63939 .58033 .64123 .58297 .63638 .57975 .63454 Mtetra
.632 .713 .905 r
.57975 .63454 .58297 .63638 .58577 .63457 .58255 .63272 Mtetra
0 .377 .781 r
.58255 .63272 .58577 .63457 .58873 .63562 .58549 .63376 Mtetra
.622 .059 0 r
.58549 .63376 .58873 .63562 .59182 .63885 .58857 .63699 Mtetra
.711 .175 0 r
.58857 .63699 .59182 .63885 .59499 .64324 .59173 .64138 Mtetra
.703 .163 0 r
.59173 .64138 .59499 .64324 .59819 .64752 .59492 .64565 Mtetra
.573 .003 0 r
.59492 .64565 .59819 .64752 .60133 .65043 .59805 .64856 Mtetra
.052 .506 .891 r
.59805 .64856 .60133 .65043 .60435 .65094 .60107 .64906 Mtetra
.696 .713 .861 r
.60107 .64906 .60435 .65094 .60721 .64843 .60392 .64655 Mtetra
.814 .662 .694 r
.60392 .64655 .60721 .64843 .60987 .64287 .60659 .64098 Mtetra
.84 .629 .618 r
.60659 .64098 .60987 .64287 .61237 .63475 .60909 .63286 Mtetra
.847 .614 .586 r
.60909 .63286 .61237 .63475 .61474 .62506 .61148 .62317 Mtetra
.849 .611 .579 r
.61148 .62317 .61474 .62506 .61708 .61503 .61383 .61313 Mtetra
.846 .618 .594 r
.61383 .61313 .61708 .61503 .61946 .60592 .61622 .60402 Mtetra
.833 .639 .64 r
.61622 .60402 .61946 .60592 .62197 .59882 .61874 .59692 Mtetra
.789 .68 .744 r
.61874 .59692 .62197 .59882 .62467 .59446 .62144 .59256 Mtetra
.558 .704 .938 r
.62144 .59256 .62467 .59446 .62759 .59311 .62436 .5912 Mtetra
0 .304 .715 r
.62436 .5912 .62759 .59311 .63074 .59453 .6275 .59262 Mtetra
.622 .06 0 r
.6275 .59262 .63074 .59453 .63406 .59803 .63081 .59611 Mtetra
.698 .156 0 r
.63081 .59611 .63406 .59803 .6375 .60255 .63423 .60063 Mtetra
.681 .133 0 r
.63423 .60063 .6375 .60255 .64094 .60685 .63767 .60492 Mtetra
.529 0 0 r
.63767 .60492 .64094 .60685 .64429 .60967 .64101 .60774 Mtetra
.112 .536 .915 r
.64101 .60774 .64429 .60967 .64746 .61004 .64417 .6081 Mtetra
.702 .712 .856 r
.64417 .6081 .64746 .61004 .65038 .60739 .64709 .60545 Mtetra
.818 .663 .691 r
.64709 .60545 .65038 .60739 .65304 .60174 .64976 .59979 Mtetra
.843 .631 .615 r
.64976 .59979 .65304 .60174 .65548 .59364 .6522 .59169 Mtetra
.851 .616 .583 r
.6522 .59169 .65548 .59364 .65777 .58409 .6545 .58214 Mtetra
.852 .614 .578 r
.6545 .58214 .65777 .58409 .66002 .57432 .65677 .57237 Mtetra
.848 .623 .597 r
.65677 .57237 .66002 .57432 .66235 .56559 .65911 .56364 Mtetra
.832 .647 .652 r
.65911 .56364 .66235 .56559 .66487 .55894 .66163 .55698 Mtetra
.772 .69 .773 r
.66163 .55698 .66487 .55894 .66765 .55505 .66441 .55309 Mtetra
.466 .682 .959 r
.66441 .55309 .66765 .55505 .67073 .55414 .66749 .55217 Mtetra
0 .248 .662 r
.66749 .55217 .67073 .55414 .6741 .55593 .67085 .55396 Mtetra
.616 .055 0 r
.67085 .55396 .6741 .55593 .6777 .55969 .67444 .55772 Mtetra
.681 .134 0 r
.67444 .55772 .6777 .55969 .68142 .56435 .67815 .56237 Mtetra
.655 .101 0 r
.67815 .56237 .68142 .56435 .68514 .56867 .68186 .56668 Mtetra
.48 0 0 r
.68186 .56668 .68514 .56867 .68872 .57141 .68543 .56941 Mtetra
.165 .561 .931 r
.68543 .56941 .68872 .57141 .69204 .57163 .68874 .56963 Mtetra
.708 .711 .851 r
.68874 .56963 .69204 .57163 .69504 .56884 .69174 .56683 Mtetra
.821 .665 .689 r
.69174 .56683 .69504 .56884 .6977 .56309 .6944 .56108 Mtetra
.847 .632 .612 r
.6944 .56108 .6977 .56309 .70008 .55499 .69679 .55298 Mtetra
.855 .618 .58 r
.69679 .55298 .70008 .55499 .70229 .54556 .69901 .54355 Mtetra
.855 .617 .577 r
.69901 .54355 .70229 .54556 .70446 .53605 .7012 .53404 Mtetra
.85 .628 .602 r
.7012 .53404 .70446 .53605 .70676 .52768 .70351 .52566 Mtetra
.829 .655 .667 r
.70351 .52566 .70676 .52768 .70931 .52146 .70606 .51944 Mtetra
.749 .7 .806 r
.70606 .51944 .70931 .52146 .71221 .51802 .70896 .516 Mtetra
.361 .644 .963 r
.70896 .516 .71221 .51802 .71549 .51754 .71224 .51551 Mtetra
0 .207 .624 r
.71224 .51551 .71549 .51754 .71913 .51969 .71587 .51766 Mtetra
.607 .046 0 r
.71587 .51766 .71913 .51969 .72304 .52372 .71977 .52168 Mtetra
.661 .11 0 r
.71977 .52168 .72304 .52372 .7271 .52852 .72381 .52647 Mtetra
.625 .067 0 r
.72381 .52647 .7271 .52852 .73112 .53285 .72782 .5308 Mtetra
.428 0 0 r
.72782 .5308 .73112 .53285 .73495 .53551 .73164 .53345 Mtetra
.211 .58 .943 r
.73164 .53345 .73495 .53551 .73844 .53559 .73512 .53353 Mtetra
.713 .711 .847 r
.73512 .53353 .73844 .53559 .74152 .53265 .7382 .53058 Mtetra
.825 .666 .687 r
.7382 .53058 .74152 .53265 .74418 .52679 .74087 .52472 Mtetra
.851 .634 .608 r
.74087 .52472 .74418 .52679 .7465 .51868 .7432 .51661 Mtetra
.858 .62 .577 r
.7432 .51661 .7465 .51868 .74863 .50937 .74534 .50729 Mtetra
.859 .62 .577 r
.74534 .50729 .74863 .50937 .75075 .50009 .74747 .49801 Mtetra
.851 .634 .607 r
.74747 .49801 .75075 .50009 .75304 .49205 .74976 .48997 Mtetra
.825 .665 .685 r
.74976 .48997 .75304 .49205 .75565 .48625 .75239 .48416 Mtetra
.716 .708 .841 r
.75239 .48416 .75565 .48625 .7587 .48325 .75544 .48116 Mtetra
.251 .595 .95 r
.75544 .48116 .7587 .48325 .76223 .48319 .75896 .4811 Mtetra
0 .178 .599 r
.75896 .4811 .76223 .48319 .76619 .48571 .76291 .48361 Mtetra
.593 .032 0 r
.76291 .48361 .76619 .48571 .77046 .49 .76717 .48789 Mtetra
.637 .083 0 r
.76717 .48789 .77046 .49 .77489 .49495 .77158 .49283 Mtetra
.591 .03 0 r
.77158 .49283 .77489 .49495 .77925 .4993 .77593 .49718 Mtetra
0 .182 .603 r
.77593 .49718 .77925 .4993 .78335 .50188 .78002 .49975 Mtetra
.251 .596 .95 r
.78002 .49975 .78335 .50188 .78703 .50181 .78369 .49968 Mtetra
.718 .712 .843 r
.78369 .49968 .78703 .50181 .79019 .49872 .78686 .49658 Mtetra
.828 .668 .684 r
.78686 .49658 .79019 .49872 .79286 .49275 .78953 .49061 Mtetra
.855 .636 .605 r
.78953 .49061 .79286 .49275 .79513 .48462 .79181 .48247 Mtetra
.863 .623 .574 r
.79181 .48247 .79513 .48462 .79719 .47539 .79388 .47324 Mtetra
.862 .624 .577 r
.79388 .47324 .79719 .47539 .79926 .46633 .79596 .46418 Mtetra
.853 .64 .615 r
.79596 .46418 .79926 .46633 .80156 .45862 .79827 .45647 Mtetra
.818 .675 .706 r
.79827 .45647 .80156 .45862 .80427 .45321 .80099 .45106 Mtetra
.673 .711 .877 r
.80099 .45106 .80427 .45321 .80752 .45066 .80424 .4485 Mtetra
.147 .539 .923 r
.80424 .4485 .80752 .45066 .81135 .45102 .80805 .44886 Mtetra
.394 0 0 r
.80805 .44886 .81135 .45102 .81568 .4539 .81237 .45173 Mtetra
.576 .015 0 r
.81237 .45173 .81568 .4539 .82037 .45846 .81705 .45628 Mtetra
.61 .053 0 r
.81705 .45628 .82037 .45846 .82522 .46355 .82188 .46137 Mtetra
.553 0 0 r
.82188 .46137 .82522 .46355 .82996 .46793 .82661 .46574 Mtetra
0 .226 .655 r
.82661 .46574 .82996 .46793 .83436 .47044 .83101 .46824 Mtetra
.285 .609 .955 r
.83101 .46824 .83436 .47044 .83824 .47023 .83488 .46802 Mtetra
.723 .713 .841 r
.83488 .46802 .83824 .47023 .84151 .46697 .83814 .46475 Mtetra
.833 .671 .682 r
.83814 .46475 .84151 .46697 .84418 .46088 .84082 .45866 Mtetra
.86 .639 .602 r
.84082 .45866 .84418 .46088 .8464 .4527 .84305 .45048 Mtetra
.867 .626 .571 r
.84305 .45048 .8464 .4527 .8484 .44355 .84506 .44133 Mtetra
.866 .629 .578 r
.84506 .44133 .8484 .44355 .85043 .43469 .84711 .43247 Mtetra
.853 .648 .625 r
.84711 .43247 .85043 .43469 .85277 .4273 .84945 .42507 Mtetra
.807 .687 .732 r
.84945 .42507 .85277 .4273 .85563 .42228 .85231 .42005 Mtetra
.617 .708 .91 r
.85231 .42005 .85563 .42228 .85913 .42016 .85581 .41792 Mtetra
.057 .485 .89 r
.85581 .41792 .85913 .42016 .86331 .42095 .85998 .4187 Mtetra
.4 0 0 r
.85998 .4187 .86331 .42095 .86807 .42419 .86474 .42194 Mtetra
.554 0 0 r
.86474 .42194 .86807 .42419 .87325 .42903 .8699 .42677 Mtetra
.579 .022 0 r
.8699 .42677 .87325 .42903 .87857 .43429 .87521 .43202 Mtetra
.512 0 0 r
.87521 .43202 .87857 .43429 .88375 .4387 .88037 .43642 Mtetra
0 .266 .701 r
.88037 .43642 .88375 .4387 .88849 .44113 .8851 .43885 Mtetra
.314 .62 .957 r
.8851 .43885 .88849 .44113 .89259 .44077 .8892 .43848 Mtetra
.684 .51 .645 r
.43709 .83407 .44033 .83906 .44303 .83377 .43979 .82879 Mtetra
.738 .523 .602 r
.43979 .82879 .44303 .83377 .4458 .82547 .44257 .8205 Mtetra
.76 .528 .581 r
.44257 .8205 .4458 .82547 .44861 .81503 .44538 .81009 Mtetra
.767 .529 .573 r
.44538 .81009 .44861 .81503 .45142 .80369 .4482 .79878 Mtetra
.765 .528 .576 r
.4482 .79878 .45142 .80369 .4542 .79282 .45099 .78793 Mtetra
.75 .526 .592 r
.45099 .78793 .4542 .79282 .45693 .78369 .45373 .77882 Mtetra
.713 .518 .624 r
.45373 .77882 .45693 .78369 .45961 .77723 .45641 .77237 Mtetra
.619 .492 .685 r
.45641 .77237 .45961 .77723 .46223 .77393 .45902 .76907 Mtetra
.344 .384 .759 r
.45902 .76907 .46223 .77393 .4648 .77375 .46159 .76888 Mtetra
0 .069 .632 r
.46159 .76888 .4648 .77375 .46735 .77613 .46413 .77125 Mtetra
.605 .175 0 r
.46413 .77125 .46735 .77613 .4699 .78008 .46666 .77517 Mtetra
.646 .207 0 r
.46666 .77517 .4699 .78008 .47247 .78431 .46921 .77938 Mtetra
0 0 .519 r
.46921 .77938 .47247 .78431 .47507 .78749 .4718 .78254 Mtetra
.139 .285 .752 r
.4718 .78254 .47507 .78749 .47771 .78842 .47443 .78346 Mtetra
.545 .465 .716 r
.47443 .78346 .47771 .78842 .48038 .78633 .47709 .78136 Mtetra
.686 .51 .643 r
.47709 .78136 .48038 .78633 .48307 .78097 .47978 .77601 Mtetra
.739 .522 .6 r
.47978 .77601 .48307 .78097 .48577 .77274 .48248 .76779 Mtetra
.76 .526 .579 r
.48248 .76779 .48577 .77274 .48846 .76251 .48519 .75759 Mtetra
.767 .527 .571 r
.48519 .75759 .48846 .76251 .49114 .75154 .48787 .74664 Mtetra
.763 .527 .576 r
.48787 .74664 .49114 .75154 .4938 .74115 .49054 .73628 Mtetra
.745 .524 .594 r
.49054 .73628 .4938 .74115 .49644 .73257 .49319 .72772 Mtetra
.702 .515 .632 r
.49319 .72772 .49644 .73257 .49908 .72668 .49583 .72183 Mtetra
.591 .483 .699 r
.49583 .72183 .49908 .72668 .50173 .7239 .49847 .71905 Mtetra
.274 .354 .764 r
.49847 .71905 .50173 .7239 .5044 .72414 .50113 .71929 Mtetra
0 .043 .61 r
.50113 .71929 .5044 .72414 .5071 .72682 .50382 .72194 Mtetra
.593 .162 0 r
.50382 .72194 .5071 .72682 .50983 .73092 .50653 .72602 Mtetra
.612 .176 0 r
.50653 .72602 .50983 .73092 .51258 .73517 .50927 .73024 Mtetra
0 0 .56 r
.50927 .73024 .51258 .73517 .51534 .73825 .51202 .73331 Mtetra
.176 .306 .759 r
.51202 .73331 .51534 .73825 .5181 .73904 .51476 .73408 Mtetra
.552 .468 .714 r
.51476 .73408 .5181 .73904 .52083 .73681 .51749 .73185 Mtetra
.687 .51 .641 r
.51749 .73185 .52083 .73681 .52351 .73139 .52017 .72644 Mtetra
.739 .521 .598 r
.52017 .72644 .52351 .73139 .52614 .7232 .5228 .71827 Mtetra
.76 .524 .576 r
.5228 .71827 .52614 .7232 .52873 .71318 .5254 .70826 Mtetra
.766 .525 .57 r
.5254 .70826 .52873 .71318 .53128 .70254 .52796 .69765 Mtetra
.761 .525 .576 r
.52796 .69765 .53128 .70254 .53383 .6926 .53052 .68774 Mtetra
.74 .521 .597 r
.53052 .68774 .53383 .6926 .53641 .68454 .53311 .67969 Mtetra
.689 .511 .641 r
.53311 .67969 .53641 .68454 .53905 .67918 .53574 .67434 Mtetra
.557 .472 .714 r
.53574 .67434 .53905 .67918 .54175 .6769 .53844 .67205 Mtetra
.203 .322 .764 r
.53844 .67205 .54175 .6769 .54455 .67755 .54123 .67269 Mtetra
0 .025 .593 r
.54123 .67269 .54455 .67755 .54742 .6805 .54408 .67563 Mtetra
0 0 .406 r
.54408 .67563 .54742 .6805 .55035 .68475 .547 .67985 Mtetra
0 0 .409 r
.547 .67985 .55035 .68475 .55331 .68901 .54994 .68408 Mtetra
0 .03 .597 r
.54994 .68408 .55331 .68901 .55625 .692 .55287 .68706 Mtetra
.208 .324 .764 r
.55287 .68706 .55625 .692 .55913 .69265 .55574 .68769 Mtetra
.558 .471 .713 r
.55574 .68769 .55913 .69265 .56192 .69028 .55852 .68532 Mtetra
.689 .509 .639 r
.55852 .68532 .56192 .69028 .5646 .68479 .56119 .67984 Mtetra
.739 .52 .595 r
.56119 .67984 .5646 .68479 .56716 .67664 .56377 .67171 Mtetra
.76 .523 .574 r
.56377 .67171 .56716 .67664 .56965 .66679 .56626 .66188 Mtetra
.765 .523 .568 r
.56626 .66188 .56965 .66679 .5721 .65646 .56872 .65158 Mtetra
.758 .522 .576 r
.56872 .65158 .5721 .65646 .57456 .64695 .57119 .64209 Mtetra
.733 .519 .601 r
.57119 .64209 .57456 .64695 .5771 .63939 .57373 .63453 Mtetra
.673 .506 .651 r
.57373 .63453 .5771 .63939 .57975 .63454 .57638 .62969 Mtetra
.519 .459 .729 r
.57638 .62969 .57975 .63454 .58255 .63272 .57917 .62787 Mtetra
.132 .291 .759 r
.57917 .62787 .58255 .63272 .58549 .63376 .58211 .6289 Mtetra
0 .014 .582 r
.58211 .6289 .58549 .63376 .58857 .63699 .58517 .63211 Mtetra
0 0 .428 r
.58517 .63211 .58857 .63699 .59173 .64138 .58831 .63646 Mtetra
0 0 .448 r
.58831 .63646 .59173 .64138 .59492 .64565 .59148 .64071 Mtetra
0 .069 .631 r
.59148 .64071 .59492 .64565 .59805 .64856 .59459 .6436 Mtetra
.236 .34 .767 r
.59459 .6436 .59805 .64856 .60107 .64906 .5976 .64409 Mtetra
.563 .473 .711 r
.5976 .64409 .60107 .64906 .60392 .64655 .60045 .64157 Mtetra
.69 .508 .637 r
.60045 .64157 .60392 .64655 .60659 .64098 .60312 .63601 Mtetra
.74 .518 .593 r
.60312 .63601 .60659 .64098 .60909 .63286 .60563 .62791 Mtetra
.76 .521 .571 r
.60563 .62791 .60909 .63286 .61148 .62317 .60802 .61824 Mtetra
.764 .521 .566 r
.60802 .61824 .61148 .62317 .61383 .61313 .61038 .60823 Mtetra
.755 .52 .577 r
.61038 .60823 .61383 .61313 .61622 .60402 .61278 .59914 Mtetra
.726 .516 .606 r
.61278 .59914 .61622 .60402 .61874 .59692 .6153 .59205 Mtetra
.655 .501 .662 r
.6153 .59205 .61874 .59692 .62144 .59256 .618 .58769 Mtetra
.475 .443 .743 r
.618 .58769 .62144 .59256 .62436 .5912 .62091 .58633 Mtetra
.067 .26 .751 r
.62091 .58633 .62436 .5912 .6275 .59262 .62404 .58773 Mtetra
0 .01 .577 r
.62404 .58773 .6275 .59262 .63081 .59611 .62734 .5912 Mtetra
0 0 .452 r
.62734 .5912 .63081 .59611 .63423 .60063 .63074 .59569 Mtetra
0 0 .487 r
.63074 .59569 .63423 .60063 .63767 .60492 .63415 .59996 Mtetra
0 .105 .66 r
.63415 .59996 .63767 .60492 .64101 .60774 .63747 .60275 Mtetra
.262 .354 .77 r
.63747 .60275 .64101 .60774 .64417 .6081 .64062 .6031 Mtetra
.568 .474 .709 r
.64062 .6031 .64417 .6081 .64709 .60545 .64354 .60045 Mtetra
.691 .508 .635 r
.64354 .60045 .64709 .60545 .64976 .59979 .64621 .5948 Mtetra
.74 .516 .59 r
.64621 .5948 .64976 .59979 .6522 .59169 .64866 .58671 Mtetra
.76 .518 .568 r
.64866 .58671 .6522 .59169 .6545 .58214 .65097 .57718 Mtetra
.763 .519 .565 r
.65097 .57718 .6545 .58214 .65677 .57237 .65324 .56744 Mtetra
.751 .518 .578 r
.65324 .56744 .65677 .57237 .65911 .56364 .65558 .55873 Mtetra
.717 .513 .613 r
.65558 .55873 .65911 .56364 .66163 .55698 .65811 .55209 Mtetra
.634 .495 .675 r
.65811 .55209 .66163 .55698 .66441 .55309 .66089 .54819 Mtetra
.427 .426 .755 r
.66089 .54819 .66441 .55309 .66749 .55217 .66396 .54727 Mtetra
.01 .234 .741 r
.66396 .54727 .66749 .55217 .67085 .55396 .66731 .54903 Mtetra
0 .012 .577 r
.66731 .54903 .67085 .55396 .67444 .55772 .67088 .55277 Mtetra
0 0 .479 r
.67088 .55277 .67444 .55772 .67815 .56237 .67457 .55739 Mtetra
0 0 .524 r
.67457 .55739 .67815 .56237 .68186 .56668 .67825 .56167 Mtetra
0 .138 .685 r
.67825 .56167 .68186 .56668 .68543 .56941 .6818 .56439 Mtetra
.285 .366 .771 r
.6818 .56439 .68543 .56941 .68874 .56963 .68511 .56459 Mtetra
.572 .476 .707 r
.68511 .56459 .68874 .56963 .69174 .56683 .6881 .56179 Mtetra
.691 .506 .632 r
.6881 .56179 .69174 .56683 .6944 .56108 .69076 .55605 Mtetra
.74 .514 .587 r
.69076 .55605 .6944 .56108 .69679 .55298 .69316 .54797 Mtetra
.759 .516 .566 r
.69316 .54797 .69679 .55298 .69901 .54355 .69538 .53856 Mtetra
.761 .516 .564 r
.69538 .53856 .69901 .54355 .7012 .53404 .69758 .52907 Mtetra
.746 .515 .58 r
.69758 .52907 .7012 .53404 .70351 .52566 .69989 .52071 Mtetra
.706 .509 .62 r
.69989 .52071 .70351 .52566 .70606 .51944 .70245 .5145 Mtetra
.609 .487 .689 r
.70245 .5145 .70606 .51944 .70896 .516 .70535 .51106 Mtetra
.375 .407 .766 r
.70535 .51106 .70896 .516 .71224 .51551 .70861 .51056 Mtetra
0 .212 .731 r
.70861 .51056 .71224 .51551 .71587 .51766 .71223 .51269 Mtetra
0 .019 .582 r
.71223 .51269 .71587 .51766 .71977 .52168 .71611 .51668 Mtetra
0 0 .506 r
.71611 .51668 .71977 .52168 .72381 .52647 .72013 .52144 Mtetra
0 0 .56 r
.72013 .52144 .72381 .52647 .72782 .5308 .72411 .52574 Mtetra
0 .169 .706 r
.72411 .52574 .72782 .5308 .73164 .53345 .72791 .52837 Mtetra
.305 .377 .772 r
.72791 .52837 .73164 .53345 .73512 .53353 .73139 .52843 Mtetra
.576 .476 .705 r
.73139 .52843 .73512 .53353 .7382 .53058 .73446 .52548 Mtetra
.692 .505 .63 r
.73446 .52548 .7382 .53058 .74087 .52472 .73713 .51964 Mtetra
.74 .512 .584 r
.73713 .51964 .74087 .52472 .7432 .51661 .73947 .51154 Mtetra
.758 .514 .563 r
.73947 .51154 .7432 .51661 .74534 .50729 .74162 .50224 Mtetra
.74162 .50224 .74534 .50729 .74747 .49801 .74375 .49298 Mtetra
.741 .512 .583 r
.74375 .49298 .74747 .49801 .74976 .48997 .74605 .48497 Mtetra
.693 .506 .629 r
.74605 .48497 .74976 .48997 .75239 .48416 .74867 .47917 Mtetra
.58 .479 .704 r
.74867 .47917 .75239 .48416 .75544 .48116 .75172 .47617 Mtetra
.322 .386 .773 r
.75172 .47617 .75544 .48116 .75896 .4811 .75523 .47609 Mtetra
0 .195 .722 r
.75523 .47609 .75896 .4811 .76291 .48361 .75916 .47858 Mtetra
0 .029 .59 r
.75916 .47858 .76291 .48361 .76717 .48789 .7634 .48283 Mtetra
0 0 .535 r
.7634 .48283 .76717 .48789 .77158 .49283 .76778 .48774 Mtetra
0 .031 .593 r
.76778 .48774 .77158 .49283 .77593 .49718 .77211 .49205 Mtetra
0 .197 .724 r
.77211 .49205 .77593 .49718 .78002 .49975 .77618 .4946 Mtetra
.322 .386 .772 r
.77618 .4946 .78002 .49975 .78369 .49968 .77984 .49452 Mtetra
.579 .477 .703 r
.77984 .49452 .78369 .49968 .78686 .49658 .783 .49141 Mtetra
.692 .503 .627 r
.783 .49141 .78686 .49658 .78953 .49061 .78567 .48546 Mtetra
.74 .51 .581 r
.78567 .48546 .78953 .49061 .79181 .48247 .78796 .47734 Mtetra
.757 .511 .56 r
.78796 .47734 .79181 .48247 .79388 .47324 .79004 .46813 Mtetra
.755 .511 .562 r
.79004 .46813 .79388 .47324 .79596 .46418 .79213 .45909 Mtetra
.734 .509 .587 r
.79213 .45909 .79596 .46418 .79827 .45647 .79444 .4514 Mtetra
.679 .501 .639 r
.79444 .4514 .79827 .45647 .80099 .45106 .79716 .44599 Mtetra
.547 .469 .719 r
.79716 .44599 .80099 .45106 .80424 .4485 .8004 .44343 Mtetra
.269 .366 .778 r
.8004 .44343 .80424 .4485 .80805 .44886 .8042 .44377 Mtetra
0 .183 .716 r
.8042 .44377 .80805 .44886 .81237 .45173 .8085 .44662 Mtetra
0 .043 .602 r
.8085 .44662 .81237 .45173 .81705 .45628 .81316 .45113 Mtetra
0 .004 .563 r
.81316 .45113 .81705 .45628 .82188 .46137 .81796 .45619 Mtetra
0 .065 .623 r
.81796 .45619 .82188 .46137 .82661 .46574 .82267 .46053 Mtetra
0 .222 .739 r
.82267 .46053 .82661 .46574 .83101 .46824 .82704 .463 Mtetra
.338 .393 .772 r
.82704 .463 .83101 .46824 .83488 .46802 .8309 .46277 Mtetra
.581 .477 .7 r
.8309 .46277 .83488 .46802 .83814 .46475 .83415 .45951 Mtetra
.692 .502 .624 r
.83415 .45951 .83814 .46475 .84082 .45866 .83683 .45342 Mtetra
.739 .507 .578 r
.83683 .45342 .84082 .45866 .84305 .45048 .83907 .44527 Mtetra
.756 .508 .558 r
.83907 .44527 .84305 .45048 .84506 .44133 .84109 .43614 Mtetra
.752 .508 .562 r
.84109 .43614 .84506 .44133 .84711 .43247 .84314 .42729 Mtetra
.726 .506 .592 r
.84314 .42729 .84711 .43247 .84945 .42507 .8455 .41991 Mtetra
.661 .496 .651 r
.8455 .41991 .84945 .42507 .85231 .42005 .84835 .4149 Mtetra
.511 .458 .733 r
.84835 .4149 .85231 .42005 .85581 .41792 .85184 .41276 Mtetra
.219 .345 .78 r
.85184 .41276 .85581 .41792 .85998 .4187 .856 .41353 Mtetra
0 .176 .712 r
.856 .41353 .85998 .4187 .86474 .42194 .86073 .41674 Mtetra
0 .059 .616 r
.86073 .41674 .86474 .42194 .8699 .42677 .86586 .42153 Mtetra
0 .033 .591 r
.86586 .42153 .8699 .42677 .87521 .43202 .87114 .42674 Mtetra
0 .097 .651 r
.87114 .42674 .87521 .43202 .88037 .43642 .87627 .43112 Mtetra
.009 .245 .751 r
.87627 .43112 .88037 .43642 .8851 .43885 .88098 .43351 Mtetra
.352 .4 .772 r
.88098 .43351 .8851 .43885 .8892 .43848 .88507 .43314 Mtetra
.613 .426 .605 r
.43394 .8262 .43709 .83407 .43979 .82879 .43664 .82093 Mtetra
.677 .457 .581 r
.43664 .82093 .43979 .82879 .44257 .8205 .43941 .81268 Mtetra
.706 .471 .567 r
.43941 .81268 .44257 .8205 .44538 .81009 .44223 .80232 Mtetra
.716 .476 .561 r
.44223 .80232 .44538 .81009 .4482 .79878 .44506 .79106 Mtetra
.712 .474 .563 r
.44506 .79106 .4482 .79878 .45099 .78793 .44785 .78026 Mtetra
.692 .465 .574 r
.44785 .78026 .45099 .78793 .45373 .77882 .45059 .77119 Mtetra
.646 .443 .594 r
.45059 .77119 .45373 .77882 .45641 .77237 .45327 .76476 Mtetra
.548 .394 .625 r
.45327 .76476 .45641 .77237 .45902 .76907 .45587 .76147 Mtetra
.339 .285 .65 r
.45587 .76147 .45902 .76907 .46159 .76888 .45843 .76127 Mtetra
0 .088 .606 r
.45843 .76127 .46159 .76888 .46413 .77125 .46095 .7636 Mtetra
0 0 .501 r
.46095 .7636 .46413 .77125 .46666 .77517 .46347 .76748 Mtetra
0 0 .477 r
.46347 .76748 .46666 .77517 .46921 .77938 .466 .77166 Mtetra
0 .009 .566 r
.466 .77166 .46921 .77938 .4718 .78254 .46857 .77477 Mtetra
.216 .217 .645 r
.46857 .77477 .4718 .78254 .47443 .78346 .47118 .77567 Mtetra
.482 .36 .636 r
.47118 .77567 .47443 .78346 .47709 .78136 .47384 .77357 Mtetra
.614 .426 .604 r
.47384 .77357 .47709 .78136 .47978 .77601 .47652 .76824 Mtetra
.676 .455 .578 r
.47652 .76824 .47978 .77601 .48248 .76779 .47923 .76006 Mtetra
.704 .468 .564 r
.47923 .76006 .48248 .76779 .48519 .75759 .48193 .7499 Mtetra
.714 .473 .559 r
.48193 .7499 .48519 .75759 .48787 .74664 .48462 .739 Mtetra
.708 .47 .562 r
.48462 .739 .48787 .74664 .49054 .73628 .4873 .72869 Mtetra
.685 .459 .575 r
.4873 .72869 .49054 .73628 .49319 .72772 .48995 .72016 Mtetra
.632 .435 .598 r
.48995 .72016 .49319 .72772 .49583 .72183 .49259 .7143 Mtetra
.522 .382 .631 r
.49259 .7143 .49583 .72183 .49847 .71905 .49522 .71152 Mtetra
.296 .264 .653 r
.49522 .71152 .49847 .71905 .50113 .71929 .49787 .71174 Mtetra
0 .072 .602 r
.49787 .71174 .50113 .71929 .50382 .72194 .50054 .71436 Mtetra
0 0 .508 r
.50054 .71436 .50382 .72194 .50653 .72602 .50323 .71839 Mtetra
0 0 .498 r
.50323 .71839 .50653 .72602 .50927 .73024 .50595 .72258 Mtetra
0 .037 .585 r
.50595 .72258 .50927 .73024 .51202 .73331 .50868 .72561 Mtetra
.236 .232 .65 r
.50868 .72561 .51202 .73331 .51476 .73408 .51141 .72636 Mtetra
.488 .363 .636 r
.51141 .72636 .51476 .73408 .51749 .73185 .51412 .72412 Mtetra
.615 .425 .602 r
.51412 .72412 .51749 .73185 .52017 .72644 .5168 .71873 Mtetra
.675 .453 .576 r
.5168 .71873 .52017 .72644 .5228 .71827 .51944 .7106 Mtetra
.703 .465 .561 r
.51944 .7106 .5228 .71827 .5254 .70826 .52203 .70064 Mtetra
.711 .469 .557 r
.52203 .70064 .5254 .70826 .52796 .69765 .52461 .69007 Mtetra
.703 .465 .561 r
.52461 .69007 .52796 .69765 .53052 .68774 .52717 .68021 Mtetra
.676 .454 .576 r
.52717 .68021 .53052 .68774 .53311 .67969 .52976 .67219 Mtetra
.617 .427 .602 r
.52976 .67219 .53311 .67969 .53574 .67434 .53239 .66686 Mtetra
.494 .368 .638 r
.53239 .66686 .53574 .67434 .53844 .67205 .53508 .66457 Mtetra
.252 .244 .656 r
.53508 .66457 .53844 .67205 .54123 .67269 .53785 .66519 Mtetra
0 .06 .6 r
.53785 .66519 .54123 .67269 .54408 .67563 .54069 .66809 Mtetra
0 0 .518 r
.54069 .66809 .54408 .67563 .547 .67985 .54358 .67227 Mtetra
0 0 .519 r
.54358 .67227 .547 .67985 .54994 .68408 .5465 .67646 Mtetra
0 .063 .601 r
.5465 .67646 .54994 .68408 .55287 .68706 .54941 .6794 Mtetra
.255 .245 .655 r
.54941 .6794 .55287 .68706 .55574 .68769 .55226 .68001 Mtetra
.493 .366 .636 r
.55226 .68001 .55574 .68769 .55852 .68532 .55503 .67763 Mtetra
.616 .424 .6 r
.55503 .67763 .55852 .68532 .56119 .67984 .55771 .67217 Mtetra
.674 .451 .573 r
.55771 .67217 .56119 .67984 .56377 .67171 .56028 .66408 Mtetra
.701 .462 .559 r
.56028 .66408 .56377 .67171 .56626 .66188 .56278 .65429 Mtetra
.708 .465 .555 r
.56278 .65429 .56626 .66188 .56872 .65158 .56524 .64404 Mtetra
.698 .461 .561 r
.56524 .64404 .56872 .65158 .57119 .64209 .56772 .63459 Mtetra
.667 .448 .578 r
.56772 .63459 .57119 .64209 .57373 .63453 .57026 .62707 Mtetra
.6 .418 .607 r
.57026 .62707 .57373 .63453 .57638 .62969 .5729 .62224 Mtetra
.463 .354 .644 r
.5729 .62224 .57638 .62969 .57917 .62787 .57568 .62042 Mtetra
.209 .225 .657 r
.57568 .62042 .57917 .62787 .58211 .6289 .5786 .62142 Mtetra
0 .052 .599 r
.5786 .62142 .58211 .6289 .58517 .63211 .58164 .62459 Mtetra
0 0 .529 r
.58164 .62459 .58517 .63211 .58831 .63646 .58476 .6289 Mtetra
0 0 .54 r
.58476 .6289 .58831 .63646 .59148 .64071 .58791 .63311 Mtetra
0 .088 .617 r
.58791 .63311 .59148 .64071 .59459 .6436 .591 .63596 Mtetra
.272 .257 .659 r
.591 .63596 .59459 .6436 .5976 .64409 .59399 .63643 Mtetra
.498 .369 .635 r
.59399 .63643 .5976 .64409 .60045 .64157 .59683 .63391 Mtetra
.616 .423 .598 r
.59683 .63391 .60045 .64157 .60312 .63601 .59949 .62837 Mtetra
.673 .448 .571 r
.59949 .62837 .60312 .63601 .60563 .62791 .60201 .6203 Mtetra
.699 .458 .556 r
.60201 .6203 .60563 .62791 .60802 .61824 .60441 .61068 Mtetra
.704 .46 .553 r
.60441 .61068 .60802 .61824 .61038 .60823 .60677 .60071 Mtetra
.692 .455 .56 r
.60677 .60071 .61038 .60823 .61278 .59914 .60918 .59166 Mtetra
.657 .441 .58 r
.60918 .59166 .61278 .59914 .6153 .59205 .6117 .5846 Mtetra
.581 .409 .613 r
.6117 .5846 .6153 .59205 .618 .58769 .61439 .58025 Mtetra
.43 .339 .651 r
.61439 .58025 .618 .58769 .62091 .58633 .61729 .57888 Mtetra
.169 .207 .658 r
.61729 .57888 .62091 .58633 .62404 .58773 .6204 .58026 Mtetra
0 .049 .6 r
.6204 .58026 .62404 .58773 .62734 .5912 .62367 .58369 Mtetra
0 0 .543 r
.62367 .58369 .62734 .5912 .63074 .59569 .62705 .58813 Mtetra
0 0 .56 r
.62705 .58813 .63074 .59569 .63415 .59996 .63043 .59235 Mtetra
0 .111 .63 r
.63043 .59235 .63415 .59996 .63747 .60275 .63374 .59511 Mtetra
.288 .268 .662 r
.63374 .59511 .63747 .60275 .64062 .6031 .63687 .59544 Mtetra
.502 .371 .635 r
.63687 .59544 .64062 .6031 .64354 .60045 .63978 .59279 Mtetra
.616 .422 .596 r
.63978 .59279 .64354 .60045 .64621 .5948 .64244 .58716 Mtetra
.672 .445 .568 r
.64244 .58716 .64621 .5948 .64866 .58671 .64489 .57911 Mtetra
.696 .454 .553 r
.64489 .57911 .64866 .58671 .65097 .57718 .64721 .56962 Mtetra
.7 .456 .551 r
.64721 .56962 .65097 .57718 .65324 .56744 .64949 .55992 Mtetra
.685 .45 .56 r
.64949 .55992 .65324 .56744 .65558 .55873 .65184 .55125 Mtetra
.645 .434 .583 r
.65184 .55125 .65558 .55873 .65811 .55209 .65436 .54463 Mtetra
.56 .399 .619 r
.65436 .54463 .65811 .55209 .66089 .54819 .65713 .54075 Mtetra
.396 .324 .657 r
.65713 .54075 .66089 .54819 .66396 .54727 .66019 .53981 Mtetra
.132 .192 .659 r
.66019 .53981 .66396 .54727 .66731 .54903 .66352 .54155 Mtetra
0 .049 .603 r
.66352 .54155 .66731 .54903 .67088 .55277 .66706 .54524 Mtetra
0 0 .557 r
.66706 .54524 .67088 .55277 .67457 .55739 .67072 .54982 Mtetra
0 .011 .58 r
.67072 .54982 .67457 .55739 .67825 .56167 .67438 .55405 Mtetra
.021 .133 .642 r
.67438 .55405 .67825 .56167 .6818 .56439 .67791 .55672 Mtetra
.302 .277 .664 r
.67791 .55672 .6818 .56439 .68511 .56459 .68119 .55691 Mtetra
.505 .372 .634 r
.68119 .55691 .68511 .56459 .6881 .56179 .68417 .55411 Mtetra
.616 .42 .594 r
.68417 .55411 .6881 .56179 .69076 .55605 .68684 .54839 Mtetra
.67 .441 .565 r
.68684 .54839 .69076 .55605 .69316 .54797 .68923 .54034 Mtetra
.693 .45 .55 r
.68923 .54034 .69316 .54797 .69538 .53856 .69147 .53098 Mtetra
.695 .451 .549 r
.69147 .53098 .69538 .53856 .69758 .52907 .69367 .52153 Mtetra
.678 .444 .561 r
.69367 .52153 .69758 .52907 .69989 .52071 .69599 .51321 Mtetra
.632 .427 .586 r
.69599 .51321 .69989 .52071 .70245 .5145 .69855 .50702 Mtetra
.538 .388 .626 r
.69855 .50702 .70245 .5145 .70535 .51106 .70143 .50358 Mtetra
.361 .309 .663 r
.70143 .50358 .70535 .51106 .70861 .51056 .70468 .50307 Mtetra
.1 .179 .66 r
.70468 .50307 .70861 .51056 .71223 .51269 .70827 .50516 Mtetra
0 .053 .607 r
.70827 .50516 .71223 .51269 .71611 .51668 .71213 .50911 Mtetra
0 0 .573 r
.71213 .50911 .71611 .51668 .72013 .52144 .71611 .51383 Mtetra
0 .037 .598 r
.71611 .51383 .72013 .52144 .72411 .52574 .72007 .51807 Mtetra
.049 .153 .652 r
.72007 .51807 .72411 .52574 .72791 .52837 .72384 .52067 Mtetra
.315 .286 .666 r
.72384 .52067 .72791 .52837 .73139 .52843 .7273 .52071 Mtetra
.508 .373 .632 r
.7273 .52071 .73139 .52843 .73446 .52548 .73036 .51776 Mtetra
.615 .417 .591 r
.73036 .51776 .73446 .52548 .73713 .51964 .73302 .51193 Mtetra
.668 .437 .562 r
.73302 .51193 .73713 .51964 .73947 .51154 .73537 .50387 Mtetra
.69 .445 .547 r
.73537 .50387 .73947 .51154 .74162 .50224 .73752 .49462 Mtetra
.73752 .49462 .74162 .50224 .74375 .49298 .73967 .48541 Mtetra
.669 .438 .561 r
.73967 .48541 .74375 .49298 .74605 .48497 .74197 .47742 Mtetra
.617 .419 .591 r
.74197 .47742 .74605 .48497 .74867 .47917 .74459 .47164 Mtetra
.513 .377 .633 r
.74459 .47164 .74867 .47917 .75172 .47617 .74762 .46864 Mtetra
.326 .294 .669 r
.74762 .46864 .75172 .47617 .75523 .47609 .75111 .46855 Mtetra
.072 .17 .661 r
.75111 .46855 .75523 .47609 .75916 .47858 .75502 .471 Mtetra
0 .06 .614 r
.75502 .471 .75916 .47858 .7634 .48283 .75923 .4752 Mtetra
0 .019 .588 r
.75923 .4752 .7634 .48283 .76778 .48774 .76358 .48006 Mtetra
0 .061 .615 r
.76358 .48006 .76778 .48774 .77211 .49205 .76787 .48432 Mtetra
.076 .171 .661 r
.76787 .48432 .77211 .49205 .77618 .4946 .77192 .48683 Mtetra
.326 .293 .668 r
.77192 .48683 .77618 .4946 .77984 .49452 .77555 .48673 Mtetra
.51 .374 .631 r
.77555 .48673 .77984 .49452 .783 .49141 .7787 .48363 Mtetra
.614 .415 .588 r
.7787 .48363 .783 .49141 .78567 .48546 .78137 .47769 Mtetra
.666 .433 .558 r
.78137 .47769 .78567 .48546 .78796 .47734 .78366 .46961 Mtetra
.686 .44 .544 r
.78366 .46961 .78796 .47734 .79004 .46813 .78575 .46045 Mtetra
.684 .44 .546 r
.78575 .46045 .79004 .46813 .79213 .45909 .78784 .45145 Mtetra
.659 .431 .563 r
.78784 .45145 .79213 .45909 .79444 .4514 .79016 .44379 Mtetra
.601 .41 .596 r
.79016 .44379 .79444 .4514 .79716 .44599 .79288 .4384 Mtetra
.486 .365 .64 r
.79288 .4384 .79716 .44599 .8004 .44343 .79611 .43583 Mtetra
.292 .28 .674 r
.79611 .43583 .8004 .44343 .8042 .44377 .79988 .43615 Mtetra
.05 .164 .663 r
.79988 .43615 .8042 .44377 .8085 .44662 .80415 .43896 Mtetra
0 .069 .622 r
.80415 .43896 .8085 .44662 .81316 .45113 .80878 .44342 Mtetra
0 .04 .604 r
.80878 .44342 .81316 .45113 .81796 .45619 .81354 .44842 Mtetra
0 .085 .631 r
.81354 .44842 .81796 .45619 .82267 .46053 .81821 .45271 Mtetra
.1 .188 .669 r
.81821 .45271 .82267 .46053 .82704 .463 .82255 .45514 Mtetra
.337 .299 .669 r
.82255 .45514 .82704 .463 .8309 .46277 .82639 .4549 Mtetra
.512 .374 .629 r
.82639 .4549 .8309 .46277 .83415 .45951 .82964 .45163 Mtetra
.613 .411 .585 r
.82964 .45163 .83415 .45951 .83683 .45342 .83231 .44557 Mtetra
.663 .429 .555 r
.83231 .44557 .83683 .45342 .83907 .44527 .83456 .43745 Mtetra
.682 .435 .541 r
.83456 .43745 .83907 .44527 .84109 .43614 .83658 .42837 Mtetra
.678 .433 .545 r
.83658 .42837 .84109 .43614 .84314 .42729 .83864 .41956 Mtetra
.648 .424 .565 r
.83864 .41956 .84314 .42729 .8455 .41991 .841 .41221 Mtetra
.582 .401 .602 r
.841 .41221 .8455 .41991 .84835 .4149 .84385 .40722 Mtetra
.458 .353 .648 r
.84385 .40722 .84835 .4149 .85184 .41276 .84732 .40507 Mtetra
.259 .268 .679 r
.84732 .40507 .85184 .41276 .856 .41353 .85145 .40581 Mtetra
.033 .16 .666 r
.85145 .40581 .856 .41353 .86073 .41674 .85615 .40898 Mtetra
0 .08 .631 r
.85615 .40898 .86073 .41674 .86586 .42153 .86125 .41371 Mtetra
0 .061 .619 r
.86125 .41371 .86586 .42153 .87114 .42674 .86648 .41886 Mtetra
0 .108 .645 r
.86648 .41886 .87114 .42674 .87627 .43112 .87158 .42318 Mtetra
.123 .204 .676 r
.87158 .42318 .87627 .43112 .88098 .43351 .87625 .42554 Mtetra
.346 .305 .669 r
.87625 .42554 .88098 .43351 .88507 .43314 .88031 .42514 Mtetra
.577 .385 .584 r
.43087 .8164 .43394 .8262 .43664 .82093 .43356 .81116 Mtetra
.643 .422 .568 r
.43356 .81116 .43664 .82093 .43941 .81268 .43633 .80296 Mtetra
.675 .439 .557 r
.43633 .80296 .43941 .81268 .44223 .80232 .43915 .79265 Mtetra
.686 .446 .553 r
.43915 .79265 .44223 .80232 .44506 .79106 .44197 .78146 Mtetra
.682 .443 .555 r
.44197 .78146 .44506 .79106 .44785 .78026 .44477 .77074 Mtetra
.659 .431 .563 r
.44477 .77074 .44785 .78026 .45059 .77119 .44751 .76172 Mtetra
.61 .404 .577 r
.44751 .76172 .45059 .77119 .45327 .76476 .45018 .75532 Mtetra
.514 .35 .596 r
.45018 .75532 .45327 .76476 .45587 .76147 .45278 .75203 Mtetra
.335 .247 .606 r
.45278 .75203 .45587 .76147 .45843 .76127 .45532 .75181 Mtetra
.069 .091 .575 r
.45532 .75181 .45843 .76127 .46095 .7636 .45782 .75411 Mtetra
0 0 .512 r
.45782 .75411 .46095 .7636 .46347 .76748 .46032 .75794 Mtetra
0 0 .498 r
.46032 .75794 .46347 .76748 .466 .77166 .46283 .76206 Mtetra
0 .031 .551 r
.46283 .76206 .466 .77166 .46857 .77477 .46538 .76514 Mtetra
.239 .191 .6 r
.46538 .76514 .46857 .77477 .47118 .77567 .46798 .766 Mtetra
.455 .315 .601 r
.46798 .766 .47118 .77567 .47384 .77357 .47062 .7639 Mtetra
.578 .384 .583 r
.47062 .7639 .47384 .77357 .47652 .76824 .4733 .7586 Mtetra
.642 .419 .565 r
.4733 .7586 .47652 .76824 .47923 .76006 .476 .75046 Mtetra
.672 .436 .555 r
.476 .75046 .47923 .76006 .48193 .7499 .47871 .74037 Mtetra
.683 .441 .551 r
.47871 .74037 .48193 .7499 .48462 .739 .4814 .72953 Mtetra
.676 .438 .553 r
.4814 .72953 .48462 .739 .4873 .72869 .48408 .71928 Mtetra
.651 .424 .563 r
.48408 .71928 .4873 .72869 .48995 .72016 .48673 .71081 Mtetra
.596 .395 .579 r
.48673 .71081 .48995 .72016 .49259 .7143 .48936 .70497 Mtetra
.49 .337 .6 r
.48936 .70497 .49259 .7143 .49522 .71152 .49199 .70219 Mtetra
.3 .23 .608 r
.49199 .70219 .49522 .71152 .49787 .71174 .49462 .70239 Mtetra
.039 .079 .575 r
.49462 .70239 .49787 .71174 .50054 .71436 .49727 .70497 Mtetra
0 0 .519 r
.49727 .70497 .50054 .71436 .50323 .71839 .49994 .70895 Mtetra
0 0 .513 r
.49994 .70895 .50323 .71839 .50595 .72258 .50263 .71308 Mtetra
0 .052 .564 r
.50263 .71308 .50595 .72258 .50868 .72561 .50534 .71606 Mtetra
.254 .203 .605 r
.50534 .71606 .50868 .72561 .51141 .72636 .50805 .71679 Mtetra
.46 .319 .602 r
.50805 .71679 .51141 .72636 .51412 .72412 .51075 .71455 Mtetra
.579 .384 .581 r
.51075 .71455 .51412 .72412 .5168 .71873 .51343 .70918 Mtetra
.64 .417 .563 r
.51343 .70918 .5168 .71873 .51944 .7106 .51606 .7011 Mtetra
.67 .432 .552 r
.51606 .7011 .51944 .7106 .52203 .70064 .51866 .6912 Mtetra
.679 .437 .548 r
.51866 .6912 .52203 .70064 .52461 .69007 .52124 .6807 Mtetra
.671 .433 .552 r
.52124 .6807 .52461 .69007 .52717 .68021 .5238 .67089 Mtetra
.642 .417 .563 r
.5238 .67089 .52717 .68021 .52976 .67219 .52639 .66293 Mtetra
.581 .386 .581 r
.52639 .66293 .52976 .67219 .53239 .66686 .52901 .65761 Mtetra
.465 .323 .603 r
.52901 .65761 .53239 .66686 .53508 .66457 .53169 .65532 Mtetra
.266 .213 .61 r
.53169 .65532 .53508 .66457 .53785 .66519 .53444 .65591 Mtetra
.014 .069 .575 r
.53444 .65591 .53785 .66519 .54069 .66809 .53726 .65877 Mtetra
0 0 .527 r
.53726 .65877 .54069 .66809 .54358 .67227 .54013 .66289 Mtetra
0 0 .528 r
.54013 .66289 .54358 .67227 .5465 .67646 .54302 .66703 Mtetra
.019 .072 .576 r
.54302 .66703 .5465 .67646 .54941 .6794 .54591 .66993 Mtetra
.269 .214 .61 r
.54591 .66993 .54941 .6794 .55226 .68001 .54875 .67051 Mtetra
.465 .322 .602 r
.54875 .67051 .55226 .68001 .55503 .67763 .55151 .66814 Mtetra
.579 .383 .579 r
.55151 .66814 .55503 .67763 .55771 .67217 .55417 .6627 Mtetra
.639 .414 .56 r
.55417 .6627 .55771 .67217 .56028 .66408 .55674 .65465 Mtetra
.667 .428 .549 r
.55674 .65465 .56028 .66408 .56278 .65429 .55924 .64492 Mtetra
.675 .432 .546 r
.55924 .64492 .56278 .65429 .56524 .64404 .56171 .63473 Mtetra
.664 .427 .551 r
.56171 .63473 .56524 .64404 .56772 .63459 .56419 .62535 Mtetra
.631 .41 .563 r
.56419 .62535 .56772 .63459 .57026 .62707 .56673 .61786 Mtetra
.564 .376 .584 r
.56673 .61786 .57026 .62707 .5729 .62224 .56937 .61305 Mtetra
.438 .31 .607 r
.56937 .61305 .5729 .62224 .57568 .62042 .57214 .61122 Mtetra
.233 .198 .612 r
.57214 .61122 .57568 .62042 .5786 .62142 .57504 .6122 Mtetra
0 .063 .577 r
.57504 .6122 .5786 .62142 .58164 .62459 .57805 .61532 Mtetra
0 0 .536 r
.57805 .61532 .58164 .62459 .58476 .6289 .58115 .61958 Mtetra
0 0 .543 r
.58115 .61958 .58476 .6289 .58791 .63311 .58426 .62373 Mtetra
.043 .091 .587 r
.58426 .62373 .58791 .63311 .591 .63596 .58733 .62653 Mtetra
.282 .224 .613 r
.58733 .62653 .591 .63596 .59399 .63643 .5903 .62697 Mtetra
.469 .324 .602 r
.5903 .62697 .59399 .63643 .59683 .63391 .59313 .62446 Mtetra
.579 .381 .577 r
.59313 .62446 .59683 .63391 .59949 .62837 .59579 .61894 Mtetra
.637 .411 .558 r
.59579 .61894 .59949 .62837 .60201 .6203 .5983 .61092 Mtetra
.664 .424 .546 r
.5983 .61092 .60201 .6203 .60441 .61068 .60071 .60136 Mtetra
.67 .427 .544 r
.60071 .60136 .60441 .61068 .60677 .60071 .60307 .59145 Mtetra
.657 .42 .55 r
.60307 .59145 .60677 .60071 .60918 .59166 .60548 .58246 Mtetra
.62 .402 .565 r
.60548 .58246 .60918 .59166 .6117 .5846 .608 .57544 Mtetra
.546 .365 .588 r
.608 .57544 .6117 .5846 .61439 .58025 .61068 .5711 Mtetra
.411 .296 .612 r
.61068 .5711 .61439 .58025 .61729 .57888 .61357 .56972 Mtetra
.202 .184 .614 r
.61357 .56972 .61729 .57888 .6204 .58026 .61665 .57106 Mtetra
0 .061 .58 r
.61665 .57106 .6204 .58026 .62367 .58369 .6199 .57444 Mtetra
0 0 .547 r
.6199 .57444 .62367 .58369 .62705 .58813 .62325 .57883 Mtetra
0 .011 .557 r
.62325 .57883 .62705 .58813 .63043 .59235 .6266 .58299 Mtetra
.066 .109 .598 r
.6266 .58299 .63043 .59235 .63374 .59511 .62988 .58571 Mtetra
.294 .233 .617 r
.62988 .58571 .63374 .59511 .63687 .59544 .63299 .58601 Mtetra
.472 .326 .601 r
.63299 .58601 .63687 .59544 .63978 .59279 .63589 .58336 Mtetra
.579 .38 .575 r
.63589 .58336 .63978 .59279 .64244 .58716 .63854 .57775 Mtetra
.635 .407 .555 r
.63854 .57775 .64244 .58716 .64489 .57911 .641 .56975 Mtetra
.661 .419 .543 r
.641 .56975 .64489 .57911 .64721 .56962 .64332 .56032 Mtetra
.665 .421 .541 r
.64332 .56032 .64721 .56962 .64949 .55992 .6456 .55068 Mtetra
.649 .414 .549 r
.6456 .55068 .64949 .55992 .65184 .55125 .64795 .54206 Mtetra
.607 .394 .566 r
.64795 .54206 .65184 .55125 .65436 .54463 .65047 .53548 Mtetra
.526 .354 .591 r
.65047 .53548 .65436 .54463 .65713 .54075 .65324 .53161 Mtetra
.382 .282 .616 r
.65324 .53161 .65713 .54075 .66019 .53981 .65627 .53065 Mtetra
.173 .173 .617 r
.65627 .53065 .66019 .53981 .66352 .54155 .65958 .53235 Mtetra
0 .061 .585 r
.65958 .53235 .66352 .54155 .66706 .54524 .66309 .53599 Mtetra
0 .005 .558 r
.66309 .53599 .66706 .54524 .67072 .54982 .66672 .54051 Mtetra
0 .031 .571 r
.66672 .54051 .67072 .54982 .67438 .55405 .67035 .54468 Mtetra
.088 .126 .607 r
.67035 .54468 .67438 .55405 .67791 .55672 .67385 .54731 Mtetra
.305 .242 .619 r
.67385 .54731 .67791 .55672 .68119 .55691 .67711 .54747 Mtetra
.475 .328 .6 r
.67711 .54747 .68119 .55691 .68417 .55411 .68008 .54467 Mtetra
.578 .377 .573 r
.68008 .54467 .68417 .55411 .68684 .54839 .68274 .53898 Mtetra
.633 .403 .552 r
.68274 .53898 .68684 .54839 .68923 .54034 .68513 .53098 Mtetra
.657 .414 .54 r
.68513 .53098 .68923 .54034 .69147 .53098 .68737 .52167 Mtetra
.659 .415 .539 r
.68737 .52167 .69147 .53098 .69367 .52153 .68958 .51228 Mtetra
.64 .407 .548 r
.68958 .51228 .69367 .52153 .69599 .51321 .6919 .50401 Mtetra
.594 .385 .568 r
.6919 .50401 .69599 .51321 .69855 .50702 .69445 .49785 Mtetra
.504 .343 .596 r
.69445 .49785 .69855 .50702 .70143 .50358 .69733 .49443 Mtetra
.353 .269 .62 r
.69733 .49443 .70143 .50358 .70468 .50307 .70056 .49389 Mtetra
.147 .163 .619 r
.70056 .49389 .70468 .50307 .70827 .50516 .70412 .49595 Mtetra
0 .064 .59 r
.70412 .49595 .70827 .50516 .71213 .50911 .70794 .49984 Mtetra
0 .02 .57 r
.70794 .49984 .71213 .50911 .71611 .51383 .71189 .50449 Mtetra
0 .051 .585 r
.71189 .50449 .71611 .51383 .72007 .51807 .71581 .50867 Mtetra
.109 .142 .615 r
.71581 .50867 .72007 .51807 .72384 .52067 .71956 .51122 Mtetra
.316 .249 .622 r
.71956 .51122 .72384 .52067 .7273 .52071 .72299 .51124 Mtetra
.478 .329 .6 r
.72299 .51124 .7273 .52071 .73036 .51776 .72604 .50829 Mtetra
.577 .375 .571 r
.72604 .50829 .73036 .51776 .73302 .51193 .7287 .50249 Mtetra
.63 .399 .549 r
.7287 .50249 .73302 .51193 .73537 .50387 .73104 .49448 Mtetra
.653 .409 .537 r
.73104 .49448 .73537 .50387 .73752 .49462 .7332 .48529 Mtetra
.7332 .48529 .73752 .49462 .73967 .48541 .73535 .47613 Mtetra
.631 .399 .548 r
.73535 .47613 .73967 .48541 .74197 .47742 .73765 .46819 Mtetra
.579 .376 .57 r
.73765 .46819 .74197 .47742 .74459 .47164 .74027 .46244 Mtetra
.482 .332 .6 r
.74027 .46244 .74459 .47164 .74762 .46864 .74329 .45944 Mtetra
.325 .257 .625 r
.74329 .45944 .74762 .46864 .75111 .46855 .74676 .45933 Mtetra
.125 .156 .623 r
.74676 .45933 .75111 .46855 .75502 .471 .75063 .46173 Mtetra
0 .069 .597 r
.75063 .46173 .75502 .471 .75923 .4752 .7548 .46587 Mtetra
0 .037 .582 r
.7548 .46587 .75923 .4752 .76358 .48006 .75911 .47066 Mtetra
0 .071 .597 r
.75911 .47066 .76358 .48006 .76787 .48432 .76337 .47486 Mtetra
.128 .157 .622 r
.76337 .47486 .76787 .48432 .77192 .48683 .76738 .47732 Mtetra
.325 .256 .623 r
.76738 .47732 .77192 .48683 .77555 .48673 .77099 .4772 Mtetra
.48 .329 .598 r
.77099 .4772 .77555 .48673 .7787 .48363 .77413 .4741 Mtetra
.575 .372 .568 r
.77413 .4741 .7787 .48363 .78137 .47769 .77679 .46819 Mtetra
.627 .394 .545 r
.77679 .46819 .78137 .47769 .78366 .46961 .77909 .46015 Mtetra
.648 .403 .534 r
.77909 .46015 .78366 .46961 .78575 .46045 .78118 .45105 Mtetra
.646 .402 .535 r
.78118 .45105 .78575 .46045 .78784 .45145 .78328 .44211 Mtetra
.62 .391 .548 r
.78328 .44211 .78784 .45145 .79016 .44379 .78559 .43449 Mtetra
.563 .367 .574 r
.78559 .43449 .79016 .44379 .79288 .4384 .7883 .42913 Mtetra
.458 .321 .605 r
.7883 .42913 .79288 .4384 .79611 .43583 .79152 .42656 Mtetra
.298 .246 .629 r
.79152 .42656 .79611 .43583 .79988 .43615 .79527 .42685 Mtetra
.107 .152 .626 r
.79527 .42685 .79988 .43615 .80415 .43896 .7995 .42961 Mtetra
0 .077 .604 r
.7995 .42961 .80415 .43896 .80878 .44342 .80408 .43401 Mtetra
0 .053 .594 r
.80408 .43401 .80878 .44342 .81354 .44842 .80881 .43893 Mtetra
0 .09 .609 r
.80881 .43893 .81354 .44842 .81821 .45271 .81343 .44316 Mtetra
.147 .171 .629 r
.81343 .44316 .81821 .45271 .82255 .45514 .81774 .44554 Mtetra
.334 .261 .625 r
.81774 .44554 .82255 .45514 .82639 .4549 .82155 .44527 Mtetra
.481 .329 .597 r
.82155 .44527 .82639 .4549 .82964 .45163 .82478 .44201 Mtetra
.573 .368 .565 r
.82478 .44201 .82964 .45163 .83231 .44557 .82746 .43598 Mtetra
.623 .389 .542 r
.82746 .43598 .83231 .44557 .83456 .43745 .8297 .42791 Mtetra
.642 .396 .531 r
.8297 .42791 .83456 .43745 .83658 .42837 .83173 .41888 Mtetra
.638 .395 .533 r
.83173 .41888 .83658 .42837 .83864 .41956 .8338 .41014 Mtetra
.608 .383 .549 r
.8338 .41014 .83864 .41956 .841 .41221 .83615 .40283 Mtetra
.545 .357 .577 r
.83615 .40283 .841 .41221 .84385 .40722 .83899 .39785 Mtetra
.434 .31 .611 r
.83899 .39785 .84385 .40722 .84732 .40507 .84245 .3957 Mtetra
.272 .236 .634 r
.84245 .3957 .84732 .40507 .85145 .40581 .84655 .39641 Mtetra
.093 .15 .631 r
.84655 .39641 .85145 .40581 .85615 .40898 .85121 .39952 Mtetra
0 .086 .612 r
.85121 .39952 .85615 .40898 .86125 .41371 .85625 .40418 Mtetra
0 .07 .606 r
.85625 .40418 .86125 .41371 .86648 .41886 .86144 .40926 Mtetra
.009 .108 .62 r
.86144 .40926 .86648 .41886 .87158 .42318 .86649 .41351 Mtetra
.164 .184 .635 r
.86649 .41351 .87158 .42318 .87625 .42554 .87113 .41581 Mtetra
.341 .266 .626 r
.87113 .41581 .87625 .42554 .88031 .42514 .87516 .41539 Mtetra
.566 .372 .577 r
.42783 .80597 .43087 .8164 .43356 .81116 .43052 .80075 Mtetra
.632 .41 .563 r
.43052 .80075 .43356 .81116 .43633 .80296 .43329 .7926 Mtetra
.664 .429 .554 r
.43329 .7926 .43633 .80296 .43915 .79265 .4361 .78236 Mtetra
.676 .436 .55 r
.4361 .78236 .43915 .79265 .44197 .78146 .43893 .77125 Mtetra
.671 .433 .552 r
.43893 .77125 .44197 .78146 .44477 .77074 .44173 .7606 Mtetra
.649 .42 .559 r
.44173 .7606 .44477 .77074 .44751 .76172 .44447 .75163 Mtetra
.599 .392 .572 r
.44447 .75163 .44751 .76172 .45018 .75532 .44713 .74527 Mtetra
.504 .337 .587 r
.44713 .74527 .45018 .75532 .45278 .75203 .44972 .74199 Mtetra
.334 .237 .594 r
.44972 .74199 .45278 .75203 .45532 .75181 .45224 .74175 Mtetra
.089 .091 .565 r
.45224 .74175 .45532 .75181 .45782 .75411 .45473 .74401 Mtetra
0 0 .511 r
.45473 .74401 .45782 .75411 .46032 .75794 .45721 .74779 Mtetra
0 0 .499 r
.45721 .74779 .46032 .75794 .46283 .76206 .4597 .75185 Mtetra
0 .036 .544 r
.4597 .75185 .46283 .76206 .46538 .76514 .46222 .75488 Mtetra
.244 .184 .587 r
.46222 .75488 .46538 .76514 .46798 .766 .4648 .75572 Mtetra
.447 .302 .591 r
.4648 .75572 .46798 .766 .47062 .7639 .46743 .75361 Mtetra
.567 .372 .576 r
.46743 .75361 .47062 .7639 .4733 .7586 .47011 .74833 Mtetra
.631 .408 .561 r
.47011 .74833 .4733 .7586 .476 .75046 .4728 .74024 Mtetra
.662 .425 .551 r
.4728 .74024 .476 .75046 .47871 .74037 .47551 .73022 Mtetra
.673 .431 .548 r
.47551 .73022 .47871 .74037 .4814 .72953 .47821 .71946 Mtetra
.666 .428 .55 r
.47821 .71946 .4814 .72953 .48408 .71928 .48088 .70928 Mtetra
.64 .413 .559 r
.48088 .70928 .48408 .71928 .48673 .71081 .48353 .70085 Mtetra
.585 .383 .573 r
.48353 .70085 .48673 .71081 .48936 .70497 .48616 .69504 Mtetra
.481 .324 .59 r
.48616 .69504 .48936 .70497 .49199 .70219 .48877 .69227 Mtetra
.301 .22 .596 r
.48877 .69227 .49199 .70219 .49462 .70239 .49139 .69244 Mtetra
.062 .08 .565 r
.49139 .69244 .49462 .70239 .49727 .70497 .49401 .69498 Mtetra
0 0 .518 r
.49401 .69498 .49727 .70497 .49994 .70895 .49666 .69891 Mtetra
0 0 .513 r
.49666 .69891 .49994 .70895 .50263 .71308 .49933 .70298 Mtetra
.021 .055 .556 r
.49933 .70298 .50263 .71308 .50534 .71606 .50202 .70591 Mtetra
.259 .195 .592 r
.50202 .70591 .50534 .71606 .50805 .71679 .50472 .70661 Mtetra
.452 .306 .592 r
.50472 .70661 .50805 .71679 .51075 .71455 .5074 .70437 Mtetra
.567 .371 .575 r
.5074 .70437 .51075 .71455 .51343 .70918 .51007 .69903 Mtetra
.629 .405 .559 r
.51007 .69903 .51343 .70918 .51606 .7011 .5127 .69099 Mtetra
.659 .422 .549 r
.5127 .69099 .51606 .7011 .51866 .6912 .5153 .68116 Mtetra
.669 .426 .545 r
.5153 .68116 .51866 .6912 .52124 .6807 .51788 .67073 Mtetra
.66 .422 .548 r
.51788 .67073 .52124 .6807 .5238 .67089 .52045 .66099 Mtetra
.63 .406 .558 r
.52045 .66099 .5238 .67089 .52639 .66293 .52303 .65307 Mtetra
.57 .373 .575 r
.52303 .65307 .52639 .66293 .52901 .65761 .52565 .64778 Mtetra
.457 .31 .593 r
.52565 .64778 .52901 .65761 .53169 .65532 .52832 .64549 Mtetra
.27 .205 .597 r
.52832 .64549 .53169 .65532 .53444 .65591 .53105 .64606 Mtetra
.038 .072 .567 r
.53105 .64606 .53444 .65591 .53726 .65877 .53384 .64887 Mtetra
0 0 .526 r
.53384 .64887 .53726 .65877 .54013 .66289 .53669 .65293 Mtetra
.53669 .65293 .54013 .66289 .54302 .66703 .53956 .65701 Mtetra
.043 .074 .567 r
.53956 .65701 .54302 .66703 .54591 .66993 .54242 .65986 Mtetra
.272 .206 .597 r
.54242 .65986 .54591 .66993 .54875 .67051 .54524 .66042 Mtetra
.456 .309 .592 r
.54524 .66042 .54875 .67051 .55151 .66814 .54798 .65804 Mtetra
.568 .37 .573 r
.54798 .65804 .55151 .66814 .55417 .6627 .55064 .65263 Mtetra
.628 .402 .556 r
.55064 .65263 .55417 .6627 .55674 .65465 .55321 .64463 Mtetra
.656 .417 .546 r
.55321 .64463 .55674 .65465 .55924 .64492 .55571 .63497 Mtetra
.664 .421 .543 r
.55571 .63497 .55924 .64492 .56171 .63473 .55818 .62485 Mtetra
.653 .416 .547 r
.55818 .62485 .56171 .63473 .56419 .62535 .56066 .61552 Mtetra
.62 .398 .559 r
.56066 .61552 .56419 .62535 .56673 .61786 .5632 .60808 Mtetra
.553 .363 .577 r
.5632 .60808 .56673 .61786 .56937 .61305 .56583 .60329 Mtetra
.431 .297 .597 r
.56583 .60329 .56937 .61305 .57214 .61122 .56858 .60146 Mtetra
.239 .191 .599 r
.56858 .60146 .57214 .61122 .57504 .6122 .57146 .6024 Mtetra
.02 .066 .569 r
.57146 .6024 .57504 .6122 .57805 .61532 .57445 .60548 Mtetra
0 0 .535 r
.57445 .60548 .57805 .61532 .58115 .61958 .57752 .60967 Mtetra
0 0 .54 r
.57752 .60967 .58115 .61958 .58426 .62373 .58061 .61376 Mtetra
.064 .092 .578 r
.58061 .61376 .58426 .62373 .58733 .62653 .58366 .61652 Mtetra
.284 .215 .601 r
.58366 .61652 .58733 .62653 .5903 .62697 .58661 .61693 Mtetra
.46 .311 .592 r
.58661 .61693 .5903 .62697 .59313 .62446 .58942 .61442 Mtetra
.567 .368 .571 r
.58942 .61442 .59313 .62446 .59579 .61894 .59207 .60893 Mtetra
.626 .399 .553 r
.59207 .60893 .59579 .61894 .5983 .61092 .59458 .60096 Mtetra
.653 .413 .543 r
.59458 .60096 .5983 .61092 .60071 .60136 .59699 .59146 Mtetra
.659 .416 .54 r
.59699 .59146 .60071 .60136 .60307 .59145 .59936 .58162 Mtetra
.646 .409 .546 r
.59936 .58162 .60307 .59145 .60548 .58246 .60177 .57268 Mtetra
.608 .39 .56 r
.60177 .57268 .60548 .58246 .608 .57544 .60428 .5657 Mtetra
.535 .352 .58 r
.60428 .5657 .608 .57544 .61068 .5711 .60696 .56139 Mtetra
.405 .284 .6 r
.60696 .56139 .61068 .5711 .61357 .56972 .60983 .55999 Mtetra
.21 .178 .602 r
.60983 .55999 .61357 .56972 .61665 .57106 .61289 .5613 Mtetra
.005 .064 .573 r
.61289 .5613 .61665 .57106 .6199 .57444 .61611 .56463 Mtetra
0 0 .544 r
.61611 .56463 .6199 .57444 .62325 .57883 .61942 .56895 Mtetra
0 .017 .553 r
.61942 .56895 .62325 .57883 .6266 .58299 .62275 .57305 Mtetra
.085 .108 .587 r
.62275 .57305 .6266 .58299 .62988 .58571 .626 .57572 Mtetra
.296 .224 .604 r
.626 .57572 .62988 .58571 .63299 .58601 .62909 .576 Mtetra
.464 .313 .591 r
.62909 .576 .63299 .58601 .63589 .58336 .63197 .57334 Mtetra
.567 .367 .569 r
.63197 .57334 .63589 .58336 .63854 .57775 .63462 .56777 Mtetra
.623 .395 .55 r
.63462 .56777 .63854 .57775 .641 .56975 .63708 .55981 Mtetra
.649 .408 .54 r
.63708 .55981 .641 .56975 .64332 .56032 .6394 .55045 Mtetra
.654 .41 .538 r
.6394 .55045 .64332 .56032 .6456 .55068 .64168 .54088 Mtetra
.638 .402 .545 r
.64168 .54088 .6456 .55068 .64795 .54206 .64404 .53231 Mtetra
.596 .381 .561 r
.64404 .53231 .64795 .54206 .65047 .53548 .64656 .52577 Mtetra
.515 .341 .583 r
.64656 .52577 .65047 .53548 .65324 .53161 .64931 .52191 Mtetra
.378 .27 .604 r
.64931 .52191 .65324 .53161 .65627 .53065 .65233 .52094 Mtetra
.184 .167 .604 r
.65233 .52094 .65627 .53065 .65958 .53235 .65561 .5226 Mtetra
0 .064 .577 r
.65561 .5226 .65958 .53235 .66309 .53599 .65909 .52618 Mtetra
0 .012 .555 r
.65909 .52618 .66309 .53599 .66672 .54051 .66269 .53063 Mtetra
0 .036 .566 r
.66269 .53063 .66672 .54051 .67035 .54468 .66628 .53474 Mtetra
.105 .124 .596 r
.66628 .53474 .67035 .54468 .67385 .54731 .66975 .53732 Mtetra
.306 .232 .607 r
.66975 .53732 .67385 .54731 .67711 .54747 .67299 .53746 Mtetra
.466 .315 .591 r
.67299 .53746 .67711 .54747 .68008 .54467 .67594 .53466 Mtetra
.566 .364 .567 r
.67594 .53466 .68008 .54467 .68274 .53898 .6786 .52899 Mtetra
.621 .391 .547 r
.6786 .52899 .68274 .53898 .68513 .53098 .68099 .52104 Mtetra
.645 .403 .537 r
.68099 .52104 .68513 .53098 .68737 .52167 .68323 .5118 Mtetra
.648 .404 .536 r
.68323 .5118 .68737 .52167 .68958 .51228 .68545 .50248 Mtetra
.629 .395 .544 r
.68545 .50248 .68958 .51228 .6919 .50401 .68777 .49426 Mtetra
.582 .373 .562 r
.68777 .49426 .6919 .50401 .69445 .49785 .69031 .48813 Mtetra
.495 .33 .587 r
.69031 .48813 .69445 .49785 .69733 .49443 .69317 .48471 Mtetra
.351 .258 .608 r
.69317 .48471 .69733 .49443 .70056 .49389 .69638 .48416 Mtetra
.16 .159 .607 r
.69638 .48416 .70056 .49389 .70412 .49595 .69992 .48617 Mtetra
0 .066 .583 r
.69992 .48617 .70412 .49595 .70794 .49984 .70371 .49 Mtetra
0 .026 .566 r
.70371 .49 .70794 .49984 .71189 .50449 .70762 .49458 Mtetra
0 .055 .578 r
.70762 .49458 .71189 .50449 .71581 .50867 .71151 .4987 Mtetra
.124 .139 .603 r
.71151 .4987 .71581 .50867 .71956 .51122 .71522 .5012 Mtetra
.316 .239 .609 r
.71522 .5012 .71956 .51122 .72299 .51124 .71863 .50119 Mtetra
.469 .316 .59 r
.71863 .50119 .72299 .51124 .72604 .50829 .72166 .49825 Mtetra
.565 .362 .564 r
.72166 .49825 .72604 .50829 .7287 .50249 .72431 .49248 Mtetra
.618 .386 .544 r
.72431 .49248 .7287 .50249 .73104 .49448 .72666 .48452 Mtetra
.641 .397 .534 r
.72666 .48452 .73104 .49448 .7332 .48529 .72882 .47539 Mtetra
.72882 .47539 .7332 .48529 .73535 .47613 .73097 .46629 Mtetra
.619 .387 .544 r
.73097 .46629 .73535 .47613 .73765 .46819 .73328 .45841 Mtetra
.567 .363 .564 r
.73328 .45841 .73765 .46819 .74027 .46244 .73589 .45268 Mtetra
.473 .319 .591 r
.73589 .45268 .74027 .46244 .74329 .45944 .73889 .44969 Mtetra
.324 .246 .612 r
.73889 .44969 .74329 .45944 .74676 .45933 .74234 .44955 Mtetra
.139 .152 .611 r
.74234 .44955 .74676 .45933 .75063 .46173 .74618 .4519 Mtetra
0 .071 .589 r
.74618 .4519 .75063 .46173 .7548 .46587 .75031 .45598 Mtetra
0 .041 .577 r
.75031 .45598 .7548 .46587 .75911 .47066 .75458 .46069 Mtetra
0 .073 .59 r
.75458 .46069 .75911 .47066 .76337 .47486 .7588 .46483 Mtetra
.142 .153 .61 r
.7588 .46483 .76337 .47486 .76738 .47732 .76278 .46724 Mtetra
.324 .245 .611 r
.76278 .46724 .76738 .47732 .77099 .4772 .76636 .46709 Mtetra
.471 .316 .589 r
.76636 .46709 .77099 .4772 .77413 .4741 .76948 .46399 Mtetra
.563 .359 .561 r
.76948 .46399 .77413 .4741 .77679 .46819 .77214 .45812 Mtetra
.614 .382 .541 r
.77214 .45812 .77679 .46819 .77909 .46015 .77443 .45014 Mtetra
.636 .391 .531 r
.77443 .45014 .77909 .46015 .78118 .45105 .77653 .4411 Mtetra
.634 .39 .532 r
.77653 .4411 .78118 .45105 .78328 .44211 .77864 .43221 Mtetra
.608 .379 .544 r
.77864 .43221 .78328 .44211 .78559 .43449 .78095 .42465 Mtetra
.551 .354 .567 r
.78095 .42465 .78559 .43449 .7883 .42913 .78365 .41931 Mtetra
.45 .308 .595 r
.78365 .41931 .7883 .42913 .79152 .42656 .78685 .41674 Mtetra
.299 .236 .616 r
.78685 .41674 .79152 .42656 .79527 .42685 .79057 .417 Mtetra
.122 .148 .615 r
.79057 .417 .79527 .42685 .7995 .42961 .79477 .41971 Mtetra
0 .078 .597 r
.79477 .41971 .7995 .42961 .80408 .43401 .79931 .42403 Mtetra
0 .057 .588 r
.79931 .42403 .80408 .43401 .80881 .43893 .80398 .42888 Mtetra
.01 .09 .601 r
.80398 .42888 .80881 .43893 .81343 .44316 .80857 .43304 Mtetra
.159 .166 .617 r
.80857 .43304 .81343 .44316 .81774 .44554 .81284 .43537 Mtetra
.332 .251 .612 r
.81284 .43537 .81774 .44554 .82155 .44527 .81662 .43507 Mtetra
.472 .316 .587 r
.81662 .43507 .82155 .44527 .82478 .44201 .81984 .43182 Mtetra
.561 .355 .559 r
.81984 .43182 .82478 .44201 .82746 .43598 .8225 .42582 Mtetra
.61 .376 .537 r
.8225 .42582 .82746 .43598 .8297 .42791 .82475 .4178 Mtetra
.63 .384 .527 r
.82475 .4178 .8297 .42791 .83173 .41888 .82679 .40884 Mtetra
.626 .383 .53 r
.82679 .40884 .83173 .41888 .8338 .41014 .82886 .40015 Mtetra
.596 .37 .544 r
.82886 .40015 .8338 .41014 .83615 .40283 .83121 .39289 Mtetra
.534 .344 .57 r
.83121 .39289 .83615 .40283 .83899 .39785 .83404 .38794 Mtetra
.427 .297 .6 r
.83404 .38794 .83899 .39785 .84245 .3957 .83748 .38578 Mtetra
.275 .226 .621 r
.83748 .38578 .84245 .3957 .84655 .39641 .84154 .38645 Mtetra
.109 .146 .619 r
.84154 .38645 .84655 .39641 .85121 .39952 .84616 .3895 Mtetra
0 .087 .605 r
.84616 .3895 .85121 .39952 .85625 .40418 .85116 .39409 Mtetra
0 .073 .599 r
.85116 .39409 .85625 .40418 .86144 .40926 .8563 .39908 Mtetra
.031 .107 .611 r
.8563 .39908 .86144 .40926 .86649 .41351 .86129 .40326 Mtetra
.175 .178 .622 r
.86129 .40326 .86649 .41351 .87113 .41581 .86589 .40551 Mtetra
.339 .255 .613 r
.86589 .40551 .87113 .41581 .87516 .41539 .86989 .40507 Mtetra
.576 .384 .584 r
.4248 .79627 .42783 .80597 .43052 .80075 .42748 .79107 Mtetra
.642 .421 .567 r
.42748 .79107 .43052 .80075 .43329 .7926 .43024 .78297 Mtetra
.674 .439 .557 r
.43024 .78297 .43329 .7926 .4361 .78236 .43306 .77279 Mtetra
.686 .445 .553 r
.43306 .77279 .4361 .78236 .43893 .77125 .43589 .76175 Mtetra
.681 .443 .555 r
.43589 .76175 .43893 .77125 .44173 .7606 .43869 .75116 Mtetra
.659 .431 .562 r
.43869 .75116 .44173 .7606 .44447 .75163 .44143 .74225 Mtetra
.61 .403 .577 r
.44143 .74225 .44447 .75163 .44713 .74527 .44408 .73592 Mtetra
.514 .349 .596 r
.44408 .73592 .44713 .74527 .44972 .74199 .44666 .73265 Mtetra
.335 .247 .605 r
.44666 .73265 .44972 .74199 .45224 .74175 .44918 .73239 Mtetra
.07 .091 .574 r
.44918 .73239 .45224 .74175 .45473 .74401 .45164 .73461 Mtetra
0 0 .512 r
.45164 .73461 .45473 .74401 .45721 .74779 .4541 .73834 Mtetra
0 0 .498 r
.4541 .73834 .45721 .74779 .4597 .75185 .45657 .74235 Mtetra
0 .031 .551 r
.45657 .74235 .4597 .75185 .46222 .75488 .45908 .74533 Mtetra
.239 .191 .599 r
.45908 .74533 .46222 .75488 .4648 .75572 .46164 .74615 Mtetra
.454 .315 .601 r
.46164 .74615 .4648 .75572 .46743 .75361 .46426 .74404 Mtetra
.577 .384 .582 r
.46426 .74404 .46743 .75361 .47011 .74833 .46692 .73878 Mtetra
.641 .419 .565 r
.46692 .73878 .47011 .74833 .4728 .74024 .46962 .73074 Mtetra
.672 .435 .554 r
.46962 .73074 .4728 .74024 .47551 .73022 .47233 .72077 Mtetra
.682 .441 .55 r
.47233 .72077 .47551 .73022 .47821 .71946 .47503 .71008 Mtetra
.676 .438 .553 r
.47503 .71008 .47821 .71946 .48088 .70928 .4777 .69996 Mtetra
.65 .424 .562 r
.4777 .69996 .48088 .70928 .48353 .70085 .48035 .69158 Mtetra
.596 .394 .579 r
.48035 .69158 .48353 .70085 .48616 .69504 .48297 .6858 Mtetra
.49 .336 .599 r
.48297 .6858 .48616 .69504 .48877 .69227 .48558 .68303 Mtetra
.301 .23 .608 r
.48558 .68303 .48877 .69227 .49139 .69244 .48818 .68318 Mtetra
.04 .079 .574 r
.48818 .68318 .49139 .69244 .49401 .69498 .49079 .68568 Mtetra
0 0 .519 r
.49079 .68568 .49401 .69498 .49666 .69891 .49341 .68956 Mtetra
0 0 .513 r
.49341 .68956 .49666 .69891 .49933 .70298 .49606 .69358 Mtetra
0 .052 .564 r
.49606 .69358 .49933 .70298 .50202 .70591 .49873 .69647 Mtetra
.255 .203 .604 r
.49873 .69647 .50202 .70591 .50472 .70661 .50141 .69714 Mtetra
.46 .318 .601 r
.50141 .69714 .50472 .70661 .5074 .70437 .50408 .6949 Mtetra
.578 .383 .581 r
.50408 .6949 .5074 .70437 .51007 .69903 .50674 .68958 Mtetra
.64 .416 .563 r
.50674 .68958 .51007 .69903 .5127 .69099 .50937 .68159 Mtetra
.67 .432 .552 r
.50937 .68159 .5127 .69099 .5153 .68116 .51197 .67181 Mtetra
.678 .436 .548 r
.51197 .67181 .5153 .68116 .51788 .67073 .51455 .66145 Mtetra
.67 .432 .552 r
.51455 .66145 .51788 .67073 .52045 .66099 .51712 .65177 Mtetra
.641 .417 .563 r
.51712 .65177 .52045 .66099 .52303 .65307 .5197 .64389 Mtetra
.58 .385 .581 r
.5197 .64389 .52303 .65307 .52565 .64778 .52231 .63863 Mtetra
.465 .323 .603 r
.52231 .63863 .52565 .64778 .52832 .64549 .52497 .63634 Mtetra
.266 .213 .61 r
.52497 .63634 .52832 .64549 .53105 .64606 .52769 .63688 Mtetra
.015 .07 .575 r
.52769 .63688 .53105 .64606 .53384 .64887 .53046 .63965 Mtetra
0 0 .527 r
.53046 .63965 .53384 .64887 .53669 .65293 .53328 .64366 Mtetra
0 0 .528 r
.53328 .64366 .53669 .65293 .53956 .65701 .53613 .64768 Mtetra
.02 .072 .576 r
.53613 .64768 .53956 .65701 .54242 .65986 .53897 .65048 Mtetra
.269 .214 .609 r
.53897 .65048 .54242 .65986 .54524 .66042 .54177 .65102 Mtetra
.464 .321 .601 r
.54177 .65102 .54524 .66042 .54798 .65804 .5445 .64864 Mtetra
.578 .382 .579 r
.5445 .64864 .54798 .65804 .55064 .65263 .54715 .64325 Mtetra
.638 .413 .56 r
.54715 .64325 .55064 .65263 .55321 .64463 .54972 .6353 Mtetra
.667 .428 .549 r
.54972 .6353 .55321 .64463 .55571 .63497 .55223 .6257 Mtetra
.674 .431 .546 r
.55223 .6257 .55571 .63497 .55818 .62485 .5547 .61564 Mtetra
.664 .426 .55 r
.5547 .61564 .55818 .62485 .56066 .61552 .55718 .60637 Mtetra
.631 .409 .563 r
.55718 .60637 .56066 .61552 .5632 .60808 .55972 .59897 Mtetra
.563 .375 .584 r
.55972 .59897 .5632 .60808 .56583 .60329 .56234 .5942 Mtetra
.438 .309 .607 r
.56234 .5942 .56583 .60329 .56858 .60146 .56508 .59236 Mtetra
.233 .198 .612 r
.56508 .59236 .56858 .60146 .57146 .6024 .56794 .59327 Mtetra
0 .064 .577 r
.56794 .59327 .57146 .6024 .57445 .60548 .57091 .5963 Mtetra
0 0 .537 r
.57091 .5963 .57445 .60548 .57752 .60967 .57395 .60044 Mtetra
0 0 .543 r
.57395 .60044 .57752 .60967 .58061 .61376 .57701 .60448 Mtetra
.044 .091 .587 r
.57701 .60448 .58061 .61376 .58366 .61652 .58003 .60719 Mtetra
.282 .224 .613 r
.58003 .60719 .58366 .61652 .58661 .61693 .58297 .60758 Mtetra
.468 .324 .601 r
.58297 .60758 .58661 .61693 .58942 .61442 .58576 .60507 Mtetra
.578 .381 .577 r
.58576 .60507 .58942 .61442 .59207 .60893 .58841 .5996 Mtetra
.637 .41 .557 r
.58841 .5996 .59207 .60893 .59458 .60096 .59092 .59168 Mtetra
.664 .423 .546 r
.59092 .59168 .59458 .60096 .59699 .59146 .59333 .58223 Mtetra
.67 .426 .543 r
.59333 .58223 .59699 .59146 .59936 .58162 .59571 .57246 Mtetra
.656 .42 .549 r
.59571 .57246 .59936 .58162 .60177 .57268 .59812 .56357 Mtetra
.619 .402 .564 r
.59812 .56357 .60177 .57268 .60428 .5657 .60063 .55663 Mtetra
.545 .365 .587 r
.60063 .55663 .60428 .5657 .60696 .56139 .6033 .55233 Mtetra
.41 .295 .611 r
.6033 .55233 .60696 .56139 .60983 .55999 .60615 .55093 Mtetra
.202 .184 .614 r
.60615 .55093 .60983 .55999 .61289 .5613 .60919 .5522 Mtetra
0 .061 .58 r
.60919 .5522 .61289 .5613 .61611 .56463 .61239 .55548 Mtetra
0 0 .547 r
.61239 .55548 .61611 .56463 .61942 .56895 .61567 .55975 Mtetra
0 .011 .557 r
.61567 .55975 .61942 .56895 .62275 .57305 .61897 .56379 Mtetra
.067 .109 .597 r
.61897 .56379 .62275 .57305 .626 .57572 .6222 .56641 Mtetra
.294 .233 .616 r
.6222 .56641 .626 .57572 .62909 .576 .62527 .56666 Mtetra
.472 .326 .601 r
.62527 .56666 .62909 .576 .63197 .57334 .62813 .56401 Mtetra
.578 .379 .575 r
.62813 .56401 .63197 .57334 .63462 .56777 .63078 .55846 Mtetra
.635 .406 .555 r
.63078 .55846 .63462 .56777 .63708 .55981 .63323 .55055 Mtetra
.66 .419 .543 r
.63323 .55055 .63708 .55981 .6394 .55045 .63556 .54125 Mtetra
.665 .421 .541 r
.63556 .54125 .6394 .55045 .64168 .54088 .63785 .53174 Mtetra
.649 .413 .549 r
.63785 .53174 .64168 .54088 .64404 .53231 .6402 .52322 Mtetra
.607 .393 .566 r
.6402 .52322 .64404 .53231 .64656 .52577 .64272 .51671 Mtetra
.525 .354 .591 r
.64272 .51671 .64656 .52577 .64931 .52191 .64546 .51286 Mtetra
.382 .282 .615 r
.64546 .51286 .64931 .52191 .65233 .52094 .64846 .51188 Mtetra
.174 .173 .616 r
.64846 .51188 .65233 .52094 .65561 .5226 .65172 .5135 Mtetra
0 .061 .584 r
.65172 .5135 .65561 .5226 .65909 .52618 .65517 .51703 Mtetra
0 .006 .558 r
.65517 .51703 .65909 .52618 .66269 .53063 .65874 .52142 Mtetra
0 .032 .571 r
.65874 .52142 .66269 .53063 .66628 .53474 .6623 .52547 Mtetra
.089 .127 .606 r
.6623 .52547 .66628 .53474 .66975 .53732 .66574 .52801 Mtetra
.306 .241 .619 r
.66574 .52801 .66975 .53732 .67299 .53746 .66896 .52812 Mtetra
.475 .327 .6 r
.66896 .52812 .67299 .53746 .67594 .53466 .6719 .52532 Mtetra
.577 .377 .573 r
.6719 .52532 .67594 .53466 .6786 .52899 .67455 .51968 Mtetra
.632 .402 .552 r
.67455 .51968 .6786 .52899 .68099 .52104 .67695 .51178 Mtetra
.656 .414 .54 r
.67695 .51178 .68099 .52104 .68323 .5118 .67919 .5026 Mtetra
.659 .415 .539 r
.67919 .5026 .68323 .5118 .68545 .50248 .68141 .49333 Mtetra
.64 .406 .548 r
.68141 .49333 .68545 .50248 .68777 .49426 .68373 .48516 Mtetra
.593 .385 .568 r
.68373 .48516 .68777 .49426 .69031 .48813 .68627 .47907 Mtetra
.504 .343 .595 r
.68627 .47907 .69031 .48813 .69317 .48471 .68912 .47565 Mtetra
.353 .269 .62 r
.68912 .47565 .69317 .48471 .69638 .48416 .69231 .47508 Mtetra
.148 .163 .619 r
.69231 .47508 .69638 .48416 .69992 .48617 .69582 .47705 Mtetra
0 .064 .59 r
.69582 .47705 .69992 .48617 .70371 .49 .69957 .48082 Mtetra
0 .021 .57 r
.69957 .48082 .70371 .49 .70762 .49458 .70345 .48534 Mtetra
0 .051 .585 r
.70345 .48534 .70762 .49458 .71151 .4987 .70731 .4894 Mtetra
.11 .142 .615 r
.70731 .4894 .71151 .4987 .71522 .5012 .71099 .49185 Mtetra
.316 .249 .621 r
.71099 .49185 .71522 .5012 .71863 .50119 .71437 .49182 Mtetra
.477 .328 .599 r
.71437 .49182 .71863 .50119 .72166 .49825 .71739 .48888 Mtetra
.576 .374 .57 r
.71739 .48888 .72166 .49825 .72431 .49248 .72004 .48314 Mtetra
.629 .398 .548 r
.72004 .48314 .72431 .49248 .72666 .48452 .72239 .47523 Mtetra
.652 .408 .537 r
.72239 .47523 .72666 .48452 .72882 .47539 .72456 .46615 Mtetra
.72456 .46615 .72882 .47539 .73097 .46629 .72671 .45711 Mtetra
.63 .399 .548 r
.72671 .45711 .73097 .46629 .73328 .45841 .72902 .44928 Mtetra
.578 .376 .57 r
.72902 .44928 .73328 .45841 .73589 .45268 .73162 .44358 Mtetra
.482 .331 .6 r
.73162 .44358 .73589 .45268 .73889 .44969 .73462 .44059 Mtetra
.325 .256 .624 r
.73462 .44059 .73889 .44969 .74234 .44955 .73804 .44043 Mtetra
.126 .156 .622 r
.73804 .44043 .74234 .44955 .74618 .4519 .74185 .44274 Mtetra
0 .07 .596 r
.74185 .44274 .74618 .4519 .75031 .45598 .74594 .44675 Mtetra
0 .037 .582 r
.74594 .44675 .75031 .45598 .75458 .46069 .75018 .4514 Mtetra
0 .071 .597 r
.75018 .4514 .75458 .46069 .7588 .46483 .75436 .45547 Mtetra
.129 .157 .622 r
.75436 .45547 .7588 .46483 .76278 .46724 .7583 .45784 Mtetra
.325 .255 .623 r
.7583 .45784 .76278 .46724 .76636 .46709 .76186 .45766 Mtetra
.479 .328 .598 r
.76186 .45766 .76636 .46709 .76948 .46399 .76497 .45457 Mtetra
.575 .371 .568 r
.76497 .45457 .76948 .46399 .77214 .45812 .76762 .44872 Mtetra
.626 .393 .545 r
.76762 .44872 .77214 .45812 .77443 .45014 .76992 .44079 Mtetra
.647 .402 .534 r
.76992 .44079 .77443 .45014 .77653 .4411 .77202 .43181 Mtetra
.645 .401 .535 r
.77202 .43181 .77653 .4411 .77864 .43221 .77413 .42298 Mtetra
.62 .391 .548 r
.77413 .42298 .77864 .43221 .78095 .42465 .77645 .41546 Mtetra
.562 .366 .573 r
.77645 .41546 .78095 .42465 .78365 .41931 .77914 .41015 Mtetra
.458 .32 .605 r
.77914 .41015 .78365 .41931 .78685 .41674 .78232 .40757 Mtetra
.298 .245 .629 r
.78232 .40757 .78685 .41674 .79057 .417 .78602 .40781 Mtetra
.108 .152 .626 r
.78602 .40781 .79057 .417 .79477 .41971 .79018 .41046 Mtetra
0 .077 .604 r
.79018 .41046 .79477 .41971 .79931 .42403 .79468 .41472 Mtetra
0 .054 .594 r
.79468 .41472 .79931 .42403 .80398 .42888 .79931 .4195 Mtetra
0 .09 .609 r
.79931 .4195 .80398 .42888 .80857 .43304 .80385 .42359 Mtetra
.148 .171 .628 r
.80385 .42359 .80857 .43304 .81284 .43537 .80809 .42588 Mtetra
.334 .261 .624 r
.80809 .42588 .81284 .43537 .81662 .43507 .81185 .42556 Mtetra
.481 .328 .596 r
.81185 .42556 .81662 .43507 .81984 .43182 .81505 .42231 Mtetra
.573 .368 .565 r
.81505 .42231 .81984 .43182 .8225 .42582 .81771 .41634 Mtetra
.622 .388 .541 r
.81771 .41634 .8225 .42582 .82475 .4178 .81996 .40837 Mtetra
.642 .396 .531 r
.81996 .40837 .82475 .4178 .82679 .40884 .822 .39946 Mtetra
.638 .394 .533 r
.822 .39946 .82679 .40884 .82886 .40015 .82408 .39083 Mtetra
.608 .382 .549 r
.82408 .39083 .82886 .40015 .83121 .39289 .82643 .38361 Mtetra
.544 .357 .577 r
.82643 .38361 .83121 .39289 .83404 .38794 .82925 .37868 Mtetra
.434 .309 .61 r
.82925 .37868 .83404 .38794 .83748 .38578 .83267 .37652 Mtetra
.272 .235 .633 r
.83267 .37652 .83748 .38578 .84154 .38645 .8367 .37715 Mtetra
.094 .15 .63 r
.8367 .37715 .84154 .38645 .84616 .3895 .84128 .38015 Mtetra
0 .086 .612 r
.84128 .38015 .84616 .3895 .85116 .39409 .84624 .38467 Mtetra
0 .071 .606 r
.84624 .38467 .85116 .39409 .8563 .39908 .85132 .38959 Mtetra
.01 .108 .62 r
.85132 .38959 .8563 .39908 .86129 .40326 .85628 .3937 Mtetra
.165 .184 .634 r
.85628 .3937 .86129 .40326 .86589 .40551 .86084 .3959 Mtetra
.341 .266 .625 r
.86084 .3959 .86589 .40551 .86989 .40507 .86481 .39543 Mtetra
.612 .425 .605 r
.42172 .78852 .4248 .79627 .42748 .79107 .42439 .78334 Mtetra
.676 .456 .581 r
.42439 .78334 .42748 .79107 .43024 .78297 .42716 .77527 Mtetra
.705 .47 .567 r
.42716 .77527 .43024 .78297 .43306 .77279 .42998 .76514 Mtetra
.715 .475 .561 r
.42998 .76514 .43306 .77279 .43589 .76175 .43281 .75415 Mtetra
.711 .473 .563 r
.43281 .75415 .43589 .76175 .43869 .75116 .43561 .74361 Mtetra
.691 .464 .574 r
.43561 .74361 .43869 .75116 .44143 .74225 .43835 .73474 Mtetra
.645 .442 .594 r
.43835 .73474 .44143 .74225 .44408 .73592 .44101 .72843 Mtetra
.547 .393 .624 r
.44101 .72843 .44408 .73592 .44666 .73265 .44358 .72516 Mtetra
.34 .285 .649 r
.44358 .72516 .44666 .73265 .44918 .73239 .44608 .72489 Mtetra
0 .09 .607 r
.44608 .72489 .44918 .73239 .45164 .73461 .44854 .72708 Mtetra
0 0 .504 r
.44854 .72708 .45164 .73461 .4541 .73834 .45097 .73077 Mtetra
0 0 .48 r
.45097 .73077 .4541 .73834 .45657 .74235 .45342 .73474 Mtetra
0 .012 .567 r
.45342 .73474 .45657 .74235 .45908 .74533 .45591 .73769 Mtetra
.219 .217 .644 r
.45591 .73769 .45908 .74533 .46164 .74615 .45846 .73848 Mtetra
.482 .359 .636 r
.45846 .73848 .46164 .74615 .46426 .74404 .46107 .73637 Mtetra
.613 .425 .603 r
.46107 .73637 .46426 .74404 .46692 .73878 .46374 .73113 Mtetra
.675 .454 .578 r
.46374 .73113 .46692 .73878 .46962 .73074 .46643 .72312 Mtetra
.703 .468 .564 r
.46643 .72312 .46962 .73074 .47233 .72077 .46915 .7132 Mtetra
.713 .472 .559 r
.46915 .7132 .47233 .72077 .47503 .71008 .47185 .70256 Mtetra
.707 .469 .562 r
.47185 .70256 .47503 .71008 .4777 .69996 .47453 .69249 Mtetra
.684 .459 .574 r
.47453 .69249 .4777 .69996 .48035 .69158 .47718 .68415 Mtetra
.631 .434 .597 r
.47718 .68415 .48035 .69158 .48297 .6858 .4798 .67838 Mtetra
.521 .381 .63 r
.4798 .67838 .48297 .6858 .48558 .68303 .48239 .67562 Mtetra
.297 .264 .652 r
.48239 .67562 .48558 .68303 .48818 .68318 .48498 .67575 Mtetra
0 .074 .603 r
.48498 .67575 .48818 .68318 .49079 .68568 .48757 .67822 Mtetra
0 0 .511 r
.48757 .67822 .49079 .68568 .49341 .68956 .49018 .68205 Mtetra
0 0 .501 r
.49018 .68205 .49341 .68956 .49606 .69358 .49281 .68603 Mtetra
0 .04 .586 r
.49281 .68603 .49606 .69358 .49873 .69647 .49546 .68889 Mtetra
.239 .232 .649 r
.49546 .68889 .49873 .69647 .50141 .69714 .49812 .68954 Mtetra
.488 .362 .635 r
.49812 .68954 .50141 .69714 .50408 .6949 .50079 .6873 Mtetra
.614 .424 .602 r
.50079 .6873 .50408 .6949 .50674 .68958 .50344 .68199 Mtetra
.674 .452 .576 r
.50344 .68199 .50674 .68958 .50937 .68159 .50607 .67403 Mtetra
.702 .464 .561 r
.50607 .67403 .50937 .68159 .51197 .67181 .50868 .66431 Mtetra
.71 .468 .557 r
.50868 .66431 .51197 .67181 .51455 .66145 .51127 .65399 Mtetra
.702 .465 .561 r
.51127 .65399 .51455 .66145 .51712 .65177 .51384 .64435 Mtetra
.675 .453 .576 r
.51384 .64435 .51712 .65177 .5197 .64389 .51642 .63651 Mtetra
.616 .426 .602 r
.51642 .63651 .5197 .64389 .52231 .63863 .51903 .63127 Mtetra
.493 .367 .637 r
.51903 .63127 .52231 .63863 .52497 .63634 .52168 .62897 Mtetra
.254 .244 .654 r
.52168 .62897 .52497 .63634 .52769 .63688 .52438 .62949 Mtetra
0 .062 .6 r
.52438 .62949 .52769 .63688 .53046 .63965 .52713 .63223 Mtetra
0 0 .52 r
.52713 .63223 .53046 .63965 .53328 .64366 .52993 .63619 Mtetra
0 0 .522 r
.52993 .63619 .53328 .64366 .53613 .64768 .53276 .64018 Mtetra
0 .066 .602 r
.53276 .64018 .53613 .64768 .53897 .65048 .53558 .64295 Mtetra
.257 .245 .654 r
.53558 .64295 .53897 .65048 .54177 .65102 .53836 .64346 Mtetra
.493 .366 .635 r
.53836 .64346 .54177 .65102 .5445 .64864 .54109 .64108 Mtetra
.615 .423 .6 r
.54109 .64108 .5445 .64864 .54715 .64325 .54374 .63571 Mtetra
.673 .45 .573 r
.54374 .63571 .54715 .64325 .54972 .6353 .54631 .62779 Mtetra
.7 .461 .559 r
.54631 .62779 .54972 .6353 .55223 .6257 .54882 .61823 Mtetra
.707 .464 .555 r
.54882 .61823 .55223 .6257 .5547 .61564 .55129 .60822 Mtetra
.697 .46 .561 r
.55129 .60822 .5547 .61564 .55718 .60637 .55378 .59899 Mtetra
.666 .447 .577 r
.55378 .59899 .55718 .60637 .55972 .59897 .55631 .59163 Mtetra
.599 .417 .606 r
.55631 .59163 .55972 .59897 .56234 .5942 .55894 .58687 Mtetra
.463 .353 .643 r
.55894 .58687 .56234 .5942 .56508 .59236 .56166 .58502 Mtetra
.212 .225 .656 r
.56166 .58502 .56508 .59236 .56794 .59327 .56451 .58592 Mtetra
0 .055 .6 r
.56451 .58592 .56794 .59327 .57091 .5963 .56746 .58891 Mtetra
0 0 .532 r
.56746 .58891 .57091 .5963 .57395 .60044 .57047 .593 Mtetra
0 0 .542 r
.57047 .593 .57395 .60044 .57701 .60448 .57351 .597 Mtetra
0 .09 .617 r
.57351 .597 .57701 .60448 .58003 .60719 .57652 .59967 Mtetra
.274 .257 .658 r
.57652 .59967 .58003 .60719 .58297 .60758 .57943 .60005 Mtetra
.497 .368 .635 r
.57943 .60005 .58297 .60758 .58576 .60507 .58222 .59753 Mtetra
.615 .422 .598 r
.58222 .59753 .58576 .60507 .58841 .5996 .58487 .59208 Mtetra
.672 .447 .571 r
.58487 .59208 .58841 .5996 .59092 .59168 .58738 .58419 Mtetra
.698 .457 .556 r
.58738 .58419 .59092 .59168 .59333 .58223 .58979 .57479 Mtetra
.703 .46 .553 r
.58979 .57479 .59333 .58223 .59571 .57246 .59217 .56506 Mtetra
.691 .455 .56 r
.59217 .56506 .59571 .57246 .59812 .56357 .59459 .55622 Mtetra
.656 .44 .58 r
.59459 .55622 .59812 .56357 .60063 .55663 .5971 .5493 Mtetra
.58 .408 .612 r
.5971 .5493 .60063 .55663 .6033 .55233 .59976 .54501 Mtetra
.43 .338 .65 r
.59976 .54501 .6033 .55233 .60615 .55093 .60261 .5436 Mtetra
.172 .208 .657 r
.60261 .5436 .60615 .55093 .60919 .5522 .60563 .54485 Mtetra
0 .051 .601 r
.60563 .54485 .60919 .5522 .61239 .55548 .6088 .54809 Mtetra
0 0 .545 r
.6088 .54809 .61239 .55548 .61567 .55975 .61206 .55231 Mtetra
0 0 .562 r
.61206 .55231 .61567 .55975 .61897 .56379 .61534 .55631 Mtetra
0 .113 .63 r
.61534 .55631 .61897 .56379 .6222 .56641 .61854 .5589 Mtetra
.289 .267 .661 r
.61854 .5589 .6222 .56641 .62527 .56666 .62159 .55913 Mtetra
.501 .37 .634 r
.62159 .55913 .62527 .56666 .62813 .56401 .62445 .55648 Mtetra
.615 .421 .595 r
.62445 .55648 .62813 .56401 .63078 .55846 .62709 .55095 Mtetra
.671 .444 .568 r
.62709 .55095 .63078 .55846 .63323 .55055 .62955 .54307 Mtetra
.695 .453 .553 r
.62955 .54307 .63323 .55055 .63556 .54125 .63188 .53381 Mtetra
.699 .455 .551 r
.63188 .53381 .63556 .54125 .63785 .53174 .63417 .52434 Mtetra
.684 .449 .56 r
.63417 .52434 .63785 .53174 .6402 .52322 .63653 .51587 Mtetra
.644 .433 .583 r
.63653 .51587 .6402 .52322 .64272 .51671 .63905 .50938 Mtetra
.56 .397 .618 r
.63905 .50938 .64272 .51671 .64546 .51286 .64178 .50554 Mtetra
.397 .323 .656 r
.64178 .50554 .64546 .51286 .64846 .51188 .64477 .50455 Mtetra
.136 .193 .658 r
.64477 .50455 .64846 .51188 .65172 .5135 .64801 .50614 Mtetra
0 .051 .604 r
.64801 .50614 .65172 .5135 .65517 .51703 .65143 .50963 Mtetra
0 0 .559 r
.65143 .50963 .65517 .51703 .65874 .52142 .65497 .51397 Mtetra
0 .014 .581 r
.65497 .51397 .65874 .52142 .6623 .52547 .65851 .51798 Mtetra
.026 .134 .642 r
.65851 .51798 .6623 .52547 .66574 .52801 .66193 .52048 Mtetra
.303 .277 .663 r
.66193 .52048 .66574 .52801 .66896 .52812 .66513 .52057 Mtetra
.505 .371 .633 r
.66513 .52057 .66896 .52812 .6719 .52532 .66806 .51778 Mtetra
.615 .419 .593 r
.66806 .51778 .6719 .52532 .67455 .51968 .6707 .51216 Mtetra
.669 .44 .565 r
.6707 .51216 .67455 .51968 .67695 .51178 .67311 .50429 Mtetra
.692 .449 .55 r
.67311 .50429 .67695 .51178 .67919 .5026 .67536 .49515 Mtetra
.694 .45 .549 r
.67536 .49515 .67919 .5026 .68141 .49333 .67758 .48592 Mtetra
.676 .443 .56 r
.67758 .48592 .68141 .49333 .68373 .48516 .6799 .47779 Mtetra
.631 .425 .586 r
.6799 .47779 .68373 .48516 .68627 .47907 .68245 .47172 Mtetra
.537 .387 .625 r
.68245 .47172 .68627 .47907 .68912 .47565 .68529 .46831 Mtetra
.362 .308 .662 r
.68529 .46831 .68912 .47565 .69231 .47508 .68846 .46772 Mtetra
.103 .18 .659 r
.68846 .46772 .69231 .47508 .69582 .47705 .69195 .46966 Mtetra
0 .055 .608 r
.69195 .46966 .69582 .47705 .69957 .48082 .69567 .47339 Mtetra
0 .001 .575 r
.69567 .47339 .69957 .48082 .70345 .48534 .69952 .47786 Mtetra
0 .039 .599 r
.69952 .47786 .70345 .48534 .70731 .4894 .70335 .48187 Mtetra
.054 .154 .652 r
.70335 .48187 .70731 .4894 .71099 .49185 .70701 .48429 Mtetra
.316 .285 .665 r
.70701 .48429 .71099 .49185 .71437 .49182 .71037 .48424 Mtetra
.508 .372 .631 r
.71037 .48424 .71437 .49182 .71739 .48888 .71338 .48129 Mtetra
.614 .416 .591 r
.71338 .48129 .71739 .48888 .72004 .48314 .71602 .47557 Mtetra
.667 .436 .562 r
.71602 .47557 .72004 .48314 .72239 .47523 .71837 .4677 Mtetra
.689 .444 .547 r
.71837 .4677 .72239 .47523 .72456 .46615 .72055 .45867 Mtetra
.72055 .45867 .72456 .46615 .72671 .45711 .72271 .44967 Mtetra
.668 .437 .561 r
.72271 .44967 .72671 .45711 .72902 .44928 .72502 .44187 Mtetra
.616 .418 .59 r
.72502 .44187 .72902 .44928 .73162 .44358 .72762 .43619 Mtetra
.512 .376 .632 r
.72762 .43619 .73162 .44358 .73462 .44059 .73061 .4332 Mtetra
.327 .294 .668 r
.73061 .4332 .73462 .44059 .73804 .44043 .73401 .43302 Mtetra
.076 .171 .661 r
.73401 .43302 .73804 .44043 .74185 .44274 .73779 .43529 Mtetra
0 .062 .615 r
.73779 .43529 .74185 .44274 .74594 .44675 .74186 .43926 Mtetra
0 .022 .59 r
.74186 .43926 .74594 .44675 .75018 .4514 .74606 .44386 Mtetra
0 .064 .616 r
.74606 .44386 .75018 .4514 .75436 .45547 .75021 .44788 Mtetra
.08 .172 .661 r
.75021 .44788 .75436 .45547 .7583 .45784 .75413 .45021 Mtetra
.327 .293 .667 r
.75413 .45021 .7583 .45784 .76186 .45766 .75767 .45002 Mtetra
.51 .373 .63 r
.75767 .45002 .76186 .45766 .76497 .45457 .76076 .44693 Mtetra
.613 .414 .588 r
.76076 .44693 .76497 .45457 .76762 .44872 .76341 .4411 Mtetra
.664 .432 .558 r
.76341 .4411 .76762 .44872 .76992 .44079 .76571 .4332 Mtetra
.685 .439 .544 r
.76571 .4332 .76992 .44079 .77202 .43181 .76782 .42426 Mtetra
.683 .439 .546 r
.76782 .42426 .77202 .43181 .77413 .42298 .76994 .41547 Mtetra
.658 .43 .563 r
.76994 .41547 .77413 .42298 .77645 .41546 .77226 .40799 Mtetra
.6 .409 .595 r
.77226 .40799 .77645 .41546 .77914 .41015 .77495 .40269 Mtetra
.486 .364 .639 r
.77495 .40269 .77914 .41015 .78232 .40757 .77812 .40012 Mtetra
.293 .28 .673 r
.77812 .40012 .78232 .40757 .78602 .40781 .78179 .40033 Mtetra
.054 .165 .663 r
.78179 .40033 .78602 .40781 .79018 .41046 .78593 .40294 Mtetra
0 .071 .623 r
.78593 .40294 .79018 .41046 .79468 .41472 .79039 .40715 Mtetra
0 .042 .605 r
.79039 .40715 .79468 .41472 .79931 .4195 .79499 .41188 Mtetra
0 .087 .631 r
.79499 .41188 .79931 .4195 .80385 .42359 .7995 .41592 Mtetra
.104 .189 .669 r
.7995 .41592 .80385 .42359 .80809 .42588 .8037 .41817 Mtetra
.338 .299 .668 r
.8037 .41817 .80809 .42588 .81185 .42556 .80744 .41783 Mtetra
.512 .373 .628 r
.80744 .41783 .81185 .42556 .81505 .42231 .81063 .41458 Mtetra
.612 .41 .585 r
.81063 .41458 .81505 .42231 .81771 .41634 .81329 .40863 Mtetra
.662 .428 .555 r
.81329 .40863 .81771 .41634 .81996 .40837 .81554 .4007 Mtetra
.681 .434 .541 r
.81554 .4007 .81996 .40837 .822 .39946 .81759 .39184 Mtetra
.677 .432 .545 r
.81759 .39184 .822 .39946 .82408 .39083 .81967 .38325 Mtetra
.647 .423 .564 r
.81967 .38325 .82408 .39083 .82643 .38361 .82203 .37606 Mtetra
.582 .4 .601 r
.82203 .37606 .82643 .38361 .82925 .37868 .82484 .37114 Mtetra
.458 .353 .647 r
.82484 .37114 .82925 .37868 .83267 .37652 .82825 .36897 Mtetra
.261 .268 .678 r
.82825 .36897 .83267 .37652 .8367 .37715 .83226 .36958 Mtetra
.038 .161 .666 r
.83226 .36958 .8367 .37715 .84128 .38015 .8368 .37253 Mtetra
0 .082 .631 r
.8368 .37253 .84128 .38015 .84624 .38467 .84172 .377 Mtetra
0 .063 .62 r
.84172 .377 .84624 .38467 .85132 .38959 .84677 .38186 Mtetra
0 .109 .645 r
.84677 .38186 .85132 .38959 .85628 .3937 .85168 .38592 Mtetra
.126 .204 .675 r
.85168 .38592 .85628 .3937 .86084 .3959 .85621 .38808 Mtetra
.347 .305 .668 r
.85621 .38808 .86084 .3959 .86481 .39543 .86016 .38759 Mtetra
.683 .509 .645 r
.41854 .7836 .42172 .78852 .42439 .78334 .42121 .77842 Mtetra
.737 .522 .603 r
.42121 .77842 .42439 .78334 .42716 .77527 .42399 .77036 Mtetra
.759 .527 .581 r
.42399 .77036 .42716 .77527 .42998 .76514 .42681 .76026 Mtetra
.766 .528 .574 r
.42681 .76026 .42998 .76514 .43281 .75415 .42966 .74929 Mtetra
.763 .528 .577 r
.42966 .74929 .43281 .75415 .43561 .74361 .43247 .73878 Mtetra
.748 .525 .592 r
.43247 .73878 .43561 .74361 .43835 .73474 .43521 .72992 Mtetra
.711 .517 .624 r
.43521 .72992 .43835 .73474 .44101 .72843 .43787 .72363 Mtetra
.618 .49 .684 r
.43787 .72363 .44101 .72843 .44358 .72516 .44044 .72036 Mtetra
.35 .385 .756 r
.44044 .72036 .44358 .72516 .44608 .72489 .44293 .72008 Mtetra
0 .08 .641 r
.44293 .72008 .44608 .72489 .44854 .72708 .44537 .72225 Mtetra
0 0 .392 r
.44537 .72225 .44854 .72708 .45097 .73077 .4478 .72593 Mtetra
.63 .196 0 r
.4478 .72593 .45097 .73077 .45342 .73474 .45023 .72987 Mtetra
0 0 .533 r
.45023 .72987 .45342 .73474 .45591 .73769 .45271 .7328 Mtetra
.152 .289 .751 r
.45271 .7328 .45591 .73769 .45846 .73848 .45525 .73358 Mtetra
.545 .464 .714 r
.45525 .73358 .45846 .73848 .46107 .73637 .45785 .73146 Mtetra
.684 .509 .643 r
.45785 .73146 .46107 .73637 .46374 .73113 .46052 .72623 Mtetra
.737 .521 .6 r
.46052 .72623 .46374 .73113 .46643 .72312 .46322 .71824 Mtetra
.759 .525 .579 r
.46322 .71824 .46643 .72312 .46915 .7132 .46594 .70834 Mtetra
.766 .526 .572 r
.46594 .70834 .46915 .7132 .47185 .70256 .46865 .69773 Mtetra
.761 .526 .576 r
.46865 .69773 .47185 .70256 .47453 .69249 .47134 .68768 Mtetra
.744 .523 .594 r
.47134 .68768 .47453 .69249 .47718 .68415 .47399 .67935 Mtetra
.7 .513 .632 r
.47399 .67935 .47718 .68415 .4798 .67838 .47661 .6736 Mtetra
.59 .481 .698 r
.47661 .6736 .4798 .67838 .48239 .67562 .4792 .67083 Mtetra
.282 .356 .762 r
.4792 .67083 .48239 .67562 .48498 .67575 .48178 .67095 Mtetra
0 .054 .62 r
.48178 .67095 .48498 .67575 .48757 .67822 .48436 .67341 Mtetra
0 0 .405 r
.48436 .67341 .48757 .67822 .49018 .68205 .48695 .67722 Mtetra
.595 .165 0 r
.48695 .67722 .49018 .68205 .49281 .68603 .48956 .68117 Mtetra
0 .001 .573 r
.48956 .68117 .49281 .68603 .49546 .68889 .4922 .68401 Mtetra
.187 .31 .758 r
.4922 .68401 .49546 .68889 .49812 .68954 .49485 .68465 Mtetra
.552 .467 .713 r
.49485 .68465 .49812 .68954 .50079 .6873 .49751 .6824 Mtetra
.686 .508 .641 r
.49751 .6824 .50079 .6873 .50344 .68199 .50017 .6771 Mtetra
.738 .52 .598 r
.50017 .6771 .50344 .68199 .50607 .67403 .50281 .66916 Mtetra
.759 .523 .577 r
.50281 .66916 .50607 .67403 .50868 .66431 .50542 .65946 Mtetra
.765 .524 .57 r
.50542 .65946 .50868 .66431 .51127 .65399 .50801 .64917 Mtetra
.759 .524 .576 r
.50801 .64917 .51127 .65399 .51384 .64435 .5106 .63955 Mtetra
.738 .52 .597 r
.5106 .63955 .51384 .64435 .51642 .63651 .51318 .63173 Mtetra
.687 .509 .64 r
.51318 .63173 .51642 .63651 .51903 .63127 .51579 .62649 Mtetra
.557 .47 .712 r
.51579 .62649 .51903 .63127 .52168 .62897 .51843 .62419 Mtetra
.213 .325 .763 r
.51843 .62419 .52168 .62897 .52438 .62949 .52112 .6247 Mtetra
0 .036 .603 r
.52112 .6247 .52438 .62949 .52713 .63223 .52386 .62741 Mtetra
0 0 .422 r
.52386 .62741 .52713 .63223 .52993 .63619 .52665 .63136 Mtetra
0 0 .424 r
.52665 .63136 .52993 .63619 .53276 .64018 .52945 .63532 Mtetra
0 .041 .608 r
.52945 .63532 .53276 .64018 .53558 .64295 .53226 .63806 Mtetra
.218 .327 .762 r
.53226 .63806 .53558 .64295 .53836 .64346 .53503 .63856 Mtetra
.558 .469 .711 r
.53503 .63856 .53836 .64346 .54109 .64108 .53775 .63618 Mtetra
.687 .508 .639 r
.53775 .63618 .54109 .64108 .54374 .63571 .5404 .63082 Mtetra
.738 .518 .595 r
.5404 .63082 .54374 .63571 .54631 .62779 .54298 .62292 Mtetra
.759 .522 .574 r
.54298 .62292 .54631 .62779 .54882 .61823 .54549 .61338 Mtetra
.764 .522 .568 r
.54549 .61338 .54882 .61823 .55129 .60822 .54798 .60339 Mtetra
.756 .521 .577 r
.54798 .60339 .55129 .60822 .55378 .59899 .55047 .59419 Mtetra
.732 .517 .602 r
.55047 .59419 .55378 .59899 .55631 .59163 .55301 .58684 Mtetra
.672 .505 .65 r
.55301 .58684 .55631 .59163 .55894 .58687 .55563 .58208 Mtetra
.52 .457 .727 r
.55563 .58208 .55894 .58687 .56166 .58502 .55836 .58024 Mtetra
.145 .295 .759 r
.55836 .58024 .56166 .58502 .56451 .58592 .56119 .58111 Mtetra
0 .025 .593 r
.56119 .58111 .56451 .58592 .56746 .58891 .56412 .58408 Mtetra
0 0 .443 r
.56412 .58408 .56746 .58891 .57047 .593 .56712 .58815 Mtetra
0 0 .462 r
.56712 .58815 .57047 .593 .57351 .597 .57014 .59212 Mtetra
0 .079 .639 r
.57014 .59212 .57351 .597 .57652 .59967 .57313 .59478 Mtetra
.245 .343 .766 r
.57313 .59478 .57652 .59967 .57943 .60005 .57604 .59514 Mtetra
.563 .471 .709 r
.57604 .59514 .57943 .60005 .58222 .59753 .57882 .59262 Mtetra
.688 .507 .637 r
.57882 .59262 .58222 .59753 .58487 .59208 .58146 .58718 Mtetra
.738 .517 .593 r
.58146 .58718 .58487 .59208 .58738 .58419 .58398 .57931 Mtetra
.758 .52 .572 r
.58398 .57931 .58738 .58419 .58979 .57479 .5864 .56993 Mtetra
.763 .52 .567 r
.5864 .56993 .58979 .57479 .59217 .56506 .58879 .56022 Mtetra
.753 .519 .577 r
.58879 .56022 .59217 .56506 .59459 .55622 .59121 .5514 Mtetra
.724 .515 .607 r
.59121 .5514 .59459 .55622 .5971 .5493 .59373 .5445 Mtetra
.654 .499 .662 r
.59373 .5445 .5971 .5493 .59976 .54501 .59639 .54021 Mtetra
.477 .442 .74 r
.59639 .54021 .59976 .54501 .60261 .5436 .59923 .53879 Mtetra
.081 .265 .752 r
.59923 .53879 .60261 .5436 .60563 .54485 .60223 .54003 Mtetra
0 .021 .587 r
.60223 .54003 .60563 .54485 .6088 .54809 .60539 .54325 Mtetra
0 0 .466 r
.60539 .54325 .6088 .54809 .61206 .55231 .60863 .54744 Mtetra
0 0 .5 r
.60863 .54744 .61206 .55231 .61534 .55631 .61189 .55141 Mtetra
0 .114 .667 r
.61189 .55141 .61534 .55631 .61854 .5589 .61508 .55398 Mtetra
.27 .356 .768 r
.61508 .55398 .61854 .5589 .62159 .55913 .61812 .5542 Mtetra
.568 .473 .707 r
.61812 .5542 .62159 .55913 .62445 .55648 .62097 .55154 Mtetra
.689 .506 .634 r
.62097 .55154 .62445 .55648 .62709 .55095 .62361 .54602 Mtetra
.738 .515 .59 r
.62361 .54602 .62709 .55095 .62955 .54307 .62607 .53817 Mtetra
.758 .517 .569 r
.62607 .53817 .62955 .54307 .63188 .53381 .62841 .52892 Mtetra
.761 .518 .565 r
.62841 .52892 .63188 .53381 .63417 .52434 .63072 .51948 Mtetra
.749 .516 .579 r
.63072 .51948 .63417 .52434 .63653 .51587 .63308 .51102 Mtetra
.715 .511 .613 r
.63308 .51102 .63653 .51587 .63905 .50938 .6356 .50455 Mtetra
.633 .493 .674 r
.6356 .50455 .63905 .50938 .64178 .50554 .63833 .50071 Mtetra
.43 .425 .753 r
.63833 .50071 .64178 .50554 .64477 .50455 .64131 .49971 Mtetra
.025 .24 .743 r
.64131 .49971 .64477 .50455 .64801 .50614 .64453 .50129 Mtetra
0 .022 .587 r
.64453 .50129 .64801 .50614 .65143 .50963 .64794 .50475 Mtetra
0 0 .492 r
.64794 .50475 .65143 .50963 .65497 .51397 .65146 .50906 Mtetra
0 0 .536 r
.65146 .50906 .65497 .51397 .65851 .51798 .65497 .51304 Mtetra
0 .147 .69 r
.65497 .51304 .65851 .51798 .66193 .52048 .65838 .51552 Mtetra
.292 .368 .769 r
.65838 .51552 .66193 .52048 .66513 .52057 .66157 .5156 Mtetra
.572 .474 .705 r
.66157 .5156 .66513 .52057 .66806 .51778 .66449 .5128 Mtetra
.69 .505 .632 r
.66449 .5128 .66806 .51778 .6707 .51216 .66714 .50719 Mtetra
.738 .513 .587 r
.66714 .50719 .6707 .51216 .67311 .50429 .66954 .49934 Mtetra
.757 .515 .566 r
.66954 .49934 .67311 .50429 .67536 .49515 .6718 .49022 Mtetra
.759 .515 .564 r
.6718 .49022 .67536 .49515 .67758 .48592 .67403 .48102 Mtetra
.744 .514 .581 r
.67403 .48102 .67758 .48592 .6799 .47779 .67636 .47291 Mtetra
.704 .508 .62 r
.67636 .47291 .6799 .47779 .68245 .47172 .67891 .46684 Mtetra
.608 .486 .688 r
.67891 .46684 .68245 .47172 .68529 .46831 .68175 .46344 Mtetra
.38 .407 .763 r
.68175 .46344 .68529 .46831 .68846 .46772 .68491 .46284 Mtetra
0 .218 .734 r
.68491 .46284 .68846 .46772 .69195 .46966 .68838 .46476 Mtetra
0 .028 .592 r
.68838 .46476 .69195 .46966 .69567 .47339 .69208 .46846 Mtetra
0 0 .518 r
.69208 .46846 .69567 .47339 .69952 .47786 .69591 .4729 Mtetra
0 .007 .57 r
.69591 .4729 .69952 .47786 .70335 .48187 .69972 .47688 Mtetra
0 .177 .71 r
.69972 .47688 .70335 .48187 .70701 .48429 .70336 .47928 Mtetra
.311 .378 .77 r
.70336 .47928 .70701 .48429 .71037 .48424 .70671 .47921 Mtetra
.575 .475 .703 r
.70671 .47921 .71037 .48424 .71338 .48129 .70971 .47627 Mtetra
.69 .503 .63 r
.70971 .47627 .71338 .48129 .71602 .47557 .71236 .47056 Mtetra
.738 .511 .584 r
.71236 .47056 .71602 .47557 .71837 .4677 .71471 .4627 Mtetra
.756 .513 .564 r
.71471 .4627 .71837 .4677 .72055 .45867 .7169 .45369 Mtetra
.757 .513 .563 r
.7169 .45369 .72055 .45867 .72271 .44967 .71907 .44472 Mtetra
.739 .511 .584 r
.71907 .44472 .72271 .44967 .72502 .44187 .72138 .43693 Mtetra
.692 .504 .629 r
.72138 .43693 .72502 .44187 .72762 .43619 .72399 .43126 Mtetra
.58 .477 .702 r
.72399 .43126 .72762 .43619 .73061 .4332 .72696 .42828 Mtetra
.328 .387 .771 r
.72696 .42828 .73061 .4332 .73401 .43302 .73035 .42808 Mtetra
0 .201 .726 r
.73035 .42808 .73401 .43302 .73779 .43529 .73412 .43033 Mtetra
0 .038 .6 r
.73412 .43033 .73779 .43529 .74186 .43926 .73816 .43427 Mtetra
0 0 .546 r
.73816 .43427 .74186 .43926 .74606 .44386 .74234 .43884 Mtetra
0 .041 .602 r
.74234 .43884 .74606 .44386 .75021 .44788 .74647 .44283 Mtetra
0 .204 .727 r
.74647 .44283 .75021 .44788 .75413 .45021 .75037 .44514 Mtetra
.328 .386 .77 r
.75037 .44514 .75413 .45021 .75767 .45002 .7539 .44493 Mtetra
.578 .475 .701 r
.7539 .44493 .75767 .45002 .76076 .44693 .75698 .44184 Mtetra
.691 .502 .627 r
.75698 .44184 .76076 .44693 .76341 .4411 .75964 .43602 Mtetra
.738 .508 .581 r
.75964 .43602 .76341 .4411 .76571 .4332 .76194 .42814 Mtetra
.755 .51 .561 r
.76194 .42814 .76571 .4332 .76782 .42426 .76406 .41922 Mtetra
.754 .51 .563 r
.76406 .41922 .76782 .42426 .76994 .41547 .76618 .41046 Mtetra
.732 .508 .587 r
.76618 .41046 .76994 .41547 .77226 .40799 .76851 .40299 Mtetra
.677 .5 .639 r
.76851 .40299 .77226 .40799 .77495 .40269 .7712 .3977 Mtetra
.548 .468 .717 r
.7712 .3977 .77495 .40269 .77812 .40012 .77436 .39512 Mtetra
.277 .367 .776 r
.77436 .39512 .77812 .40012 .78179 .40033 .77802 .39532 Mtetra
0 .189 .72 r
.77802 .39532 .78179 .40033 .78593 .40294 .78214 .39791 Mtetra
0 .051 .611 r
.78214 .39791 .78593 .40294 .79039 .40715 .78657 .40209 Mtetra
0 .013 .573 r
.78657 .40209 .79039 .40715 .79499 .41188 .79114 .40678 Mtetra
0 .074 .631 r
.79114 .40678 .79499 .41188 .7995 .41592 .79563 .41079 Mtetra
0 .228 .741 r
.79563 .41079 .7995 .41592 .8037 .41817 .79982 .41302 Mtetra
.344 .394 .77 r
.79982 .41302 .8037 .41817 .80744 .41783 .80354 .41266 Mtetra
.581 .475 .699 r
.80354 .41266 .80744 .41783 .81063 .41458 .80672 .40941 Mtetra
.691 .5 .624 r
.80672 .40941 .81063 .41458 .81329 .40863 .80938 .40348 Mtetra
.737 .506 .578 r
.80938 .40348 .81329 .40863 .81554 .4007 .81164 .39556 Mtetra
.754 .507 .559 r
.81164 .39556 .81554 .4007 .81759 .39184 .8137 .38672 Mtetra
.75 .507 .563 r
.8137 .38672 .81759 .39184 .81967 .38325 .81579 .37815 Mtetra
.724 .505 .592 r
.81579 .37815 .81967 .38325 .82203 .37606 .81815 .37098 Mtetra
.66 .495 .65 r
.81815 .37098 .82203 .37606 .82484 .37114 .82096 .36607 Mtetra
.512 .456 .731 r
.82096 .36607 .82484 .37114 .82825 .36897 .82436 .36389 Mtetra
.228 .348 .778 r
.82436 .36389 .82825 .36897 .83226 .36958 .82835 .36449 Mtetra
0 .183 .716 r
.82835 .36449 .83226 .36958 .8368 .37253 .83287 .36741 Mtetra
0 .067 .624 r
.83287 .36741 .8368 .37253 .84172 .377 .83776 .37184 Mtetra
0 .041 .6 r
.83776 .37184 .84172 .377 .84677 .38186 .84278 .37667 Mtetra
0 .105 .658 r
.84278 .37667 .84677 .38186 .85168 .38592 .84767 .3807 Mtetra
.023 .25 .753 r
.84767 .3807 .85168 .38592 .85621 .38808 .85218 .38284 Mtetra
.357 .4 .769 r
.85218 .38284 .85621 .38808 .86016 .38759 .85612 .38234 Mtetra
.801 .658 .704 r
.41525 .78187 .41854 .7836 .42121 .77842 .41792 .7767 Mtetra
.826 .624 .629 r
.41792 .7767 .42121 .77842 .42399 .77036 .4207 .76864 Mtetra
.834 .609 .598 r
.4207 .76864 .42399 .77036 .42681 .76026 .42355 .75853 Mtetra
.836 .603 .587 r
.42355 .75853 .42681 .76026 .42966 .74929 .4264 .74756 Mtetra
.835 .605 .591 r
.4264 .74756 .42966 .74929 .43247 .73878 .42923 .73705 Mtetra
.83 .616 .613 r
.42923 .73705 .43247 .73878 .43521 .72992 .43198 .72819 Mtetra
.815 .64 .665 r
.43198 .72819 .43521 .72992 .43787 .72363 .43464 .72189 Mtetra
.753 .688 .789 r
.43464 .72189 .43787 .72363 .44044 .72036 .43721 .71862 Mtetra
.316 .641 .966 r
.43721 .71862 .44044 .72036 .44293 .72008 .4397 .71834 Mtetra
.558 0 0 r
.4397 .71834 .44293 .72008 .44537 .72225 .44214 .7205 Mtetra
.727 .2 0 r
.44214 .7205 .44537 .72225 .4478 .72593 .44455 .72417 Mtetra
.741 .222 0 r
.44455 .72417 .4478 .72593 .45023 .72987 .44697 .72811 Mtetra
.66 .105 0 r
.44697 .72811 .45023 .72987 .45271 .7328 .44944 .73104 Mtetra
0 .405 .798 r
.44944 .73104 .45271 .7328 .45525 .73358 .45197 .73181 Mtetra
.676 .711 .875 r
.45197 .73181 .45525 .73358 .45785 .73146 .45458 .72969 Mtetra
.803 .657 .701 r
.45458 .72969 .45785 .73146 .46052 .72623 .45724 .72446 Mtetra
.829 .625 .627 r
.45724 .72446 .46052 .72623 .46322 .71824 .45995 .71646 Mtetra
.836 .61 .595 r
.45995 .71646 .46322 .71824 .46594 .70834 .46268 .70656 Mtetra
.838 .605 .585 r
.46268 .70656 .46594 .70834 .46865 .69773 .46541 .69595 Mtetra
.837 .608 .591 r
.46541 .69595 .46865 .69773 .47134 .68768 .46811 .6859 Mtetra
.831 .62 .618 r
.46811 .6859 .47134 .68768 .47399 .67935 .47077 .67757 Mtetra
.811 .648 .68 r
.47077 .67757 .47399 .67935 .47661 .6736 .4734 .67181 Mtetra
.726 .698 .824 r
.4734 .67181 .47661 .6736 .4792 .67083 .47599 .66904 Mtetra
.166 .569 .934 r
.47599 .66904 .4792 .67083 .48178 .67095 .47856 .66916 Mtetra
.581 .01 0 r
.47856 .66916 .48178 .67095 .48436 .67341 .48113 .67161 Mtetra
.72 .189 0 r
.48113 .67161 .48436 .67341 .48695 .67722 .48371 .67541 Mtetra
.727 .199 0 r
.48371 .67541 .48695 .67722 .48956 .68117 .48631 .67936 Mtetra
.628 .065 0 r
.48631 .67936 .48956 .68117 .4922 .68401 .48894 .6822 Mtetra
0 .452 .845 r
.48894 .6822 .4922 .68401 .49485 .68465 .49159 .68283 Mtetra
.683 .709 .867 r
.49159 .68283 .49485 .68465 .49751 .6824 .49425 .68058 Mtetra
.806 .658 .699 r
.49425 .68058 .49751 .6824 .50017 .6771 .49691 .67528 Mtetra
.831 .626 .625 r
.49691 .67528 .50017 .6771 .50281 .66916 .49955 .66734 Mtetra
.839 .611 .593 r
.49955 .66734 .50281 .66916 .50542 .65946 .50218 .65763 Mtetra
.841 .606 .583 r
.50218 .65763 .50542 .65946 .50801 .64917 .50479 .64734 Mtetra
.839 .61 .592 r
.50479 .64734 .50801 .64917 .5106 .63955 .50738 .63772 Mtetra
.831 .625 .624 r
.50738 .63772 .5106 .63955 .51318 .63173 .50997 .62989 Mtetra
.806 .656 .697 r
.50997 .62989 .51318 .63173 .51579 .62649 .51258 .62465 Mtetra
.687 .705 .861 r
.51258 .62465 .51579 .62649 .51843 .62419 .51523 .62235 Mtetra
.023 .486 .877 r
.51523 .62235 .51843 .62419 .52112 .6247 .51791 .62285 Mtetra
.595 .028 0 r
.51791 .62285 .52112 .6247 .52386 .62741 .52064 .62556 Mtetra
.712 .176 0 r
.52064 .62556 .52386 .62741 .52665 .63136 .52341 .6295 Mtetra
.711 .174 0 r
.52341 .6295 .52665 .63136 .52945 .63532 .52621 .63346 Mtetra
.591 .022 0 r
.52621 .63346 .52945 .63532 .53226 .63806 .52901 .6362 Mtetra
.032 .492 .881 r
.52901 .6362 .53226 .63806 .53503 .63856 .53177 .6367 Mtetra
.69 .707 .861 r
.53177 .6367 .53503 .63856 .53775 .63618 .53449 .63431 Mtetra
.808 .658 .696 r
.53449 .63431 .53775 .63618 .5404 .63082 .53715 .62894 Mtetra
.834 .627 .622 r
.53715 .62894 .5404 .63082 .54298 .62292 .53973 .62104 Mtetra
.842 .612 .59 r
.53973 .62104 .54298 .62292 .54549 .61338 .54226 .6115 Mtetra
.844 .608 .582 r
.54226 .6115 .54549 .61338 .54798 .60339 .54476 .60151 Mtetra
.841 .614 .594 r
.54476 .60151 .54798 .60339 .55047 .59419 .54726 .59231 Mtetra
.831 .631 .631 r
.54726 .59231 .55047 .59419 .55301 .58684 .54981 .58495 Mtetra
.797 .665 .718 r
.54981 .58495 .55301 .58684 .55563 .58208 .55243 .5802 Mtetra
.635 .706 .898 r
.55243 .5802 .55563 .58208 .55836 .58024 .55515 .57834 Mtetra
0 .404 .811 r
.55515 .57834 .55836 .58024 .56119 .58111 .55798 .57922 Mtetra
.602 .036 0 r
.55798 .57922 .56119 .58111 .56412 .58408 .5609 .58218 Mtetra
.7 .159 0 r
.5609 .58218 .56412 .58408 .56712 .58815 .56389 .58625 Mtetra
.691 .146 0 r
.56389 .58625 .56712 .58815 .57014 .59212 .5669 .59021 Mtetra
.548 0 0 r
.5669 .59021 .57014 .59212 .57313 .59478 .56988 .59286 Mtetra
.095 .524 .908 r
.56988 .59286 .57313 .59478 .57604 .59514 .57278 .59322 Mtetra
.696 .706 .855 r
.57278 .59322 .57604 .59514 .57882 .59262 .57556 .59069 Mtetra
.811 .659 .694 r
.57556 .59069 .57882 .59262 .58146 .58718 .57821 .58525 Mtetra
.837 .628 .619 r
.57821 .58525 .58146 .58718 .58398 .57931 .58073 .57738 Mtetra
.845 .613 .587 r
.58073 .57738 .58398 .57931 .5864 .56993 .58317 .56799 Mtetra
.847 .61 .581 r
.58317 .56799 .5864 .56993 .58879 .56022 .58557 .55829 Mtetra
.843 .617 .596 r
.58557 .55829 .58879 .56022 .59121 .5514 .588 .54946 Mtetra
.83 .637 .641 r
.588 .54946 .59121 .5514 .59373 .5445 .59052 .54256 Mtetra
.786 .675 .742 r
.59052 .54256 .59373 .5445 .59639 .54021 .59319 .53827 Mtetra
.566 .698 .93 r
.59319 .53827 .59639 .54021 .59923 .53879 .59602 .53685 Mtetra
0 .333 .749 r
.59602 .53685 .59923 .53879 .60223 .54003 .59902 .53808 Mtetra
.602 .038 0 r
.59902 .53808 .60223 .54003 .60539 .54325 .60216 .54129 Mtetra
.685 .14 0 r
.60216 .54129 .60539 .54325 .60863 .54744 .60539 .54548 Mtetra
.667 .116 0 r
.60539 .54548 .60863 .54744 .61189 .55141 .60864 .54944 Mtetra
.501 0 0 r
.60864 .54944 .61189 .55141 .61508 .55398 .61182 .55201 Mtetra
.151 .551 .927 r
.61182 .55201 .61508 .55398 .61812 .5542 .61485 .55222 Mtetra
.702 .705 .85 r
.61485 .55222 .61812 .5542 .62097 .55154 .6177 .54956 Mtetra
.814 .66 .692 r
.6177 .54956 .62097 .55154 .62361 .54602 .62035 .54404 Mtetra
.841 .629 .616 r
.62035 .54404 .62361 .54602 .62607 .53817 .62282 .53618 Mtetra
.848 .615 .585 r
.62282 .53618 .62607 .53817 .62841 .52892 .62517 .52693 Mtetra
.85 .613 .58 r
.62517 .52693 .62841 .52892 .63072 .51948 .62749 .51749 Mtetra
.845 .621 .599 r
.62749 .51749 .63072 .51948 .63308 .51102 .62986 .50903 Mtetra
.829 .644 .653 r
.62986 .50903 .63308 .51102 .6356 .50455 .63239 .50255 Mtetra
.769 .685 .77 r
.63239 .50255 .6356 .50455 .63833 .50071 .63512 .49871 Mtetra
.481 .679 .952 r
.63512 .49871 .63833 .50071 .64131 .49971 .6381 .4977 Mtetra
0 .276 .698 r
.6381 .4977 .64131 .49971 .64453 .50129 .64131 .49928 Mtetra
.597 .034 0 r
.64131 .49928 .64453 .50129 .64794 .50475 .64471 .50273 Mtetra
.667 .118 0 r
.64471 .50273 .64794 .50475 .65146 .50906 .64821 .50704 Mtetra
.639 .083 0 r
.64821 .50704 .65146 .50906 .65497 .51304 .65171 .51101 Mtetra
.449 0 0 r
.65171 .51101 .65497 .51304 .65838 .51552 .65511 .51349 Mtetra
.2 .572 .939 r
.65511 .51349 .65838 .51552 .66157 .5156 .65829 .51356 Mtetra
.707 .704 .845 r
.65829 .51356 .66157 .5156 .66449 .5128 .66122 .51076 Mtetra
.817 .661 .689 r
.66122 .51076 .66449 .5128 .66714 .50719 .66386 .50515 Mtetra
.844 .631 .613 r
.66386 .50515 .66714 .50719 .66954 .49934 .66628 .49729 Mtetra
.852 .617 .582 r
.66628 .49729 .66954 .49934 .6718 .49022 .66855 .48817 Mtetra
.853 .615 .579 r
.66855 .48817 .6718 .49022 .67403 .48102 .67079 .47897 Mtetra
.847 .626 .604 r
.67079 .47897 .67403 .48102 .67636 .47291 .67313 .47085 Mtetra
.826 .652 .667 r
.67313 .47085 .67636 .47291 .67891 .46684 .67568 .46479 Mtetra
.746 .694 .802 r
.67568 .46479 .67891 .46684 .68175 .46344 .67852 .46138 Mtetra
.383 .645 .96 r
.67852 .46138 .68175 .46344 .68491 .46284 .68168 .46078 Mtetra
0 .234 .659 r
.68168 .46078 .68491 .46284 .68838 .46476 .68514 .46269 Mtetra
.587 .025 0 r
.68514 .46269 .68838 .46476 .69208 .46846 .68883 .46638 Mtetra
.646 .093 0 r
.68883 .46638 .69208 .46846 .69591 .4729 .69265 .47081 Mtetra
.607 .047 0 r
.69265 .47081 .69591 .4729 .69972 .47688 .69644 .47479 Mtetra
.395 0 0 r
.69644 .47479 .69972 .47688 .70336 .47928 .70007 .47718 Mtetra
.243 .589 .947 r
.70007 .47718 .70336 .47928 .70671 .47921 .70342 .47711 Mtetra
.712 .704 .841 r
.70342 .47711 .70671 .47921 .70971 .47627 .70642 .47416 Mtetra
.821 .663 .687 r
.70642 .47416 .70971 .47627 .71236 .47056 .70907 .46845 Mtetra
.848 .632 .61 r
.70907 .46845 .71236 .47056 .71471 .4627 .71143 .46059 Mtetra
.856 .619 .579 r
.71143 .46059 .71471 .4627 .7169 .45369 .71363 .45158 Mtetra
.71363 .45158 .7169 .45369 .71907 .44472 .71581 .4426 Mtetra
.848 .632 .609 r
.71581 .4426 .71907 .44472 .72138 .43693 .71814 .43481 Mtetra
.821 .661 .685 r
.71814 .43481 .72138 .43693 .72399 .43126 .72074 .42914 Mtetra
.715 .701 .836 r
.72074 .42914 .72399 .43126 .72696 .42828 .72372 .42615 Mtetra
.279 .601 .952 r
.72372 .42615 .72696 .42828 .73035 .42808 .7271 .42595 Mtetra
0 .204 .633 r
.7271 .42595 .73035 .42808 .73412 .43033 .73086 .4282 Mtetra
.573 .012 0 r
.73086 .4282 .73412 .43033 .73816 .43427 .73489 .43213 Mtetra
.621 .065 0 r
.73489 .43213 .73816 .43427 .74234 .43884 .73905 .43668 Mtetra
.571 .01 0 r
.73905 .43668 .74234 .43884 .74647 .44283 .74317 .44067 Mtetra
0 .208 .636 r
.74317 .44067 .74647 .44283 .75037 .44514 .74706 .44297 Mtetra
.279 .603 .952 r
.74706 .44297 .75037 .44514 .7539 .44493 .75058 .44276 Mtetra
.717 .705 .838 r
.75058 .44276 .7539 .44493 .75698 .44184 .75367 .43966 Mtetra
.824 .665 .685 r
.75367 .43966 .75698 .44184 .75964 .43602 .75633 .43384 Mtetra
.852 .634 .607 r
.75633 .43384 .75964 .43602 .76194 .42814 .75864 .42596 Mtetra
.86 .621 .577 r
.75864 .42596 .76194 .42814 .76406 .41922 .76077 .41704 Mtetra
.859 .623 .58 r
.76077 .41704 .76406 .41922 .76618 .41046 .7629 .40827 Mtetra
.849 .638 .617 r
.7629 .40827 .76618 .41046 .76851 .40299 .76524 .4008 Mtetra
.814 .671 .706 r
.76524 .4008 .76851 .40299 .7712 .3977 .76793 .39551 Mtetra
.674 .704 .87 r
.76793 .39551 .7712 .3977 .77436 .39512 .77109 .39293 Mtetra
.18 .551 .93 r
.77109 .39293 .77436 .39512 .77802 .39532 .77475 .39312 Mtetra
0 .185 .617 r
.77475 .39312 .77802 .39532 .78214 .39791 .77885 .3957 Mtetra
.555 0 0 r
.77885 .3957 .78214 .39791 .78657 .40209 .78327 .39987 Mtetra
.593 .035 0 r
.78327 .39987 .78657 .40209 .79114 .40678 .78783 .40456 Mtetra
.531 0 0 r
.78783 .40456 .79114 .40678 .79563 .41079 .7923 .40856 Mtetra
0 .25 .685 r
.7923 .40856 .79563 .41079 .79982 .41302 .79648 .41077 Mtetra
.311 .614 .955 r
.79648 .41077 .79982 .41302 .80354 .41266 .8002 .41042 Mtetra
.721 .706 .835 r
.8002 .41042 .80354 .41266 .80672 .40941 .80338 .40716 Mtetra
.829 .667 .682 r
.80338 .40716 .80672 .40941 .80938 .40348 .80604 .40122 Mtetra
.856 .637 .604 r
.80604 .40122 .80938 .40348 .81164 .39556 .80831 .3933 Mtetra
.864 .624 .574 r
.80831 .3933 .81164 .39556 .8137 .38672 .81038 .38446 Mtetra
.862 .627 .581 r
.81038 .38446 .8137 .38672 .81579 .37815 .81248 .37589 Mtetra
.85 .646 .627 r
.81248 .37589 .81579 .37815 .81815 .37098 .81485 .36872 Mtetra
.803 .682 .73 r
.81485 .36872 .81815 .37098 .82096 .36607 .81767 .3638 Mtetra
.621 .701 .903 r
.81767 .3638 .82096 .36607 .82436 .36389 .82106 .36162 Mtetra
.092 .5 .902 r
.82106 .36162 .82436 .36389 .82835 .36449 .82505 .36221 Mtetra
0 .175 .612 r
.82505 .36221 .82835 .36449 .83287 .36741 .82956 .36513 Mtetra
.533 0 0 r
.82956 .36513 .83287 .36741 .83776 .37184 .83443 .36955 Mtetra
.56 .004 0 r
.83443 .36955 .83776 .37184 .84278 .37667 .83944 .37436 Mtetra
.488 0 0 r
.83944 .37436 .84278 .37667 .84767 .3807 .84431 .37838 Mtetra
0 .29 .728 r
.84431 .37838 .84767 .3807 .85218 .38284 .84881 .38051 Mtetra
.338 .623 .956 r
.84881 .38051 .85218 .38284 .85612 .38234 .85274 .38001 Mtetra
.935 .859 .742 r
.41182 .78322 .41525 .78187 .41792 .7767 .41451 .77803 Mtetra
.925 .749 .644 r
.41451 .77803 .41792 .7767 .4207 .76864 .4173 .76995 Mtetra
.914 .704 .605 r
.4173 .76995 .4207 .76864 .42355 .75853 .42016 .75981 Mtetra
.91 .69 .592 r
.42016 .75981 .42355 .75853 .4264 .74756 .42303 .74881 Mtetra
.912 .695 .597 r
.42303 .74881 .4264 .74756 .42923 .73705 .42588 .73827 Mtetra
.92 .725 .623 r
.42588 .73827 .42923 .73705 .43198 .72819 .42865 .72939 Mtetra
.932 .799 .691 r
.42865 .72939 .43198 .72819 .43464 .72189 .43132 .72307 Mtetra
.881 .965 .845 r
.43132 .72307 .43464 .72189 .43721 .71862 .43389 .7198 Mtetra
.019 0 0 r
.43389 .7198 .43721 .71862 .4397 .71834 .43638 .71952 Mtetra
.539 .035 .006 r
.43638 .71952 .4397 .71834 .44214 .7205 .43881 .72169 Mtetra
.641 .175 .129 r
.43881 .72169 .44214 .7205 .44455 .72417 .44121 .72537 Mtetra
.653 .191 .143 r
.44121 .72537 .44455 .72417 .44697 .72811 .44363 .72933 Mtetra
.596 .111 .073 r
.44363 .72933 .44697 .72811 .44944 .73104 .44609 .73226 Mtetra
.33 0 0 r
.44609 .73226 .44944 .73104 .45197 .73181 .44862 .73304 Mtetra
.682 .979 .86 r
.44862 .73304 .45197 .73181 .45458 .72969 .45123 .73092 Mtetra
.937 .859 .738 r
.45123 .73092 .45458 .72969 .45724 .72446 .4539 .72567 Mtetra
.93 .752 .64 r
.4539 .72567 .45724 .72446 .45995 .71646 .45663 .71766 Mtetra
.92 .709 .601 r
.45663 .71766 .45995 .71646 .46268 .70656 .45937 .70773 Mtetra
.916 .695 .589 r
.45937 .70773 .46268 .70656 .46541 .69595 .46212 .69709 Mtetra
.918 .704 .596 r
.46212 .69709 .46541 .69595 .46811 .6859 .46484 .68701 Mtetra
.927 .738 .629 r
.46484 .68701 .46811 .6859 .47077 .67757 .46751 .67866 Mtetra
.937 .825 .709 r
.46751 .67866 .47077 .67757 .4734 .67181 .47015 .67289 Mtetra
.824 .989 .872 r
.47015 .67289 .4734 .67181 .47599 .66904 .47274 .67011 Mtetra
.151 0 0 r
.47274 .67011 .47599 .66904 .47856 .66916 .47531 .67023 Mtetra
.558 .052 .007 r
.47531 .67023 .47856 .66916 .48113 .67161 .47788 .67269 Mtetra
.644 .169 .111 r
.47788 .67269 .48113 .67161 .48371 .67541 .48045 .67651 Mtetra
.649 .176 .117 r
.48045 .67651 .48371 .67541 .48631 .67936 .48304 .68047 Mtetra
.584 .086 .037 r
.48304 .68047 .48631 .67936 .48894 .6822 .48566 .68331 Mtetra
.289 0 0 r
.48566 .68331 .48894 .6822 .49159 .68283 .48831 .68395 Mtetra
.708 .985 .869 r
.48831 .68395 .49159 .68283 .49425 .68058 .49097 .6817 Mtetra
.94 .859 .733 r
.49097 .6817 .49425 .68058 .49691 .67528 .49364 .67639 Mtetra
.934 .756 .636 r
.49364 .67639 .49691 .67528 .49955 .66734 .4963 .66842 Mtetra
.925 .713 .597 r
.4963 .66842 .49955 .66734 .50218 .65763 .49894 .65869 Mtetra
.922 .701 .586 r
.49894 .65869 .50218 .65763 .50479 .64734 .50156 .64837 Mtetra
.925 .713 .597 r
.50156 .64837 .50479 .64734 .50738 .63772 .50417 .63873 Mtetra
.934 .754 .635 r
.50417 .63873 .50738 .63772 .50997 .62989 .50678 .63088 Mtetra
.939 .854 .732 r
.50678 .63088 .50997 .62989 .51258 .62465 .5094 .62562 Mtetra
.732 .989 .882 r
.5094 .62562 .51258 .62465 .51523 .62235 .51205 .62332 Mtetra
.25 0 0 r
.51205 .62332 .51523 .62235 .51791 .62285 .51473 .62383 Mtetra
.572 .062 .001 r
.51473 .62383 .51791 .62285 .52064 .62556 .51745 .62655 Mtetra
.645 .161 .09 r
.51745 .62655 .52064 .62556 .52341 .6295 .52022 .6305 Mtetra
.644 .16 .089 r
.52022 .6305 .52341 .6295 .52621 .63346 .52301 .63447 Mtetra
.57 .059 0 r
.52301 .63447 .52621 .63346 .52901 .6362 .5258 .63722 Mtetra
.245 0 0 r
.5258 .63722 .52901 .6362 .53177 .6367 .52856 .63772 Mtetra
.73 .989 .874 r
.52856 .63772 .53177 .6367 .53449 .63431 .53129 .63533 Mtetra
.943 .861 .729 r
.53129 .63533 .53449 .63431 .53715 .62894 .53395 .62995 Mtetra
.939 .76 .632 r
.53395 .62995 .53715 .62894 .53973 .62104 .53654 .62202 Mtetra
.931 .718 .593 r
.53654 .62202 .53973 .62104 .54226 .6115 .53909 .61246 Mtetra
.929 .708 .583 r
.53909 .61246 .54226 .6115 .54476 .60151 .5416 .60245 Mtetra
.932 .723 .597 r
.5416 .60245 .54476 .60151 .54726 .59231 .54412 .59321 Mtetra
.941 .772 .644 r
.54412 .59321 .54726 .59231 .54981 .58495 .54668 .58584 Mtetra
.936 .886 .758 r
.54668 .58584 .54981 .58495 .55243 .5802 .54931 .58107 Mtetra
.6 .952 .866 r
.54931 .58107 .55243 .5802 .55515 .57834 .55204 .57922 Mtetra
.323 0 0 r
.55204 .57922 .55515 .57834 .55798 .57922 .55486 .5801 Mtetra
.583 .067 0 r
.55486 .5801 .55798 .57922 .5609 .58218 .55778 .58307 Mtetra
.644 .151 .066 r
.55778 .58307 .5609 .58218 .56389 .58625 .56076 .58715 Mtetra
.637 .142 .058 r
.56076 .58715 .56389 .58625 .5669 .59021 .56376 .59112 Mtetra
.553 .029 0 r
.56376 .59112 .5669 .59021 .56988 .59286 .56673 .59379 Mtetra
.198 0 0 r
.56673 .59379 .56988 .59286 .57278 .59322 .56963 .59414 Mtetra
.747 .992 .877 r
.56963 .59414 .57278 .59322 .57556 .59069 .57242 .59162 Mtetra
.947 .863 .724 r
.57242 .59162 .57556 .59069 .57821 .58525 .57507 .58616 Mtetra
.945 .764 .627 r
.57507 .58616 .57821 .58525 .58073 .57738 .57761 .57827 Mtetra
.937 .724 .589 r
.57761 .57827 .58073 .57738 .58317 .56799 .58006 .56886 Mtetra
.936 .716 .581 r
.58006 .56886 .58317 .56799 .58557 .55829 .58248 .55913 Mtetra
.94 .735 .599 r
.58248 .55913 .58557 .55829 .588 .54946 .58493 .55028 Mtetra
.948 .792 .655 r
.58493 .55028 .588 .54946 .59052 .54256 .58746 .54336 Mtetra
.926 .92 .788 r
.58746 .54336 .59052 .54256 .59319 .53827 .59013 .53906 Mtetra
.44 .876 .819 r
.59013 .53906 .59319 .53827 .59602 .53685 .59296 .53763 Mtetra
.376 0 0 r
.59296 .53763 .59602 .53685 .59902 .53808 .59596 .53887 Mtetra
.589 .068 0 r
.59596 .53887 .59902 .53808 .60216 .54129 .5991 .54209 Mtetra
.641 .139 .039 r
.5991 .54209 .60216 .54129 .60539 .54548 .60232 .54629 Mtetra
.629 .121 .024 r
.60232 .54629 .60539 .54548 .60864 .54944 .60556 .55027 Mtetra
.534 0 0 r
.60556 .55027 .60864 .54944 .61182 .55201 .60874 .55284 Mtetra
.15 0 0 r
.60874 .55284 .61182 .55201 .61485 .55222 .61177 .55306 Mtetra
.762 .993 .877 r
.61177 .55306 .61485 .55222 .6177 .54956 .61463 .5504 Mtetra
.951 .866 .719 r
.61463 .5504 .6177 .54956 .62035 .54404 .61728 .54486 Mtetra
.951 .77 .622 r
.61728 .54486 .62035 .54404 .62282 .53618 .61976 .53698 Mtetra
.944 .731 .584 r
.61976 .53698 .62282 .53618 .62517 .52693 .62213 .52771 Mtetra
.943 .725 .578 r
.62213 .52771 .62517 .52693 .62749 .51749 .62446 .51824 Mtetra
.947 .748 .601 r
.62446 .51824 .62749 .51749 .62986 .50903 .62685 .50976 Mtetra
.954 .815 .669 r
.62685 .50976 .62986 .50903 .63239 .50255 .62938 .50326 Mtetra
.904 .953 .82 r
.62938 .50326 .63239 .50255 .63512 .49871 .63212 .49941 Mtetra
.273 .774 .751 r
.63212 .49941 .63512 .49871 .6381 .4977 .6351 .49841 Mtetra
.415 0 0 r
.6351 .49841 .6381 .4977 .64131 .49928 .63831 .49999 Mtetra
.593 .065 0 r
.63831 .49999 .64131 .49928 .64471 .50273 .6417 .50345 Mtetra
.636 .124 .01 r
.6417 .50345 .64471 .50273 .64821 .50704 .6452 .50778 Mtetra
.618 .099 0 r
.6452 .50778 .64821 .50704 .65171 .51101 .6487 .51176 Mtetra
.512 0 0 r
.6487 .51176 .65171 .51101 .65511 .51349 .65209 .51424 Mtetra
.101 0 0 r
.65209 .51424 .65511 .51349 .65829 .51356 .65528 .51432 Mtetra
.774 .994 .875 r
.65528 .51432 .65829 .51356 .66122 .51076 .6582 .51151 Mtetra
.955 .87 .714 r
.6582 .51151 .66122 .51076 .66386 .50515 .66086 .50588 Mtetra
.957 .776 .616 r
.66086 .50588 .66386 .50515 .66628 .49729 .66329 .49801 Mtetra
.951 .738 .578 r
.66329 .49801 .66628 .49729 .66855 .48817 .66557 .48886 Mtetra
.951 .734 .575 r
.66557 .48886 .66855 .48817 .67079 .47897 .66783 .47964 Mtetra
.955 .763 .604 r
.66783 .47964 .67079 .47897 .67313 .47085 .67018 .4715 Mtetra
.958 .841 .685 r
.67018 .4715 .67313 .47085 .67568 .46479 .67274 .46542 Mtetra
.863 .98 .852 r
.67274 .46542 .67568 .46479 .67852 .46138 .67558 .462 Mtetra
0 0 0 r
.67558 .462 .67852 .46138 .68168 .46078 .67874 .4614 Mtetra
.444 0 0 r
.67874 .4614 .68168 .46078 .68514 .46269 .6822 .46332 Mtetra
.594 .059 0 r
.6822 .46332 .68514 .46269 .68883 .46638 .68589 .46702 Mtetra
.63 .106 0 r
.68589 .46702 .68883 .46638 .69265 .47081 .6897 .47147 Mtetra
.605 .074 0 r
.6897 .47147 .69265 .47081 .69644 .47479 .69349 .47546 Mtetra
.488 0 0 r
.69349 .47546 .69644 .47479 .70007 .47718 .69711 .47786 Mtetra
.053 0 0 r
.69711 .47786 .70007 .47718 .70342 .47711 .70046 .47779 Mtetra
.783 .995 .871 r
.70046 .47779 .70342 .47711 .70642 .47416 .70347 .47484 Mtetra
.96 .874 .707 r
.70347 .47484 .70642 .47416 .70907 .46845 .70613 .46911 Mtetra
.964 .782 .61 r
.70613 .46911 .70907 .46845 .71143 .46059 .7085 .46123 Mtetra
.959 .745 .572 r
.7085 .46123 .71143 .46059 .71363 .45158 .71071 .45219 Mtetra
.71071 .45219 .71363 .45158 .71581 .4426 .71291 .44319 Mtetra
.963 .78 .608 r
.71291 .44319 .71581 .4426 .71814 .43481 .71525 .43538 Mtetra
.959 .87 .706 r
.71525 .43538 .71814 .43481 .72074 .42914 .71786 .4297 Mtetra
.798 .993 .876 r
.71786 .4297 .72074 .42914 .72372 .42615 .72084 .4267 Mtetra
.003 0 0 r
.72084 .4267 .72372 .42615 .7271 .42595 .72423 .4265 Mtetra
.464 0 0 r
.72423 .4265 .7271 .42595 .73086 .4282 .72798 .42875 Mtetra
.592 .049 0 r
.72798 .42875 .73086 .4282 .73489 .43213 .73201 .4327 Mtetra
.621 .087 0 r
.73201 .4327 .73489 .43213 .73905 .43668 .73617 .43727 Mtetra
.59 .047 0 r
.73617 .43727 .73905 .43668 .74317 .44067 .74028 .44127 Mtetra
.461 0 0 r
.74028 .44127 .74317 .44067 .74706 .44297 .74416 .44358 Mtetra
.007 0 0 r
.74416 .44358 .74706 .44297 .75058 .44276 .74769 .44336 Mtetra
.791 .996 .867 r
.74769 .44336 .75058 .44276 .75367 .43966 .75078 .44026 Mtetra
.964 .88 .701 r
.75078 .44026 .75367 .43966 .75633 .43384 .75345 .43442 Mtetra
.97 .789 .602 r
.75345 .43442 .75633 .43384 .75864 .42596 .75578 .42652 Mtetra
.966 .754 .565 r
.75578 .42652 .75864 .42596 .76077 .41704 .75792 .41758 Mtetra
.967 .757 .569 r
.75792 .41758 .76077 .41704 .7629 .40827 .76007 .40879 Mtetra
.971 .8 .614 r
.76007 .40879 .7629 .40827 .76524 .4008 .76241 .40129 Mtetra
.956 .902 .729 r
.76241 .40129 .76524 .4008 .76793 .39551 .76511 .39599 Mtetra
.703 .983 .886 r
.76511 .39599 .76793 .39551 .77109 .39293 .76828 .3934 Mtetra
.101 0 0 r
.76828 .3934 .77109 .39293 .77475 .39312 .77194 .3936 Mtetra
.477 0 0 r
.77194 .3936 .77475 .39312 .77885 .3957 .77604 .39618 Mtetra
.587 .035 0 r
.77604 .39618 .77885 .3957 .78327 .39987 .78046 .40037 Mtetra
.609 .065 0 r
.78046 .40037 .78327 .39987 .78783 .40456 .78501 .40507 Mtetra
.572 .017 0 r
.78501 .40507 .78783 .40456 .7923 .40856 .78948 .40908 Mtetra
.431 0 0 r
.78948 .40908 .7923 .40856 .79648 .41077 .79365 .41131 Mtetra
0 0 0 r
.79365 .41131 .79648 .41077 .8002 .41042 .79737 .41095 Mtetra
.797 .997 .861 r
.79737 .41095 .8002 .41042 .80338 .40716 .80056 .40769 Mtetra
.969 .886 .693 r
.80056 .40769 .80338 .40716 .80604 .40122 .80324 .40173 Mtetra
.977 .797 .593 r
.80324 .40173 .80604 .40122 .80831 .3933 .80552 .39379 Mtetra
.974 .763 .558 r
.80552 .39379 .80831 .3933 .81038 .38446 .8076 .38493 Mtetra
.975 .771 .565 r
.8076 .38493 .81038 .38446 .81248 .37589 .80971 .37633 Mtetra
.978 .822 .622 r
.80971 .37633 .81248 .37589 .81485 .36872 .81209 .36914 Mtetra
.944 .935 .756 r
.81209 .36914 .81485 .36872 .81767 .3638 .81492 .36421 Mtetra
.582 .944 .877 r
.81492 .36421 .81767 .3638 .82106 .36162 .81831 .36203 Mtetra
.175 0 0 r
.81831 .36203 .82106 .36162 .82505 .36221 .8223 .36261 Mtetra
.484 0 0 r
.8223 .36261 .82505 .36221 .82956 .36513 .82681 .36554 Mtetra
.579 .019 0 r
.82681 .36554 .82956 .36513 .83443 .36955 .83168 .36997 Mtetra
.595 .04 0 r
.83168 .36997 .83443 .36955 .83944 .37436 .83669 .37481 Mtetra
.552 0 0 r
.83669 .37481 .83944 .37436 .84431 .37838 .84156 .37884 Mtetra
.4 0 0 r
.84156 .37884 .84431 .37838 .84881 .38051 .84606 .38098 Mtetra
0 0 0 r
.84606 .38098 .84881 .38051 .85274 .38001 .84999 .38047 Mtetra
.938 .959 .66 r
.40828 .78697 .41182 .78322 .41451 .77803 .41097 .78176 Mtetra
.985 .847 .624 r
.41097 .78176 .41451 .77803 .4173 .76995 .41379 .77365 Mtetra
.971 .784 .593 r
.41379 .77365 .4173 .76995 .42016 .75981 .41667 .76346 Mtetra
.964 .762 .582 r
.41667 .76346 .42016 .75981 .42303 .74881 .41956 .75241 Mtetra
.967 .77 .586 r
.41956 .75241 .42303 .74881 .42588 .73827 .42243 .74182 Mtetra
.979 .814 .609 r
.42243 .74182 .42588 .73827 .42865 .72939 .42521 .7329 Mtetra
.98 .91 .653 r
.42521 .7329 .42865 .72939 .43132 .72307 .4279 .72656 Mtetra
.692 .918 .587 r
.4279 .72656 .43132 .72307 .43389 .7198 .43048 .72327 Mtetra
.162 0 0 r
.43048 .72327 .43389 .7198 .43638 .71952 .43297 .723 Mtetra
.485 .051 .139 r
.43297 .723 .43638 .71952 .43881 .72169 .4354 .72519 Mtetra
.575 .155 .208 r
.4354 .72519 .43881 .72169 .44121 .72537 .4378 .7289 Mtetra
.586 .168 .217 r
.4378 .7289 .44121 .72537 .44363 .72933 .44021 .73288 Mtetra
.532 .105 .176 r
.44021 .73288 .44363 .72933 .44609 .73226 .44267 .73584 Mtetra
.338 0 .034 r
.44267 .73584 .44609 .73226 .44862 .73304 .4452 .73663 Mtetra
0 0 0 r
.4452 .73663 .44862 .73304 .45123 .73092 .44781 .73451 Mtetra
.939 .957 .653 r
.44781 .73451 .45123 .73092 .4539 .72567 .4505 .72924 Mtetra
.987 .85 .617 r
.4505 .72924 .4539 .72567 .45663 .71766 .45324 .72119 Mtetra
.976 .789 .587 r
.45324 .72119 .45663 .71766 .45937 .70773 .456 .71121 Mtetra
.971 .77 .576 r
.456 .71121 .45937 .70773 .46212 .69709 .45877 .70052 Mtetra
.974 .782 .583 r
.45877 .70052 .46212 .69709 .46484 .68701 .46151 .69039 Mtetra
.985 .832 .609 r
.46151 .69039 .46484 .68701 .46751 .67866 .4642 .68201 Mtetra
.968 .934 .654 r
.4642 .68201 .46751 .67866 .47015 .67289 .46685 .67621 Mtetra
.551 .845 .522 r
.46685 .67621 .47015 .67289 .47274 .67011 .46945 .67343 Mtetra
.236 0 0 r
.46945 .67343 .47274 .67011 .47531 .67023 .47202 .67356 Mtetra
.502 .062 .136 r
.47202 .67356 .47531 .67023 .47788 .67269 .47459 .67603 Mtetra
.579 .152 .194 r
.47459 .67603 .47788 .67269 .48045 .67651 .47715 .67988 Mtetra
.584 .158 .198 r
.47715 .67988 .48045 .67651 .48304 .68047 .47974 .68387 Mtetra
.524 .087 .152 r
.47974 .68387 .48304 .68047 .48566 .68331 .48236 .68674 Mtetra
.315 0 .003 r
.48236 .68674 .48566 .68331 .48831 .68395 .48501 .68739 Mtetra
0 0 0 r
.48501 .68739 .48831 .68395 .49097 .6817 .48767 .68513 Mtetra
.939 .955 .645 r
.48767 .68513 .49097 .6817 .49364 .67639 .49035 .6798 Mtetra
.99 .854 .609 r
.49035 .6798 .49364 .67639 .4963 .66842 .49303 .6718 Mtetra
.982 .796 .579 r
.49303 .6718 .4963 .66842 .49894 .65869 .49569 .66202 Mtetra
.977 .779 .57 r
.49569 .66202 .49894 .65869 .50156 .64837 .49833 .65165 Mtetra
.981 .795 .579 r
.49833 .65165 .50156 .64837 .50417 .63873 .50096 .64196 Mtetra
.99 .852 .608 r
.50096 .64196 .50417 .63873 .50678 .63088 .50359 .63408 Mtetra
.944 .954 .65 r
.50359 .63408 .50678 .63088 .5094 .62562 .50622 .62881 Mtetra
0 0 0 r
.50622 .62881 .5094 .62562 .51205 .62332 .50887 .62649 Mtetra
.294 0 0 r
.50887 .62649 .51205 .62332 .51473 .62383 .51155 .62701 Mtetra
.516 .07 .129 r
.51155 .62701 .51473 .62383 .51745 .62655 .51428 .62976 Mtetra
.581 .146 .179 r
.51428 .62976 .51745 .62655 .52022 .6305 .51704 .63374 Mtetra
.581 .145 .178 r
.51704 .63374 .52022 .6305 .52301 .63447 .51982 .63773 Mtetra
.514 .067 .128 r
.51982 .63773 .52301 .63447 .5258 .63722 .52261 .64051 Mtetra
.29 0 0 r
.52261 .64051 .5258 .63722 .52856 .63772 .52538 .64102 Mtetra
0 0 0 r
.52538 .64102 .52856 .63772 .53129 .63533 .52811 .63862 Mtetra
.937 .953 .636 r
.52811 .63862 .53129 .63533 .53395 .62995 .53078 .63322 Mtetra
.993 .858 .599 r
.53078 .63322 .53395 .62995 .53654 .62202 .53339 .62526 Mtetra
.987 .802 .57 r
.53339 .62526 .53654 .62202 .53909 .61246 .53596 .61565 Mtetra
.984 .788 .563 r
.53596 .61565 .53909 .61246 .5416 .60245 .53849 .60559 Mtetra
.988 .809 .574 r
.53849 .60559 .5416 .60245 .54412 .59321 .54103 .59632 Mtetra
.992 .873 .607 r
.54103 .59632 .54412 .59321 .54668 .58584 .5436 .58891 Mtetra
.901 .964 .64 r
.5436 .58891 .54668 .58584 .54931 .58107 .54624 .58413 Mtetra
0 0 0 r
.54624 .58413 .54931 .58107 .55204 .57922 .54897 .58227 Mtetra
.34 0 0 r
.54897 .58227 .55204 .57922 .55486 .5801 .5518 .58316 Mtetra
.527 .074 .119 r
.5518 .58316 .55486 .5801 .55778 .58307 .55471 .58616 Mtetra
.583 .139 .161 r
.55471 .58616 .55778 .58307 .56076 .58715 .55769 .59026 Mtetra
.576 .131 .156 r
.55769 .59026 .56076 .58715 .56376 .59112 .56069 .59427 Mtetra
.502 .046 .101 r
.56069 .59427 .56376 .59112 .56673 .59379 .56366 .59695 Mtetra
.264 0 0 r
.56366 .59695 .56673 .59379 .56963 .59414 .56656 .59732 Mtetra
0 0 0 r
.56656 .59732 .56963 .59414 .57242 .59162 .56936 .59479 Mtetra
.935 .951 .624 r
.56936 .59479 .57242 .59162 .57507 .58616 .57203 .58931 Mtetra
.994 .862 .588 r
.57203 .58931 .57507 .58616 .57761 .57827 .57458 .58137 Mtetra
.991 .809 .561 r
.57458 .58137 .57761 .57827 .58006 .56886 .57705 .57192 Mtetra
.989 .798 .554 r
.57705 .57192 .58006 .56886 .58248 .55913 .57948 .56215 Mtetra
.993 .823 .568 r
.57948 .56215 .58248 .55913 .58493 .55028 .58195 .55326 Mtetra
.989 .894 .605 r
.58195 .55326 .58493 .55028 .58746 .54336 .58449 .54631 Mtetra
.834 .958 .62 r
.58449 .54631 .58746 .54336 .59013 .53906 .58717 .54199 Mtetra
0 0 0 r
.58717 .54199 .59013 .53906 .59296 .53763 .59001 .54057 Mtetra
.376 0 0 r
.59001 .54057 .59296 .53763 .59596 .53887 .59301 .54181 Mtetra
.536 .075 .106 r
.59301 .54181 .59596 .53887 .5991 .54209 .59615 .54506 Mtetra
.583 .129 .141 r
.59615 .54506 .5991 .54209 .60232 .54629 .59937 .54929 Mtetra
.571 .116 .132 r
.59937 .54929 .60232 .54629 .60556 .55027 .60261 .5533 Mtetra
.49 .023 .073 r
.60261 .5533 .60556 .55027 .60874 .55284 .60578 .5559 Mtetra
.238 0 0 r
.60578 .5559 .60874 .55284 .61177 .55306 .60882 .55612 Mtetra
0 0 0 r
.60882 .55612 .61177 .55306 .61463 .5504 .61168 .55345 Mtetra
.931 .947 .611 r
.61168 .55345 .61463 .5504 .61728 .54486 .61435 .54789 Mtetra
.996 .865 .575 r
.61435 .54789 .61728 .54486 .61976 .53698 .61685 .53997 Mtetra
.995 .816 .549 r
.61685 .53997 .61976 .53698 .62213 .52771 .61923 .53066 Mtetra
.995 .808 .545 r
.61923 .53066 .62213 .52771 .62446 .51824 .62158 .52115 Mtetra
.997 .839 .562 r
.62158 .52115 .62446 .51824 .62685 .50976 .62399 .51263 Mtetra
.979 .913 .601 r
.62399 .51263 .62685 .50976 .62938 .50326 .62653 .50611 Mtetra
.742 .931 .588 r
.62653 .50611 .62938 .50326 .63212 .49941 .62928 .50224 Mtetra
0 0 0 r
.62928 .50224 .63212 .49941 .6351 .49841 .63226 .50124 Mtetra
.405 0 0 r
.63226 .50124 .6351 .49841 .63831 .49999 .63548 .50283 Mtetra
.542 .073 .09 r
.63548 .50283 .63831 .49999 .6417 .50345 .63887 .50632 Mtetra
.581 .118 .119 r
.63887 .50632 .6417 .50345 .6452 .50778 .64237 .51068 Mtetra
.564 .098 .107 r
.64237 .51068 .6452 .50778 .6487 .51176 .64586 .51469 Mtetra
.475 0 .044 r
.64586 .51469 .6487 .51176 .65209 .51424 .64925 .51719 Mtetra
.211 0 0 r
.64925 .51719 .65209 .51424 .65528 .51432 .65245 .51728 Mtetra
0 0 0 r
.65245 .51728 .65528 .51432 .6582 .51151 .65538 .51446 Mtetra
.925 .943 .595 r
.65538 .51446 .6582 .51151 .66086 .50588 .65805 .50881 Mtetra
.995 .868 .56 r
.65805 .50881 .66086 .50588 .66329 .49801 .66049 .5009 Mtetra
.998 .823 .536 r
.66049 .5009 .66329 .49801 .66557 .48886 .66279 .49171 Mtetra
.998 .819 .533 r
.66279 .49171 .66557 .48886 .66783 .47964 .66507 .48244 Mtetra
.998 .854 .553 r
.66507 .48244 .66783 .47964 .67018 .4715 .66744 .47427 Mtetra
.958 .929 .593 r
.66744 .47427 .67018 .4715 .67274 .46542 .67001 .46816 Mtetra
.626 .881 .544 r
.67001 .46816 .67274 .46542 .67558 .462 .67286 .46473 Mtetra
.082 0 0 r
.67286 .46473 .67558 .462 .67874 .4614 .67603 .46414 Mtetra
.428 0 0 r
.67603 .46414 .67874 .4614 .6822 .46332 .67949 .46607 Mtetra
.546 .068 .072 r
.67949 .46607 .6822 .46332 .68589 .46702 .68318 .4698 Mtetra
.578 .105 .095 r
.68318 .4698 .68589 .46702 .6897 .47147 .68698 .47428 Mtetra
.556 .08 .079 r
.68698 .47428 .6897 .47147 .69349 .47546 .69077 .4783 Mtetra
.46 0 .014 r
.69077 .4783 .69349 .47546 .69711 .47786 .6944 .48072 Mtetra
.184 0 0 r
.6944 .48072 .69711 .47786 .70046 .47779 .69776 .48066 Mtetra
0 0 0 r
.69776 .48066 .70046 .47779 .70347 .47484 .70077 .4777 Mtetra
.916 .938 .576 r
.70077 .4777 .70347 .47484 .70613 .46911 .70345 .47194 Mtetra
.993 .871 .543 r
.70345 .47194 .70613 .46911 .7085 .46123 .70584 .46403 Mtetra
1 .829 .52 r
.70584 .46403 .7085 .46123 .71071 .45219 .70806 .45495 Mtetra
.70806 .45495 .71071 .45219 .71291 .44319 .71027 .44591 Mtetra
.994 .869 .543 r
.71027 .44591 .71291 .44319 .71525 .43538 .71262 .43806 Mtetra
.923 .938 .58 r
.71262 .43806 .71525 .43538 .71786 .4297 .71525 .43235 Mtetra
0 0 0 r
.71525 .43235 .71786 .4297 .72084 .4267 .71824 .42934 Mtetra
.155 0 0 r
.71824 .42934 .72084 .4267 .72423 .4265 .72163 .42915 Mtetra
.445 0 0 r
.72163 .42915 .72423 .4265 .72798 .42875 .72539 .43142 Mtetra
.548 .061 .051 r
.72539 .43142 .72798 .42875 .73201 .4327 .72942 .4354 Mtetra
.574 .09 .068 r
.72942 .4354 .73201 .4327 .73617 .43727 .73358 .44 Mtetra
.547 .059 .05 r
.73358 .44 .73617 .43727 .74028 .44127 .73769 .44403 Mtetra
.443 0 0 r
.73769 .44403 .74028 .44127 .74416 .44358 .74158 .44636 Mtetra
.157 0 0 r
.74158 .44636 .74416 .44358 .74769 .44336 .74512 .44615 Mtetra
0 0 0 r
.74512 .44615 .74769 .44336 .75078 .44026 .74822 .44304 Mtetra
.905 .931 .555 r
.74822 .44304 .75078 .44026 .75345 .43442 .7509 .43718 Mtetra
.988 .872 .522 r
.7509 .43718 .75345 .43442 .75578 .42652 .75324 .42924 Mtetra
.998 .835 .501 r
.75324 .42924 .75578 .42652 .75792 .41758 .7554 .42025 Mtetra
.998 .838 .503 r
.7554 .42025 .75792 .41758 .76007 .40879 .75756 .41142 Mtetra
.983 .882 .529 r
.75756 .41142 .76007 .40879 .76241 .40129 .75992 .40389 Mtetra
.869 .936 .561 r
.75992 .40389 .76241 .40129 .76511 .39599 .76263 .39857 Mtetra
0 0 0 r
.76263 .39857 .76511 .39599 .76828 .3934 .76581 .39597 Mtetra
.213 0 0 r
.76581 .39597 .76828 .3934 .77194 .3936 .76947 .39618 Mtetra
.459 0 0 r
.76947 .39618 .77194 .3936 .77604 .39618 .77358 .39879 Mtetra
.548 .051 .027 r
.77358 .39879 .77604 .39618 .78046 .40037 .778 .403 Mtetra
.568 .073 .04 r
.778 .403 .78046 .40037 .78501 .40507 .78256 .40774 Mtetra
.536 .037 .019 r
.78256 .40774 .78501 .40507 .78948 .40908 .78703 .41178 Mtetra
.425 0 0 r
.78703 .41178 .78948 .40908 .79365 .41131 .79121 .41402 Mtetra
.132 0 0 r
.79121 .41402 .79365 .41131 .79737 .41095 .79494 .41367 Mtetra
0 0 0 r
.79494 .41367 .79737 .41095 .80056 .40769 .79814 .4104 Mtetra
.889 .921 .529 r
.79814 .4104 .80056 .40769 .80324 .40173 .80083 .40441 Mtetra
.98 .871 .498 r
.80083 .40441 .80324 .40173 .80552 .39379 .80312 .39644 Mtetra
.994 .838 .479 r
.80312 .39644 .80552 .39379 .8076 .38493 .80522 .38753 Mtetra
.991 .846 .483 r
.80522 .38753 .8076 .38493 .80971 .37633 .80735 .3789 Mtetra
.963 .892 .512 r
.80735 .3789 .80971 .37633 .81209 .36914 .80974 .37167 Mtetra
.794 .919 .534 r
.80974 .37167 .81209 .36914 .81492 .36421 .81258 .36672 Mtetra
0 0 0 r
.81258 .36672 .81492 .36421 .81831 .36203 .81598 .36453 Mtetra
.259 0 0 r
.81598 .36453 .81831 .36203 .8223 .36261 .81998 .36513 Mtetra
.468 0 0 r
.81998 .36513 .8223 .36261 .82681 .36554 .8245 .36808 Mtetra
.546 .038 0 r
.8245 .36808 .82681 .36554 .83168 .36997 .82937 .37255 Mtetra
.56 .054 .009 r
.82937 .37255 .83168 .36997 .83669 .37481 .83438 .37742 Mtetra
.523 .013 0 r
.83438 .37742 .83669 .37481 .84156 .37884 .83926 .38148 Mtetra
.406 0 0 r
.83926 .38148 .84156 .37884 .84606 .38098 .84377 .38364 Mtetra
.108 0 0 r
.84377 .38364 .84606 .38098 .84999 .38047 .84771 .38313 Mtetra
.849 .929 .545 r
.40465 .79207 .40828 .78697 .41097 .78176 .40736 .78684 Mtetra
.991 .885 .59 r
.40736 .78684 .41097 .78176 .41379 .77365 .41019 .77868 Mtetra
.991 .822 .576 r
.41019 .77868 .41379 .77365 .41667 .76346 .41309 .76844 Mtetra
.986 .798 .568 r
.41309 .76844 .41667 .76346 .41956 .75241 .41602 .75732 Mtetra
.988 .808 .571 r
.41602 .75732 .41956 .75241 .42243 .74182 .4189 .74667 Mtetra
.995 .853 .585 r
.4189 .74667 .42243 .74182 .42521 .7329 .42171 .7377 Mtetra
.954 .93 .59 r
.42171 .7377 .42521 .7329 .4279 .72656 .42442 .73132 Mtetra
0 0 0 r
.42442 .73132 .4279 .72656 .43048 .72327 .42701 .72802 Mtetra
.195 0 .016 r
.42701 .72802 .43048 .72327 .43297 .723 .4295 .72776 Mtetra
.461 .055 .182 r
.4295 .72776 .43297 .723 .4354 .72519 .43192 .72998 Mtetra
.546 .147 .236 r
.43192 .72998 .4354 .72519 .4378 .7289 .43432 .73372 Mtetra
.557 .159 .243 r
.43432 .73372 .4378 .7289 .44021 .73288 .43673 .73774 Mtetra
.505 .102 .21 r
.43673 .73774 .44021 .73288 .44267 .73584 .43918 .74073 Mtetra
.335 0 .104 r
.43918 .74073 .44267 .73584 .4452 .73663 .44171 .74154 Mtetra
0 0 0 r
.44171 .74154 .4452 .73663 .44781 .73451 .44433 .73941 Mtetra
.848 .926 .538 r
.44433 .73941 .44781 .73451 .4505 .72924 .44703 .73411 Mtetra
.991 .886 .579 r
.44703 .73411 .4505 .72924 .45324 .72119 .44979 .72602 Mtetra
.995 .827 .566 r
.44979 .72602 .45324 .72119 .456 .71121 .45258 .71599 Mtetra
.991 .806 .559 r
.45258 .71599 .456 .71121 .45877 .70052 .45537 .70523 Mtetra
.993 .819 .564 r
.45537 .70523 .45877 .70052 .46151 .69039 .45813 .69505 Mtetra
.995 .87 .578 r
.45813 .69505 .46151 .69039 .4642 .68201 .46085 .68662 Mtetra
.916 .935 .569 r
.46085 .68662 .4642 .68201 .46685 .67621 .46351 .68079 Mtetra
0 0 0 r
.46351 .68079 .46685 .67621 .46945 .67343 .46612 .678 Mtetra
.253 0 .04 r
.46612 .678 .46945 .67343 .47202 .67356 .46869 .67814 Mtetra
.478 .065 .178 r
.46869 .67814 .47202 .67356 .47459 .67603 .47125 .68064 Mtetra
.55 .144 .224 r
.47125 .68064 .47459 .67603 .47715 .67988 .47382 .68453 Mtetra
.555 .149 .227 r
.47382 .68453 .47715 .67988 .47974 .68387 .4764 .68855 Mtetra
.497 .086 .191 r
.4764 .68855 .47974 .68387 .48236 .68674 .47902 .69145 Mtetra
.316 0 .08 r
.47902 .69145 .48236 .68674 .48501 .68739 .48167 .69212 Mtetra
0 0 0 r
.48167 .69212 .48501 .68739 .48767 .68513 .48435 .68985 Mtetra
.846 .921 .528 r
.48435 .68985 .48767 .68513 .49035 .6798 .48704 .68449 Mtetra
.989 .887 .567 r
.48704 .68449 .49035 .6798 .49303 .6718 .48973 .67645 Mtetra
.997 .833 .555 r
.48973 .67645 .49303 .6718 .49569 .66202 .49242 .66661 Mtetra
.995 .815 .549 r
.49242 .66661 .49569 .66202 .49833 .65165 .49508 .65619 Mtetra
.997 .832 .554 r
.49508 .65619 .49833 .65165 .50096 .64196 .49773 .64644 Mtetra
.99 .885 .568 r
.49773 .64644 .50096 .64196 .50359 .63408 .50037 .63852 Mtetra
.858 .926 .539 r
.50037 .63852 .50359 .63408 .50622 .62881 .50302 .63322 Mtetra
0 0 0 r
.50302 .63322 .50622 .62881 .50887 .62649 .50568 .6309 Mtetra
.299 0 .055 r
.50568 .6309 .50887 .62649 .51155 .62701 .50836 .63143 Mtetra
.491 .071 .171 r
.50836 .63143 .51155 .62701 .51428 .62976 .51109 .6342 Mtetra
.553 .139 .21 r
.51109 .6342 .51428 .62976 .51704 .63374 .51385 .63822 Mtetra
.552 .138 .21 r
.51385 .63822 .51704 .63374 .51982 .63773 .51663 .64226 Mtetra
.489 .069 .17 r
.51663 .64226 .51982 .63773 .52261 .64051 .51942 .64506 Mtetra
.296 0 .056 r
.51942 .64506 .52261 .64051 .52538 .64102 .52219 .64558 Mtetra
0 0 0 r
.52219 .64558 .52538 .64102 .52811 .63862 .52493 .64318 Mtetra
.841 .915 .516 r
.52493 .64318 .52811 .63862 .53078 .63322 .52761 .63775 Mtetra
.987 .887 .552 r
.52761 .63775 .53078 .63322 .53339 .62526 .53024 .62975 Mtetra
.999 .838 .542 r
.53024 .62975 .53339 .62526 .53596 .61565 .53283 .62009 Mtetra
.998 .823 .537 r
.53283 .62009 .53596 .61565 .53849 .60559 .53538 .60997 Mtetra
.999 .844 .544 r
.53538 .60997 .53849 .60559 .54103 .59632 .53794 .60064 Mtetra
.979 .898 .555 r
.53794 .60064 .54103 .59632 .5436 .58891 .54053 .5932 Mtetra
.778 .9 .499 r
.54053 .5932 .5436 .58891 .54624 .58413 .54318 .58839 Mtetra
0 0 0 r
.54318 .58839 .54624 .58413 .54897 .58227 .54592 .58653 Mtetra
.337 0 .065 r
.54592 .58653 .54897 .58227 .5518 .58316 .54875 .58743 Mtetra
.502 .075 .162 r
.54875 .58743 .5518 .58316 .55471 .58616 .55167 .59046 Mtetra
.555 .132 .195 r
.55167 .59046 .55471 .58616 .55769 .59026 .55464 .59461 Mtetra
.549 .126 .191 r
.55464 .59461 .55769 .59026 .56069 .59427 .55764 .59865 Mtetra
.479 .051 .149 r
.55764 .59865 .56069 .59427 .56366 .59695 .56061 .60136 Mtetra
.276 0 .033 r
.56061 .60136 .56366 .59695 .56656 .59732 .56352 .60174 Mtetra
0 0 0 r
.56352 .60174 .56656 .59732 .56936 .59479 .56632 .5992 Mtetra
.833 .908 .501 r
.56632 .5992 .56936 .59479 .57203 .58931 .56901 .59369 Mtetra
.982 .886 .536 r
.56901 .59369 .57203 .58931 .57458 .58137 .57158 .58572 Mtetra
.999 .842 .527 r
.57158 .58572 .57458 .58137 .57705 .57192 .57406 .57621 Mtetra
1 .831 .523 r
.57406 .57621 .57705 .57192 .57948 .56215 .57652 .56638 Mtetra
.997 .855 .53 r
.57652 .56638 .57948 .56215 .58195 .55326 .579 .55744 Mtetra
.957 .907 .537 r
.579 .55744 .58195 .55326 .58449 .54631 .58157 .55046 Mtetra
.677 .855 .449 r
.58157 .55046 .58449 .54631 .58717 .54199 .58426 .54612 Mtetra
0 0 0 r
.58426 .54612 .58717 .54199 .59001 .54057 .5871 .5447 Mtetra
.368 0 .069 r
.5871 .5447 .59001 .54057 .59301 .54181 .59011 .54596 Mtetra
.51 .076 .151 r
.59011 .54596 .59301 .54181 .59615 .54506 .59325 .54924 Mtetra
.555 .124 .178 r
.59325 .54924 .59615 .54506 .59937 .54929 .59647 .55351 Mtetra
.544 .112 .171 r
.59647 .55351 .59937 .54929 .60261 .5533 .5997 .55756 Mtetra
.468 .032 .127 r
.5997 .55756 .60261 .5533 .60578 .5559 .60288 .56018 Mtetra
.255 0 .009 r
.60288 .56018 .60578 .5559 .60882 .55612 .60593 .56042 Mtetra
0 0 0 r
.60593 .56042 .60882 .55612 .61168 .55345 .6088 .55774 Mtetra
.823 .898 .483 r
.6088 .55774 .61168 .55345 .61435 .54789 .61148 .55215 Mtetra
.975 .885 .516 r
.61148 .55215 .61435 .54789 .61685 .53997 .61399 .54419 Mtetra
.997 .846 .509 r
.61399 .54419 .61685 .53997 .61923 .53066 .6164 .53482 Mtetra
.998 .838 .507 r
.6164 .53482 .61923 .53066 .62158 .52115 .61876 .52525 Mtetra
.99 .865 .514 r
.61876 .52525 .62158 .52115 .62399 .51263 .62119 .51669 Mtetra
.922 .909 .513 r
.62119 .51669 .62399 .51263 .62653 .50611 .62375 .51013 Mtetra
0 0 0 r
.62375 .51013 .62653 .50611 .62928 .50224 .62651 .50625 Mtetra
.067 0 0 r
.62651 .50625 .62928 .50224 .63226 .50124 .6295 .50525 Mtetra
.394 0 .068 r
.6295 .50525 .63226 .50124 .63548 .50283 .63272 .50686 Mtetra
.517 .074 .137 r
.63272 .50686 .63548 .50283 .63887 .50632 .63611 .51039 Mtetra
.554 .114 .159 r
.63611 .51039 .63887 .50632 .64237 .51068 .63961 .51478 Mtetra
.538 .097 .149 r
.63961 .51478 .64237 .51068 .64586 .51469 .64311 .51884 Mtetra
.456 .011 .103 r
.64311 .51884 .64586 .51469 .64925 .51719 .6465 .52137 Mtetra
.234 0 0 r
.6465 .52137 .64925 .51719 .65245 .51728 .6497 .52146 Mtetra
0 0 0 r
.6497 .52146 .65245 .51728 .65538 .51446 .65265 .51864 Mtetra
.809 .887 .462 r
.65265 .51864 .65538 .51446 .65805 .50881 .65533 .51296 Mtetra
.966 .881 .494 r
.65533 .51296 .65805 .50881 .66049 .5009 .65779 .505 Mtetra
.992 .848 .488 r
.65779 .505 .66049 .5009 .66279 .49171 .66011 .49576 Mtetra
.993 .844 .487 r
.66011 .49576 .66279 .49171 .66507 .48244 .6624 .48644 Mtetra
.976 .872 .493 r
.6624 .48644 .66507 .48244 .66744 .47427 .66479 .47822 Mtetra
.871 .9 .483 r
.66479 .47822 .66744 .47427 .67001 .46816 .66737 .47208 Mtetra
0 0 0 r
.66737 .47208 .67001 .46816 .67286 .46473 .67024 .46864 Mtetra
.135 0 0 r
.67024 .46864 .67286 .46473 .67603 .46414 .67341 .46805 Mtetra
.414 0 .063 r
.67341 .46805 .67603 .46414 .67949 .46607 .67688 .47001 Mtetra
.521 .07 .121 r
.67688 .47001 .67949 .46607 .68318 .4698 .68057 .47378 Mtetra
.552 .103 .138 r
.68057 .47378 .68318 .4698 .68698 .47428 .68438 .47829 Mtetra
.531 .081 .126 r
.68438 .47829 .68698 .47428 .69077 .4783 .68817 .48235 Mtetra
.443 0 .079 r
.68817 .48235 .69077 .4783 .6944 .48072 .69181 .4848 Mtetra
.214 0 0 r
.69181 .4848 .6944 .48072 .69776 .48066 .69518 .48475 Mtetra
0 0 0 r
.69518 .48475 .69776 .48066 .70077 .4777 .6982 .48178 Mtetra
.791 .872 .438 r
.6982 .48178 .70077 .4777 .70345 .47194 .70089 .47599 Mtetra
.952 .875 .468 r
.70089 .47599 .70345 .47194 .70584 .46403 .7033 .46803 Mtetra
.983 .848 .464 r
.7033 .46803 .70584 .46403 .70806 .45495 .70554 .4589 Mtetra
.983 .847 .464 r
.70554 .4589 .70806 .45495 .71027 .44591 .70777 .44981 Mtetra
.954 .874 .468 r
.70777 .44981 .71027 .44591 .71262 .43806 .71013 .44192 Mtetra
.802 .877 .445 r
.71013 .44192 .71262 .43806 .71525 .43235 .71277 .43618 Mtetra
0 0 0 r
.71277 .43618 .71525 .43235 .71824 .42934 .71578 .43316 Mtetra
.192 0 0 r
.71578 .43316 .71824 .42934 .72163 .42915 .71918 .43298 Mtetra
.431 0 .054 r
.71918 .43298 .72163 .42915 .72539 .43142 .72294 .43527 Mtetra
.524 .064 .102 r
.72294 .43527 .72539 .43142 .72942 .4354 .72698 .43929 Mtetra
.549 .09 .115 r
.72698 .43929 .72942 .4354 .73358 .44 .73114 .44393 Mtetra
.523 .063 .102 r
.73114 .44393 .73358 .44 .73769 .44403 .73526 .448 Mtetra
.429 0 .054 r
.73526 .448 .73769 .44403 .74158 .44636 .73916 .45036 Mtetra
.193 0 0 r
.73916 .45036 .74158 .44636 .74512 .44615 .74271 .45016 Mtetra
0 0 0 r
.74271 .45016 .74512 .44615 .74822 .44304 .74582 .44703 Mtetra
.769 .855 .41 r
.74582 .44703 .74822 .44304 .7509 .43718 .74851 .44114 Mtetra
.934 .865 .437 r
.74851 .44114 .7509 .43718 .75324 .42924 .75087 .43316 Mtetra
.969 .845 .435 r
.75087 .43316 .75324 .42924 .7554 .42025 .75304 .42412 Mtetra
.966 .847 .436 r
.75304 .42412 .7554 .42025 .75756 .41142 .75522 .41524 Mtetra
.92 .87 .438 r
.75522 .41524 .75756 .41142 .75992 .40389 .7576 .40767 Mtetra
.716 .841 .402 r
.7576 .40767 .75992 .40389 .76263 .39857 .76032 .40232 Mtetra
0 0 0 r
.76032 .40232 .76263 .39857 .76581 .39597 .76351 .39971 Mtetra
.238 0 0 r
.76351 .39971 .76581 .39597 .76947 .39618 .76719 .39993 Mtetra
.443 0 .041 r
.76719 .39993 .76947 .39618 .77358 .39879 .7713 .40257 Mtetra
.525 .055 .081 r
.7713 .40257 .77358 .39879 .778 .403 .77573 .40682 Mtetra
.544 .075 .091 r
.77573 .40682 .778 .403 .78256 .40774 .7803 .4116 Mtetra
.514 .044 .076 r
.7803 .4116 .78256 .40774 .78703 .41178 .78478 .41568 Mtetra
.414 0 .029 r
.78478 .41568 .78703 .41178 .79121 .41402 .78897 .41795 Mtetra
.174 0 0 r
.78897 .41795 .79121 .41402 .79494 .41367 .79271 .41761 Mtetra
0 0 0 r
.79271 .41761 .79494 .41367 .79814 .4104 .79593 .41432 Mtetra
.743 .833 .378 r
.79593 .41432 .79814 .4104 .80083 .40441 .79863 .40831 Mtetra
.909 .852 .403 r
.79863 .40831 .80083 .40441 .80312 .39644 .80094 .40029 Mtetra
.948 .837 .402 r
.80094 .40029 .80312 .39644 .80522 .38753 .80305 .39133 Mtetra
.941 .841 .402 r
.80305 .39133 .80522 .38753 .80735 .3789 .80519 .38264 Mtetra
.872 .856 .402 r
.80519 .38264 .80735 .3789 .80974 .37167 .8076 .37538 Mtetra
.616 .79 .354 r
.8076 .37538 .80974 .37167 .81258 .36672 .81045 .3704 Mtetra
0 0 0 r
.81045 .3704 .81258 .36672 .81598 .36453 .81387 .36821 Mtetra
.275 0 0 r
.81387 .36821 .81598 .36453 .81998 .36513 .81788 .36882 Mtetra
.453 0 .026 r
.81788 .36882 .81998 .36513 .8245 .36808 .82241 .37181 Mtetra
.525 .044 .058 r
.82241 .37181 .8245 .36808 .82937 .37255 .8273 .37631 Mtetra
.538 .058 .064 r
.8273 .37631 .82937 .37255 .83438 .37742 .83232 .38123 Mtetra
.503 .023 .049 r
.83232 .38123 .83438 .37742 .83926 .38148 .83721 .38533 Mtetra
.398 0 .004 r
.83721 .38533 .83926 .38148 .84377 .38364 .84173 .38752 Mtetra
.156 0 0 r
.84173 .38752 .84377 .38364 .84771 .38313 .84569 .38702 Mtetra
.85 .93 .547 r
.40099 .7972 .40465 .79207 .40736 .78684 .40372 .79194 Mtetra
.992 .884 .591 r
.40372 .79194 .40736 .78684 .41019 .77868 .40657 .78373 Mtetra
.991 .822 .576 r
.40657 .78373 .41019 .77868 .41309 .76844 .40949 .77343 Mtetra
.986 .798 .568 r
.40949 .77343 .41309 .76844 .41602 .75732 .41244 .76225 Mtetra
.988 .807 .571 r
.41244 .76225 .41602 .75732 .4189 .74667 .41535 .75154 Mtetra
.995 .853 .585 r
.41535 .75154 .4189 .74667 .42171 .7377 .41818 .74252 Mtetra
.955 .93 .591 r
.41818 .74252 .42171 .7377 .42442 .73132 .4209 .73611 Mtetra
0 0 0 r
.4209 .73611 .42442 .73132 .42701 .72802 .4235 .7328 Mtetra
.195 0 .015 r
.4235 .7328 .42701 .72802 .4295 .72776 .426 .73254 Mtetra
.462 .055 .181 r
.426 .73254 .4295 .72776 .43192 .72998 .42842 .73479 Mtetra
.546 .147 .236 r
.42842 .73479 .43192 .72998 .43432 .73372 .43081 .73856 Mtetra
.557 .159 .243 r
.43081 .73856 .43432 .73372 .43673 .73774 .43321 .74262 Mtetra
.506 .102 .21 r
.43321 .74262 .43673 .73774 .43918 .74073 .43567 .74564 Mtetra
.335 0 .103 r
.43567 .74564 .43918 .74073 .44171 .74154 .4382 .74647 Mtetra
0 0 0 r
.4382 .74647 .44171 .74154 .44433 .73941 .44083 .74433 Mtetra
.85 .926 .54 r
.44083 .74433 .44433 .73941 .44703 .73411 .44354 .73901 Mtetra
.991 .886 .58 r
.44354 .73901 .44703 .73411 .44979 .72602 .44632 .73087 Mtetra
.994 .827 .566 r
.44632 .73087 .44979 .72602 .45258 .71599 .44913 .72078 Mtetra
.991 .806 .56 r
.44913 .72078 .45258 .71599 .45537 .70523 .45195 .70996 Mtetra
.993 .819 .564 r
.45195 .70996 .45537 .70523 .45813 .69505 .45473 .69972 Mtetra
.995 .869 .578 r
.45473 .69972 .45813 .69505 .46085 .68662 .45746 .69125 Mtetra
.917 .935 .57 r
.45746 .69125 .46085 .68662 .46351 .68079 .46014 .6854 Mtetra
0 0 0 r
.46014 .6854 .46351 .68079 .46612 .678 .46276 .68259 Mtetra
.252 0 .039 r
.46276 .68259 .46612 .678 .46869 .67814 .46534 .68274 Mtetra
.478 .065 .177 r
.46534 .68274 .46869 .67814 .47125 .68064 .4679 .68527 Mtetra
.55 .144 .224 r
.4679 .68527 .47125 .68064 .47382 .68453 .47046 .68919 Mtetra
.555 .149 .227 r
.47046 .68919 .47382 .68453 .4764 .68855 .47304 .69326 Mtetra
.498 .086 .19 r
.47304 .69326 .4764 .68855 .47902 .69145 .47565 .69618 Mtetra
.316 0 .08 r
.47565 .69618 .47902 .69145 .48167 .69212 .47831 .69686 Mtetra
0 0 0 r
.47831 .69686 .48167 .69212 .48435 .68985 .48099 .69459 Mtetra
.848 .922 .53 r
.48099 .69459 .48435 .68985 .48704 .68449 .4837 .68921 Mtetra
.99 .886 .568 r
.4837 .68921 .48704 .68449 .48973 .67645 .48641 .68112 Mtetra
.997 .832 .555 r
.48641 .68112 .48973 .67645 .49242 .66661 .48911 .67123 Mtetra
.995 .814 .549 r
.48911 .67123 .49242 .66661 .49508 .65619 .4918 .66074 Mtetra
.997 .831 .555 r
.4918 .66074 .49508 .65619 .49773 .64644 .49447 .65095 Mtetra
.99 .885 .568 r
.49447 .65095 .49773 .64644 .50037 .63852 .49713 .64298 Mtetra
.86 .927 .54 r
.49713 .64298 .50037 .63852 .50302 .63322 .49979 .63765 Mtetra
0 0 0 r
.49979 .63765 .50302 .63322 .50568 .6309 .50246 .63533 Mtetra
.299 0 .054 r
.50246 .63533 .50568 .6309 .50836 .63143 .50515 .63587 Mtetra
.491 .071 .171 r
.50515 .63587 .50836 .63143 .51109 .6342 .50787 .63867 Mtetra
.553 .139 .21 r
.50787 .63867 .51109 .6342 .51385 .63822 .51063 .64273 Mtetra
.553 .138 .209 r
.51063 .64273 .51385 .63822 .51663 .64226 .51341 .6468 Mtetra
.489 .069 .17 r
.51341 .6468 .51663 .64226 .51942 .64506 .51619 .64963 Mtetra
.296 0 .055 r
.51619 .64963 .51942 .64506 .52219 .64558 .51897 .65017 Mtetra
0 0 0 r
.51897 .65017 .52219 .64558 .52493 .64318 .52172 .64776 Mtetra
.843 .916 .518 r
.52172 .64776 .52493 .64318 .52761 .63775 .52442 .6423 Mtetra
.987 .887 .553 r
.52442 .6423 .52761 .63775 .53024 .62975 .52707 .63426 Mtetra
.999 .837 .542 r
.52707 .63426 .53024 .62975 .53283 .62009 .52967 .62454 Mtetra
.998 .823 .538 r
.52967 .62454 .53283 .62009 .53538 .60997 .53225 .61436 Mtetra
.999 .843 .544 r
.53225 .61436 .53538 .60997 .53794 .60064 .53483 .60498 Mtetra
.979 .898 .555 r
.53483 .60498 .53794 .60064 .54053 .5932 .53743 .5975 Mtetra
.78 .901 .501 r
.53743 .5975 .54053 .5932 .54318 .58839 .5401 .59267 Mtetra
0 0 0 r
.5401 .59267 .54318 .58839 .54592 .58653 .54284 .59081 Mtetra
.337 0 .064 r
.54284 .59081 .54592 .58653 .54875 .58743 .54568 .59173 Mtetra
.502 .075 .162 r
.54568 .59173 .54875 .58743 .55167 .59046 .54859 .59479 Mtetra
.555 .132 .194 r
.54859 .59479 .55167 .59046 .55464 .59461 .55157 .59897 Mtetra
.549 .126 .191 r
.55157 .59897 .55464 .59461 .55764 .59865 .55456 .60305 Mtetra
.479 .051 .148 r
.55456 .60305 .55764 .59865 .56061 .60136 .55754 .60579 Mtetra
.276 0 .032 r
.55754 .60579 .56061 .60136 .56352 .60174 .56045 .60618 Mtetra
0 0 0 r
.56045 .60618 .56352 .60174 .56632 .5992 .56326 .60364 Mtetra
.835 .909 .503 r
.56326 .60364 .56632 .5992 .56901 .59369 .56596 .5981 Mtetra
.983 .886 .536 r
.56596 .5981 .56901 .59369 .57158 .58572 .56855 .59008 Mtetra
.999 .842 .527 r
.56855 .59008 .57158 .58572 .57406 .57621 .57106 .58053 Mtetra
1 .831 .524 r
.57106 .58053 .57406 .57621 .57652 .56638 .57353 .57064 Mtetra
.997 .855 .531 r
.57353 .57064 .57652 .56638 .579 .55744 .57603 .56165 Mtetra
.958 .907 .538 r
.57603 .56165 .579 .55744 .58157 .55046 .57861 .55462 Mtetra
.679 .856 .451 r
.57861 .55462 .58157 .55046 .58426 .54612 .58131 .55027 Mtetra
0 0 0 r
.58131 .55027 .58426 .54612 .5871 .5447 .58417 .54885 Mtetra
.369 0 .068 r
.58417 .54885 .5871 .5447 .59011 .54596 .58718 .55013 Mtetra
.511 .076 .15 r
.58718 .55013 .59011 .54596 .59325 .54924 .59032 .55344 Mtetra
.555 .124 .177 r
.59032 .55344 .59325 .54924 .59647 .55351 .59354 .55775 Mtetra
.544 .112 .17 r
.59354 .55775 .59647 .55351 .5997 .55756 .59677 .56183 Mtetra
.468 .032 .126 r
.59677 .56183 .5997 .55756 .60288 .56018 .59995 .56448 Mtetra
.255 0 .008 r
.59995 .56448 .60288 .56018 .60593 .56042 .60301 .56473 Mtetra
0 0 0 r
.60301 .56473 .60593 .56042 .6088 .55774 .60589 .56204 Mtetra
.824 .899 .485 r
.60589 .56204 .6088 .55774 .61148 .55215 .60858 .55643 Mtetra
.976 .885 .517 r
.60858 .55643 .61148 .55215 .61399 .54419 .61111 .54842 Mtetra
.997 .845 .509 r
.61111 .54842 .61399 .54419 .6164 .53482 .61353 .53901 Mtetra
.998 .838 .507 r
.61353 .53901 .6164 .53482 .61876 .52525 .61592 .52938 Mtetra
.99 .865 .514 r
.61592 .52938 .61876 .52525 .62119 .51669 .61836 .52077 Mtetra
.923 .909 .515 r
.61836 .52077 .62119 .51669 .62375 .51013 .62094 .51418 Mtetra
0 0 0 r
.62094 .51418 .62375 .51013 .62651 .50625 .62371 .51028 Mtetra
.066 0 0 r
.62371 .51028 .62651 .50625 .6295 .50525 .62671 .50928 Mtetra
.394 0 .067 r
.62671 .50928 .6295 .50525 .63272 .50686 .62993 .51092 Mtetra
.517 .074 .137 r
.62993 .51092 .63272 .50686 .63611 .51039 .63333 .51448 Mtetra
.555 .115 .158 r
.63333 .51448 .63611 .51039 .63961 .51478 .63683 .51891 Mtetra
.538 .097 .149 r
.63683 .51891 .63961 .51478 .64311 .51884 .64033 .523 Mtetra
.456 .011 .103 r
.64033 .523 .64311 .51884 .6465 .52137 .64373 .52556 Mtetra
.234 0 0 r
.64373 .52556 .6465 .52137 .6497 .52146 .64694 .52567 Mtetra
0 0 0 r
.64694 .52567 .6497 .52146 .65265 .51864 .64989 .52283 Mtetra
.811 .888 .464 r
.64989 .52283 .65265 .51864 .65533 .51296 .65259 .51712 Mtetra
.966 .881 .495 r
.65259 .51712 .65533 .51296 .65779 .505 .65507 .50912 Mtetra
.992 .848 .489 r
.65507 .50912 .65779 .505 .66011 .49576 .6574 .49983 Mtetra
.994 .844 .488 r
.6574 .49983 .66011 .49576 .6624 .48644 .65971 .49046 Mtetra
.977 .872 .494 r
.65971 .49046 .6624 .48644 .66479 .47822 .66212 .48219 Mtetra
.873 .9 .485 r
.66212 .48219 .66479 .47822 .66737 .47208 .66472 .47602 Mtetra
0 0 0 r
.66472 .47602 .66737 .47208 .67024 .46864 .66759 .47256 Mtetra
.135 0 0 r
.66759 .47256 .67024 .46864 .67341 .46805 .67077 .47198 Mtetra
.414 0 .062 r
.67077 .47198 .67341 .46805 .67688 .47001 .67425 .47396 Mtetra
.522 .07 .12 r
.67425 .47396 .67688 .47001 .68057 .47378 .67794 .47777 Mtetra
.553 .103 .137 r
.67794 .47777 .68057 .47378 .68438 .47829 .68176 .48233 Mtetra
.531 .081 .126 r
.68176 .48233 .68438 .47829 .68817 .48235 .68555 .48642 Mtetra
.443 0 .078 r
.68555 .48642 .68817 .48235 .69181 .4848 .68919 .4889 Mtetra
.213 0 0 r
.68919 .4889 .69181 .4848 .69518 .48475 .69257 .48886 Mtetra
0 0 0 r
.69257 .48886 .69518 .48475 .6982 .48178 .69561 .48587 Mtetra
.793 .874 .44 r
.69561 .48587 .6982 .48178 .70089 .47599 .69831 .48006 Mtetra
.953 .875 .469 r
.69831 .48006 .70089 .47599 .7033 .46803 .70073 .47205 Mtetra
.983 .848 .465 r
.70073 .47205 .7033 .46803 .70554 .4589 .70299 .46287 Mtetra
.984 .847 .464 r
.70299 .46287 .70554 .4589 .70777 .44981 .70524 .45372 Mtetra
.955 .874 .469 r
.70524 .45372 .70777 .44981 .71013 .44192 .70762 .44579 Mtetra
.804 .879 .447 r
.70762 .44579 .71013 .44192 .71277 .43618 .71027 .44003 Mtetra
0 0 0 r
.71027 .44003 .71277 .43618 .71578 .43316 .71329 .437 Mtetra
.191 0 0 r
.71329 .437 .71578 .43316 .71918 .43298 .7167 .43682 Mtetra
.431 0 .053 r
.7167 .43682 .71918 .43298 .72294 .43527 .72047 .43914 Mtetra
.525 .064 .102 r
.72047 .43914 .72294 .43527 .72698 .43929 .72451 .44319 Mtetra
.549 .09 .115 r
.72451 .44319 .72698 .43929 .73114 .44393 .72868 .44788 Mtetra
.523 .063 .101 r
.72868 .44788 .73114 .44393 .73526 .448 .7328 .45199 Mtetra
.429 0 .054 r
.7328 .45199 .73526 .448 .73916 .45036 .73671 .45437 Mtetra
.193 0 0 r
.73671 .45437 .73916 .45036 .74271 .45016 .74027 .45419 Mtetra
0 0 0 r
.74027 .45419 .74271 .45016 .74582 .44703 .7434 .45105 Mtetra
.771 .856 .412 r
.7434 .45105 .74582 .44703 .74851 .44114 .7461 .44513 Mtetra
.935 .866 .439 r
.7461 .44513 .74851 .44114 .75087 .43316 .74848 .4371 Mtetra
.97 .845 .436 r
.74848 .4371 .75087 .43316 .75304 .42412 .75067 .42801 Mtetra
.967 .847 .437 r
.75067 .42801 .75304 .42412 .75522 .41524 .75286 .41907 Mtetra
.921 .87 .439 r
.75286 .41907 .75522 .41524 .7576 .40767 .75525 .41146 Mtetra
.718 .842 .404 r
.75525 .41146 .7576 .40767 .76032 .40232 .75799 .40608 Mtetra
0 0 0 r
.75799 .40608 .76032 .40232 .76351 .39971 .76119 .40347 Mtetra
.237 0 0 r
.76119 .40347 .76351 .39971 .76719 .39993 .76488 .4037 Mtetra
.444 0 .041 r
.76488 .4037 .76719 .39993 .7713 .40257 .769 .40637 Mtetra
.526 .055 .081 r
.769 .40637 .7713 .40257 .77573 .40682 .77344 .41066 Mtetra
.545 .075 .09 r
.77344 .41066 .77573 .40682 .7803 .4116 .77801 .41549 Mtetra
.514 .043 .075 r
.77801 .41549 .7803 .4116 .78478 .41568 .7825 .41961 Mtetra
.414 0 .028 r
.7825 .41961 .78478 .41568 .78897 .41795 .78671 .42191 Mtetra
.173 0 0 r
.78671 .42191 .78897 .41795 .79271 .41761 .79046 .42157 Mtetra
0 0 0 r
.79046 .42157 .79271 .41761 .79593 .41432 .79368 .41827 Mtetra
.745 .835 .38 r
.79368 .41827 .79593 .41432 .79863 .40831 .7964 .41223 Mtetra
.911 .852 .404 r
.7964 .41223 .79863 .40831 .80094 .40029 .79873 .40416 Mtetra
.949 .837 .403 r
.79873 .40416 .80094 .40029 .80305 .39133 .80085 .39515 Mtetra
.942 .841 .404 r
.80085 .39515 .80305 .39133 .80519 .38264 .80301 .38641 Mtetra
.873 .857 .403 r
.80301 .38641 .80519 .38264 .8076 .37538 .80544 .3791 Mtetra
.618 .792 .357 r
.80544 .3791 .8076 .37538 .81045 .3704 .8083 .3741 Mtetra
0 0 0 r
.8083 .3741 .81045 .3704 .81387 .36821 .81173 .37191 Mtetra
.275 0 0 r
.81173 .37191 .81387 .36821 .81788 .36882 .81576 .37253 Mtetra
.453 0 .025 r
.81576 .37253 .81788 .36882 .82241 .37181 .82029 .37555 Mtetra
.525 .044 .057 r
.82029 .37555 .82241 .37181 .8273 .37631 .82519 .3801 Mtetra
.539 .058 .064 r
.82519 .3801 .8273 .37631 .83232 .38123 .83023 .38506 Mtetra
.503 .023 .048 r
.83023 .38506 .83232 .38123 .83721 .38533 .83513 .3892 Mtetra
.398 0 .003 r
.83513 .3892 .83721 .38533 .84173 .38752 .83966 .39142 Mtetra
.155 0 0 r
.83966 .39142 .84173 .38752 .84569 .38702 .84363 .39093 Mtetra
.939 .959 .662 r
.39737 .801 .40099 .7972 .40372 .79194 .40011 .79572 Mtetra
.984 .846 .625 r
.40011 .79572 .40372 .79194 .40657 .78373 .40297 .78748 Mtetra
.97 .782 .594 r
.40297 .78748 .40657 .78373 .40949 .77343 .40592 .77713 Mtetra
.963 .761 .582 r
.40592 .77713 .40949 .77343 .41244 .76225 .40889 .7659 Mtetra
.966 .769 .587 r
.40889 .7659 .41244 .76225 .41535 .75154 .41183 .75513 Mtetra
.978 .812 .609 r
.41183 .75513 .41535 .75154 .41818 .74252 .41467 .74607 Mtetra
.98 .909 .654 r
.41467 .74607 .41818 .74252 .4209 .73611 .41741 .73964 Mtetra
.696 .922 .592 r
.41741 .73964 .4209 .73611 .4235 .7328 .42002 .73632 Mtetra
.162 0 0 r
.42002 .73632 .4235 .7328 .426 .73254 .42251 .73606 Mtetra
.486 .051 .138 r
.42251 .73606 .426 .73254 .42842 .73479 .42494 .73833 Mtetra
.576 .156 .208 r
.42494 .73833 .42842 .73479 .43081 .73856 .42732 .74213 Mtetra
.587 .169 .217 r
.42732 .74213 .43081 .73856 .43321 .74262 .42972 .74622 Mtetra
.534 .106 .175 r
.42972 .74622 .43321 .74262 .43567 .74564 .43216 .74927 Mtetra
.339 0 .032 r
.43216 .74927 .43567 .74564 .4382 .74647 .4347 .7501 Mtetra
0 0 0 r
.4347 .7501 .4382 .74647 .44083 .74433 .43733 .74796 Mtetra
.94 .957 .656 r
.43733 .74796 .44083 .74433 .44354 .73901 .44006 .74262 Mtetra
.987 .849 .618 r
.44006 .74262 .44354 .73901 .44632 .73087 .44285 .73444 Mtetra
.976 .788 .587 r
.44285 .73444 .44632 .73087 .44913 .72078 .44569 .72431 Mtetra
.97 .769 .577 r
.44569 .72431 .44913 .72078 .45195 .70996 .44852 .71344 Mtetra
.973 .781 .583 r
.44852 .71344 .45195 .70996 .45473 .69972 .45133 .70315 Mtetra
.985 .831 .609 r
.45133 .70315 .45473 .69972 .45746 .69125 .45408 .69464 Mtetra
.969 .934 .656 r
.45408 .69464 .45746 .69125 .46014 .6854 .45676 .68876 Mtetra
.556 .85 .529 r
.45676 .68876 .46014 .6854 .46276 .68259 .45939 .68595 Mtetra
.236 0 0 r
.45939 .68595 .46276 .68259 .46534 .68274 .46197 .68611 Mtetra
.503 .063 .135 r
.46197 .68611 .46534 .68274 .4679 .68527 .46453 .68866 Mtetra
.58 .152 .194 r
.46453 .68866 .4679 .68527 .47046 .68919 .46708 .69261 Mtetra
.585 .158 .198 r
.46708 .69261 .47046 .68919 .47304 .69326 .46966 .6967 Mtetra
.525 .088 .152 r
.46966 .6967 .47304 .69326 .47565 .69618 .47227 .69965 Mtetra
.316 0 0 r
.47227 .69965 .47565 .69618 .47831 .69686 .47493 .70034 Mtetra
0 0 0 r
.47493 .70034 .47831 .69686 .48099 .69459 .47762 .69807 Mtetra
.94 .955 .648 r
.47762 .69807 .48099 .69459 .4837 .68921 .48034 .69266 Mtetra
.99 .853 .609 r
.48034 .69266 .4837 .68921 .48641 .68112 .48306 .68454 Mtetra
.981 .794 .579 r
.48306 .68454 .48641 .68112 .48911 .67123 .48579 .6746 Mtetra
.976 .777 .57 r
.48579 .6746 .48911 .67123 .4918 .66074 .4885 .66406 Mtetra
.981 .793 .579 r
.4885 .66406 .4918 .66074 .49447 .65095 .49119 .65422 Mtetra
.989 .85 .609 r
.49119 .65422 .49447 .65095 .49713 .64298 .49387 .64622 Mtetra
.945 .954 .653 r
.49387 .64622 .49713 .64298 .49979 .63765 .49653 .64087 Mtetra
0 0 0 r
.49653 .64087 .49979 .63765 .50246 .63533 .49921 .63854 Mtetra
.294 0 0 r
.49921 .63854 .50246 .63533 .50515 .63587 .5019 .6391 Mtetra
.517 .07 .128 r
.5019 .6391 .50515 .63587 .50787 .63867 .50462 .64192 Mtetra
.583 .147 .178 r
.50462 .64192 .50787 .63867 .51063 .64273 .50737 .646 Mtetra
.582 .146 .177 r
.50737 .646 .51063 .64273 .51341 .6468 .51015 .65011 Mtetra
.515 .068 .127 r
.51015 .65011 .51341 .6468 .51619 .64963 .51293 .65296 Mtetra
.291 0 0 r
.51293 .65296 .51619 .64963 .51897 .65017 .51571 .65351 Mtetra
0 0 0 r
.51571 .65351 .51897 .65017 .52172 .64776 .51847 .65109 Mtetra
.939 .953 .639 r
.51847 .65109 .52172 .64776 .52442 .6423 .52118 .64562 Mtetra
.992 .856 .6 r
.52118 .64562 .52442 .6423 .52707 .63426 .52384 .63753 Mtetra
.986 .801 .571 r
.52384 .63753 .52707 .63426 .52967 .62454 .52647 .62777 Mtetra
.983 .787 .563 r
.52647 .62777 .52967 .62454 .53225 .61436 .52906 .61755 Mtetra
.987 .807 .574 r
.52906 .61755 .53225 .61436 .53483 .60498 .53166 .60812 Mtetra
.992 .871 .608 r
.53166 .60812 .53483 .60498 .53743 .5975 .53428 .60061 Mtetra
.904 .964 .644 r
.53428 .60061 .53743 .5975 .5401 .59267 .53696 .59576 Mtetra
0 0 0 r
.53696 .59576 .5401 .59267 .54284 .59081 .53971 .59389 Mtetra
.34 0 0 r
.53971 .59389 .54284 .59081 .54568 .59173 .54254 .59483 Mtetra
.528 .074 .118 r
.54254 .59483 .54568 .59173 .54859 .59479 .54546 .59791 Mtetra
.584 .139 .16 r
.54546 .59791 .54859 .59479 .55157 .59897 .54843 .60212 Mtetra
.578 .132 .155 r
.54843 .60212 .55157 .59897 .55456 .60305 .55142 .60623 Mtetra
.504 .047 .1 r
.55142 .60623 .55456 .60305 .55754 .60579 .55439 .60899 Mtetra
.265 0 0 r
.55439 .60899 .55754 .60579 .56045 .60618 .55731 .60939 Mtetra
0 0 0 r
.55731 .60939 .56045 .60618 .56326 .60364 .56013 .60684 Mtetra
.937 .951 .627 r
.56013 .60684 .56326 .60364 .56596 .5981 .56284 .60129 Mtetra
.994 .86 .589 r
.56284 .60129 .56596 .5981 .56855 .59008 .56544 .59323 Mtetra
.991 .808 .561 r
.56544 .59323 .56855 .59008 .57106 .58053 .56797 .58363 Mtetra
.989 .796 .555 r
.56797 .58363 .57106 .58053 .57353 .57064 .57046 .57369 Mtetra
.993 .822 .569 r
.57046 .57369 .57353 .57064 .57603 .56165 .57298 .56466 Mtetra
.989 .893 .607 r
.57298 .56466 .57603 .56165 .57861 .55462 .57557 .55761 Mtetra
.838 .96 .624 r
.57557 .55761 .57861 .55462 .58131 .55027 .57829 .55324 Mtetra
0 0 0 r
.57829 .55324 .58131 .55027 .58417 .54885 .58115 .55181 Mtetra
.377 0 0 r
.58115 .55181 .58417 .54885 .58718 .55013 .58416 .55311 Mtetra
.537 .075 .105 r
.58416 .55311 .58718 .55013 .59032 .55344 .5873 .55645 Mtetra
.584 .13 .14 r
.5873 .55645 .59032 .55344 .59354 .55775 .59051 .56079 Mtetra
.572 .116 .131 r
.59051 .56079 .59354 .55775 .59677 .56183 .59375 .5649 Mtetra
.491 .024 .072 r
.59375 .5649 .59677 .56183 .59995 .56448 .59693 .56757 Mtetra
.238 0 0 r
.59693 .56757 .59995 .56448 .60301 .56473 .59998 .56783 Mtetra
0 0 0 r
.59998 .56783 .60301 .56473 .60589 .56204 .60287 .56514 Mtetra
.933 .948 .614 r
.60287 .56514 .60589 .56204 .60858 .55643 .60558 .55949 Mtetra
.996 .864 .576 r
.60558 .55949 .60858 .55643 .61111 .54842 .60813 .55146 Mtetra
.995 .815 .55 r
.60813 .55146 .61111 .54842 .61353 .53901 .61057 .54199 Mtetra
.994 .807 .545 r
.61057 .54199 .61353 .53901 .61592 .52938 .61297 .53233 Mtetra
.997 .837 .563 r
.61297 .53233 .61592 .52938 .61836 .52077 .61543 .52367 Mtetra
.979 .913 .603 r
.61543 .52367 .61836 .52077 .62094 .51418 .61802 .51705 Mtetra
.746 .934 .593 r
.61802 .51705 .62094 .51418 .62371 .51028 .6208 .51314 Mtetra
0 0 0 r
.6208 .51314 .62371 .51028 .62671 .50928 .6238 .51215 Mtetra
.406 0 0 r
.6238 .51215 .62671 .50928 .62993 .51092 .62703 .5138 Mtetra
.543 .073 .089 r
.62703 .5138 .62993 .51092 .63333 .51448 .63042 .51738 Mtetra
.583 .119 .118 r
.63042 .51738 .63333 .51448 .63683 .51891 .63392 .52185 Mtetra
.566 .099 .106 r
.63392 .52185 .63683 .51891 .64033 .523 .63742 .52597 Mtetra
.477 0 .043 r
.63742 .52597 .64033 .523 .64373 .52556 .64082 .52855 Mtetra
.211 0 0 r
.64082 .52855 .64373 .52556 .64694 .52567 .64403 .52866 Mtetra
0 0 0 r
.64403 .52866 .64694 .52567 .64989 .52283 .647 .52582 Mtetra
.927 .944 .598 r
.647 .52582 .64989 .52283 .65259 .51712 .64971 .52009 Mtetra
.996 .867 .562 r
.64971 .52009 .65259 .51712 .65507 .50912 .6522 .51205 Mtetra
.998 .822 .537 r
.6522 .51205 .65507 .50912 .6574 .49983 .65456 .50272 Mtetra
.998 .817 .534 r
.65456 .50272 .6574 .49983 .65971 .49046 .65688 .4933 Mtetra
.998 .853 .554 r
.65688 .4933 .65971 .49046 .66212 .48219 .6593 .485 Mtetra
.959 .929 .596 r
.6593 .485 .66212 .48219 .66472 .47602 .66191 .4788 Mtetra
.631 .885 .55 r
.66191 .4788 .66472 .47602 .66759 .47256 .6648 .47533 Mtetra
.082 0 0 r
.6648 .47533 .66759 .47256 .67077 .47198 .66799 .47475 Mtetra
.429 0 0 r
.66799 .47475 .67077 .47198 .67425 .47396 .67146 .47675 Mtetra
.547 .069 .071 r
.67146 .47675 .67425 .47396 .67794 .47777 .67516 .48058 Mtetra
.58 .106 .094 r
.67516 .48058 .67794 .47777 .68176 .48233 .67897 .48517 Mtetra
.558 .08 .078 r
.67897 .48517 .68176 .48233 .68555 .48642 .68277 .4893 Mtetra
.461 0 .012 r
.68277 .4893 .68555 .48642 .68919 .4889 .68641 .49179 Mtetra
.184 0 0 r
.68641 .49179 .68919 .4889 .69257 .48886 .68979 .49176 Mtetra
0 0 0 r
.68979 .49176 .69257 .48886 .69561 .48587 .69284 .48877 Mtetra
.919 .939 .58 r
.69284 .48877 .69561 .48587 .69831 .48006 .69555 .48293 Mtetra
.994 .87 .544 r
.69555 .48293 .69831 .48006 .70073 .47205 .69799 .47489 Mtetra
1 .828 .521 r
.69799 .47489 .70073 .47205 .70299 .46287 .70027 .46566 Mtetra
.70027 .46566 .70299 .46287 .70524 .45372 .70253 .45647 Mtetra
.994 .868 .544 r
.70253 .45647 .70524 .45372 .70762 .44579 .70493 .44851 Mtetra
.925 .939 .584 r
.70493 .44851 .70762 .44579 .71027 .44003 .7076 .44271 Mtetra
.502 .817 .499 r
.7076 .44271 .71027 .44003 .71329 .437 .71062 .43968 Mtetra
.155 0 0 r
.71062 .43968 .71329 .437 .7167 .43682 .71404 .43951 Mtetra
.447 0 0 r
.71404 .43951 .7167 .43682 .72047 .43914 .71781 .44185 Mtetra
.549 .061 .049 r
.71781 .44185 .72047 .43914 .72451 .44319 .72185 .44593 Mtetra
.575 .091 .067 r
.72185 .44593 .72451 .44319 .72868 .44788 .72603 .45065 Mtetra
.548 .06 .049 r
.72603 .45065 .72868 .44788 .7328 .45199 .73015 .45479 Mtetra
.444 0 0 r
.73015 .45479 .7328 .45199 .73671 .45437 .73406 .45719 Mtetra
.157 0 0 r
.73406 .45719 .73671 .45437 .74027 .45419 .73762 .45701 Mtetra
0 0 0 r
.73762 .45701 .74027 .45419 .7434 .45105 .74076 .45387 Mtetra
.908 .932 .558 r
.74076 .45387 .7434 .45105 .7461 .44513 .74348 .44792 Mtetra
.989 .871 .524 r
.74348 .44792 .7461 .44513 .74848 .4371 .74587 .43985 Mtetra
.999 .834 .502 r
.74587 .43985 .74848 .4371 .75067 .42801 .74808 .43072 Mtetra
.998 .837 .504 r
.74808 .43072 .75067 .42801 .75286 .41907 .75029 .42174 Mtetra
.984 .882 .531 r
.75029 .42174 .75286 .41907 .75525 .41146 .75269 .41409 Mtetra
.873 .938 .565 r
.75269 .41409 .75525 .41146 .75799 .40608 .75545 .40869 Mtetra
0 0 0 r
.75545 .40869 .75799 .40608 .76119 .40347 .75865 .40608 Mtetra
.213 0 0 r
.75865 .40608 .76119 .40347 .76488 .4037 .76235 .40631 Mtetra
.46 0 0 r
.76235 .40631 .76488 .4037 .769 .40637 .76648 .409 Mtetra
.549 .051 .025 r
.76648 .409 .769 .40637 .77344 .41066 .77092 .41333 Mtetra
.569 .074 .039 r
.77092 .41333 .77344 .41066 .77801 .41549 .77549 .41819 Mtetra
.537 .038 .017 r
.77549 .41819 .77801 .41549 .7825 .41961 .77999 .42234 Mtetra
.426 0 0 r
.77999 .42234 .7825 .41961 .78671 .42191 .7842 .42466 Mtetra
.131 0 0 r
.7842 .42466 .78671 .42191 .79046 .42157 .78796 .42433 Mtetra
0 0 0 r
.78796 .42433 .79046 .42157 .79368 .41827 .7912 .42102 Mtetra
.893 .922 .533 r
.7912 .42102 .79368 .41827 .7964 .41223 .79393 .41495 Mtetra
.981 .87 .5 r
.79393 .41495 .7964 .41223 .79873 .40416 .79627 .40684 Mtetra
.994 .838 .48 r
.79627 .40684 .79873 .40416 .80085 .39515 .79841 .39778 Mtetra
.992 .845 .485 r
.79841 .39778 .80085 .39515 .80301 .38641 .80058 .38901 Mtetra
.965 .892 .514 r
.80058 .38901 .80301 .38641 .80544 .3791 .80302 .38167 Mtetra
.799 .922 .539 r
.80302 .38167 .80544 .3791 .8083 .3741 .8059 .37665 Mtetra
0 0 0 r
.8059 .37665 .8083 .3741 .81173 .37191 .80934 .37444 Mtetra
.259 0 0 r
.80934 .37444 .81173 .37191 .81576 .37253 .81337 .37508 Mtetra
.47 0 0 r
.81337 .37508 .81576 .37253 .82029 .37555 .81791 .37812 Mtetra
.547 .039 0 r
.81791 .37812 .82029 .37555 .82519 .3801 .82282 .38271 Mtetra
.561 .055 .007 r
.82282 .38271 .82519 .3801 .83023 .38506 .82786 .3877 Mtetra
.524 .014 0 r
.82786 .3877 .83023 .38506 .83513 .3892 .83277 .39188 Mtetra
.407 0 0 r
.83277 .39188 .83513 .3892 .83966 .39142 .83731 .39411 Mtetra
.107 0 0 r
.83731 .39411 .83966 .39142 .84363 .39093 .84129 .39363 Mtetra
.934 .857 .741 r
.39384 .80236 .39737 .801 .40011 .79572 .39659 .79706 Mtetra
.924 .747 .643 r
.39659 .79706 .40011 .79572 .40297 .78748 .39947 .7888 Mtetra
.913 .703 .604 r
.39947 .7888 .40297 .78748 .40592 .77713 .40243 .77842 Mtetra
.909 .688 .591 r
.40243 .77842 .40592 .77713 .40889 .7659 .40543 .76716 Mtetra
.911 .694 .596 r
.40543 .76716 .40889 .7659 .41183 .75513 .40838 .75636 Mtetra
.919 .723 .623 r
.40838 .75636 .41183 .75513 .41467 .74607 .41124 .74728 Mtetra
.931 .797 .69 r
.41124 .74728 .41467 .74607 .41741 .73964 .41398 .74083 Mtetra
.88 .963 .847 r
.41398 .74083 .41741 .73964 .42002 .73632 .4166 .7375 Mtetra
.024 0 0 r
.4166 .7375 .42002 .73632 .42251 .73606 .4191 .73725 Mtetra
.544 .04 .008 r
.4191 .73725 .42251 .73606 .42494 .73833 .42151 .73952 Mtetra
.645 .178 .131 r
.42151 .73952 .42494 .73833 .42732 .74213 .42389 .74334 Mtetra
.656 .194 .145 r
.42389 .74334 .42732 .74213 .42972 .74622 .42627 .74744 Mtetra
.6 .115 .075 r
.42627 .74744 .42972 .74622 .43216 .74927 .42872 .7505 Mtetra
.336 0 0 r
.42872 .7505 .43216 .74927 .4347 .7501 .43125 .75134 Mtetra
.682 .979 .863 r
.43125 .75134 .4347 .7501 .43733 .74796 .43388 .7492 Mtetra
.936 .856 .737 r
.43388 .7492 .43733 .74796 .44006 .74262 .43662 .74384 Mtetra
.929 .75 .64 r
.43662 .74384 .44006 .74262 .44285 .73444 .43943 .73564 Mtetra
.919 .707 .6 r
.43943 .73564 .44285 .73444 .44569 .72431 .44228 .72548 Mtetra
.915 .694 .588 r
.44228 .72548 .44569 .72431 .44852 .71344 .44513 .71458 Mtetra
.917 .702 .596 r
.44513 .71458 .44852 .71344 .45133 .70315 .44795 .70427 Mtetra
.926 .737 .628 r
.44795 .70427 .45133 .70315 .45408 .69464 .45072 .69573 Mtetra
.936 .823 .709 r
.45072 .69573 .45408 .69464 .45676 .68876 .45341 .68984 Mtetra
.824 .988 .874 r
.45341 .68984 .45676 .68876 .45939 .68595 .45605 .68702 Mtetra
.157 0 0 r
.45605 .68702 .45939 .68595 .46197 .68611 .45863 .68719 Mtetra
.563 .056 .008 r
.45863 .68719 .46197 .68611 .46453 .68866 .46118 .68975 Mtetra
.647 .173 .112 r
.46118 .68975 .46453 .68866 .46708 .69261 .46372 .69371 Mtetra
.652 .18 .119 r
.46372 .69371 .46708 .69261 .46966 .6967 .46629 .69782 Mtetra
.588 .09 .039 r
.46629 .69782 .46966 .6967 .47227 .69965 .4689 .70078 Mtetra
.295 0 0 r
.4689 .70078 .47227 .69965 .47493 .70034 .47155 .70147 Mtetra
.708 .985 .872 r
.47155 .70147 .47493 .70034 .47762 .69807 .47424 .69919 Mtetra
.939 .857 .733 r
.47424 .69919 .47762 .69807 .48034 .69266 .47697 .69377 Mtetra
.933 .754 .636 r
.47697 .69377 .48034 .69266 .48306 .68454 .47971 .68563 Mtetra
.924 .712 .597 r
.47971 .68563 .48306 .68454 .48579 .6746 .48245 .67566 Mtetra
.921 .7 .586 r
.48245 .67566 .48579 .6746 .4885 .66406 .48518 .6651 Mtetra
.924 .711 .596 r
.48518 .6651 .4885 .66406 .49119 .65422 .48789 .65523 Mtetra
.933 .752 .635 r
.48789 .65523 .49119 .65422 .49387 .64622 .49058 .64721 Mtetra
.938 .852 .731 r
.49058 .64721 .49387 .64622 .49653 .64087 .49325 .64185 Mtetra
.732 .988 .886 r
.49325 .64185 .49653 .64087 .49921 .63854 .49593 .63951 Mtetra
.256 0 0 r
.49593 .63951 .49921 .63854 .5019 .6391 .49862 .64007 Mtetra
.576 .066 .003 r
.49862 .64007 .5019 .6391 .50462 .64192 .50134 .6429 Mtetra
.648 .165 .091 r
.50134 .6429 .50462 .64192 .50737 .646 .50408 .647 Mtetra
.647 .164 .09 r
.50408 .647 .50737 .646 .51015 .65011 .50685 .65112 Mtetra
.574 .063 0 r
.50685 .65112 .51015 .65011 .51293 .65296 .50963 .65398 Mtetra
.251 0 0 r
.50963 .65398 .51293 .65296 .51571 .65351 .5124 .65453 Mtetra
.73 .989 .878 r
.5124 .65453 .51571 .65351 .51847 .65109 .51516 .65212 Mtetra
.942 .858 .729 r
.51516 .65212 .51847 .65109 .52118 .64562 .51788 .64662 Mtetra
.938 .758 .632 r
.51788 .64662 .52118 .64562 .52384 .63753 .52056 .63852 Mtetra
.93 .717 .592 r
.52056 .63852 .52384 .63753 .52647 .62777 .5232 .62873 Mtetra
.928 .707 .583 r
.5232 .62873 .52647 .62777 .52906 .61755 .52581 .61848 Mtetra
.931 .721 .597 r
.52581 .61848 .52906 .61755 .53166 .60812 .52842 .60903 Mtetra
.94 .77 .644 r
.52842 .60903 .53166 .60812 .53428 .60061 .53106 .6015 Mtetra
.935 .884 .758 r
.53106 .6015 .53428 .60061 .53696 .59576 .53374 .59664 Mtetra
.599 .952 .87 r
.53374 .59664 .53696 .59576 .53971 .59389 .5365 .59477 Mtetra
.328 0 0 r
.5365 .59477 .53971 .59389 .54254 .59483 .53933 .5957 Mtetra
.587 .071 0 r
.53933 .5957 .54254 .59483 .54546 .59791 .54224 .5988 Mtetra
.647 .155 .067 r
.54224 .5988 .54546 .59791 .54843 .60212 .5452 .60303 Mtetra
.64 .145 .059 r
.5452 .60303 .54843 .60212 .55142 .60623 .54818 .60715 Mtetra
.557 .033 0 r
.54818 .60715 .55142 .60623 .55439 .60899 .55115 .60992 Mtetra
.204 0 0 r
.55115 .60992 .55439 .60899 .55731 .60939 .55406 .61033 Mtetra
.747 .991 .88 r
.55406 .61033 .55731 .60939 .56013 .60684 .55689 .60777 Mtetra
.946 .861 .724 r
.55689 .60777 .56013 .60684 .56284 .60129 .55961 .6022 Mtetra
.944 .762 .627 r
.55961 .6022 .56284 .60129 .56544 .59323 .56222 .59412 Mtetra
.936 .722 .588 r
.56222 .59412 .56544 .59323 .56797 .58363 .56477 .58449 Mtetra
.935 .714 .58 r
.56477 .58449 .56797 .58363 .57046 .57369 .56728 .57453 Mtetra
.939 .733 .598 r
.56728 .57453 .57046 .57369 .57298 .56466 .56981 .56548 Mtetra
.947 .79 .655 r
.56981 .56548 .57298 .56466 .57557 .55761 .57242 .5584 Mtetra
.926 .918 .788 r
.57242 .5584 .57557 .55761 .57829 .55324 .57514 .55402 Mtetra
.438 .875 .823 r
.57514 .55402 .57829 .55324 .58115 .55181 .578 .5526 Mtetra
.381 0 0 r
.578 .5526 .58115 .55181 .58416 .55311 .58101 .5539 Mtetra
.593 .072 0 r
.58101 .5539 .58416 .55311 .5873 .55645 .58414 .55725 Mtetra
.644 .142 .041 r
.58414 .55725 .5873 .55645 .59051 .56079 .58735 .5616 Mtetra
.632 .125 .026 r
.58735 .5616 .59051 .56079 .59375 .5649 .59057 .56573 Mtetra
.538 .001 0 r
.59057 .56573 .59375 .5649 .59693 .56757 .59375 .56841 Mtetra
.156 0 0 r
.59375 .56841 .59693 .56757 .59998 .56783 .5968 .56867 Mtetra
.762 .992 .88 r
.5968 .56867 .59998 .56783 .60287 .56514 .5997 .56597 Mtetra
.95 .864 .719 r
.5997 .56597 .60287 .56514 .60558 .55949 .60242 .56032 Mtetra
.95 .768 .622 r
.60242 .56032 .60558 .55949 .60813 .55146 .60497 .55225 Mtetra
.943 .729 .583 r
.60497 .55225 .60813 .55146 .61057 .54199 .60743 .54277 Mtetra
.942 .723 .577 r
.60743 .54277 .61057 .54199 .61297 .53233 .60985 .53307 Mtetra
.946 .746 .6 r
.60985 .53307 .61297 .53233 .61543 .52367 .61232 .5244 Mtetra
.953 .813 .668 r
.61232 .5244 .61543 .52367 .61802 .51705 .61492 .51776 Mtetra
.904 .951 .821 r
.61492 .51776 .61802 .51705 .6208 .51314 .61771 .51384 Mtetra
.27 .772 .754 r
.61771 .51384 .6208 .51314 .6238 .51215 .62071 .51284 Mtetra
.42 0 0 r
.62071 .51284 .6238 .51215 .62703 .5138 .62393 .5145 Mtetra
.597 .069 0 r
.62393 .5145 .62703 .5138 .63042 .51738 .62733 .5181 Mtetra
.639 .127 .011 r
.62733 .5181 .63042 .51738 .63392 .52185 .63082 .52258 Mtetra
.621 .102 0 r
.63082 .52258 .63392 .52185 .63742 .52597 .63431 .52671 Mtetra
.517 0 0 r
.63431 .52671 .63742 .52597 .64082 .52855 .63771 .5293 Mtetra
.107 0 0 r
.63771 .5293 .64082 .52855 .64403 .52866 .64092 .52942 Mtetra
.774 .993 .878 r
.64092 .52942 .64403 .52866 .647 .52582 .64389 .52657 Mtetra
.954 .867 .713 r
.64389 .52657 .647 .52582 .64971 .52009 .64661 .52082 Mtetra
.956 .773 .616 r
.64661 .52082 .64971 .52009 .6522 .51205 .64911 .51277 Mtetra
.95 .736 .578 r
.64911 .51277 .6522 .51205 .65456 .50272 .65148 .50341 Mtetra
.95 .732 .574 r
.65148 .50341 .65456 .50272 .65688 .4933 .65382 .49396 Mtetra
.954 .761 .603 r
.65382 .49396 .65688 .4933 .6593 .485 .65625 .48564 Mtetra
.957 .839 .685 r
.65625 .48564 .6593 .485 .66191 .4788 .65888 .47942 Mtetra
.863 .979 .853 r
.65888 .47942 .66191 .4788 .6648 .47533 .66177 .47595 Mtetra
0 0 0 r
.66177 .47595 .6648 .47533 .66799 .47475 .66496 .47537 Mtetra
.448 0 0 r
.66496 .47537 .66799 .47475 .67146 .47675 .66843 .47737 Mtetra
.597 .062 0 r
.66843 .47737 .67146 .47675 .67516 .48058 .67212 .48122 Mtetra
.633 .11 0 r
.67212 .48122 .67516 .48058 .67897 .48517 .67593 .48583 Mtetra
.609 .078 0 r
.67593 .48583 .67897 .48517 .68277 .4893 .67972 .48997 Mtetra
.492 0 0 r
.67972 .48997 .68277 .4893 .68641 .49179 .68336 .49247 Mtetra
.059 0 0 r
.68336 .49247 .68641 .49179 .68979 .49176 .68674 .49244 Mtetra
.784 .994 .874 r
.68674 .49244 .68979 .49176 .69284 .48877 .68979 .48944 Mtetra
.959 .872 .707 r
.68979 .48944 .69284 .48877 .69555 .48293 .69251 .48359 Mtetra
.963 .78 .609 r
.69251 .48359 .69555 .48293 .69799 .47489 .69496 .47552 Mtetra
.958 .743 .571 r
.69496 .47552 .69799 .47489 .70027 .46566 .69726 .46627 Mtetra
.69726 .46627 .70027 .46566 .70253 .45647 .69953 .45706 Mtetra
.962 .778 .608 r
.69953 .45706 .70253 .45647 .70493 .44851 .70194 .44907 Mtetra
.959 .868 .705 r
.70194 .44907 .70493 .44851 .7076 .44271 .70462 .44326 Mtetra
.798 .992 .878 r
.70462 .44326 .7076 .44271 .71062 .43968 .70765 .44021 Mtetra
.008 0 0 r
.70765 .44021 .71062 .43968 .71404 .43951 .71107 .44005 Mtetra
.468 0 0 r
.71107 .44005 .71404 .43951 .71781 .44185 .71484 .4424 Mtetra
.595 .052 0 r
.71484 .4424 .71781 .44185 .72185 .44593 .71888 .44649 Mtetra
.624 .09 0 r
.71888 .44649 .72185 .44593 .72603 .45065 .72304 .45123 Mtetra
.594 .051 0 r
.72304 .45123 .72603 .45065 .73015 .45479 .72716 .45538 Mtetra
.465 0 0 r
.72716 .45538 .73015 .45479 .73406 .45719 .73107 .45779 Mtetra
.012 0 0 r
.73107 .45779 .73406 .45719 .73762 .45701 .73464 .45761 Mtetra
.791 .995 .87 r
.73464 .45761 .73762 .45701 .74076 .45387 .73778 .45446 Mtetra
.964 .878 .701 r
.73778 .45446 .74076 .45387 .74348 .44792 .74051 .44849 Mtetra
.97 .787 .602 r
.74051 .44849 .74348 .44792 .74587 .43985 .74291 .4404 Mtetra
.965 .752 .565 r
.74291 .4404 .74587 .43985 .74808 .43072 .74513 .43125 Mtetra
.966 .755 .568 r
.74513 .43125 .74808 .43072 .75029 .42174 .74735 .42225 Mtetra
.97 .798 .614 r
.74735 .42225 .75029 .42174 .75269 .41409 .74977 .41458 Mtetra
.955 .9 .729 r
.74977 .41458 .75269 .41409 .75545 .40869 .75253 .40916 Mtetra
.703 .982 .889 r
.75253 .40916 .75545 .40869 .75865 .40608 .75574 .40654 Mtetra
.106 0 0 r
.75574 .40654 .75865 .40608 .76235 .40631 .75944 .40678 Mtetra
.481 0 0 r
.75944 .40678 .76235 .40631 .76648 .409 .76356 .40948 Mtetra
.59 .039 0 r
.76356 .40948 .76648 .409 .77092 .41333 .768 .41382 Mtetra
.612 .068 0 r
.768 .41382 .77092 .41333 .77549 .41819 .77257 .41869 Mtetra
.576 .021 0 r
.77257 .41869 .77549 .41819 .77999 .42234 .77707 .42286 Mtetra
.436 0 0 r
.77707 .42286 .77999 .42234 .7842 .42466 .78127 .42518 Mtetra
0 0 0 r
.78127 .42518 .7842 .42466 .78796 .42433 .78504 .42486 Mtetra
.797 .996 .863 r
.78504 .42486 .78796 .42433 .7912 .42102 .78828 .42154 Mtetra
.969 .884 .693 r
.78828 .42154 .7912 .42102 .79393 .41495 .79102 .41545 Mtetra
.977 .795 .593 r
.79102 .41545 .79393 .41495 .79627 .40684 .79337 .40732 Mtetra
.973 .761 .557 r
.79337 .40732 .79627 .40684 .79841 .39778 .79553 .39824 Mtetra
.974 .769 .565 r
.79553 .39824 .79841 .39778 .80058 .38901 .79772 .38944 Mtetra
.977 .82 .621 r
.79772 .38944 .80058 .38901 .80302 .38167 .80016 .38208 Mtetra
.944 .933 .757 r
.80016 .38208 .80302 .38167 .8059 .37665 .80305 .37704 Mtetra
.581 .944 .88 r
.80305 .37704 .8059 .37665 .80934 .37444 .8065 .37484 Mtetra
.18 0 0 r
.8065 .37484 .80934 .37444 .81337 .37508 .81053 .37548 Mtetra
.488 0 0 r
.81053 .37548 .81337 .37508 .81791 .37812 .81507 .37853 Mtetra
.582 .023 0 r
.81507 .37853 .81791 .37812 .82282 .38271 .81997 .38313 Mtetra
.598 .043 0 r
.81997 .38313 .82282 .38271 .82786 .3877 .82501 .38814 Mtetra
.556 0 0 r
.82501 .38814 .82786 .3877 .83277 .39188 .82991 .39233 Mtetra
.405 0 0 r
.82991 .39233 .83277 .39188 .83731 .39411 .83445 .39457 Mtetra
0 0 0 r
.83445 .39457 .83731 .39411 .84129 .39363 .83844 .39409 Mtetra
.801 .656 .703 r
.39046 .80057 .39384 .80236 .39659 .79706 .39321 .79527 Mtetra
.826 .623 .628 r
.39321 .79527 .39659 .79706 .39947 .7888 .3961 .787 Mtetra
.833 .607 .596 r
.3961 .787 .39947 .7888 .40243 .77842 .39908 .77662 Mtetra
.836 .602 .585 r
.39908 .77662 .40243 .77842 .40543 .76716 .40208 .76536 Mtetra
.835 .604 .59 r
.40208 .76536 .40543 .76716 .40838 .75636 .40505 .75456 Mtetra
.83 .615 .611 r
.40505 .75456 .40838 .75636 .41124 .74728 .40792 .74547 Mtetra
.815 .639 .664 r
.40792 .74547 .41124 .74728 .41398 .74083 .41067 .73902 Mtetra
.752 .687 .789 r
.41067 .73902 .41398 .74083 .4166 .7375 .41329 .73569 Mtetra
.297 .631 .963 r
.41329 .73569 .4166 .7375 .4191 .73725 .41578 .73543 Mtetra
.574 .001 0 r
.41578 .73543 .4191 .73725 .42151 .73952 .41819 .7377 Mtetra
.734 .211 0 r
.41819 .7377 .42151 .73952 .42389 .74334 .42055 .74152 Mtetra
.747 .232 0 r
.42055 .74152 .42389 .74334 .42627 .74744 .42293 .74562 Mtetra
.672 .121 0 r
.42293 .74562 .42627 .74744 .42872 .7505 .42536 .74867 Mtetra
0 .383 .78 r
.42536 .74867 .42872 .7505 .43125 .75134 .42788 .7495 Mtetra
.672 .709 .876 r
.42788 .7495 .43125 .75134 .43388 .7492 .43052 .74736 Mtetra
.803 .656 .7 r
.43052 .74736 .43388 .7492 .43662 .74384 .43326 .742 Mtetra
.828 .623 .626 r
.43326 .742 .43662 .74384 .43943 .73564 .43608 .7338 Mtetra
.836 .608 .594 r
.43608 .7338 .43943 .73564 .44228 .72548 .43894 .72364 Mtetra
.838 .603 .584 r
.43894 .72364 .44228 .72548 .44513 .71458 .44181 .71273 Mtetra
.837 .606 .59 r
.44181 .71273 .44513 .71458 .44795 .70427 .44464 .70242 Mtetra
.831 .619 .616 r
.44464 .70242 .44795 .70427 .45072 .69573 .44742 .69388 Mtetra
.811 .646 .678 r
.44742 .69388 .45072 .69573 .45341 .68984 .45012 .68798 Mtetra
.723 .696 .824 r
.45012 .68798 .45341 .68984 .45605 .68702 .45275 .68516 Mtetra
.143 .555 .926 r
.45275 .68516 .45605 .68702 .45863 .68719 .45532 .68532 Mtetra
.597 .028 0 r
.45532 .68532 .45863 .68719 .46118 .68975 .45786 .68788 Mtetra
.728 .201 0 r
.45786 .68788 .46118 .68975 .46372 .69371 .4604 .69183 Mtetra
.734 .21 0 r
.4604 .69183 .46372 .69371 .46629 .69782 .46296 .69594 Mtetra
.641 .081 0 r
.46296 .69594 .46629 .69782 .4689 .70078 .46555 .69889 Mtetra
0 .433 .83 r
.46555 .69889 .4689 .70078 .47155 .70147 .4682 .69959 Mtetra
.68 .707 .868 r
.4682 .69959 .47155 .70147 .47424 .69919 .47089 .6973 Mtetra
.805 .656 .698 r
.47089 .6973 .47424 .69919 .47697 .69377 .47362 .69188 Mtetra
.831 .624 .623 r
.47362 .69188 .47697 .69377 .47971 .68563 .47637 .68373 Mtetra
.839 .609 .591 r
.47637 .68373 .47971 .68563 .48245 .67566 .47913 .67376 Mtetra
.841 .605 .582 r
.47913 .67376 .48245 .67566 .48518 .6651 .48187 .6632 Mtetra
.839 .609 .591 r
.48187 .6632 .48518 .6651 .48789 .65523 .48459 .65333 Mtetra
.831 .624 .622 r
.48459 .65333 .48789 .65523 .49058 .64721 .48728 .6453 Mtetra
.805 .655 .696 r
.48728 .6453 .49058 .64721 .49325 .64185 .48996 .63994 Mtetra
.684 .703 .861 r
.48996 .63994 .49325 .64185 .49593 .63951 .49264 .6376 Mtetra
0 .468 .865 r
.49264 .6376 .49593 .63951 .49862 .64007 .49533 .63816 Mtetra
.609 .044 0 r
.49533 .63816 .49862 .64007 .50134 .6429 .49803 .64099 Mtetra
.719 .187 0 r
.49803 .64099 .50134 .6429 .50408 .647 .50076 .64508 Mtetra
.719 .186 0 r
.50076 .64508 .50408 .647 .50685 .65112 .50351 .64919 Mtetra
.605 .039 0 r
.50351 .64919 .50685 .65112 .50963 .65398 .50628 .65205 Mtetra
.006 .474 .869 r
.50628 .65205 .50963 .65398 .5124 .65453 .50905 .65259 Mtetra
.687 .705 .862 r
.50905 .65259 .5124 .65453 .51516 .65212 .51181 .65017 Mtetra
.808 .657 .695 r
.51181 .65017 .51516 .65212 .51788 .64662 .51454 .64468 Mtetra
.834 .625 .62 r
.51454 .64468 .51788 .64662 .52056 .63852 .51722 .63657 Mtetra
.842 .611 .589 r
.51722 .63657 .52056 .63852 .5232 .62873 .51987 .62678 Mtetra
.843 .607 .58 r
.51987 .62678 .5232 .62873 .52581 .61848 .5225 .61653 Mtetra
.841 .612 .592 r
.5225 .61653 .52581 .61848 .52842 .60903 .52512 .60708 Mtetra
.831 .629 .63 r
.52512 .60708 .52842 .60903 .53106 .6015 .52777 .59954 Mtetra
.797 .664 .717 r
.52777 .59954 .53106 .6015 .53374 .59664 .53046 .59468 Mtetra
.63 .704 .899 r
.53046 .59468 .53374 .59664 .5365 .59477 .53321 .5928 Mtetra
0 .385 .796 r
.53321 .5928 .5365 .59477 .53933 .5957 .53603 .59374 Mtetra
.615 .052 0 r
.53603 .59374 .53933 .5957 .54224 .5988 .53893 .59683 Mtetra
.708 .171 0 r
.53893 .59683 .54224 .5988 .5452 .60303 .54188 .60105 Mtetra
.699 .158 0 r
.54188 .60105 .5452 .60303 .54818 .60715 .54485 .60516 Mtetra
.563 0 0 r
.54485 .60516 .54818 .60715 .55115 .60992 .54781 .60793 Mtetra
.071 .509 .898 r
.54781 .60793 .55115 .60992 .55406 .61033 .55071 .60833 Mtetra
.693 .704 .856 r
.55071 .60833 .55406 .61033 .55689 .60777 .55354 .60577 Mtetra
.81 .657 .693 r
.55354 .60577 .55689 .60777 .55961 .6022 .55626 .6002 Mtetra
.837 .626 .618 r
.55626 .6002 .55961 .6022 .56222 .59412 .55889 .59212 Mtetra
.845 .612 .586 r
.55889 .59212 .56222 .59412 .56477 .58449 .56144 .58249 Mtetra
.846 .609 .579 r
.56144 .58249 .56477 .58449 .56728 .57453 .56397 .57252 Mtetra
.843 .616 .594 r
.56397 .57252 .56728 .57453 .56981 .56548 .56651 .56347 Mtetra
.83 .635 .639 r
.56651 .56347 .56981 .56548 .57242 .5584 .56912 .55639 Mtetra
.785 .674 .741 r
.56912 .55639 .57242 .5584 .57514 .55402 .57184 .55201 Mtetra
.559 .695 .931 r
.57184 .55201 .57514 .55402 .578 .5526 .5747 .55058 Mtetra
0 .313 .732 r
.5747 .55058 .578 .5526 .58101 .5539 .5777 .55188 Mtetra
.614 .053 0 r
.5777 .55188 .58101 .5539 .58414 .55725 .58082 .55522 Mtetra
.694 .151 0 r
.58082 .55522 .58414 .55725 .58735 .5616 .58402 .55957 Mtetra
.676 .128 0 r
.58402 .55957 .58735 .5616 .59057 .56573 .58723 .56369 Mtetra
.517 0 0 r
.58723 .56369 .59057 .56573 .59375 .56841 .5904 .56636 Mtetra
.129 .537 .919 r
.5904 .56636 .59375 .56841 .5968 .56867 .59345 .56662 Mtetra
.699 .703 .85 r
.59345 .56662 .5968 .56867 .5997 .56597 .59634 .56391 Mtetra
.813 .658 .69 r
.59634 .56391 .5997 .56597 .60242 .56032 .59906 .55825 Mtetra
.84 .627 .615 r
.59906 .55825 .60242 .56032 .60497 .55225 .60163 .55019 Mtetra
.848 .613 .583 r
.60163 .55019 .60497 .55225 .60743 .54277 .6041 .5407 Mtetra
.849 .611 .578 r
.6041 .5407 .60743 .54277 .60985 .53307 .60653 .53101 Mtetra
.845 .62 .597 r
.60653 .53101 .60985 .53307 .61232 .5244 .60901 .52233 Mtetra
.828 .643 .651 r
.60901 .52233 .61232 .5244 .61492 .51776 .61162 .51569 Mtetra
.768 .684 .77 r
.61162 .51569 .61492 .51776 .61771 .51384 .61441 .51177 Mtetra
.47 .674 .953 r
.61441 .51177 .61771 .51384 .62071 .51284 .61741 .51077 Mtetra
0 .257 .68 r
.61741 .51077 .62071 .51284 .62393 .5145 .62062 .51242 Mtetra
.609 .048 0 r
.62062 .51242 .62393 .5145 .62733 .5181 .624 .51601 Mtetra
.677 .129 0 r
.624 .51601 .62733 .5181 .63082 .52258 .62748 .52048 Mtetra
.649 .095 0 r
.62748 .52048 .63082 .52258 .63431 .52671 .63096 .52461 Mtetra
.467 0 0 r
.63096 .52461 .63431 .52671 .63771 .5293 .63434 .52719 Mtetra
.18 .56 .933 r
.63434 .52719 .63771 .5293 .64092 .52942 .63755 .5273 Mtetra
.704 .703 .846 r
.63755 .5273 .64092 .52942 .64389 .52657 .64052 .52445 Mtetra
.817 .659 .688 r
.64052 .52445 .64389 .52657 .64661 .52082 .64324 .5187 Mtetra
.844 .629 .612 r
.64324 .5187 .64661 .52082 .64911 .51277 .64575 .51064 Mtetra
.852 .615 .58 r
.64575 .51064 .64911 .51277 .65148 .50341 .64814 .50128 Mtetra
.852 .614 .577 r
.64814 .50128 .65148 .50341 .65382 .49396 .65049 .49183 Mtetra
.846 .625 .602 r
.65049 .49183 .65382 .49396 .65625 .48564 .65293 .48351 Mtetra
.825 .651 .666 r
.65293 .48351 .65625 .48564 .65888 .47942 .65556 .47729 Mtetra
.744 .693 .802 r
.65556 .47729 .65888 .47942 .66177 .47595 .65845 .47381 Mtetra
.369 .638 .959 r
.65845 .47381 .66177 .47595 .66496 .47537 .66163 .47323 Mtetra
0 .216 .641 r
.66163 .47323 .66496 .47537 .66843 .47737 .6651 .47523 Mtetra
.599 .039 0 r
.6651 .47523 .66843 .47737 .67212 .48122 .66878 .47906 Mtetra
.656 .104 0 r
.66878 .47906 .67212 .48122 .67593 .48583 .67257 .48366 Mtetra
.618 .06 0 r
.67257 .48366 .67593 .48583 .67972 .48997 .67634 .4878 Mtetra
.414 0 0 r
.67634 .4878 .67972 .48997 .68336 .49247 .67997 .49029 Mtetra
.224 .578 .943 r
.67997 .49029 .68336 .49247 .68674 .49244 .68335 .49025 Mtetra
.709 .703 .842 r
.68335 .49025 .68674 .49244 .68979 .48944 .6864 .48725 Mtetra
.82 .661 .685 r
.6864 .48725 .68979 .48944 .69251 .48359 .68913 .4814 Mtetra
.848 .631 .609 r
.68913 .4814 .69251 .48359 .69496 .47552 .69159 .47333 Mtetra
.855 .617 .578 r
.69159 .47333 .69496 .47552 .69726 .46627 .69389 .46408 Mtetra
.856 .617 .577 r
.69389 .46408 .69726 .46627 .69953 .45706 .69618 .45486 Mtetra
.848 .63 .608 r
.69618 .45486 .69953 .45706 .70194 .44907 .6986 .44687 Mtetra
.821 .66 .683 r
.6986 .44687 .70194 .44907 .70462 .44326 .70128 .44106 Mtetra
.712 .7 .836 r
.70128 .44106 .70462 .44326 .70765 .44021 .70431 .43801 Mtetra
.263 .592 .948 r
.70431 .43801 .70765 .44021 .71107 .44005 .70772 .43784 Mtetra
0 .187 .616 r
.70772 .43784 .71107 .44005 .71484 .4424 .71148 .44018 Mtetra
.585 .026 0 r
.71148 .44018 .71484 .4424 .71888 .44649 .71551 .44426 Mtetra
.631 .077 0 r
.71551 .44426 .71888 .44649 .72304 .45123 .71966 .44899 Mtetra
.583 .023 0 r
.71966 .44899 .72304 .45123 .72716 .45538 .72376 .45314 Mtetra
0 .191 .62 r
.72376 .45314 .72716 .45538 .73107 .45779 .72766 .45554 Mtetra
.262 .593 .949 r
.72766 .45554 .73107 .45779 .73464 .45761 .73122 .45536 Mtetra
.714 .703 .838 r
.73122 .45536 .73464 .45761 .73778 .45446 .73436 .4522 Mtetra
.824 .663 .683 r
.73436 .4522 .73778 .45446 .74051 .44849 .7371 .44623 Mtetra
.852 .633 .605 r
.7371 .44623 .74051 .44849 .74291 .4404 .73951 .43814 Mtetra
.859 .62 .575 r
.73951 .43814 .74291 .4404 .74513 .43125 .74174 .42898 Mtetra
.859 .621 .578 r
.74174 .42898 .74513 .43125 .74735 .42225 .74398 .41998 Mtetra
.849 .637 .615 r
.74398 .41998 .74735 .42225 .74977 .41458 .7464 .41231 Mtetra
.813 .67 .705 r
.7464 .41231 .74977 .41458 .75253 .40916 .74917 .40689 Mtetra
.67 .702 .871 r
.74917 .40689 .75253 .40916 .75574 .40654 .75238 .40426 Mtetra
.161 .539 .925 r
.75238 .40426 .75574 .40654 .75944 .40678 .75607 .40449 Mtetra
0 .169 .601 r
.75607 .40449 .75944 .40678 .76356 .40948 .76018 .40718 Mtetra
.567 .009 0 r
.76018 .40718 .76356 .40948 .768 .41382 .76461 .41152 Mtetra
.603 .047 0 r
.76461 .41152 .768 .41382 .77257 .41869 .76916 .41638 Mtetra
.544 0 0 r
.76916 .41638 .77257 .41869 .77707 .42286 .77364 .42054 Mtetra
0 .234 .67 r
.77364 .42054 .77707 .42286 .78127 .42518 .77783 .42286 Mtetra
.295 .605 .952 r
.77783 .42286 .78127 .42518 .78504 .42486 .78159 .42252 Mtetra
.719 .704 .836 r
.78159 .42252 .78504 .42486 .78828 .42154 .78483 .4192 Mtetra
.828 .665 .681 r
.78483 .4192 .78828 .42154 .79102 .41545 .78758 .41311 Mtetra
.856 .635 .602 r
.78758 .41311 .79102 .41545 .79337 .40732 .78994 .40498 Mtetra
.864 .622 .572 r
.78994 .40498 .79337 .40732 .79553 .39824 .79211 .3959 Mtetra
.862 .625 .579 r
.79211 .3959 .79553 .39824 .79772 .38944 .79431 .38709 Mtetra
.849 .644 .625 r
.79431 .38709 .79772 .38944 .80016 .38208 .79676 .37973 Mtetra
.802 .68 .73 r
.79676 .37973 .80016 .38208 .80305 .37704 .79965 .37469 Mtetra
.615 .699 .904 r
.79965 .37469 .80305 .37704 .8065 .37484 .8031 .37248 Mtetra
.072 .487 .894 r
.8031 .37248 .8065 .37484 .81053 .37548 .80712 .37311 Mtetra
0 .159 .597 r
.80712 .37311 .81053 .37548 .81507 .37853 .81165 .37615 Mtetra
.545 0 0 r
.81165 .37615 .81507 .37853 .81997 .38313 .81654 .38074 Mtetra
.571 .016 0 r
.81654 .38074 .81997 .38313 .82501 .38814 .82155 .38575 Mtetra
.502 0 0 r
.82155 .38575 .82501 .38814 .82991 .39233 .82645 .38992 Mtetra
0 .273 .714 r
.82645 .38992 .82991 .39233 .83445 .39457 .83098 .39216 Mtetra
.323 .615 .954 r
.83098 .39216 .83445 .39457 .83844 .39409 .83496 .39167 Mtetra
.682 .507 .643 r
.38725 .79552 .39046 .80057 .39321 .79527 .39 .79023 Mtetra
.737 .521 .601 r
.39 .79023 .39321 .79527 .3961 .787 .39289 .78198 Mtetra
.759 .526 .58 r
.39289 .78198 .3961 .787 .39908 .77662 .39588 .77162 Mtetra
.767 .527 .572 r
.39588 .77162 .39908 .77662 .40208 .76536 .39889 .76039 Mtetra
.764 .527 .575 r
.39889 .76039 .40208 .76536 .40505 .75456 .40187 .74962 Mtetra
.749 .524 .59 r
.40187 .74962 .40505 .75456 .40792 .74547 .40475 .74055 Mtetra
.711 .515 .623 r
.40475 .74055 .40792 .74547 .41067 .73902 .4075 .73411 Mtetra
.616 .487 .683 r
.4075 .73411 .41067 .73902 .41329 .73569 .41011 .73078 Mtetra
.333 .374 .755 r
.41011 .73078 .41329 .73569 .41578 .73543 .41259 .73051 Mtetra
0 .05 .617 r
.41259 .73051 .41578 .73543 .41819 .7377 .41499 .73276 Mtetra
.621 .192 0 r
.41499 .73276 .41819 .7377 .42055 .74152 .41734 .73655 Mtetra
.661 .223 0 r
.41734 .73655 .42055 .74152 .42293 .74562 .41969 .74063 Mtetra
0 0 .502 r
.41969 .74063 .42293 .74562 .42536 .74867 .42211 .74366 Mtetra
.123 .272 .745 r
.42211 .74366 .42536 .74867 .42788 .7495 .42463 .74448 Mtetra
.54 .46 .714 r
.42463 .74448 .42788 .7495 .43052 .74736 .42726 .74233 Mtetra
.684 .507 .641 r
.42726 .74233 .43052 .74736 .43326 .742 .42999 .73698 Mtetra
.737 .52 .598 r
.42999 .73698 .43326 .742 .43608 .7338 .43282 .7288 Mtetra
.759 .524 .577 r
.43282 .7288 .43608 .7338 .43894 .72364 .43569 .71866 Mtetra
.766 .525 .57 r
.43569 .71866 .43894 .72364 .44181 .71273 .43857 .70778 Mtetra
.762 .525 .574 r
.43857 .70778 .44181 .71273 .44464 .70242 .44141 .69749 Mtetra
.744 .521 .592 r
.44141 .69749 .44464 .70242 .44742 .69388 .44419 .68897 Mtetra
.7 .512 .63 r
.44419 .68897 .44742 .69388 .45012 .68798 .44689 .68309 Mtetra
.587 .478 .697 r
.44689 .68309 .45012 .68798 .45275 .68516 .44952 .68027 Mtetra
.262 .343 .759 r
.44952 .68027 .45275 .68516 .45532 .68532 .45208 .68041 Mtetra
0 .025 .594 r
.45208 .68041 .45532 .68532 .45786 .68788 .45461 .68295 Mtetra
.609 .178 0 r
.45461 .68295 .45786 .68788 .4604 .69183 .45713 .68688 Mtetra
.627 .192 0 r
.45713 .68688 .4604 .69183 .46296 .69594 .45967 .69096 Mtetra
0 0 .544 r
.45967 .69096 .46296 .69594 .46555 .69889 .46225 .6939 Mtetra
.16 .294 .752 r
.46225 .6939 .46555 .69889 .4682 .69959 .46488 .69457 Mtetra
.546 .463 .712 r
.46488 .69457 .4682 .69959 .47089 .6973 .46757 .69229 Mtetra
.685 .507 .639 r
.46757 .69229 .47089 .6973 .47362 .69188 .4703 .68687 Mtetra
.738 .519 .596 r
.4703 .68687 .47362 .69188 .47637 .68373 .47306 .67874 Mtetra
.759 .522 .575 r
.47306 .67874 .47637 .68373 .47913 .67376 .47582 .6688 Mtetra
.765 .523 .568 r
.47582 .6688 .47913 .67376 .48187 .6632 .47857 .65826 Mtetra
.76 .523 .574 r
.47857 .65826 .48187 .6632 .48459 .65333 .4813 .64841 Mtetra
.738 .519 .596 r
.4813 .64841 .48459 .65333 .48728 .6453 .484 .64041 Mtetra
.687 .508 .639 r
.484 .64041 .48728 .6453 .48996 .63994 .48668 .63505 Mtetra
.552 .466 .712 r
.48668 .63505 .48996 .63994 .49264 .6376 .48935 .63271 Mtetra
.188 .311 .758 r
.48935 .63271 .49264 .6376 .49533 .63816 .49203 .63325 Mtetra
0 .007 .578 r
.49203 .63325 .49533 .63816 .49803 .64099 .49471 .63606 Mtetra
.592 .161 0 r
.49471 .63606 .49803 .64099 .50076 .64508 .49743 .64012 Mtetra
.589 .159 0 r
.49743 .64012 .50076 .64508 .50351 .64919 .50016 .64421 Mtetra
0 .012 .582 r
.50016 .64421 .50351 .64919 .50628 .65205 .50292 .64705 Mtetra
.194 .313 .758 r
.50292 .64705 .50628 .65205 .50905 .65259 .50568 .64758 Mtetra
.553 .465 .71 r
.50568 .64758 .50905 .65259 .51181 .65017 .50843 .64516 Mtetra
.686 .506 .637 r
.50843 .64516 .51181 .65017 .51454 .64468 .51115 .63967 Mtetra
.738 .517 .593 r
.51115 .63967 .51454 .64468 .51722 .63657 .51385 .63158 Mtetra
.759 .521 .572 r
.51385 .63158 .51722 .63657 .51987 .62678 .51651 .62182 Mtetra
.764 .521 .566 r
.51651 .62182 .51987 .62678 .5225 .61653 .51914 .61159 Mtetra
.757 .52 .574 r
.51914 .61159 .5225 .61653 .52512 .60708 .52177 .60216 Mtetra
.732 .516 .6 r
.52177 .60216 .52512 .60708 .52777 .59954 .52442 .59464 Mtetra
.671 .503 .649 r
.52442 .59464 .52777 .59954 .53046 .59468 .52711 .58978 Mtetra
.513 .453 .726 r
.52711 .58978 .53046 .59468 .53321 .5928 .52985 .5879 Mtetra
.117 .278 .753 r
.52985 .5879 .53321 .5928 .53603 .59374 .53267 .58882 Mtetra
0 0 .567 r
.53267 .58882 .53603 .59374 .53893 .59683 .53555 .59189 Mtetra
0 0 .412 r
.53555 .59189 .53893 .59683 .54188 .60105 .53848 .59608 Mtetra
0 0 .432 r
.53848 .59608 .54188 .60105 .54485 .60516 .54143 .60017 Mtetra
0 .052 .617 r
.54143 .60017 .54485 .60516 .54781 .60793 .54437 .60292 Mtetra
.223 .329 .762 r
.54437 .60292 .54781 .60793 .55071 .60833 .54727 .6033 Mtetra
.558 .468 .708 r
.54727 .6033 .55071 .60833 .55354 .60577 .55008 .60074 Mtetra
.687 .505 .635 r
.55008 .60074 .55354 .60577 .55626 .6002 .55281 .59518 Mtetra
.738 .516 .591 r
.55281 .59518 .55626 .6002 .55889 .59212 .55544 .58711 Mtetra
.759 .518 .569 r
.55544 .58711 .55889 .59212 .56144 .58249 .558 .57751 Mtetra
.763 .519 .565 r
.558 .57751 .56144 .58249 .56397 .57252 .56054 .56757 Mtetra
.753 .518 .575 r
.56054 .56757 .56397 .57252 .56651 .56347 .56309 .55854 Mtetra
.724 .513 .605 r
.56309 .55854 .56651 .56347 .56912 .55639 .5657 .55147 Mtetra
.652 .497 .66 r
.5657 .55147 .56912 .55639 .57184 .55201 .56842 .54709 Mtetra
.468 .437 .74 r
.56842 .54709 .57184 .55201 .5747 .55058 .57127 .54566 Mtetra
.051 .247 .744 r
.57127 .54566 .5747 .55058 .5777 .55188 .57426 .54694 Mtetra
0 0 .562 r
.57426 .54694 .5777 .55188 .58082 .55522 .57736 .55026 Mtetra
0 0 .437 r
.57736 .55026 .58082 .55522 .58402 .55957 .58054 .55458 Mtetra
0 0 .471 r
.58054 .55458 .58402 .55957 .58723 .56369 .58373 .55867 Mtetra
0 .089 .647 r
.58373 .55867 .58723 .56369 .5904 .56636 .58688 .56132 Mtetra
.25 .344 .765 r
.58688 .56132 .5904 .56636 .59345 .56662 .58992 .56156 Mtetra
.563 .469 .706 r
.58992 .56156 .59345 .56662 .59634 .56391 .59281 .55886 Mtetra
.688 .504 .633 r
.59281 .55886 .59634 .56391 .59906 .55825 .59553 .55321 Mtetra
.739 .514 .588 r
.59553 .55321 .59906 .55825 .60163 .55019 .5981 .54516 Mtetra
.758 .516 .567 r
.5981 .54516 .60163 .55019 .6041 .5407 .60058 .5357 Mtetra
.761 .517 .563 r
.60058 .5357 .6041 .5407 .60653 .53101 .60302 .52603 Mtetra
.749 .515 .576 r
.60302 .52603 .60653 .53101 .60901 .52233 .60551 .51737 Mtetra
.715 .51 .611 r
.60551 .51737 .60901 .52233 .61162 .51569 .60812 .51074 Mtetra
.631 .491 .673 r
.60812 .51074 .61162 .51569 .61441 .51177 .6109 .50682 Mtetra
.419 .419 .753 r
.6109 .50682 .61441 .51177 .61741 .51077 .6139 .50581 Mtetra
0 .22 .733 r
.6139 .50581 .61741 .51077 .62062 .51242 .61709 .50745 Mtetra
0 0 .563 r
.61709 .50745 .62062 .51242 .624 .51601 .62045 .51101 Mtetra
0 0 .464 r
.62045 .51101 .624 .51601 .62748 .52048 .62391 .51545 Mtetra
0 0 .51 r
.62391 .51545 .62748 .52048 .63096 .52461 .62737 .51955 Mtetra
0 .123 .673 r
.62737 .51955 .63096 .52461 .63434 .52719 .63074 .52211 Mtetra
.273 .357 .767 r
.63074 .52211 .63434 .52719 .63755 .5273 .63393 .52221 Mtetra
.567 .471 .704 r
.63393 .52221 .63755 .5273 .64052 .52445 .63689 .51936 Mtetra
.689 .503 .63 r
.63689 .51936 .64052 .52445 .64324 .5187 .63962 .51362 Mtetra
.739 .512 .585 r
.63962 .51362 .64324 .5187 .64575 .51064 .64214 .50557 Mtetra
.758 .514 .564 r
.64214 .50557 .64575 .51064 .64814 .50128 .64453 .49624 Mtetra
.759 .514 .562 r
.64453 .49624 .64814 .50128 .65049 .49183 .64689 .48681 Mtetra
.745 .512 .578 r
.64689 .48681 .65049 .49183 .65293 .48351 .64934 .47851 Mtetra
.704 .506 .618 r
.64934 .47851 .65293 .48351 .65556 .47729 .65197 .4723 Mtetra
.605 .483 .687 r
.65197 .4723 .65556 .47729 .65845 .47381 .65485 .46882 Mtetra
.366 .399 .763 r
.65485 .46882 .65845 .47381 .66163 .47323 .65803 .46823 Mtetra
0 .198 .723 r
.65803 .46823 .66163 .47323 .6651 .47523 .66147 .47021 Mtetra
0 .004 .568 r
.66147 .47021 .6651 .47523 .66878 .47906 .66513 .47402 Mtetra
0 0 .493 r
.66513 .47402 .66878 .47906 .67257 .48366 .6689 .47858 Mtetra
0 0 .546 r
.6689 .47858 .67257 .48366 .67634 .4878 .67265 .48269 Mtetra
0 .155 .696 r
.67265 .48269 .67634 .4878 .67997 .49029 .67627 .48516 Mtetra
.294 .367 .768 r
.67627 .48516 .67997 .49029 .68335 .49025 .67963 .48511 Mtetra
.571 .471 .702 r
.67963 .48511 .68335 .49025 .6864 .48725 .68267 .48211 Mtetra
.69 .502 .628 r
.68267 .48211 .6864 .48725 .68913 .4814 .6854 .47626 Mtetra
.738 .509 .582 r
.6854 .47626 .68913 .4814 .69159 .47333 .68787 .46821 Mtetra
.757 .511 .561 r
.68787 .46821 .69159 .47333 .69389 .46408 .69018 .45898 Mtetra
.69018 .45898 .69389 .46408 .69618 .45486 .69248 .44979 Mtetra
.739 .509 .581 r
.69248 .44979 .69618 .45486 .6986 .44687 .6949 .44182 Mtetra
.691 .502 .627 r
.6949 .44182 .6986 .44687 .70128 .44106 .69759 .43602 Mtetra
.576 .474 .701 r
.69759 .43602 .70128 .44106 .70431 .43801 .70061 .43296 Mtetra
.312 .378 .77 r
.70061 .43296 .70431 .43801 .70772 .43784 .70401 .43278 Mtetra
0 .181 .713 r
.70401 .43278 .70772 .43784 .71148 .44018 .70775 .4351 Mtetra
0 .015 .578 r
.70775 .4351 .71148 .44018 .71551 .44426 .71175 .43915 Mtetra
0 0 .522 r
.71175 .43915 .71551 .44426 .71966 .44899 .71588 .44385 Mtetra
0 .017 .58 r
.71588 .44385 .71966 .44899 .72376 .45314 .71996 .44796 Mtetra
0 .183 .715 r
.71996 .44796 .72376 .45314 .72766 .45554 .72384 .45035 Mtetra
.312 .377 .769 r
.72384 .45035 .72766 .45554 .73122 .45536 .72738 .45015 Mtetra
.574 .472 .7 r
.72738 .45015 .73122 .45536 .73436 .4522 .73052 .44699 Mtetra
.69 .5 .625 r
.73052 .44699 .73436 .4522 .7371 .44623 .73326 .44103 Mtetra
.738 .507 .579 r
.73326 .44103 .7371 .44623 .73951 .43814 .73567 .43296 Mtetra
.756 .508 .558 r
.73567 .43296 .73951 .43814 .74174 .42898 .73791 .42382 Mtetra
.754 .508 .56 r
.73791 .42382 .74174 .42898 .74398 .41998 .74016 .41484 Mtetra
.732 .506 .585 r
.74016 .41484 .74398 .41998 .7464 .41231 .74259 .40719 Mtetra
.676 .498 .637 r
.74259 .40719 .7464 .41231 .74917 .40689 .74535 .40178 Mtetra
.542 .464 .716 r
.74535 .40178 .74917 .40689 .75238 .40426 .74856 .39915 Mtetra
.258 .356 .774 r
.74856 .39915 .75238 .40426 .75607 .40449 .75223 .39936 Mtetra
0 .17 .707 r
.75223 .39936 .75607 .40449 .76018 .40718 .75632 .40203 Mtetra
0 .029 .59 r
.75632 .40203 .76018 .40718 .76461 .41152 .76072 .40633 Mtetra
0 0 .551 r
.76072 .40633 .76461 .41152 .76916 .41638 .76525 .41116 Mtetra
0 .051 .612 r
.76525 .41116 .76916 .41638 .77364 .42054 .7697 .41528 Mtetra
0 .209 .731 r
.7697 .41528 .77364 .42054 .77783 .42286 .77388 .41758 Mtetra
.328 .385 .769 r
.77388 .41758 .77783 .42286 .78159 .42252 .77762 .41723 Mtetra
.577 .472 .698 r
.77762 .41723 .78159 .42252 .78483 .4192 .78086 .4139 Mtetra
.69 .498 .622 r
.78086 .4139 .78483 .4192 .78758 .41311 .7836 .40782 Mtetra
.738 .504 .575 r
.7836 .40782 .78758 .41311 .78994 .40498 .78597 .39971 Mtetra
.754 .505 .556 r
.78597 .39971 .78994 .40498 .79211 .3959 .78815 .39065 Mtetra
.751 .505 .56 r
.78815 .39065 .79211 .3959 .79431 .38709 .79036 .38187 Mtetra
.724 .503 .59 r
.79036 .38187 .79431 .38709 .79676 .37973 .79282 .37452 Mtetra
.658 .492 .648 r
.79282 .37452 .79676 .37973 .79965 .37469 .79571 .3695 Mtetra
.505 .452 .731 r
.79571 .3695 .79965 .37469 .8031 .37248 .79914 .36728 Mtetra
.207 .336 .775 r
.79914 .36728 .8031 .37248 .80712 .37311 .80315 .36789 Mtetra
0 .163 .703 r
.80315 .36789 .80712 .37311 .81165 .37615 .80765 .37091 Mtetra
0 .046 .605 r
.80765 .37091 .81165 .37615 .81654 .38074 .81251 .37546 Mtetra
0 .02 .58 r
.81251 .37546 .81654 .38074 .82155 .38575 .8175 .38043 Mtetra
0 .084 .64 r
.8175 .38043 .82155 .38575 .82645 .38992 .82237 .38457 Mtetra
0 .233 .744 r
.82237 .38457 .82645 .38992 .83098 .39216 .82687 .38678 Mtetra
.342 .392 .768 r
.82687 .38678 .83098 .39216 .83496 .39167 .83084 .38628 Mtetra
.611 .423 .603 r
.38419 .7877 .38725 .79552 .39 .79023 .38693 .78242 Mtetra
.676 .455 .578 r
.38693 .78242 .39 .79023 .39289 .78198 .38983 .77421 Mtetra
.706 .47 .564 r
.38983 .77421 .39289 .78198 .39588 .77162 .39282 .7639 Mtetra
.716 .475 .559 r
.39282 .7639 .39588 .77162 .39889 .76039 .39584 .75272 Mtetra
.712 .473 .561 r
.39584 .75272 .39889 .76039 .40187 .74962 .39882 .742 Mtetra
.692 .463 .571 r
.39882 .742 .40187 .74962 .40475 .74055 .4017 .73297 Mtetra
.645 .44 .592 r
.4017 .73297 .40475 .74055 .4075 .73411 .40445 .72655 Mtetra
.543 .389 .622 r
.40445 .72655 .4075 .73411 .41011 .73078 .40705 .72323 Mtetra
.324 .273 .645 r
.40705 .72323 .41011 .73078 .41259 .73051 .40952 .72295 Mtetra
0 .062 .592 r
.40952 .72295 .41259 .73051 .41499 .73276 .4119 .72517 Mtetra
0 0 .474 r
.4119 .72517 .41499 .73276 .41734 .73655 .41423 .72892 Mtetra
0 0 .448 r
.41423 .72892 .41734 .73655 .41969 .74063 .41657 .73295 Mtetra
0 0 .546 r
.41657 .73295 .41969 .74063 .42211 .74366 .41898 .73595 Mtetra
.193 .2 .637 r
.41898 .73595 .42211 .74366 .42463 .74448 .42148 .73675 Mtetra
.475 .353 .634 r
.42148 .73675 .42463 .74448 .42726 .74233 .4241 .7346 Mtetra
.612 .422 .601 r
.4241 .7346 .42726 .74233 .42999 .73698 .42683 .72926 Mtetra
.676 .453 .576 r
.42683 .72926 .42999 .73698 .43282 .7288 .42965 .72111 Mtetra
.704 .467 .562 r
.42965 .72111 .43282 .7288 .43569 .71866 .43253 .71102 Mtetra
.714 .471 .557 r
.43253 .71102 .43569 .71866 .43857 .70778 .43541 .7002 Mtetra
.708 .468 .56 r
.43541 .7002 .43857 .70778 .44141 .69749 .43826 .68995 Mtetra
.684 .457 .572 r
.43826 .68995 .44141 .69749 .44419 .68897 .44104 .68147 Mtetra
.631 .432 .595 r
.44104 .68147 .44419 .68897 .44689 .68309 .44374 .6756 Mtetra
.516 .376 .629 r
.44374 .6756 .44689 .68309 .44952 .68027 .44636 .67278 Mtetra
.278 .251 .648 r
.44636 .67278 .44952 .68027 .45208 .68041 .44891 .67292 Mtetra
0 .045 .587 r
.44891 .67292 .45208 .68041 .45461 .68295 .45142 .67542 Mtetra
0 0 .482 r
.45142 .67542 .45461 .68295 .45713 .68688 .45392 .67931 Mtetra
0 0 .471 r
.45392 .67931 .45713 .68688 .45967 .69096 .45644 .68335 Mtetra
0 .008 .566 r
.45644 .68335 .45967 .69096 .46225 .6939 .459 .68625 Mtetra
.215 .216 .644 r
.459 .68625 .46225 .6939 .46488 .69457 .46162 .6869 Mtetra
.481 .357 .634 r
.46162 .6869 .46488 .69457 .46757 .69229 .4643 .68462 Mtetra
.613 .422 .599 r
.4643 .68462 .46757 .69229 .4703 .68687 .46703 .67922 Mtetra
.675 .451 .573 r
.46703 .67922 .4703 .68687 .47306 .67874 .46978 .67112 Mtetra
.703 .463 .559 r
.46978 .67112 .47306 .67874 .47582 .6688 .47255 .66123 Mtetra
.711 .467 .554 r
.47255 .66123 .47582 .6688 .47857 .65826 .4753 .65073 Mtetra
.703 .464 .559 r
.4753 .65073 .47857 .65826 .4813 .64841 .47804 .64093 Mtetra
.676 .451 .573 r
.47804 .64093 .4813 .64841 .484 .64041 .48074 .63296 Mtetra
.615 .424 .6 r
.48074 .63296 .484 .64041 .48668 .63505 .48342 .62762 Mtetra
.487 .361 .635 r
.48342 .62762 .48668 .63505 .48935 .63271 .48608 .62528 Mtetra
.231 .229 .65 r
.48608 .62528 .48935 .63271 .49203 .63325 .48874 .6258 Mtetra
0 .033 .583 r
.48874 .6258 .49203 .63325 .49471 .63606 .49141 .62857 Mtetra
0 0 .492 r
.49141 .62857 .49471 .63606 .49743 .64012 .4941 .6326 Mtetra
0 0 .494 r
.4941 .6326 .49743 .64012 .50016 .64421 .49682 .63664 Mtetra
0 .037 .585 r
.49682 .63664 .50016 .64421 .50292 .64705 .49955 .63944 Mtetra
.235 .23 .649 r
.49955 .63944 .50292 .64705 .50568 .64758 .5023 .63995 Mtetra
.486 .36 .633 r
.5023 .63995 .50568 .64758 .50843 .64516 .50504 .63753 Mtetra
.614 .421 .597 r
.50504 .63753 .50843 .64516 .51115 .63967 .50776 .63206 Mtetra
.674 .448 .571 r
.50776 .63206 .51115 .63967 .51385 .63158 .51045 .624 Mtetra
.701 .46 .556 r
.51045 .624 .51385 .63158 .51651 .62182 .51312 .61428 Mtetra
.708 .463 .552 r
.51312 .61428 .51651 .62182 .51914 .61159 .51576 .6041 Mtetra
.698 .459 .558 r
.51576 .6041 .51914 .61159 .52177 .60216 .51839 .59472 Mtetra
.666 .445 .575 r
.51839 .59472 .52177 .60216 .52442 .59464 .52104 .58723 Mtetra
.598 .414 .604 r
.52104 .58723 .52442 .59464 .52711 .58978 .52372 .58239 Mtetra
.455 .346 .641 r
.52372 .58239 .52711 .58978 .52985 .5879 .52646 .5805 Mtetra
.187 .208 .651 r
.52646 .5805 .52985 .5879 .53267 .58882 .52925 .5814 Mtetra
0 .026 .582 r
.52925 .5814 .53267 .58882 .53555 .59189 .53211 .58443 Mtetra
0 0 .505 r
.53211 .58443 .53555 .59189 .53848 .59608 .53502 .58858 Mtetra
0 0 .517 r
.53502 .58858 .53848 .59608 .54143 .60017 .53795 .59262 Mtetra
0 .063 .602 r
.53795 .59262 .54143 .60017 .54437 .60292 .54088 .59533 Mtetra
.253 .243 .653 r
.54088 .59533 .54437 .60292 .54727 .6033 .54375 .5957 Mtetra
.491 .362 .633 r
.54375 .5957 .54727 .6033 .55008 .60074 .54656 .59314 Mtetra
.614 .42 .595 r
.54656 .59314 .55008 .60074 .55281 .59518 .54928 .58759 Mtetra
.673 .445 .568 r
.54928 .58759 .55281 .59518 .55544 .58711 .55191 .57956 Mtetra
.699 .456 .553 r
.55191 .57956 .55544 .58711 .558 .57751 .55448 .57 Mtetra
.704 .458 .55 r
.55448 .57 .558 .57751 .56054 .56757 .55702 .56011 Mtetra
.692 .453 .557 r
.55702 .56011 .56054 .56757 .56309 .55854 .55957 .55112 Mtetra
.656 .438 .577 r
.55957 .55112 .56309 .55854 .5657 .55147 .56219 .54408 Mtetra
.578 .404 .61 r
.56219 .54408 .5657 .55147 .56842 .54709 .56491 .53971 Mtetra
.42 .33 .648 r
.56491 .53971 .56842 .54709 .57127 .54566 .56774 .53827 Mtetra
.144 .19 .651 r
.56774 .53827 .57127 .54566 .57426 .54694 .57071 .53952 Mtetra
0 .023 .583 r
.57071 .53952 .57426 .54694 .57736 .55026 .57379 .5428 Mtetra
0 0 .52 r
.57379 .5428 .57736 .55026 .58054 .55458 .57695 .54708 Mtetra
0 0 .539 r
.57695 .54708 .58054 .55458 .58373 .55867 .58012 .55112 Mtetra
0 .088 .617 r
.58012 .55112 .58373 .55867 .58688 .56132 .58324 .55374 Mtetra
.27 .254 .657 r
.58324 .55374 .58688 .56132 .58992 .56156 .58626 .55396 Mtetra
.495 .365 .632 r
.58626 .55396 .58992 .56156 .59281 .55886 .58914 .55126 Mtetra
.614 .418 .593 r
.58914 .55126 .59281 .55886 .59553 .55321 .59186 .54563 Mtetra
.671 .442 .565 r
.59186 .54563 .59553 .55321 .5981 .54516 .59443 .53762 Mtetra
.696 .452 .55 r
.59443 .53762 .5981 .54516 .60058 .5357 .59691 .5282 Mtetra
.7 .454 .548 r
.59691 .5282 .60058 .5357 .60302 .52603 .59936 .51857 Mtetra
.685 .448 .557 r
.59936 .51857 .60302 .52603 .60551 .51737 .60185 .50995 Mtetra
.643 .431 .58 r
.60185 .50995 .60551 .51737 .60812 .51074 .60446 .50335 Mtetra
.556 .394 .616 r
.60446 .50335 .60812 .51074 .6109 .50682 .60724 .49944 Mtetra
.384 .314 .654 r
.60724 .49944 .6109 .50682 .6139 .50581 .61022 .49842 Mtetra
.106 .174 .651 r
.61022 .49842 .6139 .50581 .61709 .50745 .6134 .50002 Mtetra
0 .024 .586 r
.6134 .50002 .61709 .50745 .62045 .51101 .61673 .50354 Mtetra
0 0 .536 r
.61673 .50354 .62045 .51101 .62391 .51545 .62016 .50794 Mtetra
0 0 .56 r
.62016 .50794 .62391 .51545 .62737 .51955 .62359 .51199 Mtetra
0 .111 .63 r
.62359 .51199 .62737 .51955 .63074 .52211 .62694 .51451 Mtetra
.285 .264 .66 r
.62694 .51451 .63074 .52211 .63393 .52221 .63012 .51459 Mtetra
.499 .366 .631 r
.63012 .51459 .63393 .52221 .63689 .51936 .63307 .51174 Mtetra
.613 .416 .591 r
.63307 .51174 .63689 .51936 .63962 .51362 .63579 .50602 Mtetra
.669 .438 .562 r
.63579 .50602 .63962 .51362 .64214 .50557 .63831 .49801 Mtetra
.693 .447 .547 r
.63831 .49801 .64214 .50557 .64453 .49624 .64071 .48872 Mtetra
.695 .448 .546 r
.64071 .48872 .64453 .49624 .64689 .48681 .64307 .47934 Mtetra
.677 .441 .557 r
.64307 .47934 .64689 .48681 .64934 .47851 .64553 .47107 Mtetra
.63 .423 .583 r
.64553 .47107 .64934 .47851 .65197 .4723 .64815 .46489 Mtetra
.532 .382 .623 r
.64815 .46489 .65197 .4723 .65485 .46882 .65103 .46141 Mtetra
.348 .298 .66 r
.65103 .46141 .65485 .46882 .65803 .46823 .65419 .4608 Mtetra
.073 .161 .651 r
.65419 .4608 .65803 .46823 .66147 .47021 .65761 .46275 Mtetra
0 .028 .591 r
.65761 .46275 .66147 .47021 .66513 .47402 .66124 .46651 Mtetra
0 0 .553 r
.66124 .46651 .66513 .47402 .6689 .47858 .66498 .47103 Mtetra
0 .012 .58 r
.66498 .47103 .6689 .47858 .67265 .48269 .66871 .47509 Mtetra
.02 .133 .642 r
.66871 .47509 .67265 .48269 .67627 .48516 .6723 .47752 Mtetra
.299 .274 .662 r
.6723 .47752 .67627 .48516 .67963 .48511 .67564 .47745 Mtetra
.502 .367 .63 r
.67564 .47745 .67963 .48511 .68267 .48211 .67867 .47445 Mtetra
.613 .413 .588 r
.67867 .47445 .68267 .48211 .6854 .47626 .6814 .46862 Mtetra
.667 .434 .559 r
.6814 .46862 .6854 .47626 .68787 .46821 .68387 .46061 Mtetra
.69 .443 .544 r
.68387 .46061 .68787 .46821 .69018 .45898 .68619 .45142 Mtetra
.68619 .45142 .69018 .45898 .69248 .44979 .68849 .44228 Mtetra
.668 .435 .558 r
.68849 .44228 .69248 .44979 .6949 .44182 .69092 .43434 Mtetra
.615 .415 .588 r
.69092 .43434 .6949 .44182 .69759 .43602 .6936 .42856 Mtetra
.507 .371 .63 r
.6936 .42856 .69759 .43602 .70061 .43296 .69661 .42551 Mtetra
.311 .283 .665 r
.69661 .42551 .70061 .43296 .70401 .43278 .69999 .4253 Mtetra
.045 .151 .652 r
.69999 .4253 .70401 .43278 .70775 .4351 .70371 .42759 Mtetra
0 .036 .598 r
.70371 .42759 .70775 .4351 .71175 .43915 .70768 .43159 Mtetra
0 0 .57 r
.70768 .43159 .71175 .43915 .71588 .44385 .71177 .43624 Mtetra
0 .038 .599 r
.71177 .43624 .71588 .44385 .71996 .44796 .71582 .4403 Mtetra
.048 .152 .652 r
.71582 .4403 .71996 .44796 .72384 .45035 .71968 .44264 Mtetra
.311 .282 .664 r
.71968 .44264 .72384 .45035 .72738 .45015 .7232 .44243 Mtetra
.504 .367 .628 r
.7232 .44243 .72738 .45015 .73052 .44699 .72633 .43927 Mtetra
.612 .411 .585 r
.72633 .43927 .73052 .44699 .73326 .44103 .72906 .43333 Mtetra
.665 .43 .555 r
.72906 .43333 .73326 .44103 .73567 .43296 .73148 .42529 Mtetra
.686 .437 .541 r
.73148 .42529 .73567 .43296 .73791 .42382 .73373 .4162 Mtetra
.684 .437 .542 r
.73373 .4162 .73791 .42382 .74016 .41484 .73598 .40727 Mtetra
.658 .428 .559 r
.73598 .40727 .74016 .41484 .74259 .40719 .73841 .39965 Mtetra
.598 .406 .593 r
.73841 .39965 .74259 .40719 .74535 .40178 .74117 .39426 Mtetra
.479 .358 .638 r
.74117 .39426 .74535 .40178 .74856 .39915 .74436 .39162 Mtetra
.275 .268 .67 r
.74436 .39162 .74856 .39915 .75223 .39936 .74801 .39181 Mtetra
.022 .145 .654 r
.74801 .39181 .75223 .39936 .75632 .40203 .75208 .39444 Mtetra
0 .046 .607 r
.75208 .39444 .75632 .40203 .76072 .40633 .75644 .39869 Mtetra
0 .016 .587 r
.75644 .39869 .76072 .40633 .76525 .41116 .76094 .40346 Mtetra
0 .063 .616 r
.76094 .40346 .76525 .41116 .7697 .41528 .76535 .40753 Mtetra
.074 .171 .661 r
.76535 .40753 .7697 .41528 .77388 .41758 .7695 .40979 Mtetra
.322 .288 .665 r
.7695 .40979 .77388 .41758 .77762 .41723 .77322 .40942 Mtetra
.506 .367 .626 r
.77322 .40942 .77762 .41723 .78086 .4139 .77645 .4061 Mtetra
.61 .407 .582 r
.77645 .4061 .78086 .4139 .7836 .40782 .77919 .40004 Mtetra
.662 .425 .551 r
.77919 .40004 .7836 .40782 .78597 .39971 .78156 .39197 Mtetra
.681 .432 .538 r
.78156 .39197 .78597 .39971 .78815 .39065 .78375 .38295 Mtetra
.677 .43 .541 r
.78375 .38295 .78815 .39065 .79036 .38187 .78596 .37421 Mtetra
.647 .42 .561 r
.78596 .37421 .79036 .38187 .79282 .37452 .78842 .3669 Mtetra
.579 .397 .598 r
.78842 .3669 .79282 .37452 .79571 .3695 .7913 .36188 Mtetra
.449 .346 .645 r
.7913 .36188 .79571 .3695 .79914 .36728 .79472 .35966 Mtetra
.241 .255 .675 r
.79472 .35966 .79914 .36728 .80315 .36789 .7987 .36025 Mtetra
.005 .142 .656 r
.7987 .36025 .80315 .36789 .80765 .37091 .80318 .36322 Mtetra
0 .059 .616 r
.80318 .36322 .80765 .37091 .81251 .37546 .808 .36771 Mtetra
0 .039 .604 r
.808 .36771 .81251 .37546 .8175 .38043 .81295 .37262 Mtetra
0 .087 .632 r
.81295 .37262 .8175 .38043 .82237 .38457 .81778 .37671 Mtetra
.099 .187 .669 r
.81778 .37671 .82237 .38457 .82687 .38678 .82225 .37888 Mtetra
.332 .294 .666 r
.82225 .37888 .82687 .38678 .83084 .38628 .82619 .37836 Mtetra
.575 .381 .581 r
.38125 .77809 .38419 .7877 .38693 .78242 .38399 .77284 Mtetra
.643 .42 .565 r
.38399 .77284 .38693 .78242 .38983 .77421 .38688 .76467 Mtetra
.676 .438 .555 r
.38688 .76467 .38983 .77421 .39282 .7639 .38987 .75442 Mtetra
.687 .445 .55 r
.38987 .75442 .39282 .7639 .39584 .75272 .39289 .74331 Mtetra
.683 .442 .552 r
.39289 .74331 .39584 .75272 .39882 .742 .39587 .73265 Mtetra
.66 .43 .56 r
.39587 .73265 .39882 .742 .4017 .73297 .39875 .72368 Mtetra
.61 .402 .575 r
.39875 .72368 .4017 .73297 .40445 .72655 .40149 .71729 Mtetra
.509 .345 .594 r
.40149 .71729 .40445 .72655 .40705 .72323 .40409 .71397 Mtetra
.318 .234 .601 r
.40409 .71397 .40705 .72323 .40952 .72295 .40655 .71368 Mtetra
.029 .063 .562 r
.40655 .71368 .40952 .72295 .4119 .72517 .40891 .71586 Mtetra
0 0 .487 r
.40891 .71586 .4119 .72517 .41423 .72892 .41122 .71956 Mtetra
0 0 .471 r
.41122 .71956 .41423 .72892 .41657 .73295 .41354 .72354 Mtetra
0 0 .533 r
.41354 .72354 .41657 .73295 .41898 .73595 .41592 .72649 Mtetra
.214 .172 .593 r
.41592 .72649 .41898 .73595 .42148 .73675 .41841 .72727 Mtetra
.446 .308 .598 r
.41841 .72727 .42148 .73675 .4241 .7346 .42102 .72511 Mtetra
.576 .381 .58 r
.42102 .72511 .4241 .7346 .42683 .72926 .42374 .7198 Mtetra
.642 .418 .563 r
.42374 .7198 .42683 .72926 .42965 .72111 .42657 .7117 Mtetra
.673 .435 .552 r
.42657 .7117 .42965 .72111 .43253 .71102 .42944 .70167 Mtetra
.684 .441 .548 r
.42944 .70167 .43253 .71102 .43541 .7002 .43232 .69091 Mtetra
.677 .437 .55 r
.43232 .69091 .43541 .7002 .43826 .68995 .43517 .68073 Mtetra
.651 .423 .56 r
.43517 .68073 .43826 .68995 .44104 .68147 .43795 .67229 Mtetra
.595 .392 .576 r
.43795 .67229 .44104 .68147 .44374 .6756 .44064 .66646 Mtetra
.484 .331 .597 r
.44064 .66646 .44374 .6756 .44636 .67278 .44325 .66364 Mtetra
.281 .215 .603 r
.44325 .66364 .44636 .67278 .44891 .67292 .44579 .66375 Mtetra
0 .05 .56 r
.44579 .66375 .44891 .67292 .45142 .67542 .44828 .66621 Mtetra
0 0 .495 r
.44828 .66621 .45142 .67542 .45392 .67931 .45076 .67005 Mtetra
0 0 .487 r
.45076 .67005 .45392 .67931 .45644 .68335 .45326 .67404 Mtetra
0 .021 .548 r
.45326 .67404 .45644 .68335 .459 .68625 .4558 .67689 Mtetra
.231 .186 .599 r
.4558 .67689 .459 .68625 .46162 .6869 .45841 .67752 Mtetra
.452 .311 .599 r
.45841 .67752 .46162 .6869 .4643 .68462 .46107 .67523 Mtetra
.577 .38 .578 r
.46107 .67523 .4643 .68462 .46703 .67922 .46379 .66986 Mtetra
.641 .415 .56 r
.46379 .66986 .46703 .67922 .46978 .67112 .46655 .66181 Mtetra
.671 .431 .549 r
.46655 .66181 .46978 .67112 .47255 .66123 .46932 .65197 Mtetra
.68 .436 .545 r
.46932 .65197 .47255 .66123 .4753 .65073 .47207 .64155 Mtetra
.671 .431 .549 r
.47207 .64155 .4753 .65073 .47804 .64093 .47481 .6318 Mtetra
.642 .416 .56 r
.47481 .6318 .47804 .64093 .48074 .63296 .47751 .62387 Mtetra
.579 .382 .579 r
.47751 .62387 .48074 .63296 .48342 .62762 .48018 .61856 Mtetra
.457 .316 .601 r
.48018 .61856 .48342 .62762 .48608 .62528 .48283 .61621 Mtetra
.244 .197 .604 r
.48283 .61621 .48608 .62528 .48874 .6258 .48547 .61671 Mtetra
0 .041 .561 r
.48547 .61671 .48874 .6258 .49141 .62857 .48812 .61944 Mtetra
0 0 .504 r
.48812 .61944 .49141 .62857 .4941 .6326 .49079 .62341 Mtetra
.49079 .62341 .4941 .6326 .49682 .63664 .49348 .6274 Mtetra
0 .043 .562 r
.49348 .6274 .49682 .63664 .49955 .63944 .4962 .63016 Mtetra
.246 .198 .604 r
.4962 .63016 .49955 .63944 .5023 .63995 .49892 .63065 Mtetra
.457 .315 .599 r
.49892 .63065 .5023 .63995 .50504 .63753 .50165 .62822 Mtetra
.577 .379 .577 r
.50165 .62822 .50504 .63753 .50776 .63206 .50437 .62278 Mtetra
.639 .412 .557 r
.50437 .62278 .50776 .63206 .51045 .624 .50706 .61476 Mtetra
.668 .427 .546 r
.50706 .61476 .51045 .624 .51312 .61428 .50973 .6051 Mtetra
.676 .431 .543 r
.50973 .6051 .51312 .61428 .51576 .6041 .51237 .59499 Mtetra
.665 .425 .548 r
.51237 .59499 .51576 .6041 .51839 .59472 .51501 .58566 Mtetra
.631 .408 .561 r
.51501 .58566 .51839 .59472 .52104 .58723 .51765 .57821 Mtetra
.561 .372 .582 r
.51765 .57821 .52104 .58723 .52372 .58239 .52033 .57338 Mtetra
.429 .302 .605 r
.52033 .57338 .52372 .58239 .52646 .5805 .52305 .57149 Mtetra
.208 .181 .606 r
.52305 .57149 .52646 .5805 .52925 .5814 .52583 .57236 Mtetra
0 .035 .562 r
.52583 .57236 .52925 .5814 .53211 .58443 .52866 .57534 Mtetra
0 0 .514 r
.52866 .57534 .53211 .58443 .53502 .58858 .53155 .57944 Mtetra
0 0 .521 r
.53155 .57944 .53502 .58858 .53795 .59262 .53445 .58343 Mtetra
.003 .065 .574 r
.53445 .58343 .53795 .59262 .54088 .59533 .53735 .5861 Mtetra
.261 .209 .608 r
.53735 .5861 .54088 .59533 .54375 .5957 .54021 .58644 Mtetra
.461 .317 .599 r
.54021 .58644 .54375 .5957 .54656 .59314 .54301 .58387 Mtetra
.577 .378 .575 r
.54301 .58387 .54656 .59314 .54928 .58759 .54572 .57835 Mtetra
.637 .408 .555 r
.54572 .57835 .54928 .58759 .55191 .57956 .54835 .57037 Mtetra
.665 .422 .543 r
.54835 .57037 .55191 .57956 .55448 .57 .55092 .56087 Mtetra
.671 .425 .54 r
.55092 .56087 .55448 .57 .55702 .56011 .55347 .55104 Mtetra
.658 .419 .546 r
.55347 .55104 .55702 .56011 .55957 .55112 .55602 .5421 Mtetra
.619 .4 .562 r
.55602 .5421 .55957 .55112 .56219 .54408 .55863 .5351 Mtetra
.542 .361 .585 r
.55863 .5351 .56219 .54408 .56491 .53971 .56134 .53075 Mtetra
.399 .287 .609 r
.56134 .53075 .56491 .53971 .56774 .53827 .56417 .52929 Mtetra
.175 .166 .607 r
.56417 .52929 .56774 .53827 .57071 .53952 .56711 .53052 Mtetra
0 .032 .565 r
.56711 .53052 .57071 .53952 .57379 .5428 .57017 .53375 Mtetra
0 0 .526 r
.57017 .53375 .57379 .5428 .57695 .54708 .57329 .53796 Mtetra
0 0 .538 r
.57329 .53796 .57695 .54708 .58012 .55112 .57644 .54195 Mtetra
.029 .084 .586 r
.57644 .54195 .58012 .55112 .58324 .55374 .57954 .54453 Mtetra
.274 .219 .612 r
.57954 .54453 .58324 .55374 .58626 .55396 .58254 .54472 Mtetra
.465 .319 .598 r
.58254 .54472 .58626 .55396 .58914 .55126 .5854 .54202 Mtetra
.577 .376 .572 r
.5854 .54202 .58914 .55126 .59186 .54563 .58812 .53641 Mtetra
.635 .405 .552 r
.58812 .53641 .59186 .54563 .59443 .53762 .59069 .52845 Mtetra
.662 .417 .54 r
.59069 .52845 .59443 .53762 .59691 .5282 .59317 .51909 Mtetra
.666 .419 .538 r
.59317 .51909 .59691 .5282 .59936 .51857 .59562 .50952 Mtetra
.649 .412 .546 r
.59562 .50952 .59936 .51857 .60185 .50995 .59812 .50095 Mtetra
.607 .391 .563 r
.59812 .50095 .60185 .50995 .60446 .50335 .60072 .49439 Mtetra
.521 .349 .589 r
.60072 .49439 .60446 .50335 .60724 .49944 .60349 .49048 Mtetra
.369 .272 .613 r
.60349 .49048 .60724 .49944 .61022 .49842 .60646 .48945 Mtetra
.144 .153 .609 r
.60646 .48945 .61022 .49842 .6134 .50002 .60961 .49102 Mtetra
0 .033 .57 r
.60961 .49102 .6134 .50002 .61673 .50354 .61291 .49449 Mtetra
0 0 .538 r
.61291 .49449 .61673 .50354 .62016 .50794 .61631 .49882 Mtetra
0 .001 .554 r
.61631 .49882 .62016 .50794 .62359 .51199 .61972 .50281 Mtetra
.053 .103 .597 r
.61972 .50281 .62359 .51199 .62694 .51451 .62304 .5053 Mtetra
.287 .228 .615 r
.62304 .5053 .62694 .51451 .63012 .51459 .62619 .50535 Mtetra
.468 .321 .598 r
.62619 .50535 .63012 .51459 .63307 .51174 .62913 .5025 Mtetra
.576 .374 .57 r
.62913 .5025 .63307 .51174 .63579 .50602 .63185 .4968 Mtetra
.633 .401 .548 r
.63185 .4968 .63579 .50602 .63831 .49801 .63437 .48884 Mtetra
.658 .412 .537 r
.63437 .48884 .63831 .49801 .64071 .48872 .63677 .4796 Mtetra
.66 .413 .536 r
.63677 .4796 .64071 .48872 .64307 .47934 .63914 .47028 Mtetra
.641 .404 .545 r
.63914 .47028 .64307 .47934 .64553 .47107 .64159 .46206 Mtetra
.592 .382 .565 r
.64159 .46206 .64553 .47107 .64815 .46489 .64421 .45591 Mtetra
.499 .338 .593 r
.64421 .45591 .64815 .46489 .65103 .46141 .64708 .45244 Mtetra
.338 .258 .617 r
.64708 .45244 .65103 .46141 .65419 .4608 .65022 .45182 Mtetra
.117 .143 .612 r
.65022 .45182 .65419 .4608 .65761 .46275 .65362 .45372 Mtetra
0 .037 .575 r
.65362 .45372 .65761 .46275 .66124 .46651 .65722 .45743 Mtetra
0 0 .552 r
.65722 .45743 .66124 .46651 .66498 .47103 .66092 .46189 Mtetra
0 .023 .569 r
.66092 .46189 .66498 .47103 .66871 .47509 .66461 .46588 Mtetra
.076 .121 .606 r
.66461 .46588 .66871 .47509 .6723 .47752 .66817 .46827 Mtetra
.298 .236 .618 r
.66817 .46827 .6723 .47752 .67564 .47745 .67149 .46818 Mtetra
.471 .322 .597 r
.67149 .46818 .67564 .47745 .67867 .47445 .67452 .46518 Mtetra
.575 .371 .567 r
.67452 .46518 .67867 .47445 .6814 .46862 .67724 .45938 Mtetra
.63 .396 .545 r
.67724 .45938 .6814 .46862 .68387 .46061 .67971 .45141 Mtetra
.653 .406 .533 r
.67971 .45141 .68387 .46061 .68619 .45142 .68203 .44229 Mtetra
.653 .407 .533 r
.68203 .44229 .68619 .45142 .68849 .44228 .68433 .43319 Mtetra
.631 .397 .545 r
.68433 .43319 .68849 .44228 .69092 .43434 .68676 .4253 Mtetra
.577 .372 .567 r
.68676 .4253 .69092 .43434 .6936 .42856 .68944 .41955 Mtetra
.475 .326 .598 r
.68944 .41955 .6936 .42856 .69661 .42551 .69244 .4165 Mtetra
.308 .245 .621 r
.69244 .4165 .69661 .42551 .69999 .4253 .6958 .41627 Mtetra
.094 .136 .614 r
.6958 .41627 .69999 .4253 .70371 .42759 .69948 .41852 Mtetra
0 .043 .582 r
.69948 .41852 .70371 .42759 .70768 .43159 .70342 .42246 Mtetra
0 .008 .565 r
.70342 .42246 .70768 .43159 .71177 .43624 .70747 .42704 Mtetra
0 .044 .583 r
.70747 .42704 .71177 .43624 .71582 .4403 .71149 .43104 Mtetra
.097 .137 .614 r
.71149 .43104 .71582 .4403 .71968 .44264 .71531 .43334 Mtetra
.308 .243 .62 r
.71531 .43334 .71968 .44264 .7232 .44243 .71881 .4331 Mtetra
.473 .322 .595 r
.71881 .4331 .7232 .44243 .72633 .43927 .72192 .42994 Mtetra
.573 .368 .564 r
.72192 .42994 .72633 .43927 .72906 .43333 .72465 .42403 Mtetra
.626 .391 .541 r
.72465 .42403 .72906 .43333 .73148 .42529 .72707 .41604 Mtetra
.648 .4 .53 r
.72707 .41604 .73148 .42529 .73373 .4162 .72932 .40701 Mtetra
.646 .399 .531 r
.72932 .40701 .73373 .4162 .73598 .40727 .73158 .39813 Mtetra
.62 .388 .545 r
.73158 .39813 .73598 .40727 .73841 .39965 .73401 .39055 Mtetra
.56 .363 .57 r
.73401 .39055 .73841 .39965 .74117 .39426 .73677 .38519 Mtetra
.45 .313 .603 r
.73677 .38519 .74117 .39426 .74436 .39162 .73994 .38255 Mtetra
.279 .232 .625 r
.73994 .38255 .74436 .39162 .74801 .39181 .74357 .38272 Mtetra
.076 .131 .618 r
.74357 .38272 .74801 .39181 .75208 .39444 .7476 .38529 Mtetra
0 .051 .59 r
.7476 .38529 .75208 .39444 .75644 .39869 .75192 .38948 Mtetra
0 .027 .579 r
.75192 .38948 .75644 .39869 .76094 .40346 .75637 .39418 Mtetra
0 .065 .596 r
.75637 .39418 .76094 .40346 .76535 .40753 .76075 .39819 Mtetra
.118 .152 .622 r
.76075 .39819 .76535 .40753 .7695 .40979 .76486 .4004 Mtetra
.317 .25 .621 r
.76486 .4004 .7695 .40979 .77322 .40942 .76856 .40001 Mtetra
.474 .322 .594 r
.76856 .40001 .77322 .40942 .77645 .4061 .77177 .39669 Mtetra
.571 .364 .561 r
.77177 .39669 .77645 .4061 .77919 .40004 .77451 .39066 Mtetra
.622 .386 .538 r
.77451 .39066 .77919 .40004 .78156 .39197 .77688 .38263 Mtetra
.643 .394 .527 r
.77688 .38263 .78156 .39197 .78375 .38295 .77907 .37368 Mtetra
.638 .392 .529 r
.77907 .37368 .78375 .38295 .78596 .37421 .78129 .36499 Mtetra
.608 .38 .545 r
.78129 .36499 .78596 .37421 .78842 .3669 .78375 .35772 Mtetra
.541 .352 .574 r
.78375 .35772 .78842 .3669 .7913 .36188 .78663 .35272 Mtetra
.425 .302 .608 r
.78663 .35272 .7913 .36188 .79472 .35966 .79003 .35049 Mtetra
.251 .222 .63 r
.79003 .35049 .79472 .35966 .7987 .36025 .79398 .35105 Mtetra
.061 .129 .622 r
.79398 .35105 .7987 .36025 .80318 .36322 .79842 .35396 Mtetra
0 .062 .599 r
.79842 .35396 .80318 .36322 .808 .36771 .80319 .35839 Mtetra
0 .045 .592 r
.80319 .35839 .808 .36771 .81295 .37262 .80809 .36322 Mtetra
0 .085 .609 r
.80809 .36322 .81295 .37262 .81778 .37671 .81288 .36725 Mtetra
.136 .166 .628 r
.81288 .36725 .81778 .37671 .82225 .37888 .81731 .36937 Mtetra
.325 .255 .622 r
.81731 .36937 .82225 .37888 .82619 .37836 .82123 .36882 Mtetra
.565 .37 .576 r
.37836 .76799 .38125 .77809 .38399 .77284 .38109 .76276 Mtetra
.634 .41 .561 r
.38109 .76276 .38399 .77284 .38688 .76467 .38398 .75464 Mtetra
.667 .43 .552 r
.38398 .75464 .38688 .76467 .38987 .75442 .38697 .74446 Mtetra
.679 .437 .548 r
.38697 .74446 .38987 .75442 .39289 .74331 .38999 .73342 Mtetra
.674 .434 .549 r
.38999 .73342 .39289 .74331 .39587 .73265 .39297 .72283 Mtetra
.651 .42 .557 r
.39297 .72283 .39587 .73265 .39875 .72368 .39584 .71391 Mtetra
.6 .391 .57 r
.39584 .71391 .39875 .72368 .40149 .71729 .39858 .70756 Mtetra
.5 .333 .586 r
.39858 .70756 .40149 .71729 .40409 .71397 .40117 .70424 Mtetra
.316 .225 .591 r
.40117 .70424 .40409 .71397 .40655 .71368 .40361 .70393 Mtetra
.047 .063 .553 r
.40361 .70393 .40655 .71368 .40891 .71586 .40596 .70608 Mtetra
0 0 .487 r
.40596 .70608 .40891 .71586 .41122 .71956 .40825 .70973 Mtetra
0 0 .473 r
.40825 .70973 .41122 .71956 .41354 .72354 .41055 .71365 Mtetra
0 .003 .527 r
.41055 .71365 .41354 .72354 .41592 .72649 .41291 .71656 Mtetra
.218 .166 .582 r
.41291 .71656 .41592 .72649 .41841 .72727 .41538 .71731 Mtetra
.439 .296 .589 r
.41538 .71731 .41841 .72727 .42102 .72511 .41798 .71515 Mtetra
.566 .37 .574 r
.41798 .71515 .42102 .72511 .42374 .7198 .4207 .70986 Mtetra
.633 .408 .559 r
.4207 .70986 .42374 .7198 .42657 .7117 .42352 .7018 Mtetra
.665 .426 .549 r
.42352 .7018 .42657 .7117 .42944 .70167 .42639 .69184 Mtetra
.675 .432 .545 r
.42639 .69184 .42944 .70167 .43232 .69091 .42927 .68115 Mtetra
.669 .428 .548 r
.42927 .68115 .43232 .69091 .43517 .68073 .43212 .67104 Mtetra
.642 .413 .556 r
.43212 .67104 .43517 .68073 .43795 .67229 .4349 .66265 Mtetra
.585 .382 .571 r
.4349 .66265 .43795 .67229 .44064 .66646 .43759 .65684 Mtetra
.476 .319 .589 r
.43759 .65684 .44064 .66646 .44325 .66364 .44019 .65403 Mtetra
.281 .207 .592 r
.44019 .65403 .44325 .66364 .44579 .66375 .44271 .65412 Mtetra
.017 .051 .553 r
.44271 .65412 .44579 .66375 .44828 .66621 .44518 .65654 Mtetra
0 0 .495 r
.44518 .65654 .44828 .66621 .45076 .67005 .44764 .66032 Mtetra
0 0 .488 r
.44764 .66032 .45076 .67005 .45326 .67404 .45011 .66425 Mtetra
0 .024 .541 r
.45011 .66425 .45326 .67404 .4558 .67689 .45264 .66706 Mtetra
.234 .179 .588 r
.45264 .66706 .4558 .67689 .45841 .67752 .45522 .66767 Mtetra
.444 .3 .59 r
.45522 .66767 .45841 .67752 .46107 .67523 .45788 .66538 Mtetra
.567 .369 .573 r
.45788 .66538 .46107 .67523 .46379 .66986 .46059 .66003 Mtetra
.631 .405 .556 r
.46059 .66003 .46379 .66986 .46655 .66181 .46334 .65202 Mtetra
.662 .422 .546 r
.46334 .65202 .46655 .66181 .46932 .65197 .46611 .64225 Mtetra
.671 .427 .543 r
.46611 .64225 .46932 .65197 .47207 .64155 .46887 .63189 Mtetra
.662 .422 .546 r
.46887 .63189 .47207 .64155 .47481 .6318 .4716 .62221 Mtetra
.632 .406 .556 r
.4716 .62221 .47481 .6318 .47751 .62387 .4743 .61433 Mtetra
.569 .371 .573 r
.4743 .61433 .47751 .62387 .48018 .61856 .47696 .60904 Mtetra
.45 .305 .592 r
.47696 .60904 .48018 .61856 .48283 .61621 .4796 .6067 Mtetra
.246 .189 .593 r
.4796 .6067 .48283 .61621 .48547 .61671 .48223 .60717 Mtetra
0 .042 .554 r
.48223 .60717 .48547 .61671 .48812 .61944 .48486 .60985 Mtetra
0 0 .503 r
.48486 .60985 .48812 .61944 .49079 .62341 .4875 .61377 Mtetra
0 0 .504 r
.4875 .61377 .49079 .62341 .49348 .6274 .49017 .6177 Mtetra
0 .045 .554 r
.49017 .6177 .49348 .6274 .4962 .63016 .49286 .62041 Mtetra
.249 .19 .593 r
.49286 .62041 .4962 .63016 .49892 .63065 .49557 .62087 Mtetra
.449 .303 .59 r
.49557 .62087 .49892 .63065 .50165 .62822 .49829 .61845 Mtetra
.567 .368 .571 r
.49829 .61845 .50165 .62822 .50437 .62278 .501 .61303 Mtetra
.629 .402 .554 r
.501 .61303 .50437 .62278 .50706 .61476 .50369 .60506 Mtetra
.659 .418 .543 r
.50369 .60506 .50706 .61476 .50973 .6051 .50635 .59547 Mtetra
.667 .422 .54 r
.50635 .59547 .50973 .6051 .51237 .59499 .509 .58541 Mtetra
.656 .416 .545 r
.509 .58541 .51237 .59499 .51501 .58566 .51164 .57615 Mtetra
.621 .398 .556 r
.51164 .57615 .51501 .58566 .51765 .57821 .51428 .56874 Mtetra
.552 .361 .575 r
.51428 .56874 .51765 .57821 .52033 .57338 .51695 .56394 Mtetra
.422 .29 .595 r
.51695 .56394 .52033 .57338 .52305 .57149 .51965 .56204 Mtetra
.213 .174 .595 r
.51965 .56204 .52305 .57149 .52583 .57236 .52241 .56288 Mtetra
0 .037 .556 r
.52241 .56288 .52583 .57236 .52866 .57534 .52523 .56581 Mtetra
0 0 .513 r
.52523 .56581 .52866 .57534 .53155 .57944 .52808 .56985 Mtetra
0 0 .52 r
.52808 .56985 .53155 .57944 .53445 .58343 .53096 .57378 Mtetra
.022 .065 .566 r
.53096 .57378 .53445 .58343 .53735 .5861 .53384 .5764 Mtetra
.263 .201 .597 r
.53384 .5764 .53735 .5861 .54021 .58644 .53668 .57672 Mtetra
.453 .306 .59 r
.53668 .57672 .54021 .58644 .54301 .58387 .53946 .57416 Mtetra
.567 .367 .569 r
.53946 .57416 .54301 .58387 .54572 .57835 .54217 .56866 Mtetra
.627 .398 .551 r
.54217 .56866 .54572 .57835 .54835 .57037 .5448 .56073 Mtetra
.656 .413 .54 r
.5448 .56073 .54835 .57037 .55092 .56087 .54737 .55129 Mtetra
.662 .416 .538 r
.54737 .55129 .55092 .56087 .55347 .55104 .54992 .54152 Mtetra
.648 .409 .543 r
.54992 .54152 .55347 .55104 .55602 .5421 .55247 .53264 Mtetra
.61 .389 .557 r
.55247 .53264 .55602 .5421 .55863 .5351 .55508 .52568 Mtetra
.533 .349 .578 r
.55508 .52568 .55863 .5351 .56134 .53075 .55778 .52134 Mtetra
.394 .276 .599 r
.55778 .52134 .56134 .53075 .56417 .52929 .56059 .51988 Mtetra
.182 .16 .596 r
.56059 .51988 .56417 .52929 .56711 .53052 .56352 .52107 Mtetra
0 .034 .559 r
.56352 .52107 .56711 .53052 .57017 .53375 .56654 .52425 Mtetra
0 0 .524 r
.56654 .52425 .57017 .53375 .57329 .53796 .56964 .5284 Mtetra
0 0 .535 r
.56964 .5284 .57329 .53796 .57644 .54195 .57276 .53233 Mtetra
.045 .083 .577 r
.57276 .53233 .57644 .54195 .57954 .54453 .57583 .53486 Mtetra
.275 .211 .601 r
.57583 .53486 .57954 .54453 .58254 .54472 .57881 .53503 Mtetra
.457 .308 .59 r
.57881 .53503 .58254 .54472 .5854 .54202 .58166 .53233 Mtetra
.567 .365 .567 r
.58166 .53233 .5854 .54202 .58812 .53641 .58437 .52675 Mtetra
.625 .394 .548 r
.58437 .52675 .58812 .53641 .59069 .52845 .58694 .51884 Mtetra
.652 .408 .537 r
.58694 .51884 .59069 .52845 .59317 .51909 .58943 .50954 Mtetra
.656 .41 .535 r
.58943 .50954 .59317 .51909 .59562 .50952 .59188 .50003 Mtetra
.64 .402 .542 r
.59188 .50003 .59562 .50952 .59812 .50095 .59438 .49152 Mtetra
.596 .38 .558 r
.59438 .49152 .59812 .50095 .60072 .49439 .59698 .48499 Mtetra
.512 .338 .581 r
.59698 .48499 .60072 .49439 .60349 .49048 .59974 .4811 Mtetra
.365 .261 .602 r
.59974 .4811 .60349 .49048 .60646 .48945 .60268 .48005 Mtetra
.153 .148 .599 r
.60268 .48005 .60646 .48945 .60961 .49102 .60581 .48158 Mtetra
0 .035 .564 r
.60581 .48158 .60961 .49102 .61291 .49449 .60909 .48499 Mtetra
0 0 .536 r
.60909 .48499 .61291 .49449 .61631 .49882 .61246 .48927 Mtetra
0 .005 .55 r
.61246 .48927 .61631 .49882 .61972 .50281 .61583 .4932 Mtetra
.068 .101 .587 r
.61583 .4932 .61972 .50281 .62304 .5053 .61912 .49563 Mtetra
.287 .219 .604 r
.61912 .49563 .62304 .5053 .62619 .50535 .62225 .49566 Mtetra
.46 .309 .589 r
.62225 .49566 .62619 .50535 .62913 .5025 .62518 .49281 Mtetra
.566 .363 .564 r
.62518 .49281 .62913 .5025 .63185 .4968 .62789 .48714 Mtetra
.622 .39 .544 r
.62789 .48714 .63185 .4968 .63437 .48884 .63041 .47923 Mtetra
.648 .402 .534 r
.63041 .47923 .63437 .48884 .63677 .4796 .63281 .47006 Mtetra
.65 .403 .533 r
.63281 .47006 .63677 .4796 .63914 .47028 .63519 .4608 Mtetra
.63 .394 .541 r
.63519 .4608 .63914 .47028 .64159 .46206 .63764 .45263 Mtetra
.582 .371 .56 r
.63764 .45263 .64159 .46206 .64421 .45591 .64026 .44651 Mtetra
.49 .326 .585 r
.64026 .44651 .64421 .45591 .64708 .45244 .64311 .44305 Mtetra
.336 .248 .606 r
.64311 .44305 .64708 .45244 .65022 .45182 .64623 .4424 Mtetra
.128 .139 .601 r
.64623 .4424 .65022 .45182 .65362 .45372 .6496 .44427 Mtetra
0 .038 .569 r
.6496 .44427 .65362 .45372 .65722 .45743 .65317 .44792 Mtetra
0 0 .549 r
.65317 .44792 .65722 .45743 .66092 .46189 .65684 .45231 Mtetra
0 .026 .564 r
.65684 .45231 .66092 .46189 .66461 .46588 .6605 .45624 Mtetra
.089 .118 .596 r
.6605 .45624 .66461 .46588 .66817 .46827 .66403 .45858 Mtetra
.298 .227 .606 r
.66403 .45858 .66817 .46827 .67149 .46818 .66732 .45846 Mtetra
.463 .31 .588 r
.66732 .45846 .67149 .46818 .67452 .46518 .67033 .45547 Mtetra
.565 .36 .562 r
.67033 .45547 .67452 .46518 .67724 .45938 .67304 .4497 Mtetra
.619 .386 .541 r
.67304 .4497 .67724 .45938 .67971 .45141 .67551 .44178 Mtetra
.643 .396 .53 r
.67551 .44178 .67971 .45141 .68203 .44229 .67784 .43271 Mtetra
.643 .397 .53 r
.67784 .43271 .68203 .44229 .68433 .43319 .68015 .42368 Mtetra
.62 .386 .541 r
.68015 .42368 .68433 .43319 .68676 .4253 .68258 .41584 Mtetra
.567 .361 .562 r
.68258 .41584 .68676 .4253 .68944 .41955 .68525 .41012 Mtetra
.467 .314 .589 r
.68525 .41012 .68944 .41955 .69244 .4165 .68823 .40707 Mtetra
.307 .235 .61 r
.68823 .40707 .69244 .4165 .6958 .41627 .69157 .40682 Mtetra
.106 .132 .604 r
.69157 .40682 .6958 .41627 .69948 .41852 .69523 .40902 Mtetra
0 .044 .576 r
.69523 .40902 .69948 .41852 .70342 .42246 .69913 .4129 Mtetra
0 .012 .561 r
.69913 .4129 .70342 .42246 .70747 .42704 .70314 .4174 Mtetra
0 .046 .577 r
.70314 .4174 .70747 .42704 .71149 .43104 .70712 .42134 Mtetra
.109 .133 .604 r
.70712 .42134 .71149 .43104 .71531 .43334 .71091 .42359 Mtetra
.307 .234 .609 r
.71091 .42359 .71531 .43334 .71881 .4331 .71439 .42333 Mtetra
.465 .311 .587 r
.71439 .42333 .71881 .4331 .72192 .42994 .71748 .42018 Mtetra
.563 .357 .559 r
.71748 .42018 .72192 .42994 .72465 .42403 .7202 .4143 Mtetra
.616 .38 .537 r
.7202 .4143 .72465 .42403 .72707 .41604 .72262 .40636 Mtetra
.638 .39 .527 r
.72262 .40636 .72707 .41604 .72932 .40701 .72488 .39739 Mtetra
.636 .389 .528 r
.72488 .39739 .72932 .40701 .73158 .39813 .72714 .38857 Mtetra
.609 .378 .541 r
.72714 .38857 .73158 .39813 .73401 .39055 .72957 .38104 Mtetra
.55 .351 .564 r
.72957 .38104 .73401 .39055 .73677 .38519 .73232 .37569 Mtetra
.443 .302 .594 r
.73232 .37569 .73677 .38519 .73994 .38255 .73548 .37306 Mtetra
.28 .224 .614 r
.73548 .37306 .73994 .38255 .74357 .38272 .73908 .37319 Mtetra
.088 .128 .608 r
.73908 .37319 .74357 .38272 .7476 .38529 .74307 .37572 Mtetra
0 .052 .584 r
.74307 .37572 .7476 .38529 .75192 .38948 .74736 .37984 Mtetra
0 .029 .574 r
.74736 .37984 .75192 .38948 .75637 .39418 .75176 .38446 Mtetra
0 .065 .59 r
.75176 .38446 .75637 .39418 .76075 .39819 .7561 .38841 Mtetra
.128 .147 .611 r
.7561 .38841 .76075 .39819 .76486 .4004 .76018 .39057 Mtetra
.316 .24 .61 r
.76018 .39057 .76486 .4004 .76856 .40001 .76385 .39015 Mtetra
.466 .311 .585 r
.76385 .39015 .76856 .40001 .77177 .39669 .76704 .38684 Mtetra
.561 .353 .556 r
.76704 .38684 .77177 .39669 .77451 .39066 .76977 .38084 Mtetra
.612 .375 .534 r
.76977 .38084 .77451 .39066 .77688 .38263 .77215 .37287 Mtetra
.632 .383 .523 r
.77215 .37287 .77688 .38263 .77907 .37368 .77434 .36397 Mtetra
.627 .381 .526 r
.77434 .36397 .77907 .37368 .78129 .36499 .77657 .35535 Mtetra
.597 .369 .541 r
.77657 .35535 .78129 .36499 .78375 .35772 .77902 .34811 Mtetra
.532 .341 .567 r
.77902 .34811 .78375 .35772 .78663 .35272 .78189 .34314 Mtetra
.418 .29 .598 r
.78189 .34314 .78663 .35272 .79003 .35049 .78527 .34091 Mtetra
.254 .214 .618 r
.78527 .34091 .79003 .35049 .79398 .35105 .78919 .34143 Mtetra
.074 .126 .613 r
.78919 .34143 .79398 .35105 .79842 .35396 .79359 .34429 Mtetra
0 .062 .593 r
.79359 .34429 .79842 .35396 .80319 .35839 .79832 .34864 Mtetra
0 .047 .587 r
.79832 .34864 .80319 .35839 .80809 .36322 .80317 .3534 Mtetra
0 .084 .601 r
.80317 .3534 .80809 .36322 .81288 .36725 .80791 .35735 Mtetra
.145 .161 .617 r
.80791 .35735 .81288 .36725 .81731 .36937 .81231 .35942 Mtetra
.324 .245 .611 r
.81231 .35942 .81731 .36937 .82123 .36882 .81619 .35885 Mtetra
.579 .386 .584 r
.37545 .75873 .37836 .76799 .38109 .76276 .37817 .75353 Mtetra
.647 .424 .567 r
.37817 .75353 .38109 .76276 .38398 .75464 .38105 .74545 Mtetra
.679 .442 .556 r
.38105 .74545 .38398 .75464 .38697 .74446 .38404 .73533 Mtetra
.691 .449 .551 r
.38404 .73533 .38697 .74446 .38999 .73342 .38706 .72435 Mtetra
.686 .446 .553 r
.38706 .72435 .38999 .73342 .39297 .72283 .39004 .71383 Mtetra
.664 .434 .561 r
.39004 .71383 .39297 .72283 .39584 .71391 .39292 .70496 Mtetra
.614 .406 .577 r
.39292 .70496 .39584 .71391 .39858 .70756 .39565 .69864 Mtetra
.513 .35 .597 r
.39565 .69864 .39858 .70756 .40117 .70424 .39823 .69533 Mtetra
.319 .239 .606 r
.39823 .69533 .40117 .70424 .40361 .70393 .40066 .695 Mtetra
.022 .064 .565 r
.40066 .695 .40361 .70393 .40596 .70608 .40299 .69711 Mtetra
0 0 .487 r
.40299 .69711 .40596 .70608 .40825 .70973 .40526 .70071 Mtetra
0 0 .469 r
.40526 .70071 .40825 .70973 .41055 .71365 .40754 .70459 Mtetra
0 0 .535 r
.40754 .70459 .41055 .71365 .41291 .71656 .40989 .70745 Mtetra
.212 .176 .598 r
.40989 .70745 .41291 .71656 .41538 .71731 .41234 .70818 Mtetra
.45 .313 .602 r
.41234 .70818 .41538 .71731 .41798 .71515 .41493 .70601 Mtetra
.58 .386 .583 r
.41493 .70601 .41798 .71515 .4207 .70986 .41764 .70075 Mtetra
.646 .422 .564 r
.41764 .70075 .4207 .70986 .42352 .7018 .42046 .69274 Mtetra
.677 .439 .553 r
.42046 .69274 .42352 .7018 .42639 .69184 .42333 .68283 Mtetra
.687 .444 .549 r
.42333 .68283 .42639 .69184 .42927 .68115 .42622 .67221 Mtetra
.681 .441 .552 r
.42622 .67221 .42927 .68115 .43212 .67104 .42907 .66215 Mtetra
.655 .427 .561 r
.42907 .66215 .43212 .67104 .4349 .66265 .43184 .65381 Mtetra
.599 .397 .579 r
.43184 .65381 .4349 .66265 .43759 .65684 .43453 .64803 Mtetra
.488 .336 .601 r
.43453 .64803 .43759 .65684 .44019 .65403 .43712 .64521 Mtetra
.281 .219 .608 r
.43712 .64521 .44019 .65403 .44271 .65412 .43962 .64528 Mtetra
0 .05 .564 r
.43962 .64528 .44271 .65412 .44518 .65654 .44208 .64767 Mtetra
0 0 .494 r
.44208 .64767 .44518 .65654 .44764 .66032 .44452 .6514 Mtetra
0 0 .487 r
.44452 .6514 .44764 .66032 .45011 .66425 .44697 .65528 Mtetra
0 .02 .551 r
.44697 .65528 .45011 .66425 .45264 .66706 .44947 .65805 Mtetra
.229 .189 .604 r
.44947 .65805 .45264 .66706 .45522 .66767 .45204 .65863 Mtetra
.455 .317 .603 r
.45204 .65863 .45522 .66767 .45788 .66538 .45469 .65634 Mtetra
.581 .385 .581 r
.45469 .65634 .45788 .66538 .46059 .66003 .45739 .65101 Mtetra
.645 .419 .562 r
.45739 .65101 .46059 .66003 .46334 .65202 .46014 .64305 Mtetra
.675 .435 .55 r
.46014 .64305 .46334 .65202 .46611 .64225 .46291 .63333 Mtetra
.684 .44 .547 r
.46291 .63333 .46611 .64225 .46887 .63189 .46567 .62304 Mtetra
.675 .435 .55 r
.46567 .62304 .46887 .63189 .4716 .62221 .46841 .61342 Mtetra
.646 .42 .562 r
.46841 .61342 .4716 .62221 .4743 .61433 .47111 .60557 Mtetra
.583 .387 .581 r
.47111 .60557 .4743 .61433 .47696 .60904 .47377 .6003 Mtetra
.461 .321 .605 r
.47377 .6003 .47696 .60904 .4796 .6067 .47639 .59796 Mtetra
.243 .201 .61 r
.47639 .59796 .4796 .6067 .48223 .60717 .479 .59841 Mtetra
0 .04 .564 r
.479 .59841 .48223 .60717 .48486 .60985 .48161 .60105 Mtetra
0 0 .504 r
.48161 .60105 .48486 .60985 .4875 .61377 .48423 .60491 Mtetra
0 0 .505 r
.48423 .60491 .4875 .61377 .49017 .6177 .48688 .6088 Mtetra
0 .043 .565 r
.48688 .6088 .49017 .6177 .49286 .62041 .48955 .61147 Mtetra
.246 .202 .609 r
.48955 .61147 .49286 .62041 .49557 .62087 .49225 .6119 Mtetra
.46 .32 .603 r
.49225 .6119 .49557 .62087 .49829 .61845 .49495 .60948 Mtetra
.581 .384 .579 r
.49495 .60948 .49829 .61845 .501 .61303 .49765 .60408 Mtetra
.643 .416 .559 r
.49765 .60408 .501 .61303 .50369 .60506 .50034 .59616 Mtetra
.672 .431 .547 r
.50034 .59616 .50369 .60506 .50635 .59547 .50301 .58662 Mtetra
.68 .435 .544 r
.50301 .58662 .50635 .59547 .509 .58541 .50566 .57663 Mtetra
.669 .429 .549 r
.50566 .57663 .509 .58541 .51164 .57615 .5083 .56741 Mtetra
.635 .412 .562 r
.5083 .56741 .51164 .57615 .51428 .56874 .51094 .56004 Mtetra
.566 .377 .584 r
.51094 .56004 .51428 .56874 .51695 .56394 .5136 .55526 Mtetra
.432 .307 .609 r
.5136 .55526 .51695 .56394 .51965 .56204 .51629 .55336 Mtetra
.206 .184 .611 r
.51629 .55336 .51965 .56204 .52241 .56288 .51903 .55417 Mtetra
0 .034 .565 r
.51903 .55417 .52241 .56288 .52523 .56581 .52183 .55706 Mtetra
0 0 .514 r
.52183 .55706 .52523 .56581 .52808 .56985 .52466 .56104 Mtetra
0 0 .522 r
.52466 .56104 .52808 .56985 .53096 .57378 .52751 .56492 Mtetra
0 .065 .578 r
.52751 .56492 .53096 .57378 .53384 .5764 .53037 .5675 Mtetra
.26 .213 .613 r
.53037 .5675 .53384 .5764 .53668 .57672 .53319 .5678 Mtetra
.465 .323 .603 r
.53319 .5678 .53668 .57672 .53946 .57416 .53596 .56523 Mtetra
.581 .383 .577 r
.53596 .56523 .53946 .57416 .54217 .56866 .53866 .55976 Mtetra
.642 .413 .556 r
.53866 .55976 .54217 .56866 .5448 .56073 .54129 .55187 Mtetra
.669 .426 .544 r
.54129 .55187 .5448 .56073 .54737 .55129 .54387 .54248 Mtetra
.675 .429 .542 r
.54387 .54248 .54737 .55129 .54992 .54152 .54641 .53278 Mtetra
.662 .423 .548 r
.54641 .53278 .54992 .54152 .55247 .53264 .54897 .52395 Mtetra
.624 .404 .563 r
.54897 .52395 .55247 .53264 .55508 .52568 .55158 .51702 Mtetra
.546 .366 .588 r
.55158 .51702 .55508 .52568 .55778 .52134 .55427 .5127 Mtetra
.402 .292 .613 r
.55427 .5127 .55778 .52134 .56059 .51988 .55707 .51123 Mtetra
.172 .169 .612 r
.55707 .51123 .56059 .51988 .56352 .52107 .55997 .51239 Mtetra
0 .031 .568 r
.55997 .51239 .56352 .52107 .56654 .52425 .56298 .51552 Mtetra
0 0 .526 r
.56298 .51552 .56654 .52425 .56964 .5284 .56605 .51962 Mtetra
0 0 .539 r
.56605 .51962 .56964 .5284 .57276 .53233 .56913 .5235 Mtetra
.022 .085 .59 r
.56913 .5235 .57276 .53233 .57583 .53486 .57218 .52598 Mtetra
.274 .223 .617 r
.57218 .52598 .57583 .53486 .57881 .53503 .57515 .52613 Mtetra
.468 .325 .602 r
.57515 .52613 .57881 .53503 .58166 .53233 .57799 .52343 Mtetra
.581 .381 .575 r
.57799 .52343 .58166 .53233 .58437 .52675 .58069 .51787 Mtetra
.639 .409 .553 r
.58069 .51787 .58437 .52675 .58694 .51884 .58326 .51 Mtetra
.666 .422 .541 r
.58326 .51 .58694 .51884 .58943 .50954 .58575 .50076 Mtetra
.67 .424 .539 r
.58575 .50076 .58943 .50954 .59188 .50003 .58821 .49131 Mtetra
.654 .416 .547 r
.58821 .49131 .59188 .50003 .59438 .49152 .5907 .48284 Mtetra
.611 .396 .565 r
.5907 .48284 .59438 .49152 .59698 .48499 .5933 .47635 Mtetra
.525 .354 .592 r
.5933 .47635 .59698 .48499 .59974 .4811 .59605 .47246 Mtetra
.371 .277 .617 r
.59605 .47246 .59974 .4811 .60268 .48005 .59898 .4714 Mtetra
.141 .156 .614 r
.59898 .4714 .60268 .48005 .60581 .48158 .60209 .4729 Mtetra
0 .032 .572 r
.60209 .4729 .60581 .48158 .60909 .48499 .60534 .47626 Mtetra
0 0 .539 r
.60534 .47626 .60909 .48499 .61246 .48927 .60867 .48048 Mtetra
0 0 .555 r
.60867 .48048 .61246 .48927 .61583 .4932 .61202 .48436 Mtetra
.047 .104 .601 r
.61202 .48436 .61583 .4932 .61912 .49563 .61528 .48675 Mtetra
.287 .232 .62 r
.61528 .48675 .61912 .49563 .62225 .49566 .6184 .48675 Mtetra
.472 .326 .601 r
.6184 .48675 .62225 .49566 .62518 .49281 .62131 .48391 Mtetra
.58 .379 .572 r
.62131 .48391 .62518 .49281 .62789 .48714 .62401 .47826 Mtetra
.637 .405 .55 r
.62401 .47826 .62789 .48714 .63041 .47923 .62653 .4704 Mtetra
.662 .416 .538 r
.62653 .4704 .63041 .47923 .63281 .47006 .62894 .46127 Mtetra
.664 .417 .537 r
.62894 .46127 .63281 .47006 .63519 .4608 .63132 .45207 Mtetra
.645 .409 .546 r
.63132 .45207 .63519 .4608 .63764 .45263 .63377 .44395 Mtetra
.597 .387 .567 r
.63377 .44395 .63764 .45263 .64026 .44651 .63639 .43786 Mtetra
.503 .343 .596 r
.63639 .43786 .64026 .44651 .64311 .44305 .63923 .4344 Mtetra
.339 .262 .622 r
.63923 .4344 .64311 .44305 .64623 .4424 .64233 .43374 Mtetra
.113 .145 .616 r
.64233 .43374 .64623 .4424 .6496 .44427 .64568 .43557 Mtetra
0 .036 .578 r
.64568 .43557 .6496 .44427 .65317 .44792 .64921 .43916 Mtetra
0 0 .553 r
.64921 .43916 .65317 .44792 .65684 .45231 .65285 .44349 Mtetra
0 .022 .571 r
.65285 .44349 .65684 .45231 .6605 .45624 .65648 .44737 Mtetra
.07 .122 .61 r
.65648 .44737 .6605 .45624 .66403 .45858 .65998 .44967 Mtetra
.298 .24 .623 r
.65998 .44967 .66403 .45858 .66732 .45846 .66326 .44953 Mtetra
.474 .327 .6 r
.66326 .44953 .66732 .45846 .67033 .45547 .66625 .44653 Mtetra
.579 .376 .57 r
.66625 .44653 .67033 .45547 .67304 .4497 .66896 .44079 Mtetra
.634 .401 .547 r
.66896 .44079 .67304 .4497 .67551 .44178 .67143 .43292 Mtetra
.658 .411 .535 r
.67143 .43292 .67551 .44178 .67784 .43271 .67376 .4239 Mtetra
.67376 .4239 .67784 .43271 .68015 .42368 .67607 .41493 Mtetra
.635 .401 .546 r
.67607 .41493 .68015 .42368 .68258 .41584 .67851 .40713 Mtetra
.581 .377 .57 r
.67851 .40713 .68258 .41584 .68525 .41012 .68117 .40143 Mtetra
.479 .331 .601 r
.68117 .40143 .68525 .41012 .68823 .40707 .68414 .39839 Mtetra
.309 .249 .626 r
.68414 .39839 .68823 .40707 .69157 .40682 .68745 .39812 Mtetra
.089 .138 .619 r
.68745 .39812 .69157 .40682 .69523 .40902 .69108 .40027 Mtetra
0 .042 .585 r
.69108 .40027 .69523 .40902 .69913 .4129 .69495 .4041 Mtetra
0 .007 .567 r
.69495 .4041 .69913 .4129 .70314 .4174 .69893 .40854 Mtetra
0 .044 .586 r
.69893 .40854 .70314 .4174 .70712 .42134 .70287 .41242 Mtetra
.092 .139 .619 r
.70287 .41242 .70712 .42134 .71091 .42359 .70663 .41462 Mtetra
.309 .248 .625 r
.70663 .41462 .71091 .42359 .71439 .42333 .71009 .41434 Mtetra
.476 .327 .599 r
.71009 .41434 .71439 .42333 .71748 .42018 .71317 .41119 Mtetra
.578 .373 .567 r
.71317 .41119 .71748 .42018 .7202 .4143 .71588 .40534 Mtetra
.631 .396 .543 r
.71588 .40534 .7202 .4143 .72262 .40636 .71831 .39744 Mtetra
.653 .405 .531 r
.71831 .39744 .72262 .40636 .72488 .39739 .72057 .38853 Mtetra
.651 .404 .533 r
.72057 .38853 .72488 .39739 .72714 .38857 .72283 .37976 Mtetra
.624 .393 .547 r
.72283 .37976 .72714 .38857 .72957 .38104 .72526 .37227 Mtetra
.564 .368 .573 r
.72526 .37227 .72957 .38104 .73232 .37569 .728 .36695 Mtetra
.454 .319 .607 r
.728 .36695 .73232 .37569 .73548 .37306 .73115 .36431 Mtetra
.279 .237 .63 r
.73115 .36431 .73548 .37306 .73908 .37319 .73472 .36442 Mtetra
.07 .133 .622 r
.73472 .36442 .73908 .37319 .74307 .37572 .73869 .3669 Mtetra
0 .051 .593 r
.73869 .3669 .74307 .37572 .74736 .37984 .74293 .37096 Mtetra
0 .026 .58 r
.74293 .37096 .74736 .37984 .75176 .38446 .7473 .37552 Mtetra
0 .065 .599 r
.7473 .37552 .75176 .38446 .7561 .38841 .7516 .3794 Mtetra
.113 .154 .626 r
.7516 .3794 .7561 .38841 .76018 .39057 .75564 .38152 Mtetra
.318 .254 .626 r
.75564 .38152 .76018 .39057 .76385 .39015 .75929 .38108 Mtetra
.478 .327 .598 r
.75929 .38108 .76385 .39015 .76704 .38684 .76247 .37777 Mtetra
.576 .369 .564 r
.76247 .37777 .76704 .38684 .76977 .38084 .7652 .3718 Mtetra
.627 .39 .539 r
.7652 .3718 .76977 .38084 .77215 .37287 .76757 .36387 Mtetra
.647 .398 .528 r
.76757 .36387 .77215 .37287 .77434 .36397 .76977 .35503 Mtetra
.643 .396 .531 r
.76977 .35503 .77434 .36397 .77657 .35535 .772 .34646 Mtetra
.612 .384 .547 r
.772 .34646 .77657 .35535 .77902 .34811 .77446 .33927 Mtetra
.546 .357 .577 r
.77446 .33927 .77902 .34811 .78189 .34314 .77732 .33431 Mtetra
.428 .307 .612 r
.77732 .33431 .78189 .34314 .78527 .34091 .78068 .33207 Mtetra
.251 .226 .635 r
.78068 .33207 .78527 .34091 .78919 .34143 .78457 .33257 Mtetra
.055 .131 .626 r
.78457 .33257 .78919 .34143 .79359 .34429 .78893 .33537 Mtetra
0 .062 .602 r
.78893 .33537 .79359 .34429 .79832 .34864 .79362 .33966 Mtetra
0 .045 .594 r
.79362 .33966 .79832 .34864 .80317 .3534 .79842 .34434 Mtetra
0 .085 .612 r
.79842 .34434 .80317 .3534 .80791 .35735 .80312 .34823 Mtetra
.133 .169 .633 r
.80312 .34823 .80791 .35735 .81231 .35942 .80748 .35026 Mtetra
.326 .259 .627 r
.80748 .35026 .81231 .35942 .81619 .35885 .81135 .34967 Mtetra
.621 .434 .609 r
.37242 .75151 .37545 .75873 .37817 .75353 .37514 .74632 Mtetra
.685 .465 .582 r
.37514 .74632 .37817 .75353 .38105 .74545 .37803 .73827 Mtetra
.714 .478 .567 r
.37803 .73827 .38105 .74545 .38404 .73533 .38102 .72819 Mtetra
.724 .482 .561 r
.38102 .72819 .38404 .73533 .38706 .72435 .38405 .71726 Mtetra
.72 .481 .563 r
.38405 .71726 .38706 .72435 .39004 .71383 .38703 .70678 Mtetra
.7 .472 .574 r
.38703 .70678 .39004 .71383 .39292 .70496 .38991 .69795 Mtetra
.654 .451 .596 r
.38991 .69795 .39292 .70496 .39565 .69864 .39264 .69165 Mtetra
.553 .402 .631 r
.39264 .69165 .39565 .69864 .39823 .69533 .39521 .68834 Mtetra
.327 .286 .659 r
.39521 .68834 .39823 .69533 .40066 .695 .39763 .688 Mtetra
0 .064 .601 r
.39763 .688 .40066 .695 .40299 .69711 .39995 .69009 Mtetra
0 0 .468 r
.39995 .69009 .40299 .69711 .40526 .70071 .4022 .69365 Mtetra
0 0 .439 r
.4022 .69365 .40526 .70071 .40754 .70459 .40447 .69749 Mtetra
0 0 .549 r
.40447 .69749 .40754 .70459 .40989 .70745 .4068 .70032 Mtetra
.188 .21 .651 r
.4068 .70032 .40989 .70745 .41234 .70818 .40924 .70103 Mtetra
.484 .366 .644 r
.40924 .70103 .41234 .70818 .41493 .70601 .41182 .69886 Mtetra
.622 .434 .607 r
.41182 .69886 .41493 .70601 .41764 .70075 .41453 .69361 Mtetra
.684 .463 .58 r
.41453 .69361 .41764 .70075 .42046 .69274 .41734 .68563 Mtetra
.712 .475 .564 r
.41734 .68563 .42046 .69274 .42333 .68283 .42022 .67577 Mtetra
.721 .479 .559 r
.42022 .67577 .42333 .68283 .42622 .67221 .42311 .66519 Mtetra
.716 .477 .562 r
.42311 .66519 .42622 .67221 .42907 .66215 .42597 .65517 Mtetra
.693 .467 .575 r
.42597 .65517 .42907 .66215 .43184 .65381 .42874 .64686 Mtetra
.64 .443 .6 r
.42874 .64686 .43184 .65381 .43453 .64803 .43142 .6411 Mtetra
.526 .389 .638 r
.43142 .6411 .43453 .64803 .43712 .64521 .43401 .63829 Mtetra
.278 .263 .662 r
.43401 .63829 .43712 .64521 .43962 .64528 .4365 .63834 Mtetra
0 .046 .594 r
.4365 .63834 .43962 .64528 .44208 .64767 .43894 .6407 Mtetra
0 0 .477 r
.43894 .6407 .44208 .64767 .44452 .6514 .44136 .6444 Mtetra
0 0 .464 r
.44136 .6444 .44452 .6514 .44697 .65528 .4438 .64824 Mtetra
0 .007 .571 r
.4438 .64824 .44697 .65528 .44947 .65805 .44628 .65098 Mtetra
.212 .226 .658 r
.44628 .65098 .44947 .65805 .45204 .65863 .44884 .65154 Mtetra
.49 .37 .644 r
.44884 .65154 .45204 .65863 .45469 .65634 .45147 .64924 Mtetra
.623 .434 .605 r
.45147 .64924 .45469 .65634 .45739 .65101 .45418 .64393 Mtetra
.684 .461 .577 r
.45418 .64393 .45739 .65101 .46014 .64305 .45693 .636 Mtetra
.711 .472 .562 r
.45693 .636 .46014 .64305 .46291 .63333 .4597 .62633 Mtetra
.719 .475 .557 r
.4597 .62633 .46291 .63333 .46567 .62304 .46247 .61608 Mtetra
.711 .472 .561 r
.46247 .61608 .46567 .62304 .46841 .61342 .46521 .60649 Mtetra
.685 .461 .577 r
.46521 .60649 .46841 .61342 .47111 .60557 .46791 .59868 Mtetra
.625 .435 .605 r
.46791 .59868 .47111 .60557 .47377 .6003 .47056 .59343 Mtetra
.496 .375 .645 r
.47056 .59343 .47377 .6003 .47639 .59796 .47318 .59108 Mtetra
.229 .24 .664 r
.47318 .59108 .47639 .59796 .479 .59841 .47578 .59151 Mtetra
0 .033 .589 r
.47578 .59151 .479 .59841 .48161 .60105 .47837 .59412 Mtetra
0 0 .488 r
.47837 .59412 .48161 .60105 .48423 .60491 .48097 .59795 Mtetra
0 0 .489 r
.48097 .59795 .48423 .60491 .48688 .6088 .4836 .60179 Mtetra
0 .037 .592 r
.4836 .60179 .48688 .6088 .48955 .61147 .48625 .60443 Mtetra
.233 .241 .663 r
.48625 .60443 .48955 .61147 .49225 .6119 .48893 .60485 Mtetra
.495 .373 .643 r
.48893 .60485 .49225 .6119 .49495 .60948 .49163 .60242 Mtetra
.624 .433 .603 r
.49163 .60242 .49495 .60948 .49765 .60408 .49433 .59704 Mtetra
.683 .458 .574 r
.49433 .59704 .49765 .60408 .50034 .59616 .49702 .58915 Mtetra
.709 .469 .559 r
.49702 .58915 .50034 .59616 .50301 .58662 .49969 .57965 Mtetra
.716 .471 .554 r
.49969 .57965 .50301 .58662 .50566 .57663 .50235 .5697 Mtetra
.706 .468 .561 r
.50235 .5697 .50566 .57663 .5083 .56741 .50499 .56052 Mtetra
.676 .455 .579 r
.50499 .56052 .5083 .56741 .51094 .56004 .50763 .55318 Mtetra
.608 .426 .611 r
.50763 .55318 .51094 .56004 .5136 .55526 .51029 .54841 Mtetra
.463 .36 .652 r
.51029 .54841 .5136 .55526 .51629 .55336 .51297 .5465 Mtetra
.182 .218 .664 r
.51297 .5465 .51629 .55336 .51903 .55417 .5157 .54729 Mtetra
0 .025 .587 r
.5157 .54729 .51903 .55417 .52183 .55706 .51847 .55015 Mtetra
0 0 .502 r
.51847 .55015 .52183 .55706 .52466 .56104 .52128 .5541 Mtetra
0 0 .514 r
.52128 .5541 .52466 .56104 .52751 .56492 .52412 .55794 Mtetra
0 .065 .61 r
.52412 .55794 .52751 .56492 .53037 .5675 .52695 .56048 Mtetra
.252 .254 .667 r
.52695 .56048 .53037 .5675 .53319 .5678 .52976 .56076 Mtetra
.5 .376 .643 r
.52976 .56076 .53319 .5678 .53596 .56523 .53252 .55819 Mtetra
.624 .431 .601 r
.53252 .55819 .53596 .56523 .53866 .55976 .53522 .55274 Mtetra
.682 .455 .572 r
.53522 .55274 .53866 .55976 .54129 .55187 .53785 .54488 Mtetra
.707 .465 .556 r
.53785 .54488 .54129 .55187 .54387 .54248 .54043 .53553 Mtetra
.713 .467 .552 r
.54043 .53553 .54387 .54248 .54641 .53278 .54298 .52587 Mtetra
.7 .463 .56 r
.54298 .52587 .54641 .53278 .54897 .52395 .54555 .51707 Mtetra
.665 .449 .581 r
.54555 .51707 .54897 .52395 .55158 .51702 .54815 .51018 Mtetra
.588 .417 .617 r
.54815 .51018 .55158 .51702 .55427 .5127 .55084 .50586 Mtetra
.427 .344 .66 r
.55084 .50586 .55427 .5127 .55707 .51123 .55362 .50438 Mtetra
.137 .199 .664 r
.55362 .50438 .55707 .51123 .55997 .51239 .55651 .50552 Mtetra
0 .022 .587 r
.55651 .50552 .55997 .51239 .56298 .51552 .5595 .50861 Mtetra
0 0 .517 r
.5595 .50861 .56298 .51552 .56605 .51962 .56254 .51267 Mtetra
0 0 .538 r
.56254 .51267 .56605 .51962 .56913 .5235 .56561 .51651 Mtetra
0 .091 .626 r
.56561 .51651 .56913 .5235 .57218 .52598 .56864 .51896 Mtetra
.27 .266 .671 r
.56864 .51896 .57218 .52598 .57515 .52613 .57159 .51909 Mtetra
.504 .378 .642 r
.57159 .51909 .57515 .52613 .57799 .52343 .57442 .51639 Mtetra
.624 .43 .599 r
.57442 .51639 .57799 .52343 .58069 .51787 .57712 .51085 Mtetra
.681 .452 .569 r
.57712 .51085 .58069 .51787 .58326 .51 .57969 .50301 Mtetra
.705 .461 .553 r
.57969 .50301 .58326 .51 .58575 .50076 .58218 .49381 Mtetra
.709 .463 .55 r
.58218 .49381 .58575 .50076 .58821 .49131 .58465 .4844 Mtetra
.694 .457 .56 r
.58465 .4844 .58821 .49131 .5907 .48284 .58715 .47597 Mtetra
.653 .442 .585 r
.58715 .47597 .5907 .48284 .5933 .47635 .58975 .46949 Mtetra
.566 .407 .624 r
.58975 .46949 .5933 .47635 .59605 .47246 .59249 .46562 Mtetra
.39 .328 .667 r
.59249 .46562 .59605 .47246 .59898 .4714 .59541 .46455 Mtetra
.097 .182 .664 r
.59541 .46455 .59898 .4714 .60209 .4729 .59849 .46602 Mtetra
0 .023 .59 r
.59849 .46602 .60209 .4729 .60534 .47626 .60172 .46934 Mtetra
0 0 .534 r
.60172 .46934 .60534 .47626 .60867 .48048 .60503 .47351 Mtetra
0 0 .561 r
.60503 .47351 .60867 .48048 .61202 .48436 .60835 .47735 Mtetra
0 .116 .64 r
.60835 .47735 .61202 .48436 .61528 .48675 .6116 .47971 Mtetra
.286 .277 .674 r
.6116 .47971 .61528 .48675 .6184 .48675 .6147 .4797 Mtetra
.508 .38 .641 r
.6147 .4797 .6184 .48675 .62131 .48391 .6176 .47685 Mtetra
.624 .428 .596 r
.6176 .47685 .62131 .48391 .62401 .47826 .6203 .47122 Mtetra
.679 .449 .566 r
.6203 .47122 .62401 .47826 .62653 .4704 .62282 .46339 Mtetra
.702 .457 .55 r
.62282 .46339 .62653 .4704 .62894 .46127 .62523 .45431 Mtetra
.704 .458 .549 r
.62523 .45431 .62894 .46127 .63132 .45207 .62762 .44514 Mtetra
.686 .452 .561 r
.62762 .44514 .63132 .45207 .63377 .44395 .63008 .43705 Mtetra
.64 .435 .589 r
.63008 .43705 .63377 .44395 .63639 .43786 .63269 .43098 Mtetra
.542 .396 .632 r
.63269 .43098 .63639 .43786 .63923 .4344 .63553 .42753 Mtetra
.352 .311 .673 r
.63553 .42753 .63923 .4344 .64233 .43374 .63861 .42686 Mtetra
.061 .168 .663 r
.63861 .42686 .64233 .43374 .64568 .43557 .64194 .42866 Mtetra
0 .028 .595 r
.64194 .42866 .64568 .43557 .64921 .43916 .64545 .43221 Mtetra
0 0 .552 r
.64545 .43221 .64921 .43916 .65285 .44349 .64906 .43649 Mtetra
0 .011 .583 r
.64906 .43649 .65285 .44349 .65648 .44737 .65266 .44033 Mtetra
.006 .138 .653 r
.65266 .44033 .65648 .44737 .65998 .44967 .65614 .44259 Mtetra
.3 .286 .676 r
.65614 .44259 .65998 .44967 .66326 .44953 .6594 .44243 Mtetra
.511 .381 .639 r
.6594 .44243 .66326 .44953 .66625 .44653 .66238 .43944 Mtetra
.623 .426 .594 r
.66238 .43944 .66625 .44653 .66896 .44079 .66509 .43372 Mtetra
.677 .445 .562 r
.66509 .43372 .66896 .44079 .67143 .43292 .66756 .42587 Mtetra
.699 .452 .547 r
.66756 .42587 .67143 .43292 .67376 .4239 .6699 .4169 Mtetra
.699 .453 .547 r
.6699 .4169 .67376 .4239 .67607 .41493 .67222 .40796 Mtetra
.678 .445 .562 r
.67222 .40796 .67607 .41493 .67851 .40713 .67465 .4002 Mtetra
.625 .427 .593 r
.67465 .4002 .67851 .40713 .68117 .40143 .67731 .39452 Mtetra
.516 .384 .64 r
.67731 .39452 .68117 .40143 .68414 .39839 .68027 .39148 Mtetra
.313 .295 .679 r
.68027 .39148 .68414 .39839 .68745 .39812 .68357 .39119 Mtetra
.032 .157 .663 r
.68357 .39119 .68745 .39812 .69108 .40027 .68718 .39331 Mtetra
0 .036 .602 r
.68718 .39331 .69108 .40027 .69495 .4041 .69101 .39709 Mtetra
0 0 .571 r
.69101 .39709 .69495 .4041 .69893 .40854 .69496 .40148 Mtetra
0 .038 .603 r
.69496 .40148 .69893 .40854 .70287 .41242 .69888 .40532 Mtetra
.036 .159 .663 r
.69888 .40532 .70287 .41242 .70663 .41462 .70261 .40749 Mtetra
.313 .294 .677 r
.70261 .40749 .70663 .41462 .71009 .41434 .70605 .40718 Mtetra
.514 .381 .638 r
.70605 .40718 .71009 .41434 .71317 .41119 .70912 .40404 Mtetra
.622 .423 .591 r
.70912 .40404 .71317 .41119 .71588 .40534 .71184 .39821 Mtetra
.675 .441 .559 r
.71184 .39821 .71588 .40534 .71831 .39744 .71426 .39034 Mtetra
.696 .447 .544 r
.71426 .39034 .71831 .39744 .72057 .38853 .71653 .38146 Mtetra
.694 .447 .545 r
.71653 .38146 .72057 .38853 .72283 .37976 .7188 .37274 Mtetra
.669 .439 .563 r
.7188 .37274 .72283 .37976 .72526 .37227 .72123 .36528 Mtetra
.608 .418 .599 r
.72123 .36528 .72526 .37227 .728 .36695 .72397 .35997 Mtetra
.487 .372 .648 r
.72397 .35997 .728 .36695 .73115 .36431 .7271 .35733 Mtetra
.275 .28 .684 r
.7271 .35733 .73115 .36431 .73472 .36442 .73066 .35742 Mtetra
.009 .15 .664 r
.73066 .35742 .73472 .36442 .73869 .3669 .7346 .35987 Mtetra
0 .047 .61 r
.7346 .35987 .73869 .3669 .74293 .37096 .73881 .36387 Mtetra
0 .016 .589 r
.73881 .36387 .74293 .37096 .7473 .37552 .74314 .36838 Mtetra
0 .064 .622 r
.74314 .36838 .7473 .37552 .7516 .3794 .74741 .37222 Mtetra
.064 .178 .673 r
.74741 .37222 .7516 .3794 .75564 .38152 .75143 .3743 Mtetra
.325 .301 .678 r
.75143 .3743 .75564 .38152 .75929 .38108 .75506 .37385 Mtetra
.516 .381 .636 r
.75506 .37385 .75929 .38108 .76247 .37777 .75823 .37054 Mtetra
.621 .42 .588 r
.75823 .37054 .76247 .37777 .7652 .3718 .76095 .36459 Mtetra
.672 .436 .555 r
.76095 .36459 .7652 .3718 .76757 .36387 .76333 .3567 Mtetra
.692 .442 .541 r
.76333 .3567 .76757 .36387 .76977 .35503 .76554 .34789 Mtetra
.687 .441 .544 r
.76554 .34789 .76977 .35503 .772 .34646 .76777 .33936 Mtetra
.658 .432 .566 r
.76777 .33936 .772 .34646 .77446 .33927 .77023 .33219 Mtetra
.59 .409 .605 r
.77023 .33219 .77446 .33927 .77732 .33431 .77308 .32725 Mtetra
.457 .36 .656 r
.77308 .32725 .77732 .33431 .78068 .33207 .77643 .32501 Mtetra
.24 .266 .688 r
.77643 .32501 .78068 .33207 .78457 .33257 .7803 .32548 Mtetra
0 .147 .666 r
.7803 .32548 .78457 .33257 .78893 .33537 .78463 .32824 Mtetra
0 .06 .621 r
.78463 .32824 .78893 .33537 .79362 .33966 .78928 .33248 Mtetra
0 .039 .607 r
.78928 .33248 .79362 .33966 .79842 .34434 .79405 .33711 Mtetra
0 .089 .638 r
.79405 .33711 .79842 .34434 .80312 .34823 .79872 .34095 Mtetra
.089 .195 .681 r
.79872 .34095 .80312 .34823 .80748 .35026 .80305 .34294 Mtetra
.335 .307 .679 r
.80305 .34294 .80748 .35026 .81135 .34967 .80689 .34233 Mtetra
.7 .529 .653 r
.36924 .74713 .37242 .75151 .37514 .74632 .37196 .74194 Mtetra
.751 .537 .606 r
.37196 .74194 .37514 .74632 .37803 .73827 .37485 .73391 Mtetra
.771 .539 .583 r
.37485 .73391 .37803 .73827 .38102 .72819 .37785 .72385 Mtetra
.778 .54 .575 r
.37785 .72385 .38102 .72819 .38405 .71726 .38088 .71294 Mtetra
.775 .539 .578 r
.38088 .71294 .38405 .71726 .38703 .70678 .38388 .70248 Mtetra
.762 .539 .595 r
.38388 .70248 .38703 .70678 .38991 .69795 .38676 .69366 Mtetra
.727 .534 .63 r
.38676 .69366 .38991 .69795 .39264 .69165 .38949 .68737 Mtetra
.636 .515 .699 r
.38949 .68737 .39264 .69165 .39521 .68834 .39206 .68407 Mtetra
.342 .411 .788 r
.39206 .68407 .39521 .68834 .39763 .688 .39448 .68372 Mtetra
0 .058 .617 r
.39448 .68372 .39763 .688 .39995 .69009 .39678 .68579 Mtetra
.655 .192 0 r
.39678 .68579 .39995 .69009 .4022 .69365 .39902 .68934 Mtetra
.691 .222 0 r
.39902 .68934 .4022 .69365 .40447 .69749 .40127 .69315 Mtetra
0 0 .482 r
.40127 .69315 .40447 .69749 .4068 .70032 .40359 .69597 Mtetra
.11 .301 .776 r
.40359 .69597 .4068 .70032 .40924 .70103 .40602 .69666 Mtetra
.56 .492 .736 r
.40602 .69666 .40924 .70103 .41182 .69886 .40859 .69449 Mtetra
.702 .529 .651 r
.40859 .69449 .41182 .69886 .41453 .69361 .4113 .68925 Mtetra
.752 .536 .604 r
.4113 .68925 .41453 .69361 .41734 .68563 .41413 .68128 Mtetra
.772 .538 .581 r
.41413 .68128 .41734 .68563 .42022 .67577 .41701 .67143 Mtetra
.778 .538 .573 r
.41701 .67143 .42022 .67577 .42311 .66519 .41991 .66088 Mtetra
.774 .538 .578 r
.41991 .66088 .42311 .66519 .42597 .65517 .42278 .65088 Mtetra
.758 .537 .597 r
.42278 .65088 .42597 .65517 .42874 .64686 .42556 .64259 Mtetra
.717 .532 .639 r
.42556 .64259 .42874 .64686 .43142 .6411 .42824 .63683 Mtetra
.607 .508 .715 r
.42824 .63683 .43142 .6411 .43401 .63829 .43082 .63402 Mtetra
.263 .378 .792 r
.43082 .63402 .43401 .63829 .4365 .63834 .43331 .63406 Mtetra
0 .03 .589 r
.43331 .63406 .4365 .63834 .43894 .6407 .43573 .6364 Mtetra
.642 .178 0 r
.43573 .6364 .43894 .6407 .44136 .6444 .43814 .64008 Mtetra
.658 .192 0 r
.43814 .64008 .44136 .6444 .4438 .64824 .44056 .6439 Mtetra
0 0 .53 r
.44056 .6439 .4438 .64824 .44628 .65098 .44303 .64662 Mtetra
.152 .324 .784 r
.44303 .64662 .44628 .65098 .44884 .65154 .44558 .64717 Mtetra
.567 .495 .734 r
.44558 .64717 .44884 .65154 .45147 .64924 .44821 .64487 Mtetra
.703 .529 .649 r
.44821 .64487 .45147 .64924 .45418 .64393 .45091 .63957 Mtetra
.752 .535 .602 r
.45091 .63957 .45418 .64393 .45693 .636 .45367 .63165 Mtetra
.772 .537 .579 r
.45367 .63165 .45693 .636 .4597 .62633 .45645 .62199 Mtetra
.777 .537 .572 r
.45645 .62199 .4597 .62633 .46247 .61608 .45923 .61176 Mtetra
.772 .537 .578 r
.45923 .61176 .46247 .61608 .46521 .60649 .46198 .6022 Mtetra
.753 .536 .601 r
.46198 .6022 .46521 .60649 .46791 .59868 .46468 .5944 Mtetra
.705 .53 .649 r
.46468 .5944 .46791 .59868 .47056 .59343 .46733 .58915 Mtetra
.572 .498 .733 r
.46733 .58915 .47056 .59343 .47318 .59108 .46995 .5868 Mtetra
.183 .342 .79 r
.46995 .5868 .47318 .59108 .47578 .59151 .47254 .58722 Mtetra
0 .011 .569 r
.47254 .58722 .47578 .59151 .47837 .59412 .47511 .58982 Mtetra
.625 .161 0 r
.47511 .58982 .47837 .59412 .48097 .59795 .4777 .59362 Mtetra
.623 .159 0 r
.4777 .59362 .48097 .59795 .4836 .60179 .48031 .59744 Mtetra
0 .017 .574 r
.48031 .59744 .4836 .60179 .48625 .60443 .48295 .60007 Mtetra
.189 .344 .79 r
.48295 .60007 .48625 .60443 .48893 .60485 .48562 .60047 Mtetra
.573 .497 .731 r
.48562 .60047 .48893 .60485 .49163 .60242 .48831 .59804 Mtetra
.705 .528 .647 r
.48831 .59804 .49163 .60242 .49433 .59704 .49101 .59266 Mtetra
.753 .534 .599 r
.49101 .59266 .49433 .59704 .49702 .58915 .49371 .58479 Mtetra
.772 .535 .576 r
.49371 .58479 .49702 .58915 .49969 .57965 .49639 .57531 Mtetra
.777 .535 .57 r
.49639 .57531 .49969 .57965 .50235 .5697 .49905 .56538 Mtetra
.77 .535 .579 r
.49905 .56538 .50235 .5697 .50499 .56052 .5017 .55622 Mtetra
.747 .534 .606 r
.5017 .55622 .50499 .56052 .50763 .55318 .50435 .54889 Mtetra
.69 .526 .66 r
.50435 .54889 .50763 .55318 .51029 .54841 .50701 .54412 Mtetra
.532 .486 .75 r
.50701 .54412 .51029 .54841 .51297 .5465 .50969 .54221 Mtetra
.104 .306 .781 r
.50969 .54221 .51297 .5465 .5157 .54729 .5124 .54299 Mtetra
0 .001 .556 r
.5124 .54299 .5157 .54729 .51847 .55015 .51516 .54583 Mtetra
.603 .14 0 r
.51516 .54583 .51847 .55015 .52128 .5541 .51796 .54975 Mtetra
.583 .124 0 r
.51796 .54975 .52128 .5541 .52412 .55794 .52077 .55357 Mtetra
0 .058 .614 r
.52077 .55357 .52412 .55794 .52695 .56048 .5236 .5561 Mtetra
.221 .361 .794 r
.5236 .5561 .52695 .56048 .52976 .56076 .5264 .55636 Mtetra
.579 .499 .729 r
.5264 .55636 .52976 .56076 .53252 .55819 .52915 .55379 Mtetra
.706 .528 .645 r
.52915 .55379 .53252 .55819 .53522 .55274 .53185 .54835 Mtetra
.754 .533 .597 r
.53185 .54835 .53522 .55274 .53785 .54488 .53449 .5405 Mtetra
.773 .534 .573 r
.53449 .5405 .53785 .54488 .54043 .53553 .53707 .53117 Mtetra
.776 .534 .568 r
.53707 .53117 .54043 .53553 .54298 .52587 .53964 .52152 Mtetra
.768 .534 .58 r
.53964 .52152 .54298 .52587 .54555 .51707 .54221 .51275 Mtetra
.741 .532 .612 r
.54221 .51275 .54555 .51707 .54815 .51018 .54482 .50586 Mtetra
.672 .522 .673 r
.54482 .50586 .54815 .51018 .55084 .50586 .5475 .50155 Mtetra
.485 .471 .766 r
.5475 .50155 .55084 .50586 .55362 .50438 .55028 .50006 Mtetra
.033 .271 .768 r
.55028 .50006 .55362 .50438 .55651 .50552 .55316 .50119 Mtetra
0 0 .551 r
.55316 .50119 .55651 .50552 .5595 .50861 .55612 .50426 Mtetra
.578 .118 0 r
.55612 .50426 .5595 .50861 .56254 .51267 .55915 .5083 Mtetra
0 0 .451 r
.55915 .5083 .56254 .51267 .56561 .51651 .5622 .51211 Mtetra
0 .098 .649 r
.5622 .51211 .56561 .51651 .56864 .51896 .56522 .51455 Mtetra
.25 .376 .796 r
.56522 .51455 .56864 .51896 .57159 .51909 .56816 .51467 Mtetra
.583 .5 .727 r
.56816 .51467 .57159 .51909 .57442 .51639 .57098 .51196 Mtetra
.707 .527 .643 r
.57098 .51196 .57442 .51639 .57712 .51085 .57368 .50643 Mtetra
.754 .532 .594 r
.57368 .50643 .57712 .51085 .57969 .50301 .57626 .4986 Mtetra
.773 .532 .571 r
.57626 .4986 .57969 .50301 .58218 .49381 .57876 .48941 Mtetra
.775 .532 .567 r
.57876 .48941 .58218 .49381 .58465 .4844 .58123 .48003 Mtetra
.765 .532 .581 r
.58123 .48003 .58465 .4844 .58715 .47597 .58374 .47161 Mtetra
.732 .53 .619 r
.58374 .47161 .58715 .47597 .58975 .46949 .58634 .46515 Mtetra
.651 .518 .688 r
.58634 .46515 .58975 .46949 .59249 .46562 .58908 .46127 Mtetra
.433 .453 .781 r
.58908 .46127 .59249 .46562 .59541 .46455 .59199 .46019 Mtetra
0 .24 .753 r
.59199 .46019 .59541 .46455 .59849 .46602 .59507 .46165 Mtetra
0 0 .552 r
.59507 .46165 .59849 .46602 .60172 .46934 .59828 .46495 Mtetra
0 0 .444 r
.59828 .46495 .60172 .46934 .60503 .47351 .60157 .4691 Mtetra
0 0 .493 r
.60157 .4691 .60503 .47351 .60835 .47735 .60487 .47291 Mtetra
0 .134 .68 r
.60487 .47291 .60835 .47735 .6116 .47971 .6081 .47525 Mtetra
.276 .389 .798 r
.6081 .47525 .6116 .47971 .6147 .4797 .61119 .47523 Mtetra
.588 .502 .724 r
.61119 .47523 .6147 .4797 .6176 .47685 .61409 .47238 Mtetra
.708 .526 .64 r
.61409 .47238 .6176 .47685 .6203 .47122 .61679 .46676 Mtetra
.755 .53 .591 r
.61679 .46676 .6203 .47122 .62282 .46339 .61932 .45894 Mtetra
.773 .53 .568 r
.61932 .45894 .62282 .46339 .62523 .45431 .62174 .44988 Mtetra
.774 .53 .566 r
.62174 .44988 .62523 .45431 .62762 .44514 .62413 .44073 Mtetra
.761 .53 .584 r
.62413 .44073 .62762 .44514 .63008 .43705 .6266 .43266 Mtetra
.723 .528 .627 r
.6266 .43266 .63008 .43705 .63269 .43098 .62921 .4266 Mtetra
.626 .512 .704 r
.62921 .4266 .63269 .43098 .63553 .42753 .63204 .42314 Mtetra
.376 .432 .792 r
.63204 .42314 .63553 .42753 .63861 .42686 .63512 .42246 Mtetra
0 .215 .739 r
.63512 .42246 .63861 .42686 .64194 .42866 .63843 .42424 Mtetra
0 .007 .558 r
.63843 .42424 .64194 .42866 .64545 .43221 .64192 .42777 Mtetra
0 0 .475 r
.64192 .42777 .64545 .43221 .64906 .43649 .64551 .43203 Mtetra
0 0 .533 r
.64551 .43203 .64906 .43649 .65266 .44033 .64909 .43584 Mtetra
0 .168 .706 r
.64909 .43584 .65266 .44033 .65614 .44259 .65256 .43808 Mtetra
.298 .4 .799 r
.65256 .43808 .65614 .44259 .6594 .44243 .65581 .43791 Mtetra
.592 .502 .722 r
.65581 .43791 .6594 .44243 .66238 .43944 .65879 .43492 Mtetra
.709 .525 .638 r
.65879 .43492 .66238 .43944 .66509 .43372 .66149 .4292 Mtetra
.755 .528 .588 r
.66149 .4292 .66509 .43372 .66756 .42587 .66397 .42137 Mtetra
.772 .528 .566 r
.66397 .42137 .66756 .42587 .6699 .4169 .66632 .41242 Mtetra
.773 .528 .565 r
.66632 .41242 .6699 .4169 .67222 .40796 .66865 .4035 Mtetra
.756 .528 .587 r
.66865 .4035 .67222 .40796 .67465 .4002 .67109 .39575 Mtetra
.711 .526 .637 r
.67109 .39575 .67465 .4002 .67731 .39452 .67375 .39007 Mtetra
.596 .504 .721 r
.67375 .39007 .67731 .39452 .68027 .39148 .67671 .38703 Mtetra
.317 .41 .799 r
.67671 .38703 .68027 .39148 .68357 .39119 .67999 .38673 Mtetra
0 .196 .726 r
.67999 .38673 .68357 .39119 .68718 .39331 .68358 .38883 Mtetra
0 .018 .568 r
.68358 .38883 .68718 .39331 .69101 .39709 .6874 .39259 Mtetra
0 0 .507 r
.6874 .39259 .69101 .39709 .69496 .40148 .69132 .39696 Mtetra
0 .021 .571 r
.69132 .39696 .69496 .40148 .69888 .40532 .69522 .40076 Mtetra
0 .199 .728 r
.69522 .40076 .69888 .40532 .70261 .40749 .69894 .40292 Mtetra
.318 .409 .799 r
.69894 .40292 .70261 .40749 .70605 .40718 .70236 .4026 Mtetra
.595 .503 .72 r
.70236 .4026 .70605 .40718 .70912 .40404 .70543 .39945 Mtetra
.71 .524 .635 r
.70543 .39945 .70912 .40404 .71184 .39821 .70814 .39363 Mtetra
.756 .526 .585 r
.70814 .39363 .71184 .39821 .71426 .39034 .71058 .38578 Mtetra
.772 .526 .563 r
.71058 .38578 .71426 .39034 .71653 .38146 .71285 .37692 Mtetra
.771 .526 .565 r
.71285 .37692 .71653 .38146 .7188 .37274 .71513 .36821 Mtetra
.75 .526 .591 r
.71513 .36821 .7188 .37274 .72123 .36528 .71757 .36076 Mtetra
.696 .523 .648 r
.71757 .36076 .72123 .36528 .72397 .35997 .72031 .35546 Mtetra
.562 .495 .738 r
.72031 .35546 .72397 .35997 .7271 .35733 .72343 .35282 Mtetra
.259 .387 .803 r
.72343 .35282 .7271 .35733 .73066 .35742 .72698 .3529 Mtetra
0 .183 .717 r
.72698 .3529 .73066 .35742 .7346 .35987 .7309 .35532 Mtetra
0 .033 .582 r
.7309 .35532 .7346 .35987 .73881 .36387 .73509 .3593 Mtetra
0 0 .539 r
.73509 .3593 .73881 .36387 .74314 .36838 .7394 .36378 Mtetra
0 .056 .606 r
.7394 .36378 .74314 .36838 .74741 .37222 .74364 .36759 Mtetra
0 .226 .746 r
.74364 .36759 .74741 .37222 .75143 .3743 .74764 .36965 Mtetra
.335 .417 .798 r
.74764 .36965 .75143 .3743 .75506 .37385 .75126 .36918 Mtetra
.598 .503 .718 r
.75126 .36918 .75506 .37385 .75823 .37054 .75442 .36587 Mtetra
.711 .522 .633 r
.75442 .36587 .75823 .37054 .76095 .36459 .75715 .35993 Mtetra
.756 .524 .582 r
.75715 .35993 .76095 .36459 .76333 .3567 .75954 .35205 Mtetra
.771 .524 .56 r
.75954 .35205 .76333 .3567 .76554 .34789 .76175 .34327 Mtetra
.768 .524 .565 r
.76175 .34327 .76554 .34789 .76777 .33936 .76399 .33475 Mtetra
.744 .524 .597 r
.76399 .33475 .76777 .33936 .77023 .33219 .76646 .3276 Mtetra
.679 .519 .662 r
.76646 .3276 .77023 .33219 .77308 .32725 .76931 .32266 Mtetra
.523 .484 .755 r
.76931 .32266 .77308 .32725 .77643 .32501 .77265 .32041 Mtetra
.204 .364 .802 r
.77265 .32041 .77643 .32501 .7803 .32548 .77651 .32087 Mtetra
0 .175 .711 r
.77651 .32087 .7803 .32548 .78463 .32824 .78082 .32361 Mtetra
0 .05 .598 r
.78082 .32361 .78463 .32824 .78928 .33248 .78544 .32782 Mtetra
0 .023 .57 r
.78544 .32782 .78928 .33248 .79405 .33711 .79019 .33242 Mtetra
0 .09 .638 r
.79019 .33242 .79405 .33711 .79872 .34095 .79483 .33623 Mtetra
0 .251 .761 r
.79483 .33623 .79872 .34095 .80305 .34294 .79914 .3382 Mtetra
.35 .424 .797 r
.79914 .3382 .80305 .34294 .80689 .34233 .80297 .33757 Mtetra
.826 .69 .715 r
.36585 .74593 .36924 .74713 .37196 .74194 .36857 .74074 Mtetra
.843 .645 .634 r
.36857 .74074 .37196 .74194 .37485 .73391 .37147 .7327 Mtetra
.848 .625 .6 r
.37147 .7327 .37485 .73391 .37785 .72385 .37448 .72263 Mtetra
.849 .618 .589 r
.37448 .72263 .37785 .72385 .38088 .71294 .37753 .71172 Mtetra
.848 .621 .593 r
.37753 .71172 .38088 .71294 .38388 .70248 .38054 .70125 Mtetra
.846 .634 .616 r
.38054 .70125 .38388 .70248 .38676 .69366 .38344 .69242 Mtetra
.836 .666 .672 r
.38344 .69242 .38676 .69366 .38949 .68737 .38618 .68613 Mtetra
.783 .736 .809 r
.38618 .68613 .38949 .68737 .39206 .68407 .38875 .68282 Mtetra
.294 .693 .975 r
.38875 .68282 .39206 .68407 .39448 .68372 .39116 .68247 Mtetra
.564 0 0 r
.39116 .68247 .39448 .68372 .39678 .68579 .39345 .68453 Mtetra
.713 .19 0 r
.39345 .68453 .39678 .68579 .39902 .68934 .39569 .68808 Mtetra
.726 .211 0 r
.39569 .68808 .39902 .68934 .40127 .69315 .39792 .6919 Mtetra
.654 .101 0 r
.39792 .6919 .40127 .69315 .40359 .69597 .40023 .69471 Mtetra
0 .408 .734 r
.40023 .69471 .40359 .69597 .40602 .69666 .40266 .6954 Mtetra
.705 .774 .906 r
.40266 .6954 .40602 .69666 .40859 .69449 .40523 .69323 Mtetra
.828 .69 .712 r
.40523 .69323 .40859 .69449 .4113 .68925 .40795 .68798 Mtetra
.846 .646 .632 r
.40795 .68798 .4113 .68925 .41413 .68128 .41078 .68001 Mtetra
.851 .627 .598 r
.41078 .68001 .41413 .68128 .41701 .67143 .41368 .67015 Mtetra
.852 .62 .587 r
.41368 .67015 .41701 .67143 .41991 .66088 .41659 .65959 Mtetra
.851 .624 .594 r
.41659 .65959 .41991 .66088 .42278 .65088 .41947 .64959 Mtetra
.848 .64 .622 r
.41947 .64959 .42278 .65088 .42556 .64259 .42226 .64129 Mtetra
.834 .677 .688 r
.42226 .64129 .42556 .64259 .42824 .63683 .42495 .63553 Mtetra
.756 .751 .848 r
.42495 .63553 .42824 .63683 .43082 .63402 .42753 .63271 Mtetra
.128 .603 .919 r
.42753 .63271 .43082 .63402 .43331 .63406 .43001 .63275 Mtetra
.586 .011 0 r
.43001 .63275 .43331 .63406 .43573 .6364 .43243 .63509 Mtetra
.709 .181 0 r
.43243 .63509 .43573 .6364 .43814 .64008 .43482 .63877 Mtetra
.715 .191 0 r
.43482 .63877 .43814 .64008 .44056 .6439 .43723 .64259 Mtetra
.627 .063 0 r
.43723 .64259 .44056 .6439 .44303 .64662 .4397 .6453 Mtetra
0 .463 .796 r
.4397 .6453 .44303 .64662 .44558 .64717 .44224 .64585 Mtetra
.713 .77 .897 r
.44224 .64585 .44558 .64717 .44821 .64487 .44487 .64355 Mtetra
.83 .691 .709 r
.44487 .64355 .44821 .64487 .45091 .63957 .44758 .63824 Mtetra
.849 .647 .629 r
.44758 .63824 .45091 .63957 .45367 .63165 .45034 .63032 Mtetra
.854 .628 .595 r
.45034 .63032 .45367 .63165 .45645 .62199 .45314 .62065 Mtetra
.855 .623 .586 r
.45314 .62065 .45645 .62199 .45923 .61176 .45593 .61042 Mtetra
.854 .628 .595 r
.45593 .61042 .45923 .61176 .46198 .6022 .45869 .60084 Mtetra
.849 .647 .628 r
.45869 .60084 .46198 .6022 .46468 .5944 .4614 .59304 Mtetra
.83 .689 .707 r
.4614 .59304 .46468 .5944 .46733 .58915 .46406 .58779 Mtetra
.717 .764 .89 r
.46406 .58779 .46733 .58915 .46995 .5868 .46668 .58543 Mtetra
0 .503 .842 r
.46668 .58543 .46995 .5868 .47254 .58722 .46926 .58585 Mtetra
.599 .027 0 r
.46926 .58585 .47254 .58722 .47511 .58982 .47183 .58844 Mtetra
.703 .169 0 r
.47183 .58844 .47511 .58982 .4777 .59362 .4744 .59224 Mtetra
.702 .167 0 r
.4744 .59224 .4777 .59362 .48031 .59744 .477 .59606 Mtetra
.595 .022 0 r
.477 .59606 .48031 .59744 .48295 .60007 .47963 .59869 Mtetra
0 .51 .847 r
.47963 .59869 .48295 .60007 .48562 .60047 .4823 .59909 Mtetra
.72 .767 .89 r
.4823 .59909 .48562 .60047 .48831 .59804 .48499 .59665 Mtetra
.833 .691 .707 r
.48499 .59665 .48831 .59804 .49101 .59266 .48769 .59127 Mtetra
.853 .649 .627 r
.48769 .59127 .49101 .59266 .49371 .58479 .4904 .58339 Mtetra
.858 .63 .593 r
.4904 .58339 .49371 .58479 .49639 .57531 .49309 .5739 Mtetra
.859 .625 .584 r
.49309 .5739 .49639 .57531 .49905 .56538 .49577 .56397 Mtetra
.857 .632 .597 r
.49577 .56397 .49905 .56538 .5017 .55622 .49843 .5548 Mtetra
.851 .654 .637 r
.49843 .5548 .5017 .55622 .50435 .54889 .50109 .54747 Mtetra
.824 .702 .73 r
.50109 .54747 .50435 .54889 .50701 .54412 .50375 .54269 Mtetra
.66 .769 .93 r
.50375 .54269 .50701 .54412 .50969 .54221 .50643 .54078 Mtetra
0 .411 .763 r
.50643 .54078 .50969 .54221 .5124 .54299 .50914 .54156 Mtetra
.606 .036 0 r
.50914 .54156 .5124 .54299 .51516 .54583 .51189 .54439 Mtetra
.694 .153 0 r
.51189 .54439 .51516 .54583 .51796 .54975 .51467 .54831 Mtetra
.685 .141 0 r
.51467 .54831 .51796 .54975 .52077 .55357 .51748 .55213 Mtetra
.559 0 0 r
.51748 .55213 .52077 .55357 .5236 .5561 .52029 .55466 Mtetra
.055 .55 .886 r
.52029 .55466 .5236 .5561 .5264 .55636 .52308 .55492 Mtetra
.726 .765 .883 r
.52308 .55492 .5264 .55636 .52915 .55379 .52584 .55234 Mtetra
.836 .693 .704 r
.52584 .55234 .52915 .55379 .53185 .54835 .52854 .54689 Mtetra
.856 .651 .624 r
.52854 .54689 .53185 .54835 .53449 .5405 .53119 .53904 Mtetra
.861 .632 .59 r
.53119 .53904 .53449 .5405 .53707 .53117 .53379 .52971 Mtetra
.862 .628 .583 r
.53379 .52971 .53707 .53117 .53964 .52152 .53636 .52005 Mtetra
.86 .637 .599 r
.53636 .52005 .53964 .52152 .54221 .51275 .53895 .51127 Mtetra
.851 .663 .647 r
.53895 .51127 .54221 .51275 .54482 .50586 .54157 .50438 Mtetra
.814 .716 .757 r
.54157 .50438 .54482 .50586 .5475 .50155 .54425 .50006 Mtetra
.584 .763 .964 r
.54425 .50006 .5475 .50155 .55028 .50006 .54703 .49857 Mtetra
0 .334 .695 r
.54703 .49857 .55028 .50006 .55316 .50119 .5499 .49969 Mtetra
.607 .038 0 r
.5499 .49969 .55316 .50119 .55612 .50426 .55286 .50276 Mtetra
.682 .135 0 r
.55286 .50276 .55612 .50426 .55915 .5083 .55587 .5068 Mtetra
.665 .112 0 r
.55587 .5068 .55915 .5083 .5622 .51211 .55891 .51061 Mtetra
.518 0 0 r
.55891 .51061 .5622 .51211 .56522 .51455 .56191 .51304 Mtetra
.116 .583 .917 r
.56191 .51304 .56522 .51455 .56816 .51467 .56485 .51316 Mtetra
.732 .763 .878 r
.56485 .51316 .56816 .51467 .57098 .51196 .56767 .51044 Mtetra
.84 .694 .702 r
.56767 .51044 .57098 .51196 .57368 .50643 .57038 .50491 Mtetra
.86 .653 .621 r
.57038 .50491 .57368 .50643 .57626 .4986 .57297 .49708 Mtetra
.865 .635 .587 r
.57297 .49708 .57626 .4986 .57876 .48941 .57548 .48788 Mtetra
.866 .632 .582 r
.57548 .48788 .57876 .48941 .58123 .48003 .57797 .47849 Mtetra
.863 .643 .603 r
.57797 .47849 .58123 .48003 .58374 .47161 .58049 .47007 Mtetra
.851 .673 .66 r
.58049 .47007 .58374 .47161 .58634 .46515 .58309 .4636 Mtetra
.799 .731 .788 r
.58309 .4636 .58634 .46515 .58908 .46127 .58584 .45972 Mtetra
.487 .741 .984 r
.58584 .45972 .58908 .46127 .59199 .46019 .58874 .45864 Mtetra
0 .275 .642 r
.58874 .45864 .59199 .46019 .59507 .46165 .59181 .46009 Mtetra
.604 .034 0 r
.59181 .46009 .59507 .46165 .59828 .46495 .59501 .46339 Mtetra
.667 .114 0 r
.59501 .46339 .59828 .46495 .60157 .4691 .59829 .46753 Mtetra
.641 .081 0 r
.59829 .46753 .60157 .4691 .60487 .47291 .60158 .47134 Mtetra
.472 0 0 r
.60158 .47134 .60487 .47291 .6081 .47525 .6048 .47368 Mtetra
.171 .61 .939 r
.6048 .47368 .6081 .47525 .61119 .47523 .60788 .47365 Mtetra
.737 .762 .873 r
.60788 .47365 .61119 .47523 .61409 .47238 .61078 .4708 Mtetra
.843 .696 .699 r
.61078 .4708 .61409 .47238 .61679 .46676 .61349 .46517 Mtetra
.864 .655 .618 r
.61349 .46517 .61679 .46676 .61932 .45894 .61603 .45735 Mtetra
.87 .638 .585 r
.61603 .45735 .61932 .45894 .62174 .44988 .61846 .44828 Mtetra
.87 .636 .582 r
.61846 .44828 .62174 .44988 .62413 .44073 .62087 .43913 Mtetra
.866 .65 .607 r
.62087 .43913 .62413 .44073 .6266 .43266 .62334 .43105 Mtetra
.85 .684 .676 r
.62334 .43105 .6266 .43266 .62921 .4266 .62596 .42498 Mtetra
.777 .745 .824 r
.62596 .42498 .62921 .4266 .63204 .42314 .6288 .42153 Mtetra
.376 .7 .984 r
.6288 .42153 .63204 .42314 .63512 .42246 .63187 .42084 Mtetra
.346 0 0 r
.63187 .42084 .63512 .42246 .63843 .42424 .63517 .42261 Mtetra
.596 .026 0 r
.63517 .42261 .63843 .42424 .64192 .42777 .63865 .42614 Mtetra
.649 .091 0 r
.63865 .42614 .64192 .42777 .64551 .43203 .64223 .43039 Mtetra
.613 .047 0 r
.64223 .43039 .64551 .43203 .64909 .43584 .6458 .4342 Mtetra
.423 0 0 r
.6458 .4342 .64909 .43584 .65256 .43808 .64925 .43644 Mtetra
.219 .631 .954 r
.64925 .43644 .65256 .43808 .65581 .43791 .6525 .43627 Mtetra
.743 .762 .868 r
.6525 .43627 .65581 .43791 .65879 .43492 .65548 .43327 Mtetra
.847 .698 .697 r
.65548 .43327 .65879 .43492 .66149 .4292 .65819 .42754 Mtetra
.869 .658 .615 r
.65819 .42754 .66149 .4292 .66397 .42137 .66068 .41971 Mtetra
.874 .641 .582 r
.66068 .41971 .66397 .42137 .66632 .41242 .66303 .41075 Mtetra
.66303 .41075 .66632 .41242 .66865 .4035 .66538 .40182 Mtetra
.869 .657 .614 r
.66538 .40182 .66865 .4035 .67109 .39575 .66783 .39407 Mtetra
.847 .696 .695 r
.66783 .39407 .67109 .39575 .67375 .39007 .67049 .38839 Mtetra
.745 .757 .862 r
.67049 .38839 .67375 .39007 .67671 .38703 .67345 .38534 Mtetra
.261 .646 .965 r
.67345 .38534 .67671 .38703 .67999 .38673 .67673 .38504 Mtetra
.375 0 0 r
.67673 .38504 .67999 .38673 .68358 .38883 .68031 .38713 Mtetra
.584 .013 0 r
.68031 .38713 .68358 .38883 .6874 .39259 .68412 .39088 Mtetra
.627 .064 0 r
.68412 .39088 .6874 .39259 .69132 .39696 .68803 .39525 Mtetra
.582 .01 0 r
.68803 .39525 .69132 .39696 .69522 .40076 .69191 .39905 Mtetra
.37 0 0 r
.69191 .39905 .69522 .40076 .69894 .40292 .69562 .4012 Mtetra
.26 .648 .965 r
.69562 .4012 .69894 .40292 .70236 .4026 .69904 .40088 Mtetra
.748 .762 .864 r
.69904 .40088 .70236 .4026 .70543 .39945 .70211 .39772 Mtetra
.852 .701 .695 r
.70211 .39772 .70543 .39945 .70814 .39363 .70483 .3919 Mtetra
.874 .661 .611 r
.70483 .3919 .70814 .39363 .71058 .38578 .70727 .38404 Mtetra
.879 .644 .579 r
.70727 .38404 .71058 .38578 .71285 .37692 .70956 .37518 Mtetra
.879 .646 .582 r
.70956 .37518 .71285 .37692 .71513 .36821 .71185 .36646 Mtetra
.872 .666 .622 r
.71185 .36646 .71513 .36821 .71757 .36076 .7143 .35901 Mtetra
.842 .71 .718 r
.7143 .35901 .71757 .36076 .72031 .35546 .71705 .35371 Mtetra
.702 .764 .9 r
.71705 .35371 .72031 .35546 .72343 .35282 .72017 .35106 Mtetra
.152 .585 .932 r
.72017 .35106 .72343 .35282 .72698 .3529 .72371 .35113 Mtetra
.391 0 0 r
.72371 .35113 .72698 .3529 .7309 .35532 .72762 .35355 Mtetra
.568 0 0 r
.72762 .35355 .7309 .35532 .73509 .3593 .7318 .35752 Mtetra
.602 .035 0 r
.7318 .35752 .73509 .3593 .7394 .36378 .73609 .362 Mtetra
.546 0 0 r
.73609 .362 .7394 .36378 .74364 .36759 .74033 .3658 Mtetra
0 .251 .639 r
.74033 .3658 .74364 .36759 .74764 .36965 .74432 .36786 Mtetra
.296 .662 .972 r
.74432 .36786 .74764 .36965 .75126 .36918 .74793 .36738 Mtetra
.753 .763 .861 r
.74793 .36738 .75126 .36918 .75442 .36587 .75109 .36407 Mtetra
.857 .704 .692 r
.75109 .36407 .75442 .36587 .75715 .35993 .75383 .35812 Mtetra
.879 .665 .608 r
.75383 .35812 .75715 .35993 .75954 .35205 .75622 .35024 Mtetra
.885 .649 .576 r
.75622 .35024 .75954 .35205 .76175 .34327 .75845 .34145 Mtetra
.884 .652 .583 r
.75845 .34145 .76175 .34327 .76399 .33475 .7607 .33293 Mtetra
.874 .676 .632 r
.7607 .33293 .76399 .33475 .76646 .3276 .76318 .32577 Mtetra
.834 .725 .745 r
.76318 .32577 .76646 .3276 .76931 .32266 .76603 .32083 Mtetra
.644 .763 .935 r
.76603 .32083 .76931 .32266 .77265 .32041 .76937 .31857 Mtetra
.059 .526 .894 r
.76937 .31857 .77265 .32041 .77651 .32087 .77322 .31902 Mtetra
.398 0 0 r
.77322 .31902 .77651 .32087 .78082 .32361 .77752 .32175 Mtetra
.548 0 0 r
.77752 .32175 .78082 .32361 .78544 .32782 .78213 .32596 Mtetra
.573 .004 0 r
.78213 .32596 .78544 .32782 .79019 .33242 .78687 .33055 Mtetra
.507 0 0 r
.78687 .33055 .79019 .33242 .79483 .33623 .79149 .33436 Mtetra
0 .292 .689 r
.79149 .33436 .79483 .33623 .79914 .3382 .7958 .33632 Mtetra
.327 .673 .976 r
.7958 .33632 .79914 .3382 .80297 .33757 .79962 .33569 Mtetra
.946 .884 .741 r
.36225 .74772 .36585 .74593 .36857 .74074 .36498 .74251 Mtetra
.937 .768 .647 r
.36498 .74251 .36857 .74074 .37147 .7327 .36789 .73444 Mtetra
.925 .72 .607 r
.36789 .73444 .37147 .7327 .37448 .72263 .37093 .72435 Mtetra
.92 .704 .594 r
.37093 .72435 .37448 .72263 .37753 .71172 .374 .7134 Mtetra
.922 .71 .599 r
.374 .7134 .37753 .71172 .38054 .70125 .37703 .7029 Mtetra
.931 .742 .626 r
.37703 .7029 .38054 .70125 .38344 .69242 .37994 .69404 Mtetra
.945 .822 .692 r
.37994 .69404 .38344 .69242 .38618 .68613 .38269 .68773 Mtetra
.878 .984 .828 r
.38269 .68773 .38618 .68613 .38875 .68282 .38527 .68442 Mtetra
.012 0 0 r
.38527 .68442 .38875 .68282 .39116 .68247 .38768 .68406 Mtetra
.512 .015 .014 r
.38768 .68406 .39116 .68247 .39345 .68453 .38997 .68614 Mtetra
.618 .155 .131 r
.38997 .68614 .39345 .68453 .39569 .68808 .39219 .68971 Mtetra
.63 .171 .144 r
.39219 .68971 .39569 .68808 .39792 .6919 .39442 .69354 Mtetra
.57 .091 .077 r
.39442 .69354 .39792 .6919 .40023 .69471 .39672 .69637 Mtetra
.304 0 0 r
.39672 .69637 .40023 .69471 .40266 .6954 .39914 .69706 Mtetra
.655 .967 .805 r
.39914 .69706 .40266 .6954 .40523 .69323 .40172 .69489 Mtetra
.948 .884 .736 r
.40172 .69489 .40523 .69323 .40795 .68798 .40444 .68962 Mtetra
.942 .772 .643 r
.40444 .68962 .40795 .68798 .41078 .68001 .40729 .68163 Mtetra
.93 .725 .603 r
.40729 .68163 .41078 .68001 .41368 .67015 .41021 .67174 Mtetra
.926 .71 .591 r
.41021 .67174 .41368 .67015 .41659 .65959 .41314 .66114 Mtetra
.929 .719 .599 r
.41314 .66114 .41659 .65959 .41947 .64959 .41604 .65111 Mtetra
.938 .757 .631 r
.41604 .65111 .41947 .64959 .42226 .64129 .41885 .64278 Mtetra
.949 .849 .71 r
.41885 .64278 .42226 .64129 .42495 .63553 .42154 .63701 Mtetra
.812 .999 .842 r
.42154 .63701 .42495 .63553 .42753 .63271 .42413 .63419 Mtetra
.135 0 0 r
.42413 .63419 .42753 .63271 .43001 .63275 .42661 .63423 Mtetra
.532 .032 .014 r
.42661 .63423 .43001 .63275 .43243 .63509 .42902 .63658 Mtetra
.621 .15 .113 r
.42902 .63658 .43243 .63509 .43482 .63877 .43141 .64027 Mtetra
.627 .157 .119 r
.43141 .64027 .43482 .63877 .43723 .64259 .43381 .64411 Mtetra
.558 .066 .043 r
.43381 .64411 .43723 .64259 .4397 .6453 .43626 .64684 Mtetra
.265 0 0 r
.43626 .64684 .4397 .6453 .44224 .64585 .4388 .64739 Mtetra
.683 .977 .818 r
.4388 .64739 .44224 .64585 .44487 .64355 .44144 .64508 Mtetra
.951 .884 .732 r
.44144 .64508 .44487 .64355 .44758 .63824 .44416 .63976 Mtetra
.946 .776 .638 r
.44416 .63976 .44758 .63824 .45034 .63032 .44694 .63181 Mtetra
.936 .73 .599 r
.44694 .63181 .45034 .63032 .45314 .62065 .44975 .62212 Mtetra
.933 .717 .588 r
.44975 .62212 .45314 .62065 .45593 .61042 .45256 .61185 Mtetra
.936 .729 .599 r
.45256 .61185 .45593 .61042 .45869 .60084 .45534 .60225 Mtetra
.946 .774 .637 r
.45534 .60225 .45869 .60084 .4614 .59304 .45806 .59442 Mtetra
.95 .879 .731 r
.45806 .59442 .4614 .59304 .46406 .58779 .46073 .58916 Mtetra
.711 .986 .838 r
.46073 .58916 .46406 .58779 .46668 .58543 .46335 .5868 Mtetra
.229 0 0 r
.46335 .5868 .46668 .58543 .46926 .58585 .46593 .58722 Mtetra
.547 .042 .008 r
.46593 .58722 .46926 .58585 .47183 .58844 .4685 .58982 Mtetra
.622 .142 .093 r
.4685 .58982 .47183 .58844 .4744 .59224 .47106 .59364 Mtetra
.622 .141 .092 r
.47106 .59364 .4744 .59224 .477 .59606 .47366 .59748 Mtetra
.544 .039 .006 r
.47366 .59748 .477 .59606 .47963 .59869 .47628 .60011 Mtetra
.224 0 0 r
.47628 .60011 .47963 .59869 .4823 .59909 .47894 .60052 Mtetra
.707 .985 .827 r
.47894 .60052 .4823 .59909 .48499 .59665 .48164 .59808 Mtetra
.953 .886 .727 r
.48164 .59808 .48499 .59665 .48769 .59127 .48435 .59268 Mtetra
.951 .78 .634 r
.48435 .59268 .48769 .59127 .4904 .58339 .48707 .58478 Mtetra
.942 .736 .595 r
.48707 .58478 .4904 .58339 .49309 .5739 .48978 .57526 Mtetra
.939 .725 .585 r
.48978 .57526 .49309 .5739 .49577 .56397 .49248 .56529 Mtetra
.943 .74 .599 r
.49248 .56529 .49577 .56397 .49843 .5548 .49516 .5561 Mtetra
.953 .793 .646 r
.49516 .5561 .49843 .5548 .50109 .54747 .49783 .54874 Mtetra
.945 .911 .754 r
.49783 .54874 .50109 .54747 .50375 .54269 .50049 .54396 Mtetra
.575 .938 .807 r
.50049 .54396 .50375 .54269 .50643 .54078 .50318 .54204 Mtetra
.299 0 0 r
.50318 .54204 .50643 .54078 .50914 .54156 .50589 .54282 Mtetra
.558 .048 0 r
.50589 .54282 .50914 .54156 .51189 .54439 .50863 .54567 Mtetra
.622 .133 .07 r
.50863 .54567 .51189 .54439 .51467 .54831 .5114 .54961 Mtetra
.615 .123 .062 r
.5114 .54961 .51467 .54831 .51748 .55213 .5142 .55344 Mtetra
.527 .01 0 r
.5142 .55344 .51748 .55213 .52029 .55466 .51701 .55598 Mtetra
.18 0 0 r
.51701 .55598 .52029 .55466 .52308 .55492 .5198 .55624 Mtetra
.726 .989 .833 r
.5198 .55624 .52308 .55492 .52584 .55234 .52256 .55366 Mtetra
.957 .888 .722 r
.52256 .55366 .52584 .55234 .52854 .54689 .52528 .54819 Mtetra
.957 .785 .629 r
.52528 .54819 .52854 .54689 .53119 .53904 .52794 .54032 Mtetra
.949 .742 .59 r
.52794 .54032 .53119 .53904 .53379 .52971 .53055 .53096 Mtetra
.946 .733 .582 r
.53055 .53096 .53379 .52971 .53636 .52005 .53315 .52127 Mtetra
.951 .753 .6 r
.53315 .52127 .53636 .52005 .53895 .51127 .53574 .51246 Mtetra
.959 .814 .656 r
.53574 .51246 .53895 .51127 .54157 .50438 .53838 .50555 Mtetra
.931 .944 .78 r
.53838 .50555 .54157 .50438 .54425 .50006 .54107 .50122 Mtetra
.417 .856 .753 r
.54107 .50122 .54425 .50006 .54703 .49857 .54385 .49973 Mtetra
.351 0 0 r
.54385 .49973 .54703 .49857 .5499 .49969 .54672 .50086 Mtetra
.566 .05 0 r
.54672 .50086 .5499 .49969 .55286 .50276 .54967 .50394 Mtetra
.62 .12 .044 r
.54967 .50394 .55286 .50276 .55587 .5068 .55268 .50799 Mtetra
.607 .103 .029 r
.55268 .50799 .55587 .5068 .55891 .51061 .55571 .51182 Mtetra
.509 0 0 r
.55571 .51182 .55891 .51061 .56191 .51304 .55871 .51426 Mtetra
.135 0 0 r
.55871 .51426 .56191 .51304 .56485 .51316 .56164 .51438 Mtetra
.742 .993 .835 r
.56164 .51438 .56485 .51316 .56767 .51044 .56447 .51167 Mtetra
.96 .89 .716 r
.56447 .51167 .56767 .51044 .57038 .50491 .56719 .50611 Mtetra
.962 .79 .623 r
.56719 .50611 .57038 .50491 .57297 .49708 .56979 .49826 Mtetra
.955 .749 .585 r
.56979 .49826 .57297 .49708 .57548 .48788 .57232 .48904 Mtetra
.954 .742 .579 r
.57232 .48904 .57548 .48788 .57797 .47849 .57482 .47961 Mtetra
.959 .767 .602 r
.57482 .47961 .57797 .47849 .58049 .47007 .57736 .47117 Mtetra
.965 .838 .668 r
.57736 .47117 .58049 .47007 .58309 .4636 .57998 .46468 Mtetra
.903 .974 .806 r
.57998 .46468 .58309 .4636 .58584 .45972 .58273 .46079 Mtetra
.26 .755 .685 r
.58273 .46079 .58584 .45972 .58874 .45864 .58563 .45971 Mtetra
.391 0 0 r
.58563 .45971 .58874 .45864 .59181 .46009 .5887 .46117 Mtetra
.57 .047 0 r
.5887 .46117 .59181 .46009 .59501 .46339 .59189 .46448 Mtetra
.615 .106 .015 r
.59189 .46448 .59501 .46339 .59829 .46753 .59517 .46864 Mtetra
.596 .081 0 r
.59517 .46864 .59829 .46753 .60158 .47134 .59845 .47247 Mtetra
.487 0 0 r
.59845 .47247 .60158 .47134 .6048 .47368 .60166 .47481 Mtetra
.09 0 0 r
.60166 .47481 .6048 .47368 .60788 .47365 .60475 .47479 Mtetra
.755 .995 .834 r
.60475 .47479 .60788 .47365 .61078 .4708 .60765 .47193 Mtetra
.963 .894 .709 r
.60765 .47193 .61078 .4708 .61349 .46517 .61037 .46629 Mtetra
.968 .797 .616 r
.61037 .46629 .61349 .46517 .61603 .45735 .61292 .45844 Mtetra
.962 .756 .579 r
.61292 .45844 .61603 .45735 .61846 .44828 .61537 .44934 Mtetra
.962 .753 .575 r
.61537 .44934 .61846 .44828 .62087 .43913 .61779 .44016 Mtetra
.967 .783 .604 r
.61779 .44016 .62087 .43913 .62334 .43105 .62028 .43205 Mtetra
.968 .865 .683 r
.62028 .43205 .62334 .43105 .62596 .42498 .62292 .42597 Mtetra
.855 .994 .828 r
.62292 .42597 .62596 .42498 .6288 .42153 .62576 .42251 Mtetra
0 0 0 r
.62576 .42251 .6288 .42153 .63187 .42084 .62883 .42182 Mtetra
.42 0 0 r
.62883 .42182 .63187 .42084 .63517 .42261 .63213 .4236 Mtetra
.572 .041 0 r
.63213 .4236 .63517 .42261 .63865 .42614 .6356 .42714 Mtetra
.609 .089 0 r
.6356 .42714 .63865 .42614 .64223 .43039 .63917 .43141 Mtetra
.584 .056 0 r
.63917 .43141 .64223 .43039 .6458 .4342 .64274 .43524 Mtetra
.464 0 0 r
.64274 .43524 .6458 .4342 .64925 .43644 .64619 .43749 Mtetra
.045 0 0 r
.64619 .43749 .64925 .43644 .6525 .43627 .64943 .43732 Mtetra
.765 .996 .832 r
.64943 .43732 .6525 .43627 .65548 .43327 .65242 .43431 Mtetra
.967 .898 .702 r
.65242 .43431 .65548 .43327 .65819 .42754 .65514 .42857 Mtetra
.974 .803 .609 r
.65514 .42857 .65819 .42754 .66068 .41971 .65765 .42071 Mtetra
.969 .765 .572 r
.65765 .42071 .66068 .41971 .66303 .41075 .66002 .41172 Mtetra
.969 .764 .572 r
.66002 .41172 .66303 .41075 .66538 .40182 .66237 .40277 Mtetra
.974 .802 .608 r
.66237 .40277 .66538 .40182 .66783 .39407 .66484 .39499 Mtetra
.967 .894 .701 r
.66484 .39499 .66783 .39407 .67049 .38839 .66752 .3893 Mtetra
.782 .998 .841 r
.66752 .3893 .67049 .38839 .67345 .38534 .67048 .38624 Mtetra
0 0 0 r
.67048 .38624 .67345 .38534 .67673 .38504 .67376 .38594 Mtetra
.441 0 0 r
.67376 .38594 .67673 .38504 .68031 .38713 .67734 .38804 Mtetra
.571 .032 0 r
.67734 .38804 .68031 .38713 .68412 .39088 .68114 .39181 Mtetra
.601 .07 0 r
.68114 .39181 .68412 .39088 .68803 .39525 .68505 .39619 Mtetra
.569 .03 0 r
.68505 .39619 .68803 .39525 .69191 .39905 .68893 .40001 Mtetra
.438 0 0 r
.68893 .40001 .69191 .39905 .69562 .4012 .69263 .40217 Mtetra
.002 0 0 r
.69263 .40217 .69562 .4012 .69904 .40088 .69606 .40185 Mtetra
.772 .997 .827 r
.69606 .40185 .69904 .40088 .70211 .39772 .69913 .39869 Mtetra
.97 .903 .694 r
.69913 .39869 .70211 .39772 .70483 .3919 .70186 .39284 Mtetra
.98 .81 .601 r
.70186 .39284 .70483 .3919 .70727 .38404 .70432 .38496 Mtetra
.977 .774 .565 r
.70432 .38496 .70727 .38404 .70956 .37518 .70662 .37607 Mtetra
.977 .777 .568 r
.70662 .37607 .70956 .37518 .71185 .36646 .70893 .36732 Mtetra
.981 .822 .612 r
.70893 .36732 .71185 .36646 .7143 .35901 .71139 .35985 Mtetra
.96 .925 .721 r
.71139 .35985 .7143 .35901 .71705 .35371 .71414 .35453 Mtetra
.681 .978 .839 r
.71414 .35453 .71705 .35371 .72017 .35106 .71727 .35188 Mtetra
.09 0 0 r
.71727 .35188 .72017 .35106 .72371 .35113 .72081 .35195 Mtetra
.455 0 0 r
.72081 .35195 .72371 .35113 .72762 .35355 .72472 .35438 Mtetra
.567 .019 0 r
.72472 .35438 .72762 .35355 .7318 .35752 .7289 .35837 Mtetra
.59 .048 0 r
.7289 .35837 .7318 .35752 .73609 .362 .73319 .36286 Mtetra
.552 .001 0 r
.73319 .36286 .73609 .362 .74033 .3658 .73742 .36668 Mtetra
.409 0 0 r
.73742 .36668 .74033 .3658 .74432 .36786 .74141 .36875 Mtetra
0 0 0 r
.74141 .36875 .74432 .36786 .74793 .36738 .74502 .36828 Mtetra
.777 .998 .821 r
.74502 .36828 .74793 .36738 .75109 .36407 .74819 .36495 Mtetra
.973 .908 .685 r
.74819 .36495 .75109 .36407 .75383 .35812 .75094 .35899 Mtetra
.986 .818 .591 r
.75094 .35899 .75383 .35812 .75622 .35024 .75335 .35108 Mtetra
.984 .783 .556 r
.75335 .35108 .75622 .35024 .75845 .34145 .75559 .34226 Mtetra
.984 .791 .563 r
.75559 .34226 .75845 .34145 .7607 .33293 .75785 .33371 Mtetra
.986 .844 .618 r
.75785 .33371 .7607 .33293 .76318 .32577 .76034 .32653 Mtetra
.943 .954 .742 r
.76034 .32653 .76318 .32577 .76603 .32083 .76321 .32158 Mtetra
.559 .932 .82 r
.76321 .32158 .76603 .32083 .76937 .31857 .76655 .31931 Mtetra
.161 0 0 r
.76655 .31931 .76937 .31857 .77322 .31902 .7704 .31977 Mtetra
.463 0 0 r
.7704 .31977 .77322 .31902 .77752 .32175 .7747 .32251 Mtetra
.56 .003 0 r
.7747 .32251 .77752 .32175 .78213 .32596 .77931 .32673 Mtetra
.577 .024 0 r
.77931 .32673 .78213 .32596 .78687 .33055 .78404 .33135 Mtetra
.532 0 0 r
.78404 .33135 .78687 .33055 .79149 .33436 .78866 .33517 Mtetra
.379 0 0 r
.78866 .33517 .79149 .33436 .7958 .33632 .79297 .33714 Mtetra
0 0 0 r
.79297 .33714 .7958 .33632 .79962 .33569 .7968 .33651 Mtetra
.93 .96 .653 r
.35847 .7518 .36225 .74772 .36498 .74251 .36122 .74657 Mtetra
.986 .857 .626 r
.36122 .74657 .36498 .74251 .36789 .73444 .36415 .73847 Mtetra
.975 .794 .596 r
.36415 .73847 .36789 .73444 .37093 .72435 .36721 .72832 Mtetra
.968 .772 .585 r
.36721 .72832 .37093 .72435 .374 .7134 .3703 .71732 Mtetra
.971 .78 .589 r
.3703 .71732 .374 .7134 .37703 .7029 .37335 .70676 Mtetra
.982 .824 .611 r
.37335 .70676 .37703 .7029 .37994 .69404 .37629 .69787 Mtetra
.978 .917 .651 r
.37629 .69787 .37994 .69404 .38269 .68773 .37905 .69152 Mtetra
.687 .913 .576 r
.37905 .69152 .38269 .68773 .38527 .68442 .38164 .6882 Mtetra
.129 0 0 r
.38164 .6882 .38527 .68442 .38768 .68406 .38405 .68785 Mtetra
.46 .025 .125 r
.38405 .68785 .38768 .68406 .38997 .68614 .38633 .68995 Mtetra
.555 .134 .197 r
.38633 .68995 .38997 .68614 .39219 .68971 .38855 .69354 Mtetra
.567 .147 .206 r
.38855 .69354 .39219 .68971 .39442 .69354 .39077 .69741 Mtetra
.51 .082 .163 r
.39077 .69741 .39442 .69354 .39672 .69637 .39307 .70026 Mtetra
.307 0 .018 r
.39307 .70026 .39672 .69637 .39914 .69706 .39549 .70097 Mtetra
0 0 0 r
.39549 .70097 .39914 .69706 .40172 .69489 .39808 .69879 Mtetra
.931 .959 .647 r
.39808 .69879 .40172 .69489 .40444 .68962 .40081 .6935 Mtetra
.989 .86 .618 r
.40081 .6935 .40444 .68962 .40729 .68163 .40368 .68547 Mtetra
.98 .8 .589 r
.40368 .68547 .40729 .68163 .41021 .67174 .40662 .67553 Mtetra
.974 .78 .579 r
.40662 .67553 .41021 .67174 .41314 .66114 .40958 .66488 Mtetra
.978 .792 .586 r
.40958 .66488 .41314 .66114 .41604 .65111 .41249 .6548 Mtetra
.987 .842 .611 r
.41249 .6548 .41604 .65111 .41885 .64278 .41532 .64643 Mtetra
.964 .939 .65 r
.41532 .64643 .41885 .64278 .42154 .63701 .41803 .64063 Mtetra
.554 .844 .515 r
.41803 .64063 .42154 .63701 .42413 .63419 .42062 .6378 Mtetra
.203 0 0 r
.42062 .6378 .42413 .63419 .42661 .63423 .42311 .63785 Mtetra
.478 .037 .122 r
.42311 .63785 .42661 .63423 .42902 .63658 .42552 .64022 Mtetra
.559 .13 .183 r
.42552 .64022 .42902 .63658 .43141 .64027 .4279 .64395 Mtetra
.564 .136 .187 r
.4279 .64395 .43141 .64027 .43381 .64411 .43029 .64781 Mtetra
.501 .063 .139 r
.43029 .64781 .43381 .64411 .43626 .64684 .43274 .65057 Mtetra
.283 0 0 r
.43274 .65057 .43626 .64684 .4388 .64739 .43529 .65113 Mtetra
0 0 0 r
.43529 .65113 .4388 .64739 .44144 .64508 .43793 .64882 Mtetra
.931 .956 .639 r
.43793 .64882 .44144 .64508 .44416 .63976 .44066 .64347 Mtetra
.991 .863 .61 r
.44066 .64347 .44416 .63976 .44694 .63181 .44346 .63549 Mtetra
.985 .806 .582 r
.44346 .63549 .44694 .63181 .44975 .62212 .44629 .62575 Mtetra
.981 .789 .573 r
.44629 .62575 .44975 .62212 .45256 .61185 .44912 .61542 Mtetra
.984 .805 .581 r
.44912 .61542 .45256 .61185 .45534 .60225 .45192 .60578 Mtetra
.991 .861 .61 r
.45192 .60578 .45534 .60225 .45806 .59442 .45467 .59791 Mtetra
.937 .956 .645 r
.45467 .59791 .45806 .59442 .46073 .58916 .45735 .59262 Mtetra
0 0 0 r
.45735 .59262 .46073 .58916 .46335 .5868 .45997 .59026 Mtetra
.262 0 0 r
.45997 .59026 .46335 .5868 .46593 .58722 .46255 .59069 Mtetra
.492 .045 .116 r
.46255 .59069 .46593 .58722 .4685 .58982 .46511 .59332 Mtetra
.562 .124 .167 r
.46511 .59332 .4685 .58982 .47106 .59364 .46768 .59717 Mtetra
.561 .124 .167 r
.46768 .59717 .47106 .59364 .47366 .59748 .47026 .60103 Mtetra
.49 .043 .114 r
.47026 .60103 .47366 .59748 .47628 .60011 .47289 .60369 Mtetra
.258 0 0 r
.47289 .60369 .47628 .60011 .47894 .60052 .47555 .60411 Mtetra
0 0 0 r
.47555 .60411 .47894 .60052 .48164 .59808 .47825 .60166 Mtetra
.93 .954 .63 r
.47825 .60166 .48164 .59808 .48435 .59268 .48098 .59624 Mtetra
.993 .867 .6 r
.48098 .59624 .48435 .59268 .48707 .58478 .48372 .5883 Mtetra
.989 .812 .573 r
.48372 .5883 .48707 .58478 .48978 .57526 .48645 .57873 Mtetra
.987 .798 .566 r
.48645 .57873 .48978 .57526 .49248 .56529 .48917 .56872 Mtetra
.99 .819 .577 r
.48917 .56872 .49248 .56529 .49516 .5561 .49186 .55948 Mtetra
.991 .881 .608 r
.49186 .55948 .49516 .5561 .49783 .54874 .49455 .55209 Mtetra
.892 .962 .632 r
.49455 .55209 .49783 .54874 .50049 .54396 .49723 .54728 Mtetra
0 0 0 r
.49723 .54728 .50049 .54396 .50318 .54204 .49992 .54537 Mtetra
.308 0 0 r
.49992 .54537 .50318 .54204 .50589 .54282 .50263 .54616 Mtetra
.504 .05 .106 r
.50263 .54616 .50589 .54282 .50863 .54567 .50537 .54903 Mtetra
.563 .117 .15 r
.50537 .54903 .50863 .54567 .5114 .54961 .50814 .553 Mtetra
.556 .109 .145 r
.50814 .553 .5114 .54961 .5142 .55344 .51093 .55686 Mtetra
.478 .021 .088 r
.51093 .55686 .5142 .55344 .51701 .55598 .51374 .55942 Mtetra
.232 0 0 r
.51374 .55942 .51701 .55598 .5198 .55624 .51653 .5597 Mtetra
0 0 0 r
.51653 .5597 .5198 .55624 .52256 .55366 .5193 .55711 Mtetra
.927 .951 .619 r
.5193 .55711 .52256 .55366 .52528 .54819 .52203 .55162 Mtetra
.994 .87 .589 r
.52203 .55162 .52528 .54819 .52794 .54032 .52471 .5437 Mtetra
.993 .819 .563 r
.52471 .5437 .52794 .54032 .53055 .53096 .52734 .5343 Mtetra
.992 .808 .557 r
.52734 .5343 .53055 .53096 .53315 .52127 .52996 .52456 Mtetra
.995 .833 .571 r
.52996 .52456 .53315 .52127 .53574 .51246 .53257 .51571 Mtetra
.986 .901 .605 r
.53257 .51571 .53574 .51246 .53838 .50555 .53522 .50877 Mtetra
.825 .954 .61 r
.53522 .50877 .53838 .50555 .54107 .50122 .53792 .50442 Mtetra
0 0 0 r
.53792 .50442 .54107 .50122 .54385 .49973 .54071 .50293 Mtetra
.346 0 0 r
.54071 .50293 .54385 .49973 .54672 .50086 .54358 .50407 Mtetra
.513 .051 .094 r
.54358 .50407 .54672 .50086 .54967 .50394 .54653 .50718 Mtetra
.563 .108 .13 r
.54653 .50718 .54967 .50394 .55268 .50799 .54953 .51126 Mtetra
.55 .093 .121 r
.54953 .51126 .55268 .50799 .55571 .51182 .55256 .51512 Mtetra
.464 0 .06 r
.55256 .51512 .55571 .51182 .55871 .51426 .55556 .51759 Mtetra
.205 0 0 r
.55556 .51759 .55871 .51426 .56164 .51438 .5585 .51772 Mtetra
0 0 0 r
.5585 .51772 .56164 .51438 .56447 .51167 .56134 .51499 Mtetra
.922 .948 .605 r
.56134 .51499 .56447 .51167 .56719 .50611 .56406 .50941 Mtetra
.994 .874 .576 r
.56406 .50941 .56719 .50611 .56979 .49826 .56669 .50152 Mtetra
.997 .826 .552 r
.56669 .50152 .56979 .49826 .57232 .48904 .56923 .49225 Mtetra
.996 .818 .547 r
.56923 .49225 .57232 .48904 .57482 .47961 .57176 .48278 Mtetra
.997 .848 .563 r
.57176 .48278 .57482 .47961 .57736 .47117 .57431 .47429 Mtetra
.974 .919 .599 r
.57431 .47429 .57736 .47117 .57998 .46468 .57694 .46778 Mtetra
.735 .926 .578 r
.57694 .46778 .57998 .46468 .58273 .46079 .5797 .46387 Mtetra
0 0 0 r
.5797 .46387 .58273 .46079 .58563 .45971 .58261 .46279 Mtetra
.376 0 0 r
.58261 .46279 .58563 .45971 .5887 .46117 .58568 .46427 Mtetra
.519 .049 .078 r
.58568 .46427 .5887 .46117 .59189 .46448 .58887 .46761 Mtetra
.561 .096 .108 r
.58887 .46761 .59189 .46448 .59517 .46864 .59214 .4718 Mtetra
.543 .076 .095 r
.59214 .4718 .59517 .46864 .59845 .47247 .59542 .47566 Mtetra
.449 0 .031 r
.59542 .47566 .59845 .47247 .60166 .47481 .59864 .47803 Mtetra
.178 0 0 r
.59864 .47803 .60166 .47481 .60475 .47479 .60173 .47801 Mtetra
0 0 0 r
.60173 .47801 .60475 .47479 .60765 .47193 .60465 .47514 Mtetra
.916 .943 .59 r
.60465 .47514 .60765 .47193 .61037 .46629 .60738 .46947 Mtetra
.993 .876 .561 r
.60738 .46947 .61037 .46629 .61292 .45844 .60994 .46159 Mtetra
.999 .832 .538 r
.60994 .46159 .61292 .45844 .61537 .44934 .61241 .45244 Mtetra
.999 .828 .536 r
.61241 .45244 .61537 .44934 .61779 .44016 .61485 .44322 Mtetra
.996 .863 .555 r
.61485 .44322 .61779 .44016 .62028 .43205 .61736 .43507 Mtetra
.951 .932 .59 r
.61736 .43507 .62028 .43205 .62292 .42597 .62 .42896 Mtetra
.625 .877 .536 r
.62 .42896 .62292 .42597 .62576 .42251 .62285 .42549 Mtetra
.05 0 0 r
.62285 .42549 .62576 .42251 .62883 .42182 .62593 .4248 Mtetra
.399 0 0 r
.62593 .4248 .62883 .42182 .63213 .4236 .62924 .4266 Mtetra
.524 .045 .06 r
.62924 .4266 .63213 .4236 .6356 .42714 .63271 .43017 Mtetra
.558 .083 .084 r
.63271 .43017 .6356 .42714 .63917 .43141 .63628 .43448 Mtetra
.535 .057 .068 r
.63628 .43448 .63917 .43141 .64274 .43524 .63984 .43833 Mtetra
.433 0 .001 r
.63984 .43833 .64274 .43524 .64619 .43749 .6433 .4406 Mtetra
.15 0 0 r
.6433 .4406 .64619 .43749 .64943 .43732 .64655 .44044 Mtetra
0 0 0 r
.64655 .44044 .64943 .43732 .65242 .43431 .64955 .43742 Mtetra
.907 .938 .571 r
.64955 .43742 .65242 .43431 .65514 .42857 .65228 .43166 Mtetra
.99 .878 .544 r
.65228 .43166 .65514 .42857 .65765 .42071 .6548 .42376 Mtetra
.999 .839 .522 r
.6548 .42376 .65765 .42071 .66002 .41172 .65719 .41473 Mtetra
.999 .838 .522 r
.65719 .41473 .66002 .41172 .66237 .40277 .65956 .40573 Mtetra
.991 .877 .543 r
.65956 .40573 .66237 .40277 .66484 .39499 .66204 .39791 Mtetra
.913 .938 .575 r
.66204 .39791 .66484 .39499 .66752 .3893 .66473 .39219 Mtetra
0 0 0 r
.66473 .39219 .66752 .3893 .67048 .38624 .66771 .38913 Mtetra
.122 0 0 r
.66771 .38913 .67048 .38624 .67376 .38594 .671 .38883 Mtetra
.418 0 0 r
.671 .38883 .67376 .38594 .67734 .38804 .67458 .39095 Mtetra
.526 .037 .039 r
.67458 .39095 .67734 .38804 .68114 .39181 .67838 .39475 Mtetra
.553 .068 .057 r
.67838 .39475 .68114 .39181 .68505 .39619 .68229 .39917 Mtetra
.524 .036 .038 r
.68229 .39917 .68505 .39619 .68893 .40001 .68617 .40302 Mtetra
.416 0 0 r
.68617 .40302 .68893 .40001 .69263 .40217 .68988 .4052 Mtetra
.124 0 0 r
.68988 .4052 .69263 .40217 .69606 .40185 .69331 .40488 Mtetra
0 0 0 r
.69331 .40488 .69606 .40185 .69913 .39869 .6964 .40171 Mtetra
.895 .93 .55 r
.6964 .40171 .69913 .39869 .70186 .39284 .69914 .39584 Mtetra
.984 .878 .523 r
.69914 .39584 .70186 .39284 .70432 .38496 .70161 .38792 Mtetra
.997 .843 .503 r
.70161 .38792 .70432 .38496 .70662 .37607 .70393 .37898 Mtetra
.996 .847 .505 r
.70393 .37898 .70662 .37607 .70893 .36732 .70625 .37019 Mtetra
.978 .888 .529 r
.70625 .37019 .70893 .36732 .71139 .35985 .70873 .36268 Mtetra
.859 .933 .555 r
.70873 .36268 .71139 .35985 .71414 .35453 .7115 .35734 Mtetra
0 0 0 r
.7115 .35734 .71414 .35453 .71727 .35188 .71464 .35468 Mtetra
.18 0 0 r
.71464 .35468 .71727 .35188 .72081 .35195 .71818 .35476 Mtetra
.432 0 0 r
.71818 .35476 .72081 .35195 .72472 .35438 .7221 .35721 Mtetra
.526 .027 .015 r
.7221 .35721 .72472 .35438 .7289 .35837 .72628 .36123 Mtetra
.547 .051 .029 r
.72628 .36123 .7289 .35837 .73319 .36286 .73057 .36576 Mtetra
.513 .013 .007 r
.73057 .36576 .73319 .36286 .73742 .36668 .7348 .36962 Mtetra
.397 0 0 r
.7348 .36962 .73742 .36668 .74141 .36875 .7388 .3717 Mtetra
.099 0 0 r
.7388 .3717 .74141 .36875 .74502 .36828 .74242 .37124 Mtetra
0 0 0 r
.74242 .37124 .74502 .36828 .74819 .36495 .74561 .3679 Mtetra
.879 .92 .525 r
.74561 .3679 .74819 .36495 .75094 .35899 .74836 .36191 Mtetra
.975 .877 .499 r
.74836 .36191 .75094 .35899 .75335 .35108 .75079 .35396 Mtetra
.99 .846 .481 r
.75079 .35396 .75335 .35108 .75559 .34226 .75305 .3451 Mtetra
.988 .854 .485 r
.75305 .3451 .75559 .34226 .75785 .33371 .75533 .3365 Mtetra
.956 .895 .511 r
.75533 .3365 .75785 .33371 .76034 .32653 .75783 .32929 Mtetra
.785 .914 .528 r
.75783 .32929 .76034 .32653 .76321 .32158 .76071 .32431 Mtetra
0 0 0 r
.76071 .32431 .76321 .32158 .76655 .31931 .76407 .32204 Mtetra
.226 0 0 r
.76407 .32204 .76655 .31931 .7704 .31977 .76792 .32251 Mtetra
.442 0 0 r
.76792 .32251 .7704 .31977 .7747 .32251 .77223 .32528 Mtetra
.524 .015 0 r
.77223 .32528 .7747 .32251 .77931 .32673 .77684 .32953 Mtetra
.539 .032 0 r
.77684 .32953 .77931 .32673 .78404 .33135 .78158 .33418 Mtetra
.5 0 0 r
.78158 .33418 .78404 .33135 .78866 .33517 .78621 .33804 Mtetra
.377 0 0 r
.78621 .33804 .78866 .33517 .79297 .33714 .79052 .34003 Mtetra
.075 0 0 r
.79052 .34003 .79297 .33714 .7968 .33651 .79436 .33941 Mtetra
.856 .935 .559 r
.35458 .7571 .35847 .7518 .36122 .74657 .35734 .75184 Mtetra
.99 .888 .597 r
.35734 .75184 .36122 .74657 .36415 .73847 .3603 .74369 Mtetra
.991 .827 .582 r
.3603 .74369 .36415 .73847 .36721 .72832 .36338 .73348 Mtetra
.986 .803 .574 r
.36338 .73348 .36721 .72832 .3703 .71732 .3665 .72241 Mtetra
.988 .812 .577 r
.3665 .72241 .3703 .71732 .37335 .70676 .36958 .7118 Mtetra
.994 .857 .591 r
.36958 .7118 .37335 .70676 .37629 .69787 .37254 .70285 Mtetra
.954 .933 .598 r
.37254 .70285 .37629 .69787 .37905 .69152 .37532 .69647 Mtetra
0 0 0 r
.37532 .69647 .37905 .69152 .38164 .6882 .37791 .69313 Mtetra
.158 0 0 r
.37791 .69313 .38164 .6882 .38405 .68785 .38033 .69279 Mtetra
.439 .028 .161 r
.38033 .69279 .38405 .68785 .38633 .68995 .38261 .69492 Mtetra
.529 .125 .22 r
.38261 .69492 .38633 .68995 .38855 .69354 .38482 .69855 Mtetra
.54 .138 .227 r
.38482 .69855 .38855 .69354 .39077 .69741 .38704 .70245 Mtetra
.486 .078 .192 r
.38704 .70245 .39077 .69741 .39307 .70026 .38933 .70533 Mtetra
.305 0 .077 r
.38933 .70533 .39307 .70026 .39549 .70097 .39176 .70606 Mtetra
0 0 0 r
.39176 .70606 .39549 .70097 .39808 .69879 .39435 .70387 Mtetra
.856 .932 .552 r
.39435 .70387 .39808 .69879 .40081 .6935 .3971 .69856 Mtetra
.99 .89 .587 r
.3971 .69856 .40081 .6935 .40368 .68547 .39998 .69048 Mtetra
.994 .832 .572 r
.39998 .69048 .40368 .68547 .40662 .67553 .40295 .68048 Mtetra
.991 .811 .565 r
.40295 .68048 .40662 .67553 .40958 .66488 .40593 .66977 Mtetra
.993 .824 .57 r
.40593 .66977 .40958 .66488 .41249 .6548 .40887 .65962 Mtetra
.994 .874 .584 r
.40887 .65962 .41249 .6548 .41532 .64643 .41172 .65121 Mtetra
.919 .939 .58 r
.41172 .65121 .41532 .64643 .41803 .64063 .41445 .64538 Mtetra
0 0 0 r
.41445 .64538 .41803 .64063 .42062 .6378 .41705 .64254 Mtetra
.218 0 .01 r
.41705 .64254 .42062 .6378 .42311 .63785 .41954 .6426 Mtetra
.456 .038 .158 r
.41954 .6426 .42311 .63785 .42552 .64022 .42194 .645 Mtetra
.533 .122 .207 r
.42194 .645 .42552 .64022 .4279 .64395 .42432 .64876 Mtetra
.538 .128 .211 r
.42432 .64876 .4279 .64395 .43029 .64781 .42671 .65267 Mtetra
.477 .061 .171 r
.42671 .65267 .43029 .64781 .43274 .65057 .42916 .65545 Mtetra
.285 0 .053 r
.42916 .65545 .43274 .65057 .43529 .65113 .4317 .65603 Mtetra
0 0 0 r
.4317 .65603 .43529 .65113 .43793 .64882 .43435 .65371 Mtetra
.854 .928 .543 r
.43435 .65371 .43793 .64882 .44066 .64347 .4371 .64834 Mtetra
.989 .891 .575 r
.4371 .64834 .44066 .64347 .44346 .63549 .43991 .64031 Mtetra
.997 .837 .562 r
.43991 .64031 .44346 .63549 .44629 .62575 .44277 .63051 Mtetra
.995 .82 .556 r
.44277 .63051 .44629 .62575 .44912 .61542 .44563 .62012 Mtetra
.997 .836 .561 r
.44563 .62012 .44912 .61542 .45192 .60578 .44845 .61042 Mtetra
.989 .889 .576 r
.44845 .61042 .45192 .60578 .45467 .59791 .45121 .60251 Mtetra
.865 .932 .553 r
.45121 .60251 .45467 .59791 .45735 .59262 .45391 .5972 Mtetra
0 0 0 r
.45391 .5972 .45735 .59262 .45997 .59026 .45654 .59483 Mtetra
.267 0 .027 r
.45654 .59483 .45997 .59026 .46255 .59069 .45913 .59527 Mtetra
.47 .046 .151 r
.45913 .59527 .46255 .59069 .46511 .59332 .46169 .59793 Mtetra
.536 .117 .193 r
.46169 .59793 .46511 .59332 .46768 .59717 .46425 .60181 Mtetra
.535 .116 .193 r
.46425 .60181 .46768 .59717 .47026 .60103 .46683 .60572 Mtetra
.467 .043 .15 r
.46683 .60572 .47026 .60103 .47289 .60369 .46945 .6084 Mtetra
.264 0 .028 r
.46945 .6084 .47289 .60369 .47555 .60411 .47212 .60884 Mtetra
0 0 0 r
.47212 .60884 .47555 .60411 .47825 .60166 .47483 .60638 Mtetra
.849 .923 .532 r
.47483 .60638 .47825 .60166 .48098 .59624 .47757 .60094 Mtetra
.986 .891 .561 r
.47757 .60094 .48098 .59624 .48372 .5883 .48033 .59295 Mtetra
.998 .842 .549 r
.48033 .59295 .48372 .5883 .48645 .57873 .48308 .58332 Mtetra
.998 .828 .545 r
.48308 .58332 .48645 .57873 .48917 .56872 .48582 .57325 Mtetra
.998 .849 .551 r
.48582 .57325 .48917 .56872 .49186 .55948 .48854 .56396 Mtetra
.978 .902 .564 r
.48854 .56396 .49186 .55948 .49455 .55209 .49124 .55653 Mtetra
.791 .91 .517 r
.49124 .55653 .49455 .55209 .49723 .54728 .49394 .5517 Mtetra
0 0 0 r
.49394 .5517 .49723 .54728 .49992 .54537 .49663 .54977 Mtetra
.307 0 .037 r
.49663 .54977 .49992 .54537 .50263 .54616 .49935 .55058 Mtetra
.481 .05 .143 r
.49935 .55058 .50263 .54616 .50537 .54903 .50209 .55349 Mtetra
.537 .11 .178 r
.50209 .55349 .50537 .54903 .50814 .553 .50485 .55749 Mtetra
.531 .103 .174 r
.50485 .55749 .50814 .553 .51093 .55686 .50765 .56139 Mtetra
.456 .024 .128 r
.50765 .56139 .51093 .55686 .51374 .55942 .51045 .56398 Mtetra
.242 0 .003 r
.51045 .56398 .51374 .55942 .51653 .5597 .51325 .56427 Mtetra
0 0 0 r
.51325 .56427 .51653 .5597 .5193 .55711 .51603 .56168 Mtetra
.843 .916 .518 r
.51603 .56168 .5193 .55711 .52203 .55162 .51877 .55616 Mtetra
.982 .891 .545 r
.51877 .55616 .52203 .55162 .52471 .5437 .52147 .5482 Mtetra
.998 .847 .535 r
.52147 .5482 .52471 .5437 .52734 .5343 .52413 .53873 Mtetra
.999 .836 .531 r
.52413 .53873 .52734 .5343 .52996 .52456 .52676 .52894 Mtetra
.996 .86 .539 r
.52676 .52894 .52996 .52456 .53257 .51571 .5294 .52004 Mtetra
.958 .912 .548 r
.5294 .52004 .53257 .51571 .53522 .50877 .53206 .51306 Mtetra
.698 .871 .472 r
.53206 .51306 .53522 .50877 .53792 .50442 .53478 .50869 Mtetra
0 0 0 r
.53478 .50869 .53792 .50442 .54071 .50293 .53757 .5072 Mtetra
.339 0 .042 r
.53757 .5072 .54071 .50293 .54358 .50407 .54044 .50836 Mtetra
.49 .051 .131 r
.54044 .50836 .54358 .50407 .54653 .50718 .54339 .5115 Mtetra
.538 .102 .16 r
.54339 .5115 .54653 .50718 .54953 .51126 .5464 .51562 Mtetra
.526 .089 .153 r
.5464 .51562 .54953 .51126 .55256 .51512 .54942 .51952 Mtetra
.445 .004 .105 r
.54942 .51952 .55256 .51512 .55556 .51759 .55243 .52201 Mtetra
.22 0 0 r
.55243 .52201 .55556 .51759 .5585 .51772 .55537 .52215 Mtetra
0 0 0 r
.55537 .52215 .5585 .51772 .56134 .51499 .55822 .51942 Mtetra
.833 .908 .501 r
.55822 .51942 .56134 .51499 .56406 .50941 .56096 .51381 Mtetra
.976 .89 .527 r
.56096 .51381 .56406 .50941 .56669 .50152 .5636 .50587 Mtetra
.997 .851 .518 r
.5636 .50587 .56669 .50152 .56923 .49225 .56617 .49655 Mtetra
.998 .844 .516 r
.56617 .49655 .56923 .49225 .57176 .48278 .56871 .48703 Mtetra
.99 .87 .524 r
.56871 .48703 .57176 .48278 .57431 .47429 .57128 .47849 Mtetra
.925 .914 .526 r
.57128 .47849 .57431 .47429 .57694 .46778 .57393 .47194 Mtetra
.59 .815 .421 r
.57393 .47194 .57694 .46778 .5797 .46387 .5767 .46802 Mtetra
.024 0 0 r
.5767 .46802 .5797 .46387 .58261 .46279 .57963 .46694 Mtetra
.366 0 .042 r
.57963 .46694 .58261 .46279 .58568 .46427 .58269 .46843 Mtetra
.497 .049 .117 r
.58269 .46843 .58568 .46427 .58887 .46761 .58589 .47181 Mtetra
.537 .092 .141 r
.58589 .47181 .58887 .46761 .59214 .4718 .58916 .47604 Mtetra
.519 .073 .131 r
.58916 .47604 .59214 .4718 .59542 .47566 .59244 .47994 Mtetra
.431 0 .081 r
.59244 .47994 .59542 .47566 .59864 .47803 .59566 .48233 Mtetra
.198 0 0 r
.59566 .48233 .59864 .47803 .60173 .47801 .59876 .48233 Mtetra
0 0 0 r
.59876 .48233 .60173 .47801 .60465 .47514 .60168 .47945 Mtetra
.82 .897 .481 r
.60168 .47945 .60465 .47514 .60738 .46947 .60443 .47375 Mtetra
.967 .887 .506 r
.60443 .47375 .60738 .46947 .60994 .46159 .60701 .46582 Mtetra
.992 .854 .499 r
.60701 .46582 .60994 .46159 .61241 .45244 .6095 .45662 Mtetra
.993 .85 .498 r
.6095 .45662 .61241 .45244 .61485 .44322 .61196 .44734 Mtetra
.977 .878 .505 r
.61196 .44734 .61485 .44322 .61736 .43507 .61448 .43915 Mtetra
.878 .907 .499 r
.61448 .43915 .61736 .43507 .62 .42896 .61715 .43301 Mtetra
0 0 0 r
.61715 .43301 .62 .42896 .62285 .42549 .62001 .42951 Mtetra
.095 0 0 r
.62001 .42951 .62285 .42549 .62593 .4248 .6231 .42883 Mtetra
.387 0 .038 r
.6231 .42883 .62593 .4248 .62924 .4266 .6264 .43066 Mtetra
.501 .045 .101 r
.6264 .43066 .62924 .4266 .63271 .43017 .62988 .43427 Mtetra
.534 .08 .12 r
.62988 .43427 .63271 .43017 .63628 .43448 .63345 .43861 Mtetra
.512 .056 .107 r
.63345 .43861 .63628 .43448 .63984 .43833 .63702 .4425 Mtetra
.417 0 .056 r
.63702 .4425 .63984 .43833 .6433 .4406 .64048 .44481 Mtetra
.176 0 0 r
.64048 .44481 .6433 .4406 .64655 .44044 .64374 .44465 Mtetra
0 0 0 r
.64374 .44465 .64655 .44044 .64955 .43742 .64674 .44162 Mtetra
.804 .884 .458 r
.64674 .44162 .64955 .43742 .65228 .43166 .6495 .43583 Mtetra
.954 .881 .481 r
.6495 .43583 .65228 .43166 .6548 .42376 .65203 .42789 Mtetra
.984 .854 .476 r
.65203 .42789 .6548 .42376 .65719 .41473 .65444 .4188 Mtetra
.65444 .4188 .65719 .41473 .65956 .40573 .65684 .40975 Mtetra
.956 .881 .482 r
.65684 .40975 .65956 .40573 .66204 .39791 .65933 .40188 Mtetra
.815 .889 .465 r
.65933 .40188 .66204 .39791 .66473 .39219 .66204 .39613 Mtetra
0 0 0 r
.66204 .39613 .66473 .39219 .66771 .38913 .66502 .39306 Mtetra
.153 0 0 r
.66502 .39306 .66771 .38913 .671 .38883 .66832 .39277 Mtetra
.404 0 .029 r
.66832 .39277 .671 .38883 .67458 .39095 .67191 .39492 Mtetra
.504 .039 .082 r
.67191 .39492 .67458 .39095 .67838 .39475 .67572 .39875 Mtetra
.53 .066 .097 r
.67572 .39875 .67838 .39475 .68229 .39917 .67963 .40321 Mtetra
.503 .038 .082 r
.67963 .40321 .68229 .39917 .68617 .40302 .68351 .4071 Mtetra
.402 0 .03 r
.68351 .4071 .68617 .40302 .68988 .4052 .68723 .40931 Mtetra
.155 0 0 r
.68723 .40931 .68988 .4052 .69331 .40488 .69067 .40901 Mtetra
0 0 0 r
.69067 .40901 .69331 .40488 .6964 .40171 .69377 .40582 Mtetra
.784 .868 .432 r
.69377 .40582 .6964 .40171 .69914 .39584 .69653 .39992 Mtetra
.937 .873 .453 r
.69653 .39992 .69914 .39584 .70161 .38792 .69902 .39195 Mtetra
.971 .852 .449 r
.69902 .39195 .70161 .38792 .70393 .37898 .70136 .38296 Mtetra
.968 .854 .45 r
.70136 .38296 .70393 .37898 .70625 .37019 .70369 .37412 Mtetra
.924 .878 .454 r
.70369 .37412 .70625 .37019 .70873 .36268 .70619 .36656 Mtetra
.735 .857 .426 r
.70619 .36656 .70873 .36268 .7115 .35734 .70897 .36119 Mtetra
0 0 0 r
.70897 .36119 .7115 .35734 .71464 .35468 .71212 .35852 Mtetra
.201 0 0 r
.71212 .35852 .71464 .35468 .71818 .35476 .71568 .35862 Mtetra
.418 0 .017 r
.71568 .35862 .71818 .35476 .7221 .35721 .7196 .36109 Mtetra
.505 .03 .061 r
.7196 .36109 .7221 .35721 .72628 .36123 .72379 .36516 Mtetra
.525 .051 .072 r
.72379 .36516 .72628 .36123 .73057 .36576 .72809 .36974 Mtetra
.493 .018 .055 r
.72809 .36974 .73057 .36576 .7348 .36962 .73233 .37363 Mtetra
.386 0 .004 r
.73233 .37363 .7348 .36962 .7388 .3717 .73633 .37574 Mtetra
.135 0 0 r
.73633 .37574 .7388 .3717 .74242 .37124 .73997 .37528 Mtetra
0 0 0 r
.73997 .37528 .74242 .37124 .74561 .3679 .74316 .37193 Mtetra
.76 .849 .403 r
.74316 .37193 .74561 .3679 .74836 .36191 .74594 .36591 Mtetra
.915 .861 .421 r
.74594 .36591 .74836 .36191 .75079 .35396 .74838 .35791 Mtetra
.951 .845 .418 r
.74838 .35791 .75079 .35396 .75305 .3451 .75066 .34899 Mtetra
.944 .85 .419 r
.75066 .34899 .75305 .3451 .75533 .3365 .75296 .34035 Mtetra
.88 .866 .421 r
.75296 .34035 .75533 .3365 .75783 .32929 .75547 .33309 Mtetra
.642 .812 .382 r
.75547 .33309 .75783 .32929 .76071 .32431 .75837 .32809 Mtetra
0 0 0 r
.75837 .32809 .76071 .32431 .76407 .32204 .76174 .32581 Mtetra
.24 0 0 r
.76174 .32581 .76407 .32204 .76792 .32251 .76561 .32629 Mtetra
.428 0 .002 r
.76561 .32629 .76792 .32251 .77223 .32528 .76992 .32909 Mtetra
.504 .019 .037 r
.76992 .32909 .77223 .32528 .77684 .32953 .77455 .33339 Mtetra
.519 .034 .044 r
.77455 .33339 .77684 .32953 .78158 .33418 .77929 .33809 Mtetra
.481 0 .027 r
.77929 .33809 .78158 .33418 .78621 .33804 .78393 .34199 Mtetra
.369 0 0 r
.78393 .34199 .78621 .33804 .79052 .34003 .78825 .34401 Mtetra
.116 0 0 r
.78825 .34401 .79052 .34003 .79436 .33941 .79211 .34339 Mtetra
.868 .941 .572 r
.35067 .76228 .35458 .7571 .35734 .75184 .35344 .757 Mtetra
.991 .885 .602 r
.35344 .757 .35734 .75184 .3603 .74369 .35642 .7488 Mtetra
.99 .823 .584 r
.35642 .7488 .3603 .74369 .36338 .73348 .35953 .73854 Mtetra
.984 .799 .575 r
.35953 .73854 .36338 .73348 .3665 .72241 .36268 .7274 Mtetra
.986 .808 .579 r
.36268 .7274 .3665 .72241 .36958 .7118 .36578 .71672 Mtetra
.993 .853 .594 r
.36578 .71672 .36958 .7118 .37254 .70285 .36876 .70772 Mtetra
.959 .933 .606 r
.36876 .70772 .37254 .70285 .37532 .69647 .37156 .70131 Mtetra
0 0 0 r
.37156 .70131 .37532 .69647 .37791 .69313 .37416 .69796 Mtetra
.155 0 0 r
.37416 .69796 .37791 .69313 .38033 .69279 .37658 .69763 Mtetra
.441 .027 .157 r
.37658 .69763 .38033 .69279 .38261 .69492 .37886 .69978 Mtetra
.532 .126 .217 r
.37886 .69978 .38261 .69492 .38482 .69855 .38107 .70344 Mtetra
.544 .139 .225 r
.38107 .70344 .38482 .69855 .38704 .70245 .38328 .70739 Mtetra
.489 .078 .188 r
.38328 .70739 .38704 .70245 .38933 .70533 .38557 .7103 Mtetra
.305 0 .071 r
.38557 .7103 .38933 .70533 .39176 .70606 .388 .71104 Mtetra
0 0 0 r
.388 .71104 .39176 .70606 .39435 .70387 .39059 .70885 Mtetra
.868 .938 .566 r
.39059 .70885 .39435 .70387 .3971 .69856 .39336 .70351 Mtetra
.991 .887 .592 r
.39336 .70351 .3971 .69856 .39998 .69048 .39626 .69538 Mtetra
.993 .828 .575 r
.39626 .69538 .39998 .69048 .40295 .68048 .39925 .68533 Mtetra
.989 .808 .567 r
.39925 .68533 .40295 .68048 .40593 .66977 .40226 .67455 Mtetra
.992 .82 .572 r
.40226 .67455 .40593 .66977 .40887 .65962 .40523 .66435 Mtetra
.994 .87 .589 r
.40523 .66435 .40887 .65962 .41172 .65121 .4081 .65589 Mtetra
.927 .941 .59 r
.4081 .65589 .41172 .65121 .41445 .64538 .41084 .65003 Mtetra
0 0 0 r
.41084 .65003 .41445 .64538 .41705 .64254 .41345 .64718 Mtetra
.216 0 .001 r
.41345 .64718 .41705 .64254 .41954 .6426 .41594 .64725 Mtetra
.458 .038 .153 r
.41594 .64725 .41954 .6426 .42194 .645 .41834 .64968 Mtetra
.536 .123 .204 r
.41834 .64968 .42194 .645 .42432 .64876 .42071 .65347 Mtetra
.541 .129 .208 r
.42071 .65347 .42432 .64876 .42671 .65267 .4231 .65742 Mtetra
.48 .061 .168 r
.4231 .65742 .42671 .65267 .42916 .65545 .42555 .66023 Mtetra
.285 0 .045 r
.42555 .66023 .42916 .65545 .4317 .65603 .42809 .66082 Mtetra
0 0 0 r
.42809 .66082 .4317 .65603 .43435 .65371 .43075 .6585 Mtetra
.866 .934 .557 r
.43075 .6585 .43435 .65371 .4371 .64834 .43351 .6531 Mtetra
.99 .888 .58 r
.43351 .6531 .4371 .64834 .43991 .64031 .43635 .64502 Mtetra
.996 .834 .565 r
.43635 .64502 .43991 .64031 .44277 .63051 .43923 .63517 Mtetra
.994 .816 .558 r
.43923 .63517 .44277 .63051 .44563 .62012 .44211 .62472 Mtetra
.996 .833 .564 r
.44211 .62472 .44563 .62012 .44845 .61042 .44495 .61496 Mtetra
.991 .886 .581 r
.44495 .61496 .44845 .61042 .45121 .60251 .44774 .60701 Mtetra
.877 .938 .566 r
.44774 .60701 .45121 .60251 .45391 .5972 .45045 .60167 Mtetra
0 0 0 r
.45045 .60167 .45391 .5972 .45654 .59483 .45309 .59929 Mtetra
.266 0 .019 r
.45309 .59929 .45654 .59483 .45913 .59527 .45568 .59975 Mtetra
.472 .046 .147 r
.45568 .59975 .45913 .59527 .46169 .59793 .45823 .60243 Mtetra
.539 .118 .19 r
.45823 .60243 .46169 .59793 .46425 .60181 .46079 .60636 Mtetra
.538 .117 .19 r
.46079 .60636 .46425 .60181 .46683 .60572 .46336 .6103 Mtetra
.47 .043 .146 r
.46336 .6103 .46683 .60572 .46945 .6084 .46598 .61301 Mtetra
.263 0 .02 r
.46598 .61301 .46945 .6084 .47212 .60884 .46866 .61346 Mtetra
0 0 0 r
.46866 .61346 .47212 .60884 .47483 .60638 .47138 .611 Mtetra
.862 .929 .546 r
.47138 .611 .47483 .60638 .47757 .60094 .47413 .60553 Mtetra
.988 .889 .567 r
.47413 .60553 .47757 .60094 .48033 .59295 .47691 .59749 Mtetra
.998 .839 .553 r
.47691 .59749 .48033 .59295 .48308 .58332 .47969 .58781 Mtetra
.997 .825 .548 r
.47969 .58781 .48308 .58332 .48582 .57325 .48245 .57768 Mtetra
.998 .845 .555 r
.48245 .57768 .48582 .57325 .48854 .56396 .48519 .56833 Mtetra
.981 .901 .57 r
.48519 .56833 .48854 .56396 .49124 .55653 .48791 .56086 Mtetra
.806 .92 .533 r
.48791 .56086 .49124 .55653 .49394 .5517 .49062 .55601 Mtetra
0 0 0 r
.49062 .55601 .49394 .5517 .49663 .54977 .49332 .55408 Mtetra
.307 0 .03 r
.49332 .55408 .49663 .54977 .49935 .55058 .49604 .55491 Mtetra
.484 .05 .138 r
.49604 .55491 .49935 .55058 .50209 .55349 .49877 .55784 Mtetra
.541 .111 .174 r
.49877 .55784 .50209 .55349 .50485 .55749 .50154 .56189 Mtetra
.534 .104 .17 r
.50154 .56189 .50485 .55749 .50765 .56139 .50433 .56582 Mtetra
.459 .024 .123 r
.50433 .56582 .50765 .56139 .51045 .56398 .50713 .56844 Mtetra
.241 0 0 r
.50713 .56844 .51045 .56398 .51325 .56427 .50994 .56874 Mtetra
0 0 0 r
.50994 .56874 .51325 .56427 .51603 .56168 .51272 .56614 Mtetra
.856 .923 .532 r
.51272 .56614 .51603 .56168 .51877 .55616 .51548 .56059 Mtetra
.985 .889 .552 r
.51548 .56059 .51877 .55616 .52147 .5482 .5182 .55259 Mtetra
.999 .844 .539 r
.5182 .55259 .52147 .5482 .52413 .53873 .52088 .54307 Mtetra
.999 .833 .535 r
.52088 .54307 .52413 .53873 .52676 .52894 .52353 .53322 Mtetra
.997 .857 .544 r
.52353 .53322 .52676 .52894 .5294 .52004 .52619 .52427 Mtetra
.963 .912 .556 r
.52619 .52427 .5294 .52004 .53206 .51306 .52887 .51725 Mtetra
.716 .884 .49 r
.52887 .51725 .53206 .51306 .53478 .50869 .5316 .51286 Mtetra
0 0 0 r
.5316 .51286 .53478 .50869 .53757 .5072 .5344 .51137 Mtetra
.34 0 .035 r
.5344 .51137 .53757 .5072 .54044 .50836 .53728 .51255 Mtetra
.493 .051 .127 r
.53728 .51255 .54044 .50836 .54339 .5115 .54023 .51572 Mtetra
.541 .103 .157 r
.54023 .51572 .54339 .5115 .5464 .51562 .54323 .51988 Mtetra
.529 .09 .149 r
.54323 .51988 .5464 .51562 .54942 .51952 .54625 .52382 Mtetra
.447 .003 .1 r
.54625 .52382 .54942 .51952 .55243 .52201 .54926 .52634 Mtetra
.219 0 0 r
.54926 .52634 .55243 .52201 .55537 .52215 .5522 .52649 Mtetra
0 0 0 r
.5522 .52649 .55537 .52215 .55822 .51942 .55506 .52375 Mtetra
.847 .915 .515 r
.55506 .52375 .55822 .51942 .56096 .51381 .55782 .51812 Mtetra
.98 .889 .534 r
.55782 .51812 .56096 .51381 .5636 .50587 .56048 .51013 Mtetra
.998 .849 .523 r
.56048 .51013 .5636 .50587 .56617 .49655 .56307 .50075 Mtetra
.999 .841 .521 r
.56307 .50075 .56617 .49655 .56871 .48703 .56563 .49117 Mtetra
.992 .868 .53 r
.56563 .49117 .56871 .48703 .57128 .47849 .56822 .48258 Mtetra
.934 .917 .537 r
.56822 .48258 .57128 .47849 .57393 .47194 .57089 .476 Mtetra
.608 .83 .441 r
.57089 .476 .57393 .47194 .5767 .46802 .57367 .47206 Mtetra
.018 0 0 r
.57367 .47206 .5767 .46802 .57963 .46694 .5766 .47098 Mtetra
.367 0 .035 r
.5766 .47098 .57963 .46694 .58269 .46843 .57967 .4725 Mtetra
.499 .049 .113 r
.57967 .4725 .58269 .46843 .58589 .47181 .58287 .47591 Mtetra
.54 .092 .137 r
.58287 .47591 .58589 .47181 .58916 .47604 .58614 .48018 Mtetra
.522 .074 .127 r
.58614 .48018 .58916 .47604 .59244 .47994 .58942 .48412 Mtetra
.434 0 .075 r
.58942 .48412 .59244 .47994 .59566 .48233 .59264 .48654 Mtetra
.196 0 0 r
.59264 .48654 .59566 .48233 .59876 .48233 .59574 .48655 Mtetra
0 0 0 r
.59574 .48655 .59876 .48233 .60168 .47945 .59868 .48366 Mtetra
.835 .905 .496 r
.59868 .48366 .60168 .47945 .60443 .47375 .60144 .47793 Mtetra
.972 .887 .514 r
.60144 .47793 .60443 .47375 .60701 .46582 .60405 .46995 Mtetra
.994 .852 .505 r
.60405 .46995 .60701 .46582 .6095 .45662 .60655 .4607 Mtetra
.995 .848 .503 r
.60655 .4607 .6095 .45662 .61196 .44734 .60904 .45137 Mtetra
.981 .877 .512 r
.60904 .45137 .61196 .44734 .61448 .43915 .61158 .44313 Mtetra
.89 .913 .512 r
.61158 .44313 .61448 .43915 .61715 .43301 .61426 .43695 Mtetra
0 0 0 r
.61426 .43695 .61715 .43301 .62001 .42951 .61713 .43345 Mtetra
.09 0 0 r
.61713 .43345 .62001 .42951 .6231 .42883 .62022 .43277 Mtetra
.389 0 .031 r
.62022 .43277 .6231 .42883 .6264 .43066 .62353 .43462 Mtetra
.504 .045 .096 r
.62353 .43462 .6264 .43066 .62988 .43427 .62701 .43827 Mtetra
.537 .08 .116 r
.62701 .43827 .62988 .43427 .63345 .43861 .63059 .44265 Mtetra
.514 .056 .102 r
.63059 .44265 .63345 .43861 .63702 .4425 .63416 .44658 Mtetra
.419 0 .049 r
.63416 .44658 .63702 .4425 .64048 .44481 .63762 .44891 Mtetra
.174 0 0 r
.63762 .44891 .64048 .44481 .64374 .44465 .64088 .44877 Mtetra
0 0 0 r
.64088 .44877 .64374 .44465 .64674 .44162 .64391 .44573 Mtetra
.819 .893 .474 r
.64391 .44573 .64674 .44162 .6495 .43583 .64667 .4399 Mtetra
.961 .882 .49 r
.64667 .4399 .6495 .43583 .65203 .42789 .64923 .43191 Mtetra
.987 .853 .483 r
.64923 .43191 .65203 .42789 .65444 .4188 .65165 .42277 Mtetra
.987 .853 .482 r
.65165 .42277 .65444 .4188 .65684 .40975 .65407 .41366 Mtetra
.962 .882 .491 r
.65407 .41366 .65684 .40975 .65933 .40188 .65658 .40576 Mtetra
.829 .897 .48 r
.65658 .40576 .65933 .40188 .66204 .39613 .6593 .39998 Mtetra
0 0 0 r
.6593 .39998 .66204 .39613 .66502 .39306 .6623 .39689 Mtetra
.15 0 0 r
.6623 .39689 .66502 .39306 .66832 .39277 .66561 .39661 Mtetra
.406 0 .023 r
.66561 .39661 .66832 .39277 .67191 .39492 .6692 .39879 Mtetra
.507 .039 .077 r
.6692 .39879 .67191 .39492 .67572 .39875 .67301 .40266 Mtetra
.533 .067 .092 r
.67301 .40266 .67572 .39875 .67963 .40321 .67693 .40716 Mtetra
.505 .037 .077 r
.67693 .40716 .67963 .40321 .68351 .4071 .68081 .41109 Mtetra
.404 0 .023 r
.68081 .41109 .68351 .4071 .68723 .40931 .68454 .41332 Mtetra
.152 0 0 r
.68454 .41332 .68723 .40931 .69067 .40901 .68799 .41303 Mtetra
0 0 0 r
.68799 .41303 .69067 .40901 .69377 .40582 .6911 .40983 Mtetra
.8 .878 .448 r
.6911 .40983 .69377 .40582 .69653 .39992 .69387 .4039 Mtetra
.945 .875 .463 r
.69387 .4039 .69653 .39992 .69902 .39195 .69638 .39589 Mtetra
.976 .852 .457 r
.69638 .39589 .69902 .39195 .70136 .38296 .69874 .38684 Mtetra
.973 .855 .458 r
.69874 .38684 .70136 .38296 .70369 .37412 .70109 .37794 Mtetra
.933 .881 .465 r
.70109 .37794 .70369 .37412 .70619 .36656 .70361 .37035 Mtetra
.752 .869 .443 r
.70361 .37035 .70619 .36656 .70897 .36119 .7064 .36495 Mtetra
0 0 0 r
.7064 .36495 .70897 .36119 .71212 .35852 .70957 .36227 Mtetra
.199 0 0 r
.70957 .36227 .71212 .35852 .71568 .35862 .71313 .36238 Mtetra
.42 0 .01 r
.71313 .36238 .71568 .35862 .7196 .36109 .71706 .36488 Mtetra
.508 .03 .056 r
.71706 .36488 .7196 .36109 .72379 .36516 .72125 .36899 Mtetra
.528 .051 .067 r
.72125 .36899 .72379 .36516 .72809 .36974 .72556 .37361 Mtetra
.495 .017 .049 r
.72556 .37361 .72809 .36974 .73233 .37363 .7298 .37754 Mtetra
.388 0 0 r
.7298 .37754 .73233 .37363 .73633 .37574 .73382 .37968 Mtetra
.131 0 0 r
.73382 .37968 .73633 .37574 .73997 .37528 .73747 .37923 Mtetra
0 0 0 r
.73747 .37923 .73997 .37528 .74316 .37193 .74068 .37587 Mtetra
.777 .86 .419 r
.74068 .37587 .74316 .37193 .74594 .36591 .74346 .36981 Mtetra
.925 .865 .432 r
.74346 .36981 .74594 .36591 .74838 .35791 .74593 .36176 Mtetra
.958 .847 .427 r
.74593 .36176 .74838 .35791 .75066 .34899 .74822 .35279 Mtetra
.952 .852 .428 r
.74822 .35279 .75066 .34899 .75296 .34035 .75054 .34409 Mtetra
.892 .872 .434 r
.75054 .34409 .75296 .34035 .75547 .33309 .75307 .3368 Mtetra
.661 .826 .401 r
.75307 .3368 .75547 .33309 .75837 .32809 .75598 .33177 Mtetra
0 0 0 r
.75598 .33177 .75837 .32809 .76174 .32581 .75936 .32949 Mtetra
.238 0 0 r
.75936 .32949 .76174 .32581 .76561 .32629 .76324 .32998 Mtetra
.43 0 0 r
.76324 .32998 .76561 .32629 .76992 .32909 .76757 .33282 Mtetra
.506 .018 .032 r
.76757 .33282 .76992 .32909 .77455 .33339 .7722 .33716 Mtetra
.521 .033 .039 r
.7722 .33716 .77455 .33339 .77929 .33809 .77695 .3419 Mtetra
.483 0 .021 r
.77695 .3419 .77929 .33809 .78393 .34199 .7816 .34584 Mtetra
.37 0 0 r
.7816 .34584 .78393 .34199 .78825 .34401 .78594 .34788 Mtetra
.111 0 0 r
.78594 .34788 .78825 .34401 .79211 .34339 .7898 .34728 Mtetra
.946 .958 .679 r
.34683 .76604 .35067 .76228 .35344 .757 .34962 .76074 Mtetra
.981 .843 .633 r
.34962 .76074 .35344 .757 .35642 .7488 .35262 .7525 Mtetra
.967 .781 .6 r
.35262 .7525 .35642 .7488 .35953 .73854 .35575 .74219 Mtetra
.96 .759 .588 r
.35575 .74219 .35953 .73854 .36268 .7274 .35892 .731 Mtetra
.963 .768 .592 r
.35892 .731 .36268 .7274 .36578 .71672 .36205 .72027 Mtetra
.975 .81 .616 r
.36205 .72027 .36578 .71672 .36876 .70772 .36505 .71123 Mtetra
.979 .905 .665 r
.36505 .71123 .36876 .70772 .37156 .70131 .36786 .70479 Mtetra
.738 .948 .635 r
.36786 .70479 .37156 .70131 .37416 .69796 .37047 .70143 Mtetra
.117 0 0 r
.37047 .70143 .37416 .69796 .37658 .69763 .37289 .7011 Mtetra
.469 .025 .11 r
.37289 .7011 .37658 .69763 .37886 .69978 .37517 .70327 Mtetra
.566 .138 .188 r
.37517 .70327 .37886 .69978 .38107 .70344 .37737 .70696 Mtetra
.578 .152 .197 r
.37737 .70696 .38107 .70344 .38328 .70739 .37957 .71093 Mtetra
.52 .084 .151 r
.37957 .71093 .38328 .70739 .38557 .7103 .38186 .71387 Mtetra
.309 0 0 r
.38186 .71387 .38557 .7103 .388 .71104 .38428 .71462 Mtetra
0 0 0 r
.38428 .71462 .388 .71104 .39059 .70885 .38688 .71243 Mtetra
.947 .956 .674 r
.38688 .71243 .39059 .70885 .39336 .70351 .38966 .70707 Mtetra
.984 .846 .626 r
.38966 .70707 .39336 .70351 .39626 .69538 .39259 .6989 Mtetra
.972 .786 .594 r
.39259 .6989 .39626 .69538 .39925 .68533 .3956 .6888 Mtetra
.967 .767 .583 r
.3956 .6888 .39925 .68533 .40226 .67455 .39863 .67798 Mtetra
.97 .779 .59 r
.39863 .67798 .40226 .67455 .40523 .66435 .40162 .66772 Mtetra
.981 .828 .617 r
.40162 .66772 .40523 .66435 .4081 .65589 .40451 .65922 Mtetra
.971 .93 .669 r
.40451 .65922 .4081 .65589 .41084 .65003 .40726 .65334 Mtetra
.61 .891 .582 r
.40726 .65334 .41084 .65003 .41345 .64718 .40988 .65048 Mtetra
.197 0 0 r
.40988 .65048 .41345 .64718 .41594 .64725 .41237 .65056 Mtetra
.487 .037 .108 r
.41237 .65056 .41594 .64725 .41834 .64968 .41477 .65301 Mtetra
.57 .134 .173 r
.41477 .65301 .41834 .64968 .42071 .65347 .41713 .65683 Mtetra
.575 .14 .178 r
.41713 .65683 .42071 .65347 .4231 .65742 .41951 .66081 Mtetra
.511 .064 .126 r
.41951 .66081 .4231 .65742 .42555 .66023 .42196 .66364 Mtetra
.283 0 0 r
.42196 .66364 .42555 .66023 .42809 .66082 .4245 .66425 Mtetra
0 0 0 r
.4245 .66425 .42809 .66082 .43075 .6585 .42716 .66192 Mtetra
.948 .955 .666 r
.42716 .66192 .43075 .6585 .43351 .6531 .42994 .65649 Mtetra
.987 .85 .618 r
.42994 .65649 .43351 .6531 .43635 .64502 .43279 .64838 Mtetra
.978 .793 .587 r
.43279 .64838 .43635 .64502 .43923 .63517 .43569 .63848 Mtetra
.973 .776 .577 r
.43569 .63848 .43923 .63517 .44211 .62472 .4386 .62799 Mtetra
.978 .792 .586 r
.4386 .62799 .44211 .62472 .44495 .61496 .44146 .61818 Mtetra
.987 .848 .618 r
.44146 .61818 .44495 .61496 .44774 .60701 .44427 .61019 Mtetra
.952 .953 .67 r
.44427 .61019 .44774 .60701 .45045 .60167 .44699 .60483 Mtetra
0 0 0 r
.44699 .60483 .45045 .60167 .45309 .59929 .44964 .60245 Mtetra
.26 0 0 r
.44964 .60245 .45309 .59929 .45568 .59975 .45222 .60291 Mtetra
.502 .046 .101 r
.45222 .60291 .45568 .59975 .45823 .60243 .45478 .60562 Mtetra
.572 .128 .157 r
.45478 .60562 .45823 .60243 .46079 .60636 .45732 .60957 Mtetra
.572 .127 .156 r
.45732 .60957 .46079 .60636 .46336 .6103 .4599 .61354 Mtetra
.499 .043 .1 r
.4599 .61354 .46336 .6103 .46598 .61301 .46251 .61628 Mtetra
.256 0 0 r
.46251 .61628 .46598 .61301 .46866 .61346 .46518 .61674 Mtetra
0 0 0 r
.46518 .61674 .46866 .61346 .47138 .611 .46791 .61427 Mtetra
.947 .954 .658 r
.46791 .61427 .47138 .611 .47413 .60553 .47068 .60877 Mtetra
.99 .854 .61 r
.47068 .60877 .47413 .60553 .47691 .59749 .47347 .60071 Mtetra
.983 .799 .579 r
.47347 .60071 .47691 .59749 .47969 .58781 .47627 .59098 Mtetra
.98 .785 .571 r
.47627 .59098 .47969 .58781 .48245 .57768 .47906 .5808 Mtetra
.984 .806 .583 r
.47906 .5808 .48245 .57768 .48519 .56833 .48182 .57141 Mtetra
.989 .869 .619 r
.48182 .57141 .48519 .56833 .48791 .56086 .48456 .5639 Mtetra
.917 .968 .666 r
.48456 .5639 .48791 .56086 .49062 .55601 .48727 .55903 Mtetra
0 0 0 r
.48727 .55903 .49062 .55601 .49332 .55408 .48998 .55711 Mtetra
.31 0 0 r
.48998 .55711 .49332 .55408 .49604 .55491 .4927 .55794 Mtetra
.514 .051 .091 r
.4927 .55794 .49604 .55491 .49877 .55784 .49543 .5609 Mtetra
.573 .12 .138 r
.49543 .5609 .49877 .55784 .50154 .56189 .49819 .56497 Mtetra
.567 .112 .133 r
.49819 .56497 .50154 .56189 .50433 .56582 .50097 .56894 Mtetra
.487 .02 .071 r
.50097 .56894 .50433 .56582 .50713 .56844 .50378 .57158 Mtetra
.228 0 0 r
.50378 .57158 .50713 .56844 .50994 .56874 .50658 .57189 Mtetra
0 0 0 r
.50658 .57189 .50994 .56874 .51272 .56614 .50938 .56928 Mtetra
.946 .952 .648 r
.50938 .56928 .51272 .56614 .51548 .56059 .51215 .56371 Mtetra
.992 .858 .6 r
.51215 .56371 .51548 .56059 .5182 .55259 .51488 .55567 Mtetra
.988 .806 .57 r
.51488 .55567 .5182 .55259 .52088 .54307 .51758 .5461 Mtetra
.986 .795 .564 r
.51758 .5461 .52088 .54307 .52353 .53322 .52026 .53621 Mtetra
.99 .82 .579 r
.52026 .53621 .52353 .53322 .52619 .52427 .52293 .52721 Mtetra
.988 .89 .619 r
.52293 .52721 .52619 .52427 .52887 .51725 .52563 .52016 Mtetra
.862 .971 .655 r
.52563 .52016 .52887 .51725 .5316 .51286 .52837 .51576 Mtetra
0 0 0 r
.52837 .51576 .5316 .51286 .5344 .51137 .53117 .51427 Mtetra
.349 0 0 r
.53117 .51427 .5344 .51137 .53728 .51255 .53405 .51546 Mtetra
.523 .052 .078 r
.53405 .51546 .53728 .51255 .54023 .51572 .537 .51866 Mtetra
.573 .111 .118 r
.537 .51866 .54023 .51572 .54323 .51988 .53999 .52285 Mtetra
.561 .096 .108 r
.53999 .52285 .54323 .51988 .54625 .52382 .54301 .52681 Mtetra
.473 0 .042 r
.54301 .52681 .54625 .52382 .54926 .52634 .54602 .52936 Mtetra
.198 0 0 r
.54602 .52936 .54926 .52634 .5522 .52649 .54897 .52952 Mtetra
.501 .827 .524 r
.54897 .52952 .5522 .52649 .55506 .52375 .55183 .52677 Mtetra
.943 .95 .636 r
.55183 .52677 .55506 .52375 .55782 .51812 .5546 .52111 Mtetra
.994 .862 .589 r
.5546 .52111 .55782 .51812 .56048 .51013 .55728 .51309 Mtetra
.993 .814 .56 r
.55728 .51309 .56048 .51013 .56307 .50075 .55989 .50367 Mtetra
.992 .806 .556 r
.55989 .50367 .56307 .50075 .56563 .49117 .56247 .49404 Mtetra
.995 .836 .574 r
.56247 .49404 .56563 .49117 .56822 .48258 .56508 .48541 Mtetra
.982 .911 .619 r
.56508 .48541 .56822 .48258 .57089 .476 .56776 .4788 Mtetra
.783 .956 .633 r
.56776 .4788 .57089 .476 .57367 .47206 .57056 .47485 Mtetra
0 0 0 r
.57056 .47485 .57367 .47206 .5766 .47098 .57349 .47377 Mtetra
.38 0 0 r
.57349 .47377 .5766 .47098 .57967 .4725 .57656 .4753 Mtetra
.529 .05 .062 r
.57656 .4753 .57967 .4725 .58287 .47591 .57975 .47874 Mtetra
.571 .099 .095 r
.57975 .47874 .58287 .47591 .58614 .48018 .58302 .48304 Mtetra
.553 .078 .081 r
.58302 .48304 .58614 .48018 .58942 .48412 .5863 .487 Mtetra
.457 0 .01 r
.5863 .487 .58942 .48412 .59264 .48654 .58952 .48945 Mtetra
.169 0 0 r
.58952 .48945 .59264 .48654 .59574 .48655 .59263 .48946 Mtetra
.517 .835 .53 r
.59263 .48946 .59574 .48655 .59868 .48366 .59557 .48657 Mtetra
.939 .948 .622 r
.59557 .48657 .59868 .48366 .60144 .47793 .59835 .48082 Mtetra
.995 .866 .576 r
.59835 .48082 .60144 .47793 .60405 .46995 .60097 .4728 Mtetra
.997 .821 .549 r
.60097 .4728 .60405 .46995 .60655 .4607 .60349 .4635 Mtetra
.996 .817 .546 r
.60349 .4635 .60655 .4607 .60904 .45137 .60599 .45413 Mtetra
.997 .852 .568 r
.60599 .45413 .60904 .45137 .61158 .44313 .60855 .44585 Mtetra
.966 .93 .615 r
.60855 .44585 .61158 .44313 .61426 .43695 .61124 .43965 Mtetra
.68 .919 .599 r
.61124 .43965 .61426 .43695 .61713 .43345 .61413 .43613 Mtetra
.03 0 0 r
.61413 .43613 .61713 .43345 .62022 .43277 .61723 .43546 Mtetra
.405 0 0 r
.61723 .43546 .62022 .43277 .62353 .43462 .62054 .43733 Mtetra
.533 .045 .044 r
.62054 .43733 .62353 .43462 .62701 .43827 .62402 .441 Mtetra
.568 .085 .069 r
.62402 .441 .62701 .43827 .63059 .44265 .62759 .44541 Mtetra
.544 .058 .052 r
.62759 .44541 .63059 .44265 .63416 .44658 .63115 .44937 Mtetra
.44 0 0 r
.63115 .44937 .63416 .44658 .63762 .44891 .63462 .45172 Mtetra
.139 0 0 r
.63462 .45172 .63762 .44891 .64088 .44877 .63789 .45159 Mtetra
.529 .84 .531 r
.63789 .45159 .64088 .44877 .64391 .44573 .64092 .44854 Mtetra
.933 .945 .606 r
.64092 .44854 .64391 .44573 .64667 .4399 .6437 .44269 Mtetra
.995 .87 .561 r
.6437 .44269 .64667 .4399 .64923 .43191 .64627 .43466 Mtetra
.999 .828 .535 r
.64627 .43466 .64923 .43191 .65165 .42277 .64872 .42547 Mtetra
.999 .828 .534 r
.64872 .42547 .65165 .42277 .65407 .41366 .65115 .41633 Mtetra
.995 .868 .56 r
.65115 .41633 .65407 .41366 .65658 .40576 .65368 .40838 Mtetra
.938 .944 .609 r
.65368 .40838 .65658 .40576 .6593 .39998 .65641 .40258 Mtetra
.56 .862 .556 r
.65641 .40258 .6593 .39998 .6623 .39689 .65942 .39948 Mtetra
.108 0 0 r
.65942 .39948 .6623 .39689 .66561 .39661 .66273 .3992 Mtetra
.424 0 0 r
.66273 .3992 .66561 .39661 .6692 .39879 .66633 .4014 Mtetra
.535 .038 .022 r
.66633 .4014 .6692 .39879 .67301 .40266 .67013 .4053 Mtetra
.562 .069 .042 r
.67013 .4053 .67301 .40266 .67693 .40716 .67405 .40984 Mtetra
.533 .036 .021 r
.67405 .40984 .67693 .40716 .68081 .41109 .67794 .4138 Mtetra
.421 0 0 r
.67794 .4138 .68081 .41109 .68454 .41332 .68167 .41605 Mtetra
.11 0 0 r
.68167 .41605 .68454 .41332 .68799 .41303 .68512 .41576 Mtetra
.535 .842 .528 r
.68512 .41576 .68799 .41303 .6911 .40983 .68824 .41255 Mtetra
.924 .94 .587 r
.68824 .41255 .6911 .40983 .69387 .4039 .69103 .40659 Mtetra
.992 .873 .543 r
.69103 .40659 .69387 .4039 .69638 .39589 .69355 .39854 Mtetra
.999 .835 .519 r
.69355 .39854 .69638 .39589 .69874 .38684 .69593 .38945 Mtetra
.999 .839 .521 r
.69593 .38945 .69874 .38684 .70109 .37794 .6983 .38052 Mtetra
.988 .884 .551 r
.6983 .38052 .70109 .37794 .70361 .37035 .70083 .37289 Mtetra
.894 .949 .597 r
.70083 .37289 .70361 .37035 .7064 .36495 .70364 .36746 Mtetra
0 0 0 r
.70364 .36746 .7064 .36495 .70957 .36227 .70681 .36478 Mtetra
.171 0 0 r
.70681 .36478 .70957 .36227 .71313 .36238 .71038 .36489 Mtetra
.438 0 0 r
.71038 .36489 .71313 .36238 .71706 .36488 .71431 .36742 Mtetra
.534 .027 0 r
.71431 .36742 .71706 .36488 .72125 .36899 .71851 .37156 Mtetra
.556 .051 .012 r
.71851 .37156 .72125 .36899 .72556 .37361 .72282 .37621 Mtetra
.521 .013 0 r
.72282 .37621 .72556 .37361 .7298 .37754 .72706 .38017 Mtetra
.401 0 0 r
.72706 .38017 .7298 .37754 .73382 .37968 .73108 .38233 Mtetra
.083 0 0 r
.73108 .38233 .73382 .37968 .73747 .37923 .73474 .38188 Mtetra
.538 .84 .52 r
.73474 .38188 .73747 .37923 .74068 .37587 .73796 .37851 Mtetra
.913 .934 .564 r
.73796 .37851 .74068 .37587 .74346 .36981 .74076 .37243 Mtetra
.987 .874 .522 r
.74076 .37243 .74346 .36981 .74593 .36176 .74324 .36434 Mtetra
.997 .84 .499 r
.74324 .36434 .74593 .36176 .74822 .35279 .74555 .35533 Mtetra
.995 .848 .504 r
.74555 .35533 .74822 .35279 .75054 .34409 .74788 .34659 Mtetra
.974 .896 .538 r
.74788 .34659 .75054 .34409 .75307 .3368 .75043 .33926 Mtetra
.831 .942 .578 r
.75043 .33926 .75307 .3368 .75598 .33177 .75335 .33421 Mtetra
0 0 0 r
.75335 .33421 .75598 .33177 .75936 .32949 .75674 .33192 Mtetra
.22 0 0 r
.75674 .33192 .75936 .32949 .76324 .32998 .76063 .33243 Mtetra
.448 0 0 r
.76063 .33243 .76324 .32998 .76757 .33282 .76496 .33528 Mtetra
.531 .014 0 r
.76496 .33528 .76757 .33282 .7722 .33716 .7696 .33966 Mtetra
.547 .031 0 r
.7696 .33966 .7722 .33716 .77695 .3419 .77435 .34443 Mtetra
.507 0 0 r
.77435 .34443 .77695 .3419 .7816 .34584 .77901 .3484 Mtetra
.38 0 0 r
.77901 .3484 .7816 .34584 .78594 .34788 .78335 .35047 Mtetra
.057 0 0 r
.78335 .35047 .78594 .34788 .7898 .34728 .78723 .34986 Mtetra
.928 .848 .743 r
.34316 .76728 .34683 .76604 .34962 .76074 .34596 .76197 Mtetra
.92 .743 .646 r
.34596 .76197 .34962 .76074 .35262 .7525 .34897 .75371 Mtetra
.91 .7 .606 r
.34897 .75371 .35262 .7525 .35575 .74219 .35212 .74337 Mtetra
.906 .686 .593 r
.35212 .74337 .35575 .74219 .35892 .731 .35532 .73215 Mtetra
.908 .692 .599 r
.35532 .73215 .35892 .731 .36205 .72027 .35846 .72139 Mtetra
.915 .72 .625 r
.35846 .72139 .36205 .72027 .36505 .71123 .36148 .71232 Mtetra
.926 .791 .692 r
.36148 .71232 .36505 .71123 .36786 .70479 .3643 .70587 Mtetra
.881 .951 .85 r
.3643 .70587 .36786 .70479 .37047 .70143 .36692 .7025 Mtetra
0 0 0 r
.36692 .7025 .37047 .70143 .37289 .7011 .36934 .70218 Mtetra
.532 .017 0 r
.36934 .70218 .37289 .7011 .37517 .70327 .37161 .70436 Mtetra
.64 .165 .111 r
.37161 .70436 .37517 .70327 .37737 .70696 .3738 .70806 Mtetra
.651 .182 .126 r
.3738 .70806 .37737 .70696 .37957 .71093 .37599 .71204 Mtetra
.592 .098 .05 r
.37599 .71204 .37957 .71093 .38186 .71387 .37826 .71499 Mtetra
.305 0 0 r
.37826 .71499 .38186 .71387 .38428 .71462 .38069 .71575 Mtetra
.71 .984 .887 r
.38069 .71575 .38428 .71462 .38688 .71243 .38329 .71355 Mtetra
.931 .847 .739 r
.38329 .71355 .38688 .71243 .38966 .70707 .38608 .70818 Mtetra
.924 .746 .642 r
.38608 .70818 .38966 .70707 .39259 .6989 .38902 .69999 Mtetra
.915 .704 .603 r
.38902 .69999 .39259 .6989 .3956 .6888 .39205 .68986 Mtetra
.912 .691 .591 r
.39205 .68986 .3956 .6888 .39863 .67798 .3951 .67901 Mtetra
.914 .699 .599 r
.3951 .67901 .39863 .67798 .40162 .66772 .39811 .66873 Mtetra
.921 .733 .631 r
.39811 .66873 .40162 .66772 .40451 .65922 .40101 .66021 Mtetra
.93 .815 .711 r
.40101 .66021 .40451 .65922 .40726 .65334 .40378 .65431 Mtetra
.832 .978 .881 r
.40378 .65431 .40726 .65334 .40988 .65048 .40639 .65144 Mtetra
.111 0 0 r
.40639 .65144 .40988 .65048 .41237 .65056 .40888 .65153 Mtetra
.551 .035 0 r
.40888 .65153 .41237 .65056 .41477 .65301 .41128 .65398 Mtetra
.642 .16 .092 r
.41128 .65398 .41477 .65301 .41713 .65683 .41363 .65782 Mtetra
.647 .167 .099 r
.41363 .65782 .41713 .65683 .41951 .66081 .416 .66181 Mtetra
.579 .071 .012 r
.416 .66181 .41951 .66081 .42196 .66364 .41844 .66465 Mtetra
.26 0 0 r
.41844 .66465 .42196 .66364 .4245 .66425 .42098 .66526 Mtetra
.733 .987 .892 r
.42098 .66526 .4245 .66425 .42716 .66192 .42364 .66293 Mtetra
.933 .848 .735 r
.42364 .66293 .42716 .66192 .42994 .65649 .42642 .65749 Mtetra
.929 .749 .639 r
.42642 .65749 .42994 .65649 .43279 .64838 .4293 .64936 Mtetra
.921 .709 .6 r
.4293 .64936 .43279 .64838 .43569 .63848 .43222 .63943 Mtetra
.918 .697 .589 r
.43222 .63943 .43569 .63848 .4386 .62799 .43514 .62891 Mtetra
.92 .708 .599 r
.43514 .62891 .4386 .62799 .44146 .61818 .43802 .61907 Mtetra
.928 .748 .638 r
.43802 .61907 .44146 .61818 .44427 .61019 .44084 .61107 Mtetra
.932 .843 .733 r
.44084 .61107 .44427 .61019 .44699 .60483 .44357 .60569 Mtetra
.752 .986 .901 r
.44357 .60569 .44699 .60483 .44964 .60245 .44622 .6033 Mtetra
.218 0 0 r
.44622 .6033 .44964 .60245 .45222 .60291 .4488 .60377 Mtetra
.566 .046 0 r
.4488 .60377 .45222 .60291 .45478 .60562 .45135 .60649 Mtetra
.642 .151 .07 r
.45135 .60649 .45478 .60562 .45732 .60957 .45389 .61045 Mtetra
.642 .15 .069 r
.45389 .61045 .45732 .60957 .4599 .61354 .45645 .61444 Mtetra
.563 .043 0 r
.45645 .61444 .4599 .61354 .46251 .61628 .45906 .61719 Mtetra
.212 0 0 r
.45906 .61719 .46251 .61628 .46518 .61674 .46173 .61765 Mtetra
.751 .988 .894 r
.46173 .61765 .46518 .61674 .46791 .61427 .46446 .61517 Mtetra
.937 .849 .731 r
.46446 .61517 .46791 .61427 .47068 .60877 .46724 .60967 Mtetra
.934 .753 .635 r
.46724 .60967 .47068 .60877 .47347 .60071 .47004 .60157 Mtetra
.926 .714 .596 r
.47004 .60157 .47347 .60071 .47627 .59098 .47286 .59182 Mtetra
.924 .704 .586 r
.47286 .59182 .47627 .59098 .47906 .5808 .47566 .58162 Mtetra
.927 .718 .6 r
.47566 .58162 .47906 .5808 .48182 .57141 .47844 .5722 Mtetra
.935 .765 .647 r
.47844 .5722 .48182 .57141 .48456 .5639 .48119 .56468 Mtetra
.93 .874 .76 r
.48119 .56468 .48456 .5639 .48727 .55903 .48392 .55979 Mtetra
.634 .962 .897 r
.48392 .55979 .48727 .55903 .48998 .55711 .48663 .55786 Mtetra
.296 0 0 r
.48663 .55786 .48998 .55711 .4927 .55794 .48934 .5587 Mtetra
.576 .052 0 r
.48934 .5587 .4927 .55794 .49543 .5609 .49207 .56167 Mtetra
.641 .141 .046 r
.49207 .56167 .49543 .5609 .49819 .56497 .49482 .56576 Mtetra
.634 .131 .037 r
.49482 .56576 .49819 .56497 .50097 .56894 .49759 .56974 Mtetra
.545 .011 0 r
.49759 .56974 .50097 .56894 .50378 .57158 .50039 .57239 Mtetra
.162 0 0 r
.50039 .57239 .50378 .57158 .50658 .57189 .50319 .5727 Mtetra
.766 .988 .894 r
.50319 .5727 .50658 .57189 .50938 .56928 .50599 .57009 Mtetra
.94 .852 .727 r
.50599 .57009 .50938 .56928 .51215 .56371 .50877 .5645 Mtetra
.939 .758 .63 r
.50877 .5645 .51215 .56371 .51488 .55567 .51151 .55644 Mtetra
.932 .719 .592 r
.51151 .55644 .51488 .55567 .51758 .5461 .51423 .54685 Mtetra
.931 .711 .584 r
.51423 .54685 .51758 .5461 .52026 .53621 .51693 .53693 Mtetra
.934 .729 .602 r
.51693 .53693 .52026 .53621 .52293 .52721 .51962 .52791 Mtetra
.941 .784 .658 r
.51962 .52791 .52293 .52721 .52563 .52016 .52233 .52084 Mtetra
.921 .907 .791 r
.52233 .52084 .52563 .52016 .52837 .51576 .52507 .51643 Mtetra
.485 .901 .864 r
.52507 .51643 .52837 .51576 .53117 .51427 .52788 .51493 Mtetra
.354 0 0 r
.52788 .51493 .53117 .51427 .53405 .51546 .53075 .51613 Mtetra
.583 .053 0 r
.53075 .51613 .53405 .51546 .537 .51866 .53369 .51934 Mtetra
.638 .128 .018 r
.53369 .51934 .537 .51866 .53999 .52285 .53668 .52354 Mtetra
.625 .11 .002 r
.53668 .52354 .53999 .52285 .54301 .52681 .53969 .52752 Mtetra
.524 0 0 r
.53969 .52752 .54301 .52681 .54602 .52936 .54269 .53007 Mtetra
.11 0 0 r
.54269 .53007 .54602 .52936 .54897 .52952 .54564 .53023 Mtetra
.779 .988 .893 r
.54564 .53023 .54897 .52952 .55183 .52677 .54851 .52748 Mtetra
.944 .855 .722 r
.54851 .52748 .55183 .52677 .5546 .52111 .55129 .52181 Mtetra
.945 .763 .626 r
.55129 .52181 .5546 .52111 .55728 .51309 .55398 .51376 Mtetra
.939 .726 .587 r
.55398 .51376 .55728 .51309 .55989 .50367 .5566 .50432 Mtetra
.938 .72 .581 r
.5566 .50432 .55989 .50367 .56247 .49404 .5592 .49467 Mtetra
.942 .742 .604 r
.5592 .49467 .56247 .49404 .56508 .48541 .56182 .48602 Mtetra
.947 .806 .672 r
.56182 .48602 .56508 .48541 .56776 .4788 .56452 .47938 Mtetra
.902 .939 .825 r
.56452 .47938 .56776 .4788 .57056 .47485 .56732 .47542 Mtetra
.324 .81 .806 r
.56732 .47542 .57056 .47485 .57349 .47377 .57025 .47435 Mtetra
.396 0 0 r
.57025 .47435 .57349 .47377 .57656 .4753 .57332 .47588 Mtetra
.587 .051 0 r
.57332 .47588 .57656 .4753 .57975 .47874 .57651 .47933 Mtetra
.632 .112 0 r
.57651 .47933 .57975 .47874 .58302 .48304 .57976 .48365 Mtetra
.613 .086 0 r
.57976 .48365 .58302 .48304 .5863 .487 .58303 .48762 Mtetra
.5 0 0 r
.58303 .48762 .5863 .487 .58952 .48945 .58625 .49008 Mtetra
.059 0 0 r
.58625 .49008 .58952 .48945 .59263 .48946 .58936 .49009 Mtetra
.789 .988 .89 r
.58936 .49009 .59263 .48946 .59557 .48657 .59231 .48719 Mtetra
.949 .859 .717 r
.59231 .48719 .59557 .48657 .59835 .48082 .59509 .48142 Mtetra
.951 .769 .62 r
.59509 .48142 .59835 .48082 .60097 .4728 .59772 .47339 Mtetra
.946 .732 .582 r
.59772 .47339 .60097 .4728 .60349 .4635 .60026 .46407 Mtetra
.945 .729 .579 r
.60026 .46407 .60349 .4635 .60599 .45413 .60278 .45466 Mtetra
.95 .757 .608 r
.60278 .45466 .60599 .45413 .60855 .44585 .60535 .44636 Mtetra
.951 .831 .689 r
.60535 .44636 .60855 .44585 .61124 .43965 .60806 .44015 Mtetra
.867 .968 .859 r
.60806 .44015 .61124 .43965 .61413 .43613 .61094 .43662 Mtetra
.173 .707 .737 r
.61094 .43662 .61413 .43613 .61723 .43546 .61404 .43595 Mtetra
.426 0 0 r
.61404 .43595 .61723 .43546 .62054 .43733 .61735 .43782 Mtetra
.587 .044 0 r
.61735 .43782 .62054 .43733 .62402 .441 .62082 .4415 Mtetra
.625 .094 0 r
.62082 .4415 .62402 .441 .62759 .44541 .62439 .44594 Mtetra
.599 .06 0 r
.62439 .44594 .62759 .44541 .63115 .44937 .62795 .44991 Mtetra
.474 0 0 r
.62795 .44991 .63115 .44937 .63462 .45172 .6314 .45227 Mtetra
.008 0 0 r
.6314 .45227 .63462 .45172 .63789 .45159 .63468 .45213 Mtetra
.798 .989 .886 r
.63468 .45213 .63789 .45159 .64092 .44854 .63771 .44907 Mtetra
.954 .863 .712 r
.63771 .44907 .64092 .44854 .6437 .44269 .6405 .44321 Mtetra
.958 .775 .614 r
.6405 .44321 .6437 .44269 .64627 .43466 .64308 .43516 Mtetra
.953 .74 .577 r
.64308 .43516 .64627 .43466 .64872 .42547 .64555 .42595 Mtetra
.953 .74 .576 r
.64555 .42595 .64872 .42547 .65115 .41633 .64799 .41678 Mtetra
.957 .774 .613 r
.64799 .41678 .65115 .41633 .65368 .40838 .65054 .40881 Mtetra
.953 .859 .71 r
.65054 .40881 .65368 .40838 .65641 .40258 .65328 .40299 Mtetra
.81 .985 .888 r
.65328 .40299 .65641 .40258 .65942 .39948 .65629 .39989 Mtetra
0 0 0 r
.65629 .39989 .65942 .39948 .66273 .3992 .6596 .39961 Mtetra
.447 0 0 r
.6596 .39961 .66273 .3992 .66633 .4014 .66319 .40182 Mtetra
.584 .034 0 r
.66319 .40182 .66633 .4014 .67013 .4053 .667 .40573 Mtetra
.615 .074 0 r
.667 .40573 .67013 .4053 .67405 .40984 .6709 .41028 Mtetra
.583 .032 0 r
.6709 .41028 .67405 .40984 .67794 .4138 .67479 .41425 Mtetra
.444 0 0 r
.67479 .41425 .67794 .4138 .68167 .41605 .67851 .41651 Mtetra
0 0 0 r
.67851 .41651 .68167 .41605 .68512 .41576 .68196 .41622 Mtetra
.805 .989 .882 r
.68196 .41622 .68512 .41576 .68824 .41255 .68509 .41301 Mtetra
.959 .869 .706 r
.68509 .41301 .68824 .41255 .69103 .40659 .68789 .40703 Mtetra
.964 .782 .608 r
.68789 .40703 .69103 .40659 .69355 .39854 .69043 .39896 Mtetra
.961 .748 .571 r
.69043 .39896 .69355 .39854 .69593 .38945 .69282 .38985 Mtetra
.961 .751 .574 r
.69282 .38985 .69593 .38945 .6983 .38052 .69521 .38089 Mtetra
.965 .793 .62 r
.69521 .38089 .6983 .38052 .70083 .37289 .69774 .37324 Mtetra
.951 .89 .734 r
.69774 .37324 .70083 .37289 .70364 .36746 .70056 .3678 Mtetra
.726 .982 .906 r
.70056 .3678 .70364 .36746 .70681 .36478 .70374 .36511 Mtetra
.059 0 0 r
.70374 .36511 .70681 .36478 .71038 .36489 .70731 .36522 Mtetra
.461 0 0 r
.70731 .36522 .71038 .36489 .71431 .36742 .71124 .36776 Mtetra
.578 .02 0 r
.71124 .36776 .71431 .36742 .71851 .37156 .71543 .37191 Mtetra
.602 .051 0 r
.71543 .37191 .71851 .37156 .72282 .37621 .71973 .37657 Mtetra
.563 .001 0 r
.71973 .37657 .72282 .37621 .72706 .38017 .72397 .38055 Mtetra
.413 0 0 r
.72397 .38055 .72706 .38017 .73108 .38233 .72799 .38271 Mtetra
0 0 0 r
.72799 .38271 .73108 .38233 .73474 .38188 .73164 .38227 Mtetra
.811 .991 .876 r
.73164 .38227 .73474 .38188 .73796 .37851 .73487 .37889 Mtetra
.964 .875 .699 r
.73487 .37889 .73796 .37851 .74076 .37243 .73768 .37278 Mtetra
.972 .79 .6 r
.73768 .37278 .74076 .37243 .74324 .36434 .74017 .36468 Mtetra
.969 .758 .564 r
.74017 .36468 .74324 .36434 .74555 .35533 .7425 .35564 Mtetra
.97 .765 .572 r
.7425 .35564 .74555 .35533 .74788 .34659 .74485 .34688 Mtetra
.972 .814 .628 r
.74485 .34688 .74788 .34659 .75043 .33926 .74741 .33953 Mtetra
.941 .922 .763 r
.74741 .33953 .75043 .33926 .75335 .33421 .75033 .33446 Mtetra
.616 .955 .907 r
.75033 .33446 .75335 .33421 .75674 .33192 .75373 .33217 Mtetra
.138 0 0 r
.75373 .33217 .75674 .33192 .76063 .33243 .75762 .33268 Mtetra
.468 0 0 r
.75762 .33268 .76063 .33243 .76496 .33528 .76194 .33554 Mtetra
.57 .004 0 r
.76194 .33554 .76496 .33528 .7696 .33966 .76658 .33993 Mtetra
.587 .026 0 r
.76658 .33993 .7696 .33966 .77435 .34443 .77133 .34472 Mtetra
.541 0 0 r
.77133 .34472 .77435 .34443 .77901 .3484 .77598 .3487 Mtetra
.378 0 0 r
.77598 .3487 .77901 .3484 .78335 .35047 .78032 .35078 Mtetra
.125 .674 .733 r
.78032 .35078 .78335 .35047 .78723 .34986 .7842 .35017 Mtetra
.797 .651 .701 r
.33972 .76537 .34316 .76728 .34596 .76197 .34252 .76006 Mtetra
.823 .62 .628 r
.34252 .76006 .34596 .76197 .34897 .75371 .34554 .7518 Mtetra
.831 .605 .596 r
.34554 .7518 .34897 .75371 .35212 .74337 .3487 .74145 Mtetra
.834 .6 .585 r
.3487 .74145 .35212 .74337 .35532 .73215 .35192 .73023 Mtetra
.833 .602 .59 r
.35192 .73023 .35532 .73215 .35846 .72139 .35508 .71947 Mtetra
.828 .612 .611 r
.35508 .71947 .35846 .72139 .36148 .71232 .3581 .7104 Mtetra
.812 .635 .663 r
.3581 .7104 .36148 .71232 .3643 .70587 .36093 .70395 Mtetra
.747 .68 .786 r
.36093 .70395 .3643 .70587 .36692 .7025 .36355 .70058 Mtetra
.305 .625 .961 r
.36355 .70058 .36692 .7025 .36934 .70218 .36596 .70025 Mtetra
.568 0 0 r
.36596 .70025 .36934 .70218 .37161 .70436 .36822 .70242 Mtetra
.734 .209 0 r
.36822 .70242 .37161 .70436 .3738 .70806 .3704 .70612 Mtetra
.747 .231 0 r
.3704 .70612 .3738 .70806 .37599 .71204 .37258 .7101 Mtetra
.669 .117 0 r
.37258 .7101 .37599 .71204 .37826 .71499 .37485 .71304 Mtetra
0 .388 .793 r
.37485 .71304 .37826 .71499 .38069 .71575 .37726 .7138 Mtetra
.669 .701 .87 r
.37726 .7138 .38069 .71575 .38329 .71355 .37986 .7116 Mtetra
.799 .651 .699 r
.37986 .7116 .38329 .71355 .38608 .70818 .38266 .70622 Mtetra
.826 .62 .625 r
.38266 .70622 .38608 .70818 .38902 .69999 .3856 .69803 Mtetra
.834 .606 .594 r
.3856 .69803 .38902 .69999 .39205 .68986 .38865 .6879 Mtetra
.836 .601 .584 r
.38865 .6879 .39205 .68986 .3951 .67901 .39172 .67704 Mtetra
.835 .604 .59 r
.39172 .67704 .3951 .67901 .39811 .66873 .39474 .66676 Mtetra
.828 .616 .616 r
.39474 .66676 .39811 .66873 .40101 .66021 .39765 .65824 Mtetra
.807 .642 .677 r
.39765 .65824 .40101 .66021 .40378 .65431 .40042 .65234 Mtetra
.719 .689 .82 r
.40042 .65234 .40378 .65431 .40639 .65144 .40304 .64947 Mtetra
.155 .553 .928 r
.40304 .64947 .40639 .65144 .40888 .65153 .40552 .64955 Mtetra
.591 .023 0 r
.40552 .64955 .40888 .65153 .41128 .65398 .4079 .652 Mtetra
.727 .199 0 r
.4079 .652 .41128 .65398 .41363 .65782 .41024 .65583 Mtetra
.734 .209 0 r
.41024 .65583 .41363 .65782 .416 .66181 .4126 .65981 Mtetra
.637 .077 0 r
.4126 .65981 .416 .66181 .41844 .66465 .41502 .66265 Mtetra
0 .436 .84 r
.41502 .66265 .41844 .66465 .42098 .66526 .41756 .66326 Mtetra
.676 .698 .863 r
.41756 .66326 .42098 .66526 .42364 .66293 .42022 .66092 Mtetra
.801 .652 .696 r
.42022 .66092 .42364 .66293 .42642 .65749 .42301 .65548 Mtetra
.828 .621 .623 r
.42301 .65548 .42642 .65749 .4293 .64936 .42589 .64734 Mtetra
.837 .607 .591 r
.42589 .64734 .4293 .64936 .43222 .63943 .42882 .63741 Mtetra
.839 .603 .582 r
.42882 .63741 .43222 .63943 .43514 .62891 .43176 .62689 Mtetra
.837 .607 .591 r
.43176 .62689 .43514 .62891 .43802 .61907 .43466 .61706 Mtetra
.828 .621 .622 r
.43466 .61706 .43802 .61907 .44084 .61107 .43748 .60905 Mtetra
.801 .65 .695 r
.43748 .60905 .44084 .61107 .44357 .60569 .44022 .60367 Mtetra
.68 .695 .857 r
.44022 .60367 .44357 .60569 .44622 .6033 .44286 .60128 Mtetra
.012 .47 .871 r
.44286 .60128 .44622 .6033 .4488 .60377 .44544 .60175 Mtetra
.604 .039 0 r
.44544 .60175 .4488 .60377 .45135 .60649 .44798 .60446 Mtetra
.718 .185 0 r
.44798 .60446 .45135 .60649 .45389 .61045 .4505 .60841 Mtetra
.717 .183 0 r
.4505 .60841 .45389 .61045 .45645 .61444 .45305 .61239 Mtetra
.599 .034 0 r
.45305 .61239 .45645 .61444 .45906 .61719 .45565 .61513 Mtetra
.021 .476 .876 r
.45565 .61513 .45906 .61719 .46173 .61765 .45831 .61559 Mtetra
.683 .697 .857 r
.45831 .61559 .46173 .61765 .46446 .61517 .46104 .61311 Mtetra
.804 .652 .694 r
.46104 .61311 .46446 .61517 .46724 .60967 .46382 .6076 Mtetra
.831 .622 .62 r
.46382 .6076 .46724 .60967 .47004 .60157 .46664 .59951 Mtetra
.839 .608 .589 r
.46664 .59951 .47004 .60157 .47286 .59182 .46947 .58976 Mtetra
.841 .604 .58 r
.46947 .58976 .47286 .59182 .47566 .58162 .47229 .57955 Mtetra
.838 .61 .592 r
.47229 .57955 .47566 .58162 .47844 .5722 .47508 .57013 Mtetra
.828 .626 .629 r
.47508 .57013 .47844 .5722 .48119 .56468 .47783 .56261 Mtetra
.793 .659 .715 r
.47783 .56261 .48119 .56468 .48392 .55979 .48056 .55772 Mtetra
.627 .695 .893 r
.48056 .55772 .48392 .55979 .48663 .55786 .48327 .55579 Mtetra
0 .388 .806 r
.48327 .55579 .48663 .55786 .48934 .5587 .48598 .55662 Mtetra
.61 .047 0 r
.48598 .55662 .48934 .5587 .49207 .56167 .48869 .55958 Mtetra
.706 .168 0 r
.48869 .55958 .49207 .56167 .49482 .56576 .49143 .56366 Mtetra
.697 .156 0 r
.49143 .56366 .49482 .56576 .49759 .56974 .49419 .56764 Mtetra
.556 0 0 r
.49419 .56764 .49759 .56974 .50039 .57239 .49697 .57028 Mtetra
.084 .509 .902 r
.49697 .57028 .50039 .57239 .50319 .5727 .49977 .57059 Mtetra
.689 .696 .851 r
.49977 .57059 .50319 .5727 .50599 .57009 .50257 .56797 Mtetra
.807 .653 .691 r
.50257 .56797 .50599 .57009 .50877 .5645 .50535 .56238 Mtetra
.834 .623 .617 r
.50535 .56238 .50877 .5645 .51151 .55644 .50811 .55432 Mtetra
.842 .609 .586 r
.50811 .55432 .51151 .55644 .51423 .54685 .51084 .54473 Mtetra
.844 .606 .579 r
.51084 .54473 .51423 .54685 .51693 .53693 .51355 .53481 Mtetra
.84 .613 .594 r
.51355 .53481 .51693 .53693 .51962 .52791 .51625 .52579 Mtetra
.827 .632 .639 r
.51625 .52579 .51962 .52791 .52233 .52084 .51896 .51872 Mtetra
.781 .668 .739 r
.51896 .51872 .52233 .52084 .52507 .51643 .52171 .5143 Mtetra
.558 .686 .925 r
.52171 .5143 .52507 .51643 .52788 .51493 .52452 .5128 Mtetra
0 .318 .744 r
.52452 .5128 .52788 .51493 .53075 .51613 .52738 .51399 Mtetra
.609 .049 0 r
.52738 .51399 .53075 .51613 .53369 .51934 .53031 .51719 Mtetra
.692 .149 0 r
.53031 .51719 .53369 .51934 .53668 .52354 .53328 .52139 Mtetra
.673 .125 0 r
.53328 .52139 .53668 .52354 .53969 .52752 .53628 .52536 Mtetra
.509 0 0 r
.53628 .52536 .53969 .52752 .54269 .53007 .53926 .5279 Mtetra
.141 .535 .921 r
.53926 .5279 .54269 .53007 .54564 .53023 .54221 .52806 Mtetra
.695 .695 .846 r
.54221 .52806 .54564 .53023 .54851 .52748 .54508 .5253 Mtetra
.81 .653 .689 r
.54508 .5253 .54851 .52748 .55129 .52181 .54786 .51963 Mtetra
.837 .624 .615 r
.54786 .51963 .55129 .52181 .55398 .51376 .55056 .51158 Mtetra
.846 .611 .583 r
.55056 .51158 .55398 .51376 .5566 .50432 .5532 .50214 Mtetra
.847 .609 .578 r
.5532 .50214 .5566 .50432 .5592 .49467 .55581 .49248 Mtetra
.842 .617 .597 r
.55581 .49248 .5592 .49467 .56182 .48602 .55844 .48383 Mtetra
.825 .639 .651 r
.55844 .48383 .56182 .48602 .56452 .47938 .56114 .4772 Mtetra
.764 .677 .767 r
.56114 .4772 .56452 .47938 .56732 .47542 .56394 .47324 Mtetra
.472 .665 .947 r
.56394 .47324 .56732 .47542 .57025 .47435 .56687 .47215 Mtetra
0 .262 .692 r
.56687 .47215 .57025 .47435 .57332 .47588 .56994 .47368 Mtetra
.604 .044 0 r
.56994 .47368 .57332 .47588 .57651 .47933 .57311 .47712 Mtetra
.674 .126 0 r
.57311 .47712 .57651 .47933 .57976 .48365 .57635 .48143 Mtetra
.645 .092 0 r
.57635 .48143 .57976 .48365 .58303 .48762 .57961 .4854 Mtetra
.457 0 0 r
.57961 .4854 .58303 .48762 .58625 .49008 .58281 .48785 Mtetra
.19 .557 .933 r
.58281 .48785 .58625 .49008 .58936 .49009 .58591 .48786 Mtetra
.7 .694 .841 r
.58591 .48786 .58936 .49009 .59231 .48719 .58886 .48495 Mtetra
.813 .655 .687 r
.58886 .48495 .59231 .48719 .59509 .48142 .59165 .47918 Mtetra
.841 .626 .612 r
.59165 .47918 .59509 .48142 .59772 .47339 .59429 .47114 Mtetra
.849 .612 .58 r
.59429 .47114 .59772 .47339 .60026 .46407 .59685 .46182 Mtetra
.85 .611 .578 r
.59685 .46182 .60026 .46407 .60278 .45466 .59937 .45242 Mtetra
.843 .621 .602 r
.59937 .45242 .60278 .45466 .60535 .44636 .60196 .44412 Mtetra
.822 .646 .665 r
.60196 .44412 .60535 .44636 .60806 .44015 .60466 .4379 Mtetra
.74 .686 .798 r
.60466 .4379 .60806 .44015 .61094 .43662 .60755 .43437 Mtetra
.373 .632 .954 r
.60755 .43437 .61094 .43662 .61404 .43595 .61065 .43369 Mtetra
0 .221 .654 r
.61065 .43369 .61404 .43595 .61735 .43782 .61395 .43556 Mtetra
.594 .035 0 r
.61395 .43556 .61735 .43782 .62082 .4415 .6174 .43923 Mtetra
.652 .101 0 r
.6174 .43923 .62082 .4415 .62439 .44594 .62095 .44365 Mtetra
.613 .057 0 r
.62095 .44365 .62439 .44594 .62795 .44991 .6245 .44762 Mtetra
.403 0 0 r
.6245 .44762 .62795 .44991 .6314 .45227 .62794 .44997 Mtetra
.233 .575 .942 r
.62794 .44997 .6314 .45227 .63468 .45213 .63121 .44983 Mtetra
.705 .695 .837 r
.63121 .44983 .63468 .45213 .63771 .44907 .63424 .44676 Mtetra
.816 .656 .684 r
.63424 .44676 .63771 .44907 .6405 .44321 .63704 .4409 Mtetra
.844 .627 .608 r
.63704 .4409 .6405 .44321 .64308 .43516 .63963 .43285 Mtetra
.853 .614 .578 r
.63963 .43285 .64308 .43516 .64555 .42595 .6421 .42364 Mtetra
.853 .614 .577 r
.6421 .42364 .64555 .42595 .64799 .41678 .64456 .41446 Mtetra
.845 .627 .607 r
.64456 .41446 .64799 .41678 .65054 .40881 .64712 .4065 Mtetra
.817 .655 .682 r
.64712 .4065 .65054 .40881 .65328 .40299 .64986 .40067 Mtetra
.709 .692 .832 r
.64986 .40067 .65328 .40299 .65629 .39989 .65288 .39756 Mtetra
.27 .587 .946 r
.65288 .39756 .65629 .39989 .6596 .39961 .65618 .39728 Mtetra
0 .192 .628 r
.65618 .39728 .6596 .39961 .66319 .40182 .65976 .39948 Mtetra
.58 .022 0 r
.65976 .39948 .66319 .40182 .667 .40573 .66355 .40339 Mtetra
.627 .074 0 r
.66355 .40339 .667 .40573 .6709 .41028 .66744 .40792 Mtetra
.577 .019 0 r
.66744 .40792 .6709 .41028 .67479 .41425 .67131 .41189 Mtetra
0 .196 .632 r
.67131 .41189 .67479 .41425 .67851 .41651 .67502 .41414 Mtetra
.27 .589 .947 r
.67502 .41414 .67851 .41651 .68196 .41622 .67847 .41385 Mtetra
.71 .695 .834 r
.67847 .41385 .68196 .41622 .68509 .41301 .68159 .41063 Mtetra
.82 .658 .682 r
.68159 .41063 .68509 .41301 .68789 .40703 .6844 .40464 Mtetra
.848 .629 .605 r
.6844 .40464 .68789 .40703 .69043 .39896 .68694 .39657 Mtetra
.856 .617 .575 r
.68694 .39657 .69043 .39896 .69282 .38985 .68935 .38746 Mtetra
.856 .618 .578 r
.68935 .38746 .69282 .38985 .69521 .38089 .69175 .3785 Mtetra
.845 .633 .615 r
.69175 .3785 .69521 .38089 .69774 .37324 .69429 .37084 Mtetra
.809 .664 .703 r
.69429 .37084 .69774 .37324 .70056 .3678 .69712 .36541 Mtetra
.667 .694 .866 r
.69712 .36541 .70056 .3678 .70374 .36511 .70029 .36271 Mtetra
.171 .537 .925 r
.70029 .36271 .70374 .36511 .70731 .36522 .70386 .36282 Mtetra
0 .174 .613 r
.70386 .36282 .70731 .36522 .71124 .36776 .70777 .36534 Mtetra
.561 .005 0 r
.70777 .36534 .71124 .36776 .71543 .37191 .71194 .36948 Mtetra
.598 .044 0 r
.71194 .36948 .71543 .37191 .71973 .37657 .71623 .37414 Mtetra
.537 0 0 r
.71623 .37414 .71973 .37657 .72397 .38055 .72046 .3781 Mtetra
0 .238 .68 r
.72046 .3781 .72397 .38055 .72799 .38271 .72446 .38026 Mtetra
.302 .6 .949 r
.72446 .38026 .72799 .38271 .73164 .38227 .72811 .37981 Mtetra
.715 .696 .831 r
.72811 .37981 .73164 .38227 .73487 .37889 .73134 .37642 Mtetra
.824 .66 .68 r
.73134 .37642 .73487 .37889 .73768 .37278 .73415 .37032 Mtetra
.853 .631 .602 r
.73415 .37032 .73768 .37278 .74017 .36468 .73666 .36221 Mtetra
.86 .619 .572 r
.73666 .36221 .74017 .36468 .7425 .35564 .73899 .35317 Mtetra
.859 .622 .579 r
.73899 .35317 .7425 .35564 .74485 .34688 .74135 .34441 Mtetra
.846 .64 .624 r
.74135 .34441 .74485 .34688 .74741 .33953 .74392 .33705 Mtetra
.798 .674 .727 r
.74392 .33705 .74741 .33953 .75033 .33446 .74685 .33199 Mtetra
.613 .69 .898 r
.74685 .33199 .75033 .33446 .75373 .33217 .75025 .32969 Mtetra
.083 .486 .896 r
.75025 .32969 .75373 .33217 .75762 .33268 .75413 .33019 Mtetra
0 .164 .607 r
.75413 .33019 .75762 .33268 .76194 .33554 .75844 .33305 Mtetra
.539 0 0 r
.75844 .33305 .76194 .33554 .76658 .33993 .76305 .33742 Mtetra
.566 .012 0 r
.76305 .33742 .76658 .33993 .77133 .34472 .76779 .3422 Mtetra
.494 0 0 r
.76779 .3422 .77133 .34472 .77598 .3487 .77242 .34617 Mtetra
0 .277 .723 r
.77242 .34617 .77598 .3487 .78032 .35078 .77675 .34823 Mtetra
.329 .61 .951 r
.77675 .34823 .78032 .35078 .7842 .35017 .78062 .34762 Mtetra
.68 .504 .641 r
.33653 .76026 .33972 .76537 .34252 .76006 .33933 .75495 Mtetra
.736 .519 .599 r
.33933 .75495 .34252 .76006 .34554 .7518 .34235 .74671 Mtetra
.758 .524 .578 r
.34235 .74671 .34554 .7518 .3487 .74145 .34552 .73639 Mtetra
.766 .525 .57 r
.34552 .73639 .3487 .74145 .35192 .73023 .34874 .7252 Mtetra
.763 .525 .573 r
.34874 .7252 .35192 .73023 .35508 .71947 .35191 .71446 Mtetra
.748 .522 .588 r
.35191 .71446 .35508 .71947 .3581 .7104 .35494 .70542 Mtetra
.71 .513 .621 r
.35494 .70542 .3581 .7104 .36093 .70395 .35778 .69897 Mtetra
.612 .483 .681 r
.35778 .69897 .36093 .70395 .36355 .70058 .36039 .6956 Mtetra
.32 .364 .751 r
.36039 .6956 .36355 .70058 .36596 .70025 .3628 .69527 Mtetra
0 .028 .599 r
.3628 .69527 .36596 .70025 .36822 .70242 .36504 .69742 Mtetra
.64 .211 0 r
.36504 .69742 .36822 .70242 .3704 .70612 .36721 .7011 Mtetra
.678 .241 0 r
.36721 .7011 .3704 .70612 .37258 .7101 .36937 .70505 Mtetra
0 0 .48 r
.36937 .70505 .37258 .7101 .37485 .71304 .37162 .70797 Mtetra
.103 .256 .736 r
.37162 .70797 .37485 .71304 .37726 .7138 .37403 .70871 Mtetra
.534 .454 .712 r
.37403 .70871 .37726 .7138 .37986 .7116 .37662 .70651 Mtetra
.682 .504 .639 r
.37662 .70651 .37986 .7116 .38266 .70622 .37941 .70114 Mtetra
.736 .518 .597 r
.37941 .70114 .38266 .70622 .3856 .69803 .38237 .69297 Mtetra
.758 .522 .575 r
.38237 .69297 .3856 .69803 .38865 .6879 .38542 .68286 Mtetra
.765 .524 .568 r
.38542 .68286 .38865 .6879 .39172 .67704 .38849 .67203 Mtetra
.761 .523 .573 r
.38849 .67203 .39172 .67704 .39474 .66676 .39152 .66178 Mtetra
.743 .519 .591 r
.39152 .66178 .39474 .66676 .39765 .65824 .39444 .65327 Mtetra
.698 .509 .628 r
.39444 .65327 .39765 .65824 .40042 .65234 .39721 .64738 Mtetra
.582 .473 .695 r
.39721 .64738 .40042 .65234 .40304 .64947 .39983 .64451 Mtetra
.247 .331 .754 r
.39983 .64451 .40304 .64947 .40552 .64955 .4023 .64458 Mtetra
0 .003 .576 r
.4023 .64458 .40552 .64955 .4079 .652 .40467 .64701 Mtetra
.628 .196 0 r
.40467 .64701 .4079 .652 .41024 .65583 .40699 .65082 Mtetra
.645 .21 0 r
.40699 .65082 .41024 .65583 .4126 .65981 .40933 .65477 Mtetra
0 0 .524 r
.40933 .65477 .4126 .65981 .41502 .66265 .41174 .65759 Mtetra
.142 .279 .745 r
.41174 .65759 .41502 .66265 .41756 .66326 .41427 .65818 Mtetra
.541 .457 .71 r
.41427 .65818 .41756 .66326 .42022 .66092 .41693 .65584 Mtetra
.683 .503 .637 r
.41693 .65584 .42022 .66092 .42301 .65548 .41971 .65041 Mtetra
.737 .516 .594 r
.41971 .65041 .42301 .65548 .42589 .64734 .4226 .64229 Mtetra
.758 .52 .573 r
.4226 .64229 .42589 .64734 .42882 .63741 .42554 .63239 Mtetra
.764 .521 .566 r
.42554 .63239 .42882 .63741 .43176 .62689 .42848 .62189 Mtetra
.759 .521 .572 r
.42848 .62189 .43176 .62689 .43466 .61706 .43139 .61208 Mtetra
.737 .517 .594 r
.43139 .61208 .43466 .61706 .43748 .60905 .43421 .60409 Mtetra
.685 .504 .637 r
.43421 .60409 .43748 .60905 .44022 .60367 .43695 .59872 Mtetra
.547 .461 .709 r
.43695 .59872 .44022 .60367 .44286 .60128 .43959 .59633 Mtetra
.171 .297 .752 r
.43959 .59633 .44286 .60128 .44544 .60175 .44216 .59678 Mtetra
0 0 .559 r
.44216 .59678 .44544 .60175 .44798 .60446 .44468 .59947 Mtetra
.61 .179 0 r
.44468 .59947 .44798 .60446 .4505 .60841 .44719 .6034 Mtetra
.608 .177 0 r
.44719 .6034 .4505 .60841 .45305 .61239 .44972 .60735 Mtetra
0 0 .564 r
.44972 .60735 .45305 .61239 .45565 .61513 .45231 .61008 Mtetra
.177 .299 .752 r
.45231 .61008 .45565 .61513 .45831 .61559 .45496 .61052 Mtetra
.547 .46 .708 r
.45496 .61052 .45831 .61559 .46104 .61311 .45768 .60804 Mtetra
.684 .503 .635 r
.45768 .60804 .46104 .61311 .46382 .6076 .46046 .60253 Mtetra
.737 .515 .591 r
.46046 .60253 .46382 .6076 .46664 .59951 .46328 .59446 Mtetra
.758 .518 .57 r
.46328 .59446 .46664 .59951 .46947 .58976 .46612 .58473 Mtetra
.763 .519 .564 r
.46612 .58473 .46947 .58976 .47229 .57955 .46895 .57455 Mtetra
.756 .518 .573 r
.46895 .57455 .47229 .57955 .47508 .57013 .47174 .56516 Mtetra
.731 .514 .598 r
.47174 .56516 .47508 .57013 .47783 .56261 .4745 .55765 Mtetra
.669 .499 .647 r
.4745 .55765 .47783 .56261 .48056 .55772 .47723 .55277 Mtetra
.506 .446 .724 r
.47723 .55277 .48056 .55772 .48327 .55579 .47994 .55083 Mtetra
.098 .263 .745 r
.47994 .55083 .48327 .55579 .48598 .55662 .48263 .55165 Mtetra
0 0 .549 r
.48263 .55165 .48598 .55662 .48869 .55958 .48533 .55459 Mtetra
.589 .158 0 r
.48533 .55459 .48869 .55958 .49143 .56366 .48804 .55864 Mtetra
0 0 .413 r
.48804 .55864 .49143 .56366 .49419 .56764 .49079 .56259 Mtetra
0 .032 .6 r
.49079 .56259 .49419 .56764 .49697 .57028 .49356 .56521 Mtetra
.208 .317 .757 r
.49356 .56521 .49697 .57028 .49977 .57059 .49634 .5655 Mtetra
.553 .462 .706 r
.49634 .5655 .49977 .57059 .50257 .56797 .49913 .56288 Mtetra
.685 .502 .633 r
.49913 .56288 .50257 .56797 .50535 .56238 .50192 .5573 Mtetra
.737 .513 .589 r
.50192 .5573 .50535 .56238 .50811 .55432 .50468 .54926 Mtetra
.758 .516 .567 r
.50468 .54926 .50811 .55432 .51084 .54473 .50742 .53969 Mtetra
.762 .517 .563 r
.50742 .53969 .51084 .54473 .51355 .53481 .51013 .5298 Mtetra
.752 .516 .573 r
.51013 .5298 .51355 .53481 .51625 .52579 .51284 .5208 Mtetra
.723 .51 .603 r
.51284 .5208 .51625 .52579 .51896 .51872 .51556 .51374 Mtetra
.65 .493 .658 r
.51556 .51374 .51896 .51872 .52171 .5143 .51831 .50933 Mtetra
.46 .43 .738 r
.51831 .50933 .52171 .5143 .52452 .5128 .5211 .50782 Mtetra
.031 .232 .735 r
.5211 .50782 .52452 .5128 .52738 .51399 .52396 .509 Mtetra
0 0 .545 r
.52396 .509 .52738 .51399 .53031 .51719 .52686 .51218 Mtetra
0 0 .419 r
.52686 .51218 .53031 .51719 .53328 .52139 .52982 .51634 Mtetra
0 0 .453 r
.52982 .51634 .53328 .52139 .53628 .52536 .53279 .52028 Mtetra
0 .07 .632 r
.53279 .52028 .53628 .52536 .53926 .5279 .53576 .52281 Mtetra
.235 .332 .76 r
.53576 .52281 .53926 .5279 .54221 .52806 .5387 .52295 Mtetra
.558 .464 .704 r
.5387 .52295 .54221 .52806 .54508 .5253 .54156 .52019 Mtetra
.686 .501 .63 r
.54156 .52019 .54508 .5253 .54786 .51963 .54434 .51452 Mtetra
.737 .511 .586 r
.54434 .51452 .54786 .51963 .55056 .51158 .54705 .5065 Mtetra
.757 .514 .565 r
.54705 .5065 .55056 .51158 .5532 .50214 .54969 .49707 Mtetra
.76 .514 .561 r
.54969 .49707 .5532 .50214 .55581 .49248 .55232 .48745 Mtetra
.748 .513 .574 r
.55232 .48745 .55581 .49248 .55844 .48383 .55496 .47882 Mtetra
.713 .507 .609 r
.55496 .47882 .55844 .48383 .56114 .4772 .55766 .4722 Mtetra
.627 .486 .671 r
.55766 .4722 .56114 .4772 .56394 .47324 .56046 .46824 Mtetra
.409 .411 .75 r
.56046 .46824 .56394 .47324 .56687 .47215 .56338 .46714 Mtetra
0 .204 .724 r
.56338 .46714 .56687 .47215 .56994 .47368 .56642 .46866 Mtetra
0 0 .546 r
.56642 .46866 .56994 .47368 .57311 .47712 .56957 .47207 Mtetra
0 0 .447 r
.56957 .47207 .57311 .47712 .57635 .48143 .5728 .47635 Mtetra
0 0 .492 r
.5728 .47635 .57635 .48143 .57961 .4854 .57603 .48029 Mtetra
0 .105 .66 r
.57603 .48029 .57961 .4854 .58281 .48785 .57922 .48271 Mtetra
.259 .346 .762 r
.57922 .48271 .58281 .48785 .58591 .48786 .58231 .48271 Mtetra
.562 .465 .702 r
.58231 .48271 .58591 .48786 .58886 .48495 .58525 .4798 Mtetra
.687 .5 .628 r
.58525 .4798 .58886 .48495 .59165 .47918 .58804 .47404 Mtetra
.737 .509 .583 r
.58804 .47404 .59165 .47918 .59429 .47114 .59069 .46602 Mtetra
.757 .511 .562 r
.59069 .46602 .59429 .47114 .59685 .46182 .59325 .45672 Mtetra
.758 .512 .56 r
.59325 .45672 .59685 .46182 .59937 .45242 .59579 .44734 Mtetra
.744 .51 .576 r
.59579 .44734 .59937 .45242 .60196 .44412 .59837 .43906 Mtetra
.702 .503 .616 r
.59837 .43906 .60196 .44412 .60466 .4379 .60108 .43285 Mtetra
.601 .478 .685 r
.60108 .43285 .60466 .4379 .60755 .43437 .60397 .42933 Mtetra
.355 .39 .759 r
.60397 .42933 .60755 .43437 .61065 .43369 .60705 .42864 Mtetra
0 .182 .712 r
.60705 .42864 .61065 .43369 .61395 .43556 .61033 .43048 Mtetra
0 0 .552 r
.61033 .43048 .61395 .43556 .6174 .43923 .61377 .43413 Mtetra
0 0 .476 r
.61377 .43413 .6174 .43923 .62095 .44365 .61729 .43852 Mtetra
0 0 .53 r
.61729 .43852 .62095 .44365 .6245 .44762 .62082 .44245 Mtetra
0 .138 .684 r
.62082 .44245 .6245 .44762 .62794 .44997 .62425 .44478 Mtetra
.281 .357 .764 r
.62425 .44478 .62794 .44997 .63121 .44983 .6275 .44463 Mtetra
.566 .466 .7 r
.6275 .44463 .63121 .44983 .63424 .44676 .63053 .44156 Mtetra
.687 .498 .625 r
.63053 .44156 .63424 .44676 .63704 .4409 .63332 .4357 Mtetra
.737 .507 .58 r
.63332 .4357 .63704 .4409 .63963 .43285 .63592 .42767 Mtetra
.756 .509 .559 r
.63592 .42767 .63963 .43285 .6421 .42364 .6384 .41849 Mtetra
.6384 .41849 .6421 .42364 .64456 .41446 .64087 .40934 Mtetra
.738 .507 .579 r
.64087 .40934 .64456 .41446 .64712 .4065 .64343 .40139 Mtetra
.689 .499 .625 r
.64343 .40139 .64712 .4065 .64986 .40067 .64618 .39558 Mtetra
.571 .469 .699 r
.64618 .39558 .64986 .40067 .65288 .39756 .64919 .39247 Mtetra
.3 .368 .766 r
.64919 .39247 .65288 .39756 .65618 .39728 .65248 .39217 Mtetra
0 .165 .703 r
.65248 .39217 .65618 .39728 .65976 .39948 .65604 .39435 Mtetra
0 0 .563 r
.65604 .39435 .65976 .39948 .66355 .40339 .6598 .39822 Mtetra
0 0 .506 r
.6598 .39822 .66355 .40339 .66744 .40792 .66367 .40273 Mtetra
0 .001 .565 r
.66367 .40273 .66744 .40792 .67131 .41189 .66751 .40666 Mtetra
0 .168 .704 r
.66751 .40666 .67131 .41189 .67502 .41414 .67121 .40889 Mtetra
.3 .367 .765 r
.67121 .40889 .67502 .41414 .67847 .41385 .67464 .40858 Mtetra
.569 .467 .698 r
.67464 .40858 .67847 .41385 .68159 .41063 .67776 .40536 Mtetra
.688 .496 .623 r
.67776 .40536 .68159 .41063 .6844 .40464 .68057 .39939 Mtetra
.737 .504 .576 r
.68057 .39939 .6844 .40464 .68694 .39657 .68312 .39134 Mtetra
.754 .506 .556 r
.68312 .39134 .68694 .39657 .68935 .38746 .68553 .38224 Mtetra
.753 .505 .558 r
.68553 .38224 .68935 .38746 .69175 .3785 .68794 .37331 Mtetra
.731 .503 .582 r
.68794 .37331 .69175 .3785 .69429 .37084 .69049 .36567 Mtetra
.673 .494 .635 r
.69049 .36567 .69429 .37084 .69712 .36541 .69331 .36024 Mtetra
.537 .458 .714 r
.69331 .36024 .69712 .36541 .70029 .36271 .69648 .35754 Mtetra
.245 .346 .769 r
.69648 .35754 .70029 .36271 .70386 .36282 .70003 .35763 Mtetra
0 .154 .696 r
.70003 .35763 .70386 .36282 .70777 .36534 .70393 .36013 Mtetra
0 .013 .576 r
.70393 .36013 .70777 .36534 .71194 .36948 .70807 .36424 Mtetra
0 0 .536 r
.70807 .36424 .71194 .36948 .71623 .37414 .71233 .36886 Mtetra
0 .035 .598 r
.71233 .36886 .71623 .37414 .72046 .3781 .71653 .37279 Mtetra
0 .195 .721 r
.71653 .37279 .72046 .3781 .72446 .38026 .72051 .37492 Mtetra
.317 .376 .765 r
.72051 .37492 .72446 .38026 .72811 .37981 .72415 .37446 Mtetra
.572 .467 .696 r
.72415 .37446 .72811 .37981 .73134 .37642 .72737 .37107 Mtetra
.688 .494 .62 r
.72737 .37107 .73134 .37642 .73415 .37032 .73019 .36498 Mtetra
.736 .501 .573 r
.73019 .36498 .73415 .37032 .73666 .36221 .7327 .35689 Mtetra
.753 .502 .553 r
.7327 .35689 .73666 .36221 .73899 .35317 .73504 .34787 Mtetra
.749 .502 .557 r
.73504 .34787 .73899 .35317 .74135 .34441 .73741 .33913 Mtetra
.723 .5 .587 r
.73741 .33913 .74135 .34441 .74392 .33705 .73998 .3318 Mtetra
.655 .488 .646 r
.73998 .3318 .74392 .33705 .74685 .33199 .74291 .32674 Mtetra
.498 .445 .729 r
.74291 .32674 .74685 .33199 .75025 .32969 .7463 .32444 Mtetra
.193 .325 .77 r
.7463 .32444 .75025 .32969 .75413 .33019 .75016 .32492 Mtetra
0 .148 .692 r
.75016 .32492 .75413 .33019 .75844 .33305 .75445 .32774 Mtetra
0 .031 .592 r
.75445 .32774 .75844 .33305 .76305 .33742 .75904 .33208 Mtetra
0 .005 .566 r
.75904 .33208 .76305 .33742 .76779 .3422 .76374 .33683 Mtetra
0 .069 .628 r
.76374 .33683 .76779 .3422 .77242 .34617 .76834 .34076 Mtetra
0 .219 .735 r
.76834 .34076 .77242 .34617 .77675 .34823 .77265 .3428 Mtetra
.331 .383 .765 r
.77265 .3428 .77675 .34823 .78062 .34762 .77651 .34217 Mtetra
.609 .419 .6 r
.33356 .75248 .33653 .76026 .33933 .75495 .33636 .74718 Mtetra
.676 .453 .576 r
.33636 .74718 .33933 .75495 .34235 .74671 .33938 .73898 Mtetra
.706 .468 .562 r
.33938 .73898 .34235 .74671 .34552 .73639 .34255 .72871 Mtetra
.716 .473 .556 r
.34255 .72871 .34552 .73639 .34874 .7252 .34578 .71756 Mtetra
.712 .471 .559 r
.34578 .71756 .34874 .7252 .35191 .71446 .34895 .70688 Mtetra
.692 .461 .569 r
.34895 .70688 .35191 .71446 .35494 .70542 .35198 .69787 Mtetra
.644 .438 .589 r
.35198 .69787 .35494 .70542 .35778 .69897 .35481 .69146 Mtetra
.538 .384 .62 r
.35481 .69146 .35778 .69897 .36039 .6956 .35742 .68809 Mtetra
.306 .259 .64 r
.35742 .68809 .36039 .6956 .3628 .69527 .35981 .68774 Mtetra
0 .033 .574 r
.35981 .68774 .3628 .69527 .36504 .69742 .36205 .68986 Mtetra
0 0 .442 r
.36205 .68986 .36504 .69742 .36721 .7011 .36419 .6935 Mtetra
0 0 .414 r
.36419 .6935 .36721 .7011 .36937 .70505 .36634 .69741 Mtetra
0 0 .522 r
.36634 .69741 .36937 .70505 .37162 .70797 .36857 .7003 Mtetra
.166 .18 .629 r
.36857 .7003 .37162 .70797 .37403 .70871 .37096 .70102 Mtetra
.466 .345 .63 r
.37096 .70102 .37403 .70871 .37662 .70651 .37355 .69881 Mtetra
.61 .419 .598 r
.37355 .69881 .37662 .70651 .37941 .70114 .37634 .69346 Mtetra
.675 .451 .573 r
.37634 .69346 .37941 .70114 .38237 .69297 .37929 .68532 Mtetra
.704 .465 .559 r
.37929 .68532 .38237 .69297 .38542 .68286 .38235 .67526 Mtetra
.714 .469 .554 r
.38235 .67526 .38542 .68286 .38849 .67203 .38543 .66448 Mtetra
.708 .467 .557 r
.38543 .66448 .38849 .67203 .39152 .66178 .38846 .65428 Mtetra
.684 .455 .569 r
.38846 .65428 .39152 .66178 .39444 .65327 .39138 .64581 Mtetra
.629 .429 .593 r
.39138 .64581 .39444 .65327 .39721 .64738 .39414 .63994 Mtetra
.51 .37 .626 r
.39414 .63994 .39721 .64738 .39983 .64451 .39675 .63707 Mtetra
.257 .235 .642 r
.39675 .63707 .39983 .64451 .4023 .64458 .39921 .63712 Mtetra
0 .015 .568 r
.39921 .63712 .4023 .64458 .40467 .64701 .40156 .63952 Mtetra
0 0 .451 r
.40156 .63952 .40467 .64701 .40699 .65082 .40387 .64329 Mtetra
0 0 .44 r
.40387 .64329 .40699 .65082 .40933 .65477 .40619 .6472 Mtetra
0 0 .545 r
.40619 .6472 .40933 .65477 .41174 .65759 .40858 .64999 Mtetra
.19 .198 .636 r
.40858 .64999 .41174 .65759 .41427 .65818 .4111 .65056 Mtetra
.473 .349 .631 r
.4111 .65056 .41427 .65818 .41693 .65584 .41374 .64821 Mtetra
.611 .418 .597 r
.41374 .64821 .41693 .65584 .41971 .65041 .41653 .6428 Mtetra
.674 .449 .571 r
.41653 .6428 .41971 .65041 .4226 .64229 .41941 .63471 Mtetra
.703 .462 .556 r
.41941 .63471 .4226 .64229 .42554 .63239 .42235 .62486 Mtetra
.711 .465 .552 r
.42235 .62486 .42554 .63239 .42848 .62189 .4253 .61441 Mtetra
.703 .462 .556 r
.4253 .61441 .42848 .62189 .43139 .61208 .42821 .60465 Mtetra
.675 .449 .571 r
.42821 .60465 .43139 .61208 .43421 .60409 .43104 .59669 Mtetra
.613 .42 .597 r
.43104 .59669 .43421 .60409 .43695 .59872 .43377 .59133 Mtetra
.479 .354 .632 r
.43377 .59133 .43695 .59872 .43959 .59633 .43641 .58894 Mtetra
.208 .212 .643 r
.43641 .58894 .43959 .59633 .44216 .59678 .43896 .58937 Mtetra
0 .003 .564 r
.43896 .58937 .44216 .59678 .44468 .59947 .44146 .59203 Mtetra
0 0 .464 r
.44146 .59203 .44468 .59947 .44719 .6034 .44395 .59592 Mtetra
0 0 .465 r
.44395 .59592 .44719 .6034 .44972 .60735 .44646 .59983 Mtetra
0 .007 .566 r
.44646 .59983 .44972 .60735 .45231 .61008 .44903 .60251 Mtetra
.212 .213 .642 r
.44903 .60251 .45231 .61008 .45496 .61052 .45166 .60293 Mtetra
.479 .353 .63 r
.45166 .60293 .45496 .61052 .45768 .60804 .45438 .60045 Mtetra
.611 .417 .595 r
.45438 .60045 .45768 .60804 .46046 .60253 .45716 .59497 Mtetra
.673 .446 .568 r
.45716 .59497 .46046 .60253 .46328 .59446 .45998 .58693 Mtetra
.701 .458 .553 r
.45998 .58693 .46328 .59446 .46612 .58473 .46282 .57725 Mtetra
.708 .461 .549 r
.46282 .57725 .46612 .58473 .46895 .57455 .46565 .56711 Mtetra
.698 .457 .555 r
.46565 .56711 .46895 .57455 .47174 .56516 .46845 .55776 Mtetra
.666 .443 .572 r
.46845 .55776 .47174 .56516 .4745 .55765 .47121 .55028 Mtetra
.595 .41 .602 r
.47121 .55028 .4745 .55765 .47723 .55277 .47393 .54542 Mtetra
.445 .338 .638 r
.47393 .54542 .47723 .55277 .47994 .55083 .47663 .54347 Mtetra
.161 .19 .643 r
.47663 .54347 .47994 .55083 .48263 .55165 .4793 .54427 Mtetra
0 0 .562 r
.4793 .54427 .48263 .55165 .48533 .55459 .48198 .54717 Mtetra
0 0 .478 r
.48198 .54717 .48533 .55459 .48804 .55864 .48468 .55118 Mtetra
0 0 .49 r
.48468 .55118 .48804 .55864 .49079 .56259 .4874 .55508 Mtetra
0 .035 .585 r
.4874 .55508 .49079 .56259 .49356 .56521 .49015 .55767 Mtetra
.232 .227 .648 r
.49015 .55767 .49356 .56521 .49634 .5655 .49292 .55794 Mtetra
.484 .355 .63 r
.49292 .55794 .49634 .5655 .49913 .56288 .4957 .55532 Mtetra
.612 .416 .593 r
.4957 .55532 .49913 .56288 .50192 .5573 .49848 .54976 Mtetra
.672 .443 .565 r
.49848 .54976 .50192 .5573 .50468 .54926 .50124 .54175 Mtetra
.698 .454 .55 r
.50124 .54175 .50468 .54926 .50742 .53969 .50399 .53223 Mtetra
.704 .456 .547 r
.50399 .53223 .50742 .53969 .51013 .5298 .50671 .52238 Mtetra
.691 .451 .554 r
.50671 .52238 .51013 .5298 .51284 .5208 .50942 .51342 Mtetra
.655 .435 .574 r
.50942 .51342 .51284 .5208 .51556 .51374 .51214 .5064 Mtetra
.575 .4 .607 r
.51214 .5064 .51556 .51374 .51831 .50933 .51488 .502 Mtetra
.409 .321 .645 r
.51488 .502 .51831 .50933 .5211 .50782 .51766 .50048 Mtetra
.117 .17 .643 r
.51766 .50048 .5211 .50782 .52396 .509 .5205 .50163 Mtetra
0 0 .563 r
.5205 .50163 .52396 .509 .52686 .51218 .52338 .50477 Mtetra
0 0 .494 r
.52338 .50477 .52686 .51218 .52982 .51634 .52631 .50889 Mtetra
0 0 .515 r
.52631 .50889 .52982 .51634 .53279 .52028 .52927 .51279 Mtetra
0 .062 .602 r
.52927 .51279 .53279 .52028 .53576 .52281 .53222 .51527 Mtetra
.25 .239 .652 r
.53222 .51527 .53576 .52281 .5387 .52295 .53513 .5154 Mtetra
.488 .358 .629 r
.53513 .5154 .5387 .52295 .54156 .52019 .53799 .51263 Mtetra
.612 .414 .59 r
.53799 .51263 .54156 .52019 .54434 .51452 .54077 .50699 Mtetra
.67 .439 .562 r
.54077 .50699 .54434 .51452 .54705 .5065 .54347 .499 Mtetra
.696 .45 .547 r
.54347 .499 .54705 .5065 .54969 .49707 .54612 .48962 Mtetra
.7 .451 .545 r
.54612 .48962 .54969 .49707 .55232 .48745 .54875 .48004 Mtetra
.684 .445 .554 r
.54875 .48004 .55232 .48745 .55496 .47882 .55139 .47145 Mtetra
.642 .428 .577 r
.55139 .47145 .55496 .47882 .55766 .4722 .55409 .46485 Mtetra
.552 .389 .613 r
.55409 .46485 .55766 .4722 .56046 .46824 .55688 .4609 Mtetra
.371 .304 .651 r
.55688 .4609 .56046 .46824 .56338 .46714 .55979 .45979 Mtetra
.077 .153 .642 r
.55979 .45979 .56338 .46714 .56642 .46866 .56282 .46128 Mtetra
0 0 .566 r
.56282 .46128 .56642 .46866 .56957 .47207 .56594 .46465 Mtetra
0 0 .512 r
.56594 .46465 .56957 .47207 .5728 .47635 .56914 .46888 Mtetra
0 0 .538 r
.56914 .46888 .5728 .47635 .57603 .48029 .57235 .47277 Mtetra
0 .087 .617 r
.57235 .47277 .57603 .48029 .57922 .48271 .57552 .47516 Mtetra
.266 .251 .655 r
.57552 .47516 .57922 .48271 .58231 .48271 .57859 .47514 Mtetra
.492 .359 .628 r
.57859 .47514 .58231 .48271 .58525 .4798 .58152 .47223 Mtetra
.611 .412 .588 r
.58152 .47223 .58525 .4798 .58804 .47404 .5843 .46649 Mtetra
.669 .436 .559 r
.5843 .46649 .58804 .47404 .59069 .46602 .58696 .4585 Mtetra
.693 .445 .544 r
.58696 .4585 .59069 .46602 .59325 .45672 .58952 .44925 Mtetra
.695 .446 .542 r
.58952 .44925 .59325 .45672 .59579 .44734 .59206 .43992 Mtetra
.676 .439 .554 r
.59206 .43992 .59579 .44734 .59837 .43906 .59466 .43167 Mtetra
.628 .42 .58 r
.59466 .43167 .59837 .43906 .60108 .43285 .59736 .42549 Mtetra
.527 .377 .62 r
.59736 .42549 .60108 .43285 .60397 .42933 .60024 .42196 Mtetra
.333 .287 .656 r
.60024 .42196 .60397 .42933 .60705 .42864 .60331 .42126 Mtetra
.042 .14 .641 r
.60331 .42126 .60705 .42864 .61033 .43048 .60657 .42308 Mtetra
0 .001 .572 r
.60657 .42308 .61033 .43048 .61377 .43413 .60998 .42668 Mtetra
0 0 .53 r
.60998 .42668 .61377 .43413 .61729 .43852 .61347 .43102 Mtetra
0 0 .56 r
.61347 .43102 .61729 .43852 .62082 .44245 .61697 .4349 Mtetra
0 .11 .63 r
.61697 .4349 .62082 .44245 .62425 .44478 .62037 .43719 Mtetra
.281 .26 .658 r
.62037 .43719 .62425 .44478 .6275 .44463 .62361 .43702 Mtetra
.495 .36 .627 r
.62361 .43702 .6275 .44463 .63053 .44156 .62662 .43396 Mtetra
.61 .409 .585 r
.62662 .43396 .63053 .44156 .63332 .4357 .62942 .42812 Mtetra
.666 .431 .555 r
.62942 .42812 .63332 .4357 .63592 .42767 .63202 .42012 Mtetra
.689 .44 .54 r
.63202 .42012 .63592 .42767 .6384 .41849 .6345 .41098 Mtetra
.69 .44 .54 r
.6345 .41098 .6384 .41849 .64087 .40934 .63698 .40188 Mtetra
.667 .432 .555 r
.63698 .40188 .64087 .40934 .64343 .40139 .63954 .39396 Mtetra
.612 .411 .585 r
.63954 .39396 .64343 .40139 .64618 .39558 .64228 .38817 Mtetra
.5 .364 .627 r
.64228 .38817 .64618 .39558 .64919 .39247 .64528 .38506 Mtetra
.294 .27 .661 r
.64528 .38506 .64919 .39247 .65248 .39217 .64855 .38475 Mtetra
.013 .13 .642 r
.64855 .38475 .65248 .39217 .65604 .39435 .65209 .38689 Mtetra
0 .01 .58 r
.65209 .38689 .65604 .39435 .6598 .39822 .65583 .39071 Mtetra
0 0 .549 r
.65583 .39071 .6598 .39822 .66367 .40273 .65966 .39517 Mtetra
0 .012 .581 r
.65966 .39517 .66367 .40273 .66751 .40666 .66347 .39905 Mtetra
.017 .131 .642 r
.66347 .39905 .66751 .40666 .67121 .40889 .66714 .40124 Mtetra
.294 .269 .66 r
.66714 .40124 .67121 .40889 .67464 .40858 .67056 .40091 Mtetra
.497 .361 .625 r
.67056 .40091 .67464 .40858 .67776 .40536 .67367 .39769 Mtetra
.609 .406 .582 r
.67367 .39769 .67776 .40536 .68057 .39939 .67647 .39174 Mtetra
.664 .427 .551 r
.67647 .39174 .68057 .39939 .68312 .39134 .67902 .38373 Mtetra
.685 .434 .537 r
.67902 .38373 .68312 .39134 .68553 .38224 .68144 .37468 Mtetra
.683 .434 .538 r
.68144 .37468 .68553 .38224 .68794 .37331 .68385 .36579 Mtetra
.657 .425 .556 r
.68385 .36579 .68794 .37331 .69049 .36567 .68641 .35818 Mtetra
.595 .401 .59 r
.68641 .35818 .69049 .36567 .69331 .36024 .68922 .35277 Mtetra
.471 .351 .635 r
.68922 .35277 .69331 .36024 .69648 .35754 .69238 .35007 Mtetra
.256 .255 .666 r
.69238 .35007 .69648 .35754 .70003 .35763 .69591 .35014 Mtetra
0 .124 .643 r
.69591 .35014 .70003 .35763 .70393 .36013 .69978 .3526 Mtetra
0 .021 .589 r
.69978 .3526 .70393 .36013 .70807 .36424 .70389 .35665 Mtetra
0 0 .568 r
.70389 .35665 .70807 .36424 .71233 .36886 .70811 .36122 Mtetra
0 .038 .6 r
.70811 .36122 .71233 .36886 .71653 .37279 .71228 .3651 Mtetra
.045 .151 .652 r
.71228 .3651 .71653 .37279 .72051 .37492 .71623 .36719 Mtetra
.306 .276 .661 r
.71623 .36719 .72051 .37492 .72415 .37446 .71985 .36671 Mtetra
.499 .361 .623 r
.71985 .36671 .72415 .37446 .72737 .37107 .72306 .36332 Mtetra
.608 .403 .579 r
.72306 .36332 .72737 .37107 .73019 .36498 .72587 .35725 Mtetra
.661 .422 .548 r
.72587 .35725 .73019 .36498 .7327 .35689 .72838 .3492 Mtetra
.681 .428 .534 r
.72838 .3492 .7327 .35689 .73504 .34787 .73074 .34023 Mtetra
.676 .427 .537 r
.73074 .34023 .73504 .34787 .73741 .33913 .73311 .33153 Mtetra
.646 .417 .557 r
.73311 .33153 .73741 .33913 .73998 .3318 .73568 .32423 Mtetra
.575 .392 .595 r
.73568 .32423 .73998 .3318 .74291 .32674 .73861 .31918 Mtetra
.44 .338 .643 r
.73861 .31918 .74291 .32674 .7463 .32444 .74198 .31688 Mtetra
.221 .241 .67 r
.74198 .31688 .7463 .32444 .75016 .32492 .74582 .31733 Mtetra
0 .121 .645 r
.74582 .31733 .75016 .32492 .75445 .32774 .75007 .32011 Mtetra
0 .035 .6 r
.75007 .32011 .75445 .32774 .75904 .33208 .75462 .3244 Mtetra
0 .015 .587 r
.75462 .3244 .75904 .33208 .76374 .33683 .75929 .32908 Mtetra
0 .064 .618 r
.75929 .32908 .76374 .33683 .76834 .34076 .76386 .33296 Mtetra
.071 .169 .661 r
.76386 .33296 .76834 .34076 .77265 .3428 .76813 .33496 Mtetra
.316 .283 .662 r
.76813 .33496 .77265 .3428 .77651 .34217 .77197 .33432 Mtetra
.573 .378 .579 r
.33075 .74304 .33356 .75248 .33636 .74718 .33354 .73777 Mtetra
.643 .419 .562 r
.33354 .73777 .33636 .74718 .33938 .73898 .33656 .72961 Mtetra
.677 .438 .552 r
.33656 .72961 .33938 .73898 .34255 .72871 .33973 .7194 Mtetra
.689 .444 .548 r
.33973 .7194 .34255 .72871 .34578 .71756 .34295 .70832 Mtetra
.684 .442 .549 r
.34295 .70832 .34578 .71756 .34895 .70688 .34613 .6977 Mtetra
.661 .429 .557 r
.34613 .6977 .34895 .70688 .35198 .69787 .34916 .68875 Mtetra
.609 .4 .572 r
.34916 .68875 .35198 .69787 .35481 .69146 .35198 .68236 Mtetra
.504 .339 .591 r
.35198 .68236 .35481 .69146 .35742 .68809 .35458 .679 Mtetra
.299 .22 .596 r
.35458 .679 .35742 .68809 .35981 .68774 .35696 .67863 Mtetra
0 .033 .546 r
.35696 .67863 .35981 .68774 .36205 .68986 .35918 .68072 Mtetra
0 0 .458 r
.35918 .68072 .36205 .68986 .36419 .6935 .3613 .68431 Mtetra
0 0 .439 r
.3613 .68431 .36419 .6935 .36634 .69741 .36343 .68817 Mtetra
0 0 .511 r
.36343 .68817 .36634 .69741 .36857 .7003 .36565 .69101 Mtetra
.185 .152 .585 r
.36565 .69101 .36857 .7003 .37096 .70102 .36803 .69171 Mtetra
.437 .299 .595 r
.36803 .69171 .37096 .70102 .37355 .69881 .3706 .6895 Mtetra
.574 .378 .577 r
.3706 .6895 .37355 .69881 .37634 .69346 .37338 .68417 Mtetra
.642 .416 .56 r
.37338 .68417 .37634 .69346 .37929 .68532 .37633 .67608 Mtetra
.675 .434 .549 r
.37633 .67608 .37929 .68532 .38235 .67526 .37938 .66608 Mtetra
.685 .44 .545 r
.37938 .66608 .38235 .67526 .38543 .66448 .38247 .65536 Mtetra
.679 .436 .548 r
.38247 .65536 .38543 .66448 .38846 .65428 .3855 .64522 Mtetra
.652 .422 .557 r
.3855 .64522 .38846 .65428 .39138 .64581 .38842 .6368 Mtetra
.594 .39 .574 r
.38842 .6368 .39138 .64581 .39414 .63994 .39118 .63095 Mtetra
.478 .324 .594 r
.39118 .63095 .39414 .63994 .39675 .63707 .39377 .62809 Mtetra
.259 .199 .597 r
.39377 .62809 .39675 .63707 .39921 .63712 .39622 .62812 Mtetra
0 .019 .544 r
.39622 .62812 .39921 .63712 .40156 .63952 .39856 .63048 Mtetra
0 0 .466 r
.39856 .63048 .40156 .63952 .40387 .64329 .40084 .6342 Mtetra
0 0 .458 r
.40084 .6342 .40387 .64329 .40619 .6472 .40314 .63806 Mtetra
0 0 .528 r
.40314 .63806 .40619 .6472 .40858 .64999 .40552 .6408 Mtetra
.204 .167 .592 r
.40552 .6408 .40858 .64999 .4111 .65056 .40801 .64134 Mtetra
.443 .304 .596 r
.40801 .64134 .4111 .65056 .41374 .64821 .41065 .639 Mtetra
.575 .377 .576 r
.41065 .639 .41374 .64821 .41653 .6428 .41342 .63361 Mtetra
.641 .413 .557 r
.41342 .63361 .41653 .6428 .41941 .63471 .41631 .62557 Mtetra
.672 .43 .546 r
.41631 .62557 .41941 .63471 .42235 .62486 .41925 .61577 Mtetra
.681 .435 .542 r
.41925 .61577 .42235 .62486 .4253 .61441 .4222 .60539 Mtetra
.673 .43 .546 r
.4222 .60539 .4253 .61441 .42821 .60465 .42511 .59568 Mtetra
.642 .414 .557 r
.42511 .59568 .42821 .60465 .43104 .59669 .42794 .58777 Mtetra
.577 .379 .576 r
.42794 .58777 .43104 .59669 .43377 .59133 .43066 .58243 Mtetra
.449 .309 .598 r
.43066 .58243 .43377 .59133 .43641 .58894 .43329 .58004 Mtetra
.219 .179 .598 r
.43329 .58004 .43641 .58894 .43896 .58937 .43582 .58045 Mtetra
0 .009 .543 r
.43582 .58045 .43896 .58937 .44146 .59203 .43831 .58306 Mtetra
0 0 .476 r
.43831 .58306 .44146 .59203 .44395 .59592 .44077 .5869 Mtetra
0 0 .477 r
.44077 .5869 .44395 .59592 .44646 .59983 .44326 .59076 Mtetra
0 .012 .544 r
.44326 .59076 .44646 .59983 .44903 .60251 .44581 .5934 Mtetra
.222 .18 .597 r
.44581 .5934 .44903 .60251 .45166 .60293 .44843 .5938 Mtetra
.448 .307 .596 r
.44843 .5938 .45166 .60293 .45438 .60045 .45113 .59131 Mtetra
.575 .376 .574 r
.45113 .59131 .45438 .60045 .45716 .59497 .4539 .58585 Mtetra
.64 .41 .554 r
.4539 .58585 .45716 .59497 .45998 .58693 .45672 .57786 Mtetra
.669 .426 .543 r
.45672 .57786 .45998 .58693 .46282 .57725 .45956 .56823 Mtetra
.677 .43 .54 r
.45956 .56823 .46282 .57725 .46565 .56711 .46239 .55816 Mtetra
.666 .424 .544 r
.46239 .55816 .46565 .56711 .46845 .55776 .46519 .54887 Mtetra
.631 .406 .558 r
.46519 .54887 .46845 .55776 .47121 .55028 .46795 .54143 Mtetra
.559 .368 .579 r
.46795 .54143 .47121 .55028 .47393 .54542 .47067 .53658 Mtetra
.419 .293 .601 r
.47067 .53658 .47393 .54542 .47663 .54347 .47335 .53463 Mtetra
.181 .161 .599 r
.47335 .53463 .47663 .54347 .4793 .54427 .47601 .5354 Mtetra
0 .003 .544 r
.47601 .5354 .4793 .54427 .48198 .54717 .47867 .53826 Mtetra
0 0 .488 r
.47867 .53826 .48198 .54717 .48468 .55118 .48134 .54221 Mtetra
0 0 .496 r
.48134 .54221 .48468 .55118 .4874 .55508 .48404 .54606 Mtetra
0 .035 .559 r
.48404 .54606 .4874 .55508 .49015 .55767 .48676 .5486 Mtetra
.238 .192 .602 r
.48676 .5486 .49015 .55767 .49292 .55794 .48952 .54885 Mtetra
.453 .31 .596 r
.48952 .54885 .49292 .55794 .4957 .55532 .49229 .54623 Mtetra
.575 .374 .572 r
.49229 .54623 .4957 .55532 .49848 .54976 .49506 .54069 Mtetra
.638 .407 .551 r
.49506 .54069 .49848 .54976 .50124 .54175 .49782 .53273 Mtetra
.666 .421 .54 r
.49782 .53273 .50124 .54175 .50399 .53223 .50056 .52327 Mtetra
.672 .424 .537 r
.50056 .52327 .50399 .53223 .50671 .52238 .50329 .51348 Mtetra
.658 .417 .543 r
.50329 .51348 .50671 .52238 .50942 .51342 .506 .50457 Mtetra
.619 .397 .558 r
.506 .50457 .50942 .51342 .51214 .5064 .50872 .49758 Mtetra
.539 .356 .582 r
.50872 .49758 .51214 .5064 .51488 .502 .51145 .4932 Mtetra
.387 .277 .605 r
.51145 .4932 .51488 .502 .51766 .50048 .51422 .49167 Mtetra
.145 .145 .6 r
.51422 .49167 .51766 .50048 .5205 .50163 .51703 .49279 Mtetra
0 .001 .547 r
.51703 .49279 .5205 .50163 .52338 .50477 .5199 .49588 Mtetra
0 0 .501 r
.5199 .49588 .52338 .50477 .52631 .50889 .5228 .49994 Mtetra
0 0 .515 r
.5228 .49994 .52631 .50889 .52927 .51279 .52573 .50379 Mtetra
0 .057 .573 r
.52573 .50379 .52927 .51279 .53222 .51527 .52865 .50623 Mtetra
.252 .203 .607 r
.52865 .50623 .53222 .51527 .53513 .5154 .53155 .50633 Mtetra
.457 .312 .595 r
.53155 .50633 .53513 .5154 .53799 .51263 .53439 .50357 Mtetra
.575 .372 .569 r
.53439 .50357 .53799 .51263 .54077 .50699 .53716 .49795 Mtetra
.635 .403 .548 r
.53716 .49795 .54077 .50699 .54347 .499 .53987 .49 Mtetra
.663 .416 .536 r
.53987 .49 .54347 .499 .54612 .48962 .54252 .48068 Mtetra
.667 .418 .534 r
.54252 .48068 .54612 .48962 .54875 .48004 .54515 .47116 Mtetra
.65 .41 .542 r
.54515 .47116 .54875 .48004 .55139 .47145 .54779 .46262 Mtetra
.606 .388 .56 r
.54779 .46262 .55139 .47145 .55409 .46485 .55049 .45606 Mtetra
.517 .344 .586 r
.55049 .45606 .55409 .46485 .55688 .4609 .55327 .45211 Mtetra
.354 .261 .609 r
.55327 .45211 .55688 .4609 .55979 .45979 .55616 .451 Mtetra
.112 .132 .601 r
.55616 .451 .55979 .45979 .56282 .46128 .55917 .45245 Mtetra
0 .002 .552 r
.55917 .45245 .56282 .46128 .56594 .46465 .56227 .45577 Mtetra
0 0 .515 r
.56227 .45577 .56594 .46465 .56914 .46888 .56544 .45994 Mtetra
0 0 .533 r
.56544 .45994 .56914 .46888 .57235 .47277 .56862 .46377 Mtetra
.014 .077 .585 r
.56862 .46377 .57235 .47277 .57552 .47516 .57176 .46612 Mtetra
.266 .213 .61 r
.57176 .46612 .57552 .47516 .57859 .47514 .57481 .46607 Mtetra
.46 .314 .595 r
.57481 .46607 .57859 .47514 .58152 .47223 .57773 .46316 Mtetra
.574 .37 .567 r
.57773 .46316 .58152 .47223 .5843 .46649 .58051 .45745 Mtetra
.633 .398 .545 r
.58051 .45745 .5843 .46649 .58696 .4585 .58316 .44951 Mtetra
.658 .41 .533 r
.58316 .44951 .58696 .4585 .58952 .44925 .58573 .44032 Mtetra
.661 .411 .532 r
.58573 .44032 .58952 .44925 .59206 .43992 .58827 .43104 Mtetra
.641 .402 .541 r
.58827 .43104 .59206 .43992 .59466 .43167 .59086 .42284 Mtetra
.591 .379 .562 r
.59086 .42284 .59466 .43167 .59736 .42549 .59357 .41669 Mtetra
.493 .332 .59 r
.59357 .41669 .59736 .42549 .60024 .42196 .59643 .41317 Mtetra
.322 .246 .613 r
.59643 .41317 .60024 .42196 .60331 .42126 .59948 .41245 Mtetra
.084 .121 .602 r
.59948 .41245 .60331 .42126 .60657 .42308 .60272 .41423 Mtetra
0 .007 .558 r
.60272 .41423 .60657 .42308 .60998 .42668 .6061 .41777 Mtetra
0 0 .53 r
.6061 .41777 .60998 .42668 .61347 .43102 .60956 .42205 Mtetra
0 0 .55 r
.60956 .42205 .61347 .43102 .61697 .4349 .61302 .42588 Mtetra
.039 .097 .595 r
.61302 .42588 .61697 .4349 .62037 .43719 .6164 .42812 Mtetra
.278 .222 .613 r
.6164 .42812 .62037 .43719 .62361 .43702 .61961 .42793 Mtetra
.463 .315 .594 r
.61961 .42793 .62361 .43702 .62662 .43396 .62262 .42487 Mtetra
.573 .367 .564 r
.62262 .42487 .62662 .43396 .62942 .42812 .6254 .41905 Mtetra
.63 .393 .541 r
.6254 .41905 .62942 .42812 .63202 .42012 .62801 .41111 Mtetra
.654 .404 .529 r
.62801 .41111 .63202 .42012 .6345 .41098 .6305 .40202 Mtetra
.6305 .40202 .6345 .41098 .63698 .40188 .63297 .39297 Mtetra
.631 .394 .541 r
.63297 .39297 .63698 .40188 .63954 .39396 .63553 .3851 Mtetra
.575 .369 .564 r
.63553 .3851 .63954 .39396 .64228 .38817 .63827 .37934 Mtetra
.468 .319 .595 r
.63827 .37934 .64228 .38817 .64528 .38506 .64126 .37623 Mtetra
.289 .231 .617 r
.64126 .37623 .64528 .38506 .64855 .38475 .64451 .3759 Mtetra
.06 .113 .605 r
.64451 .3759 .64855 .38475 .65209 .38689 .64802 .37799 Mtetra
0 .014 .566 r
.64802 .37799 .65209 .38689 .65583 .39071 .65172 .38176 Mtetra
0 0 .545 r
.65172 .38176 .65583 .39071 .65966 .39517 .65552 .38615 Mtetra
0 .015 .566 r
.65552 .38615 .65966 .39517 .66347 .39905 .6593 .38997 Mtetra
.063 .115 .605 r
.6593 .38997 .66347 .39905 .66714 .40124 .66293 .39212 Mtetra
.289 .23 .616 r
.66293 .39212 .66714 .40124 .67056 .40091 .66633 .39177 Mtetra
.465 .315 .592 r
.66633 .39177 .67056 .40091 .67367 .39769 .66942 .38855 Mtetra
.571 .364 .561 r
.66942 .38855 .67367 .39769 .67647 .39174 .67222 .38263 Mtetra
.626 .388 .537 r
.67222 .38263 .67647 .39174 .67902 .38373 .67477 .37466 Mtetra
.649 .398 .526 r
.67477 .37466 .67902 .38373 .68144 .37468 .67719 .36567 Mtetra
.647 .397 .527 r
.67719 .36567 .68144 .37468 .68385 .36579 .67961 .35683 Mtetra
.619 .385 .541 r
.67961 .35683 .68385 .36579 .68641 .35818 .68217 .34927 Mtetra
.557 .358 .567 r
.68217 .34927 .68641 .35818 .68922 .35277 .68497 .34388 Mtetra
.442 .306 .6 r
.68497 .34388 .68922 .35277 .69238 .35007 .68812 .34118 Mtetra
.258 .218 .621 r
.68812 .34118 .69238 .35007 .69591 .35014 .69162 .34122 Mtetra
.04 .109 .608 r
.69162 .34122 .69591 .35014 .69978 .3526 .69546 .34363 Mtetra
0 .023 .575 r
.69546 .34363 .69978 .3526 .70389 .35665 .69953 .34763 Mtetra
0 0 .561 r
.69953 .34763 .70389 .35665 .70811 .36122 .70371 .35212 Mtetra
0 .038 .582 r
.70371 .35212 .70811 .36122 .71228 .3651 .70784 .35594 Mtetra
.085 .131 .613 r
.70784 .35594 .71228 .3651 .71623 .36719 .71177 .35799 Mtetra
.299 .237 .617 r
.71177 .35799 .71623 .36719 .71985 .36671 .71536 .35748 Mtetra
.467 .315 .591 r
.71536 .35748 .71985 .36671 .72306 .36332 .71855 .3541 Mtetra
.569 .36 .558 r
.71855 .3541 .72306 .36332 .72587 .35725 .72136 .34806 Mtetra
.622 .382 .533 r
.72136 .34806 .72587 .35725 .72838 .3492 .72387 .34006 Mtetra
.643 .391 .522 r
.72387 .34006 .72838 .3492 .73074 .34023 .72623 .33114 Mtetra
.638 .389 .525 r
.72623 .33114 .73074 .34023 .73311 .33153 .7286 .3225 Mtetra
.607 .376 .541 r
.7286 .3225 .73311 .33153 .73568 .32423 .73118 .31523 Mtetra
.538 .347 .57 r
.73118 .31523 .73568 .32423 .73861 .31918 .73409 .31021 Mtetra
.414 .293 .605 r
.73409 .31021 .73861 .31918 .74198 .31688 .73745 .3079 Mtetra
.229 .207 .625 r
.73745 .3079 .74198 .31688 .74582 .31733 .74126 .30832 Mtetra
.026 .107 .612 r
.74126 .30832 .74582 .31733 .75007 .32011 .74548 .31105 Mtetra
0 .035 .584 r
.74548 .31105 .75007 .32011 .75462 .3244 .74998 .31526 Mtetra
0 .018 .576 r
.74998 .31526 .75462 .3244 .75929 .32908 .7546 .31988 Mtetra
0 .059 .595 r
.7546 .31988 .75929 .32908 .76386 .33296 .75913 .32369 Mtetra
.106 .146 .621 r
.75913 .32369 .76386 .33296 .76813 .33496 .76337 .32564 Mtetra
.308 .243 .619 r
.76337 .32564 .76813 .33496 .77197 .33432 .76718 .32498 Mtetra
.565 .369 .574 r
.32799 .73324 .33075 .74304 .33354 .73777 .33077 .72799 Mtetra
.636 .411 .559 r
.33077 .72799 .33354 .73777 .33656 .72961 .33379 .71988 Mtetra
.67 .431 .55 r
.33379 .71988 .33656 .72961 .33973 .7194 .33696 .70973 Mtetra
.682 .438 .546 r
.33696 .70973 .33973 .7194 .34295 .70832 .34018 .69873 Mtetra
.677 .435 .547 r
.34018 .69873 .34295 .70832 .34613 .6977 .34335 .68818 Mtetra
.654 .421 .555 r
.34335 .68818 .34613 .6977 .34916 .68875 .34638 .67928 Mtetra
.602 .391 .568 r
.34638 .67928 .34916 .68875 .35198 .68236 .3492 .67292 Mtetra
.497 .33 .584 r
.3492 .67292 .35198 .68236 .35458 .679 .35179 .66957 Mtetra
.297 .212 .587 r
.35179 .66957 .35458 .679 .35696 .67863 .35415 .66918 Mtetra
0 .032 .539 r
.35415 .66918 .35696 .67863 .35918 .68072 .35635 .67123 Mtetra
0 0 .459 r
.35635 .67123 .35918 .68072 .3613 .68431 .35846 .67477 Mtetra
0 0 .441 r
.35846 .67477 .3613 .68431 .36343 .68817 .36057 .67858 Mtetra
0 0 .507 r
.36057 .67858 .36343 .68817 .36565 .69101 .36277 .68138 Mtetra
.189 .146 .576 r
.36277 .68138 .36565 .69101 .36803 .69171 .36513 .68205 Mtetra
.431 .29 .588 r
.36513 .68205 .36803 .69171 .3706 .6895 .3677 .67983 Mtetra
.566 .369 .573 r
.3677 .67983 .3706 .6895 .37338 .68417 .37047 .67453 Mtetra
.635 .408 .557 r
.37047 .67453 .37338 .68417 .37633 .67608 .37342 .66648 Mtetra
.668 .427 .547 r
.37342 .66648 .37633 .67608 .37938 .66608 .37647 .65655 Mtetra
.678 .433 .543 r
.37647 .65655 .37938 .66608 .38247 .65536 .37955 .6459 Mtetra
.672 .429 .545 r
.37955 .6459 .38247 .65536 .3855 .64522 .38258 .63582 Mtetra
.645 .414 .554 r
.38258 .63582 .3855 .64522 .38842 .6368 .3855 .62745 Mtetra
.586 .381 .569 r
.3855 .62745 .38842 .6368 .39118 .63095 .38825 .62163 Mtetra
.471 .315 .587 r
.38825 .62163 .39118 .63095 .39377 .62809 .39084 .61877 Mtetra
.259 .192 .588 r
.39084 .61877 .39377 .62809 .39622 .62812 .39327 .61879 Mtetra
0 .019 .538 r
.39327 .61879 .39622 .62812 .39856 .63048 .39559 .6211 Mtetra
0 0 .467 r
.39559 .6211 .39856 .63048 .40084 .6342 .39785 .62477 Mtetra
0 0 .459 r
.39785 .62477 .40084 .6342 .40314 .63806 .40013 .62857 Mtetra
0 0 .524 r
.40013 .62857 .40314 .63806 .40552 .6408 .40249 .63127 Mtetra
.207 .161 .582 r
.40249 .63127 .40552 .6408 .40801 .64134 .40497 .63179 Mtetra
.437 .294 .588 r
.40497 .63179 .40801 .64134 .41065 .639 .40759 .62944 Mtetra
.567 .368 .571 r
.40759 .62944 .41065 .639 .41342 .63361 .41036 .62408 Mtetra
.633 .405 .554 r
.41036 .62408 .41342 .63361 .41631 .62557 .41324 .61608 Mtetra
.665 .423 .544 r
.41324 .61608 .41631 .62557 .41925 .61577 .41618 .60635 Mtetra
.674 .428 .54 r
.41618 .60635 .41925 .61577 .4222 .60539 .41913 .59603 Mtetra
.665 .423 .544 r
.41913 .59603 .4222 .60539 .42511 .59568 .42204 .58639 Mtetra
.635 .406 .554 r
.42204 .58639 .42511 .59568 .42794 .58777 .42487 .57852 Mtetra
.569 .37 .571 r
.42487 .57852 .42794 .58777 .43066 .58243 .42758 .57321 Mtetra
.443 .299 .59 r
.42758 .57321 .43066 .58243 .43329 .58004 .4302 .57081 Mtetra
.221 .173 .589 r
.4302 .57081 .43329 .58004 .43582 .58045 .43272 .5712 Mtetra
0 .01 .538 r
.43272 .5712 .43582 .58045 .43831 .58306 .43518 .57377 Mtetra
0 0 .477 r
.43518 .57377 .43831 .58306 .44077 .5869 .43763 .57755 Mtetra
0 0 .478 r
.43763 .57755 .44077 .5869 .44326 .59076 .44009 .58135 Mtetra
0 .013 .539 r
.44009 .58135 .44326 .59076 .44581 .5934 .44262 .58395 Mtetra
.223 .174 .588 r
.44262 .58395 .44581 .5934 .44843 .5938 .44522 .58432 Mtetra
.442 .297 .589 r
.44522 .58432 .44843 .5938 .45113 .59131 .44791 .58184 Mtetra
.567 .367 .569 r
.44791 .58184 .45113 .59131 .4539 .58585 .45067 .5764 Mtetra
.632 .402 .551 r
.45067 .5764 .4539 .58585 .45672 .57786 .45349 .56845 Mtetra
.662 .418 .541 r
.45349 .56845 .45672 .57786 .45956 .56823 .45633 .55889 Mtetra
.67 .422 .537 r
.45633 .55889 .45956 .56823 .46239 .55816 .45917 .54888 Mtetra
.658 .416 .542 r
.45917 .54888 .46239 .55816 .46519 .54887 .46197 .53965 Mtetra
.624 .398 .554 r
.46197 .53965 .46519 .54887 .46795 .54143 .46472 .53225 Mtetra
.551 .359 .574 r
.46472 .53225 .46795 .54143 .47067 .53658 .46743 .52742 Mtetra
.413 .283 .594 r
.46743 .52742 .47067 .53658 .47335 .53463 .4701 .52547 Mtetra
.184 .155 .59 r
.4701 .52547 .47335 .53463 .47601 .5354 .47274 .52621 Mtetra
0 .004 .539 r
.47274 .52621 .47601 .5354 .47867 .53826 .47538 .52902 Mtetra
0 0 .488 r
.47538 .52902 .47867 .53826 .48134 .54221 .47802 .53292 Mtetra
0 0 .496 r
.47802 .53292 .48134 .54221 .48404 .54606 .4807 .53671 Mtetra
0 .035 .553 r
.4807 .53671 .48404 .54606 .48676 .5486 .4834 .53921 Mtetra
.239 .185 .593 r
.4834 .53921 .48676 .5486 .48952 .54885 .48614 .53943 Mtetra
.446 .3 .589 r
.48614 .53943 .48952 .54885 .49229 .54623 .48889 .53681 Mtetra
.567 .365 .567 r
.48889 .53681 .49229 .54623 .49506 .54069 .49166 .5313 Mtetra
.63 .398 .548 r
.49166 .5313 .49506 .54069 .49782 .53273 .49442 .52338 Mtetra
.659 .413 .537 r
.49442 .52338 .49782 .53273 .50056 .52327 .49716 .51398 Mtetra
.665 .416 .535 r
.49716 .51398 .50056 .52327 .50329 .51348 .49989 .50425 Mtetra
.651 .409 .54 r
.49989 .50425 .50329 .51348 .506 .50457 .5026 .49541 Mtetra
.611 .389 .555 r
.5026 .49541 .506 .50457 .50872 .49758 .50531 .48845 Mtetra
.531 .347 .577 r
.50531 .48845 .50872 .49758 .51145 .4932 .50804 .48408 Mtetra
.382 .268 .597 r
.50804 .48408 .51145 .4932 .51422 .49167 .51079 .48255 Mtetra
.15 .14 .591 r
.51079 .48255 .51422 .49167 .51703 .49279 .51359 .48363 Mtetra
0 .002 .543 r
.51359 .48363 .51703 .49279 .5199 .49588 .51642 .48668 Mtetra
0 0 .501 r
.51642 .48668 .5199 .49588 .5228 .49994 .5193 .49068 Mtetra
0 0 .513 r
.5193 .49068 .5228 .49994 .52573 .50379 .5222 .49447 Mtetra
0 .056 .566 r
.5222 .49447 .52573 .50379 .52865 .50623 .5251 .49686 Mtetra
.253 .196 .597 r
.5251 .49686 .52865 .50623 .53155 .50633 .52798 .49694 Mtetra
.45 .303 .588 r
.52798 .49694 .53155 .50633 .53439 .50357 .53081 .49418 Mtetra
.567 .363 .565 r
.53081 .49418 .53439 .50357 .53716 .49795 .53358 .48859 Mtetra
.627 .394 .545 r
.53358 .48859 .53716 .49795 .53987 .49 .53628 .48069 Mtetra
.655 .408 .534 r
.53628 .48069 .53987 .49 .54252 .48068 .53894 .47143 Mtetra
.659 .41 .532 r
.53894 .47143 .54252 .48068 .54515 .47116 .54157 .46196 Mtetra
.642 .402 .539 r
.54157 .46196 .54515 .47116 .54779 .46262 .54421 .45348 Mtetra
.598 .38 .556 r
.54421 .45348 .54779 .46262 .55049 .45606 .5469 .44695 Mtetra
.509 .335 .58 r
.5469 .44695 .55049 .45606 .55327 .45211 .54967 .44302 Mtetra
.351 .252 .601 r
.54967 .44302 .55327 .45211 .55616 .451 .55255 .44189 Mtetra
.119 .127 .592 r
.55255 .44189 .55616 .451 .55917 .45245 .55553 .4433 Mtetra
0 .003 .547 r
.55553 .4433 .55917 .45245 .56227 .45577 .5586 .44657 Mtetra
0 0 .514 r
.5586 .44657 .56227 .45577 .56544 .45994 .56174 .45068 Mtetra
0 0 .53 r
.56174 .45068 .56544 .45994 .56862 .46377 .56489 .45446 Mtetra
.026 .075 .577 r
.56489 .45446 .56862 .46377 .57176 .46612 .56801 .45676 Mtetra
.266 .206 .601 r
.56801 .45676 .57176 .46612 .57481 .46607 .57104 .45668 Mtetra
.454 .304 .588 r
.57104 .45668 .57481 .46607 .57773 .46316 .57394 .45378 Mtetra
.566 .361 .562 r
.57394 .45378 .57773 .46316 .58051 .45745 .57671 .44809 Mtetra
.625 .39 .542 r
.57671 .44809 .58051 .45745 .58316 .44951 .57937 .4402 Mtetra
.651 .402 .53 r
.57937 .4402 .58316 .44951 .58573 .44032 .58194 .43106 Mtetra
.653 .404 .529 r
.58194 .43106 .58573 .44032 .58827 .43104 .58448 .42185 Mtetra
.633 .394 .538 r
.58448 .42185 .58827 .43104 .59086 .42284 .58708 .4137 Mtetra
.583 .37 .557 r
.58708 .4137 .59086 .42284 .59357 .41669 .58977 .40758 Mtetra
.486 .322 .584 r
.58977 .40758 .59357 .41669 .59643 .41317 .59263 .40407 Mtetra
.319 .237 .604 r
.59263 .40407 .59643 .41317 .59948 .41245 .59566 .40333 Mtetra
.092 .117 .594 r
.59566 .40333 .59948 .41245 .60272 .41423 .59887 .40507 Mtetra
0 .008 .554 r
.59887 .40507 .60272 .41423 .6061 .41777 .60222 .40855 Mtetra
0 0 .528 r
.60222 .40855 .6061 .41777 .60956 .42205 .60565 .41277 Mtetra
0 0 .547 r
.60565 .41277 .60956 .42205 .61302 .42588 .60908 .41654 Mtetra
.049 .094 .587 r
.60908 .41654 .61302 .42588 .6164 .42812 .61243 .41874 Mtetra
.277 .214 .604 r
.61243 .41874 .6164 .42812 .61961 .42793 .61562 .41852 Mtetra
.456 .305 .587 r
.61562 .41852 .61961 .42793 .62262 .42487 .61861 .41546 Mtetra
.564 .358 .559 r
.61861 .41546 .62262 .42487 .6254 .41905 .62139 .40968 Mtetra
.621 .385 .538 r
.62139 .40968 .6254 .41905 .62801 .41111 .62399 .40178 Mtetra
.646 .396 .527 r
.62399 .40178 .62801 .41111 .6305 .40202 .62648 .39275 Mtetra
.62648 .39275 .6305 .40202 .63297 .39297 .62896 .38376 Mtetra
.622 .385 .538 r
.62896 .38376 .63297 .39297 .63553 .3851 .63152 .37594 Mtetra
.567 .36 .559 r
.63152 .37594 .63553 .3851 .63827 .37934 .63426 .3702 Mtetra
.461 .309 .588 r
.63426 .3702 .63827 .37934 .64126 .37623 .63723 .3671 Mtetra
.288 .223 .608 r
.63723 .3671 .64126 .37623 .64451 .3759 .64046 .36674 Mtetra
.069 .11 .597 r
.64046 .36674 .64451 .3759 .64802 .37799 .64394 .36879 Mtetra
0 .015 .561 r
.64394 .36879 .64802 .37799 .65172 .38176 .6476 .3725 Mtetra
0 0 .543 r
.6476 .3725 .65172 .38176 .65552 .38615 .65137 .37682 Mtetra
0 .016 .562 r
.65137 .37682 .65552 .38615 .6593 .38997 .65511 .38058 Mtetra
.072 .111 .597 r
.65511 .38058 .6593 .38997 .66293 .39212 .65872 .38268 Mtetra
.288 .222 .606 r
.65872 .38268 .66293 .39212 .66633 .39177 .66209 .38231 Mtetra
.459 .306 .585 r
.66209 .38231 .66633 .39177 .66942 .38855 .66517 .37909 Mtetra
.563 .355 .556 r
.66517 .37909 .66942 .38855 .67222 .38263 .66796 .3732 Mtetra
.618 .38 .534 r
.66796 .3732 .67222 .38263 .67477 .37466 .67051 .36528 Mtetra
.64 .39 .523 r
.67051 .36528 .67477 .37466 .67719 .36567 .67293 .35635 Mtetra
.638 .389 .524 r
.67293 .35635 .67719 .36567 .67961 .35683 .67536 .34757 Mtetra
.611 .377 .537 r
.67536 .34757 .67961 .35683 .68217 .34927 .67791 .34006 Mtetra
.549 .349 .562 r
.67791 .34006 .68217 .34927 .68497 .34388 .68071 .33469 Mtetra
.435 .296 .592 r
.68071 .33469 .68497 .34388 .68812 .34118 .68384 .33199 Mtetra
.258 .211 .612 r
.68384 .33199 .68812 .34118 .69162 .34122 .68732 .332 Mtetra
.05 .105 .6 r
.68732 .332 .69162 .34122 .69546 .34363 .69112 .33437 Mtetra
0 .024 .57 r
.69112 .33437 .69546 .34363 .69953 .34763 .69515 .33829 Mtetra
0 0 .557 r
.69515 .33829 .69953 .34763 .70371 .35212 .69929 .34272 Mtetra
0 .038 .576 r
.69929 .34272 .70371 .35212 .70784 .35594 .70339 .34647 Mtetra
.093 .127 .605 r
.70339 .34647 .70784 .35594 .71177 .35799 .70728 .34847 Mtetra
.298 .229 .608 r
.70728 .34847 .71177 .35799 .71536 .35748 .71084 .34794 Mtetra
.46 .305 .584 r
.71084 .34794 .71536 .35748 .71855 .3541 .71402 .34457 Mtetra
.56 .351 .553 r
.71402 .34457 .71855 .3541 .72136 .34806 .71682 .33855 Mtetra
.614 .374 .53 r
.71682 .33855 .72136 .34806 .72387 .34006 .71934 .3306 Mtetra
.635 .383 .519 r
.71934 .3306 .72387 .34006 .72623 .33114 .7217 .32175 Mtetra
.63 .381 .522 r
.7217 .32175 .72623 .33114 .7286 .3225 .72408 .31316 Mtetra
.598 .367 .537 r
.72408 .31316 .7286 .3225 .73118 .31523 .72665 .30594 Mtetra
.53 .338 .565 r
.72665 .30594 .73118 .31523 .73409 .31021 .72955 .30094 Mtetra
.409 .284 .597 r
.72955 .30094 .73409 .31021 .73745 .3079 .73289 .29862 Mtetra
.23 .2 .616 r
.73289 .29862 .73745 .3079 .74126 .30832 .73667 .29901 Mtetra
.036 .104 .605 r
.73667 .29901 .74126 .30832 .74548 .31105 .74085 .30168 Mtetra
0 .035 .58 r
.74085 .30168 .74548 .31105 .74998 .31526 .74531 .30583 Mtetra
0 .018 .572 r
.74531 .30583 .74998 .31526 .7546 .31988 .74989 .31036 Mtetra
0 .058 .59 r
.74989 .31036 .7546 .31988 .75913 .32369 .75437 .31411 Mtetra
.113 .142 .612 r
.75437 .31411 .75913 .32369 .76337 .32564 .75857 .31601 Mtetra
.306 .234 .61 r
.75857 .31601 .76337 .32564 .76718 .32498 .76235 .31532 Mtetra
.583 .389 .585 r
.32517 .72441 .32799 .73324 .33077 .72799 .32794 .71918 Mtetra
.652 .428 .566 r
.32794 .71918 .33077 .72799 .33379 .71988 .33096 .71111 Mtetra
.685 .446 .555 r
.33096 .71111 .33379 .71988 .33696 .70973 .33413 .70102 Mtetra
.697 .452 .55 r
.33413 .70102 .33696 .70973 .34018 .69873 .33735 .69008 Mtetra
.692 .45 .552 r
.33735 .69008 .34018 .69873 .34335 .68818 .34052 .67959 Mtetra
.67 .438 .561 r
.34052 .67959 .34335 .68818 .34638 .67928 .34355 .67073 Mtetra
.619 .41 .577 r
.34355 .67073 .34638 .67928 .3492 .67292 .34637 .6644 Mtetra
.513 .351 .599 r
.34637 .6644 .3492 .67292 .35179 .66957 .34894 .66106 Mtetra
.301 .23 .608 r
.34894 .66106 .35179 .66957 .35415 .66918 .3513 .66066 Mtetra
0 .033 .554 r
.3513 .66066 .35415 .66918 .35635 .67123 .35349 .66267 Mtetra
0 0 .456 r
.35349 .66267 .35635 .67123 .35846 .67477 .35558 .66617 Mtetra
0 0 .435 r
.35558 .66617 .35846 .67477 .36057 .67858 .35767 .66993 Mtetra
0 0 .515 r
.35767 .66993 .36057 .67858 .36277 .68138 .35985 .67269 Mtetra
.181 .16 .597 r
.35985 .67269 .36277 .68138 .36513 .68205 .3622 .67333 Mtetra
.445 .312 .605 r
.3622 .67333 .36513 .68205 .3677 .67983 .36475 .67112 Mtetra
.584 .389 .583 r
.36475 .67112 .3677 .67983 .37047 .67453 .36752 .66583 Mtetra
.652 .426 .564 r
.36752 .66583 .37047 .67453 .37342 .66648 .37046 .65783 Mtetra
.683 .443 .552 r
.37046 .65783 .37342 .66648 .37647 .65655 .37352 .64795 Mtetra
.693 .448 .548 r
.37352 .64795 .37647 .65655 .37955 .6459 .3766 .63736 Mtetra
.687 .445 .55 r
.3766 .63736 .37955 .6459 .38258 .63582 .37963 .62734 Mtetra
.661 .431 .561 r
.37963 .62734 .38258 .63582 .3855 .62745 .38254 .61901 Mtetra
.604 .401 .579 r
.38254 .61901 .3855 .62745 .38825 .62163 .38529 .61322 Mtetra
.486 .337 .603 r
.38529 .61322 .38825 .62163 .39084 .61877 .38787 .61036 Mtetra
.259 .209 .609 r
.38787 .61036 .39084 .61877 .39327 .61879 .39029 .61035 Mtetra
0 .018 .551 r
.39029 .61035 .39327 .61879 .39559 .6211 .39259 .61263 Mtetra
0 0 .464 r
.39259 .61263 .39559 .6211 .39785 .62477 .39484 .61625 Mtetra
0 0 .455 r
.39484 .61625 .39785 .62477 .40013 .62857 .3971 .62001 Mtetra
0 0 .534 r
.3971 .62001 .40013 .62857 .40249 .63127 .39943 .62267 Mtetra
.201 .175 .603 r
.39943 .62267 .40249 .63127 .40497 .63179 .4019 .62316 Mtetra
.451 .316 .605 r
.4019 .62316 .40497 .63179 .40759 .62944 .40451 .62082 Mtetra
.585 .388 .582 r
.40451 .62082 .40759 .62944 .41036 .62408 .40728 .61547 Mtetra
.65 .423 .561 r
.40728 .61547 .41036 .62408 .41324 .61608 .41015 .60752 Mtetra
.681 .439 .549 r
.41015 .60752 .41324 .61608 .41618 .60635 .4131 .59783 Mtetra
.69 .443 .545 r
.4131 .59783 .41618 .60635 .41913 .59603 .41605 .58758 Mtetra
.681 .439 .549 r
.41605 .58758 .41913 .59603 .42204 .58639 .41896 .57799 Mtetra
.652 .424 .561 r
.41896 .57799 .42204 .58639 .42487 .57852 .42178 .57016 Mtetra
.587 .39 .582 r
.42178 .57016 .42487 .57852 .42758 .57321 .4245 .56487 Mtetra
.457 .321 .607 r
.4245 .56487 .42758 .57321 .4302 .57081 .4271 .56247 Mtetra
.217 .188 .61 r
.4271 .56247 .4302 .57081 .43272 .5712 .4296 .56283 Mtetra
0 .008 .55 r
.4296 .56283 .43272 .5712 .43518 .57377 .43205 .56536 Mtetra
0 0 .475 r
.43205 .56536 .43518 .57377 .43763 .57755 .43447 .5691 Mtetra
0 0 .476 r
.43447 .5691 .43763 .57755 .44009 .58135 .43692 .57285 Mtetra
0 .011 .551 r
.43692 .57285 .44009 .58135 .44262 .58395 .43942 .57541 Mtetra
.22 .189 .609 r
.43942 .57541 .44262 .58395 .44522 .58432 .44201 .57576 Mtetra
.457 .319 .605 r
.44201 .57576 .44522 .58432 .44791 .58184 .44469 .57328 Mtetra
.585 .387 .58 r
.44469 .57328 .44791 .58184 .45067 .5764 .44745 .56786 Mtetra
.649 .42 .558 r
.44745 .56786 .45067 .5764 .45349 .56845 .45027 .55996 Mtetra
.678 .435 .546 r
.45027 .55996 .45349 .56845 .45633 .55889 .45311 .55045 Mtetra
.686 .438 .543 r
.45311 .55045 .45633 .55889 .45917 .54888 .45594 .54049 Mtetra
.675 .433 .548 r
.45594 .54049 .45917 .54888 .46197 .53965 .45875 .53131 Mtetra
.641 .416 .562 r
.45875 .53131 .46197 .53965 .46472 .53225 .4615 .52395 Mtetra
.569 .38 .585 r
.4615 .52395 .46472 .53225 .46743 .52742 .4642 .51914 Mtetra
.426 .305 .611 r
.4642 .51914 .46743 .52742 .4701 .52547 .46686 .51718 Mtetra
.176 .169 .611 r
.46686 .51718 .4701 .52547 .47274 .52621 .46948 .51789 Mtetra
0 .002 .55 r
.46948 .51789 .47274 .52621 .47538 .52902 .4721 .52066 Mtetra
0 0 .487 r
.4721 .52066 .47538 .52902 .47802 .53292 .47472 .52451 Mtetra
0 0 .497 r
.47472 .52451 .47802 .53292 .4807 .53671 .47737 .52825 Mtetra
0 .036 .567 r
.47737 .52825 .4807 .53671 .4834 .53921 .48006 .53071 Mtetra
.237 .202 .614 r
.48006 .53071 .4834 .53921 .48614 .53943 .48278 .53092 Mtetra
.461 .322 .605 r
.48278 .53092 .48614 .53943 .48889 .53681 .48552 .52829 Mtetra
.585 .386 .577 r
.48552 .52829 .48889 .53681 .49166 .5313 .48828 .52281 Mtetra
.647 .417 .555 r
.48828 .52281 .49166 .5313 .49442 .52338 .49104 .51493 Mtetra
.675 .43 .543 r
.49104 .51493 .49442 .52338 .49716 .51398 .49379 .50558 Mtetra
.681 .433 .54 r
.49379 .50558 .49716 .51398 .49989 .50425 .49651 .49591 Mtetra
.668 .427 .546 r
.49651 .49591 .49989 .50425 .5026 .49541 .49923 .48711 Mtetra
.629 .408 .563 r
.49923 .48711 .5026 .49541 .50531 .48845 .50194 .48019 Mtetra
.549 .368 .589 r
.50194 .48019 .50531 .48845 .50804 .48408 .50466 .47583 Mtetra
.393 .289 .616 r
.50466 .47583 .50804 .48408 .51079 .48255 .5074 .47429 Mtetra
.138 .152 .611 r
.5074 .47429 .51079 .48255 .51359 .48363 .51017 .47534 Mtetra
0 0 .553 r
.51017 .47534 .51359 .48363 .51642 .48668 .51299 .47834 Mtetra
0 0 .501 r
.51299 .47834 .51642 .48668 .5193 .49068 .51584 .48229 Mtetra
0 0 .517 r
.51584 .48229 .5193 .49068 .5222 .49447 .51871 .48603 Mtetra
0 .059 .581 r
.51871 .48603 .5222 .49447 .5251 .49686 .52159 .48839 Mtetra
.252 .213 .619 r
.52159 .48839 .5251 .49686 .52798 .49694 .52445 .48844 Mtetra
.465 .324 .604 r
.52445 .48844 .52798 .49694 .53081 .49418 .52727 .48568 Mtetra
.585 .384 .575 r
.52727 .48568 .53081 .49418 .53358 .48859 .53003 .48011 Mtetra
.645 .413 .552 r
.53003 .48011 .53358 .48859 .53628 .48069 .53274 .47225 Mtetra
.672 .425 .54 r
.53274 .47225 .53628 .48069 .53894 .47143 .53539 .46304 Mtetra
.676 .427 .537 r
.53539 .46304 .53894 .47143 .54157 .46196 .53803 .45364 Mtetra
.66 .42 .546 r
.53803 .45364 .54157 .46196 .54421 .45348 .54067 .4452 Mtetra
.616 .399 .565 r
.54067 .4452 .54421 .45348 .5469 .44695 .54336 .4387 Mtetra
.526 .356 .593 r
.54336 .4387 .5469 .44695 .54967 .44302 .54612 .43478 Mtetra
.359 .272 .62 r
.54612 .43478 .54967 .44302 .55255 .44189 .54898 .43364 Mtetra
.104 .138 .612 r
.54898 .43364 .55255 .44189 .55553 .4433 .55194 .43502 Mtetra
0 .001 .557 r
.55194 .43502 .55553 .4433 .5586 .44657 .55499 .43824 Mtetra
0 0 .516 r
.55499 .43824 .5586 .44657 .56174 .45068 .5581 .44229 Mtetra
0 0 .536 r
.5581 .44229 .56174 .45068 .56489 .45446 .56123 .44602 Mtetra
0 .08 .594 r
.56123 .44602 .56489 .45446 .56801 .45676 .56432 .44827 Mtetra
.266 .223 .622 r
.56432 .44827 .56801 .45676 .57104 .45668 .56733 .44818 Mtetra
.469 .326 .604 r
.56733 .44818 .57104 .45668 .57394 .45378 .57022 .44528 Mtetra
.584 .382 .573 r
.57022 .44528 .57394 .45378 .57671 .44809 .57299 .43962 Mtetra
.643 .409 .549 r
.57299 .43962 .57671 .44809 .57937 .4402 .57564 .43177 Mtetra
.668 .42 .536 r
.57564 .43177 .57937 .4402 .58194 .43106 .57821 .42268 Mtetra
.671 .421 .535 r
.57821 .42268 .58194 .43106 .58448 .42185 .58077 .41352 Mtetra
.651 .412 .545 r
.58077 .41352 .58448 .42185 .58708 .4137 .58336 .40542 Mtetra
.601 .39 .567 r
.58336 .40542 .58708 .4137 .58977 .40758 .58605 .39932 Mtetra
.502 .344 .598 r
.58605 .39932 .58977 .40758 .59263 .40407 .5889 .39582 Mtetra
.325 .257 .625 r
.5889 .39582 .59263 .40407 .59566 .40333 .59191 .39506 Mtetra
.074 .126 .613 r
.59191 .39506 .59566 .40333 .59887 .40507 .59509 .39676 Mtetra
0 .006 .563 r
.59509 .39676 .59887 .40507 .60222 .40855 .59842 .4002 Mtetra
0 0 .532 r
.59842 .4002 .60222 .40855 .60565 .41277 .60182 .40436 Mtetra
0 0 .555 r
.60182 .40436 .60565 .41277 .60908 .41654 .60522 .40807 Mtetra
.026 .101 .605 r
.60522 .40807 .60908 .41654 .61243 .41874 .60854 .41023 Mtetra
.279 .232 .625 r
.60854 .41023 .61243 .41874 .61562 .41852 .61171 .40999 Mtetra
.472 .327 .603 r
.61171 .40999 .61562 .41852 .61861 .41546 .61469 .40693 Mtetra
.583 .379 .57 r
.61469 .40693 .61861 .41546 .62139 .40968 .61747 .40117 Mtetra
.64 .404 .545 r
.61747 .40117 .62139 .40968 .62399 .40178 .62007 .39332 Mtetra
.664 .414 .533 r
.62007 .39332 .62399 .40178 .62648 .39275 .62256 .38434 Mtetra
.62256 .38434 .62648 .39275 .62896 .38376 .62505 .3754 Mtetra
.641 .405 .545 r
.62505 .3754 .62896 .38376 .63152 .37594 .62761 .36762 Mtetra
.585 .38 .57 r
.62761 .36762 .63152 .37594 .63426 .3702 .63034 .36191 Mtetra
.477 .331 .604 r
.63034 .36191 .63426 .3702 .63723 .3671 .63329 .35881 Mtetra
.291 .242 .629 r
.63329 .35881 .63723 .3671 .64046 .36674 .63651 .35844 Mtetra
.048 .118 .615 r
.63651 .35844 .64046 .36674 .64394 .36879 .63996 .36044 Mtetra
0 .013 .571 r
.63996 .36044 .64394 .36879 .6476 .3725 .64359 .3641 Mtetra
0 0 .548 r
.64359 .3641 .6476 .3725 .65137 .37682 .64732 .36836 Mtetra
0 .015 .572 r
.64732 .36836 .65137 .37682 .65511 .38058 .65103 .37206 Mtetra
.052 .119 .615 r
.65103 .37206 .65511 .38058 .65872 .38268 .65461 .37412 Mtetra
.291 .24 .627 r
.65461 .37412 .65872 .38268 .66209 .38231 .65796 .37372 Mtetra
.474 .327 .601 r
.65796 .37372 .66209 .38231 .66517 .37909 .66103 .37051 Mtetra
.582 .376 .567 r
.66103 .37051 .66517 .37909 .66796 .3732 .66381 .36465 Mtetra
.637 .399 .541 r
.66381 .36465 .66796 .3732 .67051 .36528 .66637 .35677 Mtetra
.659 .408 .529 r
.66637 .35677 .67051 .36528 .67293 .35635 .6688 .34789 Mtetra
.657 .407 .53 r
.6688 .34789 .67293 .35635 .67536 .34757 .67122 .33916 Mtetra
.63 .396 .545 r
.67122 .33916 .67536 .34757 .67791 .34006 .67378 .33169 Mtetra
.567 .37 .573 r
.67378 .33169 .67791 .34006 .68071 .33469 .67657 .32634 Mtetra
.45 .318 .609 r
.67657 .32634 .68071 .33469 .68384 .33199 .67968 .32364 Mtetra
.258 .228 .633 r
.67968 .32364 .68384 .33199 .68732 .332 .68314 .32363 Mtetra
.028 .113 .618 r
.68314 .32363 .68732 .332 .69112 .33437 .68691 .32595 Mtetra
0 .023 .58 r
.68691 .32595 .69112 .33437 .69515 .33829 .69091 .32982 Mtetra
0 0 .564 r
.69091 .32982 .69515 .33829 .69929 .34272 .69501 .33418 Mtetra
0 .038 .588 r
.69501 .33418 .69929 .34272 .70339 .34647 .69907 .33787 Mtetra
.075 .137 .624 r
.69907 .33787 .70339 .34647 .70728 .34847 .70293 .33983 Mtetra
.301 .247 .629 r
.70293 .33983 .70728 .34847 .71084 .34794 .70647 .33928 Mtetra
.476 .327 .6 r
.70647 .33928 .71084 .34794 .71402 .34457 .70964 .33591 Mtetra
.58 .372 .563 r
.70964 .33591 .71402 .34457 .71682 .33855 .71244 .32993 Mtetra
.633 .393 .537 r
.71244 .32993 .71682 .33855 .71934 .3306 .71495 .32202 Mtetra
.654 .401 .526 r
.71495 .32202 .71934 .3306 .7217 .32175 .71731 .31321 Mtetra
.649 .4 .528 r
.71731 .31321 .7217 .32175 .72408 .31316 .7197 .30468 Mtetra
.618 .387 .546 r
.7197 .30468 .72408 .31316 .72665 .30594 .72227 .29749 Mtetra
.548 .359 .577 r
.72227 .29749 .72665 .30594 .72955 .30094 .72517 .29251 Mtetra
.421 .305 .615 r
.72517 .29251 .72955 .30094 .73289 .29862 .72848 .29018 Mtetra
.227 .216 .637 r
.72848 .29018 .73289 .29862 .73667 .29901 .73224 .29054 Mtetra
.013 .111 .622 r
.73224 .29054 .73667 .29901 .74085 .30168 .73638 .29317 Mtetra
0 .035 .59 r
.73638 .29317 .74085 .30168 .74531 .30583 .74081 .29725 Mtetra
0 .017 .58 r
.74081 .29725 .74531 .30583 .74989 .31036 .74534 .30172 Mtetra
0 .061 .602 r
.74534 .30172 .74989 .31036 .75437 .31411 .74978 .30541 Mtetra
.097 .152 .632 r
.74978 .30541 .75437 .31411 .75857 .31601 .75395 .30727 Mtetra
.311 .253 .63 r
.75395 .30727 .75857 .31601 .76235 .31532 .75771 .30656 Mtetra
.631 .446 .613 r
.32218 .71769 .32517 .72441 .32794 .71918 .32495 .71247 Mtetra
.695 .474 .584 r
.32495 .71247 .32794 .71918 .33096 .71111 .32797 .70443 Mtetra
.723 .486 .568 r
.32797 .70443 .33096 .71111 .33413 .70102 .33114 .69438 Mtetra
.733 .49 .561 r
.33114 .69438 .33413 .70102 .33735 .69008 .33437 .68348 Mtetra
.729 .489 .564 r
.33437 .68348 .33735 .69008 .34052 .67959 .33755 .67303 Mtetra
.71 .481 .576 r
.33755 .67303 .34052 .67959 .34355 .67073 .34058 .66421 Mtetra
.665 .461 .6 r
.34058 .66421 .34355 .67073 .34637 .6644 .34339 .6579 Mtetra
.561 .414 .639 r
.34339 .6579 .34637 .6644 .34894 .66106 .34596 .65455 Mtetra
.313 .289 .672 r
.34596 .65455 .34894 .66106 .3513 .66066 .34831 .65414 Mtetra
0 .036 .591 r
.34831 .65414 .3513 .66066 .35349 .66267 .35048 .65613 Mtetra
0 0 .424 r
.35048 .65613 .35349 .66267 .35558 .66617 .35256 .65959 Mtetra
0 0 .391 r
.35256 .65959 .35558 .66617 .35767 .66993 .35463 .66332 Mtetra
0 0 .524 r
.35463 .66332 .35767 .66993 .35985 .67269 .3568 .66605 Mtetra
.154 .203 .661 r
.3568 .66605 .35985 .67269 .3622 .67333 .35913 .66668 Mtetra
.487 .377 .654 r
.35913 .66668 .3622 .67333 .36475 .67112 .36168 .66446 Mtetra
.632 .445 .612 r
.36168 .66446 .36475 .67112 .36752 .66583 .36445 .65919 Mtetra
.695 .472 .581 r
.36445 .65919 .36752 .66583 .37046 .65783 .36739 .65121 Mtetra
.722 .484 .565 r
.36739 .65121 .37046 .65783 .37352 .64795 .37045 .64137 Mtetra
.731 .487 .559 r
.37045 .64137 .37352 .64795 .3766 .63736 .37354 .63083 Mtetra
.725 .485 .563 r
.37354 .63083 .3766 .63736 .37963 .62734 .37657 .62084 Mtetra
.703 .476 .577 r
.37657 .62084 .37963 .62734 .38254 .61901 .37949 .61254 Mtetra
.651 .454 .604 r
.37949 .61254 .38254 .61901 .38529 .61322 .38224 .60677 Mtetra
.532 .4 .647 r
.38224 .60677 .38529 .61322 .38787 .61036 .38481 .60391 Mtetra
.258 .263 .674 r
.38481 .60391 .38787 .61036 .39029 .61035 .38721 .60389 Mtetra
0 .016 .581 r
.38721 .60389 .39029 .61035 .39259 .61263 .3895 .60614 Mtetra
0 0 .435 r
.3895 .60614 .39259 .61263 .39484 .61625 .39173 .60972 Mtetra
0 0 .42 r
.39173 .60972 .39484 .61625 .3971 .62001 .39397 .61345 Mtetra
0 0 .552 r
.39397 .61345 .3971 .62001 .39943 .62267 .39629 .61608 Mtetra
.182 .222 .669 r
.39629 .61608 .39943 .62267 .4019 .62316 .39875 .61656 Mtetra
.494 .381 .654 r
.39875 .61656 .4019 .62316 .40451 .62082 .40135 .61421 Mtetra
.633 .445 .61 r
.40135 .61421 .40451 .62082 .40728 .61547 .40411 .60887 Mtetra
.694 .47 .579 r
.40411 .60887 .40728 .61547 .41015 .60752 .40699 .60095 Mtetra
.721 .481 .562 r
.40699 .60095 .41015 .60752 .4131 .59783 .40994 .5913 Mtetra
.728 .484 .557 r
.40994 .5913 .4131 .59783 .41605 .58758 .4129 .58109 Mtetra
.721 .481 .562 r
.4129 .58109 .41605 .58758 .41896 .57799 .41581 .57153 Mtetra
.695 .471 .579 r
.41581 .57153 .41896 .57799 .42178 .57016 .41864 .56373 Mtetra
.635 .446 .61 r
.41864 .56373 .42178 .57016 .4245 .56487 .42135 .55846 Mtetra
.5 .386 .655 r
.42135 .55846 .4245 .56487 .4271 .56247 .42394 .55606 Mtetra
.202 .237 .675 r
.42394 .55606 .4271 .56247 .4296 .56283 .42644 .5564 Mtetra
0 .002 .574 r
.42644 .5564 .4296 .56283 .43205 .56536 .42886 .5589 Mtetra
0 0 .448 r
.42886 .5589 .43205 .56536 .43447 .5691 .43127 .5626 Mtetra
0 0 .45 r
.43127 .5626 .43447 .5691 .43692 .57285 .4337 .56632 Mtetra
0 .006 .577 r
.4337 .56632 .43692 .57285 .43942 .57541 .43618 .56885 Mtetra
.206 .239 .675 r
.43618 .56885 .43942 .57541 .44201 .57576 .43876 .56918 Mtetra
.499 .384 .653 r
.43876 .56918 .44201 .57576 .44469 .57328 .44143 .5667 Mtetra
.634 .444 .608 r
.44143 .5667 .44469 .57328 .44745 .56786 .44419 .5613 Mtetra
.694 .468 .576 r
.44419 .5613 .44745 .56786 .45027 .55996 .44701 .55342 Mtetra
.719 .478 .559 r
.44701 .55342 .45027 .55996 .45311 .55045 .44985 .54394 Mtetra
.726 .48 .555 r
.44985 .54394 .45311 .55045 .45594 .54049 .45269 .53403 Mtetra
.716 .477 .561 r
.45269 .53403 .45594 .54049 .45875 .53131 .4555 .52488 Mtetra
.686 .465 .581 r
.4555 .52488 .45875 .53131 .4615 .52395 .45826 .51755 Mtetra
.618 .438 .616 r
.45826 .51755 .4615 .52395 .4642 .51914 .46095 .51275 Mtetra
.464 .37 .664 r
.46095 .51275 .4642 .51914 .46686 .51718 .4636 .51078 Mtetra
.148 .213 .674 r
.4636 .51078 .46686 .51718 .46948 .51789 .46621 .51148 Mtetra
0 0 .57 r
.46621 .51148 .46948 .51789 .4721 .52066 .46881 .51422 Mtetra
0 0 .465 r
.46881 .51422 .4721 .52066 .47472 .52451 .47141 .51803 Mtetra
0 0 .48 r
.47141 .51803 .47472 .52451 .47737 .52825 .47404 .52174 Mtetra
0 .038 .6 r
.47404 .52174 .47737 .52825 .48006 .53071 .47671 .52416 Mtetra
.229 .254 .679 r
.47671 .52416 .48006 .53071 .48278 .53092 .47942 .52435 Mtetra
.505 .387 .653 r
.47942 .52435 .48278 .53092 .48552 .52829 .48216 .52173 Mtetra
.635 .443 .606 r
.48216 .52173 .48552 .52829 .48828 .52281 .48491 .51625 Mtetra
.693 .465 .573 r
.48491 .51625 .48828 .52281 .49104 .51493 .48767 .50841 Mtetra
.718 .474 .556 r
.48767 .50841 .49104 .51493 .49379 .50558 .49042 .49909 Mtetra
.723 .476 .553 r
.49042 .49909 .49379 .50558 .49651 .49591 .49316 .48946 Mtetra
.711 .472 .561 r
.49316 .48946 .49651 .49591 .49923 .48711 .49588 .48069 Mtetra
.676 .459 .584 r
.49588 .48069 .49923 .48711 .50194 .48019 .49859 .47379 Mtetra
.598 .428 .623 r
.49859 .47379 .50194 .48019 .50466 .47583 .5013 .46945 Mtetra
.425 .353 .672 r
.5013 .46945 .50466 .47583 .5074 .47429 .50403 .4679 Mtetra
.098 .19 .672 r
.50403 .4679 .5074 .47429 .51017 .47534 .50679 .46893 Mtetra
0 0 .569 r
.50679 .46893 .51017 .47534 .51299 .47834 .50959 .47189 Mtetra
0 0 .484 r
.50959 .47189 .51299 .47834 .51584 .48229 .51242 .47581 Mtetra
0 0 .509 r
.51242 .47581 .51584 .48229 .51871 .48603 .51527 .47951 Mtetra
0 .068 .62 r
.51527 .47951 .51871 .48603 .52159 .48839 .51813 .48184 Mtetra
.249 .267 .683 r
.51813 .48184 .52159 .48839 .52445 .48844 .52098 .48187 Mtetra
.509 .389 .651 r
.52098 .48187 .52445 .48844 .52727 .48568 .52379 .47911 Mtetra
.635 .441 .603 r
.52379 .47911 .52727 .48568 .53003 .48011 .52655 .47356 Mtetra
.692 .462 .57 r
.52655 .47356 .53003 .48011 .53274 .47225 .52925 .46573 Mtetra
.716 .47 .553 r
.52925 .46573 .53274 .47225 .53539 .46304 .53191 .45655 Mtetra
.719 .472 .551 r
.53191 .45655 .53539 .46304 .53803 .45364 .53456 .44718 Mtetra
.705 .467 .561 r
.53456 .44718 .53803 .45364 .54067 .4452 .5372 .43877 Mtetra
.665 .453 .587 r
.5372 .43877 .54067 .4452 .54336 .4387 .53989 .4323 Mtetra
.575 .418 .631 r
.53989 .4323 .54336 .4387 .54612 .43478 .54265 .42838 Mtetra
.384 .335 .679 r
.54265 .42838 .54612 .43478 .54898 .43364 .5455 .42723 Mtetra
.053 .171 .669 r
.5455 .42723 .54898 .43364 .55194 .43502 .54844 .42859 Mtetra
0 0 .571 r
.54844 .42859 .55194 .43502 .55499 .43824 .55147 .43177 Mtetra
0 0 .504 r
.55147 .43177 .55499 .43824 .5581 .44229 .55455 .43579 Mtetra
0 0 .536 r
.55455 .43579 .5581 .44229 .56123 .44602 .55766 .43947 Mtetra
0 .096 .637 r
.55766 .43947 .56123 .44602 .56432 .44827 .56073 .4417 Mtetra
.267 .278 .686 r
.56073 .4417 .56432 .44827 .56733 .44818 .56372 .44159 Mtetra
.513 .391 .65 r
.56372 .44159 .56733 .44818 .57022 .44528 .56661 .43869 Mtetra
.635 .439 .601 r
.56661 .43869 .57022 .44528 .57299 .43962 .56937 .43304 Mtetra
.69 .459 .567 r
.56937 .43304 .57299 .43962 .57564 .43177 .57203 .42522 Mtetra
.713 .466 .55 r
.57203 .42522 .57564 .43177 .57821 .42268 .57461 .41617 Mtetra
.715 .467 .549 r
.57461 .41617 .57821 .42268 .58077 .41352 .57716 .40704 Mtetra
.698 .461 .562 r
.57716 .40704 .58077 .41352 .58336 .40542 .57976 .39897 Mtetra
.651 .446 .592 r
.57976 .39897 .58336 .40542 .58605 .39932 .58245 .39289 Mtetra
.55 .407 .64 r
.58245 .39289 .58605 .39932 .5889 .39582 .58529 .38939 Mtetra
.341 .317 .686 r
.58529 .38939 .5889 .39582 .59191 .39506 .58829 .38863 Mtetra
.014 .155 .667 r
.58829 .38863 .59191 .39506 .59509 .39676 .59146 .3903 Mtetra
0 0 .577 r
.59146 .3903 .59509 .39676 .59842 .4002 .59475 .3937 Mtetra
0 0 .525 r
.59475 .3937 .59842 .4002 .60182 .40436 .59813 .39781 Mtetra
0 0 .562 r
.59813 .39781 .60182 .40436 .60522 .40807 .6015 .40149 Mtetra
0 .122 .652 r
.6015 .40149 .60522 .40807 .60854 .41023 .60481 .40362 Mtetra
.284 .289 .689 r
.60481 .40362 .60854 .41023 .61171 .40999 .60796 .40336 Mtetra
.517 .392 .649 r
.60796 .40336 .61171 .40999 .61469 .40693 .61093 .4003 Mtetra
.634 .437 .598 r
.61093 .4003 .61469 .40693 .61747 .40117 .6137 .39456 Mtetra
.689 .455 .564 r
.6137 .39456 .61747 .40117 .62007 .39332 .61631 .38673 Mtetra
.711 .462 .547 r
.61631 .38673 .62007 .39332 .62256 .38434 .61881 .37779 Mtetra
.61881 .37779 .62256 .38434 .62505 .3754 .6213 .36889 Mtetra
.69 .456 .563 r
.6213 .36889 .62505 .3754 .62761 .36762 .62387 .36114 Mtetra
.636 .438 .598 r
.62387 .36114 .62761 .36762 .63034 .36191 .62659 .35544 Mtetra
.522 .395 .649 r
.62659 .35544 .63034 .36191 .63329 .35881 .62954 .35234 Mtetra
.298 .299 .692 r
.62954 .35234 .63329 .35881 .63651 .35844 .63274 .35195 Mtetra
0 .143 .665 r
.63274 .35195 .63651 .35844 .63996 .36044 .63617 .35393 Mtetra
0 .01 .585 r
.63617 .35393 .63996 .36044 .64359 .3641 .63978 .35754 Mtetra
0 0 .547 r
.63978 .35754 .64359 .3641 .64732 .36836 .64348 .36176 Mtetra
0 .012 .586 r
.64348 .36176 .64732 .36836 .65103 .37206 .64716 .36542 Mtetra
0 .145 .666 r
.64716 .36542 .65103 .37206 .65461 .37412 .65072 .36745 Mtetra
.298 .298 .69 r
.65072 .36745 .65461 .37412 .65796 .37372 .65405 .36704 Mtetra
.519 .392 .647 r
.65405 .36704 .65796 .37372 .66103 .37051 .65711 .36383 Mtetra
.633 .434 .595 r
.65711 .36383 .66103 .37051 .66381 .36465 .65989 .35798 Mtetra
.687 .451 .56 r
.65989 .35798 .66381 .36465 .66637 .35677 .66245 .35014 Mtetra
.707 .457 .544 r
.66245 .35014 .66637 .35677 .6688 .34789 .66488 .34129 Mtetra
.706 .457 .545 r
.66488 .34129 .6688 .34789 .67122 .33916 .66731 .33259 Mtetra
.68 .449 .565 r
.66731 .33259 .67122 .33916 .67378 .33169 .66987 .32515 Mtetra
.619 .43 .604 r
.66987 .32515 .67378 .33169 .67657 .32634 .67266 .31982 Mtetra
.491 .383 .658 r
.67266 .31982 .67657 .32634 .67968 .32364 .67577 .31711 Mtetra
.256 .282 .696 r
.67577 .31711 .67968 .32364 .68314 .32363 .6792 .31708 Mtetra
0 .136 .664 r
.6792 .31708 .68314 .32363 .68691 .32595 .68295 .31937 Mtetra
0 .022 .595 r
.68295 .31937 .68691 .32595 .69091 .32982 .68692 .32319 Mtetra
0 0 .568 r
.68692 .32319 .69091 .32982 .69501 .33418 .69099 .32751 Mtetra
0 .041 .609 r
.69099 .32751 .69501 .33418 .69907 .33787 .69502 .33116 Mtetra
.019 .166 .677 r
.69502 .33116 .69907 .33787 .70293 .33983 .69885 .33308 Mtetra
.311 .306 .692 r
.69885 .33308 .70293 .33983 .70647 .33928 .70238 .33252 Mtetra
.521 .392 .645 r
.70238 .33252 .70647 .33928 .70964 .33591 .70553 .32915 Mtetra
.632 .431 .592 r
.70553 .32915 .70964 .33591 .71244 .32993 .70833 .32318 Mtetra
.684 .447 .556 r
.70833 .32318 .71244 .32993 .71495 .32202 .71085 .3153 Mtetra
.704 .452 .541 r
.71085 .3153 .71495 .32202 .71731 .31321 .71322 .30654 Mtetra
.699 .451 .544 r
.71322 .30654 .71731 .31321 .7197 .30468 .71561 .29803 Mtetra
.67 .443 .567 r
.71561 .29803 .7197 .30468 .72227 .29749 .71818 .29087 Mtetra
.6 .421 .611 r
.71818 .29087 .72227 .29749 .72517 .29251 .72108 .2859 Mtetra
.458 .369 .668 r
.72108 .2859 .72517 .29251 .72848 .29018 .72438 .28357 Mtetra
.217 .266 .7 r
.72438 .28357 .72848 .29018 .73224 .29054 .72812 .28391 Mtetra
0 .132 .665 r
.72812 .28391 .73224 .29054 .73638 .29317 .73223 .2865 Mtetra
0 .037 .606 r
.73223 .2865 .73638 .29317 .74081 .29725 .73662 .29053 Mtetra
0 .015 .589 r
.73662 .29053 .74081 .29725 .74534 .30172 .74112 .29495 Mtetra
0 .069 .629 r
.74112 .29495 .74534 .30172 .74978 .30541 .74553 .2986 Mtetra
.049 .186 .686 r
.74553 .2986 .74978 .30541 .75395 .30727 .74968 .30042 Mtetra
.323 .312 .692 r
.74968 .30042 .75395 .30727 .75771 .30656 .75342 .2997 Mtetra
.719 .553 .663 r
.31895 .71384 .32218 .71769 .32495 .71247 .32172 .70863 Mtetra
.766 .554 .611 r
.32172 .70863 .32495 .71247 .32797 .70443 .32474 .70059 Mtetra
.784 .553 .586 r
.32474 .70059 .32797 .70443 .33114 .69438 .32792 .69056 Mtetra
.79 .552 .577 r
.32792 .69056 .33114 .69438 .33437 .68348 .33116 .67968 Mtetra
.788 .552 .581 r
.33116 .67968 .33437 .68348 .33755 .67303 .33435 .66924 Mtetra
.776 .553 .598 r
.33435 .66924 .33755 .67303 .34058 .66421 .33738 .66043 Mtetra
.744 .554 .637 r
.33738 .66043 .34058 .66421 .34339 .6579 .3402 .65413 Mtetra
.656 .545 .716 r
.3402 .65413 .34339 .6579 .34596 .65455 .34277 .65078 Mtetra
.335 .445 .824 r
.34277 .65078 .34596 .65455 .34831 .65414 .34511 .65036 Mtetra
0 .038 .579 r
.34511 .65036 .34831 .65414 .35048 .65613 .34727 .65234 Mtetra
.703 .21 0 r
.34727 .65234 .35048 .65613 .35256 .65959 .34934 .65579 Mtetra
.73 .238 0 r
.34934 .65579 .35256 .65959 .35463 .66332 .3514 .6595 Mtetra
.574 .095 0 r
.3514 .6595 .35463 .66332 .3568 .66605 .35355 .66221 Mtetra
.063 .318 .8 r
.35355 .66221 .3568 .66605 .35913 .66668 .35588 .66283 Mtetra
.578 .527 .762 r
.35588 .66283 .35913 .66668 .36168 .66446 .35842 .66061 Mtetra
.721 .552 .661 r
.35842 .66061 .36168 .66446 .36445 .65919 .36119 .65534 Mtetra
.767 .553 .608 r
.36119 .65534 .36445 .65919 .36739 .65121 .36414 .64737 Mtetra
.785 .552 .583 r
.36414 .64737 .36739 .65121 .37045 .64137 .3672 .63755 Mtetra
.79 .551 .575 r
.3672 .63755 .37045 .64137 .37354 .63083 .3703 .62702 Mtetra
.787 .552 .58 r
.3703 .62702 .37354 .63083 .37657 .62084 .37335 .61705 Mtetra
.773 .553 .601 r
.37335 .61705 .37657 .62084 .37949 .61254 .37627 .60876 Mtetra
.735 .553 .647 r
.37627 .60876 .37949 .61254 .38224 .60677 .37902 .60299 Mtetra
.627 .539 .735 r
.37902 .60299 .38224 .60677 .38481 .60391 .38159 .60013 Mtetra
.244 .407 .827 r
.38159 .60013 .38481 .60391 .38721 .60389 .38399 .6001 Mtetra
0 .009 .546 r
.38399 .6001 .38721 .60389 .3895 .60614 .38626 .60234 Mtetra
.69 .196 0 r
.38626 .60234 .3895 .60614 .39173 .60972 .38848 .60591 Mtetra
.702 .209 0 r
.38848 .60591 .39173 .60972 .39397 .61345 .39071 .60961 Mtetra
0 0 .478 r
.39071 .60961 .39397 .61345 .39629 .61608 .39301 .61223 Mtetra
.113 .345 .812 r
.39301 .61223 .39629 .61608 .39875 .61656 .39546 .6127 Mtetra
.585 .529 .758 r
.39546 .6127 .39875 .61656 .40135 .61421 .39806 .61034 Mtetra
.723 .552 .659 r
.39806 .61034 .40135 .61421 .40411 .60887 .40082 .60501 Mtetra
.768 .552 .606 r
.40082 .60501 .40411 .60887 .40699 .60095 .40371 .5971 Mtetra
.786 .551 .581 r
.40371 .5971 .40699 .60095 .40994 .5913 .40667 .58747 Mtetra
.791 .55 .573 r
.40667 .58747 .40994 .5913 .4129 .58109 .40964 .57727 Mtetra
.786 .551 .581 r
.40964 .57727 .4129 .58109 .41581 .57153 .41256 .56773 Mtetra
.769 .552 .605 r
.41256 .56773 .41581 .57153 .41864 .56373 .41539 .55994 Mtetra
.724 .552 .658 r
.41539 .55994 .41864 .56373 .42135 .55846 .4181 .55467 Mtetra
.591 .531 .756 r
.4181 .55467 .42135 .55846 .42394 .55606 .42069 .55226 Mtetra
.15 .364 .819 r
.42069 .55226 .42394 .55606 .42644 .5564 .42318 .5526 Mtetra
0 0 .524 r
.42318 .5526 .42644 .5564 .42886 .5589 .42559 .55509 Mtetra
.673 .179 0 r
.42559 .55509 .42886 .5589 .43127 .5626 .42798 .55877 Mtetra
.671 .177 0 r
.42798 .55877 .43127 .5626 .4337 .56632 .43039 .56247 Mtetra
0 0 .53 r
.43039 .56247 .4337 .56632 .43618 .56885 .43287 .56498 Mtetra
.157 .367 .82 r
.43287 .56498 .43618 .56885 .43876 .56918 .43543 .5653 Mtetra
.592 .531 .755 r
.43543 .5653 .43876 .56918 .44143 .5667 .4381 .56282 Mtetra
.724 .552 .657 r
.4381 .56282 .44143 .5667 .44419 .5613 .44086 .55742 Mtetra
.769 .552 .603 r
.44086 .55742 .44419 .5613 .44701 .55342 .44368 .54955 Mtetra
.787 .55 .578 r
.44368 .54955 .44701 .55342 .44985 .54394 .44654 .54009 Mtetra
.791 .549 .572 r
.44654 .54009 .44985 .54394 .45269 .53403 .44939 .53019 Mtetra
.785 .55 .581 r
.44939 .53019 .45269 .53403 .4555 .52488 .45221 .52106 Mtetra
.764 .552 .611 r
.45221 .52106 .4555 .52488 .45826 .51755 .45497 .51373 Mtetra
.71 .551 .671 r
.45497 .51373 .45826 .51755 .46095 .51275 .45767 .50894 Mtetra
.548 .52 .777 r
.45767 .50894 .46095 .51275 .4636 .51078 .46031 .50697 Mtetra
.06 .321 .803 r
.46031 .50697 .4636 .51078 .46621 .51148 .46291 .50765 Mtetra
0 0 .511 r
.46291 .50765 .46621 .51148 .46881 .51422 .46549 .51037 Mtetra
.652 .159 0 r
.46549 .51037 .46881 .51422 .47141 .51803 .46808 .51417 Mtetra
.635 .143 0 r
.46808 .51417 .47141 .51803 .47404 .52174 .4707 .51786 Mtetra
0 .04 .579 r
.4707 .51786 .47404 .52174 .47671 .52416 .47335 .52027 Mtetra
.195 .387 .825 r
.47335 .52027 .47671 .52416 .47942 .52435 .47605 .52044 Mtetra
.598 .532 .752 r
.47605 .52044 .47942 .52435 .48216 .52173 .47878 .51782 Mtetra
.726 .551 .654 r
.47878 .51782 .48216 .52173 .48491 .51625 .48154 .51235 Mtetra
.771 .551 .601 r
.48154 .51235 .48491 .51625 .48767 .50841 .4843 .50451 Mtetra
.787 .549 .576 r
.4843 .50451 .48767 .50841 .49042 .49909 .48707 .49521 Mtetra
.791 .548 .57 r
.48707 .49521 .49042 .49909 .49316 .48946 .48981 .48559 Mtetra
.783 .549 .583 r
.48981 .48559 .49316 .48946 .49588 .48069 .49254 .47684 Mtetra
.758 .552 .617 r
.49254 .47684 .49588 .48069 .49859 .47379 .49525 .46995 Mtetra
.693 .549 .686 r
.49525 .46995 .49859 .47379 .5013 .46945 .49797 .46561 Mtetra
.497 .506 .796 r
.49797 .46561 .5013 .46945 .50403 .4679 .50069 .46405 Mtetra
0 .28 .782 r
.50069 .46405 .50403 .4679 .50679 .46893 .50344 .46507 Mtetra
0 0 .506 r
.50344 .46507 .50679 .46893 .50959 .47189 .50622 .46802 Mtetra
.628 .136 0 r
.50622 .46802 .50959 .47189 .51242 .47581 .50903 .47191 Mtetra
.595 .108 0 r
.50903 .47191 .51242 .47581 .51527 .47951 .51187 .47559 Mtetra
0 .083 .623 r
.51187 .47559 .51527 .47951 .51813 .48184 .51472 .4779 Mtetra
.229 .403 .828 r
.51472 .4779 .51813 .48184 .52098 .48187 .51755 .47793 Mtetra
.603 .534 .749 r
.51755 .47793 .52098 .48187 .52379 .47911 .52036 .47517 Mtetra
.727 .551 .652 r
.52036 .47517 .52379 .47911 .52655 .47356 .52312 .46962 Mtetra
.772 .55 .598 r
.52312 .46962 .52655 .47356 .52925 .46573 .52583 .4618 Mtetra
.788 .548 .573 r
.52583 .4618 .52925 .46573 .53191 .45655 .5285 .45264 Mtetra
.791 .547 .569 r
.5285 .45264 .53191 .45655 .53456 .44718 .53115 .44328 Mtetra
.781 .549 .585 r
.53115 .44328 .53456 .44718 .5372 .43877 .53381 .43489 Mtetra
.751 .551 .625 r
.53381 .43489 .5372 .43877 .53989 .4323 .5365 .42842 Mtetra
.672 .546 .703 r
.5365 .42842 .53989 .4323 .54265 .42838 .53926 .4245 Mtetra
.438 .487 .813 r
.53926 .4245 .54265 .42838 .5455 .42723 .5421 .42334 Mtetra
0 .244 .759 r
.5421 .42334 .5455 .42723 .54844 .42859 .54503 .42468 Mtetra
0 0 .509 r
.54503 .42468 .54844 .42859 .55147 .43177 .54804 .42785 Mtetra
.6 .11 0 r
.54804 .42785 .55147 .43177 .55455 .43579 .55111 .43185 Mtetra
.553 .071 0 r
.55111 .43185 .55455 .43579 .55766 .43947 .55419 .43551 Mtetra
0 .124 .661 r
.55419 .43551 .55766 .43947 .56073 .4417 .55725 .43772 Mtetra
.259 .417 .83 r
.55725 .43772 .56073 .4417 .56372 .44159 .56023 .4376 Mtetra
.607 .535 .747 r
.56023 .4376 .56372 .44159 .56661 .43869 .56312 .4347 Mtetra
.729 .55 .65 r
.56312 .4347 .56661 .43869 .56937 .43304 .56588 .42906 Mtetra
.773 .549 .595 r
.56588 .42906 .56937 .43304 .57203 .42522 .56854 .42125 Mtetra
.789 .547 .571 r
.56854 .42125 .57203 .42522 .57461 .41617 .57113 .41221 Mtetra
.79 .546 .568 r
.57113 .41221 .57461 .41617 .57716 .40704 .5737 .4031 Mtetra
.778 .548 .587 r
.5737 .4031 .57716 .40704 .57976 .39897 .5763 .39504 Mtetra
.742 .551 .635 r
.5763 .39504 .57976 .39897 .58245 .39289 .579 .38897 Mtetra
.647 .542 .722 r
.579 .38897 .58245 .39289 .58529 .38939 .58183 .38546 Mtetra
.374 .465 .825 r
.58183 .38546 .58529 .38939 .58829 .38863 .58483 .38469 Mtetra
0 .215 .738 r
.58483 .38469 .58829 .38863 .59146 .3903 .58798 .38634 Mtetra
0 0 .518 r
.58798 .38634 .59146 .3903 .59475 .3937 .59126 .38972 Mtetra
.568 .082 0 r
.59126 .38972 .59475 .3937 .59813 .39781 .59461 .39382 Mtetra
0 0 .49 r
.59461 .39382 .59813 .39781 .6015 .40149 .59797 .39747 Mtetra
0 .161 .695 r
.59797 .39747 .6015 .40149 .60481 .40362 .60126 .39958 Mtetra
.285 .429 .831 r
.60126 .39958 .60481 .40362 .60796 .40336 .6044 .39931 Mtetra
.612 .535 .744 r
.6044 .39931 .60796 .40336 .61093 .4003 .60737 .39626 Mtetra
.73 .55 .647 r
.60737 .39626 .61093 .4003 .6137 .39456 .61014 .39052 Mtetra
.774 .548 .592 r
.61014 .39052 .6137 .39456 .61631 .38673 .61275 .3827 Mtetra
.789 .545 .568 r
.61275 .3827 .61631 .38673 .61881 .37779 .61527 .37378 Mtetra
.61527 .37378 .61881 .37779 .6213 .36889 .61776 .36489 Mtetra
.774 .548 .591 r
.61776 .36489 .6213 .36889 .62387 .36114 .62034 .35715 Mtetra
.732 .55 .646 r
.62034 .35715 .62387 .36114 .62659 .35544 .62307 .35146 Mtetra
.616 .537 .742 r
.62307 .35146 .62659 .35544 .62954 .35234 .62601 .34836 Mtetra
.307 .439 .831 r
.62601 .34836 .62954 .35234 .63274 .35195 .6292 .34795 Mtetra
0 .193 .721 r
.6292 .34795 .63274 .35195 .63617 .35393 .63261 .34992 Mtetra
0 .002 .531 r
.63261 .34992 .63617 .35393 .63978 .35754 .6362 .35351 Mtetra
.534 .053 0 r
.6362 .35351 .63978 .35754 .64348 .36176 .63988 .3577 Mtetra
0 .004 .534 r
.63988 .3577 .64348 .36176 .64716 .36542 .64355 .36134 Mtetra
0 .196 .723 r
.64355 .36134 .64716 .36542 .65072 .36745 .64708 .36335 Mtetra
.308 .439 .831 r
.64708 .36335 .65072 .36745 .65405 .36704 .65041 .36293 Mtetra
.615 .536 .742 r
.65041 .36293 .65405 .36704 .65711 .36383 .65346 .35972 Mtetra
.732 .549 .645 r
.65346 .35972 .65711 .36383 .65989 .35798 .65625 .35387 Mtetra
.775 .546 .589 r
.65625 .35387 .65989 .35798 .66245 .35014 .65881 .34604 Mtetra
.79 .544 .565 r
.65881 .34604 .66245 .35014 .66488 .34129 .66126 .33721 Mtetra
.788 .544 .567 r
.66126 .33721 .66488 .34129 .66731 .33259 .6637 .32852 Mtetra
.77 .547 .596 r
.6637 .32852 .66731 .33259 .66987 .32515 .66626 .32109 Mtetra
.718 .549 .659 r
.66626 .32109 .66987 .32515 .67266 .31982 .66905 .31576 Mtetra
.58 .529 .762 r
.66905 .31576 .67266 .31982 .67577 .31711 .67215 .31305 Mtetra
.241 .412 .832 r
.67215 .31305 .67577 .31711 .6792 .31708 .67558 .31301 Mtetra
0 .178 .708 r
.67558 .31301 .6792 .31708 .68295 .31937 .67931 .31528 Mtetra
0 .018 .548 r
.67931 .31528 .68295 .31937 .68692 .32319 .68326 .31908 Mtetra
0 0 .501 r
.68326 .31908 .68692 .32319 .69099 .32751 .68731 .32337 Mtetra
0 .042 .575 r
.68731 .32337 .69099 .32751 .69502 .33116 .69131 .327 Mtetra
0 .227 .747 r
.69131 .327 .69502 .33116 .69885 .33308 .69513 .32891 Mtetra
.328 .448 .83 r
.69513 .32891 .69885 .33308 .70238 .33252 .69864 .32833 Mtetra
.618 .536 .739 r
.69864 .32833 .70238 .33252 .70553 .32915 .7018 .32496 Mtetra
.733 .548 .642 r
.7018 .32496 .70553 .32915 .70833 .32318 .7046 .31899 Mtetra
.776 .545 .586 r
.7046 .31899 .70833 .32318 .71085 .3153 .70712 .31113 Mtetra
.79 .542 .563 r
.70712 .31113 .71085 .3153 .71322 .30654 .7095 .30237 Mtetra
.787 .543 .568 r
.7095 .30237 .71322 .30654 .71561 .29803 .7119 .29388 Mtetra
.764 .546 .603 r
.7119 .29388 .71561 .29803 .71818 .29087 .71448 .28674 Mtetra
.702 .547 .675 r
.71448 .28674 .71818 .29087 .72108 .2859 .71737 .28176 Mtetra
.538 .518 .782 r
.71737 .28176 .72108 .2859 .72438 .28357 .72067 .27943 Mtetra
.179 .385 .828 r
.72067 .27943 .72438 .28357 .72812 .28391 .72439 .27975 Mtetra
0 .17 .7 r
.72439 .27975 .72812 .28391 .73223 .2865 .72849 .28232 Mtetra
0 .036 .568 r
.72849 .28232 .73223 .2865 .73662 .29053 .73286 .28633 Mtetra
0 .009 .537 r
.73286 .28633 .73662 .29053 .74112 .29495 .73733 .29073 Mtetra
0 .078 .613 r
.73733 .29073 .74112 .29495 .74553 .2986 .74172 .29435 Mtetra
0 .255 .766 r
.74172 .29435 .74553 .2986 .74968 .30042 .74585 .29615 Mtetra
.345 .455 .829 r
.74585 .29615 .74968 .30042 .75342 .2997 .74957 .29541 Mtetra
.849 .724 .725 r
.31542 .71315 .31895 .71384 .32172 .70863 .3182 .70793 Mtetra
.86 .666 .639 r
.3182 .70793 .32172 .70863 .32474 .70059 .32123 .69988 Mtetra
.861 .642 .604 r
.32123 .69988 .32474 .70059 .32792 .69056 .32443 .68984 Mtetra
.861 .633 .592 r
.32443 .68984 .32792 .69056 .33116 .67968 .32769 .67894 Mtetra
.861 .637 .596 r
.32769 .67894 .33116 .67968 .33435 .66924 .33089 .6685 Mtetra
.861 .653 .62 r
.33089 .6685 .33435 .66924 .33738 .66043 .33394 .65967 Mtetra
.856 .693 .68 r
.33394 .65967 .33738 .66043 .3402 .65413 .33676 .65336 Mtetra
.811 .784 .827 r
.33676 .65336 .3402 .65413 .34277 .65078 .33934 .65002 Mtetra
.271 .73 .952 r
.33934 .65002 .34277 .65078 .34511 .65036 .34167 .6496 Mtetra
.555 0 0 r
.34167 .6496 .34511 .65036 .34727 .65234 .34382 .65157 Mtetra
.694 .176 0 r
.34382 .65157 .34727 .65234 .34934 .65579 .34588 .65502 Mtetra
.706 .197 .018 r
.34588 .65502 .34934 .65579 .3514 .6595 .34792 .65873 Mtetra
.637 .09 0 r
.34792 .65873 .3514 .6595 .35355 .66221 .35007 .66145 Mtetra
.192 0 0 r
.35007 .66145 .35355 .66221 .35588 .66283 .35239 .66206 Mtetra
.732 .837 .929 r
.35239 .66206 .35588 .66283 .35842 .66061 .35493 .65984 Mtetra
.851 .724 .722 r
.35493 .65984 .35842 .66061 .36119 .65534 .3577 .65456 Mtetra
.863 .668 .637 r
.3577 .65456 .36119 .65534 .36414 .64737 .36067 .64659 Mtetra
.865 .644 .601 r
.36067 .64659 .36414 .64737 .3672 .63755 .36375 .63675 Mtetra
.865 .636 .59 r
.36375 .63675 .3672 .63755 .3703 .62702 .36686 .62621 Mtetra
.865 .641 .597 r
.36686 .62621 .3703 .62702 .37335 .61705 .36992 .61623 Mtetra
.864 .66 .626 r
.36992 .61623 .37335 .61705 .37627 .60876 .37286 .60793 Mtetra
.855 .706 .696 r
.37286 .60793 .37627 .60876 .37902 .60299 .37562 .60215 Mtetra
.785 .805 .869 r
.37562 .60215 .37902 .60299 .38159 .60013 .37819 .59929 Mtetra
.096 .623 .875 r
.37819 .59929 .38159 .60013 .38399 .6001 .38058 .59926 Mtetra
.576 .004 0 r
.38058 .59926 .38399 .6001 .38626 .60234 .38285 .6015 Mtetra
.692 .168 0 r
.38285 .6015 .38626 .60234 .38848 .60591 .38505 .60507 Mtetra
.698 .177 0 r
.38505 .60507 .38848 .60591 .39071 .60961 .38727 .60878 Mtetra
.614 .054 0 r
.38727 .60878 .39071 .60961 .39301 .61223 .38957 .61139 Mtetra
0 .465 .727 r
.38957 .61139 .39301 .61223 .39546 .6127 .392 .61186 Mtetra
.74 .831 .921 r
.392 .61186 .39546 .6127 .39806 .61034 .39461 .6095 Mtetra
.854 .724 .719 r
.39461 .6095 .39806 .61034 .40082 .60501 .39737 .60416 Mtetra
.867 .67 .634 r
.39737 .60416 .40082 .60501 .40371 .5971 .40027 .59624 Mtetra
.869 .646 .599 r
.40027 .59624 .40371 .5971 .40667 .58747 .40324 .5866 Mtetra
.869 .639 .588 r
.40324 .5866 .40667 .58747 .40964 .57727 .40623 .57639 Mtetra
.869 .646 .598 r
.40623 .57639 .40964 .57727 .41256 .56773 .40917 .56684 Mtetra
.867 .669 .633 r
.40917 .56684 .41256 .56773 .41539 .55994 .41201 .55903 Mtetra
.853 .722 .717 r
.41201 .55903 .41539 .55994 .4181 .55467 .41472 .55376 Mtetra
.744 .823 .913 r
.41472 .55376 .4181 .55467 .42069 .55226 .41731 .55135 Mtetra
0 .512 .785 r
.41731 .55135 .42069 .55226 .42318 .5526 .4198 .55169 Mtetra
.59 .02 0 r
.4198 .55169 .42318 .5526 .42559 .55509 .4222 .55417 Mtetra
.687 .157 0 r
.4222 .55417 .42559 .55509 .42798 .55877 .42458 .55786 Mtetra
.686 .155 0 r
.42458 .55786 .42798 .55877 .43039 .56247 .42698 .56156 Mtetra
.587 .015 0 r
.42698 .56156 .43039 .56247 .43287 .56498 .42945 .56407 Mtetra
0 .519 .789 r
.42945 .56407 .43287 .56498 .43543 .5653 .43201 .56439 Mtetra
.747 .827 .913 r
.43201 .56439 .43543 .5653 .4381 .56282 .43467 .5619 Mtetra
.857 .725 .716 r
.43467 .5619 .4381 .56282 .44086 .55742 .43744 .5565 Mtetra
.871 .672 .631 r
.43744 .5565 .44086 .55742 .44368 .54955 .44027 .54862 Mtetra
.873 .649 .596 r
.44027 .54862 .44368 .54955 .44654 .54009 .44314 .53915 Mtetra
.873 .643 .587 r
.44314 .53915 .44654 .54009 .44939 .53019 .44601 .52924 Mtetra
.873 .651 .6 r
.44601 .52924 .44939 .53019 .45221 .52106 .44884 .52009 Mtetra
.869 .678 .642 r
.44884 .52009 .45221 .52106 .45497 .51373 .45161 .51276 Mtetra
.849 .739 .741 r
.45161 .51276 .45497 .51373 .45767 .50894 .45432 .50796 Mtetra
.683 .832 .955 r
.45432 .50796 .45767 .50894 .46031 .50697 .45696 .50598 Mtetra
0 .414 .701 r
.45696 .50598 .46031 .50697 .46291 .50765 .45955 .50667 Mtetra
.598 .028 0 r
.45955 .50667 .46291 .50765 .46549 .51037 .46213 .50939 Mtetra
.68 .142 0 r
.46213 .50939 .46549 .51037 .46808 .51417 .4647 .51318 Mtetra
.672 .13 0 r
.4647 .51318 .46808 .51417 .4707 .51786 .4673 .51687 Mtetra
.555 0 0 r
.4673 .51687 .4707 .51786 .47335 .52027 .46995 .51928 Mtetra
.023 .566 .841 r
.46995 .51928 .47335 .52027 .47605 .52044 .47264 .51946 Mtetra
.754 .823 .906 r
.47264 .51946 .47605 .52044 .47878 .51782 .47537 .51683 Mtetra
.86 .727 .714 r
.47537 .51683 .47878 .51782 .48154 .51235 .47814 .51135 Mtetra
.875 .674 .628 r
.47814 .51135 .48154 .51235 .4843 .50451 .48092 .50351 Mtetra
.877 .652 .593 r
.48092 .50351 .4843 .50451 .48707 .49521 .48369 .49419 Mtetra
.877 .647 .586 r
.48369 .49419 .48707 .49521 .48981 .48559 .48645 .48457 Mtetra
.877 .658 .602 r
.48645 .48457 .48981 .48559 .49254 .47684 .48919 .4758 Mtetra
.871 .689 .653 r
.48919 .4758 .49254 .47684 .49525 .46995 .49192 .46891 Mtetra
.841 .757 .771 r
.49192 .46891 .49525 .46995 .49797 .46561 .49463 .46456 Mtetra
.599 .825 .986 r
.49463 .46456 .49797 .46561 .50069 .46405 .49736 .463 Mtetra
.259 0 0 r
.49736 .463 .50069 .46405 .50344 .46507 .5001 .46401 Mtetra
.601 .031 0 r
.5001 .46401 .50344 .46507 .50622 .46802 .50287 .46696 Mtetra
.67 .125 0 r
.50287 .46696 .50622 .46802 .50903 .47191 .50567 .47086 Mtetra
.655 .103 0 r
.50567 .47086 .50903 .47191 .51187 .47559 .5085 .47453 Mtetra
.518 0 0 r
.5085 .47453 .51187 .47559 .51472 .4779 .51133 .47685 Mtetra
.087 .605 .883 r
.51133 .47685 .51472 .4779 .51755 .47793 .51416 .47687 Mtetra
.76 .821 .9 r
.51416 .47687 .51755 .47793 .52036 .47517 .51697 .4741 Mtetra
.864 .729 .711 r
.51697 .4741 .52036 .47517 .52312 .46962 .51974 .46855 Mtetra
.879 .677 .625 r
.51974 .46855 .52312 .46962 .52583 .4618 .52246 .46072 Mtetra
.882 .655 .59 r
.52246 .46072 .52583 .4618 .5285 .45264 .52515 .45155 Mtetra
.882 .652 .585 r
.52515 .45155 .5285 .45264 .53115 .44328 .52781 .44218 Mtetra
.881 .665 .606 r
.52781 .44218 .53115 .44328 .53381 .43489 .53048 .43378 Mtetra
.873 .702 .666 r
.53048 .43378 .53381 .43489 .5365 .42842 .53318 .4273 Mtetra
.827 .777 .804 r
.53318 .4273 .5365 .42842 .53926 .4245 .53594 .42338 Mtetra
.491 .798 .999 r
.53594 .42338 .53926 .4245 .5421 .42334 .53878 .42222 Mtetra
.32 0 0 r
.53878 .42222 .5421 .42334 .54503 .42468 .5417 .42356 Mtetra
.599 .027 0 r
.5417 .42356 .54503 .42468 .54804 .42785 .5447 .42672 Mtetra
.658 .106 0 r
.5447 .42672 .54804 .42785 .55111 .43185 .54776 .43072 Mtetra
.634 .073 0 r
.54776 .43072 .55111 .43185 .55419 .43551 .55083 .43438 Mtetra
.478 0 0 r
.55083 .43438 .55419 .43551 .55725 .43772 .55388 .43659 Mtetra
.145 .638 .915 r
.55388 .43659 .55725 .43772 .56023 .4376 .55686 .43647 Mtetra
.766 .819 .895 r
.55686 .43647 .56023 .4376 .56312 .4347 .55974 .43356 Mtetra
.868 .731 .708 r
.55974 .43356 .56312 .4347 .56588 .42906 .56252 .42791 Mtetra
.884 .68 .622 r
.56252 .42791 .56588 .42906 .56854 .42125 .56519 .42009 Mtetra
.887 .659 .587 r
.56519 .42009 .56854 .42125 .57113 .41221 .56779 .41105 Mtetra
.887 .657 .584 r
.56779 .41105 .57113 .41221 .5737 .4031 .57037 .40192 Mtetra
.885 .673 .611 r
.57037 .40192 .5737 .4031 .5763 .39504 .57299 .39385 Mtetra
.874 .716 .683 r
.57299 .39385 .5763 .39504 .579 .38897 .57569 .38777 Mtetra
.806 .796 .843 r
.57569 .38777 .579 .38897 .58183 .38546 .57853 .38427 Mtetra
.368 .749 .989 r
.57853 .38427 .58183 .38546 .58483 .38469 .58152 .38349 Mtetra
.362 0 0 r
.58152 .38349 .58483 .38469 .58798 .38634 .58466 .38514 Mtetra
.593 .02 0 r
.58466 .38514 .58798 .38634 .59126 .38972 .58793 .38852 Mtetra
.642 .083 0 r
.58793 .38852 .59126 .38972 .59461 .39382 .59127 .39261 Mtetra
.609 .04 0 r
.59127 .39261 .59461 .39382 .59797 .39747 .59462 .39627 Mtetra
.433 0 0 r
.59462 .39627 .59797 .39747 .60126 .39958 .59789 .39838 Mtetra
.197 .664 .939 r
.59789 .39838 .60126 .39958 .6044 .39931 .60104 .3981 Mtetra
.771 .819 .89 r
.60104 .3981 .6044 .39931 .60737 .39626 .604 .39504 Mtetra
.873 .734 .706 r
.604 .39504 .60737 .39626 .61014 .39052 .60678 .3893 Mtetra
.889 .684 .619 r
.60678 .3893 .61014 .39052 .61275 .3827 .60941 .38147 Mtetra
.892 .663 .584 r
.60941 .38147 .61275 .3827 .61527 .37378 .61193 .37254 Mtetra
.61193 .37254 .61527 .37378 .61776 .36489 .61444 .36364 Mtetra
.889 .683 .618 r
.61444 .36364 .61776 .36489 .62034 .35715 .61703 .35589 Mtetra
.873 .732 .704 r
.61703 .35589 .62034 .35715 .62307 .35146 .61976 .35019 Mtetra
.774 .813 .883 r
.61976 .35019 .62307 .35146 .62601 .34836 .62271 .34708 Mtetra
.244 .684 .958 r
.62271 .34708 .62601 .34836 .6292 .34795 .62589 .34668 Mtetra
.389 0 0 r
.62589 .34668 .6292 .34795 .63261 .34992 .6293 .34864 Mtetra
.583 .008 0 r
.6293 .34864 .63261 .34992 .6362 .35351 .63288 .35223 Mtetra
.624 .058 0 r
.63288 .35223 .6362 .35351 .63988 .3577 .63654 .35642 Mtetra
.581 .005 0 r
.63654 .35642 .63988 .3577 .64355 .36134 .6402 .36006 Mtetra
.385 0 0 r
.6402 .36006 .64355 .36134 .64708 .36335 .64373 .36206 Mtetra
.243 .686 .957 r
.64373 .36206 .64708 .36335 .65041 .36293 .64704 .36164 Mtetra
.777 .819 .886 r
.64704 .36164 .65041 .36293 .65346 .35972 .6501 .35842 Mtetra
.878 .738 .703 r
.6501 .35842 .65346 .35972 .65625 .35387 .65289 .35257 Mtetra
.895 .688 .615 r
.65289 .35257 .65625 .35387 .65881 .34604 .65547 .34473 Mtetra
.898 .668 .582 r
.65547 .34473 .65881 .34604 .66126 .33721 .65793 .33589 Mtetra
.898 .67 .585 r
.65793 .33589 .66126 .33721 .6637 .32852 .66038 .32719 Mtetra
.893 .694 .626 r
.66038 .32719 .6637 .32852 .66626 .32109 .66295 .31975 Mtetra
.869 .75 .728 r
.66295 .31975 .66626 .32109 .66905 .31576 .66575 .31442 Mtetra
.728 .824 .924 r
.66575 .31442 .66905 .31576 .67215 .31305 .66885 .3117 Mtetra
.13 .614 .916 r
.66885 .3117 .67215 .31305 .67558 .31301 .67227 .31166 Mtetra
.405 0 0 r
.67227 .31166 .67558 .31301 .67931 .31528 .67599 .31392 Mtetra
.57 0 0 r
.67599 .31392 .67931 .31528 .68326 .31908 .67993 .31772 Mtetra
.601 .03 0 r
.67993 .31772 .68326 .31908 .68731 .32337 .68397 .32201 Mtetra
.549 0 0 r
.68397 .32201 .68731 .32337 .69131 .327 .68796 .32564 Mtetra
.336 0 0 r
.68796 .32564 .69131 .327 .69513 .32891 .69177 .32754 Mtetra
.282 .703 .97 r
.69177 .32754 .69513 .32891 .69864 .32833 .69528 .32696 Mtetra
.782 .821 .883 r
.69528 .32696 .69864 .32833 .7018 .32496 .69844 .32358 Mtetra
.884 .742 .701 r
.69844 .32358 .7018 .32496 .7046 .31899 .70124 .31761 Mtetra
.901 .693 .611 r
.70124 .31761 .7046 .31899 .70712 .31113 .70378 .30974 Mtetra
.904 .673 .579 r
.70378 .30974 .70712 .31113 .7095 .30237 .70617 .30097 Mtetra
.904 .678 .586 r
.70617 .30097 .7095 .30237 .7119 .29388 .70858 .29247 Mtetra
.897 .707 .637 r
.70858 .29247 .7119 .29388 .71448 .28674 .71117 .28532 Mtetra
.863 .769 .758 r
.71117 .28532 .71448 .28674 .71737 .28176 .71407 .28034 Mtetra
.666 .825 .96 r
.71407 .28034 .71737 .28176 .72067 .27943 .71737 .278 Mtetra
.034 .547 .871 r
.71737 .278 .72067 .27943 .72439 .27975 .72109 .27832 Mtetra
.412 0 0 r
.72109 .27832 .72439 .27975 .72849 .28232 .72518 .28088 Mtetra
.552 0 0 r
.72518 .28088 .72849 .28232 .73286 .28633 .72953 .28489 Mtetra
.575 0 0 r
.72953 .28489 .73286 .28633 .73733 .29073 .73399 .28928 Mtetra
.514 0 0 r
.73399 .28928 .73733 .29073 .74172 .29435 .73837 .2929 Mtetra
.285 0 0 r
.73837 .2929 .74172 .29435 .74585 .29615 .74249 .2947 Mtetra
.316 .717 .979 r
.74249 .2947 .74585 .29615 .74957 .29541 .74621 .29396 Mtetra
.952 .905 .738 r
.31161 .71537 .31542 .71315 .3182 .70793 .3144 .71014 Mtetra
.947 .786 .649 r
.3144 .71014 .3182 .70793 .32123 .69988 .31744 .70206 Mtetra
.934 .735 .61 r
.31744 .70206 .32123 .69988 .32443 .68984 .32066 .69198 Mtetra
.929 .718 .597 r
.32066 .69198 .32443 .68984 .32769 .67894 .32394 .68105 Mtetra
.931 .725 .602 r
.32394 .68105 .32769 .67894 .33089 .6685 .32717 .67056 Mtetra
.941 .759 .628 r
.32717 .67056 .33089 .6685 .33394 .65967 .33024 .66171 Mtetra
.954 .842 .693 r
.33024 .66171 .33394 .65967 .33676 .65336 .33307 .65538 Mtetra
.87 .994 .806 r
.33307 .65538 .33676 .65336 .33934 .65002 .33565 .65203 Mtetra
0 0 0 r
.33565 .65203 .33934 .65002 .34167 .6496 .33799 .65161 Mtetra
.483 0 .014 r
.33799 .65161 .34167 .6496 .34382 .65157 .34014 .6536 Mtetra
.595 .133 .128 r
.34014 .6536 .34382 .65157 .34588 .65502 .34218 .65706 Mtetra
.607 .15 .142 r
.34218 .65706 .34588 .65502 .34792 .65873 .34422 .66079 Mtetra
.544 .068 .076 r
.34422 .66079 .34792 .65873 .35007 .66145 .34635 .66353 Mtetra
.275 0 0 r
.34635 .66353 .35007 .66145 .35239 .66206 .34867 .66415 Mtetra
.632 .95 .755 r
.34867 .66415 .35239 .66206 .35493 .65984 .35122 .66192 Mtetra
.954 .904 .733 r
.35122 .66192 .35493 .65984 .3577 .65456 .354 .65663 Mtetra
.952 .79 .645 r
.354 .65663 .3577 .65456 .36067 .64659 .35698 .64862 Mtetra
.94 .74 .606 r
.35698 .64862 .36067 .64659 .36375 .63675 .36008 .63875 Mtetra
.935 .724 .594 r
.36008 .63875 .36375 .63675 .36686 .62621 .36322 .62817 Mtetra
.938 .734 .601 r
.36322 .62817 .36686 .62621 .36992 .61623 .3663 .61815 Mtetra
.948 .774 .633 r
.3663 .61815 .36992 .61623 .37286 .60793 .36925 .60983 Mtetra
.957 .87 .709 r
.36925 .60983 .37286 .60793 .37562 .60215 .37202 .60403 Mtetra
.797 .999 .81 r
.37202 .60403 .37562 .60215 .37819 .59929 .37459 .60117 Mtetra
.113 0 0 r
.37459 .60117 .37819 .59929 .38058 .59926 .37699 .60114 Mtetra
.504 .009 .014 r
.37699 .60114 .38058 .59926 .38285 .6015 .37925 .60339 Mtetra
.598 .129 .111 r
.37925 .60339 .38285 .6015 .38505 .60507 .38144 .60698 Mtetra
.604 .136 .117 r
.38144 .60698 .38505 .60507 .38727 .60878 .38365 .6107 Mtetra
.531 .043 .042 r
.38365 .6107 .38727 .60878 .38957 .61139 .38594 .61333 Mtetra
.237 0 0 r
.38594 .61333 .38957 .61139 .392 .61186 .38838 .61381 Mtetra
.661 .963 .771 r
.38838 .61381 .392 .61186 .39461 .6095 .39099 .61144 Mtetra
.957 .905 .728 r
.39099 .61144 .39461 .6095 .39737 .60416 .39376 .60609 Mtetra
.956 .794 .64 r
.39376 .60609 .39737 .60416 .40027 .59624 .39668 .59814 Mtetra
.945 .745 .602 r
.39668 .59814 .40027 .59624 .40324 .5866 .39967 .58847 Mtetra
.942 .732 .591 r
.39967 .58847 .40324 .5866 .40623 .57639 .40267 .57822 Mtetra
.945 .745 .601 r
.40267 .57822 .40623 .57639 .40917 .56684 .40563 .56863 Mtetra
.955 .792 .639 r
.40563 .56863 .40917 .56684 .41201 .55903 .40849 .56081 Mtetra
.956 .9 .728 r
.40849 .56081 .41201 .55903 .41472 .55376 .41122 .55551 Mtetra
.691 .976 .794 r
.41122 .55551 .41472 .55376 .41731 .55135 .41381 .5531 Mtetra
.202 0 0 r
.41381 .5531 .41731 .55135 .4198 .55169 .41629 .55344 Mtetra
.52 .02 .009 r
.41629 .55344 .4198 .55169 .4222 .55417 .41869 .55594 Mtetra
.599 .121 .091 r
.41869 .55594 .4222 .55417 .42458 .55786 .42106 .55964 Mtetra
.599 .12 .09 r
.42106 .55964 .42458 .55786 .42698 .56156 .42345 .56336 Mtetra
.517 .017 .007 r
.42345 .56336 .42698 .56156 .42945 .56407 .42591 .56589 Mtetra
.197 0 0 r
.42591 .56589 .42945 .56407 .43201 .56439 .42847 .56622 Mtetra
.686 .973 .782 r
.42847 .56622 .43201 .56439 .43467 .5619 .43114 .56372 Mtetra
.959 .906 .723 r
.43114 .56372 .43467 .5619 .43744 .5565 .43392 .5583 Mtetra
.961 .798 .635 r
.43392 .5583 .43744 .5565 .44027 .54862 .43677 .55039 Mtetra
.951 .752 .597 r
.43677 .55039 .44027 .54862 .44314 .53915 .43966 .54089 Mtetra
.948 .74 .588 r
.43966 .54089 .44314 .53915 .44601 .52924 .44254 .53095 Mtetra
.953 .757 .601 r
.44254 .53095 .44601 .52924 .44884 .52009 .44539 .52177 Mtetra
.962 .811 .647 r
.44539 .52177 .44884 .52009 .45161 .51276 .44818 .51441 Mtetra
.949 .931 .748 r
.44818 .51441 .45161 .51276 .45432 .50796 .45089 .50959 Mtetra
.556 .921 .756 r
.45089 .50959 .45432 .50796 .45696 .50598 .45353 .50762 Mtetra
.271 0 0 r
.45353 .50762 .45696 .50598 .45955 .50667 .45613 .50831 Mtetra
.532 .026 0 r
.45613 .50831 .45955 .50667 .46213 .50939 .4587 .51104 Mtetra
.599 .112 .069 r
.4587 .51104 .46213 .50939 .4647 .51318 .46126 .51485 Mtetra
.592 .102 .061 r
.46126 .51485 .4647 .51318 .4673 .51687 .46386 .51856 Mtetra
.5 0 0 r
.46386 .51856 .4673 .51687 .46995 .51928 .4665 .52099 Mtetra
.156 0 0 r
.4665 .52099 .46995 .51928 .47264 .51946 .46919 .52117 Mtetra
.706 .98 .789 r
.46919 .52117 .47264 .51946 .47537 .51683 .47193 .51853 Mtetra
.962 .907 .717 r
.47193 .51853 .47537 .51683 .47814 .51135 .4747 .51304 Mtetra
.966 .803 .63 r
.4747 .51304 .47814 .51135 .48092 .50351 .4775 .50516 Mtetra
.958 .758 .592 r
.4775 .50516 .48092 .50351 .48369 .49419 .48029 .49582 Mtetra
.956 .749 .584 r
.48029 .49582 .48369 .49419 .48645 .48457 .48307 .48616 Mtetra
.96 .77 .602 r
.48307 .48616 .48645 .48457 .48919 .4758 .48583 .47736 Mtetra
.968 .834 .656 r
.48583 .47736 .48919 .4758 .49192 .46891 .48856 .47045 Mtetra
.93 .961 .769 r
.48856 .47045 .49192 .46891 .49463 .46456 .49129 .46608 Mtetra
.405 .838 .699 r
.49129 .46608 .49463 .46456 .49736 .463 .49401 .46452 Mtetra
.323 0 0 r
.49401 .46452 .49736 .463 .5001 .46401 .49675 .46555 Mtetra
.54 .028 0 r
.49675 .46555 .5001 .46401 .50287 .46696 .49952 .46851 Mtetra
.597 .1 .044 r
.49952 .46851 .50287 .46696 .50567 .47086 .50231 .47242 Mtetra
.583 .082 .03 r
.50231 .47242 .50567 .47086 .5085 .47453 .50513 .47612 Mtetra
.481 0 0 r
.50513 .47612 .5085 .47453 .51133 .47685 .50796 .47845 Mtetra
.113 0 0 r
.50796 .47845 .51133 .47685 .51416 .47687 .51079 .47848 Mtetra
.722 .985 .793 r
.51079 .47848 .51416 .47687 .51697 .4741 .51361 .4757 Mtetra
.964 .91 .711 r
.51361 .4757 .51697 .4741 .51974 .46855 .51638 .47012 Mtetra
.971 .809 .624 r
.51638 .47012 .51974 .46855 .52246 .46072 .51912 .46227 Mtetra
.964 .766 .586 r
.51912 .46227 .52246 .46072 .52515 .45155 .52183 .45307 Mtetra
.963 .759 .581 r
.52183 .45307 .52515 .45155 .52781 .44218 .52451 .44367 Mtetra
.968 .785 .603 r
.52451 .44367 .52781 .44218 .53048 .43378 .52719 .43523 Mtetra
.972 .858 .667 r
.52719 .43523 .53048 .43378 .53318 .4273 .52991 .42873 Mtetra
.897 .985 .788 r
.52991 .42873 .53318 .4273 .53594 .42338 .53268 .4248 Mtetra
0 0 0 r
.53268 .4248 .53594 .42338 .53878 .42222 .53552 .42364 Mtetra
.362 0 0 r
.53552 .42364 .53878 .42222 .5417 .42356 .53844 .42499 Mtetra
.546 .026 0 r
.53844 .42499 .5417 .42356 .5447 .42672 .54143 .42817 Mtetra
.593 .086 .016 r
.54143 .42817 .5447 .42672 .54776 .43072 .54448 .43218 Mtetra
.573 .06 0 r
.54448 .43218 .54776 .43072 .55083 .43438 .54754 .43587 Mtetra
.46 0 0 r
.54754 .43587 .55083 .43438 .55388 .43659 .55059 .43809 Mtetra
.07 0 0 r
.55059 .43809 .55388 .43659 .55686 .43647 .55357 .43797 Mtetra
.735 .988 .794 r
.55357 .43797 .55686 .43647 .55974 .43356 .55646 .43505 Mtetra
.967 .913 .704 r
.55646 .43505 .55974 .43356 .56252 .42791 .55924 .42939 Mtetra
.977 .815 .617 r
.55924 .42939 .56252 .42791 .56519 .42009 .56193 .42154 Mtetra
.971 .773 .58 r
.56193 .42154 .56519 .42009 .56779 .41105 .56455 .41246 Mtetra
.97 .77 .577 r
.56455 .41246 .56779 .41105 .57037 .40192 .56715 .40331 Mtetra
.975 .802 .605 r
.56715 .40331 .57037 .40192 .57299 .39385 .56978 .39521 Mtetra
.974 .885 .68 r
.56978 .39521 .57299 .39385 .57569 .38777 .5725 .38911 Mtetra
.843 .999 .801 r
.5725 .38911 .57569 .38777 .57853 .38427 .57534 .3856 Mtetra
0 0 0 r
.57534 .3856 .57853 .38427 .58152 .38349 .57833 .38482 Mtetra
.392 0 0 r
.57833 .38482 .58152 .38349 .58466 .38514 .58147 .38648 Mtetra
.548 .02 0 r
.58147 .38648 .58466 .38514 .58793 .38852 .58473 .38988 Mtetra
.587 .069 0 r
.58473 .38988 .58793 .38852 .59127 .39261 .58807 .39399 Mtetra
.561 .036 0 r
.58807 .39399 .59127 .39261 .59462 .39627 .59141 .39766 Mtetra
.437 0 0 r
.59141 .39766 .59462 .39627 .59789 .39838 .59469 .39978 Mtetra
.028 0 0 r
.59469 .39978 .59789 .39838 .60104 .3981 .59783 .39951 Mtetra
.745 .99 .792 r
.59783 .39951 .60104 .3981 .604 .39504 .6008 .39644 Mtetra
.969 .916 .696 r
.6008 .39644 .604 .39504 .60678 .3893 .6036 .39068 Mtetra
.982 .822 .608 r
.6036 .39068 .60678 .3893 .60941 .38147 .60623 .38283 Mtetra
.978 .782 .573 r
.60623 .38283 .60941 .38147 .61193 .37254 .60878 .37386 Mtetra
.978 .782 .572 r
.60878 .37386 .61193 .37254 .61444 .36364 .6113 .36493 Mtetra
.982 .82 .607 r
.6113 .36493 .61444 .36364 .61703 .35589 .6139 .35715 Mtetra
.97 .913 .695 r
.6139 .35715 .61703 .35589 .61976 .35019 .61665 .35144 Mtetra
.764 .995 .804 r
.61665 .35144 .61976 .35019 .62271 .34708 .6196 .34832 Mtetra
0 0 0 r
.6196 .34832 .62271 .34708 .62589 .34668 .62279 .34792 Mtetra
.414 0 0 r
.62279 .34792 .62589 .34668 .6293 .34864 .62619 .34989 Mtetra
.548 .011 0 r
.62619 .34989 .6293 .34864 .63288 .35223 .62976 .35349 Mtetra
.579 .05 0 r
.62976 .35349 .63288 .35223 .63654 .35642 .63343 .3577 Mtetra
.546 .01 0 r
.63343 .3577 .63654 .35642 .6402 .36006 .63707 .36136 Mtetra
.411 0 0 r
.63707 .36136 .6402 .36006 .64373 .36206 .6406 .36338 Mtetra
0 0 0 r
.6406 .36338 .64373 .36206 .64704 .36164 .64392 .36296 Mtetra
.752 .99 .788 r
.64392 .36296 .64704 .36164 .6501 .35842 .64699 .35973 Mtetra
.971 .92 .686 r
.64699 .35973 .6501 .35842 .65289 .35257 .64979 .35386 Mtetra
.987 .829 .599 r
.64979 .35386 .65289 .35257 .65547 .34473 .65238 .34599 Mtetra
.984 .791 .564 r
.65238 .34599 .65547 .34473 .65793 .33589 .65486 .33712 Mtetra
.985 .795 .568 r
.65486 .33712 .65793 .33589 .66038 .32719 .65733 .32839 Mtetra
.987 .841 .61 r
.65733 .32839 .66038 .32719 .66295 .31975 .65991 .32092 Mtetra
.959 .941 .711 r
.65991 .32092 .66295 .31975 .66575 .31442 .66272 .31557 Mtetra
.661 .967 .793 r
.66272 .31557 .66575 .31442 .66885 .3117 .66583 .31285 Mtetra
.071 0 0 r
.66583 .31285 .66885 .3117 .67227 .31166 .66925 .31281 Mtetra
.429 0 0 r
.66925 .31281 .67227 .31166 .67599 .31392 .67297 .31509 Mtetra
.544 0 0 r
.67297 .31509 .67599 .31392 .67993 .31772 .6769 .3189 Mtetra
.569 .029 0 r
.6769 .3189 .67993 .31772 .68397 .32201 .68094 .32321 Mtetra
.529 0 0 r
.68094 .32321 .68397 .32201 .68796 .32564 .68493 .32686 Mtetra
.383 0 0 r
.68493 .32686 .68796 .32564 .69177 .32754 .68873 .32877 Mtetra
0 0 0 r
.68873 .32877 .69177 .32754 .69528 .32696 .69225 .32819 Mtetra
.756 .99 .781 r
.69225 .32819 .69528 .32696 .69844 .32358 .69541 .3248 Mtetra
.972 .924 .675 r
.69541 .3248 .69844 .32358 .70124 .31761 .69823 .31882 Mtetra
.992 .836 .588 r
.69823 .31882 .70124 .31761 .70378 .30974 .70078 .31091 Mtetra
.99 .801 .555 r
.70078 .31091 .70378 .30974 .70617 .30097 .70319 .30212 Mtetra
.991 .809 .562 r
.70319 .30212 .70617 .30097 .70858 .29247 .70562 .29359 Mtetra
.99 .863 .614 r
.70562 .29359 .70858 .29247 .71117 .28532 .70822 .28641 Mtetra
.937 .966 .726 r
.70822 .28641 .71117 .28532 .71407 .28034 .71113 .28141 Mtetra
.541 .918 .769 r
.71113 .28141 .71407 .28034 .71737 .278 .71443 .27906 Mtetra
.14 0 0 r
.71443 .27906 .71737 .278 .72109 .27832 .71815 .27939 Mtetra
.439 0 0 r
.71815 .27939 .72109 .27832 .72518 .28088 .72224 .28197 Mtetra
.538 0 0 r
.72224 .28197 .72518 .28088 .72953 .28489 .72659 .286 Mtetra
.556 .005 0 r
.72659 .286 .72953 .28489 .73399 .28928 .73105 .29041 Mtetra
.51 0 0 r
.73105 .29041 .73399 .28928 .73837 .2929 .73542 .29405 Mtetra
.354 0 0 r
.73542 .29405 .73837 .2929 .74249 .2947 .73954 .29586 Mtetra
0 0 0 r
.73954 .29586 .74249 .2947 .74621 .29396 .74327 .29511 Mtetra
.925 .961 .65 r
.30756 .71978 .31161 .71537 .3144 .71014 .31037 .71452 Mtetra
.987 .865 .628 r
.31037 .71452 .3144 .71014 .31744 .70206 .31343 .70641 Mtetra
.978 .803 .6 r
.31343 .70641 .31744 .70206 .32066 .69198 .31668 .69627 Mtetra
.971 .78 .589 r
.31668 .69627 .32066 .69198 .32394 .68105 .31999 .68528 Mtetra
.974 .789 .593 r
.31999 .68528 .32394 .68105 .32717 .67056 .32324 .67474 Mtetra
.984 .832 .614 r
.32324 .67474 .32717 .67056 .33024 .66171 .32633 .66584 Mtetra
.976 .923 .651 r
.32633 .66584 .33024 .66171 .33307 .65538 .32918 .65948 Mtetra
.689 .912 .574 r
.32918 .65948 .33307 .65538 .33565 .65203 .33177 .65612 Mtetra
.093 0 0 r
.33177 .65612 .33565 .65203 .33799 .65161 .33411 .6557 Mtetra
.433 0 .108 r
.33411 .6557 .33799 .65161 .34014 .6536 .33625 .65771 Mtetra
.534 .111 .183 r
.33625 .65771 .34014 .6536 .34218 .65706 .33828 .66121 Mtetra
.547 .125 .192 r
.33828 .66121 .34218 .65706 .34422 .66079 .34031 .66497 Mtetra
.487 .056 .147 r
.34031 .66497 .34422 .66079 .34635 .66353 .34245 .66773 Mtetra
.275 0 0 r
.34245 .66773 .34635 .66353 .34867 .66415 .34476 .66837 Mtetra
0 0 0 r
.34476 .66837 .34867 .66415 .35122 .66192 .34732 .66613 Mtetra
.926 .96 .644 r
.34732 .66613 .35122 .66192 .354 .65663 .35011 .66082 Mtetra
.989 .868 .621 r
.35011 .66082 .354 .65663 .35698 .64862 .35311 .65277 Mtetra
.982 .808 .593 r
.35311 .65277 .35698 .64862 .36008 .63875 .35624 .64285 Mtetra
.977 .789 .583 r
.35624 .64285 .36008 .63875 .36322 .62817 .3594 .63221 Mtetra
.98 .801 .589 r
.3594 .63221 .36322 .62817 .3663 .61815 .36251 .62214 Mtetra
.988 .85 .613 r
.36251 .62214 .3663 .61815 .36925 .60983 .36548 .61378 Mtetra
.96 .943 .649 r
.36548 .61378 .36925 .60983 .37202 .60403 .36826 .60795 Mtetra
.564 .848 .516 r
.36826 .60795 .37202 .60403 .37459 .60117 .37085 .60507 Mtetra
.167 0 0 r
.37085 .60507 .37459 .60117 .37699 .60114 .37324 .60505 Mtetra
.452 .01 .106 r
.37324 .60505 .37699 .60114 .37925 .60339 .3755 .60733 Mtetra
.539 .107 .169 r
.3755 .60733 .37925 .60339 .38144 .60698 .37768 .61095 Mtetra
.544 .114 .173 r
.37768 .61095 .38144 .60698 .38365 .6107 .37988 .61471 Mtetra
.476 .037 .124 r
.37988 .61471 .38365 .6107 .38594 .61333 .38217 .61736 Mtetra
.25 0 0 r
.38217 .61736 .38594 .61333 .38838 .61381 .38461 .61785 Mtetra
0 0 0 r
.38461 .61785 .38838 .61381 .39099 .61144 .38722 .61548 Mtetra
.925 .957 .637 r
.38722 .61548 .39099 .61144 .39376 .60609 .39001 .6101 Mtetra
.991 .871 .612 r
.39001 .6101 .39376 .60609 .39668 .59814 .39295 .60211 Mtetra
.987 .815 .585 r
.39295 .60211 .39668 .59814 .39967 .58847 .39596 .59238 Mtetra
.983 .798 .577 r
.39596 .59238 .39967 .58847 .40267 .57822 .39899 .58208 Mtetra
.987 .814 .585 r
.39899 .58208 .40267 .57822 .40563 .56863 .40197 .57245 Mtetra
.991 .869 .612 r
.40197 .57245 .40563 .56863 .40849 .56081 .40485 .56458 Mtetra
.931 .957 .642 r
.40485 .56458 .40849 .56081 .41122 .55551 .40759 .55926 Mtetra
0 0 0 r
.40759 .55926 .41122 .55551 .41381 .5531 .41019 .55684 Mtetra
.227 0 0 r
.41019 .55684 .41381 .5531 .41629 .55344 .41267 .55719 Mtetra
.468 .019 .1 r
.41267 .55719 .41629 .55344 .41869 .55594 .41507 .55972 Mtetra
.541 .101 .153 r
.41507 .55972 .41869 .55594 .42106 .55964 .41743 .56345 Mtetra
.54 .101 .153 r
.41743 .56345 .42106 .55964 .42345 .56336 .41982 .56721 Mtetra
.465 .016 .098 r
.41982 .56721 .42345 .56336 .42591 .56589 .42227 .56976 Mtetra
.224 0 0 r
.42227 .56976 .42591 .56589 .42847 .56622 .42483 .5701 Mtetra
0 0 0 r
.42483 .5701 .42847 .56622 .43114 .56372 .42751 .56759 Mtetra
.924 .955 .627 r
.42751 .56759 .43114 .56372 .43392 .5583 .4303 .56215 Mtetra
.992 .875 .602 r
.4303 .56215 .43392 .5583 .43677 .55039 .43317 .5542 Mtetra
.991 .821 .577 r
.43317 .5542 .43677 .55039 .43966 .54089 .43608 .54465 Mtetra
.989 .807 .569 r
.43608 .54465 .43966 .54089 .44254 .53095 .43899 .53465 Mtetra
.992 .827 .58 r
.43899 .53465 .44254 .53095 .44539 .52177 .44186 .52543 Mtetra
.99 .888 .61 r
.44186 .52543 .44539 .52177 .44818 .51441 .44467 .51803 Mtetra
.886 .961 .629 r
.44467 .51803 .44818 .51441 .45089 .50959 .44739 .51319 Mtetra
0 0 0 r
.44739 .51319 .45089 .50959 .45353 .50762 .45004 .51121 Mtetra
.275 0 0 r
.45004 .51121 .45353 .50762 .45613 .50831 .45264 .51191 Mtetra
.48 .024 .09 r
.45264 .51191 .45613 .50831 .4587 .51104 .4552 .51468 Mtetra
.542 .094 .136 r
.4552 .51468 .4587 .51104 .46126 .51485 .45776 .51852 Mtetra
.535 .086 .131 r
.45776 .51852 .46126 .51485 .46386 .51856 .46035 .52226 Mtetra
.452 0 .071 r
.46035 .52226 .46386 .51856 .4665 .52099 .46299 .52471 Mtetra
.197 0 0 r
.46299 .52471 .4665 .52099 .46919 .52117 .46568 .5249 Mtetra
0 0 0 r
.46568 .5249 .46919 .52117 .47193 .51853 .46843 .52226 Mtetra
.921 .952 .616 r
.46843 .52226 .47193 .51853 .4747 .51304 .47122 .51674 Mtetra
.993 .878 .591 r
.47122 .51674 .4747 .51304 .4775 .50516 .47403 .50882 Mtetra
.995 .828 .567 r
.47403 .50882 .4775 .50516 .48029 .49582 .47685 .49943 Mtetra
.993 .817 .561 r
.47685 .49943 .48029 .49582 .48307 .48616 .47965 .48972 Mtetra
.995 .842 .574 r
.47965 .48972 .48307 .48616 .48583 .47736 .48243 .48088 Mtetra
.983 .907 .606 r
.48243 .48088 .48583 .47736 .48856 .47045 .48518 .47392 Mtetra
.821 .952 .606 r
.48518 .47392 .48856 .47045 .49129 .46608 .48792 .46954 Mtetra
0 0 0 r
.48792 .46954 .49129 .46608 .49401 .46452 .49065 .46798 Mtetra
.314 0 0 r
.49065 .46798 .49401 .46452 .49675 .46555 .49339 .46902 Mtetra
.489 .025 .078 r
.49339 .46902 .49675 .46555 .49952 .46851 .49615 .47201 Mtetra
.542 .084 .116 r
.49615 .47201 .49952 .46851 .50231 .47242 .49894 .47596 Mtetra
.529 .07 .107 r
.49894 .47596 .50231 .47242 .50513 .47612 .50175 .47969 Mtetra
.438 0 .043 r
.50175 .47969 .50513 .47612 .50796 .47845 .50459 .48203 Mtetra
.169 0 0 r
.50459 .48203 .50796 .47845 .51079 .47848 .50742 .48207 Mtetra
0 0 0 r
.50742 .48207 .51079 .47848 .51361 .4757 .51024 .47929 Mtetra
.916 .948 .603 r
.51024 .47929 .51361 .4757 .51638 .47012 .51303 .47369 Mtetra
.993 .881 .578 r
.51303 .47369 .51638 .47012 .51912 .46227 .51579 .46579 Mtetra
.997 .835 .555 r
.51579 .46579 .51912 .46227 .52183 .45307 .51852 .45654 Mtetra
.997 .827 .551 r
.51852 .45654 .52183 .45307 .52451 .44367 .52122 .44709 Mtetra
.997 .856 .567 r
.52122 .44709 .52451 .44367 .52719 .43523 .52392 .43861 Mtetra
.969 .923 .599 r
.52392 .43861 .52719 .43523 .52991 .42873 .52665 .43208 Mtetra
.735 .924 .575 r
.52665 .43208 .52991 .42873 .53268 .4248 .52943 .42813 Mtetra
0 0 0 r
.52943 .42813 .53268 .4248 .53552 .42364 .53228 .42697 Mtetra
.345 0 0 r
.53228 .42697 .53552 .42364 .53844 .42499 .5352 .42834 Mtetra
.496 .024 .063 r
.5352 .42834 .53844 .42499 .54143 .42817 .53819 .43155 Mtetra
.54 .073 .094 r
.53819 .43155 .54143 .42817 .54448 .43218 .54124 .4356 Mtetra
.521 .052 .081 r
.54124 .4356 .54448 .43218 .54754 .43587 .5443 .43932 Mtetra
.422 0 .014 r
.5443 .43932 .54754 .43587 .55059 .43809 .54734 .44156 Mtetra
.141 0 0 r
.54734 .44156 .55059 .43809 .55357 .43797 .55033 .44145 Mtetra
0 0 0 r
.55033 .44145 .55357 .43797 .55646 .43505 .55323 .43852 Mtetra
.91 .944 .588 r
.55323 .43852 .55646 .43505 .55924 .42939 .55603 .43283 Mtetra
.991 .883 .564 r
.55603 .43283 .55924 .42939 .56193 .42154 .55873 .42494 Mtetra
.999 .841 .542 r
.55873 .42494 .56193 .42154 .56455 .41246 .56137 .41582 Mtetra
.999 .837 .539 r
.56137 .41582 .56455 .41246 .56715 .40331 .56399 .40661 Mtetra
.995 .87 .557 r
.56399 .40661 .56715 .40331 .56978 .39521 .56664 .39847 Mtetra
.945 .934 .589 r
.56664 .39847 .56978 .39521 .5725 .38911 .56937 .39234 Mtetra
.631 .879 .535 r
.56937 .39234 .5725 .38911 .57534 .3856 .57223 .38881 Mtetra
.013 0 0 r
.57223 .38881 .57534 .3856 .57833 .38482 .57522 .38804 Mtetra
.37 0 0 r
.57522 .38804 .57833 .38482 .58147 .38648 .57837 .38972 Mtetra
.5 .019 .045 r
.57837 .38972 .58147 .38648 .58473 .38988 .58163 .39315 Mtetra
.537 .059 .07 r
.58163 .39315 .58473 .38988 .58807 .39399 .58496 .3973 Mtetra
.512 .032 .053 r
.58496 .3973 .58807 .39399 .59141 .39766 .5883 .401 Mtetra
.405 0 0 r
.5883 .401 .59141 .39766 .59469 .39978 .59158 .40314 Mtetra
.114 0 0 r
.59158 .40314 .59469 .39978 .59783 .39951 .59473 .40288 Mtetra
0 0 0 r
.59473 .40288 .59783 .39951 .6008 .39644 .59771 .3998 Mtetra
.901 .938 .57 r
.59771 .3998 .6008 .39644 .6036 .39068 .60052 .39401 Mtetra
.987 .884 .546 r
.60052 .39401 .6036 .39068 .60623 .38283 .60317 .38612 Mtetra
.998 .847 .526 r
.60317 .38612 .60623 .38283 .60878 .37386 .60574 .3771 Mtetra
.998 .846 .526 r
.60574 .3771 .60878 .37386 .6113 .36493 .60828 .36812 Mtetra
.988 .883 .546 r
.60828 .36812 .6113 .36493 .6139 .35715 .6109 .36031 Mtetra
.907 .939 .574 r
.6109 .36031 .6139 .35715 .61665 .35144 .61366 .35456 Mtetra
.517 .819 .49 r
.61366 .35456 .61665 .35144 .6196 .34832 .61662 .35144 Mtetra
.085 0 0 r
.61662 .35144 .6196 .34832 .62279 .34792 .61982 .35104 Mtetra
.389 0 0 r
.61982 .35104 .62279 .34792 .62619 .34989 .62322 .35303 Mtetra
.502 .012 .024 r
.62322 .35303 .62619 .34989 .62976 .35349 .6268 .35667 Mtetra
.532 .044 .044 r
.6268 .35667 .62976 .35349 .63343 .3577 .63046 .36092 Mtetra
.501 .011 .023 r
.63046 .36092 .63343 .3577 .63707 .36136 .6341 .36461 Mtetra
.386 0 0 r
.6341 .36461 .63707 .36136 .6406 .36338 .63764 .36665 Mtetra
.087 0 0 r
.63764 .36665 .6406 .36338 .64392 .36296 .64096 .36623 Mtetra
0 0 0 r
.64096 .36623 .64392 .36296 .64699 .35973 .64404 .36299 Mtetra
.889 .93 .55 r
.64404 .36299 .64699 .35973 .64979 .35386 .64686 .35709 Mtetra
.98 .884 .526 r
.64686 .35709 .64979 .35386 .65238 .34599 .64947 .34918 Mtetra
.995 .851 .507 r
.64947 .34918 .65238 .34599 .65486 .33712 .65196 .34026 Mtetra
.994 .854 .509 r
.65196 .34026 .65486 .33712 .65733 .32839 .65445 .33149 Mtetra
.974 .893 .532 r
.65445 .33149 .65733 .32839 .65991 .32092 .65705 .32398 Mtetra
.853 .933 .554 r
.65705 .32398 .65991 .32092 .66272 .31557 .65988 .31861 Mtetra
0 0 0 r
.65988 .31861 .66272 .31557 .66583 .31285 .66299 .31587 Mtetra
.144 0 0 r
.66299 .31587 .66583 .31285 .66925 .31281 .66642 .31584 Mtetra
.403 0 0 r
.66642 .31584 .66925 .31281 .67297 .31509 .67014 .31814 Mtetra
.502 .002 .001 r
.67014 .31814 .67297 .31509 .6769 .3189 .67408 .32199 Mtetra
.525 .027 .015 r
.67408 .32199 .6769 .3189 .68094 .32321 .67811 .32634 Mtetra
.489 0 0 r
.67811 .32634 .68094 .32321 .68493 .32686 .68211 .33002 Mtetra
.367 0 0 r
.68211 .33002 .68493 .32686 .68873 .32877 .68592 .33196 Mtetra
.062 0 0 r
.68592 .33196 .68873 .32877 .69225 .32819 .68944 .33138 Mtetra
0 0 0 r
.68944 .33138 .69225 .32819 .69541 .3248 .69262 .32798 Mtetra
.873 .92 .525 r
.69262 .32798 .69541 .3248 .69823 .31882 .69545 .32196 Mtetra
.97 .882 .502 r
.69545 .32196 .69823 .31882 .70078 .31091 .69802 .31402 Mtetra
.988 .854 .485 r
.69802 .31402 .70078 .31091 .70319 .30212 .70045 .30517 Mtetra
.985 .861 .489 r
.70045 .30517 .70319 .30212 .70562 .29359 .70289 .29659 Mtetra
.951 .899 .514 r
.70289 .29659 .70562 .29359 .70822 .28641 .70551 .28938 Mtetra
.782 .914 .528 r
.70551 .28938 .70822 .28641 .71113 .28141 .70844 .28436 Mtetra
0 0 0 r
.70844 .28436 .71113 .28141 .71443 .27906 .71175 .282 Mtetra
.191 0 0 r
.71175 .282 .71443 .27906 .71815 .27939 .71548 .28234 Mtetra
.414 0 0 r
.71548 .28234 .71815 .27939 .72224 .28197 .71957 .28495 Mtetra
.5 0 0 r
.71957 .28495 .72224 .28197 .72659 .286 .72393 .28901 Mtetra
.516 .007 0 r
.72393 .28901 .72659 .286 .73105 .29041 .72839 .29346 Mtetra
.475 0 0 r
.72839 .29346 .73105 .29041 .73542 .29405 .73277 .29713 Mtetra
.346 0 0 r
.73277 .29713 .73542 .29405 .73954 .29586 .7369 .29897 Mtetra
.038 0 0 r
.7369 .29897 .73954 .29586 .74327 .29511 .74064 .29823 Mtetra
.865 .942 .574 r
.30338 .72528 .30756 .71978 .31037 .71452 .3062 .71999 Mtetra
.989 .891 .605 r
.3062 .71999 .31037 .71452 .31343 .70641 .30929 .71183 Mtetra
.991 .831 .588 r
.30929 .71183 .31343 .70641 .31668 .69627 .31256 .70163 Mtetra
.986 .807 .579 r
.31256 .70163 .31668 .69627 .31999 .68528 .3159 .69057 Mtetra
.988 .816 .583 r
.3159 .69057 .31999 .68528 .32324 .67474 .31918 .67996 Mtetra
.993 .861 .598 r
.31918 .67996 .32324 .67474 .32633 .66584 .3223 .67101 Mtetra
.955 .936 .608 r
.3223 .67101 .32633 .66584 .32918 .65948 .32517 .66461 Mtetra
.573 .82 .444 r
.32517 .66461 .32918 .65948 .33177 .65612 .32777 .66123 Mtetra
.118 0 0 r
.32777 .66123 .33177 .65612 .33411 .6557 .33011 .66083 Mtetra
.415 0 .138 r
.33011 .66083 .33411 .6557 .33625 .65771 .33225 .66286 Mtetra
.511 .102 .201 r
.33225 .66286 .33625 .65771 .33828 .66121 .33427 .6664 Mtetra
.523 .115 .209 r
.33427 .6664 .33828 .66121 .34031 .66497 .3363 .6702 Mtetra
.465 .052 .171 r
.3363 .6702 .34031 .66497 .34245 .66773 .33842 .67299 Mtetra
.272 0 .048 r
.33842 .67299 .34245 .66773 .34476 .66837 .34074 .67364 Mtetra
0 0 0 r
.34074 .67364 .34476 .66837 .34732 .66613 .3433 .6714 Mtetra
.865 .939 .568 r
.3433 .6714 .34732 .66613 .35011 .66082 .34611 .66606 Mtetra
.989 .893 .595 r
.34611 .66606 .35011 .66082 .35311 .65277 .34913 .65796 Mtetra
.994 .836 .579 r
.34913 .65796 .35311 .65277 .35624 .64285 .35229 .64798 Mtetra
.991 .816 .572 r
.35229 .64798 .35624 .64285 .3594 .63221 .35548 .63728 Mtetra
.993 .828 .576 r
.35548 .63728 .3594 .63221 .36251 .62214 .35861 .62714 Mtetra
.993 .877 .592 r
.35861 .62714 .36251 .62214 .36548 .61378 .36161 .61873 Mtetra
.923 .943 .592 r
.36161 .61873 .36548 .61378 .36826 .60795 .36441 .61287 Mtetra
0 0 0 r
.36441 .61287 .36826 .60795 .37085 .60507 .367 .60998 Mtetra
.18 0 0 r
.367 .60998 .37085 .60507 .37324 .60505 .3694 .60997 Mtetra
.433 .01 .135 r
.3694 .60997 .37324 .60505 .3755 .60733 .37165 .61228 Mtetra
.515 .099 .189 r
.37165 .61228 .3755 .60733 .37768 .61095 .37383 .61593 Mtetra
.521 .105 .193 r
.37383 .61593 .37768 .61095 .37988 .61471 .37602 .61973 Mtetra
.455 .034 .15 r
.37602 .61973 .37988 .61471 .38217 .61736 .37831 .62242 Mtetra
.251 0 .022 r
.37831 .62242 .38217 .61736 .38461 .61785 .38074 .62292 Mtetra
0 0 0 r
.38074 .62292 .38461 .61785 .38722 .61548 .38337 .62055 Mtetra
.863 .935 .559 r
.38337 .62055 .38722 .61548 .39001 .6101 .38617 .61514 Mtetra
.988 .894 .584 r
.38617 .61514 .39001 .6101 .39295 .60211 .38913 .6071 Mtetra
.996 .841 .569 r
.38913 .6071 .39295 .60211 .39596 .59238 .39217 .59731 Mtetra
.995 .824 .563 r
.39217 .59731 .39596 .59238 .39899 .58208 .39523 .58695 Mtetra
.996 .841 .569 r
.39523 .58695 .39899 .58208 .40197 .57245 .39823 .57725 Mtetra
.989 .892 .584 r
.39823 .57725 .40197 .57245 .40485 .56458 .40113 .56934 Mtetra
.874 .939 .568 r
.40113 .56934 .40485 .56458 .40759 .55926 .40389 .56399 Mtetra
0 0 0 r
.40389 .56399 .40759 .55926 .41019 .55684 .4065 .56157 Mtetra
.232 0 0 r
.4065 .56157 .41019 .55684 .41267 .55719 .40898 .56193 Mtetra
.447 .018 .129 r
.40898 .56193 .41267 .55719 .41507 .55972 .41137 .56449 Mtetra
.518 .094 .175 r
.41137 .56449 .41507 .55972 .41743 .56345 .41373 .56826 Mtetra
.517 .093 .174 r
.41373 .56826 .41743 .56345 .41982 .56721 .41611 .57205 Mtetra
.445 .015 .128 r
.41611 .57205 .41982 .56721 .42227 .56976 .41856 .57464 Mtetra
.228 0 0 r
.41856 .57464 .42227 .56976 .42483 .5701 .42112 .57499 Mtetra
0 0 0 r
.42112 .57499 .42483 .5701 .42751 .56759 .42381 .57248 Mtetra
.859 .931 .549 r
.42381 .57248 .42751 .56759 .4303 .56215 .42662 .567 Mtetra
.986 .895 .571 r
.42662 .567 .4303 .56215 .43317 .5542 .42951 .55901 Mtetra
.998 .847 .557 r
.42951 .55901 .43317 .5542 .43608 .54465 .43245 .5494 Mtetra
.998 .833 .552 r
.43245 .5494 .43608 .54465 .43899 .53465 .43538 .53934 Mtetra
.997 .853 .559 r
.43538 .53934 .43899 .53465 .44186 .52543 .43828 .53005 Mtetra
.978 .906 .574 r
.43828 .53005 .44186 .52543 .44467 .51803 .4411 .52261 Mtetra
.806 .921 .536 r
.4411 .52261 .44467 .51803 .44739 .51319 .44384 .51775 Mtetra
0 0 0 r
.44384 .51775 .44739 .51319 .45004 .51121 .4465 .51577 Mtetra
.274 0 .007 r
.4465 .51577 .45004 .51121 .45264 .51191 .4491 .51649 Mtetra
.459 .022 .12 r
.4491 .51649 .45264 .51191 .4552 .51468 .45166 .51928 Mtetra
.519 .087 .159 r
.45166 .51928 .4552 .51468 .45776 .51852 .45421 .52317 Mtetra
.512 .079 .154 r
.45421 .52317 .45776 .51852 .46035 .52226 .4568 .52695 Mtetra
.433 0 .105 r
.4568 .52695 .46035 .52226 .46299 .52471 .45943 .52943 Mtetra
.206 0 0 r
.45943 .52943 .46299 .52471 .46568 .5249 .46213 .52963 Mtetra
0 0 0 r
.46213 .52963 .46568 .5249 .46843 .52226 .46489 .52698 Mtetra
.853 .925 .536 r
.46489 .52698 .46843 .52226 .47122 .51674 .46769 .52143 Mtetra
.982 .895 .556 r
.46769 .52143 .47122 .51674 .47403 .50882 .47053 .51347 Mtetra
.998 .852 .544 r
.47053 .51347 .47403 .50882 .47685 .49943 .47337 .50401 Mtetra
.999 .841 .54 r
.47337 .50401 .47685 .49943 .47965 .48972 .47619 .49424 Mtetra
.996 .864 .548 r
.47619 .49424 .47965 .48972 .48243 .48088 .47899 .48535 Mtetra
.959 .916 .56 r
.47899 .48535 .48243 .48088 .48518 .47392 .48177 .47835 Mtetra
.72 .888 .497 r
.48177 .47835 .48518 .47392 .48792 .46954 .48452 .47395 Mtetra
0 0 0 r
.48452 .47395 .48792 .46954 .49065 .46798 .48725 .47239 Mtetra
.308 0 .013 r
.48725 .47239 .49065 .46798 .49339 .46902 .49 .47345 Mtetra
.468 .024 .109 r
.49 .47345 .49339 .46902 .49615 .47201 .49276 .47647 Mtetra
.519 .078 .141 r
.49276 .47647 .49615 .47201 .49894 .47596 .49554 .48046 Mtetra
.507 .064 .133 r
.49554 .48046 .49894 .47596 .50175 .47969 .49835 .48423 Mtetra
.42 0 .08 r
.49835 .48423 .50175 .47969 .50459 .48203 .50118 .48661 Mtetra
.182 0 0 r
.50118 .48661 .50459 .48203 .50742 .48207 .50402 .48666 Mtetra
0 0 0 r
.50402 .48666 .50742 .48207 .51024 .47929 .50686 .48386 Mtetra
.845 .917 .52 r
.50686 .48386 .51024 .47929 .51303 .47369 .50966 .47823 Mtetra
.976 .894 .539 r
.50966 .47823 .51303 .47369 .51579 .46579 .51244 .47029 Mtetra
.996 .856 .528 r
.51244 .47029 .51579 .46579 .51852 .45654 .51519 .46098 Mtetra
.998 .849 .526 r
.51519 .46098 .51852 .45654 .52122 .44709 .51792 .45147 Mtetra
.99 .875 .534 r
.51792 .45147 .52122 .44709 .52392 .43861 .52064 .44294 Mtetra
.93 .92 .541 r
.52064 .44294 .52392 .43861 .52665 .43208 .52339 .43637 Mtetra
.62 .839 .451 r
.52339 .43637 .52665 .43208 .52943 .42813 .52618 .43241 Mtetra
0 0 0 r
.52618 .43241 .52943 .42813 .53228 .42697 .52903 .43125 Mtetra
.336 0 .014 r
.52903 .43125 .53228 .42697 .5352 .42834 .53196 .43264 Mtetra
.475 .022 .095 r
.53196 .43264 .5352 .42834 .53819 .43155 .53495 .43588 Mtetra
.518 .068 .121 r
.53495 .43588 .53819 .43155 .54124 .4356 .53799 .43997 Mtetra
.499 .048 .11 r
.53799 .43997 .54124 .4356 .5443 .43932 .54105 .44373 Mtetra
.406 0 .055 r
.54105 .44373 .5443 .43932 .54734 .44156 .5441 .446 Mtetra
.159 0 0 r
.5441 .446 .54734 .44156 .55033 .44145 .54709 .4459 Mtetra
0 0 0 r
.54709 .4459 .55033 .44145 .55323 .43852 .55 .44296 Mtetra
.833 .908 .502 r
.55 .44296 .55323 .43852 .55603 .43283 .55282 .43724 Mtetra
.968 .892 .519 r
.55282 .43724 .55603 .43283 .55873 .42494 .55554 .4293 Mtetra
.992 .859 .51 r
.55554 .4293 .55873 .42494 .56137 .41582 .55821 .42012 Mtetra
.994 .855 .509 r
.55821 .42012 .56137 .41582 .56399 .40661 .56085 .41086 Mtetra
.978 .883 .518 r
.56085 .41086 .56399 .40661 .56664 .39847 .56352 .40267 Mtetra
.886 .915 .517 r
.56352 .40267 .56664 .39847 .56937 .39234 .56627 .39651 Mtetra
0 0 0 r
.56627 .39651 .56937 .39234 .57223 .38881 .56913 .39296 Mtetra
.052 0 0 r
.56913 .39296 .57223 .38881 .57522 .38804 .57214 .3922 Mtetra
.358 0 .01 r
.57214 .3922 .57522 .38804 .57837 .38972 .57528 .3939 Mtetra
.48 .018 .079 r
.57528 .3939 .57837 .38972 .58163 .39315 .57854 .39736 Mtetra
.515 .055 .099 r
.57854 .39736 .58163 .39315 .58496 .3973 .58188 .40156 Mtetra
.491 .03 .085 r
.58188 .40156 .58496 .3973 .5883 .401 .58522 .4053 Mtetra
.39 0 .029 r
.58522 .4053 .5883 .401 .59158 .40314 .5885 .40747 Mtetra
.136 0 0 r
.5885 .40747 .59158 .40314 .59473 .40288 .59165 .40722 Mtetra
0 0 0 r
.59165 .40722 .59473 .40288 .59771 .3998 .59465 .40413 Mtetra
.819 .897 .481 r
.59465 .40413 .59771 .3998 .60052 .39401 .59747 .3983 Mtetra
.957 .888 .496 r
.59747 .3983 .60052 .39401 .60317 .38612 .60015 .39036 Mtetra
.985 .86 .489 r
.60015 .39036 .60317 .38612 .60574 .3771 .60273 .38129 Mtetra
.60273 .38129 .60574 .3771 .60828 .36812 .6053 .37225 Mtetra
.959 .887 .497 r
.6053 .37225 .60828 .36812 .6109 .36031 .60794 .36439 Mtetra
.828 .9 .487 r
.60794 .36439 .6109 .36031 .61366 .35456 .61072 .35861 Mtetra
0 0 0 r
.61072 .35861 .61366 .35456 .61662 .35144 .61369 .35548 Mtetra
.112 0 0 r
.61369 .35548 .61662 .35144 .61982 .35104 .61689 .35509 Mtetra
.376 0 .002 r
.61689 .35509 .61982 .35104 .62322 .35303 .6203 .35711 Mtetra
.483 .012 .06 r
.6203 .35711 .62322 .35303 .6268 .35667 .62388 .36078 Mtetra
.511 .041 .076 r
.62388 .36078 .6268 .35667 .63046 .36092 .62754 .36508 Mtetra
.481 .011 .059 r
.62754 .36508 .63046 .36092 .6341 .36461 .63119 .36881 Mtetra
.374 0 .003 r
.63119 .36881 .6341 .36461 .63764 .36665 .63473 .37088 Mtetra
.114 0 0 r
.63473 .37088 .63764 .36665 .64096 .36623 .63806 .37047 Mtetra
0 0 0 r
.63806 .37047 .64096 .36623 .64404 .36299 .64115 .36722 Mtetra
.801 .883 .456 r
.64115 .36722 .64404 .36299 .64686 .35709 .64399 .36128 Mtetra
.942 .881 .47 r
.64399 .36128 .64686 .35709 .64947 .34918 .64662 .35332 Mtetra
.973 .859 .464 r
.64662 .35332 .64947 .34918 .65196 .34026 .64913 .34434 Mtetra
.971 .861 .465 r
.64913 .34434 .65196 .34026 .65445 .33149 .65164 .33552 Mtetra
.93 .886 .472 r
.65164 .33552 .65445 .33149 .65705 .32398 .65426 .32796 Mtetra
.755 .873 .451 r
.65426 .32796 .65705 .32398 .65988 .31861 .6571 .32256 Mtetra
0 0 0 r
.6571 .32256 .65988 .31861 .66299 .31587 .66023 .31982 Mtetra
.162 0 0 r
.66023 .31982 .66299 .31587 .66642 .31584 .66367 .3198 Mtetra
.39 0 0 r
.66367 .3198 .66642 .31584 .67014 .31814 .6674 .32213 Mtetra
.483 .003 .039 r
.6674 .32213 .67014 .31814 .67408 .32199 .67134 .32602 Mtetra
.505 .025 .05 r
.67134 .32602 .67408 .32199 .67811 .32634 .67538 .33041 Mtetra
.47 0 .032 r
.67538 .33041 .67811 .32634 .68211 .33002 .67938 .33413 Mtetra
.357 0 0 r
.67938 .33413 .68211 .33002 .68592 .33196 .6832 .3361 Mtetra
.093 0 0 r
.6832 .3361 .68592 .33196 .68944 .33138 .68673 .33553 Mtetra
0 0 0 r
.68673 .33553 .68944 .33138 .69262 .32798 .68992 .33212 Mtetra
.779 .866 .428 r
.68992 .33212 .69262 .32798 .69545 .32196 .69277 .32606 Mtetra
.922 .87 .44 r
.69277 .32606 .69545 .32196 .69802 .31402 .69536 .31807 Mtetra
.955 .854 .435 r
.69536 .31807 .69802 .31402 .70045 .30517 .69781 .30917 Mtetra
.949 .858 .437 r
.69781 .30917 .70045 .30517 .70289 .29659 .70027 .30053 Mtetra
.889 .877 .442 r
.70027 .30053 .70289 .29659 .70551 .28938 .70291 .29327 Mtetra
.669 .835 .412 r
.70291 .29327 .70551 .28938 .70844 .28436 .70585 .28823 Mtetra
0 0 0 r
.70585 .28823 .70844 .28436 .71175 .282 .70917 .28587 Mtetra
.202 0 0 r
.70917 .28587 .71175 .282 .71548 .28234 .71291 .28622 Mtetra
.401 0 0 r
.71291 .28622 .71548 .28234 .71957 .28495 .71701 .28886 Mtetra
.482 0 .014 r
.71701 .28886 .71957 .28495 .72393 .28901 .72138 .29296 Mtetra
.498 .007 .022 r
.72138 .29296 .72393 .28901 .72839 .29346 .72585 .29746 Mtetra
.458 0 .003 r
.72585 .29746 .72839 .29346 .73277 .29713 .73024 .30117 Mtetra
.339 0 0 r
.73024 .30117 .73277 .29713 .7369 .29897 .73437 .30304 Mtetra
.073 0 0 r
.73437 .30304 .7369 .29897 .74064 .29823 .73813 .30231 Mtetra
.884 .95 .597 r
.29919 .73053 .30338 .72528 .3062 .71999 .30203 .72522 Mtetra
.99 .885 .612 r
.30203 .72522 .3062 .71999 .30929 .71183 .30514 .71701 Mtetra
.988 .823 .592 r
.30514 .71701 .30929 .71183 .31256 .70163 .30844 .70674 Mtetra
.982 .8 .582 r
.30844 .70674 .31256 .70163 .3159 .69057 .31181 .69562 Mtetra
.985 .809 .586 r
.31181 .69562 .3159 .69057 .31918 .67996 .31512 .68494 Mtetra
.991 .854 .603 r
.31512 .68494 .31918 .67996 .3223 .67101 .31826 .67594 Mtetra
.963 .934 .621 r
.31826 .67594 .3223 .67101 .32517 .66461 .32115 .66951 Mtetra
.604 .846 .478 r
.32115 .66951 .32517 .66461 .32777 .66123 .32375 .66612 Mtetra
.112 0 0 r
.32375 .66612 .32777 .66123 .33011 .66083 .3261 .66572 Mtetra
.42 0 .13 r
.3261 .66572 .33011 .66083 .33225 .66286 .32823 .66778 Mtetra
.517 .104 .197 r
.32823 .66778 .33225 .66286 .33427 .6664 .33025 .67135 Mtetra
.529 .118 .205 r
.33025 .67135 .33427 .6664 .3363 .6702 .33227 .67519 Mtetra
.471 .053 .165 r
.33227 .67519 .3363 .6702 .33842 .67299 .33439 .67801 Mtetra
.273 0 .035 r
.33439 .67801 .33842 .67299 .34074 .67364 .33671 .67868 Mtetra
0 0 0 r
.33671 .67868 .34074 .67364 .3433 .6714 .33927 .67644 Mtetra
.884 .948 .59 r
.33927 .67644 .3433 .6714 .34611 .66606 .3421 .67107 Mtetra
.99 .887 .603 r
.3421 .67107 .34611 .66606 .34913 .65796 .34514 .66293 Mtetra
.991 .829 .583 r
.34514 .66293 .34913 .65796 .35229 .64798 .34832 .65288 Mtetra
.988 .809 .575 r
.34832 .65288 .35229 .64798 .35548 .63728 .35154 .64211 Mtetra
.99 .821 .58 r
.35154 .64211 .35548 .63728 .35861 .62714 .3547 .63192 Mtetra
.993 .87 .599 r
.3547 .63192 .35861 .62714 .36161 .61873 .35772 .62345 Mtetra
.935 .945 .609 r
.35772 .62345 .36161 .61873 .36441 .61287 .36054 .61757 Mtetra
0 0 0 r
.36054 .61757 .36441 .61287 .367 .60998 .36314 .61467 Mtetra
.177 0 0 r
.36314 .61467 .367 .60998 .3694 .60997 .36554 .61467 Mtetra
.438 .01 .127 r
.36554 .61467 .3694 .60997 .37165 .61228 .36778 .617 Mtetra
.521 .101 .184 r
.36778 .617 .37165 .61228 .37383 .61593 .36996 .6207 Mtetra
.527 .107 .188 r
.36996 .6207 .37383 .61593 .37602 .61973 .37214 .62453 Mtetra
.461 .035 .143 r
.37214 .62453 .37602 .61973 .37831 .62242 .37442 .62725 Mtetra
.251 0 .008 r
.37442 .62725 .37831 .62242 .38074 .62292 .37686 .62776 Mtetra
0 0 0 r
.37686 .62776 .38074 .62292 .38337 .62055 .37949 .62538 Mtetra
.883 .944 .582 r
.37949 .62538 .38337 .62055 .38617 .61514 .38232 .61995 Mtetra
.99 .889 .592 r
.38232 .61995 .38617 .61514 .38913 .6071 .38529 .61187 Mtetra
.994 .835 .574 r
.38529 .61187 .38913 .6071 .39217 .59731 .38836 .60202 Mtetra
.992 .817 .567 r
.38836 .60202 .39217 .59731 .39523 .58695 .39144 .59159 Mtetra
.994 .834 .574 r
.39144 .59159 .39523 .58695 .39823 .57725 .39447 .58184 Mtetra
.991 .887 .593 r
.39447 .58184 .39823 .57725 .40113 .56934 .39739 .57388 Mtetra
.892 .947 .59 r
.39739 .57388 .40113 .56934 .40389 .56399 .40016 .56851 Mtetra
0 0 0 r
.40016 .56851 .40389 .56399 .4065 .56157 .40278 .56608 Mtetra
.231 0 0 r
.40278 .56608 .4065 .56157 .40898 .56193 .40527 .56645 Mtetra
.453 .018 .122 r
.40527 .56645 .40898 .56193 .41137 .56449 .40765 .56904 Mtetra
.524 .096 .169 r
.40765 .56904 .41137 .56449 .41373 .56826 .41001 .57285 Mtetra
.523 .095 .169 r
.41001 .57285 .41373 .56826 .41611 .57205 .41238 .57668 Mtetra
.45 .016 .12 r
.41238 .57668 .41611 .57205 .41856 .57464 .41483 .57929 Mtetra
.227 0 0 r
.41483 .57929 .41856 .57464 .42112 .57499 .41739 .57965 Mtetra
0 0 0 r
.41739 .57965 .42112 .57499 .42381 .57248 .42009 .57714 Mtetra
.88 .94 .572 r
.42009 .57714 .42381 .57248 .42662 .567 .42291 .57163 Mtetra
.989 .891 .58 r
.42291 .57163 .42662 .567 .42951 .55901 .42583 .56359 Mtetra
.997 .84 .563 r
.42583 .56359 .42951 .55901 .43245 .5494 .42879 .55392 Mtetra
.996 .826 .558 r
.42879 .55392 .43245 .5494 .43538 .53934 .43175 .5438 Mtetra
.997 .847 .566 r
.43175 .5438 .43538 .53934 .43828 .53005 .43467 .53447 Mtetra
.983 .903 .585 r
.43467 .53447 .43828 .53005 .4411 .52261 .43751 .52698 Mtetra
.83 .935 .563 r
.43751 .52698 .4411 .52261 .44384 .51775 .44026 .5221 Mtetra
0 0 0 r
.44026 .5221 .44384 .51775 .4465 .51577 .44293 .52011 Mtetra
.274 0 0 r
.44293 .52011 .4465 .51577 .4491 .51649 .44553 .52085 Mtetra
.464 .023 .113 r
.44553 .52085 .4491 .51649 .45166 .51928 .44808 .52367 Mtetra
.525 .089 .153 r
.44808 .52367 .45166 .51928 .45421 .52317 .45064 .52759 Mtetra
.518 .081 .148 r
.45064 .52759 .45421 .52317 .4568 .52695 .45322 .53141 Mtetra
.438 0 .096 r
.45322 .53141 .4568 .52695 .45943 .52943 .45585 .53392 Mtetra
.204 0 0 r
.45585 .53392 .45943 .52943 .46213 .52963 .45855 .53413 Mtetra
0 0 0 r
.45855 .53413 .46213 .52963 .46489 .52698 .46132 .53148 Mtetra
.874 .935 .559 r
.46132 .53148 .46489 .52698 .46769 .52143 .46414 .5259 Mtetra
.987 .892 .567 r
.46414 .5259 .46769 .52143 .47053 .51347 .46699 .51789 Mtetra
.998 .846 .551 r
.46699 .51789 .47053 .51347 .47337 .50401 .46985 .50838 Mtetra
.998 .835 .547 r
.46985 .50838 .47337 .50401 .47619 .49424 .47271 .49855 Mtetra
.997 .859 .556 r
.47271 .49855 .47619 .49424 .47899 .48535 .47553 .4896 Mtetra
.968 .915 .574 r
.47553 .4896 .47899 .48535 .48177 .47835 .47832 .48257 Mtetra
.749 .908 .527 r
.47832 .48257 .48177 .47835 .48452 .47395 .48108 .47815 Mtetra
0 0 0 r
.48108 .47815 .48452 .47395 .48725 .47239 .48383 .47658 Mtetra
.31 0 0 r
.48383 .47658 .48725 .47239 .49 .47345 .48657 .47766 Mtetra
.474 .024 .101 r
.48657 .47766 .49 .47345 .49276 .47647 .48933 .48072 Mtetra
.525 .08 .135 r
.48933 .48072 .49276 .47647 .49554 .48046 .49211 .48474 Mtetra
.512 .066 .126 r
.49211 .48474 .49554 .48046 .49835 .48423 .49492 .48855 Mtetra
.425 0 .071 r
.49492 .48855 .49835 .48423 .50118 .48661 .49775 .49096 Mtetra
.179 0 0 r
.49775 .49096 .50118 .48661 .50402 .48666 .50059 .49102 Mtetra
0 0 0 r
.50059 .49102 .50402 .48666 .50686 .48386 .50343 .48822 Mtetra
.867 .929 .544 r
.50343 .48822 .50686 .48386 .50966 .47823 .50626 .48255 Mtetra
.983 .892 .551 r
.50626 .48255 .50966 .47823 .51244 .47029 .50906 .47457 Mtetra
.998 .851 .536 r
.50906 .47457 .51244 .47029 .51519 .46098 .51183 .4652 Mtetra
.999 .844 .534 r
.51183 .4652 .51519 .46098 .51792 .45147 .51458 .45563 Mtetra
.993 .871 .544 r
.51458 .45563 .51792 .45147 .52064 .44294 .51733 .44705 Mtetra
.943 .923 .558 r
.51733 .44705 .52064 .44294 .52339 .43637 .52009 .44045 Mtetra
.652 .864 .484 r
.52009 .44045 .52339 .43637 .52618 .43241 .52289 .43647 Mtetra
0 0 0 r
.52289 .43647 .52618 .43241 .52903 .43125 .52575 .43531 Mtetra
.338 0 .001 r
.52575 .43531 .52903 .43125 .53196 .43264 .52868 .43672 Mtetra
.481 .023 .087 r
.52868 .43672 .53196 .43264 .53495 .43588 .53167 .44 Mtetra
.524 .069 .114 r
.53167 .44 .53495 .43588 .53799 .43997 .53471 .44413 Mtetra
.505 .049 .103 r
.53471 .44413 .53799 .43997 .54105 .44373 .53777 .44792 Mtetra
.41 0 .045 r
.53777 .44792 .54105 .44373 .5441 .446 .54082 .45023 Mtetra
.155 0 0 r
.54082 .45023 .5441 .446 .54709 .4459 .54382 .45014 Mtetra
0 0 0 r
.54382 .45014 .54709 .4459 .55 .44296 .54674 .44719 Mtetra
.857 .921 .527 r
.54674 .44719 .55 .44296 .55282 .43724 .54957 .44143 Mtetra
.976 .891 .532 r
.54957 .44143 .55282 .43724 .55554 .4293 .55231 .43345 Mtetra
.996 .855 .52 r
.55231 .43345 .55554 .4293 .55821 .42012 .555 .42421 Mtetra
.997 .851 .518 r
.555 .42421 .55821 .42012 .56085 .41086 .55766 .41489 Mtetra
.984 .881 .53 r
.55766 .41489 .56085 .41086 .56352 .40267 .56035 .40666 Mtetra
.905 .923 .538 r
.56035 .40666 .56352 .40267 .56627 .39651 .56312 .40046 Mtetra
0 0 0 r
.56312 .40046 .56627 .39651 .56913 .39296 .56599 .3969 Mtetra
.043 0 0 r
.56599 .3969 .56913 .39296 .57214 .3922 .569 .39614 Mtetra
.361 0 0 r
.569 .39614 .57214 .3922 .57528 .3939 .57215 .39787 Mtetra
.485 .019 .07 r
.57215 .39787 .57528 .3939 .57854 .39736 .57542 .40137 Mtetra
.521 .057 .092 r
.57542 .40137 .57854 .39736 .58188 .40156 .57875 .4056 Mtetra
.497 .031 .077 r
.57875 .4056 .58188 .40156 .58522 .4053 .58209 .40938 Mtetra
.394 0 .018 r
.58209 .40938 .58522 .4053 .5885 .40747 .58537 .41158 Mtetra
.131 0 0 r
.58537 .41158 .5885 .40747 .59165 .40722 .58854 .41134 Mtetra
0 0 0 r
.58854 .41134 .59165 .40722 .59465 .40413 .59154 .40824 Mtetra
.843 .911 .506 r
.59154 .40824 .59465 .40413 .59747 .3983 .59438 .40238 Mtetra
.967 .889 .511 r
.59438 .40238 .59747 .3983 .60015 .39036 .59708 .39439 Mtetra
.99 .858 .5 r
.59708 .39439 .60015 .39036 .60273 .38129 .59968 .38526 Mtetra
.99 .857 .5 r
.59968 .38526 .60273 .38129 .6053 .37225 .60227 .37617 Mtetra
.969 .888 .511 r
.60227 .37617 .6053 .37225 .60794 .36439 .60493 .36827 Mtetra
.852 .914 .512 r
.60493 .36827 .60794 .36439 .61072 .35861 .60772 .36246 Mtetra
0 0 0 r
.60772 .36246 .61072 .35861 .61369 .35548 .61071 .35931 Mtetra
.106 0 0 r
.61071 .35931 .61369 .35548 .61689 .35509 .61391 .35893 Mtetra
.38 0 0 r
.61391 .35893 .61689 .35509 .6203 .35711 .61733 .36097 Mtetra
.488 .012 .051 r
.61733 .36097 .6203 .35711 .62388 .36078 .62091 .36469 Mtetra
.516 .042 .068 r
.62091 .36469 .62388 .36078 .62754 .36508 .62457 .36902 Mtetra
.487 .011 .05 r
.62457 .36902 .62754 .36508 .63119 .36881 .62822 .37279 Mtetra
.377 0 0 r
.62822 .37279 .63119 .36881 .63473 .37088 .63177 .37489 Mtetra
.108 0 0 r
.63177 .37489 .63473 .37088 .63806 .37047 .63511 .37449 Mtetra
0 0 0 r
.63511 .37449 .63806 .37047 .64115 .36722 .63821 .37123 Mtetra
.827 .898 .482 r
.63821 .37123 .64115 .36722 .64399 .36128 .64107 .36526 Mtetra
.955 .884 .487 r
.64107 .36526 .64399 .36128 .64662 .35332 .64371 .35725 Mtetra
.981 .858 .477 r
.64371 .35725 .64662 .35332 .64913 .34434 .64625 .34822 Mtetra
.979 .861 .478 r
.64625 .34822 .64913 .34434 .65164 .33552 .64878 .33934 Mtetra
.944 .89 .489 r
.64878 .33934 .65164 .33552 .65426 .32796 .65142 .33174 Mtetra
.783 .892 .48 r
.65142 .33174 .65426 .32796 .6571 .32256 .65427 .32631 Mtetra
0 0 0 r
.65427 .32631 .6571 .32256 .66023 .31982 .65741 .32355 Mtetra
.157 0 0 r
.65741 .32355 .66023 .31982 .66367 .3198 .66086 .32355 Mtetra
.394 0 0 r
.66086 .32355 .66367 .3198 .6674 .32213 .66459 .3259 Mtetra
.489 .003 .029 r
.66459 .3259 .6674 .32213 .67134 .32602 .66854 .32984 Mtetra
.51 .026 .041 r
.66854 .32984 .67134 .32602 .67538 .33041 .67258 .33427 Mtetra
.475 0 .022 r
.67258 .33427 .67538 .33041 .67938 .33413 .67659 .33803 Mtetra
.36 0 0 r
.67659 .33803 .67938 .33413 .6832 .3361 .68041 .34003 Mtetra
.085 0 0 r
.68041 .34003 .6832 .3361 .68673 .33553 .68396 .33947 Mtetra
0 0 0 r
.68396 .33947 .68673 .33553 .68992 .33212 .68716 .33604 Mtetra
.806 .883 .455 r
.68716 .33604 .68992 .33212 .69277 .32606 .69003 .32995 Mtetra
.937 .876 .458 r
.69003 .32995 .69277 .32606 .69536 .31807 .69263 .3219 Mtetra
.966 .856 .45 r
.69263 .3219 .69536 .31807 .69781 .30917 .6951 .31295 Mtetra
.961 .861 .452 r
.6951 .31295 .69781 .30917 .70027 .30053 .69759 .30426 Mtetra
.908 .886 .463 r
.69759 .30426 .70027 .30053 .70291 .29327 .70024 .29696 Mtetra
.701 .858 .443 r
.70024 .29696 .70291 .29327 .70585 .28823 .7032 .29189 Mtetra
0 0 0 r
.7032 .29189 .70585 .28823 .70917 .28587 .70654 .28952 Mtetra
.2 0 0 r
.70654 .28952 .70917 .28587 .71291 .28622 .71028 .28989 Mtetra
.405 0 0 r
.71028 .28989 .71291 .28622 .71701 .28886 .71439 .29256 Mtetra
.487 0 .004 r
.71439 .29256 .71701 .28886 .72138 .29296 .71876 .29671 Mtetra
.503 .007 .012 r
.71876 .29671 .72138 .29296 .72585 .29746 .72324 .30125 Mtetra
.462 0 0 r
.72324 .30125 .72585 .29746 .73024 .30117 .72764 .305 Mtetra
.341 0 0 r
.72764 .305 .73024 .30117 .73437 .30304 .73178 .30689 Mtetra
.065 0 0 r
.73178 .30689 .73437 .30304 .73813 .30231 .73555 .30617 Mtetra
.951 .955 .694 r
.29513 .73425 .29919 .73053 .30203 .72522 .29797 .72891 Mtetra
.977 .839 .639 r
.29797 .72891 .30203 .72522 .30514 .71701 .30111 .72067 Mtetra
.964 .779 .605 r
.30111 .72067 .30514 .71701 .30844 .70674 .30443 .71035 Mtetra
.957 .758 .593 r
.30443 .71035 .30844 .70674 .31181 .69562 .30783 .69917 Mtetra
.96 .766 .598 r
.30783 .69917 .31181 .69562 .31512 .68494 .31116 .68845 Mtetra
.971 .807 .622 r
.31116 .68845 .31512 .68494 .31826 .67594 .31432 .6794 Mtetra
.977 .9 .674 r
.31432 .6794 .31826 .67594 .32115 .66951 .31723 .67294 Mtetra
.773 .967 .672 r
.31723 .67294 .32115 .66951 .32375 .66612 .31984 .66954 Mtetra
.069 0 0 r
.31984 .66954 .32375 .66612 .3261 .66572 .32219 .66915 Mtetra
.451 0 .081 r
.32219 .66915 .3261 .66572 .32823 .66778 .32432 .67123 Mtetra
.555 .119 .167 r
.32432 .67123 .32823 .66778 .33025 .67135 .32633 .67482 Mtetra
.568 .134 .177 r
.32633 .67482 .33025 .67135 .33227 .67519 .32833 .6787 Mtetra
.506 .061 .126 r
.32833 .6787 .33227 .67519 .33439 .67801 .33045 .68154 Mtetra
.277 0 0 r
.33045 .68154 .33439 .67801 .33671 .67868 .33276 .68222 Mtetra
0 0 0 r
.33276 .68222 .33671 .67868 .33927 .67644 .33534 .67997 Mtetra
.952 .954 .689 r
.33534 .67997 .33927 .67644 .3421 .67107 .33818 .67458 Mtetra
.98 .843 .633 r
.33818 .67458 .3421 .67107 .34514 .66293 .34124 .6664 Mtetra
.969 .785 .6 r
.34124 .6664 .34514 .66293 .34832 .65288 .34444 .65631 Mtetra
.964 .766 .588 r
.34444 .65631 .34832 .65288 .35154 .64211 .34769 .64549 Mtetra
.967 .778 .595 r
.34769 .64549 .35154 .64211 .3547 .63192 .35087 .63524 Mtetra
.978 .825 .624 r
.35087 .63524 .3547 .63192 .35772 .62345 .35391 .62674 Mtetra
.971 .926 .68 r
.35391 .62674 .35772 .62345 .36054 .61757 .35674 .62083 Mtetra
.659 .924 .63 r
.35674 .62083 .36054 .61757 .36314 .61467 .35935 .61792 Mtetra
.155 0 0 r
.35935 .61792 .36314 .61467 .36554 .61467 .36175 .61793 Mtetra
.47 .011 .079 r
.36175 .61793 .36554 .61467 .36778 .617 .36399 .62028 Mtetra
.559 .115 .152 r
.36399 .62028 .36778 .617 .36996 .6207 .36616 .624 Mtetra
.565 .122 .157 r
.36616 .624 .36996 .6207 .37214 .62453 .36833 .62787 Mtetra
.496 .04 .1 r
.36833 .62787 .37214 .62453 .37442 .62725 .37061 .63061 Mtetra
.249 0 0 r
.37061 .63061 .37442 .62725 .37686 .62776 .37305 .63114 Mtetra
.485 .826 .539 r
.37305 .63114 .37686 .62776 .37949 .62538 .37568 .62875 Mtetra
.953 .953 .682 r
.37568 .62875 .37949 .62538 .38232 .61995 .37852 .62329 Mtetra
.984 .847 .627 r
.37852 .62329 .38232 .61995 .38529 .61187 .38151 .61517 Mtetra
.974 .791 .594 r
.38151 .61517 .38529 .61187 .38836 .60202 .3846 .60528 Mtetra
.97 .775 .584 r
.3846 .60528 .38836 .60202 .39144 .59159 .38771 .5948 Mtetra
.974 .79 .593 r
.38771 .5948 .39144 .59159 .39447 .58184 .39077 .585 Mtetra
.983 .844 .626 r
.39077 .585 .39447 .58184 .39739 .57388 .3937 .57701 Mtetra
.956 .95 .685 r
.3937 .57701 .39739 .57388 .40016 .56851 .39649 .57161 Mtetra
.524 .854 .573 r
.39649 .57161 .40016 .56851 .40278 .56608 .39911 .56918 Mtetra
.223 0 0 r
.39911 .56918 .40278 .56608 .40527 .56645 .40159 .56956 Mtetra
.486 .02 .073 r
.40159 .56956 .40527 .56645 .40765 .56904 .40398 .57217 Mtetra
.562 .109 .135 r
.40398 .57217 .40765 .56904 .41001 .57285 .40632 .57601 Mtetra
.561 .108 .134 r
.40632 .57601 .41001 .57285 .41238 .57668 .40869 .57986 Mtetra
.483 .017 .071 r
.40869 .57986 .41238 .57668 .41483 .57929 .41113 .5825 Mtetra
.219 0 0 r
.41113 .5825 .41483 .57929 .41739 .57965 .4137 .58287 Mtetra
.514 .845 .557 r
.4137 .58287 .41739 .57965 .42009 .57714 .4164 .58035 Mtetra
.953 .952 .674 r
.4164 .58035 .42009 .57714 .42291 .57163 .41923 .57482 Mtetra
.987 .851 .619 r
.41923 .57482 .42291 .57163 .42583 .56359 .42217 .56675 Mtetra
.98 .798 .587 r
.42217 .56675 .42583 .56359 .42879 .55392 .42515 .55703 Mtetra
.977 .784 .578 r
.42515 .55703 .42879 .55392 .43175 .5438 .42813 .54686 Mtetra
.981 .804 .591 r
.42813 .54686 .43175 .5438 .43467 .53447 .43107 .53748 Mtetra
.987 .865 .629 r
.43107 .53748 .43467 .53447 .43751 .52698 .43393 .52997 Mtetra
.927 .969 .686 r
.43393 .52997 .43751 .52698 .44026 .5221 .4367 .52506 Mtetra
0 0 0 r
.4367 .52506 .44026 .5221 .44293 .52011 .43937 .52307 Mtetra
.277 0 0 r
.43937 .52307 .44293 .52011 .44553 .52085 .44197 .52382 Mtetra
.498 .026 .064 r
.44197 .52382 .44553 .52085 .44808 .52367 .44452 .52667 Mtetra
.562 .101 .116 r
.44452 .52667 .44808 .52367 .45064 .52759 .44707 .53062 Mtetra
.555 .092 .11 r
.44707 .53062 .45064 .52759 .45322 .53141 .44964 .53446 Mtetra
.469 0 .041 r
.44964 .53446 .45322 .53141 .45585 .53392 .45227 .53699 Mtetra
.188 0 0 r
.45227 .53699 .45585 .53392 .45855 .53413 .45497 .53722 Mtetra
.538 .859 .571 r
.45497 .53722 .45855 .53413 .46132 .53148 .45774 .53455 Mtetra
.952 .951 .665 r
.45774 .53455 .46132 .53148 .46414 .5259 .46058 .52895 Mtetra
.99 .855 .61 r
.46058 .52895 .46414 .5259 .46699 .51789 .46345 .5209 Mtetra
.985 .805 .579 r
.46345 .5209 .46699 .51789 .46985 .50838 .46633 .51135 Mtetra
.983 .794 .572 r
.46633 .51135 .46985 .50838 .47271 .49855 .46921 .50147 Mtetra
.987 .818 .588 r
.46921 .50147 .47271 .49855 .47553 .4896 .47205 .49248 Mtetra
.987 .887 .631 r
.47205 .49248 .47553 .4896 .47832 .48257 .47486 .48542 Mtetra
.881 .978 .681 r
.47486 .48542 .47832 .48257 .48108 .47815 .47763 .48098 Mtetra
0 0 0 r
.47763 .48098 .48108 .47815 .48383 .47658 .48038 .47941 Mtetra
.32 0 0 r
.48038 .47941 .48383 .47658 .48657 .47766 .48313 .4805 Mtetra
.507 .027 .051 r
.48313 .4805 .48657 .47766 .48933 .48072 .48588 .48358 Mtetra
.562 .091 .094 r
.48588 .48358 .48933 .48072 .49211 .48474 .48865 .48764 Mtetra
.548 .075 .083 r
.48865 .48764 .49211 .48474 .49492 .48855 .49145 .49148 Mtetra
.454 0 .01 r
.49145 .49148 .49492 .48855 .49775 .49096 .49428 .4939 Mtetra
.156 0 0 r
.49428 .4939 .49775 .49096 .50059 .49102 .49713 .49397 Mtetra
.558 .87 .58 r
.49713 .49397 .50059 .49102 .50343 .48822 .49998 .49116 Mtetra
.951 .951 .655 r
.49998 .49116 .50343 .48822 .50626 .48255 .50282 .48548 Mtetra
.993 .86 .6 r
.50282 .48548 .50626 .48255 .50906 .47457 .50563 .47745 Mtetra
.99 .812 .57 r
.50563 .47745 .50906 .47457 .51183 .4652 .50842 .46804 Mtetra
.989 .805 .565 r
.50842 .46804 .51183 .4652 .51458 .45563 .5112 .45843 Mtetra
.992 .834 .584 r
.5112 .45843 .51458 .45563 .51733 .44705 .51396 .44981 Mtetra
.983 .909 .632 r
.51396 .44981 .51733 .44705 .52009 .44045 .51674 .44318 Mtetra
.813 .972 .667 r
.51674 .44318 .52009 .44045 .52289 .43647 .51955 .43918 Mtetra
0 0 0 r
.51955 .43918 .52289 .43647 .52575 .43531 .52242 .43803 Mtetra
.353 0 0 r
.52242 .43803 .52575 .43531 .52868 .43672 .52534 .43945 Mtetra
.514 .026 .034 r
.52534 .43945 .52868 .43672 .53167 .44 .52833 .44275 Mtetra
.559 .078 .07 r
.52833 .44275 .53167 .44 .53471 .44413 .53136 .44691 Mtetra
.54 .056 .055 r
.53136 .44691 .53471 .44413 .53777 .44792 .53442 .45074 Mtetra
.436 0 0 r
.53442 .45074 .53777 .44792 .54082 .45023 .53747 .45306 Mtetra
.124 0 0 r
.53747 .45306 .54082 .45023 .54382 .45014 .54047 .45298 Mtetra
.573 .878 .585 r
.54047 .45298 .54382 .45014 .54674 .44719 .5434 .45002 Mtetra
.948 .95 .643 r
.5434 .45002 .54674 .44719 .54957 .44143 .54624 .44424 Mtetra
.994 .865 .589 r
.54624 .44424 .54957 .44143 .55231 .43345 .549 .43622 Mtetra
.994 .82 .56 r
.549 .43622 .55231 .43345 .555 .42421 .55171 .42694 Mtetra
.994 .816 .557 r
.55171 .42694 .555 .42421 .55766 .41489 .55439 .41758 Mtetra
.995 .851 .58 r
.55439 .41758 .55766 .41489 .56035 .40666 .5571 .4093 Mtetra
.97 .93 .633 r
.5571 .4093 .56035 .40666 .56312 .40046 .55988 .40308 Mtetra
.722 .946 .642 r
.55988 .40308 .56312 .40046 .56599 .3969 .56277 .39951 Mtetra
0 0 0 r
.56277 .39951 .56599 .3969 .569 .39614 .56578 .39875 Mtetra
.38 0 0 r
.56578 .39875 .569 .39614 .57215 .39787 .56893 .40049 Mtetra
.518 .021 .015 r
.56893 .40049 .57215 .39787 .57542 .40137 .57219 .40402 Mtetra
.555 .064 .044 r
.57219 .40402 .57542 .40137 .57875 .4056 .57552 .40828 Mtetra
.53 .034 .024 r
.57552 .40828 .57875 .4056 .58209 .40938 .57885 .41209 Mtetra
.418 0 0 r
.57885 .41209 .58209 .40938 .58537 .41158 .58214 .41431 Mtetra
.093 0 0 r
.58214 .41431 .58537 .41158 .58854 .41134 .58531 .41408 Mtetra
.584 .882 .585 r
.58531 .41408 .58854 .41134 .59154 .40824 .58832 .41096 Mtetra
.944 .948 .628 r
.58832 .41096 .59154 .40824 .59438 .40238 .59118 .40508 Mtetra
.995 .869 .575 r
.59118 .40508 .59438 .40238 .59708 .39439 .59389 .39705 Mtetra
.998 .828 .547 r
.59389 .39705 .59708 .39439 .59968 .38526 .59651 .38788 Mtetra
.998 .827 .547 r
.59651 .38788 .59968 .38526 .60227 .37617 .59912 .37875 Mtetra
.995 .868 .575 r
.59912 .37875 .60227 .37617 .60493 .36827 .60179 .3708 Mtetra
.948 .947 .63 r
.60179 .3708 .60493 .36827 .60772 .36246 .6046 .36497 Mtetra
.612 .901 .608 r
.6046 .36497 .60772 .36246 .61071 .35931 .6076 .36181 Mtetra
.059 0 0 r
.6076 .36181 .61071 .35931 .61391 .35893 .61081 .36144 Mtetra
.4 0 0 r
.61081 .36144 .61391 .35893 .61733 .36097 .61422 .3635 Mtetra
.519 .013 0 r
.61422 .3635 .61733 .36097 .62091 .36469 .6178 .36724 Mtetra
.549 .047 .015 r
.6178 .36724 .62091 .36469 .62457 .36902 .62146 .37161 Mtetra
.518 .012 0 r
.62146 .37161 .62457 .36902 .62822 .37279 .62511 .37541 Mtetra
.397 0 0 r
.62511 .37541 .62822 .37279 .63177 .37489 .62866 .37752 Mtetra
.062 0 0 r
.62866 .37752 .63177 .37489 .63511 .37449 .63201 .37713 Mtetra
.59 .883 .582 r
.63201 .37713 .63511 .37449 .63821 .37123 .63512 .37386 Mtetra
.937 .945 .611 r
.63512 .37386 .63821 .37123 .64107 .36526 .63798 .36786 Mtetra
.994 .873 .559 r
.63798 .36786 .64107 .36526 .64371 .35725 .64065 .35982 Mtetra
.999 .835 .533 r
.64065 .35982 .64371 .35725 .64625 .34822 .6432 .35074 Mtetra
.999 .839 .536 r
.6432 .35074 .64625 .34822 .64878 .33934 .64575 .34182 Mtetra
.991 .884 .568 r
.64575 .34182 .64878 .33934 .65142 .33174 .64841 .33418 Mtetra
.912 .957 .624 r
.64841 .33418 .65142 .33174 .65427 .32631 .65128 .32873 Mtetra
.492 .839 .566 r
.65128 .32873 .65427 .32631 .65741 .32355 .65443 .32597 Mtetra
.126 0 0 r
.65443 .32597 .65741 .32355 .66086 .32355 .65788 .32597 Mtetra
.415 0 0 r
.65788 .32597 .66086 .32355 .66459 .3259 .66161 .32834 Mtetra
.519 .003 0 r
.66161 .32834 .66459 .3259 .66854 .32984 .66556 .33231 Mtetra
.542 .029 0 r
.66556 .33231 .66854 .32984 .67258 .33427 .6696 .33678 Mtetra
.504 0 0 r
.6696 .33678 .67258 .33427 .67659 .33803 .6736 .34057 Mtetra
.375 0 0 r
.6736 .34057 .67659 .33803 .68041 .34003 .67743 .34258 Mtetra
.032 0 0 r
.67743 .34258 .68041 .34003 .68396 .33947 .68098 .34202 Mtetra
.593 .881 .574 r
.68098 .34202 .68396 .33947 .68716 .33604 .6842 .33858 Mtetra
.928 .941 .592 r
.6842 .33858 .68716 .33604 .69003 .32995 .68708 .33246 Mtetra
.991 .876 .541 r
.68708 .33246 .69003 .32995 .69263 .3219 .6897 .32438 Mtetra
.998 .842 .516 r
.6897 .32438 .69263 .3219 .6951 .31295 .69219 .31538 Mtetra
.997 .849 .522 r
.69219 .31538 .6951 .31295 .69759 .30426 .69469 .30665 Mtetra
.98 .899 .559 r
.69469 .30665 .69759 .30426 .70024 .29696 .69736 .29932 Mtetra
.858 .956 .612 r
.69736 .29932 .70024 .29696 .7032 .29189 .70033 .29422 Mtetra
0 0 0 r
.70033 .29422 .7032 .29189 .70654 .28952 .70368 .29185 Mtetra
.179 0 0 r
.70368 .29185 .70654 .28952 .71028 .28989 .70743 .29223 Mtetra
.425 0 0 r
.70743 .29223 .71028 .28989 .71439 .29256 .71155 .29492 Mtetra
.515 0 0 r
.71155 .29492 .71439 .29256 .71876 .29671 .71592 .2991 Mtetra
.532 .008 0 r
.71592 .2991 .71876 .29671 .72324 .30125 .72039 .30368 Mtetra
.489 0 0 r
.72039 .30368 .72324 .30125 .72764 .305 .72479 .30746 Mtetra
.352 0 0 r
.72479 .30746 .72764 .305 .73178 .30689 .72895 .30937 Mtetra
.005 0 0 r
.72895 .30937 .73178 .30689 .73555 .30617 .73272 .30865 Mtetra
.923 .839 .744 r
.29131 .73538 .29513 .73425 .29797 .72891 .29416 .73003 Mtetra
.916 .739 .648 r
.29416 .73003 .29797 .72891 .30111 .72067 .29731 .72176 Mtetra
.907 .698 .609 r
.29731 .72176 .30111 .72067 .30443 .71035 .30065 .71142 Mtetra
.903 .684 .596 r
.30065 .71142 .30443 .71035 .30783 .69917 .30407 .70021 Mtetra
.905 .689 .601 r
.30407 .70021 .30783 .69917 .31116 .68845 .30743 .68946 Mtetra
.911 .717 .627 r
.30743 .68946 .31116 .68845 .31432 .6794 .3106 .68039 Mtetra
.921 .785 .694 r
.3106 .68039 .31432 .6794 .31723 .67294 .31352 .67392 Mtetra
.88 .939 .851 r
.31352 .67392 .31723 .67294 .31984 .66954 .31614 .67051 Mtetra
0 0 0 r
.31614 .67051 .31984 .66954 .32219 .66915 .31848 .67011 Mtetra
.519 0 0 r
.31848 .67011 .32219 .66915 .32432 .67123 .3206 .67221 Mtetra
.635 .153 .091 r
.3206 .67221 .32432 .67123 .32633 .67482 .3226 .67581 Mtetra
.647 .171 .108 r
.3226 .67581 .32633 .67482 .32833 .6787 .3246 .6797 Mtetra
.584 .081 .025 r
.3246 .6797 .32833 .6787 .33045 .68154 .3267 .68255 Mtetra
.274 0 0 r
.3267 .68255 .33045 .68154 .33276 .68222 .32902 .68323 Mtetra
.732 .984 .903 r
.32902 .68323 .33276 .68222 .33534 .67997 .33159 .68098 Mtetra
.925 .839 .741 r
.33159 .68098 .33534 .67997 .33818 .67458 .33444 .67558 Mtetra
.92 .742 .645 r
.33444 .67558 .33818 .67458 .34124 .6664 .33752 .66738 Mtetra
.912 .702 .605 r
.33752 .66738 .34124 .6664 .34444 .65631 .34074 .65726 Mtetra
.909 .689 .593 r
.34074 .65726 .34444 .65631 .34769 .64549 .34401 .64641 Mtetra
.911 .697 .601 r
.34401 .64641 .34769 .64549 .35087 .63524 .34721 .63614 Mtetra
.917 .729 .633 r
.34721 .63614 .35087 .63524 .35391 .62674 .35026 .62761 Mtetra
.925 .808 .712 r
.35026 .62761 .35391 .62674 .35674 .62083 .35311 .62169 Mtetra
.837 .968 .886 r
.35311 .62169 .35674 .62083 .35935 .61792 .35572 .61878 Mtetra
.066 0 0 r
.35572 .61878 .35935 .61792 .36175 .61793 .35811 .61879 Mtetra
.54 .014 0 r
.35811 .61879 .36175 .61793 .36399 .62028 .36035 .62115 Mtetra
.637 .147 .072 r
.36035 .62115 .36399 .62028 .36616 .624 .3625 .62488 Mtetra
.643 .155 .08 r
.3625 .62488 .36616 .624 .36833 .62787 .36467 .62876 Mtetra
.57 .053 0 r
.36467 .62876 .36833 .62787 .37061 .63061 .36693 .63151 Mtetra
.225 0 0 r
.36693 .63151 .37061 .63061 .37305 .63114 .36937 .63204 Mtetra
.751 .984 .906 r
.36937 .63204 .37305 .63114 .37568 .62875 .37201 .62965 Mtetra
.928 .839 .737 r
.37201 .62965 .37568 .62875 .37852 .62329 .37485 .62418 Mtetra
.924 .745 .641 r
.37485 .62418 .37852 .62329 .38151 .61517 .37786 .61604 Mtetra
.917 .706 .602 r
.37786 .61604 .38151 .61517 .3846 .60528 .38097 .60611 Mtetra
.914 .695 .591 r
.38097 .60611 .3846 .60528 .38771 .5948 .3841 .59561 Mtetra
.917 .705 .602 r
.3841 .59561 .38771 .5948 .39077 .585 .38717 .58578 Mtetra
.924 .743 .64 r
.38717 .58578 .39077 .585 .3937 .57701 .39012 .57777 Mtetra
.926 .835 .735 r
.39012 .57777 .3937 .57701 .39649 .57161 .39292 .57236 Mtetra
.767 .981 .911 r
.39292 .57236 .39649 .57161 .39911 .56918 .39554 .56992 Mtetra
.18 0 0 r
.39554 .56992 .39911 .56918 .40159 .56956 .39802 .57031 Mtetra
.556 .027 0 r
.39802 .57031 .40159 .56956 .40398 .57217 .4004 .57292 Mtetra
.637 .139 .05 r
.4004 .57292 .40398 .57217 .40632 .57601 .40273 .57678 Mtetra
.636 .138 .049 r
.40273 .57678 .40632 .57601 .40869 .57986 .40509 .58065 Mtetra
.553 .023 0 r
.40509 .58065 .40869 .57986 .41113 .5825 .40752 .58329 Mtetra
.173 0 0 r
.40752 .58329 .41113 .5825 .4137 .58287 .41008 .58367 Mtetra
.767 .984 .906 r
.41008 .58367 .4137 .58287 .4164 .58035 .41279 .58114 Mtetra
.931 .841 .733 r
.41279 .58114 .4164 .58035 .41923 .57482 .41563 .5756 Mtetra
.929 .749 .637 r
.41563 .5756 .41923 .57482 .42217 .56675 .41858 .5675 Mtetra
.923 .711 .599 r
.41858 .5675 .42217 .56675 .42515 .55703 .42158 .55776 Mtetra
.921 .701 .589 r
.42158 .55776 .42515 .55703 .42813 .54686 .42459 .54757 Mtetra
.923 .715 .603 r
.42459 .54757 .42813 .54686 .43107 .53748 .42754 .53816 Mtetra
.93 .76 .649 r
.42754 .53816 .43107 .53748 .43393 .52997 .43042 .53063 Mtetra
.925 .864 .761 r
.43042 .53063 .43393 .52997 .4367 .52506 .43319 .52571 Mtetra
.661 .967 .917 r
.43319 .52571 .4367 .52506 .43937 .52307 .43586 .52372 Mtetra
.264 0 0 r
.43586 .52372 .43937 .52307 .44197 .52382 .43846 .52447 Mtetra
.567 .034 0 r
.43846 .52447 .44197 .52382 .44452 .52667 .441 .52732 Mtetra
.635 .128 .025 r
.441 .52732 .44452 .52667 .44707 .53062 .44354 .53128 Mtetra
.628 .118 .015 r
.44354 .53128 .44707 .53062 .44964 .53446 .4461 .53514 Mtetra
.533 0 0 r
.4461 .53514 .44964 .53446 .45227 .53699 .44872 .53768 Mtetra
.12 0 0 r
.44872 .53768 .45227 .53699 .45497 .53722 .45142 .53791 Mtetra
.78 .983 .904 r
.45142 .53791 .45497 .53722 .45774 .53455 .45419 .53524 Mtetra
.935 .843 .729 r
.45419 .53524 .45774 .53455 .46058 .52895 .45704 .52962 Mtetra
.934 .753 .633 r
.45704 .52962 .46058 .52895 .46345 .5209 .45993 .52155 Mtetra
.929 .716 .595 r
.45993 .52155 .46345 .5209 .46633 .51135 .46283 .51198 Mtetra
.927 .709 .587 r
.46283 .51198 .46633 .51135 .46921 .50147 .46572 .50207 Mtetra
.93 .726 .605 r
.46572 .50207 .46921 .50147 .47205 .49248 .46858 .49306 Mtetra
.936 .778 .661 r
.46858 .49306 .47205 .49248 .47486 .48542 .4714 .48598 Mtetra
.917 .896 .792 r
.4714 .48598 .47486 .48542 .47763 .48098 .47418 .48153 Mtetra
.525 .918 .896 r
.47418 .48153 .47763 .48098 .48038 .47941 .47693 .47996 Mtetra
.326 0 0 r
.47693 .47996 .48038 .47941 .48313 .4805 .47967 .48106 Mtetra
.573 .035 0 r
.47967 .48106 .48313 .4805 .48588 .48358 .48241 .48415 Mtetra
.631 .114 0 r
.48241 .48415 .48588 .48358 .48865 .48764 .48518 .48822 Mtetra
.618 .095 0 r
.48518 .48822 .48865 .48764 .49145 .49148 .48797 .49206 Mtetra
.51 0 0 r
.48797 .49206 .49145 .49148 .49428 .4939 .49079 .4945 Mtetra
.066 0 0 r
.49079 .4945 .49428 .4939 .49713 .49397 .49363 .49457 Mtetra
.791 .982 .902 r
.49363 .49457 .49713 .49397 .49998 .49116 .49649 .49175 Mtetra
.939 .846 .725 r
.49649 .49175 .49998 .49116 .50282 .48548 .49934 .48605 Mtetra
.94 .758 .629 r
.49934 .48605 .50282 .48548 .50563 .47745 .50217 .47801 Mtetra
.935 .722 .591 r
.50217 .47801 .50563 .47745 .50842 .46804 .50498 .46857 Mtetra
.934 .717 .585 r
.50498 .46857 .50842 .46804 .5112 .45843 .50777 .45894 Mtetra
.938 .738 .608 r
.50777 .45894 .5112 .45843 .51396 .44981 .51055 .45029 Mtetra
.942 .8 .675 r
.51055 .45029 .51396 .44981 .51674 .44318 .51334 .44364 Mtetra
.9 .928 .826 r
.51334 .44364 .51674 .44318 .51955 .43918 .51616 .43964 Mtetra
.372 .84 .849 r
.51616 .43964 .51955 .43918 .52242 .43803 .51902 .43848 Mtetra
.371 0 0 r
.51902 .43848 .52242 .43803 .52534 .43945 .52194 .43991 Mtetra
.577 .033 0 r
.52194 .43991 .52534 .43945 .52833 .44275 .52492 .44322 Mtetra
.625 .098 0 r
.52492 .44322 .52833 .44275 .53136 .44691 .52794 .4474 Mtetra
.605 .071 0 r
.52794 .4474 .53136 .44691 .53442 .45074 .53099 .45123 Mtetra
.484 0 0 r
.53099 .45123 .53442 .45074 .53747 .45306 .53403 .45356 Mtetra
.012 0 0 r
.53403 .45356 .53747 .45306 .54047 .45298 .53703 .45348 Mtetra
.8 .981 .898 r
.53703 .45348 .54047 .45298 .5434 .45002 .53996 .45051 Mtetra
.943 .85 .72 r
.53996 .45051 .5434 .45002 .54624 .44424 .54282 .44472 Mtetra
.946 .764 .624 r
.54282 .44472 .54624 .44424 .549 .43622 .54559 .43668 Mtetra
.942 .729 .586 r
.54559 .43668 .549 .43622 .55171 .42694 .54832 .42737 Mtetra
.941 .726 .583 r
.54832 .42737 .55171 .42694 .55439 .41758 .55102 .41799 Mtetra
.945 .753 .612 r
.55102 .41799 .55439 .41758 .5571 .4093 .55374 .40969 Mtetra
.946 .824 .692 r
.55374 .40969 .5571 .4093 .55988 .40308 .55653 .40345 Mtetra
.869 .956 .862 r
.55653 .40345 .55988 .40308 .56277 .39951 .55942 .39987 Mtetra
.223 .744 .788 r
.55942 .39987 .56277 .39951 .56578 .39875 .56244 .39911 Mtetra
.404 0 0 r
.56244 .39911 .56578 .39875 .56893 .40049 .56558 .40086 Mtetra
.577 .026 0 r
.56558 .40086 .56893 .40049 .57219 .40402 .56883 .4044 Mtetra
.617 .08 0 r
.56883 .4044 .57219 .40402 .57552 .40828 .57215 .40868 Mtetra
.59 .044 0 r
.57215 .40868 .57552 .40828 .57885 .41209 .57548 .4125 Mtetra
.455 0 0 r
.57548 .4125 .57885 .41209 .58214 .41431 .57875 .41473 Mtetra
0 0 0 r
.57875 .41473 .58214 .41431 .58531 .41408 .58192 .41449 Mtetra
.808 .981 .894 r
.58192 .41449 .58531 .41408 .58832 .41096 .58494 .41137 Mtetra
.948 .855 .715 r
.58494 .41137 .58832 .41096 .59118 .40508 .58781 .40547 Mtetra
.953 .77 .619 r
.58781 .40547 .59118 .40508 .59389 .39705 .59053 .39742 Mtetra
.949 .736 .581 r
.59053 .39742 .59389 .39705 .59651 .38788 .59318 .38823 Mtetra
.59318 .38823 .59651 .38788 .59912 .37875 .5958 .37907 Mtetra
.952 .769 .617 r
.5958 .37907 .59912 .37875 .60179 .3708 .59849 .37111 Mtetra
.948 .851 .713 r
.59849 .37111 .60179 .3708 .6046 .36497 .6013 .36526 Mtetra
.818 .976 .894 r
.6013 .36526 .6046 .36497 .6076 .36181 .60431 .36209 Mtetra
.092 .649 .724 r
.60431 .36209 .6076 .36181 .61081 .36144 .60752 .36172 Mtetra
.427 0 0 r
.60752 .36172 .61081 .36144 .61422 .3635 .61093 .36378 Mtetra
.573 .016 0 r
.61093 .36378 .61422 .3635 .6178 .36724 .61449 .36754 Mtetra
.606 .059 0 r
.61449 .36754 .6178 .36724 .62146 .37161 .61814 .37192 Mtetra
.572 .014 0 r
.61814 .37192 .62146 .37161 .62511 .37541 .62179 .37573 Mtetra
.423 0 0 r
.62179 .37573 .62511 .37541 .62866 .37752 .62533 .37785 Mtetra
.088 .646 .715 r
.62533 .37785 .62866 .37752 .63201 .37713 .62868 .37746 Mtetra
.815 .981 .89 r
.62868 .37746 .63201 .37713 .63512 .37386 .63179 .37417 Mtetra
.953 .86 .71 r
.63179 .37417 .63512 .37386 .63798 .36786 .63467 .36817 Mtetra
.96 .777 .613 r
.63467 .36817 .63798 .36786 .64065 .35982 .63735 .3601 Mtetra
.957 .745 .576 r
.63735 .3601 .64065 .35982 .6432 .35074 .63992 .351 Mtetra
.957 .748 .579 r
.63992 .351 .6432 .35074 .64575 .34182 .64248 .34205 Mtetra
.96 .787 .625 r
.64248 .34205 .64575 .34182 .64841 .33418 .64515 .3344 Mtetra
.946 .88 .738 r
.64515 .3344 .64841 .33418 .65128 .32873 .64803 .32893 Mtetra
.743 .979 .918 r
.64803 .32893 .65128 .32873 .65443 .32597 .65118 .32616 Mtetra
.015 0 0 r
.65118 .32616 .65443 .32597 .65788 .32597 .65464 .32616 Mtetra
.441 0 0 r
.65464 .32616 .65788 .32597 .66161 .32834 .65837 .32855 Mtetra
.567 .003 0 r
.65837 .32855 .66161 .32834 .66556 .33231 .6623 .33252 Mtetra
.592 .035 0 r
.6623 .33252 .66556 .33231 .6696 .33678 .66633 .337 Mtetra
.551 0 0 r
.66633 .337 .6696 .33678 .6736 .34057 .67033 .3408 Mtetra
.389 0 0 r
.67033 .3408 .6736 .34057 .67743 .34258 .67416 .34282 Mtetra
.133 .681 .752 r
.67416 .34282 .67743 .34258 .68098 .34202 .67771 .34226 Mtetra
.821 .983 .885 r
.67771 .34226 .68098 .34202 .6842 .33858 .68093 .33881 Mtetra
.959 .867 .704 r
.68093 .33881 .6842 .33858 .68708 .33246 .68382 .33268 Mtetra
.967 .785 .606 r
.68382 .33268 .68708 .33246 .6897 .32438 .68646 .32458 Mtetra
.964 .754 .57 r
.68646 .32458 .6897 .32438 .69219 .31538 .68896 .31555 Mtetra
.965 .761 .578 r
.68896 .31555 .69219 .31538 .69469 .30665 .69148 .3068 Mtetra
.966 .808 .634 r
.69148 .3068 .69469 .30665 .69736 .29932 .69416 .29944 Mtetra
.938 .911 .767 r
.69416 .29944 .69736 .29932 .70033 .29422 .69714 .29434 Mtetra
.643 .959 .926 r
.69714 .29434 .70033 .29422 .70368 .29185 .70049 .29196 Mtetra
.097 0 0 r
.70049 .29196 .70368 .29185 .70743 .29223 .70424 .29234 Mtetra
.449 0 0 r
.70424 .29234 .70743 .29223 .71155 .29492 .70835 .29503 Mtetra
.557 0 0 r
.70835 .29503 .71155 .29492 .71592 .2991 .71271 .29923 Mtetra
.576 .009 0 r
.71271 .29923 .71592 .2991 .72039 .30368 .71718 .30382 Mtetra
.527 0 0 r
.71718 .30382 .72039 .30368 .72479 .30746 .72158 .30761 Mtetra
.353 0 0 r
.72158 .30761 .72479 .30746 .72895 .30937 .72573 .30953 Mtetra
.174 .71 .783 r
.72573 .30953 .72895 .30937 .73272 .30865 .7295 .3088 Mtetra
.794 .647 .7 r
.2878 .73335 .29131 .73538 .29416 .73003 .29066 .728 Mtetra
.821 .617 .627 r
.29066 .728 .29416 .73003 .29731 .72176 .29381 .71973 Mtetra
.829 .603 .596 r
.29381 .71973 .29731 .72176 .30065 .71142 .29717 .70939 Mtetra
.832 .598 .585 r
.29717 .70939 .30065 .71142 .30407 .70021 .30061 .69818 Mtetra
.831 .6 .589 r
.30061 .69818 .30407 .70021 .30743 .68946 .30398 .68743 Mtetra
.825 .61 .611 r
.30398 .68743 .30743 .68946 .3106 .68039 .30716 .67836 Mtetra
.809 .632 .662 r
.30716 .67836 .3106 .68039 .31352 .67392 .31009 .67188 Mtetra
.744 .674 .783 r
.31009 .67188 .31352 .67392 .31614 .67051 .31271 .66847 Mtetra
.309 .618 .957 r
.31271 .66847 .31614 .67051 .31848 .67011 .31504 .66807 Mtetra
.564 0 0 r
.31504 .66807 .31848 .67011 .3206 .67221 .31716 .67016 Mtetra
.734 .209 0 r
.31716 .67016 .3206 .67221 .3226 .67581 .31914 .67376 Mtetra
.748 .231 0 r
.31914 .67376 .3226 .67581 .3246 .6797 .32113 .67764 Mtetra
.668 .116 0 r
.32113 .67764 .3246 .6797 .3267 .68255 .32322 .68049 Mtetra
0 .389 .8 r
.32322 .68049 .3267 .68255 .32902 .68323 .32552 .68116 Mtetra
.665 .692 .866 r
.32552 .68116 .32902 .68323 .33159 .68098 .3281 .67891 Mtetra
.796 .647 .697 r
.3281 .67891 .33159 .68098 .33444 .67558 .33095 .6735 Mtetra
.823 .618 .625 r
.33095 .6735 .33444 .67558 .33752 .66738 .33404 .6653 Mtetra
.832 .604 .593 r
.33404 .6653 .33752 .66738 .34074 .65726 .33727 .65518 Mtetra
.834 .599 .583 r
.33727 .65518 .34074 .65726 .34401 .64641 .34056 .64433 Mtetra
.833 .602 .59 r
.34056 .64433 .34401 .64641 .34721 .63614 .34377 .63406 Mtetra
.826 .613 .615 r
.34377 .63406 .34721 .63614 .35026 .62761 .34684 .62553 Mtetra
.804 .638 .676 r
.34684 .62553 .35026 .62761 .35311 .62169 .34968 .61961 Mtetra
.715 .682 .816 r
.34968 .61961 .35311 .62169 .35572 .61878 .35229 .61669 Mtetra
.161 .548 .928 r
.35229 .61669 .35572 .61878 .35811 .61879 .35468 .6167 Mtetra
.588 .021 0 r
.35468 .6167 .35811 .61879 .36035 .62115 .35691 .61905 Mtetra
.728 .199 0 r
.35691 .61905 .36035 .62115 .3625 .62488 .35905 .62278 Mtetra
.734 .209 0 r
.35905 .62278 .3625 .62488 .36467 .62876 .3612 .62665 Mtetra
.635 .076 0 r
.3612 .62665 .36467 .62876 .36693 .63151 .36346 .62939 Mtetra
0 .435 .845 r
.36346 .62939 .36693 .63151 .36937 .63204 .36588 .62992 Mtetra
.672 .69 .859 r
.36588 .62992 .36937 .63204 .37201 .62965 .36852 .62752 Mtetra
.798 .647 .695 r
.36852 .62752 .37201 .62965 .37485 .62418 .37137 .62205 Mtetra
.826 .618 .622 r
.37137 .62205 .37485 .62418 .37786 .61604 .37439 .61391 Mtetra
.834 .605 .591 r
.37439 .61391 .37786 .61604 .38097 .60611 .37751 .60398 Mtetra
.837 .601 .582 r
.37751 .60398 .38097 .60611 .3841 .59561 .38066 .59348 Mtetra
.835 .605 .59 r
.38066 .59348 .3841 .59561 .38717 .58578 .38374 .58365 Mtetra
.826 .618 .621 r
.38374 .58365 .38717 .58578 .39012 .57777 .3867 .57564 Mtetra
.798 .646 .693 r
.3867 .57564 .39012 .57777 .39292 .57236 .3895 .57023 Mtetra
.677 .687 .852 r
.3895 .57023 .39292 .57236 .39554 .56992 .39212 .56778 Mtetra
.02 .467 .874 r
.39212 .56778 .39554 .56992 .39802 .57031 .3946 .56817 Mtetra
.601 .038 0 r
.3946 .56817 .39802 .57031 .4004 .57292 .39696 .57078 Mtetra
.718 .185 0 r
.39696 .57078 .4004 .57292 .40273 .57678 .39928 .57462 Mtetra
.717 .183 0 r
.39928 .57462 .40273 .57678 .40509 .58065 .40162 .57848 Mtetra
.596 .032 0 r
.40162 .57848 .40509 .58065 .40752 .58329 .40404 .58112 Mtetra
.029 .473 .879 r
.40404 .58112 .40752 .58329 .41008 .58367 .4066 .58149 Mtetra
.679 .689 .852 r
.4066 .58149 .41008 .58367 .41279 .58114 .4093 .57896 Mtetra
.801 .648 .692 r
.4093 .57896 .41279 .58114 .41563 .5756 .41215 .57342 Mtetra
.828 .619 .62 r
.41215 .57342 .41563 .5756 .41858 .5675 .41511 .56532 Mtetra
.837 .606 .588 r
.41511 .56532 .41858 .5675 .42158 .55776 .41812 .55558 Mtetra
.839 .602 .58 r
.41812 .55558 .42158 .55776 .42459 .54757 .42114 .54538 Mtetra
.836 .607 .592 r
.42114 .54538 .42459 .54757 .42754 .53816 .42411 .53598 Mtetra
.825 .623 .629 r
.42411 .53598 .42754 .53816 .43042 .53063 .42699 .52844 Mtetra
.789 .654 .713 r
.42699 .52844 .43042 .53063 .43319 .52571 .42977 .52352 Mtetra
.624 .687 .888 r
.42977 .52352 .43319 .52571 .43586 .52372 .43244 .52152 Mtetra
0 .388 .811 r
.43244 .52152 .43586 .52372 .43846 .52447 .43502 .52227 Mtetra
.607 .046 0 r
.43502 .52227 .43846 .52447 .441 .52732 .43756 .52512 Mtetra
.706 .168 0 r
.43756 .52512 .441 .52732 .44354 .53128 .44008 .52907 Mtetra
.697 .155 0 r
.44008 .52907 .44354 .53128 .4461 .53514 .44263 .53292 Mtetra
.553 0 0 r
.44263 .53292 .4461 .53514 .44872 .53768 .44523 .53546 Mtetra
.092 .505 .903 r
.44523 .53546 .44872 .53768 .45142 .53791 .44793 .53568 Mtetra
.685 .688 .847 r
.44793 .53568 .45142 .53791 .45419 .53524 .4507 .533 Mtetra
.803 .648 .69 r
.4507 .533 .45419 .53524 .45704 .52962 .45355 .52738 Mtetra
.831 .62 .617 r
.45355 .52738 .45704 .52962 .45993 .52155 .45645 .51932 Mtetra
.84 .607 .586 r
.45645 .51932 .45993 .52155 .46283 .51198 .45936 .50974 Mtetra
.842 .604 .579 r
.45936 .50974 .46283 .51198 .46572 .50207 .46227 .49983 Mtetra
.838 .61 .594 r
.46227 .49983 .46572 .50207 .46858 .49306 .46514 .49082 Mtetra
.824 .628 .638 r
.46514 .49082 .46858 .49306 .4714 .48598 .46797 .48374 Mtetra
.777 .663 .737 r
.46797 .48374 .4714 .48598 .47418 .48153 .47075 .47928 Mtetra
.556 .678 .92 r
.47075 .47928 .47418 .48153 .47693 .47996 .4735 .47771 Mtetra
0 .319 .751 r
.4735 .47771 .47693 .47996 .47967 .48106 .47623 .4788 Mtetra
.607 .047 0 r
.47623 .4788 .47967 .48106 .48241 .48415 .47896 .48188 Mtetra
.691 .148 0 r
.47896 .48188 .48241 .48415 .48518 .48822 .48171 .48594 Mtetra
.672 .124 0 r
.48171 .48594 .48518 .48822 .48797 .49206 .48448 .48978 Mtetra
.504 0 0 r
.48448 .48978 .48797 .49206 .49079 .4945 .48729 .49221 Mtetra
.147 .531 .92 r
.48729 .49221 .49079 .4945 .49363 .49457 .49013 .49228 Mtetra
.691 .687 .842 r
.49013 .49228 .49363 .49457 .49649 .49175 .49298 .48946 Mtetra
.806 .649 .688 r
.49298 .48946 .49649 .49175 .49934 .48605 .49583 .48375 Mtetra
.835 .621 .614 r
.49583 .48375 .49934 .48605 .50217 .47801 .49868 .47571 Mtetra
.843 .608 .583 r
.49868 .47571 .50217 .47801 .50498 .46857 .5015 .46627 Mtetra
.844 .606 .578 r
.5015 .46627 .50498 .46857 .50777 .45894 .5043 .45664 Mtetra
.839 .614 .597 r
.5043 .45664 .50777 .45894 .51055 .45029 .50709 .44799 Mtetra
.822 .635 .65 r
.50709 .44799 .51055 .45029 .51334 .44364 .50989 .44134 Mtetra
.76 .671 .764 r
.50989 .44134 .51334 .44364 .51616 .43964 .51271 .43733 Mtetra
.471 .657 .942 r
.51271 .43733 .51616 .43964 .51902 .43848 .51557 .43617 Mtetra
0 .264 .7 r
.51557 .43617 .51902 .43848 .52194 .43991 .51848 .43759 Mtetra
.601 .043 0 r
.51848 .43759 .52194 .43991 .52492 .44322 .52145 .4409 Mtetra
.672 .126 0 r
.52145 .4409 .52492 .44322 .52794 .4474 .52445 .44506 Mtetra
.643 .091 0 r
.52445 .44506 .52794 .4474 .53099 .45123 .52749 .44889 Mtetra
.452 0 0 r
.52749 .44889 .53099 .45123 .53403 .45356 .53051 .45121 Mtetra
.195 .552 .932 r
.53051 .45121 .53403 .45356 .53703 .45348 .5335 .45112 Mtetra
.696 .687 .837 r
.5335 .45112 .53703 .45348 .53996 .45051 .53644 .44815 Mtetra
.809 .65 .685 r
.53644 .44815 .53996 .45051 .54282 .44472 .5393 .44236 Mtetra
.838 .622 .611 r
.5393 .44236 .54282 .44472 .54559 .43668 .54208 .43432 Mtetra
.847 .61 .58 r
.54208 .43432 .54559 .43668 .54832 .42737 .54482 .42501 Mtetra
.847 .609 .577 r
.54482 .42501 .54832 .42737 .55102 .41799 .54753 .41562 Mtetra
.841 .618 .601 r
.54753 .41562 .55102 .41799 .55374 .40969 .55027 .40733 Mtetra
.818 .642 .664 r
.55027 .40733 .55374 .40969 .55653 .40345 .55306 .40109 Mtetra
.736 .679 .795 r
.55306 .40109 .55653 .40345 .55942 .39987 .55595 .3975 Mtetra
.375 .624 .95 r
.55595 .3975 .55942 .39987 .56244 .39911 .55896 .39674 Mtetra
0 .222 .662 r
.55896 .39674 .56244 .39911 .56558 .40086 .5621 .39848 Mtetra
.591 .034 0 r
.5621 .39848 .56558 .40086 .56883 .4044 .56533 .40201 Mtetra
.65 .1 0 r
.56533 .40201 .56883 .4044 .57215 .40868 .56863 .40627 Mtetra
.611 .055 0 r
.56863 .40627 .57215 .40868 .57548 .4125 .57195 .41008 Mtetra
0 .153 .586 r
.57195 .41008 .57548 .4125 .57875 .41473 .57521 .4123 Mtetra
.237 .569 .939 r
.57521 .4123 .57875 .41473 .58192 .41449 .57837 .41206 Mtetra
.701 .687 .833 r
.57837 .41206 .58192 .41449 .58494 .41137 .58139 .40893 Mtetra
.813 .651 .683 r
.58139 .40893 .58494 .41137 .58781 .40547 .58426 .40304 Mtetra
.841 .624 .608 r
.58426 .40304 .58781 .40547 .59053 .39742 .587 .39499 Mtetra
.85 .612 .577 r
.587 .39499 .59053 .39742 .59318 .38823 .58965 .38579 Mtetra
.85 .611 .577 r
.58965 .38579 .59318 .38823 .5958 .37907 .59229 .37664 Mtetra
.842 .623 .607 r
.59229 .37664 .5958 .37907 .59849 .37111 .59499 .36867 Mtetra
.813 .65 .681 r
.59499 .36867 .59849 .37111 .6013 .36526 .59781 .36282 Mtetra
.705 .684 .828 r
.59781 .36282 .6013 .36526 .60431 .36209 .60081 .35965 Mtetra
.273 .581 .943 r
.60081 .35965 .60431 .36209 .60752 .36172 .60401 .35927 Mtetra
0 .193 .636 r
.60401 .35927 .60752 .36172 .61093 .36378 .60741 .36133 Mtetra
.576 .021 0 r
.60741 .36133 .61093 .36378 .61449 .36754 .61096 .36507 Mtetra
.625 .073 0 r
.61096 .36507 .61449 .36754 .61814 .37192 .6146 .36944 Mtetra
.574 .018 0 r
.6146 .36944 .61814 .37192 .62179 .37573 .61822 .37324 Mtetra
0 .197 .639 r
.61822 .37324 .62179 .37573 .62533 .37785 .62175 .37535 Mtetra
.273 .583 .944 r
.62175 .37535 .62533 .37785 .62868 .37746 .62509 .37495 Mtetra
.706 .688 .83 r
.62509 .37495 .62868 .37746 .63179 .37417 .62821 .37166 Mtetra
.816 .653 .681 r
.62821 .37166 .63179 .37417 .63467 .36817 .63109 .36565 Mtetra
.845 .626 .605 r
.63109 .36565 .63467 .36817 .63735 .3601 .63378 .35759 Mtetra
.854 .614 .575 r
.63378 .35759 .63735 .3601 .63992 .351 .63636 .34848 Mtetra
.853 .615 .578 r
.63636 .34848 .63992 .351 .64248 .34205 .63894 .33954 Mtetra
.842 .629 .614 r
.63894 .33954 .64248 .34205 .64515 .3344 .64162 .33188 Mtetra
.805 .659 .701 r
.64162 .33188 .64515 .3344 .64803 .32893 .6445 .32641 Mtetra
.663 .686 .862 r
.6445 .32641 .64803 .32893 .65118 .32616 .64765 .32364 Mtetra
.175 .532 .923 r
.64765 .32364 .65118 .32616 .65464 .32616 .6511 .32363 Mtetra
0 .175 .62 r
.6511 .32363 .65464 .32616 .65837 .32855 .65481 .32601 Mtetra
.558 .004 0 r
.65481 .32601 .65837 .32855 .6623 .33252 .65873 .32997 Mtetra
.595 .043 0 r
.65873 .32997 .6623 .33252 .66633 .337 .66274 .33444 Mtetra
.534 0 0 r
.66274 .33444 .66633 .337 .67033 .3408 .66672 .33823 Mtetra
0 .239 .687 r
.66672 .33823 .67033 .3408 .67416 .34282 .67054 .34024 Mtetra
.304 .594 .946 r
.67054 .34024 .67416 .34282 .67771 .34226 .67408 .33968 Mtetra
.71 .689 .827 r
.67408 .33968 .67771 .34226 .68093 .33881 .6773 .33622 Mtetra
.82 .655 .678 r
.6773 .33622 .68093 .33881 .68382 .33268 .6802 .33008 Mtetra
.85 .628 .601 r
.6802 .33008 .68382 .33268 .68646 .32458 .68285 .32198 Mtetra
.858 .616 .572 r
.68285 .32198 .68646 .32458 .68896 .31555 .68536 .31296 Mtetra
.856 .619 .579 r
.68536 .31296 .68896 .31555 .69148 .3068 .68789 .30421 Mtetra
.842 .636 .624 r
.68789 .30421 .69148 .3068 .69416 .29944 .69058 .29685 Mtetra
.794 .668 .725 r
.69058 .29685 .69416 .29944 .69714 .29434 .69356 .29174 Mtetra
.61 .682 .893 r
.69356 .29174 .69714 .29434 .70049 .29196 .69691 .28935 Mtetra
.089 .483 .896 r
.69691 .28935 .70049 .29196 .70424 .29234 .70066 .28972 Mtetra
0 .165 .614 r
.70066 .28972 .70424 .29234 .70835 .29503 .70475 .29241 Mtetra
.535 0 0 r
.70475 .29241 .70835 .29503 .71271 .29923 .7091 .29659 Mtetra
.563 .011 0 r
.7091 .29659 .71271 .29923 .71718 .30382 .71355 .30117 Mtetra
.49 0 0 r
.71355 .30117 .71718 .30382 .72158 .30761 .71792 .30495 Mtetra
0 .278 .729 r
.71792 .30495 .72158 .30761 .72573 .30953 .72206 .30685 Mtetra
.331 .603 .947 r
.72206 .30685 .72573 .30953 .7295 .3088 .72583 .30612 Mtetra
.678 .501 .639 r
.28463 .72817 .2878 .73335 .29066 .728 .28749 .72283 Mtetra
.735 .517 .597 r
.28749 .72283 .29066 .728 .29381 .71973 .29065 .71457 Mtetra
.758 .522 .576 r
.29065 .71457 .29381 .71973 .29717 .70939 .29401 .70426 Mtetra
.765 .524 .569 r
.29401 .70426 .29717 .70939 .30061 .69818 .29745 .69307 Mtetra
.762 .523 .572 r
.29745 .69307 .30061 .69818 .30398 .68743 .30083 .68235 Mtetra
.747 .52 .586 r
.30083 .68235 .30398 .68743 .30716 .67836 .30403 .6733 Mtetra
.708 .51 .619 r
.30403 .6733 .30716 .67836 .31009 .67188 .30695 .66684 Mtetra
.608 .479 .679 r
.30695 .66684 .31009 .67188 .31271 .66847 .30957 .66342 Mtetra
.305 .352 .746 r
.30957 .66342 .31271 .66847 .31504 .66807 .3119 .66302 Mtetra
0 .003 .578 r
.3119 .66302 .31504 .66807 .31716 .67016 .314 .66509 Mtetra
.662 .232 0 r
.314 .66509 .31716 .67016 .31914 .67376 .31597 .66866 Mtetra
.698 .261 0 r
.31597 .66866 .31914 .67376 .32113 .67764 .31793 .67252 Mtetra
0 0 .455 r
.31793 .67252 .32113 .67764 .32322 .68049 .32001 .67534 Mtetra
.079 .238 .727 r
.32001 .67534 .32322 .68049 .32552 .68116 .32231 .67601 Mtetra
.527 .447 .709 r
.32231 .67601 .32552 .68116 .3281 .67891 .32488 .67375 Mtetra
.68 .501 .637 r
.32488 .67375 .3281 .67891 .33095 .6735 .32773 .66835 Mtetra
.735 .515 .595 r
.32773 .66835 .33095 .6735 .33404 .6653 .33082 .66017 Mtetra
.758 .52 .574 r
.33082 .66017 .33404 .6653 .33727 .65518 .33406 .65007 Mtetra
.765 .522 .566 r
.33406 .65007 .33727 .65518 .34056 .64433 .33735 .63925 Mtetra
.76 .521 .571 r
.33735 .63925 .34056 .64433 .34377 .63406 .34058 .62901 Mtetra
.742 .517 .589 r
.34058 .62901 .34377 .63406 .34684 .62553 .34365 .6205 Mtetra
.696 .506 .626 r
.34365 .6205 .34684 .62553 .34968 .61961 .34649 .61458 Mtetra
.577 .468 .693 r
.34649 .61458 .34968 .61961 .35229 .61669 .3491 .61167 Mtetra
.229 .318 .748 r
.3491 .61167 .35229 .61669 .35468 .6167 .35148 .61166 Mtetra
0 0 .554 r
.35148 .61166 .35468 .6167 .35691 .61905 .35369 .61399 Mtetra
.649 .217 0 r
.35369 .61399 .35691 .61905 .35905 .62278 .35582 .6177 Mtetra
.666 .23 0 r
.35582 .6177 .35905 .62278 .3612 .62665 .35795 .62154 Mtetra
0 0 .501 r
.35795 .62154 .3612 .62665 .36346 .62939 .36019 .62426 Mtetra
.12 .262 .737 r
.36019 .62426 .36346 .62939 .36588 .62992 .36261 .62477 Mtetra
.534 .451 .707 r
.36261 .62477 .36588 .62992 .36852 .62752 .36524 .62238 Mtetra
.681 .5 .635 r
.36524 .62238 .36852 .62752 .37137 .62205 .36809 .61691 Mtetra
.736 .514 .592 r
.36809 .61691 .37137 .62205 .37439 .61391 .37111 .60879 Mtetra
.758 .518 .571 r
.37111 .60879 .37439 .61391 .37751 .60398 .37424 .59889 Mtetra
.764 .52 .564 r
.37424 .59889 .37751 .60398 .38066 .59348 .37739 .58841 Mtetra
.758 .519 .571 r
.37739 .58841 .38066 .59348 .38374 .58365 .38049 .57861 Mtetra
.736 .514 .592 r
.38049 .57861 .38374 .58365 .3867 .57564 .38345 .57062 Mtetra
.683 .501 .635 r
.38345 .57062 .3867 .57564 .3895 .57023 .38625 .56522 Mtetra
.541 .455 .707 r
.38625 .56522 .3895 .57023 .39212 .56778 .38887 .56277 Mtetra
.151 .282 .745 r
.38887 .56277 .39212 .56778 .3946 .56817 .39133 .56314 Mtetra
0 0 .538 r
.39133 .56314 .3946 .56817 .39696 .57078 .39368 .56572 Mtetra
.632 .199 0 r
.39368 .56572 .39696 .57078 .39928 .57462 .39598 .56954 Mtetra
.629 .197 0 r
.39598 .56954 .39928 .57462 .40162 .57848 .39831 .57338 Mtetra
0 0 .543 r
.39831 .57338 .40162 .57848 .40404 .58112 .40072 .57599 Mtetra
.156 .284 .745 r
.40072 .57599 .40404 .58112 .4066 .58149 .40326 .57635 Mtetra
.541 .454 .706 r
.40326 .57635 .4066 .58149 .4093 .57896 .40596 .57382 Mtetra
.682 .499 .633 r
.40596 .57382 .4093 .57896 .41215 .57342 .40881 .56828 Mtetra
.736 .512 .589 r
.40881 .56828 .41215 .57342 .41511 .56532 .41177 .5602 Mtetra
.757 .516 .568 r
.41177 .5602 .41511 .56532 .41812 .55558 .41479 .55049 Mtetra
.763 .517 .562 r
.41479 .55049 .41812 .55558 .42114 .54538 .41782 .54032 Mtetra
.755 .516 .571 r
.41782 .54032 .42114 .54538 .42411 .53598 .42079 .53094 Mtetra
.729 .511 .595 r
.42079 .53094 .42411 .53598 .42699 .52844 .42368 .52342 Mtetra
.666 .496 .645 r
.42368 .52342 .42699 .52844 .42977 .52352 .42645 .51851 Mtetra
.499 .44 .722 r
.42645 .51851 .42977 .52352 .43244 .52152 .42912 .5165 Mtetra
.076 .247 .737 r
.42912 .5165 .43244 .52152 .43502 .52227 .43169 .51723 Mtetra
0 0 .528 r
.43169 .51723 .43502 .52227 .43756 .52512 .43421 .52006 Mtetra
.61 .178 0 r
.43421 .52006 .43756 .52512 .44008 .52907 .43671 .52399 Mtetra
.59 .163 0 r
.43671 .52399 .44008 .52907 .44263 .53292 .43924 .52781 Mtetra
0 .009 .581 r
.43924 .52781 .44263 .53292 .44523 .53546 .44183 .53032 Mtetra
.189 .303 .75 r
.44183 .53032 .44523 .53546 .44793 .53568 .44451 .53053 Mtetra
.547 .456 .704 r
.44451 .53053 .44793 .53568 .4507 .533 .44728 .52785 Mtetra
.683 .499 .631 r
.44728 .52785 .4507 .533 .45355 .52738 .45013 .52224 Mtetra
.736 .51 .586 r
.45013 .52224 .45355 .52738 .45645 .51932 .45303 .51419 Mtetra
.757 .514 .565 r
.45303 .51419 .45645 .51932 .45936 .50974 .45595 .50464 Mtetra
.761 .515 .56 r
.45595 .50464 .45936 .50974 .46227 .49983 .45887 .49476 Mtetra
.752 .513 .571 r
.45887 .49476 .46227 .49983 .46514 .49082 .46175 .48577 Mtetra
.721 .508 .6 r
.46175 .48577 .46514 .49082 .46797 .48374 .46458 .4787 Mtetra
.647 .489 .656 r
.46458 .4787 .46797 .48374 .47075 .47928 .46736 .47425 Mtetra
.451 .422 .735 r
.46736 .47425 .47075 .47928 .4735 .47771 .4701 .47267 Mtetra
.007 .214 .725 r
.4701 .47267 .4735 .47771 .47623 .4788 .47281 .47374 Mtetra
0 0 .524 r
.47281 .47374 .47623 .4788 .47896 .48188 .47553 .4768 Mtetra
0 0 .397 r
.47553 .4768 .47896 .48188 .48171 .48594 .47826 .48083 Mtetra
0 0 .431 r
.47826 .48083 .48171 .48594 .48448 .48978 .48101 .48464 Mtetra
0 .048 .615 r
.48101 .48464 .48448 .48978 .48729 .49221 .48381 .48705 Mtetra
.217 .319 .755 r
.48381 .48705 .48729 .49221 .49013 .49228 .48663 .4871 Mtetra
.552 .458 .702 r
.48663 .4871 .49013 .49228 .49298 .48946 .48948 .48428 Mtetra
.684 .497 .628 r
.48948 .48428 .49298 .48946 .49583 .48375 .49233 .47859 Mtetra
.736 .508 .583 r
.49233 .47859 .49583 .48375 .49868 .47571 .49518 .47056 Mtetra
.756 .512 .562 r
.49518 .47056 .49868 .47571 .5015 .46627 .49801 .46115 Mtetra
.76 .512 .559 r
.49801 .46115 .5015 .46627 .5043 .45664 .50082 .45154 Mtetra
.747 .51 .572 r
.50082 .45154 .5043 .45664 .50709 .44799 .50362 .44292 Mtetra
.712 .504 .606 r
.50362 .44292 .50709 .44799 .50989 .44134 .50642 .43628 Mtetra
.624 .482 .669 r
.50642 .43628 .50989 .44134 .51271 .43733 .50923 .43227 Mtetra
.399 .402 .747 r
.50923 .43227 .51271 .43733 .51557 .43617 .51208 .4311 Mtetra
0 .186 .712 r
.51208 .4311 .51557 .43617 .51848 .43759 .51498 .4325 Mtetra
0 0 .526 r
.51498 .4325 .51848 .43759 .52145 .4409 .51793 .43578 Mtetra
0 0 .426 r
.51793 .43578 .52145 .4409 .52445 .44506 .52091 .43992 Mtetra
0 0 .472 r
.52091 .43992 .52445 .44506 .52749 .44889 .52392 .44371 Mtetra
0 .085 .644 r
.52392 .44371 .52749 .44889 .53051 .45121 .52693 .44601 Mtetra
.243 .333 .758 r
.52693 .44601 .53051 .45121 .5335 .45112 .52991 .44591 Mtetra
.557 .46 .7 r
.52991 .44591 .5335 .45112 .53644 .44815 .53284 .44294 Mtetra
.685 .496 .626 r
.53284 .44294 .53644 .44815 .5393 .44236 .5357 .43715 Mtetra
.736 .506 .58 r
.5357 .43715 .5393 .44236 .54208 .43432 .53849 .42913 Mtetra
.756 .509 .559 r
.53849 .42913 .54208 .43432 .54482 .42501 .54123 .41985 Mtetra
.757 .509 .557 r
.54123 .41985 .54482 .42501 .54753 .41562 .54396 .41049 Mtetra
.742 .507 .574 r
.54396 .41049 .54753 .41562 .55027 .40733 .5467 .40221 Mtetra
.7 .5 .613 r
.5467 .40221 .55027 .40733 .55306 .40109 .54949 .39598 Mtetra
.597 .473 .682 r
.54949 .39598 .55306 .40109 .55595 .3975 .55238 .3924 Mtetra
.343 .38 .756 r
.55238 .3924 .55595 .3975 .55896 .39674 .55538 .39162 Mtetra
0 .164 .7 r
.55538 .39162 .55896 .39674 .5621 .39848 .55849 .39334 Mtetra
0 0 .534 r
.55849 .39334 .5621 .39848 .56533 .40201 .56171 .39684 Mtetra
0 0 .456 r
.56171 .39684 .56533 .40201 .56863 .40627 .56499 .40108 Mtetra
0 0 .511 r
.56499 .40108 .56863 .40627 .57195 .41008 .56828 .40486 Mtetra
0 .119 .67 r
.56828 .40486 .57195 .41008 .57521 .4123 .57152 .40705 Mtetra
.265 .346 .76 r
.57152 .40705 .57521 .4123 .57837 .41206 .57467 .4068 Mtetra
.561 .461 .698 r
.57467 .4068 .57837 .41206 .58139 .40893 .57769 .40367 Mtetra
.685 .495 .623 r
.57769 .40367 .58139 .40893 .58426 .40304 .58056 .39778 Mtetra
.736 .504 .577 r
.58056 .39778 .58426 .40304 .587 .39499 .5833 .38975 Mtetra
.755 .506 .556 r
.5833 .38975 .587 .39499 .58965 .38579 .58596 .38058 Mtetra
.58596 .38058 .58965 .38579 .59229 .37664 .58861 .37145 Mtetra
.737 .504 .576 r
.58861 .37145 .59229 .37664 .59499 .36867 .59131 .3635 Mtetra
.687 .495 .622 r
.59131 .3635 .59499 .36867 .59781 .36282 .59413 .35766 Mtetra
.566 .463 .697 r
.59413 .35766 .59781 .36282 .60081 .35965 .59713 .35449 Mtetra
.285 .357 .762 r
.59713 .35449 .60081 .35965 .60401 .35927 .60032 .35409 Mtetra
0 .147 .69 r
.60032 .35409 .60401 .35927 .60741 .36133 .6037 .35613 Mtetra
0 0 .545 r
.6037 .35613 .60741 .36133 .61096 .36507 .60722 .35984 Mtetra
0 0 .488 r
.60722 .35984 .61096 .36507 .6146 .36944 .61083 .36418 Mtetra
0 0 .547 r
.61083 .36418 .6146 .36944 .61822 .37324 .61444 .36795 Mtetra
0 .149 .692 r
.61444 .36795 .61822 .37324 .62175 .37535 .61794 .37004 Mtetra
.285 .356 .761 r
.61794 .37004 .62175 .37535 .62509 .37495 .62127 .36962 Mtetra
.564 .461 .696 r
.62127 .36962 .62509 .37495 .62821 .37166 .62438 .36633 Mtetra
.685 .493 .62 r
.62438 .36633 .62821 .37166 .63109 .36565 .62726 .36033 Mtetra
.735 .501 .573 r
.62726 .36033 .63109 .36565 .63378 .35759 .62996 .35228 Mtetra
.753 .503 .553 r
.62996 .35228 .63378 .35759 .63636 .34848 .63255 .34321 Mtetra
.752 .503 .555 r
.63255 .34321 .63636 .34848 .63894 .33954 .63513 .33429 Mtetra
.729 .5 .58 r
.63513 .33429 .63894 .33954 .64162 .33188 .63782 .32665 Mtetra
.671 .49 .632 r
.63782 .32665 .64162 .33188 .6445 .32641 .6407 .32119 Mtetra
.53 .452 .712 r
.6407 .32119 .6445 .32641 .64765 .32364 .64385 .31841 Mtetra
.229 .334 .765 r
.64385 .31841 .64765 .32364 .6511 .32363 .64728 .31839 Mtetra
0 .136 .683 r
.64728 .31839 .6511 .32363 .65481 .32601 .65097 .32074 Mtetra
0 0 .559 r
.65097 .32074 .65481 .32601 .65873 .32997 .65486 .32466 Mtetra
0 0 .519 r
.65486 .32466 .65873 .32997 .66274 .33444 .65885 .3291 Mtetra
0 .017 .581 r
.65885 .3291 .66274 .33444 .66672 .33823 .6628 .33286 Mtetra
0 .178 .71 r
.6628 .33286 .66672 .33823 .67054 .34024 .6666 .33484 Mtetra
.303 .365 .761 r
.6666 .33484 .67054 .34024 .67408 .33968 .67013 .33426 Mtetra
.567 .461 .694 r
.67013 .33426 .67408 .33968 .6773 .33622 .67334 .33081 Mtetra
.685 .49 .617 r
.67334 .33081 .6773 .33622 .6802 .33008 .67624 .32468 Mtetra
.735 .498 .57 r
.67624 .32468 .6802 .33008 .68285 .32198 .67889 .3166 Mtetra
.752 .499 .55 r
.67889 .3166 .68285 .32198 .68536 .31296 .68142 .3076 Mtetra
.748 .499 .555 r
.68142 .3076 .68536 .31296 .68789 .30421 .68396 .29887 Mtetra
.721 .496 .584 r
.68396 .29887 .68789 .30421 .69058 .29685 .68665 .29153 Mtetra
.652 .484 .644 r
.68665 .29153 .69058 .29685 .69356 .29174 .68963 .28643 Mtetra
.491 .439 .726 r
.68963 .28643 .69356 .29174 .69691 .28935 .69297 .28404 Mtetra
.176 .312 .765 r
.69297 .28404 .69691 .28935 .70066 .28972 .69669 .28439 Mtetra
0 .131 .679 r
.69669 .28439 .70066 .28972 .70475 .29241 .70077 .28704 Mtetra
0 .013 .576 r
.70077 .28704 .70475 .29241 .7091 .29659 .70508 .29119 Mtetra
0 0 .55 r
.70508 .29119 .7091 .29659 .71355 .30117 .7095 .29573 Mtetra
0 .051 .613 r
.7095 .29573 .71355 .30117 .71792 .30495 .71385 .29948 Mtetra
0 .203 .725 r
.71385 .29948 .71792 .30495 .72206 .30685 .71797 .30135 Mtetra
.318 .373 .761 r
.71797 .30135 .72206 .30685 .72583 .30612 .72172 .30061 Mtetra
.606 .416 .597 r
.28175 .72041 .28463 .72817 .28749 .72283 .2846 .71508 Mtetra
.675 .451 .573 r
.2846 .71508 .28749 .72283 .29065 .71457 .28776 .70687 Mtetra
.706 .467 .559 r
.28776 .70687 .29065 .71457 .29401 .70426 .29113 .6966 Mtetra
.717 .472 .554 r
.29113 .6966 .29401 .70426 .29745 .69307 .29457 .68547 Mtetra
.713 .47 .556 r
.29457 .68547 .29745 .69307 .30083 .68235 .29795 .6748 Mtetra
.692 .459 .566 r
.29795 .6748 .30083 .68235 .30403 .6733 .30115 .66579 Mtetra
.642 .435 .587 r
.30115 .66579 .30403 .6733 .30695 .66684 .30407 .65935 Mtetra
.533 .378 .617 r
.30407 .65935 .30695 .66684 .30957 .66342 .30668 .65594 Mtetra
.286 .244 .635 r
.30668 .65594 .30957 .66342 .3119 .66302 .309 .65552 Mtetra
0 0 .554 r
.309 .65552 .3119 .66302 .314 .66509 .31108 .65756 Mtetra
0 0 .407 r
.31108 .65756 .314 .66509 .31597 .66866 .31304 .66109 Mtetra
0 0 .377 r
.31304 .66109 .31597 .66866 .31793 .67252 .31499 .66491 Mtetra
0 0 .494 r
.31499 .66491 .31793 .67252 .32001 .67534 .31705 .6677 Mtetra
.136 .158 .62 r
.31705 .6677 .32001 .67534 .32231 .67601 .31933 .66834 Mtetra
.457 .337 .627 r
.31933 .66834 .32231 .67601 .32488 .67375 .32189 .66608 Mtetra
.608 .415 .596 r
.32189 .66608 .32488 .67375 .32773 .66835 .32474 .66069 Mtetra
.675 .449 .571 r
.32474 .66069 .32773 .66835 .33082 .66017 .32783 .65255 Mtetra
.705 .463 .556 r
.32783 .65255 .33082 .66017 .33406 .65007 .33108 .6425 Mtetra
.714 .468 .551 r
.33108 .6425 .33406 .65007 .33735 .63925 .33437 .63173 Mtetra
.708 .465 .554 r
.33437 .63173 .33735 .63925 .34058 .62901 .3376 .62153 Mtetra
.684 .453 .567 r
.3376 .62153 .34058 .62901 .34365 .6205 .34067 .61306 Mtetra
.628 .426 .59 r
.34067 .61306 .34365 .6205 .34649 .61458 .34351 .60717 Mtetra
.503 .363 .623 r
.34351 .60717 .34649 .61458 .3491 .61167 .34611 .60425 Mtetra
.234 .218 .636 r
.34611 .60425 .3491 .61167 .35148 .61166 .34847 .60423 Mtetra
0 0 .546 r
.34847 .60423 .35148 .61166 .35369 .61399 .35067 .60653 Mtetra
0 0 .417 r
.35067 .60653 .35369 .61399 .35582 .6177 .35278 .61019 Mtetra
0 0 .405 r
.35278 .61019 .35582 .6177 .35795 .62154 .3549 .614 Mtetra
0 0 .52 r
.3549 .614 .35795 .62154 .36019 .62426 .35712 .61668 Mtetra
.162 .177 .628 r
.35712 .61668 .36019 .62426 .36261 .62477 .35952 .61717 Mtetra
.464 .341 .627 r
.35952 .61717 .36261 .62477 .36524 .62238 .36214 .61477 Mtetra
.609 .415 .594 r
.36214 .61477 .36524 .62238 .36809 .61691 .36499 .60933 Mtetra
.674 .446 .568 r
.36499 .60933 .36809 .61691 .37111 .60879 .36801 .60124 Mtetra
.703 .46 .553 r
.36801 .60124 .37111 .60879 .37424 .59889 .37114 .59139 Mtetra
.711 .464 .549 r
.37114 .59139 .37424 .59889 .37739 .58841 .3743 .58096 Mtetra
.703 .46 .553 r
.3743 .58096 .37739 .58841 .38049 .57861 .37739 .5712 Mtetra
.675 .447 .568 r
.37739 .5712 .38049 .57861 .38345 .57062 .38036 .56324 Mtetra
.611 .417 .594 r
.38036 .56324 .38345 .57062 .38625 .56522 .38315 .55786 Mtetra
.471 .347 .629 r
.38315 .55786 .38625 .56522 .38887 .56277 .38576 .55541 Mtetra
.182 .193 .635 r
.38576 .55541 .38887 .56277 .39133 .56314 .38821 .55576 Mtetra
0 0 .541 r
.38821 .55576 .39133 .56314 .39368 .56572 .39054 .55831 Mtetra
0 0 .431 r
.39054 .55831 .39368 .56572 .39598 .56954 .39283 .56209 Mtetra
0 0 .432 r
.39283 .56209 .39598 .56954 .39831 .57338 .39513 .56588 Mtetra
0 0 .544 r
.39513 .56588 .39831 .57338 .40072 .57599 .39752 .56846 Mtetra
.186 .194 .635 r
.39752 .56846 .40072 .57599 .40326 .57635 .40005 .5688 Mtetra
.47 .345 .627 r
.40005 .5688 .40326 .57635 .40596 .57382 .40274 .56626 Mtetra
.609 .414 .592 r
.40274 .56626 .40596 .57382 .40881 .56828 .40559 .56075 Mtetra
.673 .443 .565 r
.40559 .56075 .40881 .56828 .41177 .5602 .40855 .5527 Mtetra
.701 .456 .55 r
.40855 .5527 .41177 .5602 .41479 .55049 .41157 .54303 Mtetra
.708 .459 .546 r
.41157 .54303 .41479 .55049 .41782 .54032 .4146 .53291 Mtetra
.698 .455 .552 r
.4146 .53291 .41782 .54032 .42079 .53094 .41758 .52357 Mtetra
.665 .44 .569 r
.41758 .52357 .42079 .53094 .42368 .52342 .42047 .51608 Mtetra
.592 .406 .599 r
.42047 .51608 .42368 .52342 .42645 .51851 .42324 .51119 Mtetra
.435 .329 .635 r
.42324 .51119 .42645 .51851 .42912 .5165 .42589 .50918 Mtetra
.132 .169 .634 r
.42589 .50918 .42912 .5165 .43169 .51723 .42845 .50988 Mtetra
0 0 .539 r
.42845 .50988 .43169 .51723 .43421 .52006 .43095 .51267 Mtetra
0 0 .447 r
.43095 .51267 .43421 .52006 .43671 .52399 .43343 .51656 Mtetra
0 0 .46 r
.43343 .51656 .43671 .52399 .43924 .52781 .43594 .52034 Mtetra
0 .004 .565 r
.43594 .52034 .43924 .52781 .44183 .53032 .43851 .52281 Mtetra
.207 .209 .641 r
.43851 .52281 .44183 .53032 .44451 .53053 .44117 .523 Mtetra
.476 .348 .627 r
.44117 .523 .44451 .53053 .44728 .52785 .44394 .52032 Mtetra
.609 .412 .59 r
.44394 .52032 .44728 .52785 .45013 .52224 .44678 .51473 Mtetra
.672 .44 .562 r
.44678 .51473 .45013 .52224 .45303 .51419 .44968 .50672 Mtetra
.699 .452 .547 r
.44968 .50672 .45303 .51419 .45595 .50464 .45261 .49721 Mtetra
.704 .454 .544 r
.45261 .49721 .45595 .50464 .45887 .49476 .45553 .48737 Mtetra
.691 .449 .551 r
.45553 .48737 .45887 .49476 .46175 .48577 .45841 .47843 Mtetra
.654 .433 .571 r
.45841 .47843 .46175 .48577 .46458 .4787 .46124 .47139 Mtetra
.571 .395 .604 r
.46124 .47139 .46458 .4787 .46736 .47425 .46401 .46695 Mtetra
.397 .311 .641 r
.46401 .46695 .46736 .47425 .4701 .47267 .46674 .46536 Mtetra
.085 .148 .633 r
.46674 .46536 .4701 .47267 .47281 .47374 .46944 .46641 Mtetra
0 0 .54 r
.46944 .46641 .47281 .47374 .47553 .4768 .47213 .46943 Mtetra
0 0 .465 r
.47213 .46943 .47553 .4768 .47826 .48083 .47484 .47341 Mtetra
0 0 .487 r
.47484 .47341 .47826 .48083 .48101 .48464 .47757 .47718 Mtetra
0 .033 .584 r
.47757 .47718 .48101 .48464 .48381 .48705 .48035 .47955 Mtetra
.227 .223 .646 r
.48035 .47955 .48381 .48705 .48663 .4871 .48315 .47958 Mtetra
.48 .35 .626 r
.48315 .47958 .48663 .4871 .48948 .48428 .48599 .47676 Mtetra
.609 .41 .587 r
.48599 .47676 .48948 .48428 .49233 .47859 .48884 .47108 Mtetra
.67 .437 .559 r
.48884 .47108 .49233 .47859 .49518 .47056 .49169 .46309 Mtetra
.696 .447 .544 r
.49169 .46309 .49518 .47056 .49801 .46115 .49452 .45373 Mtetra
.7 .449 .541 r
.49452 .45373 .49801 .46115 .50082 .45154 .49733 .44416 Mtetra
.684 .443 .551 r
.49733 .44416 .50082 .45154 .50362 .44292 .50014 .43558 Mtetra
.641 .425 .574 r
.50014 .43558 .50362 .44292 .50642 .43628 .50293 .42897 Mtetra
.547 .383 .61 r
.50293 .42897 .50642 .43628 .50923 .43227 .50575 .42497 Mtetra
.357 .293 .647 r
.50575 .42497 .50923 .43227 .51208 .4311 .50858 .42379 Mtetra
.043 .131 .631 r
.50858 .42379 .51208 .4311 .51498 .4325 .51146 .42516 Mtetra
0 0 .544 r
.51146 .42516 .51498 .4325 .51793 .43578 .51438 .4284 Mtetra
0 0 .484 r
.51438 .4284 .51793 .43578 .52091 .43992 .51734 .43248 Mtetra
0 0 .513 r
.51734 .43248 .52091 .43992 .52392 .44371 .52033 .43623 Mtetra
0 .06 .601 r
.52033 .43623 .52392 .44371 .52693 .44601 .52332 .4385 Mtetra
.244 .235 .65 r
.52332 .4385 .52693 .44601 .52991 .44591 .52628 .43838 Mtetra
.484 .352 .625 r
.52628 .43838 .52991 .44591 .53284 .44294 .5292 .4354 Mtetra
.609 .408 .584 r
.5292 .4354 .53284 .44294 .5357 .43715 .53205 .42964 Mtetra
.668 .433 .555 r
.53205 .42964 .5357 .43715 .53849 .42913 .53485 .42165 Mtetra
.693 .443 .54 r
.53485 .42165 .53849 .42913 .54123 .41985 .53759 .41241 Mtetra
.695 .444 .539 r
.53759 .41241 .54123 .41985 .54396 .41049 .54032 .4031 Mtetra
.676 .436 .551 r
.54032 .4031 .54396 .41049 .5467 .40221 .54306 .39486 Mtetra
.626 .416 .577 r
.54306 .39486 .5467 .40221 .54949 .39598 .54586 .38865 Mtetra
.521 .37 .617 r
.54586 .38865 .54949 .39598 .55238 .3924 .54873 .38508 Mtetra
.316 .274 .652 r
.54873 .38508 .55238 .3924 .55538 .39162 .55172 .38428 Mtetra
.007 .116 .63 r
.55172 .38428 .55538 .39162 .55849 .39334 .55481 .38597 Mtetra
0 0 .55 r
.55481 .38597 .55849 .39334 .56171 .39684 .558 .38943 Mtetra
0 0 .505 r
.558 .38943 .56171 .39684 .56499 .40108 .56125 .39361 Mtetra
0 0 .537 r
.56125 .39361 .56499 .40108 .56828 .40486 .56452 .39734 Mtetra
0 .085 .617 r
.56452 .39734 .56828 .40486 .57152 .40705 .56774 .3995 Mtetra
.26 .246 .653 r
.56774 .3995 .57152 .40705 .57467 .4068 .57087 .39923 Mtetra
.487 .353 .624 r
.57087 .39923 .57467 .4068 .57769 .40367 .57387 .3961 Mtetra
.608 .405 .581 r
.57387 .3961 .57769 .40367 .58056 .39778 .57674 .39023 Mtetra
.666 .428 .551 r
.57674 .39023 .58056 .39778 .5833 .38975 .57948 .38224 Mtetra
.689 .437 .537 r
.57948 .38224 .5833 .38975 .58596 .38058 .58215 .37311 Mtetra
.58215 .37311 .58596 .38058 .58861 .37145 .5848 .36403 Mtetra
.667 .429 .551 r
.5848 .36403 .58861 .37145 .59131 .3635 .5875 .35611 Mtetra
.61 .407 .581 r
.5875 .35611 .59131 .3635 .59413 .35766 .59032 .3503 Mtetra
.493 .357 .624 r
.59032 .3503 .59413 .35766 .59713 .35449 .59331 .34712 Mtetra
.275 .256 .657 r
.59331 .34712 .59713 .35449 .60032 .35409 .59648 .34671 Mtetra
0 .106 .629 r
.59648 .34671 .60032 .35409 .6037 .35613 .59984 .34871 Mtetra
0 0 .559 r
.59984 .34871 .6037 .35613 .60722 .35984 .60333 .35238 Mtetra
0 0 .525 r
.60333 .35238 .60722 .35984 .61083 .36418 .60691 .35666 Mtetra
0 0 .56 r
.60691 .35666 .61083 .36418 .61444 .36795 .61049 .36038 Mtetra
0 .108 .63 r
.61049 .36038 .61444 .36795 .61794 .37004 .61397 .36243 Mtetra
.275 .255 .655 r
.61397 .36243 .61794 .37004 .62127 .36962 .61728 .362 Mtetra
.49 .354 .622 r
.61728 .362 .62127 .36962 .62438 .36633 .62038 .35871 Mtetra
.607 .402 .578 r
.62038 .35871 .62438 .36633 .62726 .36033 .62326 .35273 Mtetra
.663 .424 .547 r
.62326 .35273 .62726 .36033 .62996 .35228 .62596 .34472 Mtetra
.685 .432 .533 r
.62596 .34472 .62996 .35228 .63255 .34321 .62855 .33569 Mtetra
.683 .431 .534 r
.62855 .33569 .63255 .34321 .63513 .33429 .63114 .32681 Mtetra
.656 .421 .552 r
.63114 .32681 .63513 .33429 .63782 .32665 .63383 .3192 Mtetra
.592 .397 .586 r
.63383 .3192 .63782 .32665 .6407 .32119 .6367 .31376 Mtetra
.462 .343 .632 r
.6367 .31376 .6407 .32119 .64385 .31841 .63983 .31098 Mtetra
.235 .24 .661 r
.63983 .31098 .64385 .31841 .64728 .31839 .64324 .31094 Mtetra
0 .1 .63 r
.64324 .31094 .64728 .31839 .65097 .32074 .64691 .31324 Mtetra
0 0 .569 r
.64691 .31324 .65097 .32074 .65486 .32466 .65077 .31712 Mtetra
0 0 .546 r
.65077 .31712 .65486 .32466 .65885 .3291 .65472 .3215 Mtetra
0 .011 .581 r
.65472 .3215 .65885 .3291 .6628 .33286 .65865 .32521 Mtetra
.012 .129 .641 r
.65865 .32521 .6628 .33286 .6666 .33484 .66241 .32715 Mtetra
.287 .263 .657 r
.66241 .32715 .6666 .33484 .67013 .33426 .66592 .32656 Mtetra
.492 .353 .62 r
.66592 .32656 .67013 .33426 .67334 .33081 .66912 .3231 Mtetra
.605 .398 .575 r
.66912 .3231 .67334 .33081 .67624 .32468 .67202 .317 Mtetra
.66 .418 .543 r
.67202 .317 .67624 .32468 .67889 .3166 .67468 .30895 Mtetra
.68 .425 .529 r
.67468 .30895 .67889 .3166 .68142 .3076 .67721 .3 Mtetra
.676 .424 .533 r
.67721 .3 .68142 .3076 .68396 .29887 .67975 .29131 Mtetra
.644 .413 .553 r
.67975 .29131 .68396 .29887 .68665 .29153 .68244 .284 Mtetra
.572 .386 .592 r
.68244 .284 .68665 .29153 .68963 .28643 .68542 .27892 Mtetra
.429 .329 .639 r
.68542 .27892 .68963 .28643 .69297 .28404 .68874 .27652 Mtetra
.198 .225 .664 r
.68874 .27652 .69297 .28404 .69669 .28439 .69244 .27684 Mtetra
0 .098 .633 r
.69244 .27684 .69669 .28439 .70077 .28704 .69648 .27946 Mtetra
0 .009 .581 r
.69648 .27946 .70077 .28704 .70508 .29119 .70076 .28355 Mtetra
0 0 .567 r
.70076 .28355 .70508 .29119 .7095 .29573 .70515 .28803 Mtetra
0 .038 .601 r
.70515 .28803 .7095 .29573 .71385 .29948 .70946 .29172 Mtetra
.04 .148 .651 r
.70946 .29172 .71385 .29948 .71797 .30135 .71354 .29356 Mtetra
.298 .27 .658 r
.71354 .29356 .71797 .30135 .72172 .30061 .71727 .2928 Mtetra
.572 .375 .576 r
.27905 .71113 .28175 .72041 .2846 .71508 .2819 .70582 Mtetra
.644 .417 .56 r
.2819 .70582 .2846 .71508 .28776 .70687 .28506 .69765 Mtetra
.678 .437 .549 r
.28506 .69765 .28776 .70687 .29113 .6966 .28842 .68744 Mtetra
.69 .444 .545 r
.28842 .68744 .29113 .6966 .29457 .68547 .29187 .67638 Mtetra
.686 .441 .547 r
.29187 .67638 .29457 .68547 .29795 .6748 .29525 .66577 Mtetra
.662 .428 .555 r
.29525 .66577 .29795 .6748 .30115 .66579 .29844 .65681 Mtetra
.609 .397 .569 r
.29844 .65681 .30115 .66579 .30407 .65935 .30135 .6504 Mtetra
.499 .334 .588 r
.30135 .6504 .30407 .65935 .30668 .65594 .30395 .647 Mtetra
.277 .204 .591 r
.30395 .647 .30668 .65594 .309 .65552 .30626 .64656 Mtetra
0 0 .527 r
.30626 .64656 .309 .65552 .31108 .65756 .30833 .64856 Mtetra
0 0 .424 r
.30833 .64856 .31108 .65756 .31304 .66109 .31027 .65205 Mtetra
0 0 .402 r
.31027 .65205 .31304 .66109 .31499 .66491 .3122 .65582 Mtetra
0 0 .485 r
.3122 .65582 .31499 .66491 .31705 .6677 .31425 .65857 Mtetra
.153 .129 .576 r
.31425 .65857 .31705 .6677 .31933 .66834 .31651 .65918 Mtetra
.427 .291 .592 r
.31651 .65918 .31933 .66834 .32189 .66608 .31906 .65692 Mtetra
.573 .375 .575 r
.31906 .65692 .32189 .66608 .32474 .66069 .3219 .65156 Mtetra
.643 .415 .557 r
.3219 .65156 .32474 .66069 .32783 .65255 .32499 .64345 Mtetra
.676 .433 .546 r
.32499 .64345 .32783 .65255 .33108 .6425 .32823 .63346 Mtetra
.687 .439 .542 r
.32823 .63346 .33108 .6425 .33437 .63173 .33153 .62276 Mtetra
.68 .435 .545 r
.33153 .62276 .33437 .63173 .3376 .62153 .33476 .61263 Mtetra
.653 .42 .554 r
.33476 .61263 .3376 .62153 .34067 .61306 .33782 .6042 Mtetra
.593 .387 .571 r
.33782 .6042 .34067 .61306 .34351 .60717 .34066 .59833 Mtetra
.471 .318 .591 r
.34066 .59833 .34351 .60717 .34611 .60425 .34325 .59542 Mtetra
.234 .181 .591 r
.34325 .59542 .34611 .60425 .34847 .60423 .3456 .59538 Mtetra
0 0 .524 r
.3456 .59538 .34847 .60423 .35067 .60653 .34778 .59764 Mtetra
0 0 .433 r
.34778 .59764 .35067 .60653 .35278 .61019 .34987 .60125 Mtetra
0 0 .424 r
.34987 .60125 .35278 .61019 .3549 .614 .35197 .60501 Mtetra
0 0 .506 r
.35197 .60501 .3549 .614 .35712 .61668 .35417 .60765 Mtetra
.174 .145 .583 r
.35417 .60765 .35712 .61668 .35952 .61717 .35656 .60812 Mtetra
.434 .295 .592 r
.35656 .60812 .35952 .61717 .36214 .61477 .35917 .60571 Mtetra
.573 .374 .573 r
.35917 .60571 .36214 .61477 .36499 .60933 .36201 .60029 Mtetra
.642 .412 .554 r
.36201 .60029 .36499 .60933 .36801 .60124 .36503 .59225 Mtetra
.674 .429 .543 r
.36503 .59225 .36801 .60124 .37114 .59139 .36816 .58245 Mtetra
.683 .434 .539 r
.36816 .58245 .37114 .59139 .3743 .58096 .37132 .57209 Mtetra
.674 .429 .543 r
.37132 .57209 .3743 .58096 .37739 .5712 .37441 .56239 Mtetra
.643 .413 .554 r
.37441 .56239 .37739 .5712 .38036 .56324 .37738 .55447 Mtetra
.576 .376 .573 r
.37738 .55447 .38036 .56324 .38315 .55786 .38016 .54911 Mtetra
.44 .301 .595 r
.38016 .54911 .38315 .55786 .38576 .55541 .38276 .54666 Mtetra
.191 .159 .591 r
.38276 .54666 .38576 .55541 .38821 .55576 .3852 .54699 Mtetra
0 0 .522 r
.3852 .54699 .38821 .55576 .39054 .55831 .38751 .5495 Mtetra
0 0 .444 r
.38751 .5495 .39054 .55831 .39283 .56209 .38977 .55322 Mtetra
0 0 .446 r
.38977 .55322 .39283 .56209 .39513 .56588 .39205 .55696 Mtetra
0 0 .524 r
.39205 .55696 .39513 .56588 .39752 .56846 .39443 .5595 Mtetra
.194 .16 .59 r
.39443 .5595 .39752 .56846 .40005 .5688 .39694 .55981 Mtetra
.439 .299 .593 r
.39694 .55981 .40005 .5688 .40274 .56626 .39962 .55728 Mtetra
.574 .373 .571 r
.39962 .55728 .40274 .56626 .40559 .56075 .40245 .55178 Mtetra
.64 .408 .551 r
.40245 .55178 .40559 .56075 .40855 .5527 .40541 .54378 Mtetra
.671 .425 .54 r
.40541 .54378 .40855 .5527 .41157 .54303 .40844 .53417 Mtetra
.679 .429 .537 r
.40844 .53417 .41157 .54303 .4146 .53291 .41147 .52411 Mtetra
.667 .423 .541 r
.41147 .52411 .4146 .53291 .41758 .52357 .41445 .51483 Mtetra
.632 .404 .555 r
.41445 .51483 .41758 .52357 .42047 .51608 .41733 .50738 Mtetra
.556 .364 .576 r
.41733 .50738 .42047 .51608 .42324 .51119 .4201 .5025 Mtetra
.408 .284 .598 r
.4201 .5025 .42324 .51119 .42589 .50918 .42274 .50049 Mtetra
.149 .14 .59 r
.42274 .50049 .42589 .50918 .42845 .50988 .42528 .50117 Mtetra
0 0 .523 r
.42528 .50117 .42845 .50988 .43095 .51267 .42775 .50391 Mtetra
0 0 .458 r
.42775 .50391 .43095 .51267 .43343 .51656 .43021 .50774 Mtetra
0 0 .467 r
.43021 .50774 .43343 .51656 .43594 .52034 .4327 .51147 Mtetra
0 .002 .541 r
.4327 .51147 .43594 .52034 .43851 .52281 .43525 .5139 Mtetra
.212 .174 .596 r
.43525 .5139 .43851 .52281 .44117 .523 .4379 .51406 Mtetra
.444 .302 .593 r
.4379 .51406 .44117 .523 .44394 .52032 .44065 .51139 Mtetra
.573 .371 .569 r
.44065 .51139 .44394 .52032 .44678 .51473 .44349 .50582 Mtetra
.638 .405 .548 r
.44349 .50582 .44678 .51473 .44968 .50672 .44639 .49785 Mtetra
.667 .42 .536 r
.44639 .49785 .44968 .50672 .45261 .49721 .44931 .4884 Mtetra
.674 .423 .534 r
.44931 .4884 .45261 .49721 .45553 .48737 .45223 .47863 Mtetra
.66 .416 .54 r
.45223 .47863 .45553 .48737 .45841 .47843 .45511 .46973 Mtetra
.619 .395 .555 r
.45511 .46973 .45841 .47843 .46124 .47139 .45794 .46273 Mtetra
.535 .352 .579 r
.45794 .46273 .46124 .47139 .46401 .46695 .46071 .4583 Mtetra
.374 .266 .602 r
.46071 .4583 .46401 .46695 .46674 .46536 .46342 .45671 Mtetra
.111 .122 .59 r
.46342 .45671 .46674 .46536 .46944 .46641 .4661 .45772 Mtetra
0 0 .526 r
.4661 .45772 .46944 .46641 .47213 .46943 .46877 .46069 Mtetra
0 0 .473 r
.46877 .46069 .47213 .46943 .47484 .47341 .47145 .46462 Mtetra
0 0 .489 r
.47145 .46462 .47484 .47341 .47757 .47718 .47416 .46834 Mtetra
0 .026 .556 r
.47416 .46834 .47757 .47718 .48035 .47955 .47691 .47066 Mtetra
.228 .186 .601 r
.47691 .47066 .48035 .47955 .48315 .47958 .4797 .47067 Mtetra
.449 .305 .592 r
.4797 .47067 .48315 .47958 .48599 .47676 .48253 .46785 Mtetra
.573 .369 .566 r
.48253 .46785 .48599 .47676 .48884 .47108 .48537 .4622 Mtetra
.636 .401 .545 r
.48537 .4622 .48884 .47108 .49169 .46309 .48822 .45425 Mtetra
.664 .414 .533 r
.48822 .45425 .49169 .46309 .49452 .45373 .49105 .44494 Mtetra
.668 .417 .531 r
.49105 .44494 .49452 .45373 .49733 .44416 .49387 .43544 Mtetra
.651 .408 .539 r
.49387 .43544 .49733 .44416 .50014 .43558 .49667 .4269 Mtetra
.605 .386 .556 r
.49667 .4269 .50014 .43558 .50293 .42897 .49946 .42033 Mtetra
.512 .339 .583 r
.49946 .42033 .50293 .42897 .50575 .42497 .50227 .41634 Mtetra
.339 .249 .606 r
.50227 .41634 .50575 .42497 .50858 .42379 .50509 .41514 Mtetra
.076 .108 .591 r
.50509 .41514 .50858 .42379 .51146 .42516 .50794 .41648 Mtetra
0 0 .531 r
.50794 .41648 .51146 .42516 .51438 .4284 .51084 .41967 Mtetra
0 0 .489 r
.51084 .41967 .51438 .4284 .51734 .43248 .51377 .4237 Mtetra
0 0 .509 r
.51377 .4237 .51734 .43248 .52033 .43623 .51673 .42739 Mtetra
0 .049 .57 r
.51673 .42739 .52033 .43623 .52332 .4385 .51969 .42961 Mtetra
.243 .197 .605 r
.51969 .42961 .52332 .4385 .52628 .43838 .52264 .42947 Mtetra
.452 .306 .592 r
.52264 .42947 .52628 .43838 .5292 .4354 .52554 .4265 Mtetra
.572 .366 .563 r
.52554 .4265 .5292 .4354 .53205 .42964 .52839 .42076 Mtetra
.633 .396 .541 r
.52839 .42076 .53205 .42964 .53485 .42165 .53119 .41282 Mtetra
.66 .409 .529 r
.53119 .41282 .53485 .42165 .53759 .41241 .53393 .40364 Mtetra
.662 .41 .528 r
.53393 .40364 .53759 .41241 .54032 .4031 .53666 .39437 Mtetra
.642 .4 .538 r
.53666 .39437 .54032 .4031 .54306 .39486 .5394 .38618 Mtetra
.59 .376 .558 r
.5394 .38618 .54306 .39486 .54586 .38865 .54219 .38001 Mtetra
.487 .325 .587 r
.54219 .38001 .54586 .38865 .54873 .38508 .54506 .37644 Mtetra
.303 .232 .609 r
.54506 .37644 .54873 .38508 .55172 .38428 .54803 .37563 Mtetra
.046 .096 .592 r
.54803 .37563 .55172 .38428 .55481 .38597 .5511 .37728 Mtetra
0 0 .538 r
.5511 .37728 .55481 .38597 .558 .38943 .55426 .38068 Mtetra
0 0 .505 r
.55426 .38068 .558 .38943 .56125 .39361 .55748 .3848 Mtetra
0 0 .529 r
.55748 .3848 .56125 .39361 .56452 .39734 .56071 .38848 Mtetra
0 .07 .583 r
.56071 .38848 .56452 .39734 .56774 .3995 .56391 .39059 Mtetra
.256 .207 .608 r
.56391 .39059 .56774 .3995 .57087 .39923 .56702 .3903 Mtetra
.455 .307 .591 r
.56702 .3903 .57087 .39923 .57387 .3961 .57001 .38717 Mtetra
.571 .363 .56 r
.57001 .38717 .57387 .3961 .57674 .39023 .57287 .38133 Mtetra
.63 .391 .537 r
.57287 .38133 .57674 .39023 .57948 .38224 .57561 .37339 Mtetra
.655 .402 .525 r
.57561 .37339 .57948 .38224 .58215 .37311 .57828 .36431 Mtetra
.655 .403 .525 r
.57828 .36431 .58215 .37311 .5848 .36403 .58094 .35528 Mtetra
.631 .392 .537 r
.58094 .35528 .5848 .36403 .5875 .35611 .58364 .34741 Mtetra
.573 .365 .56 r
.58364 .34741 .5875 .35611 .59032 .3503 .58645 .34162 Mtetra
.46 .312 .592 r
.58645 .34162 .59032 .3503 .59331 .34712 .58942 .33845 Mtetra
.268 .217 .613 r
.58942 .33845 .59331 .34712 .59648 .34671 .59258 .33802 Mtetra
.021 .088 .594 r
.59258 .33802 .59648 .34671 .59984 .34871 .5959 .33998 Mtetra
0 0 .546 r
.5959 .33998 .59984 .34871 .60333 .35238 .59937 .34358 Mtetra
0 0 .523 r
.59937 .34358 .60333 .35238 .60691 .35666 .60292 .3478 Mtetra
0 0 .547 r
.60292 .3478 .60691 .35666 .61049 .36038 .60646 .35146 Mtetra
.024 .09 .594 r
.60646 .35146 .61049 .36038 .61397 .36243 .60991 .35347 Mtetra
.268 .215 .611 r
.60991 .35347 .61397 .36243 .61728 .362 .6132 .35301 Mtetra
.457 .308 .589 r
.6132 .35301 .61728 .362 .62038 .35871 .61628 .34973 Mtetra
.569 .36 .557 r
.61628 .34973 .62038 .35871 .62326 .35273 .61916 .34378 Mtetra
.626 .386 .533 r
.61916 .34378 .62326 .35273 .62596 .34472 .62185 .33581 Mtetra
.65 .396 .521 r
.62185 .33581 .62596 .34472 .62855 .33569 .62445 .32684 Mtetra
.648 .395 .523 r
.62445 .32684 .62855 .33569 .63114 .32681 .62704 .31801 Mtetra
.619 .383 .537 r
.62704 .31801 .63114 .32681 .63383 .3192 .62973 .31045 Mtetra
.555 .354 .563 r
.62973 .31045 .63383 .3192 .6367 .31376 .6326 .30503 Mtetra
.432 .298 .597 r
.6326 .30503 .6367 .31376 .63983 .31098 .63572 .30225 Mtetra
.235 .202 .616 r
.63572 .30225 .63983 .31098 .64324 .31094 .6391 .30218 Mtetra
.001 .084 .597 r
.6391 .30218 .64324 .31094 .64691 .31324 .64274 .30444 Mtetra
0 0 .556 r
.64274 .30444 .64691 .31324 .65077 .31712 .64656 .30826 Mtetra
0 0 .54 r
.64656 .30826 .65077 .31712 .65472 .3215 .65048 .31257 Mtetra
0 .008 .564 r
.65048 .31257 .65472 .3215 .65865 .32521 .65436 .31622 Mtetra
.049 .108 .604 r
.65436 .31622 .65865 .32521 .66241 .32715 .6581 .31811 Mtetra
.279 .223 .613 r
.6581 .31811 .66241 .32715 .66592 .32656 .66158 .3175 Mtetra
.459 .308 .588 r
.66158 .3175 .66592 .32656 .66912 .3231 .66477 .31405 Mtetra
.567 .356 .554 r
.66477 .31405 .66912 .3231 .67202 .317 .66766 .30798 Mtetra
.622 .38 .529 r
.66766 .30798 .67202 .317 .67468 .30895 .67032 .29998 Mtetra
.644 .388 .517 r
.67032 .29998 .67468 .30895 .67721 .3 .67285 .29108 Mtetra
.639 .386 .52 r
.67285 .29108 .67721 .3 .67975 .29131 .6754 .28245 Mtetra
.606 .373 .537 r
.6754 .28245 .67975 .29131 .68244 .284 .67809 .27518 Mtetra
.534 .342 .567 r
.67809 .27518 .68244 .284 .68542 .27892 .68105 .27011 Mtetra
.403 .284 .602 r
.68105 .27011 .68542 .27892 .68874 .27652 .68436 .26771 Mtetra
.204 .19 .62 r
.68436 .26771 .68874 .27652 .69244 .27684 .68804 .268 Mtetra
0 .082 .601 r
.68804 .268 .69244 .27684 .69648 .27946 .69204 .27056 Mtetra
0 .006 .567 r
.69204 .27056 .69648 .27946 .70076 .28355 .69628 .27459 Mtetra
0 0 .557 r
.69628 .27459 .70076 .28355 .70515 .28803 .70062 .279 Mtetra
0 .032 .58 r
.70062 .279 .70515 .28803 .70946 .29172 .70489 .28263 Mtetra
.072 .124 .612 r
.70489 .28263 .70946 .29172 .71354 .29356 .70894 .28442 Mtetra
.289 .229 .615 r
.70894 .28442 .71354 .29356 .71727 .2928 .71264 .28363 Mtetra
.566 .368 .572 r
.27641 .70161 .27905 .71113 .2819 .70582 .27925 .69633 Mtetra
.639 .412 .557 r
.27925 .69633 .2819 .70582 .28506 .69765 .2824 .6882 Mtetra
.673 .432 .547 r
.2824 .6882 .28506 .69765 .28842 .68744 .28576 .67806 Mtetra
.686 .439 .543 r
.28576 .67806 .28842 .68744 .29187 .67638 .28921 .66707 Mtetra
.681 .436 .545 r
.28921 .66707 .29187 .67638 .29525 .66577 .29258 .65652 Mtetra
.657 .422 .553 r
.29258 .65652 .29525 .66577 .29844 .65681 .29577 .64762 Mtetra
.603 .391 .566 r
.29577 .64762 .29844 .65681 .30135 .6504 .29868 .64124 Mtetra
.493 .327 .583 r
.29868 .64124 .30135 .6504 .30395 .647 .30127 .63784 Mtetra
.276 .198 .584 r
.30127 .63784 .30395 .647 .30626 .64656 .30357 .63739 Mtetra
0 0 .522 r
.30357 .63739 .30626 .64656 .30833 .64856 .30562 .63935 Mtetra
0 0 .425 r
.30562 .63935 .30833 .64856 .31027 .65205 .30754 .6428 Mtetra
0 0 .405 r
.30754 .6428 .31027 .65205 .3122 .65582 .30946 .64651 Mtetra
0 0 .483 r
.30946 .64651 .3122 .65582 .31425 .65857 .31149 .64921 Mtetra
.156 .125 .569 r
.31149 .64921 .31425 .65857 .31651 .65918 .31374 .6498 Mtetra
.422 .284 .586 r
.31374 .6498 .31651 .65918 .31906 .65692 .31628 .64754 Mtetra
.567 .368 .571 r
.31628 .64754 .31906 .65692 .3219 .65156 .31911 .6422 Mtetra
.638 .409 .555 r
.31911 .6422 .3219 .65156 .32499 .64345 .32219 .63414 Mtetra
.671 .428 .544 r
.32219 .63414 .32499 .64345 .32823 .63346 .32544 .62421 Mtetra
.682 .434 .541 r
.32544 .62421 .32823 .63346 .33153 .62276 .32873 .61358 Mtetra
.675 .43 .543 r
.32873 .61358 .33153 .62276 .33476 .61263 .33196 .6035 Mtetra
.648 .415 .552 r
.33196 .6035 .33476 .61263 .33782 .6042 .33502 .59513 Mtetra
.588 .381 .568 r
.33502 .59513 .33782 .6042 .34066 .59833 .33785 .58929 Mtetra
.465 .31 .586 r
.33785 .58929 .34066 .59833 .34325 .59542 .34043 .58638 Mtetra
.234 .175 .584 r
.34043 .58638 .34325 .59542 .3456 .59538 .34277 .58631 Mtetra
0 0 .52 r
.34277 .58631 .3456 .59538 .34778 .59764 .34493 .58854 Mtetra
0 0 .434 r
.34493 .58854 .34778 .59764 .34987 .60125 .347 .5921 Mtetra
0 0 .425 r
.347 .5921 .34987 .60125 .35197 .60501 .34908 .5958 Mtetra
0 0 .502 r
.34908 .5958 .35197 .60501 .35417 .60765 .35127 .5984 Mtetra
.176 .141 .576 r
.35127 .5984 .35417 .60765 .35656 .60812 .35364 .59884 Mtetra
.429 .288 .587 r
.35364 .59884 .35656 .60812 .35917 .60571 .35624 .59644 Mtetra
.567 .367 .569 r
.35624 .59644 .35917 .60571 .36201 .60029 .35907 .59104 Mtetra
.636 .406 .552 r
.35907 .59104 .36201 .60029 .36503 .59225 .36209 .58304 Mtetra
.668 .424 .541 r
.36209 .58304 .36503 .59225 .36816 .58245 .36522 .57331 Mtetra
.678 .429 .538 r
.36522 .57331 .36816 .58245 .37132 .57209 .36837 .563 Mtetra
.669 .424 .541 r
.36837 .563 .37132 .57209 .37441 .56239 .37147 .55337 Mtetra
.638 .407 .552 r
.37147 .55337 .37441 .56239 .37738 .55447 .37443 .54549 Mtetra
.57 .369 .57 r
.37443 .54549 .37738 .55447 .38016 .54911 .37721 .54015 Mtetra
.435 .294 .589 r
.37721 .54015 .38016 .54911 .38276 .54666 .3798 .5377 Mtetra
.192 .154 .584 r
.3798 .5377 .38276 .54666 .3852 .54699 .38221 .53801 Mtetra
0 0 .519 r
.38221 .53801 .3852 .54699 .38751 .5495 .38451 .54048 Mtetra
0 0 .445 r
.38451 .54048 .38751 .5495 .38977 .55322 .38675 .54415 Mtetra
0 0 .446 r
.38675 .54415 .38977 .55322 .39205 .55696 .38901 .54784 Mtetra
0 0 .52 r
.38901 .54784 .39205 .55696 .39443 .5595 .39136 .55033 Mtetra
.195 .155 .583 r
.39136 .55033 .39443 .5595 .39694 .55981 .39386 .55062 Mtetra
.434 .292 .587 r
.39386 .55062 .39694 .55981 .39962 .55728 .39653 .54808 Mtetra
.568 .366 .567 r
.39653 .54808 .39962 .55728 .40245 .55178 .39936 .54261 Mtetra
.635 .403 .549 r
.39936 .54261 .40245 .55178 .40541 .54378 .40231 .53466 Mtetra
.665 .419 .538 r
.40231 .53466 .40541 .54378 .40844 .53417 .40534 .5251 Mtetra
.673 .423 .535 r
.40534 .5251 .40844 .53417 .41147 .52411 .40837 .51511 Mtetra
.662 .417 .539 r
.40837 .51511 .41147 .52411 .41445 .51483 .41135 .50588 Mtetra
.626 .398 .552 r
.41135 .50588 .41445 .51483 .41733 .50738 .41423 .49847 Mtetra
.551 .357 .572 r
.41423 .49847 .41733 .50738 .4201 .5025 .41698 .49361 Mtetra
.403 .277 .592 r
.41698 .49361 .4201 .5025 .42274 .50049 .41961 .4916 Mtetra
.152 .135 .584 r
.41961 .4916 .42274 .50049 .42528 .50117 .42214 .49225 Mtetra
0 0 .52 r
.42214 .49225 .42528 .50117 .42775 .50391 .42459 .49495 Mtetra
0 0 .458 r
.42459 .49495 .42775 .50391 .43021 .50774 .42703 .49872 Mtetra
0 0 .467 r
.42703 .49872 .43021 .50774 .4327 .51147 .42949 .5024 Mtetra
0 .002 .537 r
.42949 .5024 .4327 .51147 .43525 .5139 .43202 .50479 Mtetra
.212 .168 .589 r
.43202 .50479 .43525 .5139 .4379 .51406 .43466 .50492 Mtetra
.439 .295 .587 r
.43466 .50492 .4379 .51406 .44065 .51139 .43739 .50225 Mtetra
.568 .364 .565 r
.43739 .50225 .44065 .51139 .44349 .50582 .44022 .4967 Mtetra
.633 .399 .546 r
.44022 .4967 .44349 .50582 .44639 .49785 .44312 .48878 Mtetra
.662 .414 .535 r
.44312 .48878 .44639 .49785 .44931 .4884 .44605 .47939 Mtetra
.668 .417 .532 r
.44605 .47939 .44931 .4884 .45223 .47863 .44897 .46968 Mtetra
.654 .41 .538 r
.44897 .46968 .45223 .47863 .45511 .46973 .45185 .46083 Mtetra
.613 .389 .552 r
.45185 .46083 .45511 .46973 .45794 .46273 .45467 .45387 Mtetra
.529 .345 .575 r
.45467 .45387 .45794 .46273 .46071 .4583 .45743 .44946 Mtetra
.37 .259 .596 r
.45743 .44946 .46071 .4583 .46342 .45671 .46013 .44786 Mtetra
.115 .118 .584 r
.46013 .44786 .46342 .45671 .4661 .45772 .46279 .44884 Mtetra
0 0 .523 r
.46279 .44884 .4661 .45772 .46877 .46069 .46544 .45176 Mtetra
0 0 .473 r
.46544 .45176 .46877 .46069 .47145 .46462 .46809 .45564 Mtetra
0 0 .488 r
.46809 .45564 .47145 .46462 .47416 .46834 .47078 .45929 Mtetra
0 .025 .552 r
.47078 .45929 .47416 .46834 .47691 .47066 .47351 .46158 Mtetra
.228 .18 .594 r
.47351 .46158 .47691 .47066 .4797 .47067 .47628 .46156 Mtetra
.444 .297 .587 r
.47628 .46156 .4797 .47067 .48253 .46785 .47909 .45874 Mtetra
.567 .362 .563 r
.47909 .45874 .48253 .46785 .48537 .4622 .48193 .45312 Mtetra
.63 .395 .542 r
.48193 .45312 .48537 .4622 .48822 .45425 .48477 .44522 Mtetra
.658 .409 .531 r
.48477 .44522 .48822 .45425 .49105 .44494 .48761 .43596 Mtetra
.663 .411 .529 r
.48761 .43596 .49105 .44494 .49387 .43544 .49042 .42652 Mtetra
.645 .402 .536 r
.49042 .42652 .49387 .43544 .49667 .4269 .49323 .41804 Mtetra
.599 .379 .553 r
.49323 .41804 .49667 .4269 .49946 .42033 .49602 .41149 Mtetra
.506 .332 .579 r
.49602 .41149 .49946 .42033 .50227 .41634 .49881 .40751 Mtetra
.336 .242 .599 r
.49881 .40751 .50227 .41634 .50509 .41514 .50161 .40631 Mtetra
.081 .104 .584 r
.50161 .40631 .50509 .41514 .50794 .41648 .50445 .40761 Mtetra
0 0 .528 r
.50445 .40761 .50794 .41648 .51084 .41967 .50732 .41075 Mtetra
0 0 .488 r
.50732 .41075 .51084 .41967 .51377 .4237 .51022 .41471 Mtetra
0 0 .507 r
.51022 .41471 .51377 .4237 .51673 .42739 .51315 .41835 Mtetra
0 .047 .565 r
.51315 .41835 .51673 .42739 .51969 .42961 .51609 .42053 Mtetra
.242 .191 .598 r
.51609 .42053 .51969 .42961 .52264 .42947 .51902 .42036 Mtetra
.447 .299 .586 r
.51902 .42036 .52264 .42947 .52554 .4265 .52191 .41739 Mtetra
.566 .36 .56 r
.52191 .41739 .52554 .4265 .52839 .42076 .52475 .41168 Mtetra
.627 .39 .539 r
.52475 .41168 .52839 .42076 .53119 .41282 .52754 .40379 Mtetra
.654 .403 .527 r
.52754 .40379 .53119 .41282 .53393 .40364 .53029 .39466 Mtetra
.656 .404 .526 r
.53029 .39466 .53393 .40364 .53666 .39437 .53302 .38546 Mtetra
.636 .394 .535 r
.53302 .38546 .53666 .39437 .5394 .38618 .53577 .37732 Mtetra
.584 .369 .555 r
.53577 .37732 .5394 .38618 .54219 .38001 .53855 .37117 Mtetra
.482 .318 .582 r
.53855 .37117 .54219 .38001 .54506 .37644 .54141 .36761 Mtetra
.301 .226 .602 r
.54141 .36761 .54506 .37644 .54803 .37563 .54435 .36678 Mtetra
.052 .093 .586 r
.54435 .36678 .54803 .37563 .5511 .37728 .5474 .3684 Mtetra
0 0 .535 r
.5474 .3684 .5511 .37728 .55426 .38068 .55053 .37174 Mtetra
0 0 .504 r
.55053 .37174 .55426 .38068 .55748 .3848 .55372 .3758 Mtetra
0 0 .526 r
.55372 .3758 .55748 .3848 .56071 .38848 .55692 .37942 Mtetra
.005 .068 .577 r
.55692 .37942 .56071 .38848 .56391 .39059 .56009 .38149 Mtetra
.255 .201 .601 r
.56009 .38149 .56391 .39059 .56702 .3903 .56318 .38117 Mtetra
.45 .3 .585 r
.56318 .38117 .56702 .3903 .57001 .38717 .56616 .37805 Mtetra
.565 .357 .557 r
.56616 .37805 .57001 .38717 .57287 .38133 .56901 .37224 Mtetra
.624 .385 .535 r
.56901 .37224 .57287 .38133 .57561 .37339 .57176 .36434 Mtetra
.649 .396 .523 r
.57176 .36434 .57561 .37339 .57828 .36431 .57443 .35532 Mtetra
.649 .397 .523 r
.57443 .35532 .57828 .36431 .58094 .35528 .57708 .34635 Mtetra
.625 .385 .534 r
.57708 .34635 .58094 .35528 .58364 .34741 .57978 .33853 Mtetra
.567 .358 .557 r
.57978 .33853 .58364 .34741 .58645 .34162 .58259 .33276 Mtetra
.455 .304 .587 r
.58259 .33276 .58645 .34162 .58942 .33845 .58555 .3296 Mtetra
.267 .21 .606 r
.58555 .3296 .58942 .33845 .59258 .33802 .58868 .32914 Mtetra
.027 .086 .588 r
.58868 .32914 .59258 .33802 .5959 .33998 .59198 .33105 Mtetra
0 0 .543 r
.59198 .33105 .5959 .33998 .59937 .34358 .59542 .3346 Mtetra
0 0 .521 r
.59542 .3346 .59937 .34358 .60292 .3478 .59893 .33876 Mtetra
0 0 .544 r
.59893 .33876 .60292 .3478 .60646 .35146 .60243 .34236 Mtetra
.031 .087 .588 r
.60243 .34236 .60646 .35146 .60991 .35347 .60586 .34432 Mtetra
.267 .209 .604 r
.60586 .34432 .60991 .35347 .6132 .35301 .60913 .34384 Mtetra
.452 .301 .584 r
.60913 .34384 .6132 .35301 .61628 .34973 .6122 .34056 Mtetra
.563 .353 .554 r
.6122 .34056 .61628 .34973 .61916 .34378 .61506 .33464 Mtetra
.62 .379 .531 r
.61506 .33464 .61916 .34378 .62185 .33581 .61776 .32672 Mtetra
.644 .39 .519 r
.61776 .32672 .62185 .33581 .62445 .32684 .62036 .3178 Mtetra
.642 .389 .52 r
.62036 .3178 .62445 .32684 .62704 .31801 .62295 .30903 Mtetra
.613 .376 .534 r
.62295 .30903 .62704 .31801 .62973 .31045 .62564 .30152 Mtetra
.548 .347 .56 r
.62564 .30152 .62973 .31045 .6326 .30503 .6285 .29612 Mtetra
.427 .29 .591 r
.6285 .29612 .6326 .30503 .63572 .30225 .6316 .29334 Mtetra
.235 .197 .609 r
.6316 .29334 .63572 .30225 .6391 .30218 .63496 .29324 Mtetra
.008 .081 .591 r
.63496 .29324 .6391 .30218 .64274 .30444 .63857 .29546 Mtetra
0 0 .553 r
.63857 .29546 .64274 .30444 .64656 .30826 .64236 .29921 Mtetra
0 0 .538 r
.64236 .29921 .64656 .30826 .65048 .31257 .64623 .30345 Mtetra
0 .008 .561 r
.64623 .30345 .65048 .31257 .65436 .31622 .65008 .30703 Mtetra
.054 .104 .597 r
.65008 .30703 .65436 .31622 .6581 .31811 .65378 .30889 Mtetra
.278 .216 .606 r
.65378 .30889 .6581 .31811 .66158 .3175 .65725 .30825 Mtetra
.454 .3 .582 r
.65725 .30825 .66158 .3175 .66477 .31405 .66042 .3048 Mtetra
.561 .349 .55 r
.66042 .3048 .66477 .31405 .66766 .30798 .6633 .29876 Mtetra
.616 .373 .526 r
.6633 .29876 .66766 .30798 .67032 .29998 .66596 .29081 Mtetra
.638 .382 .515 r
.66596 .29081 .67032 .29998 .67285 .29108 .6685 .28197 Mtetra
.633 .38 .518 r
.6685 .28197 .67285 .29108 .6754 .28245 .67104 .27339 Mtetra
.6 .366 .534 r
.67104 .27339 .6754 .28245 .67809 .27518 .67374 .26616 Mtetra
.528 .335 .563 r
.67374 .26616 .67809 .27518 .68105 .27011 .67669 .26112 Mtetra
.399 .277 .596 r
.67669 .26112 .68105 .27011 .68436 .26771 .67998 .25871 Mtetra
.204 .185 .613 r
.67998 .25871 .68436 .26771 .68804 .268 .68363 .25897 Mtetra
0 .08 .595 r
.68363 .25897 .68804 .268 .69204 .27056 .68759 .26148 Mtetra
0 .006 .564 r
.68759 .26148 .69204 .27056 .69628 .27459 .69179 .26544 Mtetra
0 0 .554 r
.69179 .26544 .69628 .27459 .70062 .279 .69609 .26978 Mtetra
0 .031 .576 r
.69609 .26978 .70062 .279 .70489 .28263 .70032 .27334 Mtetra
.076 .121 .606 r
.70032 .27334 .70489 .28263 .70894 .28442 .70434 .27508 Mtetra
.287 .223 .608 r
.70434 .27508 .70894 .28442 .71264 .28363 .70801 .27428 Mtetra
.588 .394 .586 r
.27366 .69319 .27641 .70161 .27925 .69633 .27649 .68792 Mtetra
.659 .433 .566 r
.27649 .68792 .27925 .69633 .2824 .6882 .27964 .67984 Mtetra
.691 .451 .554 r
.27964 .67984 .2824 .6882 .28576 .67806 .28301 .66974 Mtetra
.703 .457 .549 r
.28301 .66974 .28576 .67806 .28921 .66707 .28645 .65881 Mtetra
.698 .455 .551 r
.28645 .65881 .28921 .66707 .29258 .65652 .28983 .64832 Mtetra
.676 .443 .56 r
.28983 .64832 .29258 .65652 .29577 .64762 .29302 .63946 Mtetra
.625 .415 .577 r
.29302 .63946 .29577 .64762 .29868 .64124 .29592 .63311 Mtetra
.515 .354 .601 r
.29592 .63311 .29868 .64124 .30127 .63784 .29851 .62972 Mtetra
.282 .222 .611 r
.29851 .62972 .30127 .63784 .30357 .63739 .30079 .62925 Mtetra
0 0 .54 r
.30079 .62925 .30357 .63739 .30562 .63935 .30283 .63118 Mtetra
0 0 .419 r
.30283 .63118 .30562 .63935 .30754 .6428 .30473 .63458 Mtetra
0 0 .394 r
.30473 .63458 .30754 .6428 .30946 .64651 .30663 .63825 Mtetra
0 0 .491 r
.30663 .63825 .30946 .64651 .31149 .64921 .30864 .64092 Mtetra
.147 .142 .595 r
.30864 .64092 .31149 .64921 .31374 .6498 .31088 .64149 Mtetra
.441 .312 .608 r
.31088 .64149 .31374 .6498 .31628 .64754 .31341 .63922 Mtetra
.589 .394 .584 r
.31341 .63922 .31628 .64754 .31911 .6422 .31624 .6339 Mtetra
.658 .431 .564 r
.31624 .6339 .31911 .6422 .32219 .63414 .31932 .62588 Mtetra
.69 .447 .551 r
.31932 .62588 .32219 .63414 .32544 .62421 .32256 .616 Mtetra
.7 .453 .547 r
.32256 .616 .32544 .62421 .32873 .61358 .32586 .60543 Mtetra
.693 .449 .55 r
.32586 .60543 .32873 .61358 .33196 .6035 .32909 .5954 Mtetra
.668 .436 .56 r
.32909 .5954 .33196 .6035 .33502 .59513 .33215 .58707 Mtetra
.609 .405 .58 r
.33215 .58707 .33502 .59513 .33785 .58929 .33497 .58125 Mtetra
.486 .338 .606 r
.33497 .58125 .33785 .58929 .34043 .58638 .33754 .57834 Mtetra
.234 .198 .611 r
.33754 .57834 .34043 .58638 .34277 .58631 .33987 .57826 Mtetra
0 0 .535 r
.33987 .57826 .34277 .58631 .34493 .58854 .34202 .58045 Mtetra
0 0 .428 r
.34202 .58045 .34493 .58854 .347 .5921 .34407 .58397 Mtetra
0 0 .418 r
.34407 .58397 .347 .5921 .34908 .5958 .34613 .58763 Mtetra
0 0 .514 r
.34613 .58763 .34908 .5958 .35127 .5984 .3483 .59019 Mtetra
.17 .16 .603 r
.3483 .59019 .35127 .5984 .35364 .59884 .35066 .59061 Mtetra
.448 .316 .608 r
.35066 .59061 .35364 .59884 .35624 .59644 .35325 .5882 Mtetra
.59 .393 .583 r
.35325 .5882 .35624 .59644 .35907 .59104 .35607 .58282 Mtetra
.657 .428 .561 r
.35607 .58282 .35907 .59104 .36209 .58304 .35909 .57486 Mtetra
.687 .444 .548 r
.35909 .57486 .36209 .58304 .36522 .57331 .36222 .56518 Mtetra
.696 .448 .544 r
.36222 .56518 .36522 .57331 .36837 .563 .36538 .55493 Mtetra
.688 .444 .548 r
.36538 .55493 .36837 .563 .37147 .55337 .36847 .54535 Mtetra
.658 .429 .561 r
.36847 .54535 .37147 .55337 .37443 .54549 .37143 .53751 Mtetra
.592 .395 .583 r
.37143 .53751 .37443 .54549 .37721 .54015 .37421 .53219 Mtetra
.454 .322 .61 r
.37421 .53219 .37721 .54015 .3798 .5377 .37679 .52974 Mtetra
.187 .175 .611 r
.37679 .52974 .3798 .5377 .38221 .53801 .37919 .53002 Mtetra
0 0 .532 r
.37919 .53002 .38221 .53801 .38451 .54048 .38147 .53245 Mtetra
0 0 .441 r
.38147 .53245 .38451 .54048 .38675 .54415 .38369 .53608 Mtetra
0 0 .442 r
.38369 .53608 .38675 .54415 .38901 .54784 .38593 .53972 Mtetra
0 0 .534 r
.38593 .53972 .38901 .54784 .39136 .55033 .38827 .54218 Mtetra
.191 .176 .61 r
.38827 .54218 .39136 .55033 .39386 .55062 .39075 .54245 Mtetra
.454 .32 .609 r
.39075 .54245 .39386 .55062 .39653 .54808 .39341 .53991 Mtetra
.59 .392 .581 r
.39341 .53991 .39653 .54808 .39936 .54261 .39623 .53446 Mtetra
.656 .425 .558 r
.39623 .53446 .39936 .54261 .40231 .53466 .39918 .52654 Mtetra
.685 .439 .545 r
.39918 .52654 .40231 .53466 .40534 .5251 .40221 .51704 Mtetra
.693 .443 .541 r
.40221 .51704 .40534 .5251 .40837 .51511 .40525 .5071 Mtetra
.682 .438 .546 r
.40525 .5071 .40837 .51511 .41135 .50588 .40822 .49792 Mtetra
.647 .421 .561 r
.40822 .49792 .41135 .50588 .41423 .49847 .4111 .49055 Mtetra
.573 .384 .587 r
.4111 .49055 .41423 .49847 .41698 .49361 .41385 .4857 Mtetra
.42 .304 .615 r
.41385 .4857 .41698 .49361 .41961 .4916 .41647 .48368 Mtetra
.142 .153 .61 r
.41647 .48368 .41961 .4916 .42214 .49225 .41898 .48431 Mtetra
0 0 .532 r
.41898 .48431 .42214 .49225 .42459 .49495 .42141 .48697 Mtetra
0 0 .455 r
.42141 .48697 .42459 .49495 .42703 .49872 .42383 .49069 Mtetra
0 0 .466 r
.42383 .49069 .42703 .49872 .42949 .5024 .42627 .49432 Mtetra
0 .004 .553 r
.42627 .49432 .42949 .5024 .43202 .50479 .42878 .49667 Mtetra
.21 .19 .616 r
.42878 .49667 .43202 .50479 .43466 .50492 .4314 .49679 Mtetra
.459 .323 .608 r
.4314 .49679 .43466 .50492 .43739 .50225 .43412 .49411 Mtetra
.59 .39 .578 r
.43412 .49411 .43739 .50225 .44022 .4967 .43695 .48859 Mtetra
.654 .421 .555 r
.43695 .48859 .44022 .4967 .44312 .48878 .43985 .48071 Mtetra
.682 .435 .542 r
.43985 .48071 .44312 .48878 .44605 .47939 .44278 .47136 Mtetra
.688 .438 .539 r
.44278 .47136 .44605 .47939 .44897 .46968 .4457 .4617 Mtetra
.675 .431 .545 r
.4457 .4617 .44897 .46968 .45185 .46083 .44858 .45291 Mtetra
.635 .413 .563 r
.44858 .45291 .45185 .46083 .45467 .45387 .4514 .44597 Mtetra
.552 .372 .591 r
.4514 .44597 .45467 .45387 .45743 .44946 .45415 .44158 Mtetra
.384 .287 .62 r
.45415 .44158 .45743 .44946 .46013 .44786 .45684 .43997 Mtetra
.1 .134 .61 r
.45684 .43997 .46013 .44786 .46279 .44884 .45948 .44092 Mtetra
0 0 .534 r
.45948 .44092 .46279 .44884 .46544 .45176 .46211 .4438 Mtetra
0 0 .471 r
.46211 .4438 .46544 .45176 .46809 .45564 .46474 .44763 Mtetra
0 0 .49 r
.46474 .44763 .46809 .45564 .47078 .45929 .4674 .45123 Mtetra
0 .03 .57 r
.4674 .45123 .47078 .45929 .47351 .46158 .47011 .45348 Mtetra
.228 .203 .621 r
.47011 .45348 .47351 .46158 .47628 .46156 .47287 .45345 Mtetra
.463 .325 .608 r
.47287 .45345 .47628 .46156 .47909 .45874 .47567 .45062 Mtetra
.59 .388 .576 r
.47567 .45062 .47909 .45874 .48193 .45312 .4785 .44502 Mtetra
.652 .418 .551 r
.4785 .44502 .48193 .45312 .48477 .44522 .48134 .43716 Mtetra
.679 .43 .538 r
.48134 .43716 .48477 .44522 .48761 .43596 .48418 .42796 Mtetra
.683 .432 .536 r
.48418 .42796 .48761 .43596 .49042 .42652 .487 .41856 Mtetra
.667 .424 .544 r
.487 .41856 .49042 .42652 .49323 .41804 .4898 .41012 Mtetra
.622 .404 .565 r
.4898 .41012 .49323 .41804 .49602 .41149 .49259 .40361 Mtetra
.528 .359 .596 r
.49259 .40361 .49602 .41149 .49881 .40751 .49537 .39964 Mtetra
.347 .269 .624 r
.49537 .39964 .49881 .40751 .50161 .40631 .49816 .39842 Mtetra
.062 .118 .609 r
.49816 .39842 .50161 .40631 .50445 .40761 .50098 .39969 Mtetra
0 0 .538 r
.50098 .39969 .50445 .40761 .50732 .41075 .50383 .40278 Mtetra
0 0 .489 r
.50383 .40278 .50732 .41075 .51022 .41471 .5067 .4067 Mtetra
0 0 .513 r
.5067 .4067 .51022 .41471 .51315 .41835 .50961 .41029 Mtetra
0 .054 .585 r
.50961 .41029 .51315 .41835 .51609 .42053 .51253 .41243 Mtetra
.244 .214 .625 r
.51253 .41243 .51609 .42053 .51902 .42036 .51543 .41224 Mtetra
.467 .327 .607 r
.51543 .41224 .51902 .42036 .52191 .41739 .51831 .40927 Mtetra
.589 .386 .573 r
.51831 .40927 .52191 .41739 .52475 .41168 .52115 .40358 Mtetra
.65 .413 .548 r
.52115 .40358 .52475 .41168 .52754 .40379 .52394 .39573 Mtetra
.675 .425 .535 r
.52394 .39573 .52754 .40379 .53029 .39466 .5267 .38665 Mtetra
.678 .426 .533 r
.5267 .38665 .53029 .39466 .53302 .38546 .52943 .3775 Mtetra
.658 .417 .544 r
.52943 .3775 .53302 .38546 .53577 .37732 .53217 .3694 Mtetra
.607 .394 .567 r
.53217 .3694 .53577 .37732 .53855 .37117 .53495 .36328 Mtetra
.503 .346 .601 r
.53495 .36328 .53855 .37117 .54141 .36761 .5378 .35972 Mtetra
.309 .251 .629 r
.5378 .35972 .54141 .36761 .54435 .36678 .54073 .35888 Mtetra
.03 .106 .61 r
.54073 .35888 .54435 .36678 .5474 .3684 .54376 .36046 Mtetra
0 0 .545 r
.54376 .36046 .5474 .3684 .55053 .37174 .54686 .36376 Mtetra
0 0 .507 r
.54686 .36376 .55053 .37174 .55372 .3758 .55002 .36776 Mtetra
0 0 .534 r
.55002 .36776 .55372 .3758 .55692 .37942 .5532 .37133 Mtetra
0 .077 .599 r
.5532 .37133 .55692 .37942 .56009 .38149 .55634 .37336 Mtetra
.259 .224 .628 r
.55634 .37336 .56009 .38149 .56318 .38117 .55941 .37302 Mtetra
.47 .328 .606 r
.55941 .37302 .56318 .38117 .56616 .37805 .56238 .3699 Mtetra
.588 .383 .57 r
.56238 .3699 .56616 .37805 .56901 .37224 .56522 .36411 Mtetra
.647 .409 .544 r
.56522 .36411 .56901 .37224 .57176 .36434 .56797 .35625 Mtetra
.671 .419 .531 r
.56797 .35625 .57176 .36434 .57443 .35532 .57064 .34729 Mtetra
.57064 .34729 .57443 .35532 .57708 .34635 .5733 .33836 Mtetra
.648 .409 .544 r
.5733 .33836 .57708 .34635 .57978 .33853 .57601 .33058 Mtetra
.59 .384 .57 r
.57601 .33058 .57978 .33853 .58259 .33276 .57881 .32484 Mtetra
.475 .332 .607 r
.57881 .32484 .58259 .33276 .58555 .3296 .58175 .32168 Mtetra
.272 .235 .633 r
.58175 .32168 .58555 .3296 .58868 .32914 .58487 .3212 Mtetra
.003 .097 .611 r
.58487 .3212 .58868 .32914 .59198 .33105 .58814 .32308 Mtetra
0 0 .554 r
.58814 .32308 .59198 .33105 .59542 .3346 .59155 .32657 Mtetra
0 0 .526 r
.59155 .32657 .59542 .3346 .59893 .33876 .59503 .33067 Mtetra
0 0 .555 r
.59503 .33067 .59893 .33876 .60243 .34236 .5985 .33422 Mtetra
.006 .098 .611 r
.5985 .33422 .60243 .34236 .60586 .34432 .6019 .33614 Mtetra
.272 .233 .631 r
.6019 .33614 .60586 .34432 .60913 .34384 .60515 .33564 Mtetra
.472 .329 .604 r
.60515 .33564 .60913 .34384 .6122 .34056 .60821 .33236 Mtetra
.587 .379 .567 r
.60821 .33236 .6122 .34056 .61506 .33464 .61107 .32647 Mtetra
.644 .403 .54 r
.61107 .32647 .61506 .33464 .61776 .32672 .61377 .31859 Mtetra
.666 .412 .527 r
.61377 .31859 .61776 .32672 .62036 .3178 .61637 .30972 Mtetra
.664 .412 .528 r
.61637 .30972 .62036 .3178 .62295 .30903 .61897 .301 Mtetra
.637 .401 .544 r
.61897 .301 .62295 .30903 .62564 .30152 .62165 .29352 Mtetra
.572 .374 .574 r
.62165 .29352 .62564 .30152 .6285 .29612 .62451 .28814 Mtetra
.446 .318 .613 r
.62451 .28814 .6285 .29612 .6316 .29334 .6276 .28536 Mtetra
.235 .219 .636 r
.6276 .28536 .6316 .29334 .63496 .29324 .63094 .28524 Mtetra
0 .092 .613 r
.63094 .28524 .63496 .29324 .63857 .29546 .63451 .28741 Mtetra
0 0 .564 r
.63451 .28741 .63857 .29546 .64236 .29921 .63827 .29111 Mtetra
0 0 .544 r
.63827 .29111 .64236 .29921 .64623 .30345 .64211 .2953 Mtetra
0 .01 .573 r
.64211 .2953 .64623 .30345 .65008 .30703 .64592 .29882 Mtetra
.033 .118 .621 r
.64592 .29882 .65008 .30703 .65378 .30889 .6496 .30063 Mtetra
.283 .241 .633 r
.6496 .30063 .65378 .30889 .65725 .30825 .65304 .29997 Mtetra
.474 .329 .603 r
.65304 .29997 .65725 .30825 .66042 .3048 .6562 .29653 Mtetra
.585 .375 .564 r
.6562 .29653 .66042 .3048 .6633 .29876 .65908 .29052 Mtetra
.64 .398 .536 r
.65908 .29052 .6633 .29876 .66596 .29081 .66174 .28261 Mtetra
.661 .406 .523 r
.66174 .28261 .66596 .29081 .6685 .28197 .66428 .27382 Mtetra
.656 .404 .526 r
.66428 .27382 .6685 .28197 .67104 .27339 .66683 .26529 Mtetra
.624 .392 .545 r
.66683 .26529 .67104 .27339 .67374 .26616 .66952 .25809 Mtetra
.551 .363 .578 r
.66952 .25809 .67374 .26616 .67669 .26112 .67247 .25306 Mtetra
.415 .304 .619 r
.67247 .25306 .67669 .26112 .67998 .25871 .67574 .25065 Mtetra
.202 .206 .64 r
.67574 .25065 .67998 .25871 .68363 .25897 .67936 .25089 Mtetra
0 .09 .616 r
.67936 .25089 .68363 .25897 .68759 .26148 .6833 .25335 Mtetra
0 .008 .575 r
.6833 .25335 .68759 .26148 .69179 .26544 .68746 .25725 Mtetra
0 0 .563 r
.68746 .25725 .69179 .26544 .69609 .26978 .69171 .26152 Mtetra
0 .035 .591 r
.69171 .26152 .69609 .26978 .70032 .27334 .69591 .26503 Mtetra
.058 .136 .63 r
.69591 .26503 .70032 .27334 .70434 .27508 .69989 .26673 Mtetra
.294 .248 .634 r
.69989 .26673 .70434 .27508 .70801 .27428 .70355 .2659 Mtetra
.643 .459 .619 r
.27068 .68695 .27366 .69319 .27649 .68792 .27351 .6817 Mtetra
.706 .485 .586 r
.27351 .6817 .27649 .68792 .27964 .67984 .27666 .67363 Mtetra
.733 .496 .569 r
.27666 .67363 .27964 .67984 .28301 .66974 .28003 .66358 Mtetra
.742 .499 .562 r
.28003 .66358 .28301 .66974 .28645 .65881 .28348 .65268 Mtetra
.739 .498 .565 r
.28348 .65268 .28645 .65881 .28983 .64832 .28686 .64223 Mtetra
.72 .491 .577 r
.28686 .64223 .28983 .64832 .29302 .63946 .29005 .6334 Mtetra
.676 .473 .604 r
.29005 .6334 .29302 .63946 .29592 .63311 .29295 .62706 Mtetra
.571 .428 .648 r
.29295 .62706 .29592 .63311 .29851 .62972 .29553 .62367 Mtetra
.299 .296 .688 r
.29553 .62367 .29851 .62972 .30079 .62925 .29781 .6232 Mtetra
0 .006 .578 r
.29781 .6232 .30079 .62925 .30283 .63118 .29983 .62511 Mtetra
0 0 .373 r
.29983 .62511 .30283 .63118 .30473 .63458 .30172 .62848 Mtetra
0 0 .336 r
.30172 .62848 .30473 .63458 .30663 .63825 .3036 .63211 Mtetra
0 0 .491 r
.3036 .63211 .30663 .63825 .30864 .64092 .30561 .63475 Mtetra
.116 .198 .673 r
.30561 .63475 .30864 .64092 .31088 .64149 .30783 .6353 Mtetra
.492 .391 .667 r
.30783 .6353 .31088 .64149 .31341 .63922 .31036 .63303 Mtetra
.644 .459 .617 r
.31036 .63303 .31341 .63922 .31624 .6339 .31318 .62773 Mtetra
.706 .483 .584 r
.31318 .62773 .31624 .6339 .31932 .62588 .31626 .61973 Mtetra
.732 .493 .566 r
.31626 .61973 .31932 .62588 .32256 .616 .31951 .60989 Mtetra
.741 .496 .56 r
.31951 .60989 .32256 .616 .32586 .60543 .32281 .59935 Mtetra
.736 .494 .564 r
.32281 .59935 .32586 .60543 .32909 .5954 .32604 .58936 Mtetra
.714 .486 .579 r
.32604 .58936 .32909 .5954 .33215 .58707 .32911 .58106 Mtetra
.663 .467 .609 r
.32911 .58106 .33215 .58707 .33497 .58125 .33193 .57525 Mtetra
.54 .415 .658 r
.33193 .57525 .33497 .58125 .33754 .57834 .3345 .57235 Mtetra
.236 .266 .69 r
.3345 .57235 .33754 .57834 .33987 .57826 .33681 .57225 Mtetra
0 0 .563 r
.33681 .57225 .33987 .57826 .34202 .58045 .33895 .57442 Mtetra
0 0 .386 r
.33895 .57442 .34202 .58045 .34407 .58397 .34098 .5779 Mtetra
0 0 .37 r
.34098 .5779 .34407 .58397 .34613 .58763 .34303 .58153 Mtetra
0 0 .525 r
.34303 .58153 .34613 .58763 .3483 .59019 .34518 .58406 Mtetra
.148 .219 .682 r
.34518 .58406 .3483 .59019 .35066 .59061 .34753 .58446 Mtetra
.499 .395 .667 r
.34753 .58446 .35066 .59061 .35325 .5882 .35011 .58206 Mtetra
.645 .458 .615 r
.35011 .58206 .35325 .5882 .35607 .58282 .35293 .57669 Mtetra
.706 .481 .581 r
.35293 .57669 .35607 .58282 .35909 .57486 .35595 .56875 Mtetra
.731 .49 .563 r
.35595 .56875 .35909 .57486 .36222 .56518 .35909 .55911 Mtetra
.739 .493 .558 r
.35909 .55911 .36222 .56518 .36538 .55493 .36225 .5489 Mtetra
.732 .491 .563 r
.36225 .5489 .36538 .55493 .36847 .54535 .36535 .53934 Mtetra
.707 .482 .581 r
.36535 .53934 .36847 .54535 .37143 .53751 .36831 .53153 Mtetra
.647 .459 .615 r
.36831 .53153 .37143 .53751 .37421 .53219 .37108 .52622 Mtetra
.506 .4 .668 r
.37108 .52622 .37421 .53219 .37679 .52974 .37366 .52377 Mtetra
.173 .237 .689 r
.37366 .52377 .37679 .52974 .37919 .53002 .37605 .52403 Mtetra
0 0 .553 r
.37605 .52403 .37919 .53002 .38147 .53245 .37831 .52644 Mtetra
0 0 .402 r
.37831 .52644 .38147 .53245 .38369 .53608 .38051 .53003 Mtetra
0 0 .404 r
.38051 .53003 .38369 .53608 .38593 .53972 .38274 .53364 Mtetra
0 0 .557 r
.38274 .53364 .38593 .53972 .38827 .54218 .38506 .53607 Mtetra
.177 .238 .689 r
.38506 .53607 .38827 .54218 .39075 .54245 .38753 .53633 Mtetra
.506 .398 .666 r
.38753 .53633 .39075 .54245 .39341 .53991 .39018 .53378 Mtetra
.646 .457 .613 r
.39018 .53378 .39341 .53991 .39623 .53446 .393 .52835 Mtetra
.705 .479 .578 r
.393 .52835 .39623 .53446 .39918 .52654 .39596 .52046 Mtetra
.73 .488 .56 r
.39596 .52046 .39918 .52654 .40221 .51704 .39899 .51099 Mtetra
.737 .49 .555 r
.39899 .51099 .40221 .51704 .40525 .5071 .40203 .50108 Mtetra
.728 .487 .562 r
.40203 .50108 .40525 .5071 .40822 .49792 .40501 .49193 Mtetra
.698 .477 .583 r
.40501 .49193 .40822 .49792 .4111 .49055 .40789 .48458 Mtetra
.63 .451 .623 r
.40789 .48458 .4111 .49055 .41385 .4857 .41064 .47975 Mtetra
.467 .383 .677 r
.41064 .47975 .41385 .4857 .41647 .48368 .41325 .47772 Mtetra
.111 .208 .686 r
.41325 .47772 .41647 .48368 .41898 .48431 .41575 .47833 Mtetra
0 0 .547 r
.41575 .47833 .41898 .48431 .42141 .48697 .41816 .48096 Mtetra
0 0 .422 r
.41816 .48096 .42141 .48697 .42383 .49069 .42056 .48466 Mtetra
0 0 .439 r
.42056 .48466 .42383 .49069 .42627 .49432 .42298 .48825 Mtetra
0 .011 .585 r
.42298 .48825 .42627 .49432 .42878 .49667 .42548 .49058 Mtetra
.203 .255 .694 r
.42548 .49058 .42878 .49667 .4314 .49679 .42808 .49068 Mtetra
.511 .401 .665 r
.42808 .49068 .4314 .49679 .43412 .49411 .4308 .488 Mtetra
.647 .456 .611 r
.4308 .488 .43412 .49411 .43695 .48859 .43362 .48249 Mtetra
.705 .476 .575 r
.43362 .48249 .43695 .48859 .43985 .48071 .43652 .47463 Mtetra
.729 .484 .557 r
.43652 .47463 .43985 .48071 .44278 .47136 .43946 .46532 Mtetra
.734 .486 .553 r
.43946 .46532 .44278 .47136 .4457 .4617 .44239 .45569 Mtetra
.723 .482 .562 r
.44239 .45569 .4457 .4617 .44858 .45291 .44527 .44693 Mtetra
.688 .471 .587 r
.44527 .44693 .44858 .45291 .4514 .44597 .44809 .44001 Mtetra
.609 .442 .631 r
.44809 .44001 .4514 .44597 .45415 .44158 .45084 .43563 Mtetra
.425 .365 .687 r
.45084 .43563 .45415 .44158 .45684 .43997 .45352 .43401 Mtetra
.055 .183 .681 r
.45352 .43401 .45684 .43997 .45948 .44092 .45615 .43494 Mtetra
0 0 .545 r
.45615 .43494 .45948 .44092 .46211 .4438 .45876 .43779 Mtetra
0 0 .444 r
.45876 .43779 .46211 .4438 .46474 .44763 .46137 .44158 Mtetra
0 0 .473 r
.46137 .44158 .46474 .44763 .4674 .45123 .46401 .44516 Mtetra
0 .045 .61 r
.46401 .44516 .4674 .45123 .47011 .45348 .4667 .44737 Mtetra
.227 .27 .699 r
.4667 .44737 .47011 .45348 .47287 .45345 .46944 .44732 Mtetra
.516 .403 .664 r
.46944 .44732 .47287 .45345 .47567 .45062 .47224 .4445 Mtetra
.647 .454 .609 r
.47224 .4445 .47567 .45062 .4785 .44502 .47506 .43891 Mtetra
.704 .474 .572 r
.47506 .43891 .4785 .44502 .48134 .43716 .47791 .43108 Mtetra
.727 .481 .554 r
.47791 .43108 .48134 .43716 .48418 .42796 .48075 .42191 Mtetra
.731 .482 .551 r
.48075 .42191 .48418 .42796 .487 .41856 .48358 .41254 Mtetra
.717 .478 .563 r
.48358 .41254 .487 .41856 .4898 .41012 .48639 .40414 Mtetra
.677 .465 .591 r
.48639 .40414 .4898 .41012 .49259 .40361 .48918 .39764 Mtetra
.586 .432 .64 r
.48918 .39764 .49259 .40361 .49537 .39964 .49195 .39368 Mtetra
.379 .346 .695 r
.49195 .39368 .49537 .39964 .49816 .39842 .49474 .39245 Mtetra
.005 .161 .675 r
.49474 .39245 .49816 .39842 .50098 .39969 .49753 .3937 Mtetra
0 0 .548 r
.49753 .3937 .50098 .39969 .50383 .40278 .50036 .39675 Mtetra
0 0 .468 r
.50036 .39675 .50383 .40278 .5067 .4067 .50322 .40063 Mtetra
0 0 .505 r
.50322 .40063 .5067 .4067 .50961 .41029 .5061 .40419 Mtetra
0 .076 .631 r
.5061 .40419 .50961 .41029 .51253 .41243 .509 .4063 Mtetra
.248 .283 .702 r
.509 .4063 .51253 .41243 .51543 .41224 .51189 .4061 Mtetra
.52 .405 .662 r
.51189 .4061 .51543 .41224 .51831 .40927 .51476 .40313 Mtetra
.647 .453 .606 r
.51476 .40313 .51831 .40927 .52115 .40358 .5176 .39745 Mtetra
.703 .471 .569 r
.5176 .39745 .52115 .40358 .52394 .39573 .52039 .38962 Mtetra
.725 .477 .551 r
.52039 .38962 .52394 .39573 .5267 .38665 .52315 .38058 Mtetra
.727 .478 .549 r
.52315 .38058 .5267 .38665 .52943 .3775 .52589 .37146 Mtetra
.71 .473 .563 r
.52589 .37146 .52943 .3775 .53217 .3694 .52864 .36339 Mtetra
.664 .459 .596 r
.52864 .36339 .53217 .3694 .53495 .36328 .53142 .35728 Mtetra
.559 .421 .65 r
.53142 .35728 .53495 .36328 .5378 .35972 .53426 .35373 Mtetra
.331 .326 .702 r
.53426 .35373 .5378 .35972 .54073 .35888 .53718 .35287 Mtetra
0 .143 .67 r
.53718 .35287 .54073 .35888 .54376 .36046 .54019 .35443 Mtetra
0 0 .554 r
.54019 .35443 .54376 .36046 .54686 .36376 .54327 .35769 Mtetra
0 0 .493 r
.54327 .35769 .54686 .36376 .55002 .36776 .5464 .36166 Mtetra
0 0 .536 r
.5464 .36166 .55002 .36776 .5532 .37133 .54956 .36519 Mtetra
0 .105 .65 r
.54956 .36519 .5532 .37133 .55634 .37336 .55268 .36719 Mtetra
.266 .294 .705 r
.55268 .36719 .55634 .37336 .55941 .37302 .55574 .36683 Mtetra
.524 .406 .66 r
.55574 .36683 .55941 .37302 .56238 .3699 .55869 .36371 Mtetra
.647 .45 .603 r
.55869 .36371 .56238 .3699 .56522 .36411 .56154 .35794 Mtetra
.702 .467 .565 r
.56154 .35794 .56522 .36411 .56797 .35625 .56429 .35011 Mtetra
.723 .473 .548 r
.56429 .35011 .56797 .35625 .57064 .34729 .56697 .34117 Mtetra
.723 .473 .547 r
.56697 .34117 .57064 .34729 .5733 .33836 .56964 .33228 Mtetra
.703 .467 .565 r
.56964 .33228 .5733 .33836 .57601 .33058 .57234 .32452 Mtetra
.649 .451 .603 r
.57234 .32452 .57601 .33058 .57881 .32484 .57514 .3188 Mtetra
.529 .409 .66 r
.57514 .3188 .57881 .32484 .58175 .32168 .57808 .31564 Mtetra
.283 .306 .708 r
.57808 .31564 .58175 .32168 .58487 .3212 .58118 .31514 Mtetra
0 .13 .666 r
.58118 .31514 .58487 .3212 .58814 .32308 .58444 .31699 Mtetra
0 0 .563 r
.58444 .31699 .58814 .32308 .59155 .32657 .58782 .32045 Mtetra
0 0 .518 r
.58782 .32045 .59155 .32657 .59503 .33067 .59127 .32451 Mtetra
0 0 .565 r
.59127 .32451 .59503 .33067 .5985 .33422 .59472 .32802 Mtetra
0 .132 .667 r
.59472 .32802 .5985 .33422 .6019 .33614 .59809 .32991 Mtetra
.283 .304 .706 r
.59809 .32991 .6019 .33614 .60515 .33564 .60133 .3294 Mtetra
.527 .406 .659 r
.60133 .3294 .60515 .33564 .60821 .33236 .60438 .32612 Mtetra
.647 .448 .6 r
.60438 .32612 .60821 .33236 .61107 .32647 .60724 .32024 Mtetra
.7 .463 .562 r
.60724 .32024 .61107 .32647 .61377 .31859 .60994 .31239 Mtetra
.72 .468 .544 r
.60994 .31239 .61377 .31859 .61637 .30972 .61255 .30355 Mtetra
.719 .468 .546 r
.61255 .30355 .61637 .30972 .61897 .301 .61515 .29486 Mtetra
.694 .462 .567 r
.61515 .29486 .61897 .301 .62165 .29352 .61784 .28741 Mtetra
.632 .444 .61 r
.61784 .28741 .62165 .29352 .62451 .28814 .6207 .28204 Mtetra
.496 .396 .671 r
.6207 .28204 .62451 .28814 .6276 .28536 .62377 .27926 Mtetra
.236 .286 .712 r
.62377 .27926 .6276 .28536 .63094 .28524 .6271 .27912 Mtetra
0 .122 .663 r
.6271 .27912 .63094 .28524 .63451 .28741 .63065 .28126 Mtetra
0 0 .575 r
.63065 .28126 .63451 .28741 .63827 .29111 .63438 .28492 Mtetra
0 0 .543 r
.63438 .28492 .63827 .29111 .64211 .2953 .63819 .28906 Mtetra
0 .018 .592 r
.63819 .28906 .64211 .2953 .64592 .29882 .64198 .29254 Mtetra
0 .156 .68 r
.64198 .29254 .64592 .29882 .6496 .30063 .64563 .29433 Mtetra
.298 .313 .708 r
.64563 .29433 .6496 .30063 .65304 .29997 .64905 .29365 Mtetra
.529 .406 .657 r
.64905 .29365 .65304 .29997 .6562 .29653 .6522 .29021 Mtetra
.646 .445 .597 r
.6522 .29021 .6562 .29653 .65908 .29052 .65508 .28421 Mtetra
.698 .459 .558 r
.65508 .28421 .65908 .29052 .66174 .28261 .65774 .27633 Mtetra
.717 .463 .541 r
.65774 .27633 .66174 .28261 .66428 .27382 .66029 .26757 Mtetra
.713 .462 .545 r
.66029 .26757 .66428 .27382 .66683 .26529 .66285 .25907 Mtetra
.683 .455 .57 r
.66285 .25907 .66683 .26529 .66952 .25809 .66554 .2519 Mtetra
.612 .435 .618 r
.66554 .2519 .66952 .25809 .67247 .25306 .66849 .24688 Mtetra
.461 .382 .682 r
.66849 .24688 .67247 .25306 .67574 .25065 .67175 .24447 Mtetra
.192 .269 .714 r
.67175 .24447 .67574 .25065 .67936 .25089 .67535 .24468 Mtetra
0 .118 .663 r
.67535 .24468 .67936 .25089 .6833 .25335 .67926 .24711 Mtetra
0 .015 .589 r
.67926 .24711 .6833 .25335 .68746 .25725 .68339 .25096 Mtetra
0 0 .568 r
.68339 .25096 .68746 .25725 .69171 .26152 .68761 .25519 Mtetra
0 .048 .616 r
.68761 .25519 .69171 .26152 .69591 .26503 .69178 .25865 Mtetra
.005 .178 .692 r
.69178 .25865 .69591 .26503 .69989 .26673 .69574 .26032 Mtetra
.311 .32 .708 r
.69574 .26032 .69989 .26673 .70355 .2659 .69937 .25948 Mtetra
.74 .578 .674 r
.26736 .68362 .27068 .68695 .27351 .6817 .27019 .67837 Mtetra
.782 .571 .615 r
.27019 .67837 .27351 .6817 .27666 .67363 .27335 .67031 Mtetra
.797 .567 .589 r
.27335 .67031 .27666 .67363 .28003 .66358 .27673 .66026 Mtetra
.802 .565 .579 r
.27673 .66026 .28003 .66358 .28348 .65268 .28019 .64938 Mtetra
.8 .566 .583 r
.28019 .64938 .28348 .65268 .28686 .64223 .28358 .63894 Mtetra
.79 .569 .602 r
.28358 .63894 .28686 .64223 .29005 .6334 .28678 .63012 Mtetra
.763 .575 .644 r
.28678 .63012 .29005 .6334 .29295 .62706 .28969 .62378 Mtetra
.68 .578 .735 r
.28969 .62378 .29295 .62706 .29553 .62367 .29227 .6204 Mtetra
.329 .488 .865 r
.29227 .6204 .29553 .62367 .29781 .6232 .29453 .61991 Mtetra
0 .023 .529 r
.29453 .61991 .29781 .6232 .29983 .62511 .29655 .62181 Mtetra
.729 .218 0 r
.29655 .62181 .29983 .62511 .30172 .62848 .29843 .62517 Mtetra
.751 .243 0 r
.29843 .62517 .30172 .62848 .3036 .63211 .30029 .62879 Mtetra
.624 .11 0 r
.30029 .62879 .3036 .63211 .30561 .63475 .30228 .63142 Mtetra
.012 .34 .821 r
.30228 .63142 .30561 .63475 .30783 .6353 .3045 .63196 Mtetra
.601 .569 .79 r
.3045 .63196 .30783 .6353 .31036 .63303 .30702 .62968 Mtetra
.742 .578 .671 r
.30702 .62968 .31036 .63303 .31318 .62773 .30985 .62438 Mtetra
.783 .571 .613 r
.30985 .62438 .31318 .62773 .31626 .61973 .31294 .61639 Mtetra
.799 .566 .586 r
.31294 .61639 .31626 .61973 .31951 .60989 .3162 .60656 Mtetra
.803 .565 .577 r
.3162 .60656 .31951 .60989 .32281 .59935 .31951 .59603 Mtetra
.8 .566 .583 r
.31951 .59603 .32281 .59935 .32604 .58936 .32275 .58606 Mtetra
.788 .57 .605 r
.32275 .58606 .32604 .58936 .32911 .58106 .32582 .57776 Mtetra
.755 .577 .655 r
.32582 .57776 .32911 .58106 .33193 .57525 .32865 .57196 Mtetra
.65 .576 .758 r
.32865 .57196 .33193 .57525 .3345 .57235 .33121 .56905 Mtetra
.223 .444 .864 r
.33121 .56905 .3345 .57235 .33681 .57225 .33352 .56895 Mtetra
.506 .006 0 r
.33352 .56895 .33681 .57225 .33895 .57442 .33564 .5711 Mtetra
.717 .204 0 r
.33564 .5711 .33895 .57442 .34098 .5779 .33767 .57457 Mtetra
.728 .216 0 r
.33767 .57457 .34098 .5779 .34303 .58153 .33969 .57818 Mtetra
.575 .065 0 r
.33969 .57818 .34303 .58153 .34518 .58406 .34184 .58071 Mtetra
.071 .371 .837 r
.34184 .58071 .34518 .58406 .34753 .58446 .34418 .5811 Mtetra
.608 .57 .786 r
.34418 .5811 .34753 .58446 .35011 .58206 .34676 .57869 Mtetra
.744 .578 .669 r
.34676 .57869 .35011 .58206 .35293 .57669 .34958 .57332 Mtetra
.785 .571 .611 r
.34958 .57332 .35293 .57669 .35595 .56875 .3526 .56539 Mtetra
.8 .566 .584 r
.3526 .56539 .35595 .56875 .35909 .55911 .35575 .55576 Mtetra
.804 .564 .576 r
.35575 .55576 .35909 .55911 .36225 .5489 .35893 .54556 Mtetra
.8 .566 .583 r
.35893 .54556 .36225 .5489 .36535 .53934 .36204 .53601 Mtetra
.785 .571 .61 r
.36204 .53601 .36535 .53934 .36831 .53153 .36501 .52821 Mtetra
.745 .578 .668 r
.36501 .52821 .36831 .53153 .37108 .52622 .36778 .5229 Mtetra
.613 .571 .783 r
.36778 .5229 .37108 .52622 .37366 .52377 .37035 .52045 Mtetra
.116 .393 .848 r
.37035 .52045 .37366 .52377 .37605 .52403 .37273 .5207 Mtetra
.528 .024 0 r
.37273 .5207 .37605 .52403 .37831 .52644 .37498 .5231 Mtetra
.702 .188 0 r
.37498 .5231 .37831 .52644 .38051 .53003 .37717 .52667 Mtetra
.7 .186 0 r
.37717 .52667 .38051 .53003 .38274 .53364 .37938 .53027 Mtetra
.521 .019 0 r
.37938 .53027 .38274 .53364 .38506 .53607 .38169 .53269 Mtetra
.123 .397 .849 r
.38169 .53269 .38506 .53607 .38753 .53633 .38415 .53293 Mtetra
.614 .571 .782 r
.38415 .53293 .38753 .53633 .39018 .53378 .3868 .53038 Mtetra
.746 .578 .667 r
.3868 .53038 .39018 .53378 .393 .52835 .38962 .52495 Mtetra
.786 .57 .608 r
.38962 .52495 .393 .52835 .39596 .52046 .39258 .51707 Mtetra
.801 .566 .581 r
.39258 .51707 .39596 .52046 .39899 .51099 .39563 .50761 Mtetra
.805 .564 .574 r
.39563 .50761 .39899 .51099 .40203 .50108 .39868 .49771 Mtetra
.8 .566 .584 r
.39868 .49771 .40203 .50108 .40501 .49193 .40167 .48857 Mtetra
.782 .572 .616 r
.40167 .48857 .40501 .49193 .40789 .48458 .40456 .48123 Mtetra
.732 .579 .683 r
.40456 .48123 .40789 .48458 .41064 .47975 .40731 .4764 Mtetra
.567 .562 .807 r
.40731 .4764 .41064 .47975 .41325 .47772 .40991 .47437 Mtetra
.015 .341 .821 r
.40991 .47437 .41325 .47772 .41575 .47833 .4124 .47497 Mtetra
.539 .033 0 r
.4124 .47497 .41575 .47833 .41816 .48096 .4148 .47759 Mtetra
.683 .168 0 r
.4148 .47759 .41816 .48096 .42056 .48466 .41718 .48126 Mtetra
.669 .154 0 r
.41718 .48126 .42056 .48466 .42298 .48825 .41959 .48484 Mtetra
0 .028 .535 r
.41959 .48484 .42298 .48825 .42548 .49058 .42207 .48715 Mtetra
.169 .419 .857 r
.42207 .48715 .42548 .49058 .42808 .49068 .42467 .48724 Mtetra
.62 .572 .778 r
.42467 .48724 .42808 .49068 .4308 .488 .42738 .48456 Mtetra
.747 .578 .665 r
.42738 .48456 .4308 .488 .43362 .48249 .43021 .47906 Mtetra
.788 .57 .605 r
.43021 .47906 .43362 .48249 .43652 .47463 .43312 .4712 Mtetra
.803 .565 .579 r
.43312 .4712 .43652 .47463 .43946 .46532 .43606 .4619 Mtetra
.806 .564 .573 r
.43606 .4619 .43946 .46532 .44239 .45569 .439 .45229 Mtetra
.799 .567 .586 r
.439 .45229 .44239 .45569 .44527 .44693 .4419 .44353 Mtetra
.777 .573 .623 r
.4419 .44353 .44527 .44693 .44809 .44001 .44472 .43663 Mtetra
.716 .579 .701 r
.44472 .43663 .44809 .44001 .45084 .43563 .44747 .43224 Mtetra
.512 .548 .83 r
.44747 .43224 .45084 .43563 .45352 .43401 .45015 .43061 Mtetra
0 .292 .789 r
.45015 .43061 .45352 .43401 .45615 .43494 .45277 .43154 Mtetra
.541 .035 0 r
.45277 .43154 .45615 .43494 .45876 .43779 .45536 .43437 Mtetra
.661 .146 0 r
.45536 .43437 .45876 .43779 .46137 .44158 .45795 .43815 Mtetra
.634 .119 0 r
.45795 .43815 .46137 .44158 .46401 .44516 .46058 .4417 Mtetra
0 .073 .587 r
.46058 .4417 .46401 .44516 .4667 .44737 .46325 .44391 Mtetra
.208 .437 .862 r
.46325 .44391 .4667 .44737 .46944 .44732 .46599 .44385 Mtetra
.626 .573 .775 r
.46599 .44385 .46944 .44732 .47224 .4445 .46878 .44102 Mtetra
.749 .577 .662 r
.46878 .44102 .47224 .4445 .47506 .43891 .47161 .43544 Mtetra
.79 .57 .603 r
.47161 .43544 .47506 .43891 .47791 .43108 .47446 .42761 Mtetra
.804 .565 .576 r
.47446 .42761 .47791 .43108 .48075 .42191 .47731 .41845 Mtetra
.806 .564 .572 r
.47731 .41845 .48075 .42191 .48358 .41254 .48015 .4091 Mtetra
.798 .567 .588 r
.48015 .4091 .48358 .41254 .48639 .40414 .48297 .4007 Mtetra
.771 .574 .632 r
.48297 .4007 .48639 .40414 .48918 .39764 .48576 .3942 Mtetra
.696 .579 .721 r
.48576 .3942 .48918 .39764 .49195 .39368 .48854 .39024 Mtetra
.447 .529 .849 r
.48854 .39024 .49195 .39368 .49474 .39245 .49131 .389 Mtetra
0 .25 .757 r
.49131 .389 .49474 .39245 .49753 .3937 .4941 .39024 Mtetra
.536 .031 0 r
.4941 .39024 .49753 .3937 .50036 .39675 .49691 .39328 Mtetra
.635 .121 0 r
.49691 .39328 .50036 .39675 .50322 .40063 .49975 .39715 Mtetra
.595 .083 0 r
.49975 .39715 .50322 .40063 .5061 .40419 .50262 .40068 Mtetra
0 .117 .633 r
.50262 .40068 .5061 .40419 .509 .4063 .5055 .40278 Mtetra
.243 .452 .865 r
.5055 .40278 .509 .4063 .51189 .4061 .50839 .40257 Mtetra
.631 .573 .772 r
.50839 .40257 .51189 .4061 .51476 .40313 .51125 .3996 Mtetra
.751 .577 .66 r
.51125 .3996 .51476 .40313 .5176 .39745 .51409 .39392 Mtetra
.791 .569 .6 r
.51409 .39392 .5176 .39745 .52039 .38962 .5169 .3861 Mtetra
.805 .564 .573 r
.5169 .3861 .52039 .38962 .52315 .38058 .51967 .37707 Mtetra
.807 .564 .571 r
.51967 .37707 .52315 .38058 .52589 .37146 .52242 .36796 Mtetra
.796 .568 .591 r
.52242 .36796 .52589 .37146 .52864 .36339 .52517 .35989 Mtetra
.764 .576 .643 r
.52517 .35989 .52864 .36339 .53142 .35728 .52796 .3538 Mtetra
.67 .578 .742 r
.52796 .3538 .53142 .35728 .53426 .35373 .53079 .35024 Mtetra
.374 .505 .861 r
.53079 .35024 .53426 .35373 .53718 .35287 .53371 .34938 Mtetra
0 .217 .729 r
.53371 .34938 .53718 .35287 .54019 .35443 .5367 .35092 Mtetra
.525 .022 0 r
.5367 .35092 .54019 .35443 .54327 .35769 .53976 .35416 Mtetra
.606 .093 0 r
.53976 .35416 .54327 .35769 .5464 .36166 .54288 .35811 Mtetra
.552 .045 0 r
.54288 .35811 .5464 .36166 .54956 .36519 .54601 .36162 Mtetra
0 .158 .675 r
.54601 .36162 .54956 .36519 .55268 .36719 .54913 .36361 Mtetra
.273 .465 .866 r
.54913 .36361 .55268 .36719 .55574 .36683 .55217 .36325 Mtetra
.635 .574 .769 r
.55217 .36325 .55574 .36683 .55869 .36371 .55513 .36012 Mtetra
.753 .577 .657 r
.55513 .36012 .55869 .36371 .56154 .35794 .55798 .35435 Mtetra
.793 .569 .597 r
.55798 .35435 .56154 .35794 .56429 .35011 .56073 .34653 Mtetra
.807 .564 .571 r
.56073 .34653 .56429 .35011 .56697 .34117 .56342 .3376 Mtetra
.807 .564 .57 r
.56342 .3376 .56697 .34117 .56964 .33228 .5661 .32872 Mtetra
.794 .569 .596 r
.5661 .32872 .56964 .33228 .57234 .32452 .56881 .32097 Mtetra
.754 .577 .656 r
.56881 .32097 .57234 .32452 .57514 .3188 .57162 .31525 Mtetra
.639 .574 .766 r
.57162 .31525 .57514 .3188 .57808 .31564 .57455 .31208 Mtetra
.299 .476 .866 r
.57455 .31208 .57808 .31564 .58118 .31514 .57764 .31158 Mtetra
0 .192 .708 r
.57764 .31158 .58118 .31514 .58444 .31699 .58088 .31342 Mtetra
.51 .009 0 r
.58088 .31342 .58444 .31699 .58782 .32045 .58425 .31686 Mtetra
.574 .064 0 r
.58425 .31686 .58782 .32045 .59127 .32451 .58768 .32089 Mtetra
.506 .007 0 r
.58768 .32089 .59127 .32451 .59472 .32802 .59111 .32438 Mtetra
0 .196 .711 r
.59111 .32438 .59472 .32802 .59809 .32991 .59447 .32626 Mtetra
.299 .476 .866 r
.59447 .32626 .59809 .32991 .60133 .3294 .59769 .32574 Mtetra
.639 .574 .766 r
.59769 .32574 .60133 .3294 .60438 .32612 .60074 .32246 Mtetra
.755 .577 .655 r
.60074 .32246 .60438 .32612 .60724 .32024 .6036 .31658 Mtetra
.795 .568 .593 r
.6036 .31658 .60724 .32024 .60994 .31239 .60631 .30874 Mtetra
.808 .563 .568 r
.60631 .30874 .60994 .31239 .61255 .30355 .60894 .29991 Mtetra
.807 .564 .57 r
.60894 .29991 .61255 .30355 .61515 .29486 .61155 .29123 Mtetra
.791 .57 .601 r
.61155 .29123 .61515 .29486 .61784 .28741 .61425 .28378 Mtetra
.742 .578 .671 r
.61425 .28378 .61784 .28741 .6207 .28204 .6171 .27842 Mtetra
.601 .569 .789 r
.6171 .27842 .6207 .28204 .62377 .27926 .62018 .27563 Mtetra
.224 .444 .863 r
.62018 .27563 .62377 .27926 .6271 .27912 .62349 .27548 Mtetra
0 .176 .693 r
.62349 .27548 .6271 .27912 .63065 .28126 .62703 .27761 Mtetra
0 .007 .511 r
.62703 .27761 .63065 .28126 .63438 .28492 .63073 .28124 Mtetra
.538 .033 0 r
.63073 .28124 .63438 .28492 .63819 .28906 .63452 .28536 Mtetra
0 .032 .54 r
.63452 .28536 .63819 .28906 .64198 .29254 .63829 .28883 Mtetra
0 .23 .741 r
.63829 .28883 .64198 .29254 .64563 .29433 .64193 .2906 Mtetra
.322 .485 .865 r
.64193 .2906 .64563 .29433 .64905 .29365 .64534 .28991 Mtetra
.642 .575 .764 r
.64534 .28991 .64905 .29365 .6522 .29021 .64849 .28647 Mtetra
.757 .577 .653 r
.64849 .28647 .6522 .29021 .65508 .28421 .65137 .28047 Mtetra
.797 .568 .59 r
.65137 .28047 .65508 .28421 .65774 .27633 .65404 .2726 Mtetra
.809 .563 .566 r
.65404 .2726 .65774 .27633 .66029 .26757 .6566 .26385 Mtetra
.807 .564 .571 r
.6566 .26385 .66029 .26757 .66285 .25907 .65917 .25536 Mtetra
.786 .571 .609 r
.65917 .25536 .66285 .25907 .66554 .2519 .66187 .2482 Mtetra
.727 .579 .689 r
.66187 .2482 .66554 .2519 .66849 .24688 .66481 .24318 Mtetra
.556 .559 .812 r
.66481 .24318 .66849 .24688 .67175 .24447 .66807 .24076 Mtetra
.154 .411 .855 r
.66807 .24076 .67175 .24447 .67535 .24468 .67166 .24096 Mtetra
0 .167 .684 r
.67166 .24096 .67535 .24468 .67926 .24711 .67555 .24337 Mtetra
0 .027 .534 r
.67555 .24337 .67926 .24711 .68339 .25096 .67966 .2472 Mtetra
0 0 .501 r
.67966 .2472 .68339 .25096 .68761 .25519 .68386 .2514 Mtetra
0 .07 .583 r
.68386 .2514 .68761 .25519 .69178 .25865 .688 .25485 Mtetra
0 .261 .766 r
.688 .25485 .69178 .25865 .69574 .26032 .69194 .2565 Mtetra
.341 .492 .864 r
.69194 .2565 .69574 .26032 .69937 .25948 .69557 .25565 Mtetra
.871 .757 .734 r
.26366 .68342 .26736 .68362 .27019 .67837 .26649 .67816 Mtetra
.876 .688 .644 r
.26649 .67816 .27019 .67837 .27335 .67031 .26966 .6701 Mtetra
.874 .658 .607 r
.26966 .6701 .27335 .67031 .27673 .66026 .27306 .66003 Mtetra
.873 .649 .595 r
.27306 .66003 .27673 .66026 .28019 .64938 .27654 .64913 Mtetra
.874 .652 .599 r
.27654 .64913 .28019 .64938 .28358 .63894 .27995 .63868 Mtetra
.875 .672 .624 r
.27995 .63868 .28358 .63894 .28678 .63012 .28317 .62984 Mtetra
.875 .719 .686 r
.28317 .62984 .28678 .63012 .28969 .62378 .28609 .6235 Mtetra
.837 .83 .84 r
.28609 .6235 .28969 .62378 .29227 .6204 .28867 .6201 Mtetra
.25 .748 .903 r
.28867 .6201 .29227 .6204 .29453 .61991 .29093 .61962 Mtetra
.535 0 0 r
.29093 .61962 .29453 .61991 .29655 .62181 .29294 .62152 Mtetra
.671 .158 .013 r
.29294 .62152 .29655 .62181 .29843 .62517 .2948 .62488 Mtetra
.684 .179 .036 r
.2948 .62488 .29843 .62517 .30029 .62879 .29666 .6285 Mtetra
.614 .073 0 r
.29666 .6285 .30029 .62879 .30228 .63142 .29864 .63114 Mtetra
.199 0 0 r
.29864 .63114 .30228 .63142 .3045 .63196 .30085 .63168 Mtetra
.753 .892 .941 r
.30085 .63168 .3045 .63196 .30702 .62968 .30337 .6294 Mtetra
.874 .757 .73 r
.30337 .6294 .30702 .62968 .30985 .62438 .3062 .62409 Mtetra
.88 .69 .641 r
.3062 .62409 .30985 .62438 .31294 .61639 .3093 .61609 Mtetra
.878 .661 .604 r
.3093 .61609 .31294 .61639 .3162 .60656 .31258 .60624 Mtetra
.878 .652 .593 r
.31258 .60624 .3162 .60656 .31951 .59603 .31591 .5957 Mtetra
.878 .658 .6 r
.31591 .5957 .31951 .59603 .32275 .58606 .31917 .5857 Mtetra
.879 .681 .63 r
.31917 .5857 .32275 .58606 .32582 .57776 .32226 .57739 Mtetra
.876 .736 .704 r
.32226 .57739 .32582 .57776 .32865 .57196 .32509 .57158 Mtetra
.81 .856 .883 r
.32509 .57158 .32865 .57196 .33121 .56905 .32766 .56867 Mtetra
.075 .63 .812 r
.32766 .56867 .33121 .56905 .33352 .56895 .32996 .56856 Mtetra
.557 0 0 r
.32996 .56856 .33352 .56895 .33564 .5711 .33207 .57072 Mtetra
.67 .151 0 r
.33207 .57072 .33564 .5711 .33767 .57457 .33408 .5742 Mtetra
.676 .16 .002 r
.33408 .5742 .33767 .57457 .33969 .57818 .3361 .57781 Mtetra
.593 .039 0 r
.3361 .57781 .33969 .57818 .34184 .58071 .33823 .58034 Mtetra
.131 0 0 r
.33823 .58034 .34184 .58071 .34418 .5811 .34057 .58073 Mtetra
.762 .886 .934 r
.34057 .58073 .34418 .5811 .34676 .57869 .34315 .57831 Mtetra
.876 .757 .728 r
.34315 .57831 .34676 .57869 .34958 .57332 .34598 .57294 Mtetra
.883 .692 .639 r
.34598 .57294 .34958 .57332 .3526 .56539 .34902 .565 Mtetra
.883 .664 .602 r
.34902 .565 .3526 .56539 .35575 .55576 .35218 .55535 Mtetra
.882 .656 .591 r
.35218 .55535 .35575 .55576 .35893 .54556 .35537 .54513 Mtetra
.883 .664 .601 r
.35537 .54513 .35893 .54556 .36204 .53601 .3585 .53557 Mtetra
.883 .691 .637 r
.3585 .53557 .36204 .53601 .36501 .52821 .36148 .52775 Mtetra
.875 .754 .725 r
.36148 .52775 .36501 .52821 .36778 .5229 .36426 .52244 Mtetra
.766 .877 .927 r
.36426 .52244 .36778 .5229 .37035 .52045 .36683 .51998 Mtetra
0 .515 .719 r
.36683 .51998 .37035 .52045 .37273 .5207 .36921 .52024 Mtetra
.572 .007 0 r
.36921 .52024 .37273 .5207 .37498 .5231 .37145 .52263 Mtetra
.667 .141 0 r
.37145 .52263 .37498 .5231 .37717 .52667 .37363 .52621 Mtetra
.666 .139 0 r
.37363 .52621 .37717 .52667 .37938 .53027 .37582 .52981 Mtetra
.569 .002 0 r
.37582 .52981 .37938 .53027 .38169 .53269 .37812 .53223 Mtetra
0 .522 .723 r
.37812 .53223 .38169 .53269 .38415 .53293 .38058 .53248 Mtetra
.77 .881 .927 r
.38058 .53248 .38415 .53293 .3868 .53038 .38323 .52993 Mtetra
.879 .759 .725 r
.38323 .52993 .3868 .53038 .38962 .52495 .38606 .52448 Mtetra
.888 .695 .636 r
.38606 .52448 .38962 .52495 .39258 .51707 .38903 .51659 Mtetra
.887 .667 .599 r
.38903 .51659 .39258 .51707 .39563 .50761 .39209 .50711 Mtetra
.887 .66 .59 r
.39209 .50711 .39563 .50761 .39868 .49771 .39516 .4972 Mtetra
.887 .67 .603 r
.39516 .4972 .39868 .49771 .40167 .48857 .39817 .48805 Mtetra
.887 .702 .647 r
.39817 .48805 .40167 .48857 .40456 .48123 .40107 .4807 Mtetra
.872 .775 .751 r
.40107 .4807 .40456 .48123 .40731 .4764 .40382 .47585 Mtetra
.7 .887 .966 r
.40382 .47585 .40731 .4764 .40991 .47437 .40643 .47382 Mtetra
.182 0 0 r
.40643 .47382 .40991 .47437 .4124 .47497 .40891 .47442 Mtetra
.581 .015 0 r
.40891 .47442 .4124 .47497 .4148 .47759 .4113 .47704 Mtetra
.662 .127 0 r
.4113 .47704 .4148 .47759 .41718 .48126 .41367 .48072 Mtetra
.654 .115 0 r
.41367 .48072 .41718 .48126 .41959 .48484 .41607 .4843 Mtetra
.54 0 0 r
.41607 .4843 .41959 .48484 .42207 .48715 .41854 .48662 Mtetra
.005 .574 .782 r
.41854 .48662 .42207 .48715 .42467 .48724 .42113 .48671 Mtetra
.777 .878 .92 r
.42113 .48671 .42467 .48724 .42738 .48456 .42385 .48402 Mtetra
.883 .76 .722 r
.42385 .48402 .42738 .48456 .43021 .47906 .42668 .4785 Mtetra
.892 .698 .633 r
.42668 .4785 .43021 .47906 .43312 .4712 .4296 .47064 Mtetra
.892 .671 .596 r
.4296 .47064 .43312 .4712 .43606 .4619 .43256 .46132 Mtetra
.892 .665 .589 r
.43256 .46132 .43606 .4619 .439 .45229 .43552 .4517 Mtetra
.892 .678 .606 r
.43552 .4517 .439 .45229 .4419 .44353 .43843 .44293 Mtetra
.89 .715 .658 r
.43843 .44293 .4419 .44353 .44472 .43663 .44127 .43601 Mtetra
.865 .797 .781 r
.44127 .43601 .44472 .43663 .44747 .43224 .44402 .43161 Mtetra
.608 .878 .991 r
.44402 .43161 .44747 .43224 .45015 .43061 .44669 .42998 Mtetra
.264 0 0 r
.44669 .42998 .45015 .43061 .45277 .43154 .4493 .43091 Mtetra
.586 .018 0 r
.4493 .43091 .45277 .43154 .45536 .43437 .45189 .43375 Mtetra
.654 .111 0 r
.45189 .43375 .45536 .43437 .45795 .43815 .45447 .43752 Mtetra
.638 .089 0 r
.45447 .43752 .45795 .43815 .46058 .4417 .45708 .44108 Mtetra
.507 0 0 r
.45708 .44108 .46058 .4417 .46325 .44391 .45975 .44329 Mtetra
.068 .618 .831 r
.45975 .44329 .46325 .44391 .46599 .44385 .46248 .44323 Mtetra
.784 .875 .914 r
.46248 .44323 .46599 .44385 .46878 .44102 .46527 .4404 Mtetra
.887 .763 .719 r
.46527 .4404 .46878 .44102 .47161 .43544 .46811 .4348 Mtetra
.897 .701 .629 r
.46811 .4348 .47161 .43544 .47446 .42761 .47097 .42696 Mtetra
.897 .675 .593 r
.47097 .42696 .47446 .42761 .47731 .41845 .47384 .41779 Mtetra
.897 .671 .588 r
.47384 .41779 .47731 .41845 .48015 .4091 .4767 .40842 Mtetra
.897 .687 .61 r
.4767 .40842 .48015 .4091 .48297 .4007 .47953 .40001 Mtetra
.893 .73 .672 r
.47953 .40001 .48297 .4007 .48576 .3942 .48233 .3935 Mtetra
.853 .821 .817 r
.48233 .3935 .48576 .3942 .48854 .39024 .48511 .38953 Mtetra
.491 .843 .995 r
.48511 .38953 .48854 .39024 .49131 .389 .48788 .38829 Mtetra
.322 0 0 r
.48788 .38829 .49131 .389 .4941 .39024 .49066 .38953 Mtetra
.586 .015 0 r
.49066 .38953 .4941 .39024 .49691 .39328 .49346 .39258 Mtetra
.643 .092 0 r
.49346 .39258 .49691 .39328 .49975 .39715 .49629 .39644 Mtetra
.62 .06 0 r
.49629 .39644 .49975 .39715 .50262 .40068 .49914 .39998 Mtetra
.47 0 0 r
.49914 .39998 .50262 .40068 .5055 .40278 .50202 .40208 Mtetra
.127 .656 .872 r
.50202 .40208 .5055 .40278 .50839 .40257 .5049 .40186 Mtetra
.79 .873 .909 r
.5049 .40186 .50839 .40257 .51125 .3996 .50777 .39889 Mtetra
.891 .766 .716 r
.50777 .39889 .51125 .3996 .51409 .39392 .51062 .3932 Mtetra
.902 .705 .626 r
.51062 .3932 .51409 .39392 .5169 .3861 .51343 .38537 Mtetra
.903 .68 .59 r
.51343 .38537 .5169 .3861 .51967 .37707 .51622 .37632 Mtetra
.903 .678 .587 r
.51622 .37632 .51967 .37707 .52242 .36796 .51898 .3672 Mtetra
.903 .697 .615 r
.51898 .3672 .52242 .36796 .52517 .35989 .52175 .35912 Mtetra
.895 .747 .69 r
.52175 .35912 .52517 .35989 .52796 .3538 .52454 .35301 Mtetra
.832 .844 .856 r
.52454 .35301 .52796 .3538 .53079 .35024 .52739 .34945 Mtetra
.36 .785 .973 r
.52739 .34945 .53079 .35024 .53371 .34938 .5303 .34859 Mtetra
.363 0 0 r
.5303 .34859 .53371 .34938 .5367 .35092 .53328 .35013 Mtetra
.582 .008 0 r
.53328 .35013 .5367 .35092 .53976 .35416 .53633 .35337 Mtetra
.63 .071 0 r
.53633 .35337 .53976 .35416 .54288 .35811 .53944 .35732 Mtetra
.598 .028 0 r
.53944 .35732 .54288 .35811 .54601 .36162 .54256 .36084 Mtetra
.43 0 0 r
.54256 .36084 .54601 .36162 .54913 .36361 .54566 .36283 Mtetra
.181 .687 .904 r
.54566 .36283 .54913 .36361 .55217 .36325 .54871 .36246 Mtetra
.796 .872 .904 r
.54871 .36246 .55217 .36325 .55513 .36012 .55166 .35933 Mtetra
.896 .769 .713 r
.55166 .35933 .55513 .36012 .55798 .35435 .55452 .35355 Mtetra
.908 .71 .623 r
.55452 .35355 .55798 .35435 .56073 .34653 .55729 .34571 Mtetra
.909 .685 .587 r
.55729 .34571 .56073 .34653 .56342 .3376 .56 .33678 Mtetra
.56 .33678 .56342 .3376 .5661 .32872 .56269 .32788 Mtetra
.908 .708 .621 r
.56269 .32788 .5661 .32872 .56881 .32097 .56541 .32012 Mtetra
.896 .766 .711 r
.56541 .32012 .56881 .32097 .57162 .31525 .56822 .31438 Mtetra
.799 .865 .898 r
.56822 .31438 .57162 .31525 .57455 .31208 .57116 .31121 Mtetra
.23 .712 .932 r
.57116 .31121 .57455 .31208 .57764 .31158 .57425 .31071 Mtetra
.39 0 0 r
.57425 .31071 .57764 .31158 .58088 .31342 .57748 .31254 Mtetra
.574 0 0 r
.57748 .31254 .58088 .31342 .58425 .31686 .58083 .31599 Mtetra
.613 .046 0 r
.58083 .31599 .58425 .31686 .58768 .32089 .58425 .32002 Mtetra
.572 0 0 r
.58425 .32002 .58768 .32089 .59111 .32438 .58767 .32351 Mtetra
.386 0 0 r
.58767 .32351 .59111 .32438 .59447 .32626 .59102 .32539 Mtetra
.228 .713 .93 r
.59102 .32539 .59447 .32626 .59769 .32574 .59424 .32487 Mtetra
.801 .872 .9 r
.59424 .32487 .59769 .32574 .60074 .32246 .59729 .32158 Mtetra
.902 .774 .711 r
.59729 .32158 .60074 .32246 .6036 .31658 .60017 .31569 Mtetra
.914 .715 .619 r
.60017 .31569 .6036 .31658 .60631 .30874 .60289 .30784 Mtetra
.915 .691 .584 r
.60289 .30784 .60631 .30874 .60894 .29991 .60552 .29899 Mtetra
.915 .693 .587 r
.60552 .29899 .60894 .29991 .61155 .29123 .60815 .2903 Mtetra
.913 .722 .63 r
.60815 .2903 .61155 .29123 .61425 .28378 .61086 .28284 Mtetra
.894 .788 .736 r
.61086 .28284 .61425 .28378 .6171 .27842 .61372 .27747 Mtetra
.75 .878 .938 r
.61372 .27747 .6171 .27842 .62018 .27563 .6168 .27468 Mtetra
.114 .635 .883 r
.6168 .27468 .62018 .27563 .62349 .27548 .62011 .27453 Mtetra
.406 0 0 r
.62011 .27453 .62349 .27548 .62703 .27761 .62364 .27665 Mtetra
.562 0 0 r
.62364 .27665 .62703 .27761 .63073 .28124 .62733 .28029 Mtetra
.593 .02 0 r
.62733 .28029 .63073 .28124 .63452 .28536 .63111 .28441 Mtetra
.543 0 0 r
.63111 .28441 .63452 .28536 .63829 .28883 .63486 .28788 Mtetra
.34 0 0 r
.63486 .28788 .63829 .28883 .64193 .2906 .63849 .28964 Mtetra
.27 .734 .949 r
.63849 .28964 .64193 .2906 .64534 .28991 .64191 .28895 Mtetra
.807 .874 .896 r
.64191 .28895 .64534 .28991 .64849 .28647 .64506 .2855 Mtetra
.908 .779 .708 r
.64506 .2855 .64849 .28647 .65137 .28047 .64795 .2795 Mtetra
.921 .72 .615 r
.64795 .2795 .65137 .28047 .65404 .2726 .65063 .27161 Mtetra
.922 .698 .581 r
.65063 .27161 .65404 .2726 .6566 .26385 .6532 .26285 Mtetra
.922 .703 .588 r
.6532 .26285 .6566 .26385 .65917 .25536 .65578 .25434 Mtetra
.919 .737 .641 r
.65578 .25434 .65917 .25536 .66187 .2482 .6585 .24717 Mtetra
.888 .811 .767 r
.6585 .24717 .66187 .2482 .66481 .24318 .66145 .24214 Mtetra
.682 .879 .972 r
.66145 .24214 .66481 .24318 .66807 .24076 .6647 .23972 Mtetra
.019 .565 .836 r
.6647 .23972 .66807 .24076 .67166 .24096 .66829 .23991 Mtetra
.413 0 0 r
.66829 .23991 .67166 .24096 .67555 .24337 .67217 .24232 Mtetra
.547 0 0 r
.67217 .24232 .67555 .24337 .67966 .2472 .67627 .24615 Mtetra
.569 0 0 r
.67627 .24615 .67966 .2472 .68386 .2514 .68045 .25036 Mtetra
.51 0 0 r
.68045 .25036 .68386 .2514 .688 .25485 .68459 .25381 Mtetra
.292 0 0 r
.68459 .25381 .688 .25485 .69194 .2565 .68852 .25546 Mtetra
.306 .751 .963 r
.68852 .25546 .69194 .2565 .69557 .25565 .69215 .2546 Mtetra
.955 .921 .734 r
.25959 .68608 .26366 .68342 .26649 .67816 .26244 .6808 Mtetra
.955 .802 .651 r
.26244 .6808 .26649 .67816 .26966 .6701 .26563 .67271 Mtetra
.942 .749 .613 r
.26563 .67271 .26966 .6701 .27306 .66003 .26905 .6626 Mtetra
.937 .731 .599 r
.26905 .6626 .27306 .66003 .27654 .64913 .27255 .65166 Mtetra
.939 .738 .605 r
.27255 .65166 .27654 .64913 .27995 .63868 .27599 .64116 Mtetra
.949 .774 .631 r
.27599 .64116 .27995 .63868 .28317 .62984 .27922 .63229 Mtetra
.961 .86 .694 r
.27922 .63229 .28317 .62984 .28609 .6235 .28216 .62592 Mtetra
.86 .997 .785 r
.28216 .62592 .28609 .6235 .28867 .6201 .28475 .62252 Mtetra
0 0 0 r
.28475 .62252 .28867 .6201 .29093 .61962 .28701 .62204 Mtetra
.453 0 .009 r
.28701 .62204 .29093 .61962 .29294 .62152 .28901 .62395 Mtetra
.57 .11 .122 r
.28901 .62395 .29294 .62152 .2948 .62488 .29086 .62733 Mtetra
.584 .128 .135 r
.29086 .62733 .2948 .62488 .29666 .6285 .29271 .63098 Mtetra
.517 .043 .069 r
.29271 .63098 .29666 .6285 .29864 .63114 .29468 .63363 Mtetra
.242 0 0 r
.29468 .63363 .29864 .63114 .30085 .63168 .29689 .63418 Mtetra
.616 .935 .715 r
.29689 .63418 .30085 .63168 .30337 .6294 .29941 .6319 Mtetra
.957 .92 .729 r
.29941 .6319 .30337 .6294 .3062 .62409 .30226 .62657 Mtetra
.959 .806 .647 r
.30226 .62657 .3062 .62409 .3093 .61609 .30538 .61854 Mtetra
.948 .754 .609 r
.30538 .61854 .3093 .61609 .31258 .60624 .30868 .60865 Mtetra
.943 .738 .597 r
.30868 .60865 .31258 .60624 .31591 .5957 .31203 .59806 Mtetra
.946 .748 .604 r
.31203 .59806 .31591 .5957 .31917 .5857 .31531 .58803 Mtetra
.956 .79 .636 r
.31531 .58803 .31917 .5857 .32226 .57739 .31842 .57969 Mtetra
.963 .887 .708 r
.31842 .57969 .32226 .57739 .32509 .57158 .32127 .57386 Mtetra
.783 .994 .78 r
.32127 .57386 .32509 .57158 .32766 .56867 .32384 .57093 Mtetra
.085 0 0 r
.32384 .57093 .32766 .56867 .32996 .56856 .32614 .57084 Mtetra
.475 0 .009 r
.32614 .57084 .32996 .56856 .33207 .57072 .32825 .57301 Mtetra
.574 .106 .105 r
.32825 .57301 .33207 .57072 .33408 .5742 .33025 .5765 Mtetra
.58 .114 .111 r
.33025 .5765 .33408 .5742 .3361 .57781 .33225 .58014 Mtetra
.504 .018 .037 r
.33225 .58014 .3361 .57781 .33823 .58034 .33438 .58268 Mtetra
.205 0 0 r
.33438 .58268 .33823 .58034 .34057 .58073 .33671 .58308 Mtetra
.645 .95 .732 r
.33671 .58308 .34057 .58073 .34315 .57831 .33929 .58066 Mtetra
.959 .92 .724 r
.33929 .58066 .34315 .57831 .34598 .57294 .34214 .57527 Mtetra
.964 .81 .642 r
.34214 .57527 .34598 .57294 .34902 .565 .34519 .5673 Mtetra
.953 .76 .604 r
.34519 .5673 .34902 .565 .35218 .55535 .34838 .55761 Mtetra
.949 .746 .593 r
.34838 .55761 .35218 .55535 .35537 .54513 .3516 .54735 Mtetra
.953 .759 .604 r
.3516 .54735 .35537 .54513 .3585 .53557 .35474 .53776 Mtetra
.963 .808 .641 r
.35474 .53776 .3585 .53557 .36148 .52775 .35774 .52991 Mtetra
.959 .916 .724 r
.35774 .52991 .36148 .52775 .36426 .52244 .36053 .52458 Mtetra
.676 .965 .756 r
.36053 .52458 .36426 .52244 .36683 .51998 .36311 .52211 Mtetra
.172 0 0 r
.36311 .52211 .36683 .51998 .36921 .52024 .36548 .52237 Mtetra
.492 0 .005 r
.36548 .52237 .36921 .52024 .37145 .52263 .36772 .52478 Mtetra
.576 .099 .086 r
.36772 .52478 .37145 .52263 .37363 .52621 .36988 .52839 Mtetra
.575 .098 .085 r
.36988 .52839 .37363 .52621 .37582 .52981 .37207 .53201 Mtetra
.489 0 .002 r
.37207 .53201 .37582 .52981 .37812 .53223 .37436 .53444 Mtetra
.167 0 0 r
.37436 .53444 .37812 .53223 .38058 .53248 .37682 .53469 Mtetra
.67 .96 .744 r
.37682 .53469 .38058 .53248 .38323 .52993 .37947 .53214 Mtetra
.961 .921 .718 r
.37947 .53214 .38323 .52993 .38606 .52448 .38231 .52668 Mtetra
.968 .815 .637 r
.38231 .52668 .38606 .52448 .38903 .51659 .38531 .51875 Mtetra
.959 .766 .6 r
.38531 .51875 .38903 .51659 .39209 .50711 .38839 .50924 Mtetra
.956 .754 .59 r
.38839 .50924 .39209 .50711 .39516 .4972 .39148 .49929 Mtetra
.96 .772 .604 r
.39148 .49929 .39516 .4972 .39817 .48805 .39451 .4901 Mtetra
.969 .828 .648 r
.39451 .4901 .39817 .48805 .40107 .4807 .39742 .48272 Mtetra
.949 .945 .741 r
.39742 .48272 .40107 .4807 .40382 .47585 .40019 .47786 Mtetra
.544 .907 .715 r
.40019 .47786 .40382 .47585 .40643 .47382 .4028 .47582 Mtetra
.239 0 0 r
.4028 .47582 .40643 .47382 .40891 .47442 .40527 .47643 Mtetra
.504 .002 0 r
.40527 .47643 .40891 .47442 .4113 .47704 .40766 .47906 Mtetra
.575 .089 .064 r
.40766 .47906 .4113 .47704 .41367 .48072 .41002 .48277 Mtetra
.568 .08 .056 r
.41002 .48277 .41367 .48072 .41607 .4843 .41241 .48637 Mtetra
.471 0 0 r
.41241 .48637 .41607 .4843 .41854 .48662 .41487 .4887 Mtetra
.127 0 0 r
.41487 .4887 .41854 .48662 .42113 .48671 .41746 .4888 Mtetra
.69 .968 .752 r
.41746 .4888 .42113 .48671 .42385 .48402 .42019 .4861 Mtetra
.963 .922 .712 r
.42019 .4861 .42385 .48402 .42668 .4785 .42303 .48057 Mtetra
.973 .82 .631 r
.42303 .48057 .42668 .4785 .4296 .47064 .42597 .47267 Mtetra
.965 .773 .594 r
.42597 .47267 .4296 .47064 .43256 .46132 .42895 .46332 Mtetra
.963 .763 .586 r
.42895 .46332 .43256 .46132 .43552 .4517 .43193 .45365 Mtetra
.968 .786 .604 r
.43193 .45365 .43552 .4517 .43843 .44293 .43486 .44485 Mtetra
.974 .85 .656 r
.43486 .44485 .43843 .44293 .44127 .43601 .43771 .43791 Mtetra
.926 .971 .756 r
.43771 .43791 .44127 .43601 .44402 .43161 .44047 .4335 Mtetra
.402 .827 .659 r
.44047 .4335 .44402 .43161 .44669 .42998 .44315 .43187 Mtetra
.291 0 0 r
.44315 .43187 .44669 .42998 .4493 .43091 .44576 .4328 Mtetra
.514 .004 0 r
.44576 .4328 .4493 .43091 .45189 .43375 .44833 .43565 Mtetra
.573 .078 .039 r
.44833 .43565 .45189 .43375 .45447 .43752 .45091 .43945 Mtetra
.559 .059 .025 r
.45091 .43945 .45447 .43752 .45708 .44108 .45351 .44303 Mtetra
.452 0 0 r
.45351 .44303 .45708 .44108 .45975 .44329 .45617 .44525 Mtetra
.086 0 0 r
.45617 .44525 .45975 .44329 .46248 .44323 .4589 .4452 Mtetra
.706 .974 .757 r
.4589 .4452 .46248 .44323 .46527 .4404 .4617 .44236 Mtetra
.965 .924 .705 r
.4617 .44236 .46527 .4404 .46811 .4348 .46455 .43674 Mtetra
.978 .825 .624 r
.46455 .43674 .46811 .4348 .47097 .42696 .46743 .42887 Mtetra
.972 .781 .588 r
.46743 .42887 .47097 .42696 .47384 .41779 .47032 .41966 Mtetra
.97 .774 .583 r
.47032 .41966 .47384 .41779 .4767 .40842 .4732 .41026 Mtetra
.975 .801 .605 r
.4732 .41026 .4767 .40842 .47953 .40001 .47605 .40181 Mtetra
.977 .874 .666 r
.47605 .40181 .47953 .40001 .48233 .3935 .47886 .39529 Mtetra
.888 .99 .769 r
.47886 .39529 .48233 .3935 .48511 .38953 .48165 .3913 Mtetra
0 0 0 r
.48165 .3913 .48511 .38953 .48788 .38829 .48443 .39006 Mtetra
.331 0 0 r
.48443 .39006 .48788 .38829 .49066 .38953 .4872 .39131 Mtetra
.52 .002 0 r
.4872 .39131 .49066 .38953 .49346 .39258 .49 .39437 Mtetra
.57 .064 .012 r
.49 .39437 .49346 .39258 .49629 .39644 .49282 .39826 Mtetra
.548 .037 0 r
.49282 .39826 .49629 .39644 .49914 .39998 .49566 .40182 Mtetra
.431 0 0 r
.49566 .40182 .49914 .39998 .50202 .40208 .49853 .40393 Mtetra
.045 0 0 r
.49853 .40393 .50202 .40208 .5049 .40186 .50141 .40372 Mtetra
.719 .978 .759 r
.50141 .40372 .5049 .40186 .50777 .39889 .50429 .40074 Mtetra
.967 .927 .698 r
.50429 .40074 .50777 .39889 .51062 .3932 .50715 .39503 Mtetra
.982 .831 .617 r
.50715 .39503 .51062 .3932 .51343 .38537 .50998 .38717 Mtetra
.978 .789 .581 r
.50998 .38717 .51343 .38537 .51622 .37632 .51279 .37809 Mtetra
.977 .785 .578 r
.51279 .37809 .51622 .37632 .51898 .3672 .51557 .36893 Mtetra
.981 .818 .606 r
.51557 .36893 .51898 .3672 .52175 .35912 .51836 .36082 Mtetra
.976 .9 .677 r
.51836 .36082 .52175 .35912 .52454 .35301 .52117 .35469 Mtetra
.83 .998 .775 r
.52117 .35469 .52454 .35301 .52739 .34945 .52402 .35112 Mtetra
0 0 0 r
.52402 .35112 .52739 .34945 .5303 .34859 .52693 .35025 Mtetra
.362 0 0 r
.52693 .35025 .5303 .34859 .53328 .35013 .52991 .3518 Mtetra
.523 0 0 r
.52991 .3518 .53328 .35013 .53633 .35337 .53296 .35507 Mtetra
.564 .047 0 r
.53296 .35507 .53633 .35337 .53944 .35732 .53605 .35904 Mtetra
.536 .013 0 r
.53605 .35904 .53944 .35732 .54256 .36084 .53917 .36258 Mtetra
.407 0 0 r
.53917 .36258 .54256 .36084 .54566 .36283 .54227 .36458 Mtetra
.005 0 0 r
.54227 .36458 .54566 .36283 .54871 .36246 .54531 .36421 Mtetra
.728 .98 .757 r
.54531 .36421 .54871 .36246 .55166 .35933 .54828 .36108 Mtetra
.968 .929 .689 r
.54828 .36108 .55166 .35933 .55452 .35355 .55115 .35527 Mtetra
.987 .838 .608 r
.55115 .35527 .55452 .35355 .55729 .34571 .55393 .34741 Mtetra
.984 .798 .574 r
.55393 .34741 .55729 .34571 .56 .33678 .55666 .33843 Mtetra
.984 .797 .573 r
.55666 .33843 .56 .33678 .56269 .32788 .55937 .3295 Mtetra
.987 .836 .607 r
.55937 .3295 .56269 .32788 .56541 .32012 .56211 .32171 Mtetra
.969 .926 .688 r
.56211 .32171 .56541 .32012 .56822 .31438 .56493 .31596 Mtetra
.749 .987 .771 r
.56493 .31596 .56822 .31438 .57116 .31121 .56788 .31278 Mtetra
0 0 0 r
.56788 .31278 .57116 .31121 .57425 .31071 .57097 .31228 Mtetra
.385 0 0 r
.57097 .31228 .57425 .31071 .57748 .31254 .5742 .31412 Mtetra
.523 0 0 r
.5742 .31412 .57748 .31254 .58083 .31599 .57754 .31758 Mtetra
.556 .028 0 r
.57754 .31758 .58083 .31599 .58425 .32002 .58096 .32165 Mtetra
.521 0 0 r
.58096 .32165 .58425 .32002 .58767 .32351 .58437 .32516 Mtetra
.382 0 0 r
.58437 .32516 .58767 .32351 .59102 .32539 .58772 .32705 Mtetra
0 0 0 r
.58772 .32705 .59102 .32539 .59424 .32487 .59094 .32652 Mtetra
.735 .981 .753 r
.59094 .32652 .59424 .32487 .59729 .32158 .594 .32323 Mtetra
.969 .932 .678 r
.594 .32323 .59729 .32158 .60017 .31569 .59689 .31732 Mtetra
.991 .845 .598 r
.59689 .31732 .60017 .31569 .60289 .30784 .59963 .30943 Mtetra
.99 .807 .565 r
.59963 .30943 .60289 .30784 .60552 .29899 .60228 .30055 Mtetra
.99 .81 .568 r
.60228 .30055 .60552 .29899 .60815 .2903 .60493 .29183 Mtetra
.99 .856 .609 r
.60493 .29183 .60815 .2903 .61086 .28284 .60765 .28434 Mtetra
.954 .951 .7 r
.60765 .28434 .61086 .28284 .61372 .27747 .61052 .27895 Mtetra
.647 .955 .755 r
.61052 .27895 .61372 .27747 .6168 .27468 .61361 .27615 Mtetra
.047 0 0 r
.61361 .27615 .6168 .27468 .62011 .27453 .61692 .276 Mtetra
.401 0 0 r
.61692 .276 .62011 .27453 .62364 .27665 .62044 .27814 Mtetra
.52 0 0 r
.62044 .27814 .62364 .27665 .62733 .28029 .62414 .28179 Mtetra
.545 .007 0 r
.62414 .28179 .62733 .28029 .63111 .28441 .62791 .28594 Mtetra
.504 0 0 r
.62791 .28594 .63111 .28441 .63486 .28788 .63166 .28943 Mtetra
.354 0 0 r
.63166 .28943 .63486 .28788 .63849 .28964 .63529 .29121 Mtetra
0 0 0 r
.63529 .29121 .63849 .28964 .64191 .28895 .6387 .29052 Mtetra
.739 .98 .746 r
.6387 .29052 .64191 .28895 .64506 .2855 .64186 .28706 Mtetra
.968 .935 .666 r
.64186 .28706 .64506 .2855 .64795 .2795 .64476 .28103 Mtetra
.994 .851 .586 r
.64476 .28103 .64795 .2795 .65063 .27161 .64746 .27311 Mtetra
.995 .816 .554 r
.64746 .27311 .65063 .27161 .6532 .26285 .65005 .26431 Mtetra
.995 .824 .561 r
.65005 .26431 .6532 .26285 .65578 .25434 .65265 .25578 Mtetra
.991 .877 .611 r
.65265 .25578 .65578 .25434 .6585 .24717 .65538 .24857 Mtetra
.928 .972 .711 r
.65538 .24857 .6585 .24717 .66145 .24214 .65834 .24353 Mtetra
.532 .905 .728 r
.65834 .24353 .66145 .24214 .6647 .23972 .66161 .24109 Mtetra
.113 0 0 r
.66161 .24109 .6647 .23972 .66829 .23991 .6652 .2413 Mtetra
.411 0 0 r
.6652 .2413 .66829 .23991 .67217 .24232 .66908 .24372 Mtetra
.514 0 0 r
.66908 .24372 .67217 .24232 .67627 .24615 .67317 .24758 Mtetra
.533 0 0 r
.67317 .24758 .67627 .24615 .68045 .25036 .67735 .25181 Mtetra
.485 0 0 r
.67735 .25181 .68045 .25036 .68459 .25381 .68148 .25527 Mtetra
.325 0 0 r
.68148 .25527 .68459 .25381 .68852 .25546 .68542 .25694 Mtetra
0 0 0 r
.68542 .25694 .68852 .25546 .69215 .2546 .68905 .25608 Mtetra
.921 .962 .65 r
.25524 .69083 .25959 .68608 .26244 .6808 .2581 .68552 Mtetra
.987 .872 .631 r
.2581 .68552 .26244 .6808 .26563 .67271 .26131 .67738 Mtetra
.979 .81 .603 r
.26131 .67738 .26563 .67271 .26905 .6626 .26476 .66722 Mtetra
.974 .788 .593 r
.26476 .66722 .26905 .6626 .27255 .65166 .2683 .65621 Mtetra
.976 .797 .597 r
.2683 .65621 .27255 .65166 .27599 .64116 .27176 .64565 Mtetra
.985 .84 .618 r
.27176 .64565 .27599 .64116 .27922 .63229 .27502 .63673 Mtetra
.973 .927 .652 r
.27502 .63673 .27922 .63229 .28216 .62592 .27797 .63033 Mtetra
.697 .916 .577 r
.27797 .63033 .28216 .62592 .28475 .62252 .28057 .62692 Mtetra
.054 0 0 r
.28057 .62692 .28475 .62252 .28701 .62204 .28283 .62644 Mtetra
.406 0 .088 r
.28283 .62644 .28701 .62204 .28901 .62395 .28483 .62838 Mtetra
.513 .086 .167 r
.28483 .62838 .28901 .62395 .29086 .62733 .28667 .63179 Mtetra
.526 .101 .177 r
.28667 .63179 .29086 .62733 .29271 .63098 .28851 .63547 Mtetra
.462 .029 .129 r
.28851 .63547 .29271 .63098 .29468 .63363 .29047 .63815 Mtetra
.24 0 0 r
.29047 .63815 .29468 .63363 .29689 .63418 .29268 .63872 Mtetra
0 0 0 r
.29268 .63872 .29689 .63418 .29941 .6319 .29521 .63643 Mtetra
.922 .961 .644 r
.29521 .63643 .29941 .6319 .30226 .62657 .29807 .63107 Mtetra
.989 .875 .624 r
.29807 .63107 .30226 .62657 .30538 .61854 .30121 .623 Mtetra
.984 .816 .597 r
.30121 .623 .30538 .61854 .30868 .60865 .30454 .61305 Mtetra
.979 .797 .587 r
.30454 .61305 .30868 .60865 .31203 .59806 .30792 .60241 Mtetra
.982 .809 .593 r
.30792 .60241 .31203 .59806 .31531 .58803 .31124 .59232 Mtetra
.989 .858 .617 r
.31124 .59232 .31531 .58803 .31842 .57969 .31436 .58393 Mtetra
.957 .946 .65 r
.31436 .58393 .31842 .57969 .32127 .57386 .31723 .57807 Mtetra
.58 .857 .524 r
.31723 .57807 .32127 .57386 .32384 .57093 .3198 .57514 Mtetra
.129 0 0 r
.3198 .57514 .32384 .57093 .32614 .57084 .32211 .57505 Mtetra
.425 0 .086 r
.32211 .57505 .32614 .57084 .32825 .57301 .32421 .57724 Mtetra
.517 .082 .153 r
.32421 .57724 .32825 .57301 .33025 .5765 .3262 .58077 Mtetra
.523 .089 .158 r
.3262 .58077 .33025 .5765 .33225 .58014 .3282 .58444 Mtetra
.451 .009 .105 r
.3282 .58444 .33225 .58014 .33438 .58268 .33032 .58701 Mtetra
.214 0 0 r
.33032 .58701 .33438 .58268 .33671 .58308 .33265 .58743 Mtetra
0 0 0 r
.33265 .58743 .33671 .58308 .33929 .58066 .33524 .585 Mtetra
.922 .959 .637 r
.33524 .585 .33929 .58066 .34214 .57527 .3381 .57958 Mtetra
.99 .878 .615 r
.3381 .57958 .34214 .57527 .34519 .5673 .34117 .57157 Mtetra
.988 .822 .589 r
.34117 .57157 .34519 .5673 .34838 .55761 .34439 .56182 Mtetra
.985 .805 .581 r
.34439 .56182 .34838 .55761 .3516 .54735 .34763 .5515 Mtetra
.988 .822 .589 r
.34763 .5515 .3516 .54735 .35474 .53776 .35081 .54186 Mtetra
.99 .876 .615 r
.35081 .54186 .35474 .53776 .35774 .52991 .35382 .53396 Mtetra
.928 .958 .642 r
.35382 .53396 .35774 .52991 .36053 .52458 .35663 .52861 Mtetra
0 0 0 r
.35663 .52861 .36053 .52458 .36311 .52211 .35921 .52613 Mtetra
.19 0 0 r
.35921 .52613 .36311 .52211 .36548 .52237 .36159 .52641 Mtetra
.441 0 .081 r
.36159 .52641 .36548 .52237 .36772 .52478 .36382 .52885 Mtetra
.52 .077 .137 r
.36382 .52885 .36772 .52478 .36988 .52839 .36598 .53248 Mtetra
.519 .076 .137 r
.36598 .53248 .36988 .52839 .37207 .53201 .36816 .53614 Mtetra
.439 0 .079 r
.36816 .53614 .37207 .53201 .37436 .53444 .37044 .5386 Mtetra
.187 0 0 r
.37044 .5386 .37436 .53444 .37682 .53469 .3729 .53886 Mtetra
0 0 0 r
.3729 .53886 .37682 .53469 .37947 .53214 .37556 .5363 Mtetra
.92 .956 .628 r
.37556 .5363 .37947 .53214 .38231 .52668 .37842 .53081 Mtetra
.991 .881 .606 r
.37842 .53081 .38231 .52668 .38531 .51875 .38143 .52284 Mtetra
.992 .829 .581 r
.38143 .52284 .38531 .51875 .38839 .50924 .38454 .51327 Mtetra
.99 .815 .574 r
.38454 .51327 .38839 .50924 .39148 .49929 .38766 .50327 Mtetra
.992 .835 .584 r
.38766 .50327 .39148 .49929 .39451 .4901 .39071 .49403 Mtetra
.988 .894 .613 r
.39071 .49403 .39451 .4901 .39742 .48272 .39364 .48661 Mtetra
.883 .962 .629 r
.39364 .48661 .39742 .48272 .40019 .47786 .39642 .48172 Mtetra
0 0 0 r
.39642 .48172 .40019 .47786 .4028 .47582 .39904 .47968 Mtetra
.24 0 0 r
.39904 .47968 .4028 .47582 .40527 .47643 .40151 .4803 Mtetra
.454 0 .072 r
.40151 .4803 .40527 .47643 .40766 .47906 .4039 .48297 Mtetra
.521 .069 .12 r
.4039 .48297 .40766 .47906 .41002 .48277 .40625 .48671 Mtetra
.513 .061 .114 r
.40625 .48671 .41002 .48277 .41241 .48637 .40863 .49034 Mtetra
.425 0 .052 r
.40863 .49034 .41241 .48637 .41487 .4887 .41109 .4927 Mtetra
.159 0 0 r
.41109 .4927 .41487 .4887 .41746 .4888 .41368 .4928 Mtetra
0 0 0 r
.41368 .4928 .41746 .4888 .42019 .4861 .41641 .4901 Mtetra
.917 .953 .617 r
.41641 .4901 .42019 .4861 .42303 .48057 .41927 .48454 Mtetra
.992 .884 .595 r
.41927 .48454 .42303 .48057 .42597 .47267 .42223 .4766 Mtetra
.995 .836 .571 r
.42223 .4766 .42597 .47267 .42895 .46332 .42524 .4672 Mtetra
.994 .825 .565 r
.42524 .4672 .42895 .46332 .43193 .45365 .42824 .45748 Mtetra
.995 .849 .578 r
.42824 .45748 .43193 .45365 .43486 .44485 .43119 .44862 Mtetra
.981 .912 .608 r
.43119 .44862 .43486 .44485 .43771 .43791 .43407 .44164 Mtetra
.821 .952 .607 r
.43407 .44164 .43771 .43791 .44047 .4335 .43684 .43721 Mtetra
0 0 0 r
.43684 .43721 .44047 .4335 .44315 .43187 .43952 .43558 Mtetra
.28 0 0 r
.43952 .43558 .44315 .43187 .44576 .4328 .44213 .43653 Mtetra
.464 0 .06 r
.44213 .43653 .44576 .4328 .44833 .43565 .4447 .43941 Mtetra
.52 .059 .1 r
.4447 .43941 .44833 .43565 .45091 .43945 .44727 .44325 Mtetra
.506 .044 .09 r
.44727 .44325 .45091 .43945 .45351 .44303 .44987 .44686 Mtetra
.409 0 .023 r
.44987 .44686 .45351 .44303 .45617 .44525 .45253 .44911 Mtetra
.131 0 0 r
.45253 .44911 .45617 .44525 .4589 .4452 .45526 .44906 Mtetra
0 0 0 r
.45526 .44906 .4589 .4452 .4617 .44236 .45807 .44621 Mtetra
.913 .95 .605 r
.45807 .44621 .4617 .44236 .46455 .43674 .46093 .44057 Mtetra
.991 .887 .582 r
.46093 .44057 .46455 .43674 .46743 .42887 .46384 .43265 Mtetra
.997 .842 .56 r
.46384 .43265 .46743 .42887 .47032 .41966 .46675 .42339 Mtetra
.997 .834 .556 r
.46675 .42339 .47032 .41966 .4732 .41026 .46965 .41394 Mtetra
.996 .863 .571 r
.46965 .41394 .4732 .41026 .47605 .40181 .47252 .40544 Mtetra
.966 .926 .602 r
.47252 .40544 .47605 .40181 .47886 .39529 .47535 .39888 Mtetra
.739 .927 .578 r
.47535 .39888 .47886 .39529 .48165 .3913 .47815 .39488 Mtetra
0 0 0 r
.47815 .39488 .48165 .3913 .48443 .39006 .48094 .39364 Mtetra
.312 0 0 r
.48094 .39364 .48443 .39006 .4872 .39131 .48371 .39491 Mtetra
.471 0 .045 r
.48371 .39491 .4872 .39131 .49 .39437 .4865 .398 Mtetra
.518 .048 .078 r
.4865 .398 .49 .39437 .49282 .39826 .48931 .40193 Mtetra
.498 .025 .063 r
.48931 .40193 .49282 .39826 .49566 .40182 .49216 .40552 Mtetra
.393 0 0 r
.49216 .40552 .49566 .40182 .49853 .40393 .49502 .40766 Mtetra
.103 0 0 r
.49502 .40766 .49853 .40393 .50141 .40372 .49791 .40746 Mtetra
0 0 0 r
.49791 .40746 .50141 .40372 .50429 .40074 .5008 .40446 Mtetra
.906 .945 .59 r
.5008 .40446 .50429 .40074 .50715 .39503 .50367 .39873 Mtetra
.989 .889 .568 r
.50367 .39873 .50715 .39503 .50998 .38717 .50653 .39082 Mtetra
.998 .848 .547 r
.50653 .39082 .50998 .38717 .51279 .37809 .50935 .38169 Mtetra
.999 .844 .545 r
.50935 .38169 .51279 .37809 .51557 .36893 .51216 .37247 Mtetra
.993 .877 .562 r
.51216 .37247 .51557 .36893 .51836 .36082 .51497 .36432 Mtetra
.941 .937 .592 r
.51497 .36432 .51836 .36082 .52117 .35469 .51779 .35816 Mtetra
.642 .885 .541 r
.51779 .35816 .52117 .35469 .52402 .35112 .52065 .35457 Mtetra
0 0 0 r
.52065 .35457 .52402 .35112 .52693 .35025 .52357 .35371 Mtetra
.338 0 0 r
.52357 .35371 .52693 .35025 .52991 .3518 .52655 .35528 Mtetra
.476 0 .027 r
.52655 .35528 .52991 .3518 .53296 .35507 .5296 .35858 Mtetra
.514 .034 .053 r
.5296 .35858 .53296 .35507 .53605 .35904 .53269 .36259 Mtetra
.488 .005 .035 r
.53269 .36259 .53605 .35904 .53917 .36258 .5358 .36616 Mtetra
.375 0 0 r
.5358 .36616 .53917 .36258 .54227 .36458 .5389 .36819 Mtetra
.075 0 0 r
.5389 .36819 .54227 .36458 .54531 .36421 .54195 .36783 Mtetra
0 0 0 r
.54195 .36783 .54531 .36421 .54828 .36108 .54493 .36468 Mtetra
.897 .94 .573 r
.54493 .36468 .54828 .36108 .55115 .35527 .54781 .35885 Mtetra
.984 .89 .551 r
.54781 .35885 .55115 .35527 .55393 .34741 .55062 .35093 Mtetra
.997 .854 .531 r
.55062 .35093 .55393 .34741 .55666 .33843 .55337 .34191 Mtetra
.997 .853 .531 r
.55337 .34191 .55666 .33843 .55937 .3295 .5561 .33293 Mtetra
.985 .889 .551 r
.5561 .33293 .55937 .3295 .56211 .32171 .55886 .32509 Mtetra
.904 .94 .577 r
.55886 .32509 .56211 .32171 .56493 .31596 .5617 .31931 Mtetra
.535 .83 .5 r
.5617 .31931 .56493 .31596 .56788 .31278 .56466 .31612 Mtetra
.046 0 0 r
.56466 .31612 .56788 .31278 .57097 .31228 .56775 .31562 Mtetra
.358 0 0 r
.56775 .31562 .57097 .31228 .5742 .31412 .57098 .31749 Mtetra
.478 0 .006 r
.57098 .31749 .5742 .31412 .57754 .31758 .57433 .32099 Mtetra
.509 .018 .027 r
.57433 .32099 .57754 .31758 .58096 .32165 .57774 .32509 Mtetra
.476 0 .006 r
.57774 .32509 .58096 .32165 .58437 .32516 .58115 .32863 Mtetra
.355 0 0 r
.58115 .32863 .58437 .32516 .58772 .32705 .5845 .33055 Mtetra
.048 0 0 r
.5845 .33055 .58772 .32705 .59094 .32652 .58773 .33003 Mtetra
0 0 0 r
.58773 .33003 .59094 .32652 .594 .32323 .5908 .32672 Mtetra
.886 .932 .553 r
.5908 .32672 .594 .32323 .59689 .31732 .5937 .32078 Mtetra
.977 .89 .531 r
.5937 .32078 .59689 .31732 .59963 .30943 .59646 .31285 Mtetra
.993 .858 .513 r
.59646 .31285 .59963 .30943 .60228 .30055 .59914 .30392 Mtetra
.992 .861 .515 r
.59914 .30392 .60228 .30055 .60493 .29183 .60181 .29514 Mtetra
.97 .898 .537 r
.60181 .29514 .60493 .29183 .60765 .28434 .60455 .28762 Mtetra
.852 .934 .558 r
.60455 .28762 .60765 .28434 .61052 .27895 .60744 .2822 Mtetra
0 0 0 r
.60744 .2822 .61052 .27895 .61361 .27615 .61053 .27938 Mtetra
.105 0 0 r
.61053 .27938 .61361 .27615 .61692 .276 .61385 .27925 Mtetra
.373 0 0 r
.61385 .27925 .61692 .276 .62044 .27814 .61738 .28141 Mtetra
.478 0 0 r
.61738 .28141 .62044 .27814 .62414 .28179 .62107 .2851 Mtetra
.502 0 0 r
.62107 .2851 .62414 .28179 .62791 .28594 .62484 .28929 Mtetra
.463 0 0 r
.62484 .28929 .62791 .28594 .63166 .28943 .62859 .29281 Mtetra
.335 0 0 r
.62859 .29281 .63166 .28943 .63529 .29121 .63223 .29461 Mtetra
.022 0 0 r
.63223 .29461 .63529 .29121 .6387 .29052 .63565 .29393 Mtetra
0 0 0 r
.63565 .29393 .6387 .29052 .64186 .28706 .63882 .29046 Mtetra
.871 .922 .53 r
.63882 .29046 .64186 .28706 .64476 .28103 .64174 .28439 Mtetra
.967 .887 .508 r
.64174 .28439 .64476 .28103 .64746 .27311 .64446 .27643 Mtetra
.986 .861 .492 r
.64446 .27643 .64746 .27311 .65005 .26431 .64707 .26758 Mtetra
.982 .867 .496 r
.64707 .26758 .65005 .26431 .65265 .25578 .64969 .25899 Mtetra
.947 .904 .519 r
.64969 .25899 .65265 .25578 .65538 .24857 .65244 .25175 Mtetra
.784 .916 .533 r
.65244 .25175 .65538 .24857 .65834 .24353 .65542 .24668 Mtetra
0 0 0 r
.65542 .24668 .65834 .24353 .66161 .24109 .65869 .24424 Mtetra
.152 0 0 r
.65869 .24424 .66161 .24109 .6652 .2413 .66229 .24445 Mtetra
.384 0 0 r
.66229 .24445 .6652 .2413 .66908 .24372 .66617 .24691 Mtetra
.475 0 0 r
.66617 .24691 .66908 .24372 .67317 .24758 .67027 .2508 Mtetra
.492 0 0 r
.67027 .2508 .67317 .24758 .67735 .25181 .67445 .25507 Mtetra
.448 0 0 r
.67445 .25507 .67735 .25181 .68148 .25527 .67859 .25857 Mtetra
.313 0 0 r
.67859 .25857 .68148 .25527 .68542 .25694 .68253 .26026 Mtetra
0 0 0 r
.68253 .26026 .68542 .25694 .68905 .25608 .68617 .25941 Mtetra
.875 .948 .591 r
.25073 .69652 .25524 .69083 .2581 .68552 .25361 .69119 Mtetra
.988 .893 .613 r
.25361 .69119 .2581 .68552 .26131 .67738 .25685 .683 Mtetra
.99 .834 .594 r
.25685 .683 .26131 .67738 .26476 .66722 .26033 .67277 Mtetra
.985 .811 .586 r
.26033 .67277 .26476 .66722 .2683 .65621 .2639 .66169 Mtetra
.987 .82 .589 r
.2639 .66169 .2683 .65621 .27176 .64565 .26739 .65106 Mtetra
.992 .863 .605 r
.26739 .65106 .27176 .64565 .27502 .63673 .27068 .64208 Mtetra
.957 .938 .618 r
.27068 .64208 .27502 .63673 .27797 .63033 .27365 .63565 Mtetra
.607 .846 .476 r
.27365 .63565 .27797 .63033 .28057 .62692 .27626 .63222 Mtetra
.075 0 0 r
.27626 .63222 .28057 .62692 .28283 .62644 .27852 .63175 Mtetra
.389 0 .112 r
.27852 .63175 .28283 .62644 .28483 .62838 .28051 .63372 Mtetra
.492 .077 .181 r
.28051 .63372 .28483 .62838 .28667 .63179 .28235 .63717 Mtetra
.505 .092 .19 r
.28235 .63717 .28667 .63179 .28851 .63547 .28417 .64089 Mtetra
.443 .024 .148 r
.28417 .64089 .28851 .63547 .29047 .63815 .28613 .6436 Mtetra
.237 0 .015 r
.28613 .6436 .29047 .63815 .29268 .63872 .28834 .64418 Mtetra
0 0 0 r
.28834 .64418 .29268 .63872 .29521 .63643 .29088 .64189 Mtetra
.875 .946 .585 r
.29088 .64189 .29521 .63643 .29807 .63107 .29375 .6365 Mtetra
.988 .895 .603 r
.29375 .6365 .29807 .63107 .30121 .623 .29692 .62838 Mtetra
.993 .839 .586 r
.29692 .62838 .30121 .623 .30454 .61305 .30028 .61837 Mtetra
.99 .819 .578 r
.30028 .61837 .30454 .61305 .30792 .60241 .30369 .60765 Mtetra
.992 .832 .583 r
.30369 .60765 .30792 .60241 .31124 .59232 .30703 .5975 Mtetra
.992 .879 .6 r
.30703 .5975 .31124 .59232 .31436 .58393 .31018 .58906 Mtetra
.927 .946 .605 r
.31018 .58906 .31436 .58393 .31723 .57807 .31307 .58316 Mtetra
0 0 0 r
.31307 .58316 .31723 .57807 .3198 .57514 .31565 .58022 Mtetra
.14 0 0 r
.31565 .58022 .3198 .57514 .32211 .57505 .31796 .58014 Mtetra
.408 0 .11 r
.31796 .58014 .32211 .57505 .32421 .57724 .32005 .58237 Mtetra
.496 .074 .169 r
.32005 .58237 .32421 .57724 .3262 .58077 .32204 .58594 Mtetra
.502 .081 .173 r
.32204 .58594 .3262 .58077 .3282 .58444 .32403 .58965 Mtetra
.432 .005 .126 r
.32403 .58965 .3282 .58444 .33032 .58701 .32614 .59225 Mtetra
.214 0 0 r
.32614 .59225 .33032 .58701 .33265 .58743 .32847 .59268 Mtetra
0 0 0 r
.32847 .59268 .33265 .58743 .33524 .585 .33107 .59025 Mtetra
.874 .942 .577 r
.33107 .59025 .33524 .585 .3381 .57958 .33395 .5848 Mtetra
.987 .897 .593 r
.33395 .5848 .3381 .57958 .34117 .57157 .33705 .57673 Mtetra
.995 .845 .577 r
.33705 .57673 .34117 .57157 .34439 .56182 .34029 .56692 Mtetra
.994 .828 .57 r
.34029 .56692 .34439 .56182 .34763 .5515 .34356 .55654 Mtetra
.995 .844 .576 r
.34356 .55654 .34763 .5515 .35081 .54186 .34677 .54683 Mtetra
.988 .895 .593 r
.34677 .54683 .35081 .54186 .35382 .53396 .34981 .53889 Mtetra
.883 .945 .585 r
.34981 .53889 .35382 .53396 .35663 .52861 .35263 .5335 Mtetra
0 0 0 r
.35263 .5335 .35663 .52861 .35921 .52613 .35522 .53102 Mtetra
.194 0 0 r
.35522 .53102 .35921 .52613 .36159 .52641 .3576 .53131 Mtetra
.423 0 .104 r
.3576 .53131 .36159 .52641 .36382 .52885 .35982 .53378 Mtetra
.499 .069 .154 r
.35982 .53378 .36382 .52885 .36598 .53248 .36197 .53746 Mtetra
.498 .068 .154 r
.36197 .53746 .36598 .53248 .36816 .53614 .36414 .54115 Mtetra
.421 0 .103 r
.36414 .54115 .36816 .53614 .37044 .5386 .36643 .54365 Mtetra
.191 0 0 r
.36643 .54365 .37044 .5386 .3729 .53886 .36888 .54392 Mtetra
0 0 0 r
.36888 .54392 .3729 .53886 .37556 .5363 .37155 .54135 Mtetra
.87 .938 .567 r
.37155 .54135 .37556 .5363 .37842 .53081 .37443 .53583 Mtetra
.986 .898 .581 r
.37443 .53583 .37842 .53081 .38143 .52284 .37747 .52781 Mtetra
.997 .85 .566 r
.37747 .52781 .38143 .52284 .38454 .51327 .3806 .51818 Mtetra
.997 .836 .561 r
.3806 .51818 .38454 .51327 .38766 .50327 .38375 .50811 Mtetra
.997 .856 .568 r
.38375 .50811 .38766 .50327 .39071 .49403 .38683 .49881 Mtetra
.979 .909 .584 r
.38683 .49881 .39071 .49403 .39364 .48661 .38978 .49135 Mtetra
.822 .932 .557 r
.38978 .49135 .39364 .48661 .39642 .48172 .39257 .48644 Mtetra
0 0 0 r
.39257 .48644 .39642 .48172 .39904 .47968 .3952 .48439 Mtetra
.238 0 0 r
.3952 .48439 .39904 .47968 .40151 .4803 .39768 .48503 Mtetra
.436 0 .096 r
.39768 .48503 .40151 .4803 .4039 .48297 .40006 .48773 Mtetra
.5 .062 .138 r
.40006 .48773 .4039 .48297 .40625 .48671 .4024 .49151 Mtetra
.493 .054 .133 r
.4024 .49151 .40625 .48671 .40863 .49034 .40477 .49518 Mtetra
.408 0 .079 r
.40477 .49518 .40863 .49034 .41109 .4927 .40723 .49757 Mtetra
.166 0 0 r
.40723 .49757 .41109 .4927 .41368 .4928 .40983 .49769 Mtetra
0 0 0 r
.40983 .49769 .41368 .4928 .41641 .4901 .41257 .49498 Mtetra
.865 .933 .555 r
.41257 .49498 .41641 .4901 .41927 .48454 .41545 .48938 Mtetra
.982 .898 .567 r
.41545 .48938 .41927 .48454 .42223 .4766 .41843 .4814 Mtetra
.997 .855 .553 r
.41843 .4814 .42223 .4766 .42524 .4672 .42146 .47193 Mtetra
.998 .845 .549 r
.42146 .47193 .42524 .4672 .42824 .45748 .42449 .46215 Mtetra
.995 .868 .558 r
.42449 .46215 .42824 .45748 .43119 .44862 .42747 .45324 Mtetra
.962 .919 .572 r
.42747 .45324 .43119 .44862 .43407 .44164 .43036 .44621 Mtetra
.744 .904 .522 r
.43036 .44621 .43407 .44164 .43684 .43721 .43315 .44176 Mtetra
0 0 0 r
.43315 .44176 .43684 .43721 .43952 .43558 .43584 .44013 Mtetra
.274 0 0 r
.43584 .44013 .43952 .43558 .44213 .43653 .43845 .4411 Mtetra
.445 0 .085 r
.43845 .4411 .44213 .43653 .4447 .43941 .44101 .44402 Mtetra
.5 .053 .119 r
.44101 .44402 .4447 .43941 .44727 .44325 .44357 .44789 Mtetra
.486 .038 .111 r
.44357 .44789 .44727 .44325 .44987 .44686 .44617 .45155 Mtetra
.394 0 .054 r
.44617 .45155 .44987 .44686 .45253 .44911 .44882 .45382 Mtetra
.142 0 0 r
.44882 .45382 .45253 .44911 .45526 .44906 .45156 .45379 Mtetra
0 0 0 r
.45156 .45379 .45526 .44906 .45807 .44621 .45438 .45093 Mtetra
.857 .927 .54 r
.45438 .45093 .45807 .44621 .46093 .44057 .45726 .44526 Mtetra
.978 .898 .551 r
.45726 .44526 .46093 .44057 .46384 .43265 .46019 .43729 Mtetra
.996 .86 .539 r
.46019 .43729 .46384 .43265 .46675 .42339 .46313 .42797 Mtetra
.998 .853 .536 r
.46313 .42797 .46675 .42339 .46965 .41394 .46605 .41845 Mtetra
.99 .879 .546 r
.46605 .41845 .46965 .41394 .47252 .40544 .46895 .40991 Mtetra
.935 .925 .556 r
.46895 .40991 .47252 .40544 .47535 .39888 .4718 .40331 Mtetra
.651 .862 .481 r
.4718 .40331 .47535 .39888 .47815 .39488 .47461 .39929 Mtetra
0 0 0 r
.47461 .39929 .47815 .39488 .48094 .39364 .4774 .39805 Mtetra
.304 0 0 r
.4774 .39805 .48094 .39364 .48371 .39491 .48018 .39934 Mtetra
.452 0 .071 r
.48018 .39934 .48371 .39491 .4865 .398 .48297 .40247 Mtetra
.498 .042 .099 r
.48297 .40247 .4865 .398 .48931 .40193 .48578 .40643 Mtetra
.478 .021 .087 r
.48578 .40643 .48931 .40193 .49216 .40552 .48862 .41007 Mtetra
.378 0 .027 r
.48862 .41007 .49216 .40552 .49502 .40766 .49148 .41223 Mtetra
.117 0 0 r
.49148 .41223 .49502 .40766 .49791 .40746 .49438 .41204 Mtetra
0 0 0 r
.49438 .41204 .49791 .40746 .5008 .40446 .49727 .40904 Mtetra
.847 .919 .523 r
.49727 .40904 .5008 .40446 .50367 .39873 .50017 .40327 Mtetra
.97 .897 .533 r
.50017 .40327 .50367 .39873 .50653 .39082 .50304 .39531 Mtetra
.993 .863 .522 r
.50304 .39531 .50653 .39082 .50935 .38169 .50589 .38612 Mtetra
.994 .86 .521 r
.50589 .38612 .50935 .38169 .51216 .37247 .50873 .37685 Mtetra
.979 .887 .531 r
.50873 .37685 .51216 .37247 .51497 .36432 .51156 .36864 Mtetra
.896 .923 .535 r
.51156 .36864 .51497 .36432 .51779 .35816 .5144 .36244 Mtetra
0 0 0 r
.5144 .36244 .51779 .35816 .52065 .35457 .51727 .35884 Mtetra
.006 0 0 r
.51727 .35884 .52065 .35457 .52357 .35371 .5202 .35798 Mtetra
.327 0 0 r
.5202 .35798 .52357 .35371 .52655 .35528 .52318 .35958 Mtetra
.457 0 .054 r
.52318 .35958 .52655 .35528 .5296 .35858 .52622 .36292 Mtetra
.495 .029 .077 r
.52622 .36292 .5296 .35858 .53269 .36259 .52931 .36697 Mtetra
.469 .002 .062 r
.52931 .36697 .53269 .36259 .5358 .36616 .53242 .37058 Mtetra
.362 0 0 r
.53242 .37058 .5358 .36616 .5389 .36819 .53553 .37264 Mtetra
.093 0 0 r
.53553 .37264 .5389 .36819 .54195 .36783 .53858 .37229 Mtetra
0 0 0 r
.53858 .37229 .54195 .36783 .54493 .36468 .54157 .36913 Mtetra
.834 .909 .504 r
.54157 .36913 .54493 .36468 .54781 .35885 .54447 .36326 Mtetra
.96 .894 .512 r
.54447 .36326 .54781 .35885 .55062 .35093 .5473 .3553 Mtetra
.986 .865 .502 r
.5473 .3553 .55062 .35093 .55337 .34191 .55007 .34622 Mtetra
.55007 .34622 .55337 .34191 .5561 .33293 .55283 .33717 Mtetra
.962 .893 .512 r
.55283 .33717 .5561 .33293 .55886 .32509 .55561 .32929 Mtetra
.843 .912 .509 r
.55561 .32929 .55886 .32509 .5617 .31931 .55847 .32347 Mtetra
0 0 0 r
.55847 .32347 .5617 .31931 .56466 .31612 .56144 .32027 Mtetra
.068 0 0 r
.56144 .32027 .56466 .31612 .56775 .31562 .56454 .31978 Mtetra
.346 0 0 r
.56454 .31978 .56775 .31562 .57098 .31749 .56778 .32168 Mtetra
.46 0 .035 r
.56778 .32168 .57098 .31749 .57433 .32099 .57112 .32522 Mtetra
.49 .014 .053 r
.57112 .32522 .57433 .32099 .57774 .32509 .57453 .32936 Mtetra
.458 0 .035 r
.57453 .32936 .57774 .32509 .58115 .32863 .57794 .33295 Mtetra
.344 0 0 r
.57794 .33295 .58115 .32863 .5845 .33055 .5813 .33489 Mtetra
.07 0 0 r
.5813 .33489 .5845 .33055 .58773 .33003 .58454 .33438 Mtetra
0 0 0 r
.58454 .33438 .58773 .33003 .5908 .32672 .58762 .33106 Mtetra
.818 .897 .481 r
.58762 .33106 .5908 .32672 .5937 .32078 .59054 .32508 Mtetra
.947 .888 .488 r
.59054 .32508 .5937 .32078 .59646 .31285 .59332 .3171 Mtetra
.976 .865 .48 r
.59332 .3171 .59646 .31285 .59914 .30392 .59602 .30811 Mtetra
.974 .868 .481 r
.59602 .30811 .59914 .30392 .60181 .29514 .59871 .29928 Mtetra
.936 .893 .49 r
.59871 .29928 .60181 .29514 .60455 .28762 .60147 .2917 Mtetra
.776 .89 .478 r
.60147 .2917 .60455 .28762 .60744 .2822 .60438 .28625 Mtetra
0 0 0 r
.60438 .28625 .60744 .2822 .61053 .27938 .60749 .28343 Mtetra
.12 0 0 r
.60749 .28343 .61053 .27938 .61385 .27925 .61081 .2833 Mtetra
.361 0 0 r
.61081 .2833 .61385 .27925 .61738 .28141 .61435 .28549 Mtetra
.46 0 .014 r
.61435 .28549 .61738 .28141 .62107 .2851 .61804 .28923 Mtetra
.484 0 .026 r
.61804 .28923 .62107 .2851 .62484 .28929 .62181 .29346 Mtetra
.446 0 .006 r
.62181 .29346 .62484 .28929 .62859 .29281 .62557 .29703 Mtetra
.325 0 0 r
.62557 .29703 .62859 .29281 .63223 .29461 .62921 .29886 Mtetra
.048 0 0 r
.62921 .29886 .63223 .29461 .63565 .29393 .63264 .29818 Mtetra
0 0 0 r
.63264 .29818 .63565 .29393 .63882 .29046 .63583 .29469 Mtetra
.798 .882 .455 r
.63583 .29469 .63882 .29046 .64174 .28439 .63877 .2886 Mtetra
.929 .88 .46 r
.63877 .2886 .64174 .28439 .64446 .27643 .64151 .28058 Mtetra
.96 .862 .453 r
.64151 .28058 .64446 .27643 .64707 .26758 .64414 .27167 Mtetra
.954 .866 .455 r
.64414 .27167 .64707 .26758 .64969 .25899 .64678 .26303 Mtetra
.899 .888 .464 r
.64678 .26303 .64969 .25899 .65244 .25175 .64955 .25574 Mtetra
.697 .857 .443 r
.64955 .25574 .65244 .25175 .65542 .24668 .65254 .25064 Mtetra
0 0 0 r
.65254 .25064 .65542 .24668 .65869 .24424 .65583 .24819 Mtetra
.162 0 0 r
.65583 .24819 .65869 .24424 .66229 .24445 .65944 .24842 Mtetra
.372 0 0 r
.65944 .24842 .66229 .24445 .66617 .24691 .66333 .2509 Mtetra
.459 0 0 r
.66333 .2509 .66617 .24691 .67027 .2508 .66743 .25484 Mtetra
.475 0 0 r
.66743 .25484 .67027 .2508 .67445 .25507 .67162 .25916 Mtetra
.433 0 0 r
.67162 .25916 .67445 .25507 .67859 .25857 .67576 .26271 Mtetra
.306 0 0 r
.67576 .26271 .67859 .25857 .68253 .26026 .67971 .26442 Mtetra
.027 0 0 r
.67971 .26442 .68253 .26026 .68617 .25941 .68337 .26358 Mtetra
.898 .957 .619 r
.24623 .70185 .25073 .69652 .25361 .69119 .24913 .69649 Mtetra
.989 .884 .622 r
.24913 .69649 .25361 .69119 .25685 .683 .25239 .68825 Mtetra
.986 .823 .599 r
.25239 .68825 .25685 .683 .26033 .67277 .2559 .67796 Mtetra
.98 .801 .589 r
.2559 .67796 .26033 .67277 .2639 .66169 .2595 .66681 Mtetra
.983 .81 .593 r
.2595 .66681 .2639 .66169 .26739 .65106 .26303 .65611 Mtetra
.989 .853 .611 r
.26303 .65611 .26739 .65106 .27068 .64208 .26634 .64708 Mtetra
.966 .935 .635 r
.26634 .64708 .27068 .64208 .27365 .63565 .26933 .64061 Mtetra
.648 .879 .522 r
.26933 .64061 .27365 .63565 .27626 .63222 .27195 .63717 Mtetra
.066 0 0 r
.27195 .63717 .27626 .63222 .27852 .63175 .27422 .63671 Mtetra
.396 0 .102 r
.27422 .63671 .27852 .63175 .28051 .63372 .2762 .6387 Mtetra
.501 .081 .175 r
.2762 .6387 .28051 .63372 .28235 .63717 .27803 .64219 Mtetra
.515 .096 .184 r
.27803 .64219 .28235 .63717 .28417 .64089 .27984 .64595 Mtetra
.451 .026 .14 r
.27984 .64595 .28417 .64089 .28613 .6436 .28179 .64869 Mtetra
.238 0 0 r
.28179 .64869 .28613 .6436 .28834 .64418 .284 .64929 Mtetra
0 0 0 r
.284 .64929 .28834 .64418 .29088 .64189 .28655 .64699 Mtetra
.899 .955 .613 r
.28655 .64699 .29088 .64189 .29375 .6365 .28944 .64157 Mtetra
.99 .887 .613 r
.28944 .64157 .29375 .6365 .29692 .62838 .29